//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* @(#) 1.3 src/win/somx/somd/cpp/event/eventsvr.cpp, somx.somd, som2.1 9/21/94 16:58:47  [11/1/94 21:14:53] */
/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*
 *  This is a generic server which can use the shared server or persistent
 *  server activation policy.
 *
 */

#ifndef _ALL_SOURCE
#define _ALL_SOURCE
#endif

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <somd.xh>
#include <orb.xh>
#include <somoa.xh>
#include <implrep.xh>
#include <impldef.xh>
#include <intfacdf.xh>
#include <somdom.xh>

#include "cell.xh"
#include "eventcom.xh"
#include "eventch.xh"

void cleanup(Environment *, long);

DWORD WINAPI  request_loop_thread(LPVOID);
static HANDLE gThreadId = 0;
static BOOL   gShutdown = 0;

typedef struct _THREADPARMS  {
  HWND hwnd;
  Cell *cellObj;
  EventChannelAdmin_EventChannel *evchObj;
} THREADPARMS;

#define WM_SOMDSVR  (WM_USER+0)
#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)

long APIENTRY WndProc(HWND, UINT, UINT, LONG);
DWORD WINAPI eventsvrProcess(LPVOID);

#define MAX_ARGS 25
#define ARG_LENGTH 80

char **Argv = NULL;
long Argc = 1;
long ProcessInputArgs(LPSTR, long *Argc, char **Argv, long argSize);
int write_obj_ref(SOMDObject *objref, char *file);

char buffer[100] = "";
static char szAppName[] = "Eventsvr";

Environment ev;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    HWND hwnd;
    MSG nlsmsg;
    WNDCLASS wndclass;
    long i;

    somEnvironmentNew();

    if (!hPrevInstance) {
        wndclass.style = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon(hInstance, szAppName);
        wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
        wndclass.lpszMenuName = NULL;
        wndclass.lpszClassName = szAppName;
        RegisterClass(&wndclass);
    }

    hwnd = CreateWindow(szAppName, szAppName,
                        WS_OVERLAPPEDWINDOW | WS_MINIMIZE,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        NULL, NULL, hInstance, NULL);

    ShowWindow(hwnd, SW_SHOW);


    Argv = (char **) malloc(sizeof(char *) * MAX_ARGS);
    for (i = 0; i < MAX_ARGS; ++i)
        Argv[i] = (char *) calloc(ARG_LENGTH, sizeof(char *));

    ProcessInputArgs(lpszCmdLine, &Argc, Argv, MAX_ARGS);

    /* Start the server with Windows user message */
    PostMessage(hwnd, WM_SOMDSVR, 0, 0);

    /* Windows message loop */
    while (GetMessage(&nlsmsg, NULL, 0, 0)) {
        TranslateMessage(&nlsmsg);
        DispatchMessage(&nlsmsg);
    }

    return nlsmsg.wParam;

}                                      /* end main */

long APIENTRY WndProc(HWND hwnd, UINT message, UINT wParam,
                      LONG lParam)
{
    switch (message) {
        case WM_SOMDSVR:
            eventsvrProcess((LPVOID)hwnd);
            return 0;

        case WM_DESTROY:
            gShutdown = TRUE;
            if (gThreadId)  {
              Sleep(0);
            }
            cleanup(0,0);
            PostQuitMessage(0);
            return 0;
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}


DWORD WINAPI
eventsvrProcess(LPVOID params)
{
    HWND hwnd = (HWND)(params);
    int rc;
    char *alias;
    char buf[75] = "DSOM Server - ";
    static THREADPARMS threadps;
    static Cell *cellObj;
    static SOMDObject *cellObj_proxy;
    static SOMDObject *evchObj_proxy;
    static EventChannelAdmin_EventChannel *evchObj;
    static EventChannelAdmin_SupplierAdmin *supp_admin;
    static EventComm_EventConnection *evcon_if;
    static EventComm_Consumer *cons_if;

    /* initialization */
    SOM_InitEnvironment(&ev);
    SOMD_Init(&ev);
    SOMD_SOMOAObject = new SOMOA;

    /* Parse arguments */
    switch (Argc) {

        case 2:

            /* alias passed  */
            alias = Argv[1];
            strcat(buf, alias);
            SetWindowText(hwnd, buf);
            /* get ImplementationDef from input alias */
            SOMD_ImplDefObject = SOMD_ImplRepObject->find_impldef_by_alias(&ev, alias);
            if ((SOMD_ImplDefObject == NULL) || checkEv(&ev)) {
                wsprintf(buffer, "find_impldef_by_alias failed, exception = %s",
                         (LPSTR) somExceptionId(&ev));
                MessageBox(hwnd, buffer, "TstServer", MB_ICONSTOP);
                cleanup(&ev,1);
            }
            break;


        default:
            MessageBox(hwnd, "Invalid number of arguments", "TstServer",
                       MB_ICONSTOP);
            cleanup(&ev,1);
            break;

    }                                  /* switch */

    EventComm_EventConnectionNewClass(0, 0);

    if ((SOMD_ImplDefObject == NULL) || (SOMD_ORBObject == NULL)) {
        MessageBox(hwnd, "Initialization Failed", "TstServer", MB_ICONSTOP);
        cleanup(&ev,1);
    }

    /* implementation now ready to process requests */
    SOMD_SOMOAObject->impl_is_ready(&ev, SOMD_ImplDefObject);
    if (checkEv(&ev)) {
        sprintf("impl_is_ready failed, exception = %s\n",
                (LPSTR) somExceptionId(&ev));
        MessageBox(hwnd, buffer, "TstServer", MB_ICONSTOP);
        cleanup(&ev,1);
    }

    /* Create the cell object  */
    cellObj = new Cell;

    /* Create a DSOM object reference for the cellObj  */
    cellObj_proxy = SOMD_SOMOAObject->create_SOM_ref(&ev, cellObj, SOMD_ImplDefObject);

    /* Create EventChannel object  */
    evchObj = new EventChannelAdmin_EventChannel;

    /* Create a DSOM object reference for evch  */
    evchObj_proxy = SOMD_SOMOAObject->create_SOM_ref(&ev, evchObj, SOMD_ImplDefObject);

    /*
     * Get a supplier admin obj and add a push style supplier onto the event
     * channel using this admin interface. Returns a consumer interface which
     * will be used by the supplier
     */
    supp_admin = evchObj->for_suppliers(&ev);
    evcon_if = new EventComm_EventConnection;
    cons_if = supp_admin->add_push_supplier(&ev, evcon_if);

    /* let the cell object know what the consumer_if is */
    cellObj->setConsumerIf(&ev, cons_if);
 
    /* Write out the string representations of the object references */
    rc = write_obj_ref(cellObj_proxy, "cell.rep");
    if (rc) {
        SOMD_ImplDefObject->somFree;
        cellObj->somFree;
        evchObj->somFree;
        cleanup(&ev,1);
    }
    rc = write_obj_ref(evchObj_proxy, "event.rep");
    if (rc) {
        SOMD_ImplDefObject->somFree;
        cellObj->somFree;
        evchObj->somFree;
        cleanup(&ev,1);
    }

    /*
    **  kick off a thread to process the messages so control can
    **  can go back top our message loop
    */
    threadps.hwnd = hwnd;
    threadps.cellObj = cellObj;
    threadps.evchObj = evchObj;

    if ((gThreadId = CreateThread(NULL, /* security descriptor */
                                  0L, /* stack size - 0 means use default */
                                  request_loop_thread, /* thread function */
                                  (LPVOID)&threadps, /* function parameters */
                                  0, /* startup flags */
                                  (LPDWORD)&gThreadId)) == NULL) {
       MessageBox(hwnd, "could_not_start_thread\n", "EventServer", MB_ICONSTOP);
       cleanup(&ev, 1);
    }

    return 0;
}

long ProcessInputArgs(LPSTR lpszCmdLine, long *Argc, char **Argv, long
                       argSize)
{

    char *c;
    long i;

    *Argc = 1;                         /* lpszCmdLine does not argv[0] */

    /* lpszCmdLine has command line arguments delimited by blanks */

    c = strtok((char *) lpszCmdLine, " ");

    for (i = 0; i < argSize; ++i) {
        if (c == NULL)
            break;
        strcpy((char *) Argv[*Argc], (char *) c);
        c = strtok(NULL, " ");
        *Argc += 1;
    }
    return *Argc;
}


/*
 *  Frees local and global DSOM objects.
 */

void cleanup(Environment * ev, long rc)
{
  Environment  lev;
  Environment *pev = &lev;

  if (!ev)
    SOM_InitEnvironment(pev);
  else
    pev = ev;

  if (SOMD_SOMOAObject && SOMD_ImplDefObject)
     SOMD_SOMOAObject->deactivate_impl(pev, SOMD_ImplDefObject);

  SOMD_Uninit(pev);
  SOM_UninitEnvironment(pev);
  somEnvironmentEnd();

  if (ev) exit((int)rc);
}


int write_obj_ref(SOMDObject *objref, char *file)
{
    FILE *fd;
    char *objRefStr;

    objRefStr = (char *)(SOMD_ORBObject->object_to_string(&ev, objref));

    if ((fd = fopen(file, "w")) == (FILE *) NULL) {
        sprintf(buffer, "Unable to create file %s, errno %d\n",
                (LPSTR) file, errno);
        MessageBox((HWND) NULL, buffer, "TstServer", MB_ICONSTOP);
        return -1;
    }

    fwrite((void *) objRefStr, sizeof(char), strlen(objRefStr), fd);

    ORBfree(objRefStr);
    fclose(fd);
    return (0);
}

/*
** thread for the request loop.
*/

DWORD WINAPI
request_loop_thread(LPVOID params)
{
  THREADPARMS  *tparams = (THREADPARMS *)params;
  HWND         hwnd = tparams->hwnd;
  Environment  ev;
  char         lbuffer[64];

  SOM_InitEnvironment(&ev);

  while (gShutdown == 0) {
    /* process requests until deactivation */
    (void) SOMD_SOMOAObject->execute_request_loop(&ev, SOMD_WAIT);
    if (checkEv(&ev)) {
        wsprintf(lbuffer, "execute_request_loop failed, exception = %s",
                 (LPSTR) somExceptionId(&ev));
        MessageBox(hwnd, lbuffer, "EventServer", MB_ICONSTOP);
        cleanup(&ev,1);
    }
  }

  tparams->cellObj->somFree;
  tparams->evchObj->somFree;

  SOM_UninitEnvironment(&ev);

  return(0L);
  
}

