//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* @(#) 1.2 src/win/somx/somd/cpp/event/cell.cpp, somx.somd, som2.1 9/21/94 16:58:19  [11/1/94 21:14:58] */
/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#define Cell_Class_Source
#define M_Cell_Class_Source

#include <stdio.h>

#include <somd.xh>
#include "cell.xih"

/*
 *Method from the IDL attribute statement:
 *"attribute long val"
 */

SOM_Scope void  SOMLINK _set_val(Cell *somSelf,  Environment *ev, long value)
{
    CellData *somThis = CellGetData(somSelf);
    CellMethodDebug("Cell","_set_val");

    somThis->val = value;
    somSelf->notifyEventCh(ev);
}

SOM_Scope void  SOMLINK notifyEventCh(Cell *somSelf,  Environment *ev)
{
    CellData *somThis = CellGetData(somSelf);
    any event_msg;
    static long current_value;

    CellMethodDebug("Cell","notifyServers");

    current_value = somSelf->_get_val(ev);
    event_msg._type = TC_long;
    event_msg._value = (void *)&current_value;

    somThis->cons_if->push(ev, &event_msg);
}

SOM_Scope void  SOMLINK setConsumerIf(Cell *somSelf,  Environment *ev, EventComm_Consumer *consumer_if)
{
    CellData *somThis = CellGetData(somSelf);
    CellMethodDebug("Cell","setConsumerIf");

    somThis->cons_if = consumer_if;

}


