//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* @(#) 1.9 src/win/somx/somd/cpp/dii/diitest.cpp, somx.somd, som2.1 9/21/94 16:57:55  [11/1/94 21:02:55] */
/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*----------------------------------------
   DIITEST.C -- DSOM Sample Program
  ----------------------------------------*/
/*
 *  "diitest" is a sample program demonstrating the DSOM Dynamic
 *  Invocation Interface.
 */

#include <windows.h>
#include <somd.xh>
#include <request.xh>
#include <nvlist.xh>
#include <repostry.xh>
#include <operatdf.xh>
#include "foo.xh"

#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)

void printEv(Environment *ev);
void makeNVList(Environment *, char *, NVList **, NamedValue *);
void setNVListValue(Environment *, NVList *, long, void *, long);

long APIENTRY WndProc (HWND, UINT, UINT, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName[] = "Diitest" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     somEnvironmentNew(); 

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "Dynamic Invocation Interface Sample",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long APIENTRY WndProc (HWND hwnd, UINT message, UINT wParam,
                       LONG lParam)
     {
     static int   cxChar, cyChar ;
     HDC          hdc ;
     PAINTSTRUCT  ps ;
     TEXTMETRIC   tm ;
     char buffer[100];
     short startChar;
     static short winHeight, winWidth;

     static SOMDObject *fooObj;
     static Environment *ev;
     NVList *arglist;
     static NamedValue result;
     Request *reqObj;

     static string   arg1 = NULL;       /* ARG_OUT */
     static long     arg2 = 999;        /* ARG_INOUT */
     ReferenceData   arg3;              /* ARG_IN */

     switch (message)
          {
          case WM_CREATE:

                /* local and DSOM initialization */
                ev = SOM_CreateLocalEnvironment();
                SOMD_Init(ev);

                /* make sure classes are registered with SOMClassMgr */
                FooNewClass(0,0);

                /* create a remote object */
                fooObj = (SOMDObject *)
                            (SOMD_ObjectMgr->somdNewObject(ev, "Foo", NULL));
                if (checkEv(ev)) goto error;

                /* create an NVList for the operation */
                makeNVList(ev, "Foo::method1", &arglist, &result);
                if (checkEv(ev)) goto error;

                /* add parameters to the NVList */
                setNVListValue(ev, arglist, 0, (void *)&arg1, 0);
                if (checkEv(ev)) goto error;
                setNVListValue(ev, arglist, 1, (void *)&arg2, sizeof(arg2));
                if (checkEv(ev)) goto error;
                arg3._maximum = 1024;
		arg3._length  = 0;
		arg3._buffer  = NULL;
                setNVListValue(ev, arglist, 2, (void *)&arg3, 0);
                if (checkEv(ev)) goto error;

                /* create a request for the operation */
                (void) fooObj->create_request(ev,
                        (Context *)NULL, "method1", arglist,
                        &result, &reqObj, (Flags)0);
                if (checkEv(ev)) goto error;

                /* invoke request on object */
                (void) reqObj->invoke(ev, (Flags)0);
                if (checkEv(ev)) goto error;

                return 0 ;

        error:
                printEv(ev);
                SendMessage(hwnd, WM_CLOSE, 0, 0L);
                return 0;

          case WM_SIZE:
                winHeight = HIWORD (lParam);
                winWidth = LOWORD (lParam);
                return 0;

          case WM_PAINT:
                hdc = BeginPaint (hwnd, &ps) ;
                SelectObject (hdc, GetStockObject (SYSTEM_FIXED_FONT)) ;
                GetTextMetrics (hdc, &tm) ;
                cxChar = tm.tmAveCharWidth;
                cyChar = tm.tmHeight + tm.tmExternalLeading;

                /* print result and out parameters */
                wsprintf(buffer, "Invoked method1 on a remote instance of Foo class.");
                startChar = ((winWidth/cxChar)-strlen(buffer))/2*cxChar;
                TextOut (hdc, startChar, (winHeight/2)-(6*cyChar),
                        (LPSTR)buffer, strlen(buffer));
                wsprintf(buffer, "The result is: %s",
                        (LPSTR) *(string*) (result.argument._value));
                startChar = ((winWidth/cxChar)-strlen(buffer))/2*cxChar;
                TextOut (hdc, startChar, (winHeight/2)-(4*cyChar),
                        (LPSTR)buffer, strlen(buffer));
                wsprintf(buffer, "The value of arg1 is: %s", (LPSTR) arg1);
                TextOut (hdc, startChar, (winHeight/2)-(2*cyChar),
                                        (LPSTR)buffer, strlen(buffer));
                wsprintf(buffer, "The value of arg2 is: %d", arg2);
                TextOut (hdc, startChar, winHeight/2,
                                        (LPSTR)buffer, strlen(buffer));
                EndPaint (hwnd, &ps) ;
                return 0 ;

          case WM_DESTROY:

                /* destroy local proxy object and remote object */
                if (fooObj)
                    SOMD_ObjectMgr->somdDestroyObject(ev, fooObj);

                /* DSOM uninitialization: */
                SOMD_Uninit(ev);
                SOM_DestroyLocalEnvironment(ev);

                PostQuitMessage (0) ;
                return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

/*
 *  Prints exception information.
 */

void printEv(Environment *ev)
{
  char *exId, *bp;
  char buffer[200];
  StExcep *params;

  exId = somExceptionId(ev);
  if (!exId) exId = "None";
  params = (StExcep *) somExceptionValue(ev);
  bp = buffer;

  wsprintf(bp, "Error Occurred \nexception string: %s\n", (LPSTR) exId);
  bp += strlen(bp);
  wsprintf(bp, "minor error code: %u\n", (params ? params->minor : 0));
  bp += strlen(bp);
  wsprintf(bp, " completion code: %s\n",
                (LPSTR) (params ? (params->completed == YES ? "YES" :
                params->completed == NO ? "NO": "MAYBE") : "YES"));
  MessageBox ((HWND)NULL, buffer, (LPSTR) "Exception",
                MB_ICONEXCLAMATION | MB_OK);
  somdExceptionFree(ev);
  return;
}

/*
 *  Sets the result type and allocates an NVList for the operation.
 */

void makeNVList(Environment *ev, char *methodid, NVList **arglist,
                NamedValue *result)
{

    Repository *repos;
    OperationDef *opdef;
    Description desc;
    OperationDescription *opdesc;

    /* get the OperationDef object from the Interface Repository */
    repos = new Repository;
    opdef = (OperationDef *) repos->lookup_id(ev, methodid);
    if (ev->_major == NO_EXCEPTION) {

      /* get the operation description structure */

      desc = opdef->describe(ev);
      /* desc = _SOM1ARGSTRUCTMETHOD (opdef,describe,ev);*/

      if (ev->_major == NO_EXCEPTION) {
        opdesc = (OperationDescription *) desc.value._value;

        /* fill in the TypeCode field for result */
        result->argument._type = opdesc->result;

        /* create a NamedValue list for the operation */
        (void) SOMD_ORBObject->create_operation_list(ev, opdef, arglist);
      }
    }
    return;
}

/*
 *  Adds parameters to the NVList.
 */

void setNVListValue(Environment *ev, NVList *arglist, long pos, void *value,
                    long valsz)
{
    Identifier name;
    TypeCode tc;
    void *dummy;
    long dummylen;
    Flags flags;

    /* get initialized fields of item first */
    (void) arglist->get_item(ev, pos, &name, &tc, &dummy, &dummylen, &flags);
    if (ev->_major == NO_EXCEPTION) {

      /*
       * IMPORTANT NOTE:
       * For scalar types, use the pointer to the variable.
       * For arguments represented by structures (including "union", "sequence",
       *     and "any"), use a pointer to the structure.
       * For arguments represented by pointers (incl. strings, arrays, and
       *     objrefs), use a pointer to the pointer.
       */

      /* reset the value and length fields of the item */
      (void) arglist->set_item(ev, pos, name, tc, value, valsz, flags);
    }
    return;
}
