//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* @(#) 1.11 src/win/somx/somd/cpp/animal/testsvr.cpp, somx.somd, som2.1 9/21/94 16:57:48  [11/1/94 21:02:54] */
/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*
 *  This is a generic server which can use the shared server or persistent
 *  server activation policy.  It can also be threaded or non-threaded.
 *
 *  Syntax:  testsvr <implid> | -a <alias>
 */


#ifndef _ALL_SOURCE
#define _ALL_SOURCE
#endif

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <somd.xh>
#include <somoa.xh>
#include <implrep.xh>


#define WM_SOMDSVR  (WM_USER+0)
#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)
#define MAX_ARGS 25
#define ARG_LENGTH 80

long APIENTRY WndProc(HWND, UINT, UINT, LONG);
long          ProcessInputArgs(LPSTR, long *, char **, long);
long          testsvrProcess(HWND);
void          cleanup(Environment *, long);

DWORD WINAPI  request_loop_thread(LPVOID);
static HANDLE gThreadId;
static BOOL   gShutdown;

char **Argv = NULL;
long Argc = 1;
char buffer[100] = "";
static char szAppName[] = "Testsvr";


Environment ev = {(enum exception_type) 0, NULL, NULL, NULL};

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    HWND hwnd;
    MSG nlsmsg;
    WNDCLASS wndclass;
    long i;

    somEnvironmentNew();

    if (!hPrevInstance) {
        wndclass.style = CS_HREDRAW | CS_VREDRAW;
        wndclass.lpfnWndProc = WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon(hInstance, szAppName);
        wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
        wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
        wndclass.lpszMenuName = NULL;
        wndclass.lpszClassName = szAppName;
        RegisterClass(&wndclass);
    }

    hwnd = CreateWindow(szAppName, szAppName,
                        WS_OVERLAPPEDWINDOW | WS_MINIMIZE,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        CW_USEDEFAULT, CW_USEDEFAULT,
                        NULL, NULL, hInstance, NULL);

    ShowWindow(hwnd, SW_SHOW);


    Argv = (char **) malloc(sizeof(char *) * MAX_ARGS);
    for (i = 0; i < MAX_ARGS; ++i)
        Argv[i] = (char *) calloc(ARG_LENGTH, sizeof(char *));

    ProcessInputArgs(lpszCmdLine, &Argc, Argv, MAX_ARGS);

    /* Start the server with Windows user message */
    PostMessage(hwnd, WM_SOMDSVR, 0, 0);

    /* Windows message loop */
    while (GetMessage(&nlsmsg, NULL, 0, 0)) {
        TranslateMessage(&nlsmsg);
        DispatchMessage(&nlsmsg);
    }

    return nlsmsg.wParam;

}                                      /* end main */

long APIENTRY WndProc(HWND hwnd, UINT message, UINT wParam,
                      LONG lParam)
{
    switch (message) {
        case WM_SOMDSVR:
            testsvrProcess(hwnd);
            return 0;

        case WM_DESTROY:
            gShutdown = TRUE;
            if (gThreadId)
              Sleep(0);
            cleanup(0,0);
            PostQuitMessage(0);
            return 0;
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}


long testsvrProcess(HWND hwnd)
{
    ImplId implid;
    Environment ev;
    char *alias;
    char buf[75] = "DSOM Server - ";

    /* initialization */
    SOM_InitEnvironment(&ev);
    SOMD_Init(&ev);
    SOMD_SOMOAObject = (SOMOA *) new SOMOA;

    /* Parse arguments */
    switch (Argc) {

        case 2:
            implid = Argv[1];
            /* get ImplementationDef from Implementation Repository */
            SOMD_ImplDefObject = SOMD_ImplRepObject->find_impldef(&ev, implid);
            if ((SOMD_ImplDefObject == NULL) || checkEv(&ev)) {
                wsprintf(buffer, "find_impldef failed, exception = %s",
                         (LPSTR) somExceptionId(&ev));
                MessageBox(hwnd, buffer, "TstServer", MB_ICONSTOP);
                cleanup(&ev,1);
            }
            alias = SOMD_ImplDefObject->_get_impl_alias(&ev);
            strcat(buf, alias);
            SetWindowText(hwnd, buf);
            break;

        case 3:
            /* alias passed  (possibly) */
            /* check for a valid option */
            if ((Argv[1][0] == '-') &&
                ((Argv[1][1] == 'a') || (Argv[1][1] == 'A'))) {
                alias = Argv[2];
                strcat(buf, alias);
                SetWindowText(hwnd, buf);
                /* get ImplementationDef from input alias */
                SOMD_ImplDefObject =
                    SOMD_ImplRepObject->find_impldef_by_alias(&ev, alias);
                if ((SOMD_ImplDefObject == NULL) || checkEv(&ev)) {
                    wsprintf(buffer, "find_impldef_by_alias failed, exception = %s",
                             (LPSTR) somExceptionId(&ev));
                    MessageBox(hwnd, buffer, "TstServer", MB_ICONSTOP);
                    cleanup(&ev,1);
                }
            }
            else {
                MessageBox(hwnd, "Invalid arguments", "TstServer", MB_ICONSTOP);
                cleanup(&ev,1);
            }
            break;


        default:
            MessageBox(hwnd, "Invalid number of arguments", "TstServer",
                       MB_ICONSTOP);
            cleanup(&ev,1);
            break;

    }                                  /* switch */

    /* implementation now ready to process requests */
    SOMD_SOMOAObject->impl_is_ready(&ev, SOMD_ImplDefObject);
    if (checkEv(&ev)) {
        wsprintf("impl_is_ready failed, exception = %s\n",
                 (LPSTR) somExceptionId(&ev));
        MessageBox(hwnd, buffer, "TstServer", MB_ICONSTOP);
        cleanup(&ev,1);
    }

    /*
    **  kick off a thread to process the messages so control can
    **  can go back top our message loop
    */
    if ((gThreadId = CreateThread(NULL, /* security descriptor */
                                  0L, /* stack size - 0 means use default */
                                  request_loop_thread, /* thread function */
                                  (LPVOID)hwnd, /* function parameters */
                                  0, /* startup flags */
                                  (LPDWORD)&gThreadId)) == NULL) {
       MessageBox(hwnd, "could_not_start_thread\n", "TstServer", MB_ICONSTOP);
       cleanup(&ev, 1);
    }

    SOM_UninitEnvironment(&ev);
    return 0;
}

long ProcessInputArgs(LPSTR lpszCmdLine, long *Argc, char **Argv, long
                       argSize)
{

    char *c;
    long i;

    *Argc = 1;                         /* lpszCmdLine does not argv[0] */

    /* lpszCmdLine has command line arguments delimited by blanks */

    c = strtok((char *) lpszCmdLine, " ");

    for (i = 0; i < argSize; ++i) {
        if (c == NULL)
            break;
        strcpy((char *) Argv[*Argc], (char *) c);
        c = strtok(NULL, " ");
        *Argc += 1;
    }
    return *Argc;
}


/*
 *  Frees local and global DSOM objects.
 */

void cleanup(Environment * ev, long rc)
{
  Environment  lev;
  Environment *pev = &lev;

  if (!ev)
    SOM_InitEnvironment(pev);
  else
    pev = ev;

  if (SOMD_SOMOAObject && SOMD_ImplDefObject)
     SOMD_SOMOAObject->deactivate_impl(pev, SOMD_ImplDefObject);

  SOMD_Uninit(pev);
  SOM_UninitEnvironment(pev);
  somEnvironmentEnd();

  if (ev) exit((int)rc);
}


/*
** thread for the request loop.
*/

DWORD WINAPI
request_loop_thread(LPVOID params)
{
  HANDLE       hwnd = (HANDLE)params;
  Environment  ev;
  char         lbuffer[64];

  SOM_InitEnvironment(&ev);

  while (!gShutdown) {
    /* process requests until deactivation */
    (void) SOMD_SOMOAObject->execute_request_loop(&ev, SOMD_WAIT);
    if (checkEv(&ev)) {
        wsprintf(lbuffer, "execute_request_loop failed, exception = %s",
                 (LPSTR) somExceptionId(&ev));
        MessageBox(hwnd, lbuffer, "TstServer", MB_ICONSTOP);
        cleanup(&ev,1);
    }
  }

  SOM_UninitEnvironment(&ev);

  return(0L);
  
}
