//
//   COMPONENT_NAME: somx
//
//   ORIGINS: 27
//
//
//   10H9767, 10H9769  (C) COPYRIGHT International Business Machines Corp. 1992,1994
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//

/* @(#) 1.9 src/win/somx/somd/cpp/animal/anitest.cpp, somx.somd, som2.1 10/5/94 14:06:08  [11/1/94 21:02:50] */

/*
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */

/*----------------------------------------
   ANISAMP.C -- SOM Sample Program
  ----------------------------------------*/

#include <windows.h>
#include <somd.xh>	
#include "danimal.xh"
#include "dldog.xh"
#include "dbdog.xh"
#include "dloc.xh"

struct
     {
     long style ;
     char *text ;
     }
     button[] =
     {
     BS_PUSHBUTTON,      "Pooh",
     BS_PUSHBUTTON,      "Snoopy",
     BS_PUSHBUTTON,      "Lassie",
     } ;

#define NUM (sizeof button / sizeof button [0])
#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)


void printEv(Environment *ev);

long APIENTRY WndProc (HWND, UINT, UINT, LONG);

int APIENTRY WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                      LPSTR lpszCmdLine, int nCmdShow)
     {
     static char szAppName[] = "DAnisamp" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     somEnvironmentNew(); 

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = NULL ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hwnd = CreateWindow (szAppName, "Distributed Animals Sample",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

long APIENTRY WndProc (HWND hwnd, UINT message, UINT wParam,
                       LONG lParam)
     {
     static char  szTop []    = "PRESS A BUTTON TO SEE ABOUT AN ANIMAL";
     static HWND  hwndButton [NUM] ;
     static int   buttonx [NUM] = {  5, 20, 35 };
     static int   buttony [NUM] = {  8, 8, 8};
     static RECT  NEAR  rect ;
     static int   cxChar, cyChar ;
     HDC          hdc ;
     HCURSOR      hCursor;
     PAINTSTRUCT  ps ;
     int          i ;
     TEXTMETRIC   tm ;
     static dAnimal     *Pooh = (dAnimal *) NULL;
     static dLittleDog  *Snoopy = (dLittleDog *) NULL;
     static dBigDog     *Lassie = (dBigDog *) NULL;
     static dLocation   *locPooh = (dLocation *) NULL;
     static dLocation   *locSnoopy = (dLocation*) NULL;
     static dLocation   *locLassie = (dLocation *) NULL;
     static Environment *ev;
     string buffer;

     switch (message)
          {
          case WM_CREATE:

                /* local and DSOM initialization */
                ev = SOM_CreateLocalEnvironment();
                SOMD_Init(ev);
                Pooh = (dAnimal *) NULL;
                Snoopy = (dLittleDog *) NULL;
                Lassie = (dBigDog *) NULL;
                locPooh = (dLocation *) NULL;
                locSnoopy = (dLocation *) NULL;
                locLassie = (dLocation *) NULL;

                /* Make sure classes are registered with SOMClassMgr: */
                dAnimalNewClass(0,0);
                dLittleDogNewClass(0,0);
                dBigDogNewClass(0,0);
                dLocationNewClass(0,0);

               /* create remote animal object */
               Pooh = (dAnimal *) SOMD_ObjectMgr->somdNewObject(ev,
                                                        "dAnimal", NULL);
               if (checkEv(ev)) goto error;

               /* save pointers to dLocation object */
               locPooh = Pooh->_get_loc(ev);
               if (checkEv(ev)) goto error;

               Snoopy = (dLittleDog *) SOMD_ObjectMgr->somdNewObject(ev,
                                                        "dLittleDog", NULL);
               if (checkEv(ev)) goto error;

               locSnoopy = Snoopy->_get_loc(ev);
               if (checkEv(ev)) goto error;

               Lassie = (dBigDog *)SOMD_ObjectMgr->somdNewObject(ev,
                                                        "dBigDog", NULL);
               if (checkEv(ev)) goto error;

               locLassie = Lassie->_get_loc(ev);
               if (checkEv(ev)) goto error;

                /* set instance data for animal objects */
                Pooh->_set_name(ev, "Winnie the Pooh");
                if (checkEv(ev)) goto error;
                Pooh->_set_type(ev, "Storybook Bear");
                if (checkEv(ev)) goto error;
                Pooh->_set_food(ev, "honey");
                if (checkEv(ev)) goto error;
                locPooh->_set_city(ev, "Austin");
                if (checkEv(ev)) goto error;
                locPooh->_set_state(ev, "TX");
                if (checkEv(ev)) goto error;

                Snoopy->_set_name(ev, "Snoopy");
                if (checkEv(ev)) goto error;
                Snoopy->_set_type(ev, "Cartoon Beagle");
                if (checkEv(ev)) goto error;
                Snoopy->_set_food(ev, "cookies");
                if (checkEv(ev)) goto error;
                locSnoopy->_set_city(ev, "Dublin");
                if (checkEv(ev)) goto error;
                locSnoopy->_set_state(ev, "OH");
                if (checkEv(ev)) goto error;
                Snoopy->_set_trick(ev, "dancing");
                if (checkEv(ev)) goto error;
                Snoopy->_set_LDweight(ev, 320.47);
                if (checkEv(ev)) goto error;

                Lassie->_set_name(ev, "Lassie");
                if (checkEv(ev)) goto error;
                Lassie->_set_type(ev, "TV Collie");
                if (checkEv(ev)) goto error;
                Lassie->_set_food(ev, "steak");
                if (checkEv(ev)) goto error;
                locLassie->_set_city(ev, "Hollywood");
                if (checkEv(ev)) goto error;
                locLassie->_set_state(ev, "CA");
                if (checkEv(ev)) goto error;
                Lassie->_set_trick(ev, "saving lives");
                if (checkEv(ev)) goto error;
                Lassie->_set_BDweight(ev, 42.38);
                if (checkEv(ev)) goto error;

               /* Display one button per animal: */
               hdc = GetDC (hwnd) ;
               GetTextMetrics (hdc, &tm) ;
               cxChar = tm.tmAveCharWidth ;
               cyChar = tm.tmHeight + tm.tmExternalLeading ;
               ReleaseDC (hwnd, hdc) ;
               for (i = 0 ; i < NUM ; i++)
                 hwndButton [i] =
                     CreateWindow ("button",
                                   button[i].text,
                                   WS_CHILD | WS_VISIBLE | button[i].style,
                                   buttonx[i] * cxChar,
                                   cyChar * buttony[i],
                                   10 * cxChar,
                                   7 * cyChar / 4,
                                   hwnd,
                                   (HMENU)i,
                                   (HINSTANCE)((LPCREATESTRUCT)lParam)->hInstance,
                                   0);
               return 0 ;

                error:
                   printEv(ev);
                   SendMessage(hwnd, WM_CLOSE, 0, 0L);
                   return 0;

          case WM_SIZE:
               rect.left   =  5 * cxChar ;
               rect.top    =  2 * cyChar ;
               rect.right  = LOWORD (lParam) ;
               rect.bottom = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
               InvalidateRect (hwnd, &rect, TRUE) ;
               hdc = BeginPaint (hwnd, &ps) ;
               TextOut (hdc, 6 * cxChar, 3 * cyChar, szTop, sizeof szTop - 1);
               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_COMMAND:
          case WM_DRAWITEM:
               hCursor = SetCursor (LoadCursor (NULL, IDC_WAIT));
               ShowCursor (TRUE);

               /* Produce a pop-up window for the animal: */
                switch (wParam)
                        {
                        case 0:
                          buffer = Pooh->display (ev);
                          break;
                        case 1:
                          buffer = Snoopy->display (ev);
                          break;
                        case 2:
                          buffer = Lassie->display (ev);
                          break;
                        }
              ShowCursor (FALSE);
              SetCursor (hCursor);
              if (ev->_major == NO_EXCEPTION) {
                  MessageBox (hwnd, buffer, button[wParam].text, MB_OK);
               }
	       InvalidateRect(hwnd,NULL,TRUE);
               return 0 ;

          case WM_DESTROY:
                /* destroy local proxy objects and remote animal objects */
                if (locPooh)
                   ((SOMDClientProxy *)locPooh)->somdProxyFree(ev);
                if (Pooh)
                   SOMD_ObjectMgr->somdDestroyObject(ev, Pooh);
                if (locSnoopy)
                   ((SOMDClientProxy *)locSnoopy)->somdProxyFree(ev);
                if (Snoopy)
                   SOMD_ObjectMgr->somdDestroyObject(ev, Snoopy);
                if (locLassie)
                   ((SOMDClientProxy *)locLassie)->somdProxyFree(ev);
                if (Lassie)
                   SOMD_ObjectMgr->somdDestroyObject(ev, Lassie);
                SOMD_Uninit(ev);
                SOM_DestroyLocalEnvironment(ev);
                PostQuitMessage (0) ;
                return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }

/*
 *  Prints exception information.
 */

void printEv(Environment *ev)
{
  char *exId, *bp;
  char buffer[200];
  StExcep *params;

  exId = somExceptionId(ev);
  if (!exId) exId = "None";
  params = (StExcep *) somExceptionValue(ev);
  bp = buffer;

  wsprintf(bp, "Error Occurred \nexception string: %s\n", (LPSTR) exId);
  bp += strlen(bp);
  wsprintf(bp, "minor error code: %u\n", (params ? params->minor : 0));
  bp += strlen(bp);
  wsprintf(bp, " completion code: %s\n",
                (LPSTR) (params ? (params->completed == YES ? "YES" :
                params->completed == NO ? "NO": "MAYBE") : "YES"));
  MessageBox ((HWND)NULL, buffer, (LPSTR) "Exception",
                                MB_ICONEXCLAMATION | MB_OK);
  somdExceptionFree(ev);
  return;
}
