/*
	File:		odvideo.cpp

	Contains:	Source code for the sample multimedia part

	Written by:	Brad Nicholes and Don Griffes

	Copyright:	c 1995 by Novell, Inc., all rights reserved.


	Notes:	This part was created using button part as a starting point.
				I took button part, removed the button and added in the clipping
				(well Brad did most of that) then put in the MCI commands to get
				the video going.  It took all of about 3 hours to have a video up
				and going with the clipping working correctly.  Since then I've
				added more features to make it somewhat better for demoing such as
				repeat playing and buttons.  Also I found some interesting quirks
				will mci and Video for Windows and tried some work arounds for them.
				This is not a completed work but is working.  Have fun.

	Change History (windows) (most recent first):

		8Mar95		SOMized (Jeff Hanson) 
		23Jan95		RAM		Made part able to be used as root part

	To Do:
*/

#define ModVideoPart_VideoPart_Class_Source

#ifndef _ALTPOINT_
#include "AltPoint.h"			// Use C++ savvy ODPoint and ODRect
#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _ODUTILS_
#include "ODUtils.h"
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef _ODUTILW_
#include "ODUtilW.h"
#endif

#ifndef _ISOSTRING_
#include "ISOStr.h"
#endif

#ifndef _FOCUSLIB_
#include "FocusLib.h"
#endif

#ifndef SOM_Module_OpenDoc_StdProps_defined
#include <StdProps.xh>
#endif

#ifndef SOM_Module_OpenDoc_StdTypes_defined
#include <StdTypes.xh>
#endif

#ifndef SOM_Module_OpenDoc_Foci_defined
#include <Foci.xh>
#endif

#ifndef SOM_ODFocusSet_xh
#include <FocusSet.xh>
#endif

#ifndef SOM_ODPartWrapper_xh
#include "PartWrap.xh"
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODWindow_xh
#include <Window.xh>
#endif

#ifndef SOM_ODCanvas_xh
#include <Canvas.xh>
#endif

#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_ODDocument_xh
#include <Document.xh>
#endif

#ifndef SOM_ODContainer_xh
#include <ODCtr.xh>
#endif

#ifndef SOM_ODStorageUnitView_xh
#include <SUView.xh>
#endif

#ifndef SOM_ODStorageUnitCursor_xh
#include <SUCursor.xh>
#endif

#ifndef SOM_ODStorageUnit_xh
#include <StorageU.xh>
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODWindowState_xh
#include <WinStat.xh>
#endif

#ifndef SOM_ODFrame_xh
#include <Frame.xh>
#endif

#ifndef SOM_ODFacet_xh
#include <Facet.xh>
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef SOM_ODDispatcher_xh
#include <Disptch.xh>
#endif

#ifndef SOM_ODMenuBar_xh
#include "MenuBar.xh"
#endif

#ifndef SOM_Module_OpenDoc_Commands_defined
#include <CmdDefs.xh>
#endif

#ifndef SOM_ODInfo_xh
#include "Info.xh"
#endif

#ifndef SOM_ODFrameFacetIterator_xih
#include "FrFaItr.xh"
#endif

#ifndef SOM_ODArbitrator_xh
#include <Arbitrat.xh>
#endif

#ifndef SOM_ODShape_xh
#include <Shape.xh>
#endif

#define VARIABLE_MACROS
#include <ODVideo.xih>

#include "dbutton.h"				// my buttons

#include <stdlib.h>

#include <mmsystem.h>
#include <stdio.h>
#include <commdlg.h>
#include "odvideo.rh"

/* statics  */
static int ObjectCounter = 0;

/* constants
*/

const ODCommandID IDM_VIDEOMENU 	= 2001;
const ODCommandID IDM_VIDEOFILE 	= 2002;
const ODCommandID IDM_VIDEOSTOP 	= 2003;
const ODCommandID IDM_VIDEOPLAY 	= 2004;
const ODCommandID IDM_VIDEOPAUSE 	= 2005;
const ODCommandID IDM_VIDEOTOOLS	= 2006;
const ODCommandID IDM_VIDEOREPEAT	= 2007;
const ODCommandID IDM_PALETTEMENU	= 2010;
const ODCommandID IDM_PALBACKGROUND = 2011;
const ODCommandID IDM_PALNORMAL	= 2012;

const int	STATE_OPEN		= 1;
const int	STATE_PLAYING	= 2;
const int	STATE_FINISHED	= 4;
const int	TOOLHEIGHT		= 20;
const int	TOOLWIDTH		= 20;

static ODSession* gSession;

#define kODKindVideo "Apple:Kind:Video"

/* Globals
*/
HINSTANCE hInstance;

#ifndef WIN32
int FAR PASCAL LibMain( HINSTANCE _hInstance, WORD /*wDataSeg*/, WORD /*cbHeapSize*/, LPSTR /*lpCmdLine*/)
#else
BOOL WINAPI DllMain( HINSTANCE _hInstance, DWORD /*wDataSeg*/, LPVOID /*lpCmdLine*/)
#endif
{
	hInstance=_hInstance;
	return 1;
}


class VideoPartInfoRec
{
public:
	VideoPartInfoRec() { fIsActive = kODFalse;
								fNeedsActivating = kODFalse; }
	virtual ~VideoPartInfoRec() { }
	ODBoolean	fIsActive;	// Does this frame have its focus set?
	ODBoolean	fNeedsActivating;	// should this be activated when its window is activated?
};

LRESULT CALLBACK ShadowWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

ODFixed MyFixedMul(ODFixed val1, ODFixed val2)
{
	ODFixed retVal;

	retVal = (((val1 >> 16) * (val2 >> 16)) << 16);
	retVal += ((val1 >> 16) * (val2 & 0xffff));
	retVal += ((val1 & 0xffff) * (val2 >> 16));
	retVal += (((val1 & 0xffff) * (val2 & 0xffff)) >> 16);
	return retVal;
}

void MyScalePt(Environment* ev, Point* aPnt, ODFacet* facet)
{
	ODTransform*	anXForm = facet->GetContentTransform(ev, kODNULL);
	ODPoint			scale;
	anXForm->GetScale(ev, &scale);
	aPnt->x = FixedToInt(MyFixedMul(IntToFixed(aPnt->x), scale.x)); 
	aPnt->y = FixedToInt(MyFixedMul(IntToFixed(aPnt->y), scale.y)); 
}

void MyScaleRect(Environment* ev, Rect* rect, ODFacet* facet)
{
	ODTransform*	anXForm = facet->GetContentTransform(ev, kODNULL);
	ODPoint			scale;
	anXForm->GetScale(ev, &scale);
	SetRect(rect, FixedToInt(MyFixedMul(IntToFixed(rect->left), scale.x)), 
				FixedToInt(MyFixedMul(IntToFixed(rect->top), scale.y)), 
				FixedToInt(MyFixedMul(IntToFixed(rect->right), scale.x)), 
				FixedToInt(MyFixedMul(IntToFixed(rect->bottom), scale.y)));
}

void MyScaleRgn(Environment* ev, ODRgnHandle* aRgn, ODFacet* facet)
{
	Rect	rgnBox;
	GetRgnBox(*aRgn, &rgnBox);
	MyScaleRect(ev, &rgnBox, facet);
	DeleteObject(*aRgn);
	*aRgn = CreateRectRgnIndirect(&rgnBox);
}

//-------------------------------------------------------------------------
// Constructor/Destructor
//-------------------------------------------------------------------------

SOM_Scope void  SOMLINK ModVideoPart_VideoPartsomInit(ModVideoPart_VideoPart *somSelf)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ModVideoPart_VideoPart_parent_ODPart_somInit(somSelf);

	gSession = kODNULL;
	_fWindowID = 0;
	_fDisplayFrames = NULL;						// Create an empty collection for storing the list
												// of frames to display	the "video" in.
	_fSession = kODNULL;

	_fMenuBar = kODNULL;
	_fFocusSet = kODNULL;
	_fVideoSU = kODNULL;
	_fShadowWindow = kODNULL;

	_fSemtIntf = kODNULL;

	_State = 0;
	_ToolState = 0;
	_RepeatFlag = 0;
	_Buttons = NULL;
	_FileName[0] = 0;
	_Palette = IDM_PALNORMAL;

	ObjectCounter++;
	_ObjectNumber = ObjectCounter;
	_fPartWrapper = kODNULL;
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartsomUninit(ModVideoPart_VideoPart *somSelf)
{
	 ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	Environment *ev = somGetGlobalEnvironment();

	ODDeleteObject(_fDisplayFrames);// Release the display frames collection.
									// Deletion of memory used by the object will be
									// reclaimed when the shell deletes the
									// instantiation.

	if (_fSemtIntf != kODNULL)
		delete _fSemtIntf;

	ODReleaseObject(ev, _fMenuBar);
	ODReleaseObject(ev, _fVideoSU);

	if (_fShadowWindow)
		DestroyWindow (_fShadowWindow);

	somSelf->CloseVideo(ev);
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartInitPart(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	somSelf->InitPersistentObject(ev, storageUnit);
	
	_fPartWrapper = partWrapper;

	somSelf->CommonInitVideo(ev);

	storageUnit->AddProperty(ev, kODPropContents)->AddValue(ev, kODKindVideo);

	_fVideoSU = storageUnit->GetDraft(ev)->CreateStorageUnit(ev);

	_fVideoSU->AddProperty(ev, kODPropDisplayFrames)->AddValue(ev, kODWeakStorageUnitRefs);
	_fVideoSU->AddProperty(ev, "_FileName")->AddValue(ev, kODWeakStorageUnitRefs);
	_fVideoSU->AddProperty(ev, "_ToolState")->AddValue(ev, kODWeakStorageUnitRefs);
	_fVideoSU->AddProperty(ev, "_RepeatFlag")->AddValue(ev, kODWeakStorageUnitRefs);
	_fVideoSU->AddProperty(ev, "_Palette")->AddValue(ev, kODWeakStorageUnitRefs);
}


SOM_Scope void SOMLINK ModVideoPart_VideoPartInitPartFromStorage(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	somSelf->InitPersistentObjectFromStorage(ev, storageUnit);
	
	_fPartWrapper = partWrapper;

	_fSession = storageUnit->GetSession(ev);

	somSelf->CommonInitVideo(ev);

	ODULong valueSize, offset;
	ODStorageUnitRef aSURef;
	ODFrame* aFrame;
	ODStorageUnit* su;

	ODVolatile(su);
	ODVolatile(aFrame);

	su = somSelf->GetStorageUnit(ev);
	su->Focus(ev, kODPropContents,kODPosSame,kODKindVideo,1,kODPosFirstSib);
	su->GetValue(ev, sizeof(ODStorageUnitRef),&aSURef);
	_fVideoSU = su->GetDraft(ev)->GetStorageUnit(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
	su = _fVideoSU;

	su->Focus(ev, kODPropDisplayFrames,kODPosUndefined,0,1,kODPosFirstSib);
	valueSize = su->GetSize(ev);
	for (offset = 0; offset < valueSize; offset += sizeof(ODStorageUnitRef))
	{
		su->SetOffset(ev, offset);
		su->GetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);

		TRY

			aFrame = su->GetDraft(ev)->GetFrame(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
			_fDisplayFrames->AddLast((ElementType)aFrame);

		CATCH_ALL

			aFrame = kODNULL;

		ENDTRY
	}

	su->Focus(ev, "_FileName",kODPosUndefined,0,1,kODPosFirstSib);
	su->GetValue(ev, sizeof(_FileName),(ODValue)_FileName);
	su->Focus(ev, "_ToolState",kODPosUndefined,0,1,kODPosFirstSib);
	su->GetValue(ev, sizeof(_ToolState),(ODValue)&_ToolState); 	// really I shouldn't use GetValue because of Intel byte swapping
	su->Focus(ev, "_RepeatFlag",kODPosUndefined,0,1,kODPosFirstSib);
	su->GetValue(ev, sizeof(_RepeatFlag),(ODValue)&_RepeatFlag);
	su->Focus(ev, "_Palette",kODPosUndefined,0,1,kODPosFirstSib);
	su->GetValue(ev, sizeof(_Palette),(ODValue)&_Palette);


	// We should minimize the frame shape here, but we can't because I think that
	// the fPart and fPartInfo for the frame hasn't been set up yet.
	// this->MinimizeFrameShape(dispFrame);
}


SOM_Scope void SOMLINK ModVideoPart_VideoPartCommonInitVideo(ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	_fSession = somSelf->GetStorageUnit(ev)->GetSession(ev);

	gSession = _fSession;

	_fSelectionFocus = _fSession->Tokenize(ev, kODSelectionFocus);
	_fMenuFocus = _fSession->Tokenize(ev, kODMenuFocus);
	_fKeyFocus = _fSession->Tokenize(ev, kODKeyFocus);
	_fModalFocus = _fSession->Tokenize(ev, kODModalFocus);

	_fDisplayFrames = new OrderedCollection;		// Create an empty collection for storing the list
												// of frames to display	in.

	_fVideoMenu.menu = CreatePopupMenu();
	strcpy (_fVideoMenu.strMenu, "&Video");
	AppendMenu (_fVideoMenu.menu, MF_STRING | MF_ENABLED,(UINT) IDM_VIDEOFILE, "&Choose video");
	AppendMenu (_fVideoMenu.menu, MF_STRING | MF_ENABLED,(UINT) IDM_VIDEOPLAY, "&Play");
	AppendMenu (_fVideoMenu.menu, MF_STRING | MF_ENABLED,(UINT) IDM_VIDEOPAUSE, "P&ause");
	AppendMenu (_fVideoMenu.menu, MF_STRING | MF_ENABLED,(UINT) IDM_VIDEOREPEAT, "&Repeat");
	AppendMenu (_fVideoMenu.menu, MF_STRING | MF_ENABLED,(UINT) IDM_VIDEOTOOLS, "&Tools");

	_fPaletteMenu.menu = CreatePopupMenu();
	strcpy (_fPaletteMenu.strMenu, "&Palette");
	AppendMenu (_fPaletteMenu.menu, MF_STRING | MF_ENABLED,(UINT) IDM_PALNORMAL, "&Normal");
	AppendMenu (_fPaletteMenu.menu, MF_STRING | MF_ENABLED,(UINT) IDM_PALBACKGROUND, "&Background");


	_fMenuBar = _fSession->GetWindowState(ev)->CopyBaseMenuBar(ev);
	_fMenuBar->AddMenuLast(ev, (ODMenuID)"&Video", &_fVideoMenu, _fPartWrapper);
	_fMenuBar->AddMenuLast(ev, (ODMenuID)"&Palette", &_fPaletteMenu, _fPartWrapper);

	_fFocusSet = new ODFocusSet();
	_fFocusSet->InitFocusSet(ev);
	_fFocusSet->Add(ev, _fKeyFocus);
	_fFocusSet->Add(ev, _fMenuFocus);
	_fFocusSet->Add(ev, _fSelectionFocus);

#ifdef OSA_SUPPORT
	_fSemtIntf = new ODSemanticInterface();
	_fSemtIntf->InitSemanticInterface(ev, _fPartWrapper);
#endif
}


//-------------------------------------------------------------------------
// Getters/Setters
//-------------------------------------------------------------------------
	

//------------------------------------------------------------------------------
// VideoPart::FulfillPromise
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartFulfillPromise(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODStorageUnitView *promiseSUView)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(promiseSUView);
	// Video Part does not allow embedding of data.
	// This method is not needed.
}


//------------------------------------------------------------------------------
// VideoPart::DropCompleted
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartDropCompleted(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODPart* 		destPart,
								ODDropResult 	dropResult )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(destPart);
ODUnused(dropResult);

	// Video Part does not allow embedding of data.
	// This method is not needed.
}


//------------------------------------------------------------------------------
// VideoPart::DragEnter
//------------------------------------------------------------------------------


SOM_Scope ODBoolean SOMLINK ModVideoPart_VideoPartDragEnter(ModVideoPart_VideoPart *somSelf, Environment *ev, 
						ODDragItemIterator*		dragInfo,				//OLE2
					  	ODFacet*            	facet,
					  	ODPoint* 			   	where )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

return	kODFalse;														//OLE2
}


//------------------------------------------------------------------------------
// VideoPart::DragWithin
//------------------------------------------------------------------------------


SOM_Scope ODBoolean SOMLINK ModVideoPart_VideoPartDragWithin(ModVideoPart_VideoPart *somSelf, Environment *ev, 
						ODDragItemIterator*	dragInfo,			//OLE2
						ODFacet*            facet,
						ODPoint* 		    where )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

	// Video Part does not allow embedding of data.
	// This method is not needed.
return	kODFalse;														//OLE2
}


//------------------------------------------------------------------------------
// VideoPart::DragLeave
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartDragLeave(ModVideoPart_VideoPart *somSelf, Environment *ev, 
						ODFacet*     facet,
					  	ODPoint*		where )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(facet);
ODUnused(where);
}


//------------------------------------------------------------------------------
// VideoPart::Drop
//------------------------------------------------------------------------------


SOM_Scope ODDropResult SOMLINK ModVideoPart_VideoPartDrop(ModVideoPart_VideoPart *somSelf, Environment *ev, 
					ODDragItemIterator* 	dropInfo,
				 	ODFacet*            	facet,
				 	ODPoint* 			  	where )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(dropInfo);
ODUnused(facet);
ODUnused(where);


	return kODDropMove;
}


//-------------------------------------------------------------------------
// Implementation for Frame protocol:
//
//		The Frame protocol...
//
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// VideoPart::RemoveDisplayFrame
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartDisplayFrameRemoved(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* oldFrame )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if ( _fDisplayFrames -> Contains( oldFrame ))
	{
		VideoPartInfoRec* pInfo = (VideoPartInfoRec*) oldFrame->GetPartInfo(ev);
		oldFrame->SetPartInfo(ev, (ODInfoType) kODNULL);
		delete pInfo;

		_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,oldFrame);
		_fDisplayFrames -> Remove( oldFrame );

		oldFrame -> Release(ev);
	}
}

//------------------------------------------------------------------------------
// VideoPart::AddDisplayFrame
//------------------------------------------------------------------------------



SOM_Scope void SOMLINK ModVideoPart_VideoPartDisplayFrameAdded(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if ( frame -> GetPart(ev) == _fPartWrapper )
	{
		VideoPartInfoRec* pInfo = new VideoPartInfoRec;
		if (frame->IsRoot(ev))
			pInfo->fNeedsActivating = kODTrue;
		frame->SetPartInfo(ev, (ODInfoType) pInfo);
		_fDisplayFrames -> AddLast( frame );

		frame -> IncrementRefCount(ev);
	}
}


//------------------------------------------------------------------------------
// VideoPart::CloseDisplayFrame
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartDisplayFrameClosed(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if ( _fDisplayFrames -> Contains( frame ))
	{
		VideoPartInfoRec* pInfo = (VideoPartInfoRec*) frame->GetPartInfo(ev);
		frame->SetPartInfo(ev, (ODInfoType) kODNULL);
		delete pInfo;
		_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet, frame);
		_fDisplayFrames -> Remove( frame );

		frame -> Release(ev);
	}
}

//------------------------------------------------------------------------------
// VideoPart::FacetAdded
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartFacetAdded(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFacet* facet)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	somSelf -> MinimizeFrameShape( ev, facet->GetFrame(ev) );

	if (_fShadowWindow == kODNULL) {
		_fShadowWindow = somSelf->CreateShadowWindow(ev, facet->GetWindow(ev)->GetPlatformWindow(ev));
		_Buttons= new DButton(_fShadowWindow);

		ODShape* tempShape = new ODShape;
		tempShape = (ODShape*) facet->GetActiveShape(ev, kODNULL)->Copy(ev);
		RECT rc;
		GetRgnBox (	tempShape->GetWinRegion(ev), &rc);

		_Buttons->Add(IDB_PLAY,0,rc.bottom-TOOLHEIGHT,TOOLWIDTH,TOOLHEIGHT,0,TRUE);
		_Buttons->Add(IDB_PAUSE,TOOLWIDTH,rc.bottom-TOOLHEIGHT,TOOLWIDTH,TOOLHEIGHT);
		_Buttons->Add(IDB_REPEAT,TOOLWIDTH*2,rc.bottom-TOOLHEIGHT,TOOLWIDTH,TOOLHEIGHT);
		_Buttons->SetState(IDB_REPEAT,_RepeatFlag);

		ODDeleteObject(tempShape);

		ODFrame *containingFrame = facet->GetFrame(ev)->GetContainingFrame(ev);
		if (containingFrame) {
			ODPart *containingPart = containingFrame->GetPart(ev);
			if (containingPart->HasExtension(ev, "WindowsShadowWindow")) {

				ODPlatformWindow *shadowWindow =
					(ODPlatformWindow*)containingPart->GetExtension(ev, "WindowsShadowWindow");
				SetParent (_fShadowWindow, *shadowWindow);
			}
		}

	}


	somSelf->MoveSizeShadowWindow(ev);
	if (_FileName[0]!=0) {
		somSelf->OpenVideo(ev);	// This will Open the video if we are coming from a file open.
	}
}

void SOMLINK ModVideoPart_VideoPartFacetRemoved(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFacet* facet)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if (_fShadowWindow) {
		DestroyWindow (_fShadowWindow);
	}
}

//------------------------------------------------------------------------------
// VideoPart::FrameShapeChanged
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartFrameShapeChanged(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	// don't need to change used if same as frameShape
	// - just pass null to notify dependents
	frame->ChangeUsedShape(ev, kODNULL, kODNULL);
	somSelf->MoveSizeShadowWindow(ev);
}

static ODFacet* GetFirstFacet(Environment *ev, ODFrame* frame)
{
	ODFacet*	facet = kODNULL;

	if (frame) {
		ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
		facet = facets->First(ev);
		delete facets;
	}

	return(facet);
}


SOM_Scope void SOMLINK ModVideoPart_VideoPartGeometryChanged(ModVideoPart_VideoPart *somSelf, Environment *ev, 
						ODFacet*	facet,
						ODBoolean 	clipShapeChanged,
						ODBoolean 	externalTransformChanged)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(facet);

	//	If the ShadowWindow is present (it better be!) setup the clip region
	// so the video displays nicely.
	if (_fShadowWindow) {
		somSelf->MoveSizeShadowWindow(ev);

		ODShape* clipShape = new ODShape;
		clipShape->CopyFrom(ev, facet->GetAggregateClipShape(ev, kODNULL));
		ODRgnHandle clip = clipShape->GetWinRegion(ev);
		HDC	mydc;
		mydc = GetDC(_fShadowWindow);

		MyScaleRgn(ev, &clip, facet);

		SelectClipRgn(mydc, clip);

		ODDeleteObject(clipShape);

		somSelf->UpdateVideoWindowSize(ev);
	}
}

//------------------------------------------------------------------------------
// VideoPart::WritePartInfo
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartWritePartInfo(ModVideoPart_VideoPart *somSelf, Environment *ev, 
							ODPtr 				partInfo,
						  	ODStorageUnitView*	storageUnitView)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if (partInfo)
	{
		ODBoolean needsActivating = ((VideoPartInfoRec*)partInfo)->fNeedsActivating
									|| ((VideoPartInfoRec*)partInfo)->fIsActive;
		storageUnitView->SetValue(ev, sizeof(ODBoolean),
									(ODValue)&needsActivating);
	}

}


//------------------------------------------------------------------------------
// VideoPart::ReadPartInfo
//------------------------------------------------------------------------------


SOM_Scope ODPtr SOMLINK ModVideoPart_VideoPartReadPartInfo(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* frame, ODStorageUnitView*	storageUnitView)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(frame);
	if (storageUnitView->GetSize(ev))
	{
		VideoPartInfoRec* partInfo = new VideoPartInfoRec;

		ODBoolean needsActivating;
		storageUnitView->GetValue(ev, sizeof(ODBoolean),
									(ODValue)&(needsActivating));
		partInfo->fNeedsActivating = needsActivating;

		return partInfo;
	}
	else
		return ((ODPtr)kODNULL);
}


//------------------------------------------------------------------------------
// VideoPart::Open
//------------------------------------------------------------------------------


SOM_Scope ODID SOMLINK ModVideoPart_VideoPartOpen(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFrame*  frame )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODWindow* window = kODNULL;

	if (frame) // Doing a View As Window
	{
		window = _fSession->GetWindowState(ev)->GetWindow(ev, _fWindowID);
		if (window)
			window->Select(ev);
		else
		{
			window = somSelf->VdoCreateWindow(ev, frame);
			_fWindowID = window->GetID(ev);
			window->Open(ev);
			window->Show(ev);
			window->Select(ev);
		}
	}
	else
	{
		window = somSelf->VdoCreateWindow(ev, frame);
		_fWindowID = window->GetID(ev);
		window->Open(ev);
		window->Show(ev);
		window->Select(ev);
	}
	return window->GetID(ev);
}

SOM_Scope ODWindow* SOMLINK ModVideoPart_VideoPartVdoCreateWindow(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* sourceFrame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	Rect windRect;
	ODPlatformWindow platformWindow = kODNULL;
	ODWindow* window = kODNULL;

	SetRect(&windRect, 4, 40, 204, 100);

	platformWindow =  _fSession->GetWindowState(ev)->CreatePlatformWindow(ev, kODFalse, WS_CHILD | WS_CLIPSIBLINGS);
	
	window =  _fSession->GetWindowState(ev)->RegisterWindow(ev, platformWindow,
		kODNULL,														
		(sourceFrame==kODNULL),	// Keeps draft open
		kODTrue,	// Is resizable
		kODFalse,	// Is floating
		kODTrue,  // should save
		_fPartWrapper, (_fSession->Tokenize(ev, kODViewAsFrame)), kODNullTypeToken, sourceFrame);



	if (!sourceFrame)
	{
		ODRect bounds;													//OLE2
		ODShape* wantShape = somSelf->CalcActualButtonShape(ev, platformWindow);
		wantShape->GetBoundingBox(ev, &bounds);								//OLE2

		bounds.AsWinRect(windRect);										//OLE2

		SetWindowPos(platformWindow,HWND_TOP, windRect.left, windRect.top,
			windRect.right - windRect.left, windRect.bottom - windRect.top,
			SWP_NOMOVE | SWP_NOZORDER);

		delete wantShape;
	}
	return window;
}


//-------------------------------------------------------------------------
// Implementation for Imaging protocol
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// VideoPart::Draw
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartDraw(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFacet* facet, ODShape* invalShape )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(invalShape);

	ODFrame*	displayFrame = facet->GetFrame(ev);

	if ( _fDisplayFrames->Contains(displayFrame) )
	{
		HDC		hdc;
		ODRect	bRect;
		Rect	rect;

		hdc = GetDC(_fShadowWindow);

		displayFrame->GetFrameShape(ev, kODNULL)->GetBoundingBox(ev, &bRect);
		bRect.AsWinRect( rect );

		MyScaleRect(ev, &rect, facet);

		if (! (_State & STATE_OPEN)) {
			FillRect(hdc,&rect,GetStockObject(LTGRAY_BRUSH));
		}
		else {
			somSelf->UpdateVideoWindowSize(ev);
			somSelf->UpdateVideoWindow(ev, hdc);

			if (_ToolState)
				_Buttons->DrawAll();
		}

		ReleaseDC(_fShadowWindow, hdc);
	}
	else
	{
		// !!! signal error: invalid frame
	}
}

//-------------------------------------------------------------------------
// Implementation for Linking protocol
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// VideoPart::CreateLink
//------------------------------------------------------------------------------


SOM_Scope ODLink* SOMLINK ModVideoPart_VideoPartCreateLink(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODPtr data, ODULong size)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(data);
ODUnused(size);

	return kODNULL;
}


//------------------------------------------------------------------------------
// VideoPart::LinkUpdated
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartLinkUpdated(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODLink*  updatedLink, ODChangeID id )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(updatedLink);
ODUnused(id);

	// does not support linking
}

//-------------------------------------------------------------------------
// Implementation for Memory Management protocol
//-------------------------------------------------------------------------

SOM_Scope ODSize SOMLINK ModVideoPart_VideoPartPurge(ModVideoPart_VideoPart *somSelf, Environment *ev, ODSize  size )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODStorageUnit* su = somSelf->GetStorageUnit(ev);
	return su -> Purge( ev, size );
}


//-------------------------------------------------------------------------
// Implementation for Storage Management protocol
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// VideoPart:: Externalize
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModVideoPart_VideoPartExternalize(ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ModVideoPart_VideoPart_parent_ODPart_Externalize(somSelf, ev);

	ODFrame* aFrame;
	ODStorageUnitRef aSURef;
	ODULong offset, offsetLimit;
	ODStorageUnit* su = _fVideoSU;

	OrderedCollectionIterator aIter(_fDisplayFrames);
	su->Focus(ev, kODPropDisplayFrames,kODPosUndefined,0,1,kODPosFirstSib);
	offsetLimit = su->GetSize(ev);
	offset = 0;
	for (aFrame = (ODFrame*)aIter.First(); aIter.IsNotComplete();
											aFrame = (ODFrame*)aIter.Next(),
											offset+=sizeof(ODStorageUnitRef))
	{
		aFrame->Externalize(ev);
		aSURef = su->GetStrongStorageUnitRef(ev, aFrame->GetStorageUnit(ev)->GetID(ev));
		su->SetOffset(ev, offset);
		su->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
	}
	if (offset < offsetLimit)
		su->DeleteValue(ev, offsetLimit - offset);


	su->Focus(ev, "_FileName",kODPosUndefined,0,1,kODPosFirstSib);
	su->SetValue(ev, sizeof(_FileName),(ODValue)_FileName);
	su->Focus(ev, "_ToolState",kODPosUndefined,0,1,kODPosFirstSib);
	su->SetValue(ev, sizeof(_ToolState),(ODValue)&_ToolState);		// really I shouldn't use SetValue because of Intel byte swapping
	su->Focus(ev, "_RepeatFlag",kODPosUndefined,0,1,kODPosFirstSib);
	su->SetValue(ev, sizeof(_RepeatFlag),(ODValue)&_RepeatFlag);
	su->Focus(ev, "_Palette",kODPosUndefined,0,1,kODPosFirstSib);
	su->SetValue(ev, sizeof(_Palette),(ODValue)&_Palette);

	su = somSelf->GetStorageUnit(ev);
	su->Focus(ev, kODPropContents,kODPosSame,kODKindVideo,1,kODPosFirstSib);
	aSURef = su->GetStrongStorageUnitRef(ev, _fVideoSU->GetID(ev));
	su->SetValue(ev, sizeof(ODStorageUnitRef),&aSURef);

}


//-------------------------------------------------------------------------
// Implementation for Part Activation protocol
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// VideoPart::BeginRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope ODBoolean SOMLINK ModVideoPart_VideoPartBeginRelinquishFocus(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODTypeToken 	focus,
								ODFrame* 		currentFrame,
								ODFrame* 		proposedFrame )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(focus);
ODUnused(currentFrame);
ODUnused(proposedFrame);

	if ((focus == _fModalFocus) && (proposedFrame->GetPart(ev) != _fPartWrapper))
		return kODFalse;
	else
		return kODTrue;
}


//------------------------------------------------------------------------------
// VideoPart::CommitRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartCommitRelinquishFocus(ModVideoPart_VideoPart *somSelf, Environment *ev, 
							ODTypeToken 	focus,
							ODFrame* 		currentFrame,
							ODFrame*		proposedFrame )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODUnused(proposedFrame);
	somSelf->FocusLost(ev, focus, currentFrame);
}


//------------------------------------------------------------------------------
// VideoPart::AbortRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartAbortRelinquishFocus(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODTypeToken		focus,
								ODFrame*		currentFrame,
								ODFrame*		proposedFrame )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

ODUnused(focus);
ODUnused(currentFrame);
ODUnused(proposedFrame);
	// default is do nothing
}
			
							
//------------------------------------------------------------------------------
// VideoPart::FocusAcquired
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartFocusAcquired(ModVideoPart_VideoPart *somSelf, Environment *ev, 
							ODTypeToken		focus,
						  	ODFrame*		newOwner )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if (focus == _fSelectionFocus)
	{
		VideoPartInfoRec* pInfo = (VideoPartInfoRec*) newOwner->GetPartInfo(ev);
		pInfo->fIsActive = kODTrue;
	}
	else if (focus == _fMenuFocus)
		somSelf->InstallMenus(ev, newOwner);
}


//------------------------------------------------------------------------------
// VideoPart::FocusLost
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartFocusLost(ModVideoPart_VideoPart *somSelf, Environment *ev, 
						ODTypeToken	focus,
					  	ODFrame* 	oldOwner )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if (focus == _fSelectionFocus)
	{	// !!! unhighlight selection...
		VideoPartInfoRec* pInfo = (VideoPartInfoRec*) oldOwner->GetPartInfo(ev);
		pInfo->fIsActive = kODFalse;

		ODWindow* settingsWindow = _fSession->GetWindowState(ev)->GetWindow(ev, _fSettingsWindow);
		if (settingsWindow && settingsWindow->IsShown(ev))
		{
			_fSettingsWindowWasShown = kODTrue;
			settingsWindow->Hide(ev);
		}
		SetFocus (GetActiveWindow());
	}
	else if (focus == _fMenuFocus)
		somSelf->RemoveMenus( ev, oldOwner );

}	


//-------------------------------------------------------------------------
// Implementation for UI Events protocol
//-------------------------------------------------------------------------
	
//------------------------------------------------------------------------------
// VideoPart::HandleEvent
//------------------------------------------------------------------------------


SOM_Scope ODBoolean SOMLINK ModVideoPart_VideoPartHandleEvent(ModVideoPart_VideoPart *somSelf, Environment *ev, 
						ODEventData* event,
						ODFrame* 	frame,
						ODFacet* 	facet )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODBoolean	tWasHandled = kODFalse;

	switch ( event -> message ) {
		case WM_COMMAND:
			tWasHandled = somSelf->HandleMenuEvent (ev, frame, event);
			break;

		case WM_RBUTTONDOWN:
			somSelf->UpdateVideoWindowSize(ev);
			somSelf->RewindVideo(ev);
			somSelf->PlayVideo(ev);
			break;

		case WM_LBUTTONDOWN:
			if (_Buttons) {
				Point where;
#ifndef WIN32
				where = MAKEPOINT (event->lParam);
#else
				LONG2POINT (event->lParam, where);
#endif
				ODPoint	anODPnt(IntToFixed(where.x), IntToFixed(where.y));
				Point mouse = facet->GetWindowContentTransform(ev, kODNULL)->InvertPoint(ev, &anODPnt).AsWinPoint();
				MyScalePt(ev, &mouse, facet);
				int ButtonNum = _Buttons->CheckForHit(mouse.x,mouse.y);
				switch (ButtonNum) {
					case IDB_PLAY:
						somSelf->PlayVideo(ev);
						break;
					case IDB_PAUSE:
						somSelf->PauseVideo(ev);
						break;
					case IDB_REPEAT:
						_RepeatFlag ^= 1;
						_Buttons->SetState(IDB_REPEAT,_RepeatFlag);
						_Buttons->Draw(IDB_REPEAT);
						break;
				}
			}
			tWasHandled = somSelf->HandleMouseDown(ev, event, frame, facet );
			break;

		/* Make sure video activates its menu when it is the root part	//OLE2
		 */																//OLE2
		case kODEvtActivate:												//OLE2
			tWasHandled = TRUE; // actually ignored by dispatcher		//OLE2
			if (event->wParam  != WA_INACTIVE)			  				//OLE2
				somSelf->HandleMouseDown(ev, event,frame,facet);				//OLE2
			break;														//OLE2
																		//OLE2
		default:
			break;
	}

	return tWasHandled;
}
								
			
//------------------------------------------------------------------------------
// VideoPart::MouseEnterFrame
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModVideoPart_VideoPartMouseEnter(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFacet* facet,
							ODPoint*  where )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODUnused(facet);
	ODUnused(where);
}

//------------------------------------------------------------------------------
// VideoPart::MouseWithin
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModVideoPart_VideoPartMouseWithin(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFacet* facet,
							ODPoint*  where )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODUnused(facet);
	ODUnused(where);
}


//------------------------------------------------------------------------------
// VideoPart::MouseLeaveFrame
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModVideoPart_VideoPartMouseLeave(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFacet* facet)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODUnused(facet);
}


//------------------------------------------------------------------------------
// VideoPart::AdjustMenus
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModVideoPart_VideoPartAdjustMenus(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODUnused(frame);
	_fMenuBar->EnableCommand(ev, kODCommandViewAsWin, !frame->IsRoot(ev));
	_fMenuBar->CheckCommand(ev, IDM_VIDEOTOOLS,_ToolState);
	_fMenuBar->CheckCommand(ev, IDM_VIDEOREPEAT,_RepeatFlag);
	if (_Palette == IDM_PALNORMAL) {
		_fMenuBar->CheckCommand(ev, IDM_PALNORMAL,kODTrue);
		_fMenuBar->CheckCommand(ev, IDM_PALBACKGROUND,kODFalse);
	}
	else {
		_fMenuBar->CheckCommand(ev, IDM_PALNORMAL,kODFalse);
		_fMenuBar->CheckCommand(ev, IDM_PALBACKGROUND,kODTrue);
	}
}


//------------------------------------------------------------------------------
// VideoPart::Idle
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// VideoPart::HandleMouseDown
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK ModVideoPart_VideoPartHandleMouseDown(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODEventData* event, ODFrame* frame, ODFacet* facet )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODBoolean tWasHandled = kODFalse;

	if (facet == kODNULL) // Outside modal focus
	{
		tWasHandled = kODTrue;
	}
	else
	{
		ODBoolean tWasHandled = kODTrue;
		if (!facet->GetWindow(ev)->IsActive(ev))
			facet->GetWindow(ev)->Select(ev);
		else
		{
			somSelf->ActivateFrame(ev, facet->GetFrame(ev));

			ODWindow* settingsWindow = _fSession->GetWindowState(ev)->GetWindow(ev, _fSettingsWindow);
			if (settingsWindow && _fSettingsWindowWasShown)
				settingsWindow->Show(ev);
		}

	}
	return tWasHandled;
}



//------------------------------------------------------------------------------
// VideoPart::HandleMenuEvent
//------------------------------------------------------------------------------


SOM_Scope ODBoolean SOMLINK ModVideoPart_VideoPartHandleMenuEvent(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* frame, ODEventData* event)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODCommandID command = event->message;

	ODBoolean tEventHandled = kODTrue;

	switch ( event->wParam ) {
		case IDM_PALNORMAL:
		case IDM_PALBACKGROUND:
			_Palette = event->wParam;
			somSelf->AdjustPalette(ev);
			break;

		case IDM_VIDEOFILE :
					char    szFile[128];
					OPENFILENAME of;

					lstrcpy(szFile, "*.AVI");

					memset(&of, '\0', sizeof(OPENFILENAME));

					of.lStructSize  = sizeof(OPENFILENAME);
					of.hwndOwner    = 0;
					of.lpstrFilter  = (LPSTR)"Videos (*.AVI)\0*.AVI\0All (*.*)\0*.*\0";
					of.lpstrCustomFilter = NULL;
					of.nFilterIndex = 1;
					of.lpstrFile    = (LPSTR)szFile;
					of.nMaxFile     = sizeof(szFile);
					of.lpstrInitialDir = NULL;
					of.lpstrTitle   = NULL;
					of.Flags        = OFN_FILEMUSTEXIST;
					of.lpstrDefExt  = NULL;

					if(GetOpenFileName(&of))
					{
						lstrcpy (_FileName,of.lpstrFile);
						somSelf->OpenVideo(ev);
					}

					break;
		case IDM_VIDEOPLAY :
			somSelf->PlayVideo(ev);
			break;

		case IDM_VIDEOREPEAT :
			_RepeatFlag ^= 1;
			_Buttons->SetState(IDB_REPEAT,_RepeatFlag);
			if (_ToolState)
				_Buttons->Draw(IDB_REPEAT);
			break;

		case IDM_VIDEOSTOP :
			somSelf->StopVideo(ev);
			break;

		case IDM_VIDEOPAUSE :
			somSelf->PauseVideo(ev);
			break;

		case IDM_VIDEOTOOLS :
			_ToolState ^= 1;
			frame->Invalidate(ev, kODNULL, kODNULL);
		break;

		case kODCommandViewAsWin:
			somSelf->Open(ev, frame);
			break;

		default:

			tEventHandled = kODFalse;
	}

	return tEventHandled;
}


//-------------------------------------------------------------------------
// SemanticInterface
//-------------------------------------------------------------------------

SOM_Scope ODExtension* SOMLINK ModVideoPart_VideoPartGetExtension(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODType extensionName)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	LPSTR	shadowWindow = "WindowsShadowWindow";
	LPSTR	semtIntf = "SemanticInterface";

	if (!lstrcmpi((LPSTR)extensionName, (LPSTR)shadowWindow))
		return (ODExtension*)&_fShadowWindow;
	else if (!lstrcmpi((LPSTR)extensionName, (LPSTR)semtIntf))
		return (ODExtension*)_fSemtIntf;
	else
		return (ODExtension*)kODNULL;
}


SOM_Scope ODBoolean SOMLINK ModVideoPart_VideoPartHasExtension(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODType extensionName)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	LPSTR	shadowWindow = "WindowsShadowWindow";
	LPSTR	semtIntf = "SemanticInterface";

	if (!lstrcmpi((LPSTR)extensionName, (LPSTR)shadowWindow))
		return kODTrue;
	else if (!lstrcmpi((LPSTR)extensionName, (LPSTR)semtIntf))
		return kODTrue;
	else
		return kODFalse;
}

SOM_Scope ODSemanticInterface* SOMLINK ModVideoPart_VideoPartGetSemanticInterface(ModVideoPart_VideoPart *somSelf, 
								Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	return _fSemtIntf;
}

//------------------------------------------------------------------------------
// VideoPart::InstallMenus
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModVideoPart_VideoPartInstallMenus(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame*  frame )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if ( frame && _fMenuBar)
	{	
		_fMenuBar->Display(ev);
	}
}


//------------------------------------------------------------------------------
// VideoPart::RemoveMenus
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartRemoveMenus(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODUnused(frame);
}




//------------------------------------------------------------------------------
// VideoPart:: CalcActualButtonSize
//------------------------------------------------------------------------------

SOM_Scope ODShape* SOMLINK ModVideoPart_VideoPartCalcActualButtonShape(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODPlatformWindow window)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODRect rect;
	rect.SetInt(0,0,150,150);

	ODShape *wantShape = new ODShape;

	wantShape->SetRectangle(ev, &rect);

	return wantShape;
}

//------------------------------------------------------------------------------
// VideoPart:: MinimizeFrameShape
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModVideoPart_VideoPartMinimizeFrameShape(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame*  frame )
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	ODFrameFacetIterator* fiter = frame->CreateFacetIterator(ev);

	ODPlatformWindow window = fiter->First(ev)->GetWindow(ev)->GetPlatformWindow(ev);

	ODShape* wantShape = somSelf->CalcActualButtonShape(ev, window);
	
	frame->Invalidate(ev, kODNULL, kODNULL);
	frame->InvalidateActiveBorder(ev);
	
	ODShape* gotShape = frame -> RequestFrameShape(ev, wantShape, kODNULL);
	frame->Invalidate(ev, kODNULL, kODNULL);
	frame->InvalidateActiveBorder(ev);
	
	frame->ChangeUsedShape(ev, kODNULL, kODNULL);

	delete fiter;
}
	

SOM_Scope void SOMLINK ModVideoPart_VideoPartActivateFrame(ModVideoPart_VideoPart *somSelf, Environment *ev, ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	VideoPartInfoRec* pInfo = (VideoPartInfoRec*) frame->GetPartInfo(ev);
	if (!(pInfo->fIsActive))
	{
		ODBoolean succeeded = kODFalse;
							
		succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame);
				
		if (succeeded)
		{
			somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
			somSelf->FocusAcquired(ev, _fMenuFocus, frame);
			somSelf->FocusAcquired(ev, _fKeyFocus, frame);
		}
	}
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartDeActivateFrame(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,frame);
	somSelf->FocusLost(ev, _fSelectionFocus, frame);
	somSelf->FocusLost(ev, _fMenuFocus, frame);
	somSelf->FocusLost(ev, _fKeyFocus, frame);
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartActivatingWindow(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	VideoPartInfoRec* pInfo = (VideoPartInfoRec*) frame->GetPartInfo(ev);
	if (pInfo->fNeedsActivating)
	{
		somSelf->ActivateFrame(ev, frame);
	}
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartDeActivatingWindow(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODFrame* frame)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	VideoPartInfoRec* pInfo = (VideoPartInfoRec*) frame->GetPartInfo(ev);
	if (frame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev, _fSelectionFocus))
	{
		pInfo->fNeedsActivating = kODTrue;
	}
	else
		pInfo->fNeedsActivating = kODFalse;
}

SOM_Scope ODPlatformWindow SOMLINK ModVideoPart_VideoPartCreateShadowWindow(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODPlatformWindow hParent)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	WNDCLASS  wc;

	if (!GetClassInfo(
#ifndef WIN32
		GetWindowWord(hParent, GWW_HINSTANCE), 
#else
		(HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE), 
#endif
		"VideoShadowWindow", &wc)) {
		wc.style	        = CS_DBLCLKS | CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
		wc.lpfnWndProc   = ShadowWindowProc;			// exported static member of ODShell
		wc.cbClsExtra    = 0;
		wc.cbWndExtra    = 4;
#ifndef WIN32
		wc.hInstance     = GetWindowWord (hParent, GWW_HINSTANCE);
#else
		wc.hInstance     = (HINSTANCE)GetWindowLong(hParent, GWL_HINSTANCE);
#endif
		wc.hIcon	     = NULL;
		wc.hCursor	     = LoadCursor(NULL,IDC_ARROW);
		wc.hbrBackground = NULL;
		wc.lpszMenuName  = NULL;
		wc.lpszClassName = "VideoShadowWindow";

		if (!RegisterClass (&wc) )
			return (HWND)kODFalse;
	}
	_fShadowWindow = CreateWindowEx (WS_EX_TRANSPARENT, "VideoShadowWindow", "", WS_CHILD | WS_VISIBLE,
		0, 0, 0, 0, hParent, NULL, 
#ifndef WIN32
		GetWindowWord (hParent, GWW_HINSTANCE), 
#else
		(HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE), 
#endif
		NULL);

	if (_fShadowWindow) {
		SetWindowLong (_fShadowWindow, 0, (LONG)somSelf);
		somSelf->MoveSizeShadowWindow(ev);
	}

	return _fShadowWindow;
}

VOID SOMLINK ModVideoPart_VideoPartEmbedControl(ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	RECT rc;

	GetClientRect (_fShadowWindow, &rc);
}

SOM_Scope VOID SOMLINK ModVideoPart_VideoPartMoveSizeShadowWindow(ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if (_fShadowWindow) {
		ODFrame*	frame = (ODFrame*) _fDisplayFrames->First();
		if (frame) {
			ODShape* tempShape = new ODShape;
			ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
			tempShape = (ODShape*) facets->First(ev)->GetActiveShape(ev, kODNULL)->Copy(ev);
			if (facets->First(ev)->GetWindow(ev)->GetPlatformWindow(ev) == GetParent(_fShadowWindow)) {
				tempShape->Transform(ev, facets->First(ev)->GetContentTransform(ev, kODNULL));
			} else {
				tempShape->Transform(ev, facets->First(ev)->GetExternalTransform(ev, kODNULL));
			}
			RECT rc;
			GetRgnBox (	tempShape->GetWinRegion(ev), &rc);

			MyScaleRect(ev, &rc, facets->First(ev));

			MoveWindow (_fShadowWindow, rc.left, rc.top,
				rc.right - rc.left, rc.bottom - rc.top, TRUE);
			ODDeleteObject(tempShape);
			delete facets;
		}
	}
}
SOM_Scope void SOMLINK ModVideoPart_VideoPartMMNotifyReceived(ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[20];
	char command[40];

	wsprintf(command,"status video%d mode",_ObjectNumber);
	mciSendString(command,str,sizeof(str),NULL);
	if (strcmp(str,"playing") == 0) {
		_Buttons->SetState(IDB_PLAY,DBS_DOWN);
	}
	else {
		_Buttons->SetState(IDB_PLAY,DBS_UP);
	}
	_Buttons->SetState(IDB_PAUSE,DBS_UP);

	if (_RepeatFlag) {
		if (strcmp(str,"stopped") == 0) {
			somSelf->RewindVideo(ev);
			somSelf->PlayVideo(ev);
		}
	}

	if (_ToolState)
		_Buttons->DrawAll();
}

LRESULT CALLBACK ShadowWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	ModVideoPart_VideoPart *part;
	OrderedCollection *frames;
	ODFrameFacetIterator* facets;

	Environment *ev = somGetGlobalEnvironment();

	switch (message) {
		case MM_MCINOTIFY:
			part = (ModVideoPart_VideoPart*)GetWindowLong (hWnd, 0);
			part->MMNotifyReceived(ev);
			break;

		case WM_NCHITTEST:
			return HTTRANSPARENT;
			break;

		case WM_COMMAND:
			{
			part = (ModVideoPart_VideoPart*)GetWindowLong (hWnd, 0);
			frames = part->GetDisplayFrames(ev);
			facets = ((ODFrame*)frames->First())->CreateFacetIterator(ev);

			part->ActivateFrame(ev, (ODFrame *)frames->First());

			ODEventData	event;
			event.message = message;
			event.wParam = wParam;
			event.lParam = lParam;
			part->HandleEvent(ev, &event, (ODFrame *)frames->First(), facets->First(ev));
			delete facets;

			break;
			}
	}

	return (DefWindowProc(hWnd, message, wParam, lParam));
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartOpenVideo (ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[200];
	DWORD retval;

	if ( _State & STATE_OPEN) {
		wsprintf(str,"close video%d",_ObjectNumber);
		mciSendString(str,NULL,0,NULL);
	}

	wsprintf (str,"open %s alias video%d",_FileName,_ObjectNumber);
	retval= mciSendString(str,NULL,0,NULL);
	if (retval) {
		mciGetErrorString(retval,str,sizeof(str));
		MessageBox (NULL,str,"MCI Error opening file",MB_OK);
		_State ^= STATE_OPEN;
	}
	else {
		if (!_fShadowWindow) {
			MessageBeep(MB_OK);
		}
		_State |= STATE_OPEN;
		wsprintf (str,"window video%d handle %u",_ObjectNumber,_fShadowWindow);
		mciSendString(str,NULL,0,NULL);
		somSelf->AdjustPalette(ev);
		wsprintf (str,"seek video%d to start",_ObjectNumber);
		mciSendString(str,NULL,0,NULL);
		somSelf->UpdateVideoWindowSize(ev);
		ODFacet*	facet = GetFirstFacet(ev, (ODFrame*)_fDisplayFrames->First());
		somSelf->UpdateVideoWindow(ev, GetDC(_fShadowWindow));
	}
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartAdjustPalette(ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[35];
	if (_Palette == IDM_PALNORMAL)
		wsprintf (str,"realize video%d normal",_ObjectNumber);
	else
		wsprintf (str,"realize video%d background",_ObjectNumber);
	mciSendString(str,NULL,0,NULL);
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartCloseVideo (ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[20];
	if (_State & STATE_OPEN) {
		wsprintf(str,"close video%d",_ObjectNumber);
		mciSendString(str,NULL,0,NULL);
	}
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartPlayVideo (ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[100];
	char command[100];
	DWORD retval;
	DWORD length,position;

	wsprintf(command,"status video%d length",_ObjectNumber);
	mciSendString(command,str,sizeof(str),NULL);
	
	length=atol(str);
	wsprintf(command,"status video%d position",_ObjectNumber);
	mciSendString(command,str,sizeof(str),NULL);
	
	position=atol(str);
	if (position >= length-1) {
		somSelf->RewindVideo(ev);
	}
	somSelf->UpdateVideoWindowSize(ev);
#ifndef WIN32
	Yield();
#endif
	wsprintf(command,"play video%d notify",_ObjectNumber);
	mciSendString(command,NULL,0,_fShadowWindow);
	_Buttons->SetState(IDB_PLAY,DBS_DOWN);
	_Buttons->SetState(IDB_PAUSE,DBS_UP);
	if (_ToolState)
		_Buttons->DrawAll();
#ifndef WIN32
	Yield();
#endif
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartStopVideo (ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[20];
	wsprintf (str,"stop video%d",_ObjectNumber);
	mciSendString(str,NULL,0,NULL);
	ODFacet*	facet = GetFirstFacet(ev, (ODFrame*)_fDisplayFrames->First());
	somSelf->UpdateVideoWindow(ev, GetDC(_fShadowWindow));
	_Buttons->SetState(IDB_PLAY,DBS_UP);
	_Buttons->SetState(IDB_PAUSE,DBS_UP);
	if (_ToolState)
		_Buttons->DrawAll();
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartRewindVideo (ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[25];
	wsprintf(str,"seek video%d to start",_ObjectNumber);
	mciSendString(str,NULL,0,NULL);
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartPauseVideo (ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[20];
	wsprintf(str,"pause video%d",_ObjectNumber);
	mciSendString(str,NULL,0,NULL);
	ODFacet*	facet = GetFirstFacet(ev, (ODFrame*)_fDisplayFrames->First());
	somSelf->UpdateVideoWindow(ev, GetDC(_fShadowWindow));
	_Buttons->SetState(IDB_PLAY,DBS_UP);
	_Buttons->SetState(IDB_PAUSE,DBS_DOWN);
	if (_ToolState)
		_Buttons->DrawAll();
#ifndef WIN32
	Yield();
#endif
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartUpdateVideoWindow(ModVideoPart_VideoPart *somSelf, Environment *ev, 
								ODPlatformCanvas hdc)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	char str[40];
	char loc[20];

	if ( _State & STATE_OPEN) {
		wsprintf (str,"status video%d mode",_ObjectNumber);
		mciSendString(str,loc,sizeof(loc),NULL);
		if (stricmp(loc,"playing") == 0)
			return;

		wsprintf (str,"status video%d position",_ObjectNumber);
		mciSendString(str,loc,sizeof(loc),NULL);
		wsprintf (str,"update video%d HDC %u",_ObjectNumber,hdc);
		mciSendString(str,NULL,0,NULL);

#ifndef WIN32
		Yield();
#endif
		wsprintf(str,"seek video%d to %s",_ObjectNumber,loc);
		mciSendString(str,NULL,0,NULL);
	}
}

SOM_Scope void SOMLINK ModVideoPart_VideoPartUpdateVideoWindowSize(ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	if ( _State & STATE_OPEN) {
		RECT box;
		char str[80];
		GetClientRect(_fShadowWindow,&box);

		wsprintf (str,"window video%d handle %u",_ObjectNumber,_fShadowWindow);
		mciSendString(str,NULL,0,NULL);

		wsprintf (str,"put video%d destination at %d %d %d %d",_ObjectNumber,box.left,box.top,box.right,box.bottom-(TOOLHEIGHT*_ToolState));
		mciSendString(str,NULL,0,NULL);

		if (_ToolState) {
			_Buttons->SetLocation(IDB_PLAY, 0, box.bottom - TOOLHEIGHT);
			_Buttons->SetLocation(IDB_PAUSE, TOOLWIDTH, box.bottom - TOOLHEIGHT);
			_Buttons->SetLocation(IDB_REPEAT, TOOLWIDTH * 2, box.bottom - TOOLHEIGHT);
		}
	}
}

SOM_Scope OrderedCollection* SOMLINK ModVideoPart_VideoPartGetDisplayFrames(ModVideoPart_VideoPart *somSelf, Environment *ev)
{
	ModVideoPart_VideoPartData *somThis = ModVideoPart_VideoPartGetData(somSelf);

	return _fDisplayFrames;
};
