#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "dbutton.h"

extern HINSTANCE hInstance;


DButton::DButton(HWND _hWindow)
{
	hWindow=_hWindow;
	ButtonList=NULL;
}

DButton::~DButton()
{
	ButtonListTag *last,*ptr= ButtonList;


	while (ptr) {
		DeleteObject(ptr->bitmap);
		last=ptr;
		ptr=ptr->next;
		delete (last);
	}

}

int DButton::Add (int _id, int _x, int _y, int _w, int _h, int _state, int _UseBitmap)
{
	HBITMAP bitmap;
	ButtonListTag *ptr=ButtonList;
	if (!(bitmap=LoadBitmap (hInstance,MAKEINTRESOURCE(_id)))) {
		return (DERR_INVALID_BITMAP);
	}

	if (!ptr) {
		ButtonList=(ButtonListTag *)calloc(1,sizeof (ButtonListTag));
		ptr=ButtonList;
		if (!ButtonList) {
			DeleteObject(bitmap);
			return (DERR_OUTOFMEM);
		}

	}
	else {
		while (ptr->next) {
			if (ptr->id == _id) {
				DeleteObject(bitmap);
				return (DERR_INVALID_ID);
			}
			ptr=ptr->next;
		}
		ptr->next=(ButtonListTag *)calloc(1,sizeof (ButtonListTag));
		ptr=ptr->next;
	}
	ptr->id=_id;
	ptr->bitmap=bitmap;
	ptr->x=_x;
	ptr->y=_y;
	ptr->w=_w;
	ptr->h=_h;
	ptr->state=_state;
	ptr->UseBitmap = _UseBitmap;
//	Render(ptr);
	return 0;
}
int DButton::Render(ButtonListTag *ptr)
{
	HBITMAP	origbitmap;
	BITMAP	bm;
	HPEN	origpen;
	HPEN	pen;
	RECT	rect;
	int		retval = 0;
	int		EmbedOffset;
	HDC		memdc;
	HDC		dc = GetDC(hWindow);

	memdc = CreateCompatibleDC(dc);

	GetObject(ptr->bitmap, sizeof(BITMAP), &bm);
	origbitmap = SelectObject(memdc,ptr->bitmap);

	rect.left = ptr->x;
	rect.top = ptr->y;
	rect.right = ptr->w + ptr->x;
	rect.bottom = ptr->h + ptr->y;

	if (ptr->UseBitmap) {
		BitBlt(dc,rect.left, rect.top, (rect.right - rect.left), (rect.bottom - rect.top), 
				memdc, ptr->state * (rect.right - rect.left), 0, SRCCOPY);
		SelectObject(memdc, origbitmap);
		DeleteDC(memdc);
		return(DERR_NOERROR);
	}

	if (ptr->state == DBS_UP) {
		EmbedOffset = 2;
	}
	else {
		EmbedOffset = 3;
	}

	FillRect(dc, &rect, GetStockObject(LTGRAY_BRUSH));

	retval = BitBlt(dc, rect.left + EmbedOffset, rect.top + EmbedOffset, bm.bmWidth, bm.bmHeight, memdc, 0, 0, SRCCOPY);

	SelectObject(memdc, origbitmap);
	DeleteDC(memdc);

	if (ptr->state == DBS_UP) {
		origpen = SelectObject(dc, GetStockObject(WHITE_PEN));

		retval = MoveToEx(dc, rect.left, rect.top, NULL);
		retval = LineTo(dc, rect.left + (rect.right - rect.left) - 1, rect.top);
		retval = MoveToEx(dc, rect.left, rect.top, NULL);
		retval = LineTo(dc, rect.left, rect.top + (rect.bottom - rect.top) - 1);

		pen = CreatePen(PS_SOLID, 1, RGB(120, 120, 120));
		SelectObject(dc, pen);

		retval = MoveToEx(dc, rect.left, rect.top + (rect.bottom - rect.top), NULL);
		retval = LineTo(dc, rect.left + (rect.right - rect.left), rect.top + (rect.bottom - rect.top));
		retval = MoveToEx(dc, rect.left + 1, rect.top - 1 + (rect.bottom - rect.top), NULL);
		retval = LineTo(dc, rect.left + (rect.right - rect.left), rect.top - 1 + (rect.bottom - rect.top));
		retval = MoveToEx(dc, rect.left + (rect.right - rect.left), rect.top, NULL);
		retval = LineTo(dc, rect.left + (rect.right - rect.left), rect.top + (rect.bottom - rect.top));
		retval = MoveToEx(dc, rect.left + (rect.right - rect.left) - 1, rect.top + 1, NULL);
		retval = LineTo(dc, rect.left + (rect.right - rect.left) - 1, rect.top + (rect.bottom - rect.top));

		if (!retval) {
			SelectObject(dc, origpen);
			DeleteObject(pen);
			return(DERR_RENDER);
		}
	} else { // must be down state
		pen = CreatePen(PS_SOLID, 1, RGB(120, 120, 120));
		origpen = SelectObject(dc, pen);

		retval = MoveToEx(dc, rect.left, rect.top, NULL);
		retval = LineTo(dc, rect.left + (rect.right - rect.left), rect.top);

		if (!retval) {
			SelectObject(dc, origpen);
			DeleteObject(pen);
			return(DERR_RENDER);
		}
	}

	SelectObject(dc, origpen);
	DeleteObject(pen);

	return 0;
}

int DButton::Remove(int _id)
{
	return 0;
}

int DButton::SetState (int _id, int _state)
{
	ButtonListTag *ptr;

	if ((ptr=Find(_id)) == NULL) {
		return (DERR_INVALID_ID);
	}
	ptr->state=_state;
	return (DERR_NOERROR);
}

int DButton::GetState (int _id)
{
	ButtonListTag *ptr;

	if ((ptr=Find(_id)) == NULL) {
		return (-1);
	}
	return (ptr->state);
}

int DButton::Draw (int _id)
{
	ButtonListTag *ptr=Find(_id);
	if (ptr)
		return (Render(ptr));

	return (DERR_INVALID_ID);
}

void DButton::DrawAll()
{
	ButtonListTag *ptr=ButtonList;

	while (ptr) {
		Render(ptr);
		ptr=ptr->next;
	}

}

int DButton::CheckForHit (int x, int y)
{
	ButtonListTag *ptr = ButtonList;

	while (ptr) {
		if (  (ptr->x <= x && ptr->x+ptr->w >=x)  &&
				(ptr->y <= y && ptr->y+ptr->h >=y))
			return (ptr->id);
		ptr=ptr->next;
	}
	return (0);

}


ButtonListTag * DButton::Find(int _id)
{
	ButtonListTag *ptr;
	ptr=ButtonList;

	while (ptr) {
		if (ptr->id == _id) {
			return (ptr);
		}
		ptr=ptr->next;
	}
	return (NULL);
}

int DButton::SetLocation (int _id, int _x, int _y)
{
	ButtonListTag *ptr;

	if (!(ptr=Find(_id))) {
		return (DERR_INVALID_ID);
	}

	ptr->x=_x;
	ptr->y=_y;
	return 0;
}
