/*
	File:           NicePart.cpp

	Contains:       Implementation of the SOM class NicePart

	Written by:     Jeff Hanson     and PartMaker

	Copyright:       1995 by Novell, Inc., all rights reserved.

*/

#ifndef _ALTPOINT_
#include <AltPoint.h>
#endif

#ifndef _PLFMDEF_
#include <PlfmDef.h>
#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _ODUTILS_
#include "ODUtils.h"
#endif

#ifndef _FOCUSLIB_
#include "FocusLib.h"
#endif

#ifndef _STDDEFS_
#include <StdDefs.h>
#endif

#ifndef _FACETLIST_
#include <FacetLst.h>
#endif

#ifndef _ITEXT_
#include <IText.h>
#endif

#ifndef _ORDCOLL_
#include <OrdColl.h>
#endif

#ifndef SOM_ODCmdDefs_xh
#include <CmdDefs.xh>
#endif

#ifndef SOM_ODStdProps_xh
#include <StdProps.xh>
#endif

#ifndef SOM_ODStdTypes_xh
#include <StdTypes.xh>
#endif

#ifndef SOM_ODFrame_xh
#include <Frame.xh>
#endif

#ifndef SOM_ODFacet_xh
#include <Facet.xh>
#endif

#ifndef SOM_ODFrameFacetIterator_xh
#include <FrFaItr.xh>
#endif

#ifndef SOM_ODArbitrator_xh
#include <Arbitrat.xh>
#endif

#ifndef SOM_ODCanvas_xh
#include <Canvas.xh>
#endif

#ifndef SOM_ODPstObj_
#include <PstObj.xh>
#endif

#ifndef SOM_ODShape_xh
#include <Shape.xh>
#endif
											
#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_ODFoci_xh
#include <Foci.xh>
#endif

#ifndef SOM_ODStorageUnit_xh
#include <StorageU.xh>
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef SOM_ODWindow_xh
#include <Window.xh>
#endif

#ifndef SOM_ODWinStat_xh
#include <WinStat.xh>
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODMenuBar_xh
#include "MenuBar.xh"
#endif

#ifndef SOM_ODFocusSet_xh
#include <FocusSet.xh>
#endif

#ifndef SOM_ODInfo_xh
#include <Info.xh>
#endif

#ifndef SOM_ODPartWrapper_xh
#include "PartWrap.xh"
#endif

#ifndef SOM_ODPart_xh
#include <Part.xh>
#endif

#ifndef _NICEPART_
#include "nicepart.h"
#endif

#define SOM_Module_nicepart_Source
#define VARIABLE_MACROS
#include <NicePart.xih>


//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Novell_NicePart constructor
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartsomInit(Novell_NicePart *somSelf)
{

//{SS} Add asm statement for a debug breakpoint.
#ifdef _DEBUG
//        _asm {int 03};
#endif

    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

    Novell_NicePart_parent_ODPart_somInit(somSelf);

	_fDirty                 = kODFalse;
	_fWindowID              = 0;
	_fSession               = kODNULL;
	_fMenuBar               = kODNULL;
	_fFacets                = kODNULL;
	_haveModalFocus 		= kODFalse;
	_haveFocus 				= kODFalse;
	_newRect                = kODNULL;
	_theColor               = RGB(0, 0, 255 );
	_theColorID             = IDM_BLUE;
	_colorRects             = new OrderedCollection;
}

//==============================================================================
// Novell_NicePart destructor
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartsomUninit(Novell_NicePart *somSelf)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODDeleteObject(_fFacets);

	if (_colorRects != kODNULL)
	{
		OrderedCollectionIterator       contentsIter(_colorRects);
		ColorRect* CR;
	
		for (CR = (ColorRect*) contentsIter.First();
				contentsIter.IsNotComplete();
				CR = (ColorRect*) contentsIter.Next())
		{
			delete CR->Rect;
			delete CR;
		}

		delete _colorRects;
	}

    Novell_NicePart_parent_ODPart_somUninit(somSelf);
}

//==============================================================================
// Novell_NicePartInitPart
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartInitPart(Novell_NicePart *somSelf, Environment *ev,
		ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	if (somSelf->IsInitialized(ev))
		return;
	
	somSelf->InitPersistentObject(ev, storageUnit);
	
	_fPartWrapper = partWrapper;            

	somSelf->MyCommonInitPart(ev);          

	storageUnit->AddProperty(ev, kODPropContents)->AddValue(ev, kNicePartKind);
		// For your edification, AddProperty & AddValue 
		// implicitly focus.  Check the API for more info.

	lstrcpy(_fTextData, "NicePartPart content");

	// Initialize your other fields here.

	_fDirty = kODTrue;
}

//==============================================================================
// Novell_NicePartInitPartFromStorage
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartInitPartFromStorage(Novell_NicePart *somSelf, Environment *ev,
		ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);
	if (somSelf->IsInitialized(ev))
		return;

	somSelf->InitPersistentObjectFromStorage(ev, storageUnit);
	
	_fPartWrapper = partWrapper;            

	somSelf->MyCommonInitPart(ev);
	storageUnit->Focus(ev, kODPropContents, kODPosSame,
					   kNicePartKind, 0, kODPosSame);
	short   theSize = (short)storageUnit->GetSize(ev);
	storageUnit->GetValue(ev, theSize, _fTextData);
	_fTextData[theSize] = 0;
}

//==============================================================================
// Novell_NicePartMyCommonInitPart
//==============================================================================

SOM_Scope void SOMLINK Novell_NicePartMyCommonInitPart(Novell_NicePart *somSelf, Environment* ev)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	_fSession = _fPartWrapper->GetStorageUnit(ev)->GetSession(ev);
		// As your part grows, add your initialization that is common
		// between InitPart and InitPartFromStorage here.
		// Note that GetStorageUnit can be used, since just prior to
		// calling this method, InitPart calledInitPersistentObject or
		// InitPartFromStorage called InitPersistentObjectFromStorage.

	_fFacets = new FacetList;

	//{SWS} Create foci for selection, menu, keyboard, and modal focus.
	_fSelectionFocus = _fSession->Tokenize(ev, kODSelectionFocus);
	_fMenuFocus      = _fSession->Tokenize(ev, kODMenuFocus);
	_fKeyFocus       = _fSession->Tokenize(ev, kODKeyFocus);
	_fModalFocus     = _fSession->Tokenize(ev, kODModalFocus);

	//{SWS} Create a focus set with keyboard, menu, and selection foci so that these foci 
	//{SWS} may be requested as an atomic unit.
	_fFocusSet = new ODFocusSet();
	_fFocusSet->InitFocusSet(ev);
	_fFocusSet->Add(ev, _fKeyFocus);
	_fFocusSet->Add(ev, _fMenuFocus);
	_fFocusSet->Add(ev, _fSelectionFocus);

	//{SWS} Create an additional menu for color and add it to the end of the base menu.
	_fMenu.menu = CreatePopupMenu();
	strcpy (_fMenu.strMenu, "Color");
	if (!_fMenu.menu)
		OutputDebugStr("NicePart::MyCommonMyInitPart -- couldn't create menu.");
			// Note that THROW won't work with SOM.  Therefore we are using debug messages
			// for these types of errors.  

	AppendMenu(_fMenu.menu, MF_STRING | MF_ENABLED, IDM_GRAY,   "Gray");
	AppendMenu(_fMenu.menu, MF_STRING | MF_ENABLED, IDM_RED,    "Red");
	AppendMenu(_fMenu.menu, MF_STRING | MF_ENABLED, IDM_GREEN,  "Green");
	AppendMenu(_fMenu.menu, MF_STRING | MF_ENABLED, IDM_YELLOW, "Yellow");
	AppendMenu(_fMenu.menu, MF_STRING | MF_ENABLED, IDM_BLUE,        "Blue");
	AppendMenu(_fMenu.menu, MF_STRING | MF_ENABLED, IDM_MAGENTA,"Magenta");
	AppendMenu(_fMenu.menu, MF_STRING | MF_ENABLED, IDM_CYAN,        "Cyan");
	AppendMenu(_fMenu.menu, MF_STRING | MF_ENABLED, IDM_WHITE,       "White");

	_fMenuBar = _fSession->GetWindowState(ev)->CopyBaseMenuBar(ev);
	_fMenuBar->AddMenuLast(ev, (ODMenuID)"Color", &_fMenu, _fPartWrapper);

	//{SWS} Check the current color in the color menu.
	CheckMenuItem(_fMenu.menu, IDM_BLUE, MF_CHECKED);
}

//==============================================================================
// Novell_NicePartFulfillPromise
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartFulfillPromise(Novell_NicePart *somSelf, Environment *ev,
		ODStorageUnitView* promiseSUView)

// Fulfills a previously made promise by providing the actual
// data the promise represents.
//
// The promiseSUView is a view into the same storage unit value
// that is created by SetPromiseValue. The information about the
// promise is encoded in the promiseSUView in the Part Handler's
// own internal format. The promise data is written into the
// promiseSUView replacing the data stored in the part handler's
// format.
//
// When the promise was made, a record of it was kept by this part.
// The promiseSUView contains the part's information for that promise.
// The part uses the data in the promiseSUView to determine which
// data to move/copy. The part then writes the data into the
// promiseSUView.
//
// The format of a promise is determined by the part. The only
// restriction is that a promise must be able to be written to
// a Storage Unit Value.
//
// The destination part does not even know that the fulfilment
// of a promise is taking place.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(promiseSUView);
}

//==============================================================================
// Novell_NicePartDropCompleted
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDropCompleted(Novell_NicePart *somSelf, Environment *ev,
		ODPart* destPart,
		ODDropResult dropResult)

// Notifies the part that the drop is completed.
//
// Called by the dragAndDrop object.
//
// DropCompleted is a peculiar method. If DragAndDrop::StartDrag is
// synchronous, the return code to DragAndDrop::StartDrag is the
// drop result. Part::DropCompleted does not need to be called.
// However, if it is required that DragAndDrop::StartDrag returns
// immediately, there needs to be a way to notify the result of the
// drop. Before calling this method, you must ensure that the part
// previously started an asynchronous drag.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(destPart);
ODUnused(dropResult);
}

//==============================================================================
// Novell_NicePartDragEnter
//==============================================================================

SOM_Scope ODDragResult  SOMLINK Novell_NicePartDragEnter(Novell_NicePart *somSelf, Environment *ev,
		ODDragItemIterator* dragInfo,
		ODFacet* facet,
		ODPoint* where)

// Activates the part used to track the drag.
//
// Called by the facet object.
//
// The part should display a drag target border within the facet.
// During drag tracking (DragEnter, DragWithin) the part should
// never attempt to read data from any of the storage units supplied
// by the iterator. The part should only inspect the type of the
// dragged data. Before calling this method, you must ensure that
// the part is ready to receive DrawWithin messages.
//
// DragEnter() is called when the mouse enters a facet.  The part
// should examine the available data types of the dragged items
// using the ODDragItemIterator passed in.  If the part can handle
// a drop of the dragged object, it should provide the appropriate
// feedback (e.g., adorning the droppable frame, changing the cursor).
// If the destination part cannot handle the data types, nothing
// should be done.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

	return kODFalse;
}

//==============================================================================
// Novell_NicePartDragWithin
//==============================================================================

SOM_Scope ODDragResult  SOMLINK Novell_NicePartDragWithin(Novell_NicePart *somSelf, Environment *ev,
		ODDragItemIterator* dragInfo,
		ODFacet* facet,
		ODPoint* where)

// Tracks the drag operation, and provides graphical feedback
// regarding possible drop targets.
//
// This method highlights the appropriate content to provide
// feedback about potential drop targets, based on type of dragged
// data. It gets the type information out of the dragInfo. During
// drag tracking (DragEnter, DragWithin) the part should never
// attempt to read data from any of the storage units supplied by
// the iterator. The part should only inspect the type of the
// dragged data. Before calling tis method, you must ensure that
// the part was previously activated via DragEnter().
//
// DragWithin() is called continuously when the mouse is still in
// the facet. This allows the part to do any processing desired.
// One good example is when the frame has several hot spots where
// objects can be dropped. If the mouse is not over these hot spots,
// the cursor may need to be changed to reflect that the no
// dropping can be done there even though it is still in a
// droppable frame. Again, a ODDragItemIterator is passed in so
// that the part can examine the availabe data types of the dragged
// objects.
//
// DragWithin() also provides a chance for the part to examine the
// state of the machine. For example, some part may want to find
// out whether the modifier keys are down or not.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

	return kODFalse;
}

//==============================================================================
// Novell_NicePartDragLeave
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDragLeave(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)

// Signals that the drag operation is complete, and so
// deactivates the part from drag tracking.
//
// This method un-highlights any content previously highlighted
// during drag tracking. It also removes the drag target border.
// Before calling this method you must ensure that the part was
// previously activated via DragEnter().  After executing this
// method successfully, the part is no longer active, and cannot
// receive further DragWithin() or Drop() messages.
//
// DragLeave() is called when the mouse leaves a droppable frame.
// This allows the part to clean up after a drag within it
// (e.g., removing adornment on the frame, changing the cursor
// back to its original form).

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(facet);
ODUnused(where);
}

//==============================================================================
// Novell_NicePartDrop
//==============================================================================

SOM_Scope ODDropResult  SOMLINK Novell_NicePartDrop(Novell_NicePart *somSelf, Environment *ev,
		ODDragItemIterator* dropInfo,
		ODFacet* facet,
		ODPoint* where)

// Transfers the dragged data into this part.
//
// Called by the facet object.
//
// Respond to the Drop operation. This might involve moving or
// copying data in to the part, or some other response entirely.
// However, the response should use the data returned from the
// dropInfo iterator to perform the operation. Before calling
// this method, you must ensure that the part was previously
// activated via DragEnter().
//
// Don't forget whether the drop is a move or a copy.
//
// Drop() is called when the mouse is released within a part which
// owns the facet. The part can then figure out whether it can
// receive the dragged object using the ODDragItemIterator passed
// in. The following is a sample code fragment for incorporating
// text into a part.
//
// The destination part should return an appropriate ODDropResult
// from Drop(). This result tells the source part (via the system)
// whether the drop is accepted.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(dropInfo);
ODUnused(facet);
ODUnused(where);

	return kODDropFail;
}

//==============================================================================
// Novell_NicePartContainingPartPropertiesChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartContainingPartPropertiesChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame,
		ODStorageUnit* propertyUnit)

// Used by ContainingPart to inform the contained part of
// changes to the content properties of that object within
// the containing parts content model that encapsulates the
// embedded frame.
//
// This method inspects *propertyUnit* for properties that this
// part can understand. Where applicable, it incorporate those
// properties into part's content data. It ignores inapplicable
// properties, without signalling an error.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);
ODUnused(propertyUnit);
}

//==============================================================================
// Novell_NicePartGetContainingPartProperties
//==============================================================================

SOM_Scope ODStorageUnit*  SOMLINK Novell_NicePartGetContainingPartProperties(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Used by an embedded part to create a storage unit and write
// properties that the containing part associates with the
// embedded frame into it, before returning it. 
//
// Called by an embedded part.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);

	OutputDebugStr("NicePart::GetContainingPartProperties -- shouldn't be here.");

	return kODNULL;
}

//==============================================================================
// Novell_NicePartRevealFrame
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_NicePartRevealFrame(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* revealShape)

// Asks a part to make an embedded frame visible.
//
// Called by an embedded part.
//
// This method scrolls one of this part's display frame's to make
// the embedded frame visible therein. If this part has no visible
// frames, it asks a containing part to reveal one of them. If no
// display frames for the part currently exist, or if this part's
// containing frame can't reveal the display frame, it opens a frame
// in a new window.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(embeddedFrame);
ODUnused(revealShape);

	OutputDebugStr("NicePart::RevealFrame -- shouldn't be here.");

	return kODFalse;
}

//==============================================================================
// Novell_NicePartEmbeddedFrameSpec
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartEmbeddedFrameSpec(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODObjectSpec* spec)

// Creates an object specifier for the embedded frame.
//
// If this part is itself embedded, this method asks its containing
// part for the specifier for the part's display frame, then
// concatenates the specifier for that embedded frame.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(embeddedFrame);
ODUnused(spec);

	OutputDebugStr("NicePart::EmbeddedFrameSpec -- shouldn't be here.");
}

//==============================================================================
// Novell_NicePartCreateEmbeddedFramesIterator
//==============================================================================

SOM_Scope ODEmbeddedFramesIterator*  SOMLINK Novell_NicePartCreateEmbeddedFramesIterator(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Creates an object that will iterate over the frames that
// are embedded within a display frame of this part.
//
// To indicate all the display frames, use kODNull for the frame
// parameter.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);

	OutputDebugStr("NicePart::CreateEmbeddedFramesIterator -- shouldn't be here.");

	return kODNULL;
}

//==============================================================================
// Novell_NicePartDisplayFrameAdded
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDisplayFrameAdded(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Tells a part to add *frame* as one of its display frames.
//
// This method is only called by frame objects during their
// initialization.  Same for RemoveDisplayFrame() and
// CloseDisplayFrame().
//
// The part must record *frame* in whatever internal structures it
// uses to remember its display frames. The new frame will carry a
// suggested viewType and presentation information. The part should
// look at those settings, and decide if it can support them; if not,
// it should update those settings in the frame to reflect a default
// presentation that it can support. Note that the part must support
// the required set of standard viewTypes (frame, icon, small icon,
// thumbnail, etc.). The part will then create the appropriate
// partInfo data and store it in the frame. This data allows the part
// to distinguish the frame from its other display frames, and is
// also a handy place to store other view-related information.
//
// Add the new display frame to the parts list of its display frames.
// This list, like the parts other internal structures, is completely
// hidden from OpenDoc. The developer may represent this list any way
// he chooses. The simplest of parts may be able to do without such a
// list, but most parts will require it.
//
// Validate the viewType and presentation of the new frame. The part
// must support the required set of view types. Other kinds of view
// types or presentations are optional. The part should inspect these
// values and correct them if necessary. See the recipe for View Types
// and Presentations for more detail.
//
// Add partInfo to the frame. The partInfo field of a frame is a
// convenient place for a part to store information about that view of
// itself. It can be anything from a simple ID to a pointer to a
// complicated structure or a helper object. The partInfo for a frame
// is stored in the storage unit for the frame, not the part. If the
// part has many frames of which only a few are internalized, only the
// partInfo of those frames will be internalized and take up memory.
//
// The display frames need not be internalized until needed and will be
// done by the containing part. ???

{
	Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODUnused(frame);
}

//==============================================================================
// Novell_NicePartDisplayFrameRemoved
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDisplayFrameRemoved(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Removes the frame from the list of display frames.
//
// Called by Frame::Remove().
//
// This method makes whatever other adjustments are necessary
// to deal with removing one of the presentations. This includes
// removing any frames embedded within this display frame.
// Before calling this method, you must ensure that the frame
// has no facets.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet, frame);
	_haveFocus=kODFalse;
}

//==============================================================================
// Novell_NicePartDisplayFrameConnected
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDisplayFrameConnected(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_NicePartDisplayFrameClosed
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDisplayFrameClosed(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Informs a part that one of its display frames is closing.
//
// Called by the frame object.
// The part should remove *frame* from its list of display frames,
// call Frame::Close() on any frames that are embedded within that
// frame, and then release the frame.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet, frame);
	_haveFocus=kODFalse;
}

//==============================================================================
// Novell_NicePartAttachSourceFrame
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartAttachSourceFrame(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame,
		ODFrame* sourceFrame)

// Called by the object that requested creation of a frame,
// immediately after the creation of the frame.
//
// Calling this method associates a *source frame* with a display
// frame of a part. This tells the part to keep two or more of its
// display frames synchronized.
//
// A part will receive this call just after a display frame has
// been added. Attaching a source frame should cause the display
// frame to look identical to it. If presentations differ, it
// causes the display frame to be equivalent to it. This causes
// duplication of the embedded frames, and ensures that the view
// in one frame is updated when content in the other is changed.
// Before calling this method, you must ensure that both frame
// and sourceFrame are display frames of the part.
//
// The part being displayed should take whatever action necessary
// to synchronize the frames. As a minimum, if the two frames are
// the same kind of presentation, it should duplicate embedded
// frames in one frame into the other. 

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);
ODUnused(sourceFrame);
}

//==============================================================================
// Novell_NicePartFrameShapeChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartFrameShapeChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// ***Notifies the part that the frame shape of one of its
// display frames has been changed by its containing part.
//
// Called by Frame::ChangeFrameShape.
//
// The part should take whatever actions are necessary to respond
// to the new shape. It may need to re-layout its content, change
// its used shape, resize its embedded frames, or something else.
// It also has the option of turning around and asking the frame
// for a different frame shape via RequestFrameShape, though it
// must be able to handle the shape it is given. If the size of
// the frame is not sufficient, the part may ask the containing
// part for a continuation frame via CreateEmbeddedFrame.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);
	
	ODShape*        frmShape = somSelf->MyGetFrameShape(ev, frame);
	frame->RequestFrameShape(ev, frmShape, kODNULL);
	frmShape->Release(ev);
	somSelf->MyAdjustFacets(ev, frame);
	frame->Invalidate(ev, kODNULL, kODNULL);
	frame->InvalidateActiveBorder(ev);
}

//==============================================================================
// Novell_NicePartViewTypeChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartViewTypeChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Notifies the part that the viewType of one of its
// frames has been changed.
//
// Parts must support all standard view types.
// And they are ... ???

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_NicePartPresentationChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartPresentationChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Notifies the part that the presentation kind of one
// of its frames has been changed.
//
// Called by Frame::ChangeViewType().
//
// The part should examine the new view type via
// frame->GetViewType(). If the part does not support that kind
// of view type, it should correct the frame's viewType using
// frame->SetViewType(). Note that parts MUST support the
// standard set of view types (se HI spec). The part should then
// adjust its display in the display frame to be of the new view
// type.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_NicePartSequenceChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartSequenceChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Informs the part that the sequencing of a group of its
// display frames has been changed.
//
// Called by containing part.
//
// The containing part of frame should call this when adding a new
// frame to the group or re-ordering the frames in the group. A
// single frame of the group is passed as an argument to indicate
// which group of which containing frame has been changed.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_NicePartWritePartInfo
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartWritePartInfo(Novell_NicePart *somSelf, Environment *ev,
		ODPtr partInfo,
		ODStorageUnitView* storageUnitView)

// Externalizes the frame's partInfo data onto the frame's
// storage unit.
//
// Called by the frame object.
//

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(partInfo);
ODUnused(storageUnitView);
}

//==============================================================================
// Novell_NicePartReadPartInfo
//==============================================================================

SOM_Scope ODPtr  SOMLINK Novell_NicePartReadPartInfo(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame,
		ODStorageUnitView* storageUnitView)

// Internalizes the partInfo for a display frame of this part.
//
//
// Called by the frame object.
//
// The data for the partInfo is stored in a value in the frame's
// storage unit, specified by the suView parameter. It gets the
// data from out of the value, and places it in a block of memory.
// It then returns the memory block to the frame for it to hold.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);
ODUnused(storageUnitView);

	return kODNULL;
}

//==============================================================================
// Novell_NicePartOpen
//==============================================================================

SOM_Scope ODID  SOMLINK Novell_NicePartOpen(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Creates and opens a presentation of the part in a frame
// in a new window.
//
// This method adds this part as the root part of the window.
// It bases the presentation in the new frame on the presentation
// in the old frame, or on a default presentation if there
// is no old frame.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODWindow*       window = kODNULL;

	if (frame)
		window = _fSession->GetWindowState(ev)->GetWindow(ev, _fWindowID);

	if (window == kODNULL)
	{
		window = somSelf->MyMakeWindow(ev, frame);
		_fWindowID = window->GetID(ev);
		window->Open(ev);
		window->Show(ev);
	}

	window->Select(ev);

	return window->GetID(ev);
}

//==============================================================================
// Novell_NicePartRequestEmbeddedFrame
//==============================================================================

SOM_Scope ODFrame*  SOMLINK Novell_NicePartRequestEmbeddedFrame(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* containingFrame,
		ODFrame* baseFrame,
		ODShape* frameShape,
		ODPart* embedPart,
		ODTypeToken viewType,
		ODTypeToken presentation,
		ODBoolean isOverlaid)

// Asks the part to create a new frame and embed a part in it.
//
// This is only requested by embedded parts which want additional
// frames in which to display in the same containing part.
//
// If this part is a containing part, it should ask the draft to
// create a new frame, and embed the frame in its content.
// *baseFrame* is another display frame of the same part, already
// embedded in the same containing part. The frameShape parameter
// is relative to the frame coordinate system of the baseFrame.
// The containing part decides if it can fulfill the requests for
// frameShape. - if not, it can create the frame where it wants
// and with the shape it chooses. The containing part should assign
// the new frame to the same frameGroup as the baseFrame. If
// isOverlaid is true, the new frame should float above the part's
// content, and should not have to negotiate for space with the part.
// The viewType and presentation are just passed through to
// Draft::CreateFrame().
//
// Note that RequestEmbeddedFrame should only be called by an embedded
// part on its containing part in order to get a sibling frame.  That
// is why this call takes a baseFrame parameter.  The baseFrame must
// already be embedded inside the part receiving the
// RequestEmbeddedFrame message.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(containingFrame);
ODUnused(baseFrame);
ODUnused(frameShape);
ODUnused(embedPart);
ODUnused(viewType);
ODUnused(presentation);
ODUnused(isOverlaid);

	OutputDebugStr("NicePart::RequestEmbeddedFrame -- shouldn't be here.");

	return kODNULL;
}

//==============================================================================
// Novell_NicePartRemoveEmbeddedFrame
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartRemoveEmbeddedFrame(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame)

// Removes a frame used for viewing an embedded part.
//
// Called by an embedded part.
//
// It is called by an embedded part to indicate it no longer
// needs the frame to display itself.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(embeddedFrame);

	OutputDebugStr("NicePart::RemoveEmbeddedFrame -- shouldn't be here.");
}

//==============================================================================
// Novell_NicePartRequestFrameShape
//==============================================================================

SOM_Scope ODShape*  SOMLINK Novell_NicePartRequestFrameShape(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* frameShape)

// Used by an embedded part to ask for a change in the 
// shape of its frame.
//
// Called by Frame::RequestFrameShape().
//
// This method decides what new shape to give the embedded frame,
// using the requested *frameShape* as a guideline. It then
// answers with what shape is actually granted as the return value.
// The requestor must abide by the returned shape, though it may
// make further requests for different shapes or additional frames.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(embeddedFrame);
ODUnused(frameShape);

	OutputDebugStr("NicePart::RequestFrameShape -- shouldn't be here.");

	return kODNULL;
}

//==============================================================================
// Novell_NicePartUsedShapeChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartUsedShapeChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame)

// Informs a containing part that the used shape of one of
// its embedded frames has changed.
//
// Called by Frame::ChangeUsedShape().
//
// Containing parts that have arranged their content to conform
// to the used shape of an embedded frame (as in text wrapping)
// will need to adjust the layout of that content for the new
// used shape.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(embeddedFrame);
}

//==============================================================================
// Novell_NicePartAdjustBorderShape
//==============================================================================

SOM_Scope ODShape*  SOMLINK Novell_NicePartAdjustBorderShape(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* embeddedFacet,
		ODShape* shape)

// Adjusts the shape of the active frame border of an embedded
// frame.
//
// Called by the arbitrator object.
//
// The *shape* parameter specifies the requested shape. The
// return value specifies that shape as it is obscured by the
// other contents of this part.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(embeddedFacet);

	return shape;
}

//==============================================================================
// Novell_NicePartFacetAdded
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartFacetAdded(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	// Add new facet to list of current facets.

	_fFacets->Add(facet);

	ODFrame*        frame = facet->GetFrame(ev);
	ODShape*        frmShape = somSelf->MyGetFrameShape(ev, frame);
	frame->RequestFrameShape(ev, frmShape, kODNULL);
	frmShape->Release(ev);
		// ** First, MyGetFrameShape is called to calculate the frame
		// shape we want.  However, we might not get it, due to the
		// needs/constraints of the containing part.  Therefore, after
		// calculating what we want, we see if we can get it by calling
		// RequestFrameShape.
		// RequestFrameShape either returns us what we passed it, or
		// returns something else because it thinks it knows best.
		// Either way, we then proceed with the returned result.
		// Note that this means that we have to be prepared to deal
		// with a frame shape other than we desire.

	somSelf->MyAdjustFacets(ev, frame);
		// Given a new negotiated frame shape, adjust our facets based
		// on it.  That's all there is to it.

	if (frame->IsRoot(ev)) 
	{
		ODBoolean succeeded = kODFalse;
		succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame);
		if (succeeded)
		{
			somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
			somSelf->FocusAcquired(ev, _fMenuFocus, frame);
			somSelf->FocusAcquired(ev, _fKeyFocus, frame);
		}
	}
}

//==============================================================================
// Novell_NicePartFacetRemoved
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartFacetRemoved(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	_fFacets->Remove(facet);
		// This just removes the reference from our facet list.

	ODFrame*        frame = facet->GetFrame(ev);
	ODShape*        frmShape = somSelf->MyGetFrameShape(ev, frame);
	frame->RequestFrameShape(ev, frmShape, kODNULL);
	frmShape->Release(ev);
	somSelf->MyAdjustFacets(ev, frame);
		// ***This is here in case losing a facet means that we need to recalculate
		// the frame.  This would occur if the part added some of its own facets,
		// beyond the single facet that is automatically given to a frame.  If
		// you don't have your own additional facets, then this code renegotiates
		// the frame shape for no reason, since the frame will be going away
		// immediately afterwards (after the last/only facet is removed).
}

//==============================================================================
// Novell_NicePartCanvasChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartCanvasChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet)

// Notifies the part that one of its facets has been moved to
// image on a different canvas.
//
// Called by the facet object.
//
// The part must update any internal state necessary for
// compliance with this method.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(facet);
}

//==============================================================================
// Novell_NicePartGeometryChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartGeometryChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet,
		ODBoolean clipShapeChanged,
		ODBoolean externalTransformChanged)

// Called by a facet of the part to inform it that the clipping
// shape and/or external transform of that facet has changed.
//
// Called by the facet object.
//
// The part should use the new clip shape for display from now
// on. Parts that display only in response to update events don't
// need to do anything special, provided they check the clip
// shape each time they draw. Parts that display asynchronously
// (like clocks, movies, etc.) must notice their new clipping and
// limit their display accordingly.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(facet);
ODUnused(clipShapeChanged);
ODUnused(externalTransformChanged);
}

//--------------------------------------------------------------------
// Novell_NicePartMyWantResizable
//--------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK Novell_NicePartMyWantResizable(Novell_NicePart *somSelf, Environment *ev)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	return kODFalse;
		// used in MyMakeWindow() to toggle some parameters
}


//--------------------------------------------------------------------
// Novell_NicePartMyMakeWindow
//--------------------------------------------------------------------

SOM_Scope ODWindow*     SOMLINK Novell_NicePartMyMakeWindow(Novell_NicePart *somSelf, Environment *ev, ODFrame* sourceFrame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODPlatformWindow        platformWindow = kODNULL;
	ODWindow*                       window = kODNULL;
	
	platformWindow =  _fSession->GetWindowState(ev)->CreatePlatformWindow(ev, kODFalse, WS_CHILD | WS_CLIPSIBLINGS);

	window = _fSession->GetWindowState(ev)->RegisterWindow
	(
		ev,
		platformWindow,                                                         // newWindow
		kODNULL,                                                                        // frameType
		(sourceFrame == kODNULL),                                       // isRootWindow
		somSelf->MyWantResizable(ev),                           // isResizable
		kODFalse,                                                                       // isFloating
		kODTrue,                                                                        // shouldSave
		_fPartWrapper,                                                          // rootPart
		_fSession->Tokenize(ev, kODViewAsFrame),        // viewType
		kODNullTypeToken,                                                       // presentation
		sourceFrame                                                                     // sourceFrame
	);

	return window;
}

//==============================================================================
// Novell_NicePartDraw
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDraw(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet,
		ODShape* invalidShape)

// Draws the part in the facet, updating the portion of the
// facet in the invalidShape.
//
// Called by the facet object.
//
// The part should draw itself on the facet's canvas. The part
// must examine its canvas' isDynamic flag to determine if it
// will be drawing on the screen or to a printer, and then draw
// itself appropriately.
//
// Draw the part in the given facet. Only the portion in the
// invalidShape needs to be drawn.
//
// There are several steps a part needs to take to perform the
// imaging.
// 1) The part should look at the given facet and its frame.
//    Both the frame and the facet may have some partInfo that
//    the part has placed there, which the part can use to
//    decide how it will display itself.  The frame also has
//    viewType and presentation fields, which indicate what kind
//    of view of the part should display.
// 2) The part should examine its canvas to see how it should
//    be imaged. The canvas can be obtained from the facet via
//    ODFacet::GetCanvas(). If the canvas' isDynamic flag is
//    kODTrue, the part is imaging onto a dynamic device like
//    a CRT; otherwise, it is imaging to a static device like
//    a printer. The part will probably display its content
//    differently for static and dynamic views. For instance,
//    it should not display scroll bars on a static canvas.
// 3) The part must make sure the platform graphics system is
//    prepared to draw into the correct context for the facet.
//    On the Macintosh using QuickDraw, it is necessary to call
//    SetPort() for the appropriate canvas, and set up other
//    attributes of the drawing environment. A FocusLib library
//    is supplied to help focus drawing commands to a facet.
//    Make sure to clip to the facet's clipShape (FocusLib
//    does this for you).
// 4) Draw the part's contents.
// 5) Restore the old graphics environment.
//
// Part editors may sometimes need to display their parts
// asynchronously, that is, not in response to a ::Draw() call.
// This process is very similar to the basic drawing recipe,
// with minor modifications.
// 1) Determine which of the part's frames should be drawn. A part
//    may have multiple display frames, and more than one may need
//    updating. Parts store their display frames in whatever way
//    they want, so we can't tell you how to find them here.
// 2) For each frame being displayed, all facets must be drawn.
//    ODFrame::CreateFrameFacetIterator() returns an iterator
//    which will list all the facets of a frame. Draw the part's
//    contents in each of these facets, using the recipe above.
// 3) After drawing in a facet, call ODFacet::DrawnIn() on it to
//    tell it you've drawn in it asynchronously. If the facet is
//    on an offscreen canvas, this lets it get copied into the window. 

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	HDC     hDC;
	CFocus  foc(facet, invalidShape, &hDC);

	ODFrame*        frame     = facet->GetFrame(ev);
	ODShape*        usedShape = frame->GetUsedShape(ev, kODNULL);
	RgnHandle       rgn       = usedShape->GetWinRegion(ev);

	usedShape->Release(ev);

	Rect            rct;  
	RgnHandle       oldClip = kODNULL;
	RgnHandle       newClip = kODNULL;

	GetRgnBox(rgn, &rct);

	HBRUSH  fillBrush = CreateSolidBrush(RGB(255, 255, 255 ));


	if (frame->IsRoot(ev))
	{
		oldClip = ::CreateRectRgn(0, 0, 0, 0);
		::GetClipRgn(hDC, oldClip);
		Rect    r;
		::GetClientRect(facet->GetWindow(ev)->GetPlatformWindow(ev), &r);
		newClip = ::CreateRectRgnIndirect(&r);
		::SelectClipRgn(hDC, newClip);
		::FillRect(hDC, &r, fillBrush);
	}
	else 
	{       
		::FillRgn(hDC, rgn, fillBrush);
	}

	// Do the Rects inside first so that the border of NicePart remains intact

	if(_colorRects)         // if there are any color rects to be drawn
	{
		OrderedCollectionIterator* CRectList = _colorRects->CreateIterator();
		
		// Irerate through the collection of ColorRects
		for(ColorRect* cr = (ColorRect*)CRectList->First();
			CRectList->IsNotComplete();
			cr = (ColorRect*)CRectList->Next() )
			{
				// Fill in the Rect
				somSelf->FillODRect(ev, cr->Rect, hDC, cr->color);
				
				// Draw the Border around the rect
				somSelf->DrawODRect(ev, cr->Rect, hDC, PS_SOLID, R2_NOTXORPEN); 
			}
	}


	HPEN    framePen = ::CreatePen(PS_SOLID, 2, RGB(0, 0, 0));
	HGDIOBJ oldPen = ::SelectObject(hDC, framePen); 
	
	// Delete white brush
	::DeleteObject((HGDIOBJ)fillBrush);

	// Create black brush
	fillBrush = CreateSolidBrush(RGB(0, 0, 0));

	// Put Frame on Me after Color rects are drawn
	::FrameRect(hDC, &rct, fillBrush);

	::SelectObject(hDC, oldPen);
	::DeleteObject((HGDIOBJ)framePen);

	::DeleteObject((HGDIOBJ)fillBrush);

	if (oldClip)
	{
		::SelectClipRgn(hDC, oldClip);
		::DeleteObject((HGDIOBJ)oldClip);
		::DeleteObject((HGDIOBJ)newClip);
	}
		
}

//==============================================================================
// Novell_NicePartDrawODRect
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDrawODRect(Novell_NicePart *somSelf, Environment *ev,
		ODRect* theRect,
		ODPlatformCanvas hDC,
		int style,
		int mode)
{

	int oldmode=kODNULL;

    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	Rect winRect;
	HPEN framePen = ::CreatePen(style, 1, RGB(0, 0, 0)); // Black border
	HGDIOBJ oldPen = ::SelectObject(hDC, framePen); 
	
	// Set the Pen Draw Mode
	oldmode=SetROP2(hDC, mode);
 
	// Convert the ODRect to a Windows Rect
	theRect->AsWinRect(winRect);

	// Draw the Rectangle
	::Rectangle(hDC, winRect.left, winRect.top,
						 winRect.right, winRect.bottom);

	// if we changed the pen draw mode set it back
	if(oldmode)
		SetROP2(hDC, oldmode);

	::SelectObject(hDC, oldPen);
	::DeleteObject((HGDIOBJ)framePen);

}


//==============================================================================
// Novell_NicePartFillODRect
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartFillODRect(Novell_NicePart *somSelf, Environment *ev,
		ODRect* theRect,
		ODPlatformCanvas hDC,
		COLORREF color)
{

    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	HBRUSH  fillBrush = CreateSolidBrush(color);

	Rect winRect;

	// Convert the ODRect to a Windows Rect
	theRect->AsWinRect(winRect);

	// Fill in the Rect with the color selected in the menu
	::FillRect(hDC, &winRect, fillBrush);

	::DeleteObject((HGDIOBJ)fillBrush);

}


//==============================================================================
// Novell_NicePartCanvasUpdated
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartCanvasUpdated(Novell_NicePart *somSelf, Environment *ev,
		ODCanvas* canvas)

// Notifies the part that a canvas that it owns has been
// updated and that its contents need to be copied to its
// parent canvas.
//
// Called by the facet object.
//
// The data must be copied from an off-screen canvas,
// transformed, and then placed in the containing canvas.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(canvas);
}

//==============================================================================
// Novell_NicePartHighlightChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartHighlightChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet)

// Notifies the part that the highlight state of one of its
// frames has been changed.
//
// Called by the frame object.
//
// It adjusts this part's presentation in the facet to its
// new highlight state. New state may be found by calling
// facet->GetHighlight(). It passes notification to embedded
// parts.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(facet);
}

//==============================================================================
// Novell_NicePartGetPrintResolution
//==============================================================================

SOM_Scope ODULong  SOMLINK Novell_NicePartGetPrintResolution(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Returns the minimum desired resolution in dots per inch
// that this part requires for printing the contents of the
// specified frame.
//
// Called by part or the application and is used in performing
// printing.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);

	return 0;
}

//==============================================================================
// Novell_NicePartCreateLink
//==============================================================================

SOM_Scope ODLink*  SOMLINK Novell_NicePartCreateLink(Novell_NicePart *somSelf, Environment *ev,
		ODPtr data,
		ODULong size)

// Creates a new link object.
//
// If a link already exists to the content identified by the data
// and size arguments, this method returns the link object;
// otherwise, it creates a new link object, puts in the initial
// data and returns it to the caller.
//
// This method identifies the content to be linked (by resolving
// the object specifier saved in the data parameter, or by some
// other means). It then creates a link object to represent the
// content data. The part must maintain information about what
// portion of its contents have been linked to it, so that it may
// notify link clients when that data has been changed. The link
// created is returned to the caller. Before calling this method,
// you must ensure that the data identifies some portion of this
// part's contents. After calling this method successfully, this
// part maintains a link to the identified content.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(data);
ODUnused(size);

	return kODNULL;
}

//==============================================================================
// Novell_NicePartLinkUpdated
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartLinkUpdated(Novell_NicePart *somSelf, Environment *ev,
		ODLink* updatedLink,
		ODChangeID id)

// Retrieves the data from the link and incorporates it into
// this part at the link's destination, thereby replacing any
// previous content of the link.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(updatedLink);
ODUnused(id);
}

//==============================================================================
// Novell_NicePartRevealLink
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartRevealLink(Novell_NicePart *somSelf, Environment *ev,
		ODLinkSource* linkSource)

// Reveals data that was previously linked in a window, making it
// available for viewing in a display frame.
//
// Called by ODLinkSource objects.  Should not be called by parts.
// In some display frame for this part, this method selects the
// content linked by the linkSource argument, and scrolls it into
// view. That display frame is made the active frame. If no display
// frames for the part currently exist, or if this part's containing
// frame can't reveal the display frame, it opens a frame in a new
// window.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(linkSource);
}

//==============================================================================
// Novell_NicePartEmbeddedFrameChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartEmbeddedFrameChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame,
		ODChangeID change)

// Notifies the containing part that the content displayed
// in the argument *embedded frame* has changed.
//
// Called by an frame object belonging to an embedded part when
// the frame object's ContentChanged method is called.
//
// The part should call the ContentChanged method of any of its
// frames that would be interested in this information. This
// method should only be called by frame objects. The part is
// not responsible for passing this notification on to its
// containing part. The part may ignore this notification if it
// is uninterested in changes to embedded content. A part should
// wait a certain length of time (a second perhaps) before
// updating its display so that subsequent calls to
// EmbeddedFrameChanged with the same ODChangeID dont result
// in multiple updates for the same change.After executing this
// method successfully, the ContentChanged method of any of the
// part's frames may have been called and the part may have
// taken action to update its display.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(change);
ODUnused(frame);
}

//==============================================================================
// Novell_NicePartLinkStatusChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartLinkStatusChanged(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)

// Allows the part to set the link status of any embedded frames.
//
// Called by a part's frame when that frame's ChangeLinkStatus
// method is called.
//
// Frames notify their owner parts that their link status has
// changed whenever ChangeLinkStatus is called. After this
// method executes successfully, the part will call
// ChangeLinkStatus on any embedded frames that are involved
// in the link in question.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_NicePartBeginRelinquishFocus
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_NicePartBeginRelinquishFocus(Novell_NicePart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(ownerFrame);

	if ((focus == _fModalFocus) && (proposedFrame->GetPart(ev) != _fPartWrapper)) {
		return kODFalse;
			// ** 6/23/94
			// What IS ModalFocus, anyway?  The whole purpose of this
			// ModalFocus thing is to restrict frame changes.  This is
			// the part's chance to do this.  But how much to restrict...
			//
			// This is an interesting case.  ModalFocus is kind of a weird
			// concept in OpenDoc, as it goes against the principal of
			// being able to click anywhere at any time.  This implementation
			// keeps the focus on the part.  Note that the implementation
			// of ModalFocus might be more restrictive than this.  You may
			// wish to restrict it to a single frame, instead of allowing
			// the focus to move from frame to frame within a single part.
			// If you wish to restrict it to a single frame, then the if
			// should only check if it is a modal focus.
	}
	else {
		return kODTrue;
			// This is the super-script way of handling ModalFocus.  You
			// can NOT switch off the frame to another, no matter what.
	}
}

//==============================================================================
// Novell_NicePartCommitRelinquishFocus
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartCommitRelinquishFocus(Novell_NicePart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(proposedFrame);

	somSelf->FocusLost(ev, focus, ownerFrame);
		// ** 6/23/94
		// No choices to be made here.  It's too late to say no.  We are
		// losing the focus if we are here.  Getting called here means
		// that BeginRelinquishFocus has already agreed that losing focus
		// is okay.  If you don't want this to be happening, then you need
		// to do something in BeginRelinquishFocus.
		//
		// The way that some other samples are currently written I believe
		// to be in error.  The recipes say that when this is called, it
		// has already been decided that, focus-wise, you lose.  Therefore
		// there should be no conditions on calling FocusLost.
}

//==============================================================================
// Novell_NicePartAbortRelinquishFocus
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartAbortRelinquishFocus(Novell_NicePart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(focus);
ODUnused(ownerFrame);
ODUnused(proposedFrame);

	// ** 6/23/94
	// Being here means that BeginRelinquishFocus said no to one of the foci.
	// You are being informed of this because you may have already taken action
	// based on a previous focus.  Note that if foci are managed as a set, if
	// BeginRelinquishFocus says false to any of the foci, then no action is
	// taken.  If however the foci are tested one at a time, it is possible that
	// the part has already taken action based on the first foci, and therefore
	// needs to undo something once a foci says no thanks.
}

//==============================================================================
// Novell_NicePartFocusAcquired
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartFocusAcquired(Novell_NicePart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	if (focus == _fMenuFocus) 
		if (ownerFrame && _fMenuBar)
		{       
			_fMenuBar->Display(ev);
		}
}

//==============================================================================
// Novell_NicePartFocusLost
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartFocusLost(Novell_NicePart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(ownerFrame);

	if (focus == _fMenuFocus) 
	{
	}
	_haveFocus 				= kODFalse;
}

//==============================================================================
// Novell_NicePartHasExtension
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_NicePartHasExtension(Novell_NicePart *somSelf, Environment *ev,
		ODType extensionName)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(extensionName);

	return kODFalse;
		// No extension until you implement one for your part.
}

//==============================================================================
// Novell_NicePartGetExtension
//==============================================================================

SOM_Scope ODExtension*  SOMLINK Novell_NicePartGetExtension(Novell_NicePart *somSelf, Environment *ev,
		ODType extensionName)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(extensionName);

	OutputDebugStr("Until the part implements extension support, this should not get called.");

	ev->_major = USER_EXCEPTION;
		// If we are called with an extension type we don't support,
		// we should be returning an error here.

	return kODNULL;
}

//==============================================================================
// Novell_NicePartReleaseExtension
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartReleaseExtension(Novell_NicePart *somSelf, Environment *ev,
		ODExtension* extension)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(extension);
}

//==============================================================================
// Novell_NicePartPurge
//==============================================================================

SOM_Scope ODSize  SOMLINK Novell_NicePartPurge(Novell_NicePart *somSelf, Environment *ev,
		ODSize size)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(size);
	
	// NicePart doesn't do anything here.

	return 0;
}

//==============================================================================
// Novell_NicePartIncrementRefCount
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartIncrementRefCount(Novell_NicePart *somSelf, Environment *ev)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

    Novell_NicePart_parent_ODPart_IncrementRefCount(somSelf,ev);
}

//==============================================================================
// Novell_NicePartRelease
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartRelease(Novell_NicePart *somSelf, Environment *ev)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

    Novell_NicePart_parent_ODPart_Release(somSelf,ev);

	// ***6/23/94
	//
	// If you are using RegisterIdle on the part, not on frames, then
	// the RefCount is bumped up by one by OpenDoc.  OpenDoc keeps a
	// reference to all parts that register idle time.  ALL OF THESE MUST
	// BE RESOLVED BEFORE THE DESTRUCTOR IS CALLED.  This is
	// the place to do that.

	// The logic below, assuming that NicePart has registered for idle
	// time, is that if the RefCount is 1, then we are here to unregister
	// the idle.  When the part is being removed, OpenDoc must decrement
	// the RefCount and call Release until the part gets messaged with
	// a RefCount of 0.  Once you return from here with a RefCount of 0,
	// OpenDoc will call the destructor.

	// This means that if you have registered for idle time, Release will
	// be called TWICE when closing down your part.  The first time the
	// RefCount is 1.  This is when you should unregister the idle time.
	// When you are called with a RefCount of 0, that when it gets really
	// serious.  This is when you detach from the draft.

	if (_fPartWrapper->GetRefCount(ev) == 1) {
		// Here is where you would unregister idle time for the part if
		// have registered time.  Note that if you unregister without
		// registering, OpenDoc will crash.  It's not just a simple
		// look-up-and-if-there-remove kind of operation.

		// Note that if you unregister idle here, OpenDoc will need to
		// call Release (here) due to it.  This means that when we call
		// to unregister the idle, we are nesting calls to Release.
		// Due to this, I return out of each case, just to make the
		// flow of control of the call(s) to Release more straightforward.

		// Note that if you are going to use idle registration, you will
		// need to include "Disptch.h"

		return;
	}
	
	if (somSelf->GetRefCount(ev) == 0)
		somSelf->GetStorageUnit(ev)->GetDraft(ev)->ReleasePart(ev, somSelf);
}

//==============================================================================
// Novell_NicePartReleaseAll
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartReleaseAll(Novell_NicePart *somSelf, Environment *ev)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	if (_fMenuBar != kODNULL)
		_fMenuBar->Release(ev);
}

//==============================================================================
// Novell_NicePartExternalize
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartExternalize(Novell_NicePart *somSelf, Environment *ev)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	if (_fDirty != kODFalse)
	{
	Novell_NicePart_parent_ODPart_Externalize(somSelf,ev);

		ODStorageUnit* storageUnit = _fPartWrapper->GetStorageUnit(ev);
			// Get the reference to where we are writing to.

		storageUnit->Focus(ev, kODPropContents, kODPosSame, kNicePartKind, 0, kODPosSame);
			// First we focus on the property we want to write out.

		storageUnit->SetValue(ev, lstrlen(_fTextData), _fTextData);
			// Now we write out the property.

		_fDirty = kODFalse;
			// Flag our part as no longer being dirty.
	}
}

//==============================================================================
// Novell_NicePartCloneInto
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartCloneInto(Novell_NicePart *somSelf, Environment *ev,
		ODDraftKey key,
		ODStorageUnit* storageUnit,
		ODFrame* initiatingFrame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODStorageUnit*  su = _fPartWrapper->GetStorageUnit(ev);
	ODDraft*                draft = su->GetDraft(ev);

	ODVolatile(draft);

	somSelf->Externalize(ev);
	
	if (initiatingFrame) {
		su->CloneInto(ev, key, storageUnit, initiatingFrame->GetStorageUnit(ev)->GetID(ev));
	} else {
		su->CloneInto(ev, key, storageUnit, kODNULL);
	}

	if (ev->_major != NO_EXCEPTION)
		draft->AbortClone(ev, key);
}

//==============================================================================
// Novell_NicePartExternalizeKinds
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartExternalizeKinds(Novell_NicePart *somSelf, Environment *ev,
		ODTypeList* kindset)

// Externalizes a representation for each 'kind' that it supports.
//
// The part should iterate through all the kinds in 'kindList',
// and externalize a representation for each that it supports.
// This call does not specify anything about the ordering of those
// kinds in the contents property. Before calling this method,
// you must ensure that the part supports a subset of the kinds
// in 'kindList'. After executing this method successfully, the
// contents property of the part has a value and representation
// for each kind in kindListsupported.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(kindset);

	somSelf->Externalize(ev);
}

//==============================================================================
// Novell_NicePartChangeKind
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartChangeKind(Novell_NicePart *somSelf, Environment *ev,
		ODType kind)

// Asks a part to change into a new kind of content,
// i.e. ask an ASCII Text part to change into a Styled Text part.
//
// The part should begin using the given kind as its primary kind
// if it is supported. The first type of the first value in the
// content property of the part's storage unit should become the
// given kind. Before calling this method, you must ensure that the
// part supports the specified kind. After this method is executed
// successfully, the part's primary kind is the one that was
// specified in the parameter, and the first type of the first
// value in the content property of the part's storage unit is of
// the specified type. When it reads in data, the part uses this
// representation.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(kind);
}                                                                                                

//==============================================================================
// Novell_NicePartHandleEvent
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_NicePartHandleEvent(Novell_NicePart *somSelf, Environment *ev,
		ODEventData* event,
		ODFrame* frame,
		ODFacet* facet)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODBoolean       tWasHandled = kODFalse;
	
	switch ( event->message ) {
		case kODEvtNull:
			tWasHandled = kODTrue;
			break;
			
		case WM_LBUTTONDOWN:
			tWasHandled = somSelf->MyHandleMouseDown(ev, event, frame, facet);
			break;
			
		case WM_LBUTTONUP:
			tWasHandled = somSelf->MyHandleMouseUp(ev, event, frame, facet);
			break;

		case kODEvtMouseDownEmbedded:
		case WM_KEYDOWN:
		case kODEvtActivate:
			tWasHandled = kODTrue;
			break;

		case kODEvtMenu:
			tWasHandled = somSelf->MyHandleMenuEvent(ev, frame, event );
			break;

		default:
			break;
	}

	return tWasHandled;

// Below is some documentation for this method.  If you don't care for
// being here, then just delete it.
//
// The frame and facet parameters of HandleEvent() may be
// kODNULL, depending on the kind of event.
//
// Parts must handle the following events, which correspond to
// standard Windows messages:
//
//{SS} How come NicePart doesn't handle all of these events?
//      kODEvtNull
//      kODEvtMouseDown
//      kODEvtMouseUp
//      kODEvtKeyDown
//      kODEvtKeyUp
//      kODEvtAutoKey
//      kODEvtUpdate
//      kODEvtActivate
//      kODEvtOS
//
// Null Events --
// In order to receive null events (i.e. idle time), parts must call
// ODDispatcher::RegisterIdle(), specifying the part, a frame
// (optional) and idle frequency. The part will receive a null event
// for each frame registered. ODDispatcher::GetSleepTime() is called
// by the shell, and the value passed to WaitNextEvent. An appropriate
// sleep time is computed based on the idle frequencies of registered
// idle frames.
//
// Mouse Events --
// Unmodified mouse events are delivered to the facet under the mouse
// location using Part::HandleEvent().
//
// Shift-Click and Command-Click go to the frame with the selection
// focus.  Mouse events in window title bars are converted to window
// events. (See below)  Mouse down events in the menu bar are converted
// to menu events. (See below)
//
// Keyboard Events --
// Keyboard events go to the frame with the keyboard focus, with the
// exception of the Page Up, Page Down, Home and End keys, which will
// go to the frame with the scrolling focus, if there is one.
//
// Update Events --
// Update events are not passed to Part::HandleEvent(). Rather
// Part::Draw() will be called for each facet in the window.
//
// Activate Events --
// Activate events are also delivered to each facet, using
// Part::HandleEvent().
//
// Disk Events --
// Currently, disk events are not distributed to parts.
// But where do they go???
//
// OS Events --
// Suspend/Resume events are delivered to each facet in each
// window using Part::HandleEvent(). 
//
// Mouse Moved events are not passed to Part::HandleEvent().
// They are handled by the dispatcher, and translated into calls
// to Part::MouseEnter(), MouseWithin() and MouseLeave().
// See Cursor Tracking below.
//
// Menu Events --
// OpenDoc converts a mouse down in the menu bar, or its
// command-key equivalent, into a menu event of type kODEvtMenu.
//
// The message field of the event record contains the result 
// returned by MenuSelect() or MenuKey(). i.e. the menu is in 
// the high word, and the item in the low word. The part can 
// obtain a command number using ODMenuBar::GetCommand().
//
// Window Events --
// Events in the title bar of a window (eg. clicking in the
// close box) are usually handled by the shell, but are first
// offered to the root part of the window. Parts which wish to
// intercept these events (perhaps to hide rather than close a
// window) must handle the following event: kODEvtWindow 
// The message field of the event contains the part code, as
// returned by FindWindow().
//
// Events in Embedded Frames --
// Parts which support embedding may also receive the following events:
//      
//      kODEvtMouseDownEmbedded 
//      kODEvtMouseUpEmbedded
//      kODEvtMouseDownBorder
//      kODEvtMouseUpBorder
//
// If the user clicks in the active border, the containing
// facet/frame/part will receive a kODEvtMouseDownBorder event.
// The message field of the event record contains the embedded facet.
//
// Similarly, if the user clicks in an embedded frame with the
// *frozen* or *selected* property set, a kODEvtMouseDownEmbedded
// event is directed to the containing frame.
//
// If the user shift-clicks or command-clicks in a frame which is
// embedded in the frame with the selection focus, then the latter
// frame gets a kODEvtMouseDownEmbedded event.  
//
// Cursor Tracking --
// OpenDoc tracks cursor movement (with the mouse button up), and
// calls MouseEnter() when the cursor first moves into a facet, and
// MouseLeave() when the cursor leaves the facet. A part can change
// the cursor on MouseEnter, and set it to the arrow on MouseLeave.
//
// This process is triggered by the shell calling
// ODDispatcher::GetMouseRegion() and passing the result to
// WaitNextEvent(). The region is only recomputed when necessary. 
// If the cursor is motionless within a facet, the shell application
// goes to sleep because OpenDoc computes a mouse region containing
// just the cursor location. The part can make this region larger
// by calling ODDispatcher::SetMouseRegion(). In a future release,
// OpenDoc will also compute a suitably large sleep region if the
// cursor is not within any facet.
//
// Modal Focus --
// Some events are constrained by the modal focus. For example a
// mouse click outside the frame with the modal focus will be sent
// to the modal focus frame, but a click in an embedded frame
// within the modal focus frame will go to the embedded frame. 
//
// Propagating Events --
// If a containing part sets the *DoesPropagateEvents* property of
// an embedded frame, the containing part will receive events not
// handled by the embedded frame. A part which does this will have
// to inspect the frame passed to HandleEvent() to determine if it
// is one of its display frames.

}

//------------------------------------------------------------------------------
// Novell_NicePartMyHandleMenuEvent
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK Novell_NicePartMyHandleMenuEvent(Novell_NicePart *somSelf, Environment* ev, 
								ODFrame* frame, ODEventData* event)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(frame);

	switch(event->wParam) {

		case kODCommandAbout:
		{
			if (_fSession->GetArbitrator(ev)->RequestFocus(ev, _fModalFocus, frame))
			{
				MessageBox(kODNULL, "NicePartPart\nCopyright 1995 Novell, Inc.\nAll rights reserved.", 
							"About", MB_APPLMODAL | MB_OK);
				_fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fModalFocus,frame);
			}
		}
		break;

		case kODCommandClear:
			break;

		// Color Menu Events
		case IDM_GRAY:
		case IDM_RED:
		case IDM_GREEN:
		case IDM_YELLOW:
		case IDM_BLUE:
		case IDM_MAGENTA:
		case IDM_CYAN:
		case IDM_WHITE:
		{
			// Constants of Colors in Menu
			const COLORREF colors[8]={      RGB(127, 127, 127 ), //Gray
										RGB(255, 0, 0 ),         //Red
										RGB(0, 255, 0 ),         //Green
										RGB(255, 255, 0 ),       //Yellow
										RGB(0, 0, 255 ),         //Blue
										RGB(255, 0, 255 ),       //Magenta
										RGB(0, 255, 255 ),       //Cyan
										RGB(255, 255, 255 )  //White
									 };
		
			// Uncheck previous selection in Menu
			CheckMenuItem(_fMenu.menu,_theColorID, MF_UNCHECKED);
			
			// Check new selection in Menu
			_theColorID = event->wParam;
			CheckMenuItem(_fMenu.menu,_theColorID, MF_CHECKED);

			// Set _theColor to index value of color selected
			_theColor=( colors[ _theColorID - IDM_GRAY ] );
			return kODTrue;
			break;
		}

		case kODCommandViewAsWin:
			somSelf->Open(ev, frame);
			break;

		case kODCommandGetPartInfo:
		{
			ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
			_fSession->GetInfo(ev)->ShowPartFrameInfo(ev, facets->First(ev));
		}
			break;

		default:
			return kODFalse;
	}
		
	return kODTrue;
}

//------------------------------------------------------------------------------
// Novell_NicePartMyHandleMouseDown
//------------------------------------------------------------------------------

//{SS} Need to set a tracking flag so that if someone starts dragging from without the facet and then
//{SS} enters - rectangles are not drawn.
SOM_Scope ODBoolean SOMLINK Novell_NicePartMyHandleMouseDown(Novell_NicePart *somSelf, Environment* ev, 
								ODEventData* event, ODFrame* frame, ODFacet* facet)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODBoolean handled = kODFalse;
	
	if (facet == kODNULL)           // Did we get a click outside a modal dialog? ...
	{
		return kODTrue;                 // Return that click was handled.
	}

	// Activate the window if it is not active...
	if (!facet->GetWindow(ev)->IsActive(ev))
	{
		facet->GetWindow(ev)->Select(ev);

		#ifdef FIRST_CLICK_WINDOW_BEHAVIOR
			handled = kODTrue;
		#else
			return kODTrue;
		#endif
			// We argued way too much about which this should be.  The answer is that
			// some types of content need first click, and some absolutely don't.  Even
			// for 'TEXT', sometimes you want one, and sometimes you want the other.
			// It depends on your content, usage model, etc.
			//
			// If you are unsure about which you want, the default for NicePartPart
			// should be FIRST_CLICK_WINDOW_BEHAVIOR.  This probably means fewer clicks
			// for the user.  If this doesn't work for your part, of course change it.
	}

	// Try to grab all of our foci...
	//{SS} We should keep track of whether or not we have focus so that 
	//{SS} we dont do this on every mouse down.
	if( ! _haveFocus )
	{
		if ( _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame))
		{
			somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
			somSelf->FocusAcquired(ev, _fMenuFocus, frame);
			somSelf->FocusAcquired(ev, _fKeyFocus, frame);
			_haveFocus=kODTrue;

		}
		else
		{
			return kODFalse;        // We couldn't get focus.
		}

		// Of course, you shouldn't fail if you really don't need the *all*
		// of the foci.  For example, a vector drawing part that also has
		// a text tool should probably go ahead and allow drawing while 
		// disabling the text tool.

	}

	// Get the modal focus if we can for drawing the rubberband box
	// This needs to be done here rather than with the focus above because
	// We may already have other focuses
	if(_fSession->GetArbitrator(ev)->RequestFocus(ev, _fModalFocus,frame) )
	{
		somSelf->FocusAcquired(ev, _fModalFocus, frame);  // Also need Modal Focus
		_haveModalFocus=kODTrue;
	}
		

	// get the mouse in local coordinates
#ifndef WIN32
	POINT   event_where = MAKEPOINT(event->lParam);
#else
	POINT   event_where;
	LONG2POINT(event->lParam, event_where);
#endif

	ODWindow* odwnd = frame->GetWindow(ev);
	
	// Convert Event Point to Frane Coordinates
	ODPoint odPoint(IntToFixed(event_where.x), IntToFixed(event_where.y));

	// Convert the odPoint to Frame Coordinates
	ODTransform*    wcXForm = facet->GetWindowContentTransform(ev, kODNULL);
	odPoint = wcXForm->InvertPoint(ev, &odPoint);
	wcXForm->Release(ev);
	
	// Store off facet for use in MouseUp.  With a Modal focus you may not
	// get the mouse up inside your facet ( or even in a facet for that matter)
	_clickedFacet=facet;

	// Handle clicks in used shape...
	ODShape*  usedShape = somSelf->MyGetUsedShape(ev, frame);
	ODBoolean hit       = usedShape->ContainsPoint(ev, &odPoint);
	usedShape->Release(ev);
	
	_newRect= new ODRect(odPoint,odPoint);
	return handled;
}


//------------------------------------------------------------------------------
// Novell_NicePartMyHandleMouseUp
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK Novell_NicePartMyHandleMouseUp(Novell_NicePart *somSelf, Environment* ev, 
								ODEventData* event, ODFrame* frame, ODFacet* facet)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	#ifndef WIN32
		POINT   event_where = MAKEPOINT(event->lParam);
	#else
		POINT   event_where;
		LONG2POINT(event->lParam, event_where);
	#endif

	// Convert the Windows POINt to an ODPoint
	ODPoint odPoint(IntToFixed(event_where.x), IntToFixed(event_where.y));
			
	// Comvert the ODPoint to Frame Coordinates
	ODTransform*    wcXForm = _clickedFacet->GetWindowContentTransform(ev, kODNULL);
	odPoint = wcXForm->InvertPoint(ev, &odPoint);
	wcXForm->Release(ev);
	
	// Set the last x & y Coordinates in the newRect
	_newRect->Set( _newRect->left, _newRect->top, odPoint.x, odPoint.y );
			
	// Shut off Modal Foucs
	_haveModalFocus = kODFalse;
	_fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fModalFocus,frame);

	// Add the newRect to the list of Rects
	_colorRects->AddLast( new ColorRect ( _newRect, _theColor ) );

	// Invalidate the Facet to forsc a redraw
	_clickedFacet->Invalidate(ev, _clickedFacet->GetActiveShape(ev, kODNULL), kODNULL );

	return kODTrue;
}

//------------------------------------------------------------------------------
// Novell_NicePartMyUsedShapeHandleMouseDown
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK Novell_NicePartMyUsedShapeHandleMouseDown(Novell_NicePart *somSelf, Environment* ev, 
						ODEventData* event, ODFrame* frame, ODFacet* facet)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	// Get the window and platform window (i.e. WindowPtr)...
	ODWindow*                       odwnd = frame->GetWindow(ev);
	ODPlatformWindow        facetWnd = odwnd->GetPlatformWindow(ev);

	// Get the mouse in window-local and facet-local coordinates...
#ifndef WIN32
	POINT   event_where = MAKEPOINT(event->lParam);
#else
	POINT   event_where;
	LONG2POINT(event->lParam, event_where);
#endif
	ODPoint windowPoint(IntToFixed(event_where.x), IntToFixed(event_where.y));
	ODTransform*    wcXForm = facet->GetWindowContentTransform(ev, kODNULL);
	ODPoint facetPoint = wcXForm->InvertPoint(ev, &windowPoint);
	wcXForm->Release(ev);

	// Handle the click in whatever way is appropriate...
	{
		HDC     hDC;
		CFocus  foc(facet, kODNULL, &hDC);

		Rect            rct;
		Point           pltFrmPoint = facetPoint.AsWinPoint();
	
		int             prevDrawMode = SetROP2(hDC, R2_NOT);
		::SetRect(&rct, pltFrmPoint.x - 3, pltFrmPoint.y - 3, pltFrmPoint.x + 3, pltFrmPoint.y + 3);
		::Ellipse(hDC, rct.left, rct.top, rct.right, rct.bottom);
		SetROP2(hDC, prevDrawMode);
	}
	
	return kODTrue;         // We handled the click.
}

//==============================================================================
// Novell_NicePartHandleEventInEmbedded
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_NicePartHandleEventInEmbedded(Novell_NicePart *somSelf, Environment *ev,
		ODEventData* event,
		ODFrame* frame,
		ODFacet* facet,
		ODFrame* embeddedFrame,
		ODFacet* embeddedFacet)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(event);
ODUnused(frame);
ODUnused(facet);
ODUnused(embeddedFrame);
ODUnused(embeddedFacet);

	return kODFalse;
}

//==============================================================================
// Novell_NicePartMouseEnter
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartMouseEnter(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)

// Called when the mouse is moved over a display frame of this
// part (mouse button up).
//
// Called by the Dispatcher object.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(facet);
ODUnused(where);
}

//==============================================================================
// Novell_NicePartMouseWithin
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartMouseWithin(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)

// Called when the mouse is moved within a display frame of this
// part (mouse button up).
//
// Called by the Dispatcher object.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	HDC hDC;
	
	CFocus  foc(facet, kODNULL, &hDC);


	if(_haveModalFocus)             // Are we drawing a Rubber Band Box
	{
		// Do we have a box to erase
		if( _newRect->TopLeft() != _newRect->BotRight() )
		{
			// Erase box
			somSelf->DrawODRect(ev, _newRect, hDC, PS_DASH, R2_NOTXORPEN);
		}

		// Set to new box & Draw new box
		_newRect->Set(_newRect->left, _newRect->top, where->x, where->y );
		somSelf->DrawODRect(ev, _newRect, hDC, PS_DASH, R2_NOTXORPEN);
	}
}

//==============================================================================
// Novell_NicePartMouseLeave
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartMouseLeave(Novell_NicePart *somSelf, Environment *ev,
		ODFacet* facet)

// Called when the mouse is moved out of a display frame of this
// part (mouse button up).
//
// Called by the Dispatcher object.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(facet);
}

//==============================================================================
// Novell_NicePartAdjustMenus
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartAdjustMenus(Novell_NicePart *somSelf, Environment *ev,
		ODFrame* frame)
{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	Str63           aboutText;
	ODIText*        odiText;

ODUnused(frame);

	_fMenuBar->EnableCommand(ev, kODCommandViewAsWin, !frame->IsRoot(ev) );
	_fMenuBar->EnableCommand(ev, kODCommandGetPartInfo, kODTrue);

	lstrcpy(aboutText, "About NicePart...");

	odiText = CreateIText(kODRomanScript, kODEnglishLang, aboutText);
	_fMenuBar->SetItemString(ev, kODCommandAbout, odiText);
	DisposeIText(odiText);
}

//==============================================================================
// Novell_NicePartUndoAction
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartUndoAction(Novell_NicePart *somSelf, Environment *ev,
		ODActionData actionState)

// Tells the part to undo the action that is described by actionState.
//
// Called by the undo object.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(actionState);
}

//==============================================================================
// Novell_NicePartRedoAction
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartRedoAction(Novell_NicePart *somSelf, Environment *ev,
		ODActionData actionState)

// Tells the part to Redo the action described by actionState.
//
// Called by the undo object.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(actionState);
}

//==============================================================================
// Novell_NicePartDisposeActionState
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartDisposeActionState(Novell_NicePart *somSelf, Environment *ev,
		ODActionData actionState,
		ODDoneState doneState)

// Tells the part to dispose of the action data.
//
// Before calling this method, you must ensure that *actionState*
// is an action data block previously logged by this part. After
// calling this method successfully, memory for *actionState* has
// been reclaimed. It is no longer usable to perform undo operations.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(actionState);
ODUnused(doneState);
}

//==============================================================================
// Novell_NicePartWriteActionState
//==============================================================================

SOM_Scope void  SOMLINK Novell_NicePartWriteActionState(Novell_NicePart *somSelf, Environment *ev,
		ODPtr actionState,
		ODStorageUnitView* storageUnitView)

// Writes out the actionState data onto a StorageUnitView,
// and externalizes the undoAction data to the storage unit.
//
// Called by the undo object.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(actionState);
ODUnused(storageUnitView);
}

//==============================================================================
// Novell_NicePartReadActionState
//==============================================================================

SOM_Scope ODPtr  SOMLINK Novell_NicePartReadActionState(Novell_NicePart *somSelf, Environment *ev,
		ODStorageUnitView* storageUnitView)

// Internalizes the undoAction data from the storage unit.
//
// This method reads the actionState data from a view on a
// StorageUnit. It then allocates the memory and passes ownership
// of the storage to the caller.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

ODUnused(storageUnitView);

	return kODNULL;
}

//==============================================================================
// Novell_NicePartMyGetFrameShape
//==============================================================================

SOM_Scope ODShape* SOMLINK Novell_NicePartMyGetFrameShape(Novell_NicePart *somSelf, Environment* ev, ODFrame* frame)

// This is just to centralize the frame shape code.  Do it any way
// is best for your part.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODShape* newFrameShape;
	
	if (frame->IsRoot(ev))
		newFrameShape = frame->GetFrameShape(ev, kODNULL);
	else
		newFrameShape = somSelf->MyGetUsedShape(ev, frame);

	return newFrameShape;
}


//==============================================================================
// Novell_NicePartMyGetUsedShape
//==============================================================================

SOM_Scope ODShape* SOMLINK Novell_NicePartMyGetUsedShape(Novell_NicePart *somSelf, Environment* ev, ODFrame* frame)

// This is just to centralize the frame shape code.  Do it any way
// is best for your part.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODShape*        frameShape = frame->GetFrameShape(ev, kODNULL);
	RgnHandle       shapeRgn = frameShape->GetWinRegion(ev);
	frameShape->Release(ev);
	
	Rect            rr;
	GetRgnBox(shapeRgn, &rr);
	short           hh = rr.bottom - rr.top;
	short           ww = rr.right - rr.left;

	if (hh < 100) hh = 100;
	if (ww < 100) ww = 100;

	shapeRgn = CreateRectRgn(0, 0, hh, hh); 

	ODShape* usedShape = frame->CreateShape(ev);
	usedShape->SetWinRegion(ev, shapeRgn);

	return usedShape;
}


//==============================================================================
// Novell_NicePartMyAdjustFacets
//==============================================================================

SOM_Scope void SOMLINK Novell_NicePartMyAdjustFacets(Novell_NicePart *somSelf, Environment* ev, ODFrame* frame)

// Given a frame, iterate through all of the facets and adjust them
// according to the new frame.

{
    Novell_NicePartData *somThis = Novell_NicePartGetData(somSelf);

	ODShape* usedShape  = somSelf->MyGetUsedShape(ev, frame);
	frame->ChangeUsedShape(ev, usedShape, kODNULL);
	usedShape->Release(ev);

	ODShape* frameShape = frame->GetFrameShape(ev, kODNULL);
	ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
	for (ODFacet* facet = facets->First(ev);
			facets->IsNotComplete(ev);
			facet = facets->Next(ev) )
	{
		facet->ChangeActiveShape(ev, frameShape, kODNULL);
	}
	frameShape->Release(ev);
}
