/*
	File:           NiceFact.cpp

	Contains:       Windows platform implementation for NiceFact

	Written by:     Scott Sorensen

	Change History (most recent first):

		 <0>      8/11/94       SWS             created
*/

#ifndef _T_REGIST__
#include "T_Regist.h"
#endif

#ifndef _NICEPART_
#include "NicePart.h"
#endif

#include <string.h>

// In ODFactory we check to see that the part type matches this string.
// This is the same string that is entered for the part type when the
// part is registered with the OpenDoc shell.
#define kXMPNicePart    "Nice Part"

//-------------------------------------------------------------------------
// ODFactory
//
// About this OpenDoc Factory
// Every Windows OpenDoc part needs to define a function called
// ODFactory.  This function simply checks either the part type
// or class name to see if they match for the part in question
// and then instantiates this part.
//
//-------------------------------------------------------------------------

XMPPart* WINAPI ODFactory(
	XMPType         partType,                     // The type of part we should instantiate
	XMPType         className)
{
	XMPUnused(className);

	// include int 3 for debugging.
//      __asm int 3

	if (!lstrcmp((LPSTR)partType, (LPSTR)kXMPNicePart)) {
		return (new NicePart());
	}
	return NULL;
}



