/*
	File:		FacetLst.cpp

	Contains:	Linked list of facets, for use by parts

	Written by:	Jens Alfke

	Windowized by:	Jeff Hanson	 (03/10/95)

*/

#ifndef _FACETLIST_
#include "FacetLst.h"
#endif

#ifndef _ODTYPES_
#include <ODTypes.h>
#endif

//==============================================================================
// FacetLink
//==============================================================================


FacetLink::FacetLink( )
{
	fFacet = kODNULL;
	fPrev = this;
	fNext = this;
}


FacetLink::FacetLink( ODFacet *facet, FacetLink *list )
{
	fFacet = facet;
	fPrev  = list;
	fNext  = list->fNext;
	list->fNext  = this;
	fNext->fPrev = this;
}


FacetLink::~FacetLink( )
{
	if( fPrev )
		fPrev->fNext = fNext;
	if( fNext )
		fNext->fPrev = fPrev;
}


//==============================================================================
// FacetLink
//==============================================================================

FacetList::FacetList()
{
	fFacet = kODNULL;
	fPrev = kODNULL;
	fNext = this;
}

FacetList::~FacetList( )
{
	// Delete all links:
	while( fNext != this )
		delete fNext;
}


void FacetList::Add( ODFacet *facet )
{
	new FacetLink(facet,this);
	// The new link has already hooked itself into my chain so I don't need to
	// remember it elsewhere.
}


void FacetList::Remove( ODFacet *facet )
{
	FacetLink *link;
	for ( link = this->First(); link->Facet(); link = link->Next() ) {
		if( link->Facet() == facet ) {
			delete link;
			return;
		}
	}

	OutputDebugStr("Couldn't find facet");
}
