/*
	File:		MetaFilePart.cpp

	Contains:	implementation of class MetaFilePart

	Written by:	Lynn LeBaron

	Copyright:	c 1994 by WordPerfect Corporation, all rights reserved.

	
	Log:		
		modified by Jean Yan, 3-22-95 to work on SOM.

*/
#ifndef _ALTPOINT_
#include "AltPoint.h"                   // Use C++ savvy ODPoint and ODRect
#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#define SOM_Module_metafilp_Source
#define VARIABLE_MACROS
#include "metafilp.xih"

#ifndef SOM_ODFacet_xh
#include "Facet.xh"
#endif

#ifndef SOM_ODFrame_xh
#include "Frame.xh"
#endif

#ifndef SOM_ODInfo_xh
#include "Info.xh"
#endif

#ifndef SOM_ODFocusSet_xh
#include "FocusSet.xh"
#endif


#ifndef SOM_Module_5codsom5cinterfac5ccplus5cmachinem5cFOCI_OpenDoc_Foci_defined
#include "Foci.xh"
#endif

#ifndef SOM_ODArbitrator_xh
#include "Arbitrat.xh"
#endif

#ifndef SOM_ODMenuBar_xh
#include "MenuBar.xh"
#endif

#ifndef _ODUTILS_
#include "ODUtils.h"
#endif

#ifndef SOM_ODSession_xh
#include "ODSessn.xh"
#endif

#ifndef SOM_ODStorageUnit_xh
#include "Storageu.xh"
#endif

#ifndef SOM_ODStorageUnitView_xh
#include <SUView.xh>
#endif

#ifndef SOM_ODWindowState_xh
#include "winstat.xh"
#endif

#ifndef SOM_ODWindow_xh
#include "window.xh"
#endif

#ifndef SOM_ODShape_xh
#include "shape.xh"
#endif

#ifndef SOM_ODFrameFacetIterator_xh
#include "frfaitr.xh"
#endif

#ifndef SOM_ODFacetIterator_xh
#include "FacetItr.xh"
#endif

#ifndef SOM_ODCanvas_xh
#include "canvas.xh"
#endif

#ifndef _FOCUSLIB_
#include "focuslib.h"
#endif

#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef SOM_ODPartWrapper_xh
#include "PartWrap.xh"
#endif

#ifndef SOM_Module_OpenDoc_StdProps_defined
#include <StdProps.xh>
#endif

#ifndef SOM_Module_OpenDoc_Commands_defined
#include <CmdDefs.xh>
#endif
				 
#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif


#define	ALDUSKEY		0x9AC6CDD7L
#define IDM_METAFILE	1520

#define	TYPE_UNKNOWN	0
#define	TYPE_METAFILE	1
#define	TYPE_BITMAP		2

#define AldusHeaderSize	22

const ODCommandID IDM_META_PICK = 2002;
const ODCommandID IDM_BMP_PICK = 2003;
const ODCommandID IDM_BMP_FIT = 2004;


LRESULT CALLBACK ShadowWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

/* Constants */
#define		kODKindTestMetaFile		"Novell:Kind:MetaFile"

//==============================================================================
// 'ternalization
//==============================================================================

static const ODPropertyName kODGraphicProp = "GraphicProp";
static const ODPropertyName	kODPropMetafileBits = "MetafilePart:Property:Bits";
static const ODPropertyName	kODPropMetafileIsAldus = "MetafilePart:Property:IsAldus";
static const ODPropertyName	kODPropMetafileBox = "MetafilePart:Property:Box";

static const ODValueType	kODGraphicSize = "GraphicSize";
static const ODValueType	kODGraphicType = "GraphicType";
static const ODValueType	kODGraphicFit = "GraphicFit";
static const ODValueType	kODMetafileBits = "MetafilePart:Bits";
static const ODPropertyName	kODMetafileIsAldus = "MetafilePart:IsAldus";
static const ODPropertyName	kODMetafileBox = "MetafilePart:Box";

//==============================================================================
// MetaFilePart
//==============================================================================

//  constructor 
SOM_Scope void  SOMLINK somInit(MetaFilePart *somSelf)
{

	MetaFilePartData *somThis = MetaFilePartGetData(somSelf);
	MetaFilePartMethodDebug("MetaFilePart", "somInit");
	MetaFilePart_parent_ODPart_somInit(somSelf);

	_FitToFrame = 1;
	_fDisplayFrames = kODNULL;
	_fEmbeddedFrames = kODNULL;
	_fWindowID = 0;
	_fContents = kODNULL;
	_fSelection = kODNULL;
	_fMenuBar = kODNULL;
	_fFocusSet = kODNULL;
	_fSession = kODNULL;
	_fShadowWindow = kODNULL;
	_fShadowUsage = 0;
	_lpBitsInfo = NULL;
}


//  destructor 
SOM_Scope void  SOMLINK somUninit(MetaFilePart *somSelf)
{

	MetaFilePartData *somThis = MetaFilePartGetData(somSelf);
	MetaFilePartMethodDebug("MetaFilePart", "somUninit");
	
	Environment* ev = somGetGlobalEnvironment();

	if (_hBitmap)
		GlobalFree(_hBitmap);

	if (_fhmf) 
		DeleteMetaFile(_fhmf);
}



SOM_Scope void SOMLINK InitPart(
			MetaFilePart	*somSelf,
			Environment		*ev,
			ODStorageUnit	*storageUnit,
			ODPartWrapper	*partWrapper)
{
	
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	if (somSelf->IsInitialized(ev))
		return;

	somSelf->InitPersistentObject(ev, storageUnit);
	somSelf->CommonInitMetaFilePart(ev, partWrapper);

	storageUnit->AddProperty(ev, kODPropContents)->AddValue(ev,kODKindTestMetaFile);
	_fMetaFileSU = storageUnit->GetDraft(ev)->CreateStorageUnit(ev);

	_fMetaFileSU->AddProperty(ev, kODGraphicProp)->AddValue(ev,kODGraphicType);
	_fMetaFileSU->AddProperty(ev, kODGraphicProp)->AddValue(ev,kODGraphicSize);
	_fMetaFileSU->AddProperty(ev, kODGraphicProp)->AddValue(ev,kODGraphicFit);
	_fMetaFileSU->AddProperty(ev, kODPropMetafileBits)->AddValue(ev,kODMetafileBits);
	_fMetaFileSU->AddProperty(ev, kODPropMetafileIsAldus)->AddValue(ev, kODMetafileIsAldus);
	_fMetaFileSU->AddProperty(ev, kODPropMetafileBox)->AddValue(ev, kODMetafileBox);

}

SOM_Scope void SOMLINK InitPartFromStorage(
				MetaFilePart	*somSelf,
				Environment		*ev,
				ODStorageUnit   *storageUnit,
				ODPartWrapper   *partWrapper)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	

	/* Do standard part initialization */
	if (somSelf->IsInitialized(ev))
		return;

	somSelf->InitPersistentObjectFromStorage(ev, storageUnit);
	somSelf->CommonInitMetaFilePart(ev, partWrapper);

	ODULong				offset, offsetLimit, bitsSize;
	ODStorageUnitRef	aSURef;
	ODFrame				*frame;
	ODStorageUnit		*su;

	ODVolatile(su);
	ODVolatile(frame);

	somSelf->InitPersistentObjectFromStorage(ev, storageUnit);
	somSelf->CommonInitMetaFilePart(ev, partWrapper);

	su = somSelf->GetStorageUnit(ev);
	su->Focus(ev, kODPropContents, kODPosSame, kODKindTestMetaFile,1,kODPosFirstSib);
	su->GetULongValue(ev,sizeof(ODStorageUnitRef),&aSURef);
	
	_fMetaFileSU = su->GetDraft(ev)->GetStorageUnit(ev,su->GetIDFromStorageUnitRef(ev,aSURef));
	su = _fMetaFileSU;

	su->Focus(ev,kODGraphicProp,kODPosUndefined,kODGraphicType,0,kODPosUndefined);
	
	int type;
	su->GetValue(ev,sizeof(int),&type);
	
	switch (type) {
		case TYPE_METAFILE:
			su->Focus(ev,kODPropMetafileBits,kODPosSame,kODMetafileBits,1,kODPosFirstSib);
			bitsSize = su->GetSize(ev);
			// If there is any content
			if (bitsSize) {
				HGLOBAL	hMem;
				void	*pMem;

				/* allocate memory for the metafile */
				if (hMem = GlobalAlloc(GHND, bitsSize))  {
					/* lock the memory */
					pMem = (LPSTR)GlobalLock(hMem);
					if (pMem) {
						// Get the data
						su->GetValue(ev,bitsSize, (ODValue)pMem);
						/* Turn it into a metafile handle */
#ifndef WIN32
				fhmf = SetMetaFileBits(hMem);
#else
				_fhmf = SetMetaFileBitsEx(bitsSize, (CONST BYTE*)pMem);
#endif
						if (_fhmf) {
							// Yea, unlock the mem
							GlobalUnlock(hMem);
							// Find out the other stuff
							su->Focus(ev,kODPropMetafileIsAldus,kODPosSame,kODMetafileIsAldus,1,kODPosFirstSib);
							su->GetValue(ev,sizeof(boolean), (ODValue)&_fIsAldusMeta);
							su->Focus(ev,kODPropMetafileBox,kODPosSame,kODMetafileBox,1,kODPosFirstSib);
							su->GetValue(ev,sizeof(RECT), (ODValue)&_fAldusBox);
						} else {
							// Failed to create the Metafile handle, clean up
							GlobalUnlock(hMem);
							GlobalFree(hMem);
						}
					} else {
						// Failed the memory lock, free the handle
						GlobalFree(hMem);
					}
				}
			}
			break;
		case TYPE_BITMAP:
			su->Focus(ev,kODGraphicProp,kODPosUndefined,kODGraphicFit,0,kODPosUndefined);
			su->GetValue(ev,sizeof(_FitToFrame),&_FitToFrame);
			su->Focus(ev,kODGraphicProp,kODPosUndefined,kODGraphicSize,0,kODPosUndefined);
			su->GetValue(ev,sizeof(bitsSize),&bitsSize);
			su->Focus(ev,kODPropMetafileBits,kODPosUndefined,kODMetafileBits,0,kODPosUndefined);
			if (!su->GetSize(ev)) {
//				bitsSize=0;
				if (su->Exists(ev,kODPropMetafileBits,kODMetafileBits,0))
					MessageBox(NULL,"Size reports as zero!!! but Exists","ERROR",MB_OK);
			}
			if (bitsSize) {
				su->GetValue(ev,bitsSize,_FileName);
				somSelf->LoadBMPFile(ev, _FileName,NULL);
			}
			break;
	}// endswitch
	su->Focus(ev,kODPropDisplayFrames, kODPosSame, 0, 1, kODPosFirstSib);
	offsetLimit = su->GetSize(ev);
	for (offset = 0; offset < offsetLimit; offset += sizeof(ODStorageUnitRef))
	{
		su->SetOffset(ev,offset);
		su->GetValue(ev,sizeof(ODStorageUnitRef), (ODValue)&aSURef);

		TRY

			frame = su->GetDraft(ev)->GetFrame(ev,su->GetIDFromStorageUnitRef(ev,aSURef));
			_fDisplayFrames->AddLast((ElementType)frame);
			frame->SetDroppable(ev,kODTrue);

		CATCH_ALL

			frame = kODNULL;

		ENDTRY
	}
}

SOM_Scope void SOMLINK CommonInitMetaFilePart(
		MetaFilePart		*somSelf,
		Environment		*ev,
		ODPartWrapper   *partWrapper)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	_fSession = somSelf->GetStorageUnit(ev)->GetSession(ev);
	_fPartWrapper = partWrapper? partWrapper : (ODPartWrapper*)somSelf;
		
	_fDisplayFrames = new OrderedCollection;
	_fEmbeddedFrames = new OrderedCollection;

	_fContents = new OrderedCollection;
	_fSelection = new OrderedCollection;

	_fMetafileMenu.menu = CreatePopupMenu();
	strcpy (_fMetafileMenu.strMenu, "&Graphic");

	AppendMenu(_fMetafileMenu.menu, (WORD)MF_STRING|MF_ENABLED, (WORD)IDM_META_PICK, (LPSTR)"Choose Metafile");
	AppendMenu(_fMetafileMenu.menu, (WORD)MF_STRING|MF_ENABLED, (WORD)IDM_BMP_PICK, (LPSTR)"Choose BMP");
	AppendMenu(_fMetafileMenu.menu, (WORD)MF_STRING|MF_ENABLED, (WORD)IDM_BMP_FIT, (LPSTR)"Fit BMP to Frame");

	_fMenuBar = _fSession->GetWindowState(ev)->CopyBaseMenuBar(ev);

	_fMenuBar->AddMenuLast(ev,IDM_METAFILE, &_fMetafileMenu,  _fPartWrapper);

	_fSelectionFocus = _fSession->Tokenize(ev, kODSelectionFocus);
	_fMenuFocus = _fSession->Tokenize(ev, kODMenuFocus);
	_fKeyFocus = _fSession->Tokenize(ev, kODKeyFocus);

	_fFocusSet = new ODFocusSet();
	_fFocusSet->InitFocusSet(ev);
	_fFocusSet->Add(ev,_fSelectionFocus);
	_fFocusSet->Add(ev,_fMenuFocus);
	_fFocusSet->Add(ev,_fKeyFocus);

	_fhmf = NULL;
	_hBitmap = NULL;
}

//------------------------------------------------------------------------------
// MetaFilePart:: Externalize
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK Externalize(MetaFilePart *somSelf, Environment *ev)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	ODFrame*			aFrame;
	ODStorageUnitRef	aSURef;
	ODULong				offset, offsetLimit;
	ODStorageUnit*		su = _fMetaFileSU;
	
	MetaFilePart_parent_ODPart_Externalize(somSelf,ev);

	int type;
	if (_fhmf)
		type = TYPE_METAFILE;
	else if (_hBitmap)
		type = TYPE_BITMAP;
	else
		type = TYPE_UNKNOWN;
	
	su->Focus(ev,kODGraphicProp,kODPosUndefined,kODGraphicType,0,kODPosUndefined);
	su->SetValue(ev,sizeof(int),&type);
	
	switch (type) {
		
		case TYPE_METAFILE:
			if (_fhmf) {
				su->Focus(ev,kODPropMetafileBits,kODPosSame,kODMetafileBits,1,kODPosFirstSib);
#ifndef WIN32
				HGLOBAL	hBits = GetMetaFileBits(ev,fhmf);
				void	*aBuf = (LPSTR)GlobalLock(ev,hBits);
				if (aBuf) {
					su->SetValue(ev,GlobalSize(hBits), (ODValue)aBuf);
				}
				/* set the metafile bits to the memory that we allocated */
				if (fhmf = SetMetaFileBits(ev,hBits))
					GlobalUnlock(hBits);
				else
				{
					GlobalUnlock(hBits);
					GlobalFree(hBits);
				}
#else
				DWORD dwSize = GetMetaFileBitsEx (_fhmf, 0, NULL);
				void	*aBuf = (LPSTR)GlobalAlloc(GPTR, dwSize);
				if (aBuf)
				{
					GetMetaFileBitsEx(_fhmf, dwSize, aBuf);
					su->SetValue(ev,dwSize, (ODValue)aBuf);
					GlobalFree((HGLOBAL)aBuf);
				}
#endif
			}
			su->Focus(ev,kODPropMetafileIsAldus,kODPosSame,kODMetafileIsAldus,1,kODPosFirstSib);
			su->SetValue(ev,sizeof(boolean), (ODValue)&_fIsAldusMeta);
			su->Focus(ev,kODPropMetafileBox,kODPosSame,kODMetafileBox,1,kODPosFirstSib);
			su->SetValue(ev,sizeof(RECT), (ODValue)&_fAldusBox);
			break;
		
		case TYPE_BITMAP:
			long size=lstrlen(_FileName) + 1;
			su->Focus(ev,kODGraphicProp,kODPosUndefined,kODGraphicFit,0,kODPosUndefined);
			su->SetValue(ev, sizeof(_FitToFrame),&_FitToFrame);
			su->Focus(ev,kODGraphicProp,kODPosUndefined,kODGraphicSize,0,kODPosUndefined);
			su->SetValue(ev, sizeof(size),&size);
			su->Focus(ev,kODPropMetafileBits,kODPosUndefined,kODMetafileBits,0,kODPosUndefined);
			su->SetValue(ev, size,_FileName);
			break;

	}//endswitch
	
	OrderedCollectionIterator aIter(_fDisplayFrames);
	su->Focus(ev,kODPropDisplayFrames,kODPosUndefined,0,1,kODPosFirstSib);
	offsetLimit = su->GetSize(ev);
	offset = 0;
	for (aFrame = (ODFrame*)aIter.First(); aIter.IsNotComplete();
			aFrame = (ODFrame*)aIter.Next(),
			offset+=sizeof(ODStorageUnitRef))
	{
		aSURef = su->GetWeakStorageUnitRef(ev,aFrame->GetStorageUnit(ev)->GetID(ev));
		su->SetOffset(ev,offset);
		su->SetValue(ev,sizeof(ODStorageUnitRef), (ODValue)&aSURef);
	};

	if (offset < offsetLimit)
		su->DeleteValue(ev, offsetLimit - offset);

	su = somSelf->GetStorageUnit(ev);
	su->Focus(ev,kODPropContents,kODPosSame,kODKindTestMetaFile,1,kODPosFirstSib);
	aSURef = su->GetStrongStorageUnitRef(ev,_fMetaFileSU->GetID(ev));
	su->SetValue(ev,sizeof(ODStorageUnitRef),&aSURef);
}


//-------------------------------------------------------------------------
// From Imaging protocol
//-------------------------------------------------------------------------
ODFixed MyfixedMul(ODFixed val1, ODFixed val2)
{
	ODFixed retVal;

	retVal = (((val1 >> 16) * (val2 >> 16)) << 16);
	retVal += ((val1 >> 16) * (val2 & 0xffff));
	retVal += ((val1 & 0xffff) * (val2 >> 16));
	retVal += (((val1 & 0xffff) * (val2 & 0xffff)) >> 16);
	return retVal;
}

 
//  Draw 

SOM_Scope void SOMLINK Draw(
		MetaFilePart	*somSelf,
		Environment     *ev,
		ODFacet* facet, ODShape* invalShape)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	// get the frame we're supposed to draw
	ODFrame* displayFrame = facet->GetFrame(ev);

	if (_fDisplayFrames->Contains(displayFrame) )
	{

		HDC		hdc;
		ODRect	bRect;
		RECT	rect;
		int		sHDC;

		hdc = facet->GetCanvas(ev)->GetPlatformCanvas(ev, kODWindows);
		sHDC = SaveDC(hdc);

		CFocus	*f = new CFocus(facet, invalShape, &hdc);
//		CFocus	*f = new CFocus(facet, kODNULL, &hdc);

		ODShape		*sourceShape;
		int		 	Width;
		int		 	Height;
		int		 	oldMapMode;
	
#ifdef WIN32
		POINT		oldWinOrg, oldVPOrg;
		SIZE		oldWinExtent, oldVPExtent;
#endif

		// Find out how big our frame is (in device space)
		sourceShape = displayFrame->GetFrameShape(ev, kODNULL);
		sourceShape->GetBoundingBox(ev,&bRect);
		bRect.AsWinRect(rect );

		Width = (int)((bRect.right - bRect.left) >> 16);
		Height = (int)((bRect.bottom - bRect.top) >> 16);
		ODReleaseObject(ev,sourceShape);

		// If we have a Metafile to draw
		if (_fhmf)
		{
			FillRect(hdc, &rect, GetStockObject(WHITE_BRUSH));
			if (_fIsAldusMeta)
			{
				/* placeable metafile */
				/* This code makes the Metafile draw so that it fills the frame */
				oldMapMode = SetMapMode(hdc, MM_ANISOTROPIC);

				/* Set Window origin and extent so that it matches the Metafile */
#ifndef WIN32
				SetWindowOrg(hdc, fAldusBox.left, fAldusBox.top);
				SetWindowExt(hdc,abs(fAldusBox.right - fAldusBox.left),
											  abs(fAldusBox.bottom - fAldusBox.top));
#else
				SetWindowOrgEx(hdc, _fAldusBox.left, _fAldusBox.top, &oldWinOrg);
				SetWindowExtEx(hdc,abs(_fAldusBox.right - _fAldusBox.left),
											  abs(_fAldusBox.bottom - _fAldusBox.top), &oldWinExtent);
#endif
				/* Set Viewport origin and extent so that it matches the frame */
				ODTransform* localToGlobal = facet->GetContentTransform(ev, kODNULL);
				ODPoint scale, offset(0,0);
				offset = localToGlobal->TransformPoint(ev, &offset);

				localToGlobal->GetScale(ev, &scale);
				Width = MyfixedMul(Width, scale.x);
				Height = MyfixedMul(Height, scale.y);

#ifndef WIN32
				OffsetViewportOrg(ev,hdc, offset.IntX(ev,), offset.IntY(ev,));
				SetViewportExt(ev,hdc, Width, Height);
#else
				OffsetViewportOrgEx(hdc, offset.IntX(), offset.IntY(), &oldVPOrg);
				SetViewportExtEx(hdc, Width, Height, &oldVPExtent);
#endif
			}
			else
				/* Plain Metafile */
				oldMapMode = SetMapMode(hdc, MM_TEXT);

			PlayMetaFile(hdc, _fhmf);

			/* Restore all the settings to what they where before */
			SetMapMode(hdc, oldMapMode);

		}
		else
		{
			if ( _hBitmap ) // if we have a bitmap draw it
			{
				HBITMAP		origmap,memmap;
				HDC			memdc;

				memdc = CreateCompatibleDC(hdc);
				memmap = somSelf->GetBitmapFromMemory (ev, _hBitmap, hdc);
				origmap = SelectObject(memdc,memmap);
				if (_FitToFrame) {
					StretchBlt(hdc,0,0,Width,Height,memdc,0,0,_biWidth,_biHeight,SRCCOPY);
				}
				else {
					BitBlt(hdc,0,0,_biWidth,_biHeight,memdc,0,0,SRCCOPY);
					if (Width > _biWidth || Height > _biHeight) {
						HRGN rgn = CreateRectRgn ( 0,0,_biWidth,_biHeight);
						HRGN rgn2 = CreateRectRgn (0,0,Width,Height);
						CombineRgn (rgn,rgn,rgn2,RGN_XOR);
						FillRgn(hdc,rgn,GetStockObject(WHITE_BRUSH));
					}
				}
				SelectObject(memdc,origmap);
				DeleteDC(memdc);
				DeleteObject(memmap);

			}
			else
			{
				/* We don't have a Metafile, draw a crossed out rectangle */

				HPEN	hPen, hOldPen;
				FillRect(hdc,&rect,GetStockObject(WHITE_BRUSH));

				hPen = CreatePen(PS_SOLID, 0, RGB(0,0,0));
				hOldPen = SelectObject(hdc, hPen);
#ifndef WIN32
				MoveTo(hdc, 0, 0);
#else
				MoveToEx(hdc, 0, 0, NULL);
#endif
				LineTo(hdc, Width-1, 0);
				LineTo(hdc, 0, Height-1);
				LineTo(hdc, Width-1, Height-1);
				LineTo(hdc, 0, 0);
				LineTo(hdc, 0, Height-1);
#ifndef WIN32
				MoveTo(hdc, Width-1, 0);
#else
				MoveToEx(hdc, Width-1, 0, NULL);
#endif
				LineTo(hdc, Width-1, Height-1);
				SelectObject(hdc, hOldPen);
				DeleteObject(hPen);
			}
		}
		//////////
		// end of display code
		//////////
		delete f;
		RestoreDC(hdc, sHDC);
	}
	else
	{
		// !!! signal error: invalid frame
	}
}


//  HandleMouseDown 
SOM_Scope ODBoolean SOMLINK HandleMouseDown(
		MetaFilePart *somSelf, Environment *ev,
		ODFacet* facet,	ODPoint *where, ODEventData *event)
{
/* If we get clicked on */
	if (!facet->GetWindow(ev)->IsActive(ev))
		facet->GetWindow(ev)->Select(ev);
	else
		somSelf->ActivateFrame(ev, facet->GetFrame(ev));

	return kODTrue;
}


SOM_Scope ODBoolean SOMLINK LoadMetaFile(
		MetaFilePart *somSelf, Environment *ev,
		LPSTR lpFileName, ODFrame* focusFrame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	HFILE			fh;									  
	UINT			wBytesRead;
	int				retVal = FALSE;
	DWORD			dwIsAldus;
	HANDLE			hMem;
	LPSTR			lpMem;                     
	HMETAFILE		hMF;					  
	METAHEADER		mfHeader;
	ALDUSMFHEADER	aldusMFHeader;
	long			mfhOffset;
	boolean			isAldus;

	fh = _lopen(lpFileName, OF_READ);

 /* if opened successfully */
	if (fh != -1) {
		if ( _hBitmap )
		{
			GlobalFree (_hBitmap );
			_hBitmap = NULL;
		}
		while (TRUE) {
			/* read the first dword of the file to see if it is a placeable wmf */
			wBytesRead = _lread(fh,(LPVOID)&dwIsAldus, sizeof(dwIsAldus));

			if (wBytesRead == -1 || wBytesRead < sizeof(dwIsAldus))  {
				_lclose(fh);
				MessageBox(0, "unable to read file", NULL,
							 MB_OK | MB_ICONEXCLAMATION);
				break;
			}

			/* if this is windows metafile, not a placeable wmf */
			if (dwIsAldus != ALDUSKEY)  {
				mfhOffset = 0;
				isAldus = FALSE;
			} else { /* This is a placeable metafile */

				/* seek to beginning of file and read aldus header */
				_llseek(fh, 0, 0);

				/* read the placeable header */
				wBytesRead = _lread(fh, (LPVOID)&aldusMFHeader, AldusHeaderSize);

				/* if there is an error, return */
				if(wBytesRead == -1 || wBytesRead < AldusHeaderSize ) {
					MessageBox(0, "Unable to read placeable header",
								NULL, MB_OK | MB_ICONHAND);
					break;
				}

				mfhOffset = AldusHeaderSize;
				isAldus = TRUE;
			}

			/* seek back to the start of metafile header */
			_llseek(fh, mfhOffset, 0);

			/* read the metafile header */
			wBytesRead = _lread(fh, (LPSTR)&mfHeader, sizeof(METAHEADER));

			/* if there is an error return */
			if( wBytesRead == -1 || wBytesRead < sizeof(METAHEADER) )  {
				MessageBox(0, "Unable to read metafile header",
									NULL, MB_OK | MB_ICONHAND);
				break;
			}

			/* allocate memory for the metafile bits */
			if (!(hMem = GlobalAlloc(GHND, (mfHeader.mtSize * 2L))))  {
				MessageBox(0, "Unable to allocate memory for metafile bits",
							NULL, MB_OK | MB_ICONHAND);
				break;
			}

			/* lock the memory */
			lpMem = (LPSTR)GlobalLock(hMem);
			if (!lpMem) {
				MessageBox(0, "Unable to lock memory for metafile bits",
							NULL, MB_OK | MB_ICONHAND);
				GlobalFree(hMem);
				break;
			}

			/* seek back to the start of metafile header */
			_llseek(fh, mfhOffset, 0);

			/* read metafile bits */
			wBytesRead = _lread(fh, lpMem, (UINT)(mfHeader.mtSize * 2));

			/* if there was an error */
			if( wBytesRead == -1 )  {
				MessageBox(0, "Unable to read metafile bits",
							NULL, MB_OK | MB_ICONHAND);
				GlobalUnlock(hMem);
				GlobalFree(hMem);
				break;
			}

			/* set the metafile bits to the memory that we allocated */
#ifndef WIN32
			if (!(hMF = SetMetaFileBits(hMem))) {
#else
			if (!(hMF = SetMetaFileBitsEx(mfHeader.mtSize * 2, (CONST BYTE*)lpMem))) {
#endif
				GlobalUnlock(hMem);
				GlobalFree(hMem);
				break;
			}

			GlobalUnlock(hMem);
			retVal = TRUE;
			break;
		} /* End: while(TRUE) */
		/* close the file */
		_lclose(fh);
	}

	if (retVal && hMF)
	{
		if (_fhmf) 
			DeleteMetaFile(_fhmf);

		_fhmf = hMF;
		_fIsAldusMeta = isAldus;
		_fAldusBox.left = aldusMFHeader.bbox.Left;
		_fAldusBox.right = aldusMFHeader.bbox.Right;
		_fAldusBox.top = aldusMFHeader.bbox.Top;
		_fAldusBox.bottom = aldusMFHeader.bbox.Bottom;
		if (isAldus) {
			/* If we have a placable Metafile, then try to make our frame's
			   proportions match the Metafile's */

			ODShape 	*TheShapeIWant;
			ODRect		MyRect;

			TheShapeIWant = focusFrame->GetFrameShape(ev, kODNULL);
			TheShapeIWant->GetBoundingBox(ev,&MyRect);
			MyRect.right = MyRect.left + ((long)260 << 16);
			MyRect.bottom = MyRect.top + (((long)260 * abs(_fAldusBox.bottom - _fAldusBox.top) / abs(_fAldusBox.right - _fAldusBox.left)) << 16);
			ODReleaseObject(ev, TheShapeIWant);

			TheShapeIWant = new ODShape();
			TheShapeIWant->SetRectangle(ev, &MyRect);
			focusFrame->RequestFrameShape(ev,TheShapeIWant, kODNULL);
			focusFrame->ChangeUsedShape(ev, kODNULL, kODNULL);
			focusFrame->Invalidate(ev,NULL, kODNULL);
			focusFrame->InvalidateActiveBorder(ev);

		}
	}
	return retVal;
}

SOM_Scope ODBoolean SOMLINK LoadBMPFile(
		MetaFilePart *somSelf, Environment *ev,
		LPSTR lpFileName, ODFrame* focusFrame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	long				wBytesRead;
	int					retVal = FALSE;
	long				filesize;
	BITMAPFILEHEADER	bmpHeader;
	BITMAPINFOHEADER	bmpInfoHeader;

	_fh = _lopen(lpFileName, OF_READ);

 /* if opened successfully */
	if (_fh != -1)
	{

		filesize = _llseek (_fh,0,SEEK_END);
		_llseek(_fh,0,SEEK_SET);
		if (_fhmf)
		{
			DeleteMetaFile(_fhmf);
			_fhmf = NULL;
		}
		/* read the first dword of the file to see if it is a bmp file*/
		wBytesRead = _lread( _fh, (LPSTR)&bmpHeader, sizeof(BITMAPFILEHEADER));

		if ( ( wBytesRead == -1 ) || ( wBytesRead < sizeof(BITMAPFILEHEADER) )
				|| ( bmpHeader.bfType != 0x4D42 ) )
		{
			_lclose(_fh);
			MessageBox(0, "Doesn't Appear to be a Bitmap File!", NULL,
				MB_OK | MB_ICONEXCLAMATION);
			return (retVal);
		}

		/* read the header */
		wBytesRead = _lread(_fh, (LPSTR)&bmpInfoHeader, sizeof(BITMAPINFOHEADER));

		/* if there is an error or it's a compressed file, return */
		if( bmpInfoHeader.biSize != sizeof(BITMAPINFOHEADER) )
		{
			MessageBox(0, "Sorry dude I can't read old bitmaps.  Come into reality!  Bitmaps aren't stored that way anymore.",
				NULL, MB_OK | MB_ICONHAND);
			return (retVal);
		}
		/* if there is an error or it's a compressed file, return */
		if( ( wBytesRead == -1 ) || ( wBytesRead < sizeof(BITMAPINFOHEADER) )
				|| ( bmpInfoHeader.biCompression ) )
		{
			MessageBox(0, "Unable to read compressed bitmap file",
				NULL, MB_OK | MB_ICONHAND);
			return (retVal);
		}
		if (_hBitmap)
			GlobalFree(_hBitmap);
		// adjust filesize to the size we really want to read
		filesize -= sizeof (BITMAPFILEHEADER);
		_hBitmap = GlobalAlloc(GHND, filesize);
		if (!_hBitmap ) {
			MessageBox (NULL,"Couldn't Allocate enough Memory for Bitmap!","Error",MB_OK);
			return(retVal);
		}
		char  *ptr;
		ptr = (LPSTR)GlobalLock(_hBitmap);
		if (!ptr) {
			MessageBox (NULL,"Couldn't lock memory!","Error",MB_OK);
			return(retVal);
		}

		_llseek(_fh,sizeof(BITMAPFILEHEADER),SEEK_SET); // get to important info and read
		long bytesread;
		bytesread = _hread (_fh,ptr,filesize);
		if (bytesread < filesize) {
			MessageBox (NULL,"Couldn't read file contents!","Error",MB_OK);
			return (retVal);
		}


		//save off width and height
		bmpInfoHeader.biSize=sizeof (bmpInfoHeader);
		_biWidth = (int) bmpInfoHeader.biWidth;
		_biHeight = (int) bmpInfoHeader.biHeight;

		GlobalUnlock(_hBitmap);
		retVal = TRUE;
		/* close the file */
		_lclose(_fh);
		lstrcpy(_FileName,lpFileName);
	}

	if (retVal && _hBitmap && focusFrame)
	{
		ODShape 	*TheShapeIWant;
		ODRect		MyRect;

		TheShapeIWant = focusFrame->GetFrameShape(ev, kODNULL);
		TheShapeIWant->GetBoundingBox(ev,&MyRect);
		MyRect.right = MyRect.left + ( (ODULong)_biWidth << 16 );
		MyRect.bottom = MyRect.top + ( (ODULong)_biHeight << 16 );
		ODReleaseObject(ev, TheShapeIWant);

		TheShapeIWant = new ODShape();
		TheShapeIWant->SetRectangle(ev,&MyRect);
		focusFrame->RequestFrameShape(ev,TheShapeIWant, kODNULL);
		focusFrame->ChangeUsedShape(ev,kODNULL, kODNULL);
		focusFrame->Invalidate(ev,NULL, kODNULL);
		focusFrame->InvalidateActiveBorder(ev);
	}
	return retVal;
}

SOM_Scope ODBoolean SOMLINK HandleLoadEvent(
		MetaFilePart *somSelf, Environment *ev,
		ODFrame* focusFrame, ODEventData *event)
{
	char    szFile[128];
	OPENFILENAME of;
	memset(&of, '\0', sizeof(OPENFILENAME));

	switch ( event->wParam )
	{
		case IDM_META_PICK:
			lstrcpy ( szFile, "*.WMF" );
			of.lpstrFilter  = (LPSTR)"Metafile (*.WMF)\0*.WMF\0All (*.*)\0*.*\0";
			break;
		case IDM_BMP_PICK:
			lstrcpy ( szFile, "*.BMP" );
			of.lpstrFilter  = (LPSTR)"BMP (*.BMP)\0*.BMP\0All (*.*)\0*.*\0";
			break;
	}

	of.lStructSize  = sizeof(OPENFILENAME);
//	of.hwndOwner    = fWnd;
	of.hwndOwner    = 0;
//	of.lpstrFilter  = (LPSTR)"Metafile (*.WMF)\0*.WMF\0BMP (*.BMP)\0*.BMP\0All (*.*)\0*.*\0";
	of.lpstrCustomFilter = NULL;
	of.nFilterIndex = 1;
	of.lpstrFile    = (LPSTR)szFile;
	of.nMaxFile     = sizeof(szFile);
	of.lpstrInitialDir = NULL;
	of.lpstrTitle   = NULL;
	of.Flags        = OFN_FILEMUSTEXIST;
	of.lpstrDefExt  = NULL;

	if(GetOpenFileName(&of))
	{
		switch ( event->wParam )
		{
			case IDM_META_PICK:
				somSelf->LoadMetaFile(ev, of.lpstrFile, focusFrame);
				break;

			case IDM_BMP_PICK:
				somSelf->LoadBMPFile(ev, of.lpstrFile, focusFrame);
				break;
		}
	}
	return kODTrue;
}

//  HandleMenuEvent 
SOM_Scope ODBoolean SOMLINK HandleMenuEvent(
		MetaFilePart *somSelf, Environment *ev,
		ODFrame* focusFrame, ODEventData *event)
{

//	ASSERTM(fMenuBar != kODNULL, 0, "Menubar is NULL");
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	ODBoolean handled = kODFalse;

	// Until such time as we clean this up and register all commands:
	switch (event->wParam)
	{
		case IDM_BMP_FIT:
			_FitToFrame ^= 1;
			if (_hBitmap)
				focusFrame->Invalidate(ev, NULL, kODNULL);
			break;

		case IDM_META_PICK:
		case IDM_BMP_PICK:
			return somSelf->HandleLoadEvent(ev, focusFrame, event);

		case kODCommandViewAsWin:
			{
				Proxy* p;
				OrderedCollectionIterator i(_fSelection);
				for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
				{
					ODFrame* frame = p->frame;
					ODPart* part
							= frame ? frame->GetPart(ev) : (ODPart*)kODNULL;
					if (part)
						part->Open(ev, frame);
				}
			}
			handled = kODTrue;
			break;

		case kODCommandGetPartInfo:
			{
				Proxy* p;
				OrderedCollectionIterator i(_fSelection);
				p = (Proxy*) i.First();
				if (p!=kODNULL) {
BGNBP//bgn					ShowPartFrameInfo(p->frame);
					handled = kODTrue;
				}
			}
			break;
		default:
			break;
	}

	return handled;
}

//  ActivateFrame 
SOM_Scope void SOMLINK ActivateFrame(
		MetaFilePart *somSelf, Environment *ev, ODFrame* frame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	if (frame != kODNULL) {
		PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
		if (!(pInfo->fIsActive))
		{
			ODBoolean succeeded = kODFalse;

			succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev,_fFocusSet,frame);

			if (succeeded)
			{
				somSelf->FocusAcquired(ev,_fSelectionFocus, frame);
				somSelf->FocusAcquired(ev,_fMenuFocus, frame);
				somSelf->FocusAcquired(ev,_fKeyFocus, frame);
			}
		}
	}
}


SOM_Scope ODShape* SOMLINK RequestFrameShape(MetaFilePart *somSelf, Environment *ev,
	ODFrame* embeddedFrame, ODShape* frameShape)
{
ODUnused(embeddedFrame);
ODUnused(frameShape);

	THROW(kODErrCannotEmbed);
	return (ODShape *)kODNULL;
}


SOM_Scope ODExtension* SOMLINK GetExtension(MetaFilePart *somSelf, Environment *ev,
			ODType extensionName)
{
	
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	return (ODExtension*)kODNULL;
}


SOM_Scope ODBoolean SOMLINK HasExtension(
		MetaFilePart *somSelf, Environment *ev,
		ODType extensionName)
{
	
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	LPSTR	shadowWindow = "WindowsShadowWindow";
	if (!lstrcmpi((LPSTR)extensionName, (LPSTR)shadowWindow))
		return kODTrue;
	else
		return kODFalse;
}

//  FullfillPromise 
SOM_Scope void SOMLINK FulfillPromise(
		MetaFilePart *somSelf, Environment *ev,
		ODStorageUnitView *promiseSUView)
{
ODUnused(promiseSUView);
}


//  NotifyDropComplete 
SOM_Scope void SOMLINK DropCompleted(
		MetaFilePart *somSelf, Environment *ev,
		ODPart* destPart, ODDropResult dropResult)
{
ODUnused(destPart);
ODUnused(dropResult);
}

//------------------------------------------------------------------------------
// MetaFilePart::DragEnter
//------------------------------------------------------------------------------
SOM_Scope ODBoolean SOMLINK DragEnter(
		MetaFilePart *somSelf, Environment *ev,
		ODDragItemIterator* dragInfo,				//OLE2
		ODFacet	*facet,	ODPoint	*where )
{
ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

return	kODFalse;														//OLE2
}


//------------------------------------------------------------------------------
// MetaFilePart::DragWithin
//------------------------------------------------------------------------------
SOM_Scope ODBoolean SOMLINK DragWithin(
		MetaFilePart *somSelf, Environment *ev,
		ODDragItemIterator*	dragInfo,			//OLE2
		ODFacet		*facet,
		ODPoint		*where )
{
ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

	// MetaFile Part does not allow embedding of data.
	// This method is not needed.
return	kODFalse;														//OLE2
}


//------------------------------------------------------------------------------
// MetaFilePart::DragLeave
//------------------------------------------------------------------------------
SOM_Scope void SOMLINK DragLeave(
		MetaFilePart *somSelf, Environment *ev,
		ODFacet	*facet,	ODPoint	*where )
{
ODUnused(facet);
ODUnused(where);

}

//------------------------------------------------------------------------------
// MetaFilePart::Drop
//------------------------------------------------------------------------------
SOM_Scope ODDropResult SOMLINK Drop(
		MetaFilePart *somSelf, Environment *ev,
		ODDragItemIterator* dropInfo,
		ODFacet*		facet,
		ODPoint*		where )
{
ODUnused(dropInfo);
ODUnused(facet);
ODUnused(where);

	return kODDropMove;
}

//  DisplayFrameAdded 
SOM_Scope void SOMLINK DisplayFrameAdded(
		MetaFilePart *somSelf, Environment *ev,	ODFrame* frame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
		
	if (frame->GetPart(ev) == _fPartWrapper)		// frame belongs to me
	{
		OrderedCollectionIterator	displayFramesIter(_fDisplayFrames);
		if (displayFramesIter.IsNotComplete() == kODFalse) {
			OrderedCollectionIterator	contentsIter(_fContents);
			Proxy*						proxy;
			
			for (proxy = (Proxy*) contentsIter.First();
					contentsIter.IsNotComplete();
					proxy = (Proxy*) contentsIter.Next())
			{
				proxy->frame->SetContainingFrame(ev,frame);
			}
		}

		// !!! do something with viewType and partInfo...
		PartInfoRec* pInfo = new PartInfoRec;

		if (frame->IsRoot(ev))
			pInfo->fNeedsActivating = kODTrue;

		frame->SetPartInfo(ev,(ODInfoType) pInfo);
		_fDisplayFrames->AddLast(frame);
		frame->IncrementRefCount(ev);
		frame->SetDroppable(ev,kODTrue);

		if (frame->GetViewType(ev) == kODNullTypeToken)						// if frame view is set don't change it
			frame->SetViewType(ev, _fSession->Tokenize(ev,kODViewAsFrame));		// if not, make it viewasframe
		
		if (frame->GetContainingFrame(ev) == kODNULL)
		{
			//Wrong place. this->ActivateFrame(ev,frame);
		}
	}
	else
		THROW(kODErrInvalidFrame);

	// render in frame?
}



//  FrameShapeChanged 
SOM_Scope void SOMLINK FrameShapeChanged(
		MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	if (_fDisplayFrames->Contains(frame))
	{
	}
	else
		THROW(kODErrInvalidFrame);

	somSelf->MoveSizeShadowWindow(ev, frame);
}

//------------------------------------------------------------------------------
// MetaFilePart::WritePartInfo
//------------------------------------------------------------------------------
SOM_Scope void SOMLINK WritePartInfo(
		MetaFilePart *somSelf, Environment *ev,
		ODPtr partInfo, ODStorageUnitView* storageUnitView)
{
	if (partInfo)
	{
		ODBoolean needsActivating = ((PartInfoRec*)partInfo)->fNeedsActivating
									|| ((PartInfoRec*)partInfo)->fIsActive;
		storageUnitView->SetValue(ev,sizeof(ODBoolean),
									(ODValue)&needsActivating);
	}
}


//------------------------------------------------------------------------------
// MetaFilePart::ReadPartInfo
//------------------------------------------------------------------------------
SOM_Scope ODPtr SOMLINK ReadPartInfo(
		MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame, ODStorageUnitView*	storageUnitView)
{

ODUnused(frame);

	if (storageUnitView->GetSize(ev))
	{
		PartInfoRec* partInfo = new PartInfoRec;

		ODBoolean needsActivating;
		storageUnitView->GetValue(ev,sizeof(ODBoolean),
									(ODValue)&(needsActivating));
		partInfo->fNeedsActivating = needsActivating;

		return partInfo;
	}
	else
		return ((ODPtr)kODNULL);
}

//  Open 
SOM_Scope ODID SOMLINK Open(MetaFilePart *somSelf, Environment *ev,
			ODFrame* frame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	ODWindow* window = kODNULL;

	if (frame) // Doing a View As Window
	{
		window = _fSession->GetWindowState(ev)->GetWindow(ev,_fWindowID);
		if (window)
			window->Select(ev);
		else
		{
			window = somSelf->MetaFileCreateWindow(ev,frame);
			_fWindowID = window->GetID(ev);
			window->Open(ev);
			window->Show(ev);
			window->Select(ev);			
		}
	}
	else
	{
		window = somSelf->MetaFileCreateWindow(ev,frame);
		_fWindowID = window->GetID(ev);
		window->Open(ev);
		window->Show(ev);
		window->Select(ev);			
	}
	return window->GetID(ev);
}

SOM_Scope ODWindow* SOMLINK MetaFileCreateWindow(
		MetaFilePart *somSelf, Environment *ev,
		ODFrame* sourceFrame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	ODWindow* window = kODNULL;
	ODPlatformWindow platformWindow;

	platformWindow = _fSession->GetWindowState(ev)->CreatePlatformWindow(ev,kODFalse, WS_CHILD|WS_CLIPSIBLINGS);
	
	window = _fSession->GetWindowState(ev)->RegisterWindow(ev,
				platformWindow,
				kODNULL,
				(sourceFrame==kODNULL),	// Keeps draft open
				kODTrue,	// Is resizable
				kODFalse,	// Is floating
				kODTrue,  // should save
				_fPartWrapper,
				kODNullTypeToken,
				kODNullTypeToken,
				sourceFrame);

	return window;
}


//  UsedShapeChanged 
SOM_Scope void SOMLINK UsedShapeChanged(
		MetaFilePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	if (_fEmbeddedFrames->Contains(embeddedFrame))
	{
	}
	else
		THROW(kODErrInvalidFrame);
}


//  FacetAdded 
SOM_Scope void SOMLINK FacetAdded(
		MetaFilePart *somSelf, Environment *ev,
		ODFacet* facet)
{
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	ODFrame* dispFrame = facet->GetFrame(ev);
	if (!_fDisplayFrames->Contains(dispFrame))
		THROW(kODErrInvalidFacet);

	if (_fShadowWindow == kODNULL)
	{
		_fShadowWindow = somSelf->CreateShadowWindow (ev, facet->GetFrame(ev), facet->GetWindow(ev)->GetPlatformWindow(ev));
		if(_fShadowWindow)
			_fShadowUsage  = 1;

		ODFrame *containingFrame = facet->GetFrame(ev)->GetContainingFrame(ev);
		if (containingFrame) {
			ODPart *containingPart = containingFrame->GetPart(ev);
			if (containingPart->HasExtension (ev,"WindowsShadowWindow"))
			{
				ODPlatformWindow *shadowWindow =
					(ODPlatformWindow*)containingPart->GetExtension(ev,"WindowsShadowWindow");
				SetParent (_fShadowWindow, *shadowWindow);
			}
		}
	}
	else
		_fShadowUsage++;

}

//  FacetRemoved 
SOM_Scope void SOMLINK FacetRemoved(
		MetaFilePart *somSelf, Environment *ev,
		ODFacet* facet)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	ODFrame* dispFrame = facet->GetFrame(ev);
	if (!_fDisplayFrames->Contains(dispFrame))
		THROW(kODErrInvalidFacet);

	OrderedCollection* children = new OrderedCollection;
	ODFacetIterator* facets = facet->CreateFacetIterator(ev,kODChildrenOnly, kODFrontToBack);
	for (ODFacet* childFacet = facets->First(ev);
		facets->IsNotComplete(ev);
		childFacet = facets->Next(ev))
	{
		children->AddLast(childFacet);
	}
	delete facets;
	OrderedCollectionIterator iter(children);
	for (childFacet = (ODFacet*)iter.First();
			iter.IsNotComplete();
			childFacet = (ODFacet*)iter.Next())
	{
		facet->RemoveFacet(ev,childFacet);
		delete childFacet;
	}
	delete children;

	if (_fShadowWindow)
	{
		_fShadowUsage--;
		if(!_fShadowUsage)
		{
			DestroyWindow (_fShadowWindow);
			_fShadowWindow	= 0;
		}
	}

}

//  ClipShapeChanged 
SOM_Scope void SOMLINK GeometryChanged(
		MetaFilePart *somSelf, Environment *ev,
		ODFacet* facet)
{
	somSelf->MoveSizeShadowWindow(ev,facet->GetFrame(ev));
}


//-------------------------------------------------------------------------
// From Part Activation protocol
//-------------------------------------------------------------------------

//  RelinquishFocus 
SOM_Scope void SOMLINK CommitRelinquishFocus(
		MetaFilePart *somSelf, Environment *ev,
		ODTypeToken focus, ODFrame* currentFrame, ODFrame* proposedFrame)
{
ODUnused(proposedFrame);

	somSelf->FocusLost(ev,focus, currentFrame);
}

//  FocusAcquired 
SOM_Scope void SOMLINK FocusAcquired(
		MetaFilePart *somSelf, Environment *ev,
		ODTypeToken focus, ODFrame* newOwner)
{
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	if (focus == _fSelectionFocus)
	{
		PartInfoRec* pInfo = (PartInfoRec*) newOwner->GetPartInfo(ev);
		pInfo->fIsActive = kODTrue;
	}
	else if (focus == _fMenuFocus)
		somSelf->InstallMenus(ev,newOwner);
}

//  FocusLost 
SOM_Scope void SOMLINK FocusLost(
		MetaFilePart *somSelf, Environment *ev,
		ODTypeToken focus, ODFrame* oldOwner)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	if (focus == _fSelectionFocus)
	{
		PartInfoRec* pInfo = (PartInfoRec*) oldOwner->GetPartInfo(ev);
		pInfo->fIsActive = kODFalse;
	}
	else if (focus == _fMenuFocus)
		somSelf->RemoveMenus(ev,oldOwner);
}

//  HandleEvent  !!!

SOM_Scope ODBoolean SOMLINK HandleEvent(
		MetaFilePart *somSelf, Environment *ev,
		ODEventData *event, ODFrame* frame, ODFacet* facet)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	ODBoolean handled = kODFalse;
	POINT p;

	LONG2POINT (event->lParam, p);
	ODPoint point = p;

	switch (event->message)
	{
		case WM_LBUTTONDOWN:
			handled = somSelf->HandleMouseDown(ev,facet,&point,event);
			break;

		case WM_COMMAND:
			handled = somSelf->HandleMenuEvent(ev,frame,event);
			break;

		case WM_ACTIVATE:
			handled = kODTrue; // actually ignored by dispatcher
			if (event->wParam  != WA_INACTIVE)
				somSelf->ActivatingWindow(ev,frame);
			else
				somSelf->DeActivatingWindow(ev,frame);
			break;

		default:
			return kODFalse;
	}
	return handled;
}

//------------------------------------------------------------------------------
// MetaFilePart::MouseEnter
//------------------------------------------------------------------------------
SOM_Scope void SOMLINK MouseEnter(
			MetaFilePart *somSelf, Environment *ev,
			ODFacet* facet, ODPoint *where)
{
	ODUnused(facet);
	ODUnused(where);
}

//------------------------------------------------------------------------------
// MetaFilePart::MouseWithin
//------------------------------------------------------------------------------
SOM_Scope void SOMLINK MouseWithin(
		MetaFilePart *somSelf, Environment *ev,
		ODFacet* facet, ODPoint *where)
{
	ODUnused(facet);
	ODUnused(where);
}

//------------------------------------------------------------------------------
// MetaFilePart::MouseLeave
//------------------------------------------------------------------------------
SOM_Scope void SOMLINK MouseLeave(
		MetaFilePart *somSelf, Environment *ev, ODFacet* facet)
{
	ODUnused(facet);
}


//------------------------------------------------------------------------------
// MetaFilePart::AdjustMenus
//------------------------------------------------------------------------------
SOM_Scope void SOMLINK AdjustMenus(
		MetaFilePart *somSelf, Environment *ev, ODFrame* frame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	if (frame->GetContainingFrame(ev) == kODNULL)
	{
		_fMenuBar->EnableCommand(ev,kODCommandPageSetup, kODTrue);
		_fMenuBar->EnableCommand(ev,kODCommandPrint, kODTrue);
	}
	else
	{
		_fMenuBar->EnableCommand(ev,kODCommandPageSetup, kODFalse);
		_fMenuBar->EnableCommand(ev,kODCommandPrint, kODFalse);
	}

	_fMenuBar->EnableCommand(ev,kODCommandGetPartInfo, kODTrue);

	// if a part is selected
	_fMenuBar->EnableCommand(ev,kODCommandOpen, kODTrue);
		
	_fMenuBar->EnableCommand(ev,kODCommandViewAsWin, !frame->IsRoot(ev));

	ODBoolean hasSelection = _fSelection->Count()>0;

	_fMenuBar->EnableCommand(ev,kODCommandCut, hasSelection);
	_fMenuBar->EnableCommand(ev,kODCommandCopy, hasSelection);
	_fMenuBar->EnableCommand(ev,kODCommandClear, hasSelection);
	_fMenuBar->EnableCommand(ev,kODCommandPasteAs, kODFalse);
	_fMenuBar->EnableCommand(ev,kODCommandSelectAll, _fEmbeddedFrames->Count()>0);
	_fMenuBar->CheckCommand(ev,IDM_BMP_FIT,_FitToFrame);
}

//  DeActivateFrame 
SOM_Scope void SOMLINK DeActivateFrame(
		MetaFilePart *somSelf, Environment *ev, ODFrame* frame)
{
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	if (frame !=  kODNULL) {
		_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev,_fFocusSet,frame);
		somSelf->FocusLost(ev,_fSelectionFocus, frame);
		somSelf->FocusLost(ev,_fMenuFocus, frame);
		somSelf->FocusLost(ev,_fKeyFocus, frame);
	}
}

//  ActivatingWindow 
SOM_Scope void SOMLINK ActivatingWindow(
		MetaFilePart *somSelf, Environment *ev, ODFrame* frame)
{
	
	PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
	if (pInfo->fNeedsActivating)
		somSelf->ActivateFrame(ev,frame);
}


//  DeActivatingWindow 
SOM_Scope void SOMLINK DeActivatingWindow(
		MetaFilePart *somSelf, Environment *ev, ODFrame* frame)
{
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);
	
	PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
	if (frame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev,_fSelectionFocus))
			pInfo->fNeedsActivating = kODTrue;
	else
		pInfo->fNeedsActivating = kODFalse;
}

//  InstallMenus 
SOM_Scope void SOMLINK InstallMenus(
		MetaFilePart *somSelf, Environment *ev, ODFrame* frame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	if (frame && _fMenuBar)
		_fMenuBar->Display(ev);
}

//  RemoveMenus 
SOM_Scope void SOMLINK RemoveMenus(
		MetaFilePart *somSelf, Environment *ev, ODFrame* frame)
{
ODUnused(frame);
}


SOM_Scope HWND SOMLINK CreateShadowWindow(
		MetaFilePart *somSelf, Environment *ev, 
		ODFrame* frame, ODPlatformWindow hParent)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	WNDCLASS  wc;

	if (!GetClassInfo((HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE), "ShadowWindow", &wc))
	{
		wc.style         = CS_DBLCLKS;
		wc.lpfnWndProc   = ShadowWindowProc;			// exported static member of ODShell
		wc.cbClsExtra    = 0;
		wc.cbWndExtra    = 4;
		wc.hInstance     = (HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE);
		wc.hIcon	        = NULL;
		wc.hCursor	     = LoadCursor(NULL,IDC_ARROW);
		wc.hbrBackground = NULL;
		wc.lpszMenuName  = NULL;
		wc.lpszClassName = "ShadowWindow";

		if (!RegisterClass (&wc) )
			return (HWND)kODFalse;
	}

	_fShadowWindow = CreateWindowEx (WS_EX_TRANSPARENT,	"ShadowWindow",
						"",
						WS_CHILD|WS_VISIBLE,
						0, 0, 0, 0,
						hParent,
						NULL,
						(HINSTANCE)GetWindowLong(hParent, GWL_HINSTANCE),
						NULL);

	if (_fShadowWindow) {
		SetWindowLong (_fShadowWindow, 0, (LONG)somSelf);
		somSelf->MoveSizeShadowWindow(ev, frame);
	}

	return _fShadowWindow;
}

SOM_Scope void SOMLINK MoveSizeShadowWindow(
		MetaFilePart *somSelf, Environment *ev, ODFrame *frame)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	HWND		hwndMove;

	if (_fShadowWindow)
	{
		ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
		ODShape* tempShape = (ODShape*) facets->First(ev)->GetActiveShape(ev, kODNULL)->Copy(ev);
		if (facets->First(ev)->GetWindow(ev)->GetPlatformWindow(ev) == GetParent(_fShadowWindow))
			tempShape->Transform(ev,facets->First(ev)->GetContentTransform(ev, kODNULL));
		else
			tempShape->Transform(ev,facets->First(ev)->GetExternalTransform(ev, kODNULL));
		
		RECT rc;
	
		GetRgnBox (tempShape->GetWinRegion(ev), &rc);
		
		MoveWindow (_fShadowWindow, rc.left, rc.top,
			rc.right - rc.left, rc.bottom - rc.top, TRUE);
		ODDeleteObject(tempShape);
		
		delete facets;
		GetClientRect (_fShadowWindow, &rc);

		hwndMove	= GetDlgItem(_fShadowWindow,100);
		if(hwndMove)
			MoveWindow (hwndMove, rc.right - GetSystemMetrics(SM_CXVSCROLL),
				rc.top,	GetSystemMetrics(SM_CXVSCROLL), rc.bottom, TRUE);
	}
}

LRESULT CALLBACK ShadowWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	ODEventData				event;
	MetaFilePart			*part;
	OrderedCollection		*frames;
	ODFrameFacetIterator	*facets;

	switch (message) {

		case WM_NCHITTEST:
			return HTTRANSPARENT;

		case WM_COMMAND:
		case WM_VSCROLL:
			Environment *ev = somGetGlobalEnvironment();
			
			part = (MetaFilePart*)GetWindowLong (hWnd, 0);
			frames = part->GetDisplayFrames(ev);
			facets = ((ODFrame*)frames->First())->CreateFacetIterator(ev);

			part->ActivateFrame(ev, (ODFrame *)frames->First());

			event.message = message;
			event.wParam = wParam;
			event.lParam = lParam;
			part->HandleEvent(ev, &event, (ODFrame *)frames->First(), facets->First(ev));
			delete facets;
			break;
	}

	return (DefWindowProc(hWnd, message, wParam, lParam));
}


SOM_Scope HBITMAP SOMLINK GetBitmapFromMemory(
		MetaFilePart *somSelf, Environment *ev, HGLOBAL hMem,HDC dc)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	HBITMAP hmap;
	char  *ptr;
	BITMAPINFO *binfo;
	char  *bits;
	
	ptr= (LPSTR)GlobalLock(hMem);
	int numofcolors;

	if (!ptr)
		return (NULL);

	binfo = (BITMAPINFO *)ptr;
	numofcolors = binfo->bmiHeader.biClrUsed;
	_biWidth=binfo->bmiHeader.biWidth;
	_biHeight=binfo->bmiHeader.biHeight;
	if (!numofcolors && binfo->bmiHeader.biBitCount!=24)
		numofcolors=(1 << binfo->bmiHeader.biBitCount);

	if (numofcolors)
		bits = ptr + sizeof(BITMAPINFO) + (sizeof(RGBQUAD) * (numofcolors -1));
	else
		bits = ptr + sizeof(BITMAPINFO);
	hmap = CreateDIBitmap (dc, &(binfo->bmiHeader),CBM_INIT,
											bits,binfo, DIB_RGB_COLORS);
	GlobalUnlock(hMem);
	return (hmap);
}

SOM_Scope OrderedCollection*  SOMLINK GetDisplayFrames(MetaFilePart *somSelf, Environment *ev)
{
	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	return _fDisplayFrames;
}


SOM_Scope void  SOMLINK CanvasUpdated(MetaFilePart *somSelf, Environment *ev,
		ODCanvas* canvas)
{
	 MetaFilePartData *somThis = MetaFilePartGetData(somSelf);

	ODUnused(canvas);
}

SOM_Scope void  SOMLINK CanvasChanged(MetaFilePart *somSelf, Environment *ev,
		ODFacet* facet)
{
	 MetaFilePartData *somThis = MetaFilePartGetData(somSelf);

	ODUnused(facet);
}


SOM_Scope ODFrame*  SOMLINK RequestEmbeddedFrame(MetaFilePart *somSelf, Environment *ev,
		ODFrame* containingFrame,
		ODFrame* baseFrame,
		ODShape* frameShape,
		ODPart* embedPart,
		ODTypeToken viewType,
		ODTypeToken presentation,
		ODBoolean isOverlaid)
{

    return (MetaFilePart_parent_ODPart_RequestEmbeddedFrame(somSelf,ev,containingFrame,baseFrame,frameShape,embedPart,viewType,presentation,isOverlaid));
}


SOM_Scope void  SOMLINK EmbeddedFrameSpec(MetaFilePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame,	ODObjectSpec* spec)
{

	ODUnused(embeddedFrame);
	ODUnused(spec);

	THROW(kODErrCannotEmbed);
}


SOM_Scope void  SOMLINK AbortRelinquishFocus(MetaFilePart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{

	ODUnused(focus);
	ODUnused(ownerFrame);
	ODUnused(proposedFrame);
}

SOM_Scope void  SOMLINK RevealLink(MetaFilePart *somSelf, Environment *ev,
		ODLinkSource* linkSource)
{
	ODUnused(linkSource);
}


SOM_Scope ODStorageUnit*  SOMLINK GetContainingPartProperties(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{

	ODUnused(frame);
	return kODNULL;
}


SOM_Scope ODEmbeddedFramesIterator*  SOMLINK CreateEmbeddedFramesIterator(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{
	ODUnused(frame);
	return kODNULL;
}


SOM_Scope ODBoolean SOMLINK HandleEventInEmbedded(MetaFilePart *somSelf, Environment *ev,
			ODEventData *event,
			ODFrame* frame,
			ODFacet* facet,
			ODFrame* embeddedFrame,
			ODFacet* embeddedFacet)
{
ODUnused(event);
ODUnused(frame);
ODUnused(facet);
ODUnused(embeddedFrame);
ODUnused(embeddedFacet);
	return kODFalse;
}


SOM_Scope void  SOMLINK GeometryChanged(MetaFilePart *somSelf,
		Environment *ev, ODFacet* facet,
		ODBoolean clipShapeChanged,
		ODBoolean externalTransformChanged)
{
ODUnused( facet);

}
	 
SOM_Scope void  SOMLINK DisposeActionState(MetaFilePart *somSelf, Environment *ev,
		ODActionData actionState,
		ODDoneState doneState)
{
	ODUnused(actionState);
	ODUnused(doneState);
}


SOM_Scope void  SOMLINK DisplayFrameConnected(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{
}


SOM_Scope ODULong  SOMLINK GetPrintResolution(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{

	ODUnused(frame);

	return 0;
}


SOM_Scope void  SOMLINK DisplayFrameClosed(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{

}

SOM_Scope void  SOMLINK ChangeKind(MetaFilePart *somSelf, Environment *ev,
		ODType kind)
{

	ODUnused(kind);
}


SOM_Scope ODShape*  SOMLINK AdjustBorderShape(MetaFilePart *somSelf, Environment *ev,
		ODFacet* embeddedFacet,
		ODShape* shape)
{

	ODUnused(embeddedFacet);
	return shape;
}

SOM_Scope ODPtr  SOMLINK ReadActionState(MetaFilePart *somSelf, Environment *ev,
		ODStorageUnitView* storageUnitView)
{

	ODUnused(storageUnitView);
	return kODNULL;
}

SOM_Scope void  SOMLINK LinkUpdated(MetaFilePart *somSelf, Environment *ev,
		ODLink* updatedLink, ODChangeID id)
{

	ODUnused(updatedLink);
	ODUnused(id);
}

SOM_Scope void  SOMLINK PresentationChanged(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{
}


SOM_Scope void  SOMLINK DisplayFrameRemoved(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{
}

SOM_Scope ODBoolean  SOMLINK BeginRelinquishFocus(MetaFilePart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{

	ODUnused(focus);
	ODUnused(ownerFrame);
	ODUnused(proposedFrame);

	return kODTrue;
}

SOM_Scope void  SOMLINK WriteActionState(MetaFilePart *somSelf, Environment *ev,
		ODPtr actionState,
		ODStorageUnitView* storageUnitView)
{

	ODUnused(actionState);
	ODUnused(storageUnitView);
}

SOM_Scope void  SOMLINK RemoveEmbeddedFrame(MetaFilePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame)
{
	THROW(kODErrCannotEmbed);

}

SOM_Scope void SOMLINK Release(MetaFilePart *somSelf, Environment *ev)
{

	MetaFilePartData	*somThis = MetaFilePartGetData(somSelf);

	MetaFilePart_parent_ODPart_Release(somSelf, ev);
	
	if (somSelf->GetRefCount(ev) == 0)
		somSelf->GetStorageUnit(ev)->GetDraft(ev)->ReleasePart(ev, _fPartWrapper);

}

   
SOM_Scope void  SOMLINK ExternalizeKinds(MetaFilePart *somSelf, Environment *ev,
		ODTypeList* kindset)
{
    MetaFilePartData *somThis = MetaFilePartGetData(somSelf);

	ODUnused(kindset);
	somSelf->Externalize(ev);
}

SOM_Scope void  SOMLINK RedoAction(MetaFilePart *somSelf, Environment *ev,
		ODActionData actionState)
{
}

SOM_Scope void  SOMLINK AttachSourceFrame(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame,
		ODFrame* sourceFrame)
{
	ODUnused(frame);
	ODUnused( sourceFrame);

}


SOM_Scope void  SOMLINK CloneInto(MetaFilePart *somSelf, Environment *ev,
		ODDraftKey key,
		ODStorageUnit* toSU,
		ODFrame* scopeFrame)
{

	MetaFilePartData *somThis = MetaFilePartGetData(somSelf);

	MetaFilePart_parent_ODPart_CloneInto(somSelf,ev,key,toSU,scopeFrame);

}	 

SOM_Scope ODBoolean  SOMLINK RevealFrame(MetaFilePart *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* revealShape)
{

	ODUnused(embeddedFrame);
	ODUnused(revealShape);

	return kODFalse;
}


SOM_Scope void  SOMLINK UndoAction(MetaFilePart *somSelf, Environment *ev,
		ODActionData actionState)
{
ODUnused( actionState);
}

SOM_Scope void  SOMLINK SequenceChanged(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{
    MetaFilePartData *somThis = MetaFilePartGetData(somSelf);

    MetaFilePart_parent_ODPart_SequenceChanged(somSelf,ev,frame);
}


SOM_Scope void  SOMLINK ContainingPartPropertiesChanged(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame,
		ODStorageUnit* propertyUnit)
{
	 MetaFilePartData *somThis = MetaFilePartGetData(somSelf);

	ODUnused(frame);
	ODUnused(propertyUnit);
}

SOM_Scope void  SOMLINK ViewTypeChanged(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{
    MetaFilePartData *somThis = MetaFilePartGetData(somSelf);

	ODUnused(frame);
}

SOM_Scope void  SOMLINK HighlightChanged(MetaFilePart *somSelf, Environment *ev,
		ODFacet* facet)
{

	ODUnused(facet);
}

SOM_Scope void  SOMLINK LinkStatusChanged(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame)
{

	ODUnused(frame);
}
						  

SOM_Scope void  SOMLINK EmbeddedFrameChanged(MetaFilePart *somSelf, Environment *ev,
		ODFrame* frame,
		ODChangeID change)
{
	ODUnused(change);
	ODUnused(frame);
}

SOM_Scope ODLink*  SOMLINK CreateLink(MetaFilePart *somSelf, Environment *ev,
		ODPtr data,
		ODULong size)
{

	ODUnused(data);
	ODUnused(size);
	return kODNULL;
}
