/*
	File:		PrtPrpAc.cpp

	Contains:	Implemementation of DrawPartPropAccessor class.

	Written by:	Nick Pilch

	Copyright:	c 1993 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <3>	 9/29/94	RA		1189812: Mods for 68K build.
		 <2>	 9/22/94	JBS		1188214: coordinate bias implementation
		 <1>	 8/30/94	NP		first checked in
		 <4>	  4/6/94	JBS		1155477
		 <3>	 3/25/94	JA		GetPlatformTransform -> GetQDOffset
									(1153438).
		 <2>	 2/16/94	JA		Include new AltPoint.h.
		<14>	  2/8/94	T		Throw -> THROW & some code clean up
		<13>	  2/7/94	T		fixes to compile with PPC Headers
		<12>	 1/19/94	eeh		removed assert from GetDrawPart; fixed
									G/SetData param types
		<11>	 1/11/94	eeh		bounds property; removing "frame" from
									ospec vocabulary
		<10>	12/17/93	eeh		more work on setting bounds property of
									frame
		 <9>	12/15/93	JBS		use new clipShape calls
		 <8>	 12/9/93	eeh		implement classes AbsDrawPartPropAccessor,
									DragPartPropAccessor and FramePropAccessor
		 <7>	 12/1/93	CG		Added new class EmbeddedPartPropAccessor
									for getting pBounds and pTranslation from
									an embedded part.
		 <6>	11/22/93	SS		Added typecast for lastest headers
		 <5>	11/16/93	CG		Added some code to GetData.
		 <4>	11/12/93	JBS		use Facets
		 <3>	 11/2/93	NP		Cast kODNULL to proper type.
		 <2>	 9/14/93	NP		Explicitly set port to frame's window
									before calling invalidate.
		 <1>	 9/10/93	NP		first checked in

	To Do:
*/

#ifndef _ALTPOINT_
#include "AltPoint.h"			// Use C++ savvy ODPoint and ODRect
#endif


#ifndef _PRTPRPAC_
#include "PrtPrpAc.h"
#endif

#ifndef _DRWSHARED_
#include "DrwShared.h"
#endif

#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_Module_AppleTestDraw_defined
#include "DrawPart.xh"
#endif

#ifndef SOM_ODFacet_xh
#include "Facet.xh"
#endif

#ifndef SOM_ODFrame_xh
#include "Frame.xh"
#endif

#ifndef SOM_ODFrameFacetIterator_xh
#include "FrFaItr.xh"
#endif

#ifndef _SEUTILS_
#include "SEUtils.h"
#endif

#ifndef SOM_ODTransform_xh
#include "Trnsform.xh"
#endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

#ifndef SOM_ODWindow_xh
#include <Window.xh>
#endif

#ifndef __AEREGISTRY__
#include <AERegistry.h>
#endif

#ifndef SOM_ODShape_xh
#include <Shape.xh>
#endif

#ifndef __TEXTEDIT__
#include <TextEdit.h>
#endif

#ifndef _ODDEBUG_
#include "ODDebug.h"	// Adkins -- added
#endif

#pragma segment PrtPrpAc

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Local Classes
//==============================================================================

//==============================================================================
// Global Variables
//==============================================================================

//==============================================================================
// Function Prototype
//==============================================================================

//==============================================================================
// AbsDrawPartPropAccessor
//==============================================================================

//------------------------------------------------------------------------------
// AbsDrawPartPropAccessor::AbsDrawPartPropAccessor
//------------------------------------------------------------------------------
AbsDrawPartPropAccessor::AbsDrawPartPropAccessor(DescType property,
		ODObject* object)
{
	fProperty = property;
	fObject = object;
}

//------------------------------------------------------------------------------
// AbsDrawPartPropAccessor::SetData
//------------------------------------------------------------------------------
void AbsDrawPartPropAccessor::SetData(AEDesc* data)
{
	ODUnused(data);
	THROW(errAEEventNotHandled);
}

//------------------------------------------------------------------------------
// AbsDrawPartPropAccessor::GetData
//------------------------------------------------------------------------------
void AbsDrawPartPropAccessor::GetData(AEDesc* result)
{
	ODUnused(result);
	THROW(errAEEventNotHandled);
}

//------------------------------------------------------------------------------
// AbsDrawPartPropAccessor::GetProperty
//------------------------------------------------------------------------------
DescType AbsDrawPartPropAccessor::GetProperty()
{
	return fProperty;
}

//------------------------------------------------------------------------------
// AbsDrawPartPropAccessor::GetObject
//------------------------------------------------------------------------------
ODObject* AbsDrawPartPropAccessor::GetObject()
{
	return fObject;
}

//==============================================================================
// DrawPartPropAccessor
//==============================================================================

//------------------------------------------------------------------------------
// DrawPartPropAccessor::DrawPartPropAccessor
//------------------------------------------------------------------------------

DrawPartPropAccessor::DrawPartPropAccessor(DescType property, AppleTestDraw_DrawPart* part)
	:AbsDrawPartPropAccessor(property, part)
{
#ifdef TO_BE_DELETED
	fProperty = property;
	fPart = part;
#endif // TO_BE_DELETED
//	fContainedPart = kODNULL;
}

//------------------------------------------------------------------------------
// DrawPartPropAccessor::SetData
//------------------------------------------------------------------------------

void DrawPartPropAccessor::SetData(AEDesc* data)
{
//	DescType	gotType;
//	Size		actualSize;
//	ODError	result;
	Environment*	ev = somGetGlobalEnvironment();

	switch(this->GetProperty())
	{
		case pColor:
		{
			RGBColor color;
			if (data->descriptorType == typeRGBColor)
			{
				color = **(RGBColor**)data->dataHandle;
			}
			else
			{
				AEDesc colorDesc;
				THROW_IF_ERROR(AECoerceDesc(data, typeRGBColor, &colorDesc));
				color = **(RGBColor**)colorDesc.dataHandle;
				AEDisposeDesc(&colorDesc);
			}

			OrderedCollectionIterator iter(this->GetDrawPart()->GetDisplayFrames(ev));
			for (ODFrame* frame = (ODFrame*)iter.First()
					;iter.IsNotComplete()
					;frame = (ODFrame*)iter.Next())
			{
				this->GetDrawPart()->SetBGColor2(ev, frame, color);
				frame->Invalidate(ev, (ODShape*)kODNULL, kODNULL);
			}
			break;
		}
		default:
			THROW(errAECantSupplyType);
			break;
	}
}	// DrawPartPropAccessor::SetData()

//------------------------------------------------------------------------------
// DrawPartPropAccessor::GetData
//------------------------------------------------------------------------------

void DrawPartPropAccessor::GetData(AEDesc* objectData)
{
	ODError			result;
	Environment*	ev = somGetGlobalEnvironment();
	
	switch(this->GetProperty())
	{
		case pName:
		{
			// this is the draw part for now
			unsigned char* name = "\pDrawPart";
			THROW_IF_ERROR(AECreateDesc(typeChar, (Ptr)&name[1], name[0],
					objectData));
		}
			break;

		case pBounds:
		{
			OrderedCollectionIterator iter(this->GetDrawPart()->GetDisplayFrames(ev));
			ODFrame* frame = (ODFrame*)iter.First();
			ODShape* shape = frame->GetFrameShape(ev, kODNULL);
		//	if(shape->IsRectangular())
			{
				ODRect r;
				shape->GetBoundingBox(ev, &r);
				Rect qdR;
				r.AsQDRect(qdR);
				result = AECreateDesc(typeQDRectangle, (Ptr)&qdR, sizeof(qdR),
						objectData);
				THROW_IF_ERROR(result);
			}
		}
			break;

		case pColor:
		{
			OrderedCollectionIterator iter(this->GetDrawPart()->GetDisplayFrames(ev));
				// For now, assume first frame
			ODFrame* frame = (ODFrame*)iter.First();

			PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo(ev);
			RGBColor theColor = pInfo->bgColor;
			
#ifdef TO_BE_DELETED
			for (ODFrame* frame = (ODFrame*)iter.First()
					;iter.IsNotComplete()
					;frame = (ODFrame*)iter.Next())
			{
				PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo();
				theColor = pInfo->bgColor;
			}
			
#endif // TO_BE_DELETED

			result = AECreateDesc(typeRGBColor, (Ptr)&theColor, sizeof(theColor), objectData);
			THROW_IF_ERROR(result);

			break;
		}
		default:
			THROW(errAECantSupplyType);
			break;
	}
}

//------------------------------------------------------------------------------
// DrawPartPropAccessor::GetDrawPart
//------------------------------------------------------------------------------
AppleTestDraw_DrawPart* DrawPartPropAccessor::GetDrawPart()
	
{
	return (AppleTestDraw_DrawPart*)AbsDrawPartPropAccessor::GetObject();
}


#ifdef TO_BE_DELETED
//------------------------------------------------------------------------------
// DrawPartPropAccessor::SetContainedPart
//------------------------------------------------------------------------------
void DrawPartPropAccessor::SetContainedPart(ODPart* containedPart)
{
	fContainedPart = containedPart;
}

//------------------------------------------------------------------------------
// DrawPartPropAccessor::GetContainedPart
//------------------------------------------------------------------------------
ODPart* DrawPartPropAccessor::GetContainedPart()
{
	return fContainedPart;
}
#endif // TO_BE_DELETED

//==============================================================================
// EmbeddedPartPropAccessor
//==============================================================================

//------------------------------------------------------------------------------
// EmbeddedPartPropAccessor::DrawPartPropAccessor
//------------------------------------------------------------------------------

EmbeddedPartPropAccessor::EmbeddedPartPropAccessor(DescType property,
		ODFrame* frame, AppleTestDraw_DrawPart* me)
	:AbsDrawPartPropAccessor(property, frame)
{
	fDrawPart = me;
}

//------------------------------------------------------------------------------
// EmbeddedPartPropAccessor::GetThisPart
//------------------------------------------------------------------------------

AppleTestDraw_DrawPart* EmbeddedPartPropAccessor::GetThisPart()
{
	return fDrawPart;
}

//------------------------------------------------------------------------------
// EmbeddedPartPropAccessor::SetData
//------------------------------------------------------------------------------

static void MoveFacetTransform(ODFacet* facet, Point* desiredLocation,
		ODPart* part)
{
	Environment*	ev = somGetGlobalEnvironment();
	ODTransform* 	newXForm = facet->GetExternalTransform(ev, kODNULL)->Copy(ev);
	Point curOffset = newXForm->GetQDOffset(ev);
	Point scratch = *desiredLocation;
	scratch.h -= curOffset.h;
	scratch.v -= curOffset.v;

	ODPoint newDelta = *desiredLocation = scratch;
	newXForm->MoveBy(ev, &newDelta);
	facet->ChangeGeometry(ev, kODNULL, newXForm, kODNULL);
	facet->Invalidate(ev, facet->GetClipShape(ev, kODNULL), kODNULL);
}

void EmbeddedPartPropAccessor::SetData(AEDesc* data)
{
#if 0
	ODError			result;
	Environment*	ev = somGetGlobalEnvironment();

	ODFrame* targetFrame = this->GetFrame();		// the *contained* frame

	switch(this->GetProperty())
	{
		case pTranslation:
		{
		
				// Get the old shape to invalidate
			ODShape* oldShape = targetFrame->GetFrameShape(ev, kODNULL)->Copy(ev);
			
				// Make a new shape and set bounds
			ODShape* newShape = targetFrame->CreateShape(ev);
		
			AEDesc dPoint;
			result = AECoerceDesc(data, typeQDPoint, &dPoint); 
			THROW_IF_ERROR(result);
			Point thePoint = **(Point**)dPoint.dataHandle;
			AEDisposeDesc(&dPoint);

				// Make a new shape and set bounds
			ODTransform* newTrans = targetFrame->CreateTransform(ev);
			newTrans->SetQDOffset(ev, &thePoint);
			newShape->Transform(ev, newTrans);

			ODFrameFacetIterator* facetIterator =
					targetFrame->CreateFacetIterator(ev);
			for (ODFacet* facet = facetIterator->First(ev);
				facetIterator->IsNotComplete(ev);
				facet = facetIterator->Next(ev))
			{
				// invalidate old frame shape
				//oldShape->Transform(selection->transform);
				targetFrame->Invalidate(ev, oldShape, kODNULL);
			
				ODShape* newShapeCopy = newShape->Copy(ev);		// save to invalidate later
			
				targetFrame->ChangeFrameShape(ev, newShape);	// already in frame coords
				facet->ChangeGeometry(ev, kODNULL, newTrans);

				// invalidate changed areas
				//newShapeCopy->Transform(selection->transform);
				//facet->GetFrame()->Invalidate(newShapeCopy);
				targetFrame->Invalidate(ev, newShapeCopy);
				delete newShapeCopy;
			
		//		AppleTestDraw_DrawPart* thisPart = (AppleTestDraw_DrawPart*)targetFrame->GetPart();
				this->GetThisPart()->InvalidateSelection(ev, targetFrame);
				//fPart->UpdateProxyRegion(selection);
				//fPart->CreateProxySelectionBorder(selection);
				this->GetThisPart()->ClipEmbeddedFrames(ev, targetFrame);
				this->GetThisPart()->InvalidateSelection(ev, targetFrame);
				
				this->GetThisPart()->GetStorageUnit(ev)->GetDraft(ev)->
						SetChangedFromPrev(ev);
			}	
			delete oldShape;
			break;
		}
		case pBounds:
		{
			// Get the new rect
			AEDesc dRect;
			result = AECoerceDesc(data, typeQDRectangle, &dRect); 
			THROW_IF_ERROR(result);
			Rect usersRect = **(Rect**)dRect.dataHandle;
			AEDisposeDesc(&dRect);
			
			Point pt = *(Point*)&usersRect;

			// make the rect 0-based
			OffsetRect(&usersRect, -usersRect.left, -usersRect.top);
			
			ODShape* newShape = targetFrame->GetFrameShape(ev)->Copy(ev);
			ODRect usersODRect = usersRect;
			newShape->SetRectangle(ev, &usersODRect);
			targetFrame->ChangeFrameShape(ev, newShape);

			ODFrameFacetIterator* fi = this->GetFrame(ev)->CreateFacetIterator(ev);
			ODFacet* facet = fi->First(ev);
			MoveFacetTransform(facet, &pt, this->GetFrame(ev)->GetPart(ev));
	
			Proxy* p = this->GetThisPart()->ProxyForFrame(ev, targetFrame);
	
			// !!! this is a single-facet hack
			p->transform->MoveBy(ev, pt);		
			this->GetThisPart()->UpdateProxyRegion(ev, p);
			this->GetThisPart()->CreateProxySelectionBorder(ev, p);
	
			targetFrame->GetContainingFrame(ev)->Invalidate(ev, (ODShape*)kODNULL, kODNULL);

			break;

#ifdef TO_BE_DELETED
			ODFrame* frame = this->GetFrame();
			ODFrameFacetIterator* fi = frame->CreateFrameFacetIterator(ev);
			ODFacet* facet = fi->First();
			WASSERT((fi->Next(), !fi->IsNotComplete()));
			ODTransform* transform = facet->GetExternalTransform();

			// NOTE: this is VERY dangerous, as I'm assuming that I'm contained
			// in a AppleTestDraw_DrawPart.  Won't work when other parts can contain! <eeh>

			ODFrame* outerFrame = frame->GetContainingFrame();
			AppleTestDraw_DrawPart* outerPart = (AppleTestDraw_DrawPart*)outerFrame->GetPart();
			Proxy* p = outerPart->ProxyForFrame(frame);

			Point newOffset = *(Point*)&usersRect;	//for the new xform
			Point curOffset = p->transform->GetQDOffset();
			
			newOffset.h -= curOffset.h;
			newOffset.v -= curOffset.v;
			short usersRight = usersRect.right - usersRect.left;
			short usersBottom = usersRect.bottom - usersRect.top;
			Rect xformedRect;		// goes into the new shape
			SetRect(&xformedRect, 0, 0, usersRight, usersBottom);

			ODTransform* newXform = new ODTransform;
			newXform->CopyFrom(transform);
			ODPoint xmpPt = newOffset;
			newXform->MoveBy(xmpPt);
			facet->ChangeGeometry(kODNULL, newXform);
			
			// !!! this is a single-facet hack
			p->transform->MoveBy(newOffset);
			ODTransform* newExternalXForm = new ODTransform;
			newExternalXForm->CopyFrom(p->transform);
			ODFrameFacetIterator* facets = p->frame->CreateFacetIterator();
			facets->First()->ChangeGeometry(kODNULL, newExternalXForm);
			delete facets;
			
			outerPart->UpdateProxyRegion(p);
			outerPart->CreateProxySelectionBorder(p);

			ODShape* shape = new ODShape();
			ODRect rect = xformedRect;
			shape->SetRectangle(&rect);
			frame->ChangeFrameShape(shape);
			facet->Invalidate(facet->GetClipShape());
			facet->ChangeGeometry(facet->GetFrame()->GetFrameShape()->Copy(), kODNULL);
			facet->GetContainingFacet()->Invalidate(kODNULL);

			break;
#endif // TO_BE_DELETED
		}
		default:
			THROW(errAECantSupplyType);
			break;
	}
#endif // 0
}	// EmbeddedPartPropAccessor::SetData()

//------------------------------------------------------------------------------
// EmbeddedPartPropAccessor::GetData
//------------------------------------------------------------------------------

void EmbeddedPartPropAccessor::GetData(AEDesc* objectData)
{
	Environment*	ev = somGetGlobalEnvironment();
	ODError			result;
	ODFrame* 		frame = this->GetFrame();

	switch(this->GetProperty())
	{
		case pTranslation:
		{
			WASSERT(false);		// should not be here
			Point thePoint = frame->GetInternalTransform(ev, kODNULL)->GetQDOffset(ev);

			result = AECreateDesc(typeQDPoint, (Ptr)&thePoint, sizeof(thePoint), objectData);
			THROW_IF_ERROR(result);

			break;
		}
		case pBounds:
		{
				// make a copy of frame's shape
			ODShape* shape = frame->GetFrameShape(ev, kODNULL)->Copy(ev);

			ODFrameFacetIterator* fi = frame->CreateFacetIterator(ev);
			ODFacet* facet = fi->First(ev);
			WASSERT((fi->Next(ev), !fi->IsNotComplete(ev)));
			delete fi;
			ODTransform* transform = facet->GetExternalTransform(ev, kODNULL);
			shape->Transform(ev, facet->GetExternalTransform(ev, kODNULL));

				// get the bounding box of the shape
			ODRect theBounds;
			shape->GetBoundingBox(ev, &theBounds);
			delete shape;

				// send it back to the user
			Rect qdRect;
			theBounds.AsQDRect(qdRect);
			result = AECreateDesc(typeQDRectangle, (Ptr)&qdRect,
					sizeof(qdRect), objectData);
			THROW_IF_ERROR(result);
			break;
		}
		default:
			THROW(errAECantSupplyType);
			break;
	}
}	// EmbeddedPartPropAccessor::GetData

//------------------------------------------------------------------------------
// EmbeddedPartPropAccessor::GetPart
//------------------------------------------------------------------------------

ODFrame* EmbeddedPartPropAccessor::GetFrame()
{
	return (ODFrame*)AbsDrawPartPropAccessor::GetObject();
}

//==============================================================================
// FramePropAccessor
//==============================================================================

//------------------------------------------------------------------------------
// FramePropAccessor::DrawPartPropAccessor
//------------------------------------------------------------------------------

#ifdef TO_BE_DELETED
FramePropAccessor::FramePropAccessor(DescType property, ODFrame* frame)
	:AbsDrawPartPropAccessor(property, frame)
{
}
#endif // TO_BE_DELETED

//------------------------------------------------------------------------------
// FramePropAccessor::GetFrame
//------------------------------------------------------------------------------
#ifdef TO_BE_DELETED
ODFrame* FramePropAccessor::GetFrame()
{
	return (ODFrame*)AbsDrawPartPropAccessor::GetObject();
}
#endif // TO_BE_DELETED

//------------------------------------------------------------------------------
// FramePropAccessor::SetData
//------------------------------------------------------------------------------

#ifdef TO_BE_DELETED
void FramePropAccessor::SetData(AEDesc* data)
{
	DescType		gotType;
	ODSize			actualSize;
	ODError			result;
	Point 			thePoint = { 0, 0 };
	Environment*	ev = somGetGlobalEnvironment();

			
	switch(this->GetProperty())
	{
		case pBounds:
		{
			// Get the new rect
			AEDesc dRect;
			result = AECoerceDesc(data, typeQDRectangle, &dRect); 
			THROW_IF_ERROR(result);
			Rect usersRect = **(Rect**)dRect.dataHandle;
			AEDisposeDesc(&dRect);

			ODFrameFacetIterator* fi =
					new ODFrameFacetIterator(this->GetFrame());
			ODFacet* facet = fi->First();
			WASSERT((fi->Next(), !fi->IsNotComplete()));
			ODTransform* transform = facet->GetExternalTransform(ev);

			// NOTE: this is VERY dangerous, as I'm assuming that I'm contained
			// in a AppleTestDraw_DrawPart.  Won't work when other parts can contain! <eeh>

			ODFrame* outerFrame = this->GetFrame(ev)->GetContainingFrame(ev);
			AppleTestDraw_DrawPart* outerPart = (AppleTestDraw_DrawPart*)outerFrame->GetPart();
			Proxy* p = outerPart->ProxyForFrame(this->GetFrame());

			Point newOffset = *(Point*)&usersRect;	//for the new xform
	//		Point curOffset = transform->GetQDOffset();
			Point curOffset = p->transform->GetQDOffset();
			
			newOffset.h -= curOffset.h;
			newOffset.v -= curOffset.v;
			short usersRight = usersRect.right - usersRect.left;
			short usersBottom = usersRect.bottom - usersRect.top;
			Rect xformedRect;		// goes into the new shape
			SetRect(&xformedRect, 0, 0, usersRight, usersBottom);

			ODTransform* newXform = new ODTransform;
			newXform->CopyFrom(transform);
			ODPoint xmpPt = newOffset;
			newXform->MoveBy(xmpPt);
			facet->ChangeGeometry(kODNULL, newXform);

			
			// !!! this is a single-facet hack
			p->transform->MoveBy(newOffset);
			ODTransform* newExternalXForm = p->transform->Copy(Ev);
			ODFrameFacetIterator* facets = p->frame->CreateFacetIterator();
			facets->First()->ChangeGeometry(kODNULL, newExternalXForm);
			delete facets;
			
			outerPart->UpdateProxyRegion(p);
			outerPart->CreateProxySelectionBorder(p);

			ODShape* shape = facet->CreateShape(ev);
			ODRect rect = xformedRect;
			shape->SetRectangle(&rect);
			this->GetFrame()->ChangeFrameShape(shape);
			facet->Invalidate(facet->GetClipShape());
			facet->ChangeGeometry(facet->GetFrame()->GetFrameShape()->Copy(), kODNULL);
			facet->GetContainingFacet()->Invalidate(kODNULL);
			
#ifdef TO_BE_DELETED
			this->GetFrame()->GetPart()->Draw(facet, shape);
			ODFrame* containerF = this->GetFrame()->GetContainingFrame();
			if (containerF)
			{
				ODPart* container = containerF->GetPart();
				ODEmbeddedFramesIterator* fi =
						container->CreateEmbeddedFramesIterator();
				for(ODFrame* frm = fi->First(); fi->IsNotComplete();
						frm = fi->Next())
				{
					frm->Invalidate(frm->GetUsedShape());
					//container->Draw((ODFacet*)kODNULL,
					//		(ODShape*)kODNULL);
				}
			}
#endif // TO_BE_DELETED


#ifdef TO_BE_DELETED
			// xform it using the current external xform
			ODFrameFacetIterator* fi =
					new ODFrameFacetIterator(this->GetFrame());
			ODFacet* facet = fi->First();
			WASSERT((fi->Next(), !fi->IsNotComplete()));
			ODShape* shape = new ODShape();
			ODRect rect = usersRect;
			shape->SetRectangle(&rect);
			ODTransform* transform = facet->GetExternalTransform();
			shape->Transform(transform);
			
			ODRect transformedRect;
			shape->GetBoundingBox(&transformedRect);

			// subtract transformed from incoming to get new pt, and make
			// it into the new transform
			Point pt;
			pt.h = (short)(transformedRect.left - transformedRect.left);
			pt.v = (short)(transformedRect.top - transformedRect.top);
			ODTransform* newXform = new ODTransform;
			newXform->CopyFrom(transform);
			ODPoint xmpPt = pt;
			newXform->MoveBy(xmpPt);
			facet->ChangeGeometry(kODNULL, newXform);

			// use xformed rect to set new shape (shape is already set up?)
			// That is, set the facet's shape to be the new one?
			this->GetFrame()->ChangeFrameShape(shape);
			facet->ResetClipShape();
#endif // TO_BE_DELETED

			break;
		}
		default:
			THROW(errAEEventNotHandled);
			break;
	}
}
#endif // TO_BE_DELETED

//------------------------------------------------------------------------------
// FramePropAccessor::GetData
//------------------------------------------------------------------------------

#ifdef TO_BE_DELETED
void FramePropAccessor::GetData(AEDesc* objectData)
{
	switch(this->GetProperty())
	{
		case pBounds:
		{
			ODShape* theShape = this->GetFrame()->GetFrameShape();
			ODRect bounds;
			theShape->GetBoundingBox(&bounds);
			Rect qdBounds;
			bounds.AsQDRect(qdBounds);
			THROW_IF_ERROR(AECreateDesc(typeQDRectangle, (Ptr)&qdBounds,
					sizeof(qdBounds), objectData));
			break;

#ifdef TO_BE_DELETED
			ODRect theBounds;
			ODFrameFacetIterator* fi =
					new ODFrameFacetIterator(this->GetEmbeddedFrame());
			ODFacet* facet = fi->First();
			WASSERT((fi->Next(), !fi->IsNotComplete()));

				// make a copy of frame's shape
			ODShape* shape = new ODShape();
			shape->CopyFrom(this->GetEmbeddedFrame()->GetFrameShape());
			
			ODTransform* transform = facet->GetExternalTransform();
			shape->Transform(transform);
			
				// get the bounding box of the shape
			shape->GetBoundingBox(&theBounds);
			delete shape;

			Rect r;
			theBounds.AsQDRect(r);
			THROW_IF_ERROR(AECreateDesc(typeQDRectangle, (Ptr)&r,
					sizeof(r), objectData));
#endif // TO_BE_DELETED
		}
		default:
			THROW(errAEEventNotHandled);
			break;
	}
}

#endif // TO_BE_DELETED
