// DrPrtNat.cpp

#include "DrPrtNat.h"

#include "String.h"

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef SOM_ODWindowState_xh
#include <WinStat.xh>
#endif

#ifndef SOM_ODWindow_xh
#include <Window.xh>
#endif

void *PlatformNewPtr(size_t theSize)
{
	return(malloc(theSize));
}

void *PlatformNewPtrClear(size_t theSize)
{
	return(calloc(1, theSize));
}

void PlatformFreePtr(void *aPtr)
{
	if (aPtr) {
		free(aPtr);
	}
}

void *PlatformMemCpy(void *dest, const void *src, size_t n)
{
	return(memcpy(dest, src, n));
}

void *PlatformMemMove(void *dest, const void *src, size_t n)
{
	return(memmove(dest, src, n));
}

void PlatformDeleteFont(HFONT aFont)
{
	DeleteObject(aFont);
}

Point	PlatformGetFrameOffset(ODFacet* facet)
{
	Environment *ev = somGetGlobalEnvironment();

	Point	tmpPnt;

	tmpPnt.x = 0;
	tmpPnt.y = 0;
	if (!facet) {
		return(tmpPnt);
	}

	return(facet->GetFrameTransform(ev, kODNULL)->GetWinOffset(ev));
}

ODPlatformWindow PlatformNewWindow(ODSession* aSession, Rect *windRect, ODULong flags)
{
	Environment *ev = somGetGlobalEnvironment();

	return(aSession->GetWindowState(ev)->CreatePlatformWindow(ev, kODTrue, flags));
}

void PlatformSetWindowPos(ODPlatformWindow aWind, HWND topWnd, RECT *posSizeRect, UINT flags)
{
	SetWindowPos(aWind, topWnd, posSizeRect->left, posSizeRect->top,
			posSizeRect->right - posSizeRect->left, posSizeRect->bottom - posSizeRect->top, flags);
}

void PlatformEraseRect(HDC aDC, RECT *aRect)
{
	HBRUSH	hbr;

	hbr = CreateSolidBrush(GetBkColor(aDC));
	FillRect(aDC, aRect, hbr);
	DeleteObject((HGDIOBJ)hbr);
}

void PlatformSetPt(Point *aPnt, int xVal, int yVal)
{
	aPnt->x = xVal;
	aPnt->y = yVal;
}

void PlatformPtFromEvent(ODEventData* event, POINT *p)
{
	#ifndef WIN32
		*p = MAKEPOINT(event->lParam);
	#else
		LONG2POINT(event->lParam, *p);
	#endif
}

HFONT PlatformSelectFont(HDC aDC, HFONT theFont)
{
	HFONT	oldFont;

	if (theFont) {
		oldFont = (HFONT)SelectObject(aDC, (HGDIOBJ)theFont);
	} else {
		oldFont = (HFONT)SelectObject(aDC, GetStockObject(SYSTEM_FONT));
	}

	return(oldFont);
}

HBITMAP PlatformSelectBitmap(HDC aDC, HBITMAP aBMap)
{
	return((HBITMAP)SelectObject(aDC, aBMap));
}

void PlatformDeleteBitmap(HBITMAP aBMap)
{
	DeleteObject((HGDIOBJ)aBMap);
}

HGDIOBJ PlatformSetPenColor(HDC aDC, int theBrushObject)
{
	return(SelectObject(aDC, GetStockObject(theBrushObject)));
}

void PlatformSetPenMode(HDC aDC, int drawMode)
{
	SetROP2(aDC, drawMode);
}

void PlatformMoveTo(HDC aDC, int xPos, int yPos)
{
	MoveToEx(aDC, xPos, yPos, NULL);
}

void PlatformLineTo(HDC aDC, int xPos, int yPos)
{
	LineTo(aDC, xPos, yPos);
}

void PlatformGlobalToLocal(Point *aPnt)
{
	// do nothing
}

void PlatformLocalToGlobal(Point *aPnt)
{
	// do nothing
}

void PlatformSetCursor(HINSTANCE hinst, LPCSTR cursorName)
{
	SetCursor(LoadCursor(hinst, cursorName));
}

void PlatformGetCanvas(HDC *aDC)
{
	aDC = kODNULL;
}

void PlatformSetCanvas(HDC aDC)
{
	// do nothing
}

ODBoolean IsShiftKeyDown(void)
{
	BYTE pbKeyState[256];

	GetKeyboardState((LPBYTE) &pbKeyState);
	if (pbKeyState[VK_SHIFT] & 0x80) {

		return(kODTrue);
	} else {
		return(kODFalse);
	}
}

ODBoolean StillDown(ODFacet* facet)
{
	Environment *ev = somGetGlobalEnvironment();

	MSG	msg;
	HWND	hwnd = facet->GetWindow(ev)->GetPlatformWindow(ev);

	if (PeekMessage(&msg, hwnd, WM_LBUTTONUP, WM_LBUTTONUP, PM_NOYIELD | PM_REMOVE)) {
		return(kODFalse);
	} else {
		return(kODTrue);
	}
}

