/*
	File:           DrPlPrt.cpp

	Contains:       Source code for a DrawPalette part

	Written by:     Jeff Hanson

	Copyright:      c 1994-95 by Novell, all rights reserved.

*/

#define ModDrawPalette_DrawPalette_Class_Source

#ifndef _ALTPOINT_
#include "AltPoint.h"                   // Use C++ savvy ODPoint and ODRect
#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _ODUTILS_
#include "ODUtils.h"
#endif

#ifndef _ODUTILW_
#include "ODUtilW.h"
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

//bln #ifndef _ODSHELL_
//bln #include "ODShell.h"
//bln #endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef _ISOSTRING_
#include "ISOStr.h"
#endif

#ifndef _FOCUSLIB_
#include "FocusLib.h"
#endif


#ifndef SOM_ODToolSpaceManager_xh
#include <ODTlSpc.xh>
#endif

#ifndef SOM_ODToolSpaceObj_xh
#include <ODTlObj.xh>
#endif

#ifndef SOM_Module_OpenDoc_StdProps_defined
#include <StdProps.xh>
#endif

#ifndef SOM_Module_OpenDoc_StdTypes_defined
#include <StdTypes.xh>
#endif

#ifndef SOM_Module_OpenDoc_Foci_defined
#include <Foci.xh>
#endif

#ifndef SOM_ODFocusSet_xh
#include <FocusSet.xh>
#endif

#ifndef SOM_ODPartWrapper_xh
#include "PartWrap.xh"
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODWindow_xh
#include <Window.xh>
#endif

#ifndef SOM_ODCanvas_xh
#include <Canvas.xh>
#endif

#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_ODDocument_xh
#include <Document.xh>
#endif

#ifndef SOM_ODContainer_xh
#include <ODCtr.xh>
#endif

#ifndef SOM_ODStorageUnitView_xh
#include <SUView.xh>
#endif

#ifndef SOM_ODStorageUnitCursor_xh
#include <SUCursor.xh>
#endif

#ifndef SOM_ODStorageUnit_xh
#include <StorageU.xh>
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODWindowState_xh
#include <WinStat.xh>
#endif

#ifndef SOM_ODFrame_xh
#include <Frame.xh>
#endif

#ifndef SOM_ODFacet_xh
#include <Facet.xh>
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef SOM_ODDispatcher_xh
#include <Disptch.xh>
#endif

#ifndef SOM_ODMenuBar_xh
#include "MenuBar.xh"
#endif

#ifndef SOM_Module_OpenDoc_Commands_defined
#include <CmdDefs.xh>
#endif

#ifndef SOM_ODInfo_xh
#include "Info.xh"
#endif

#ifndef SOM_ODFrameFacetIterator_xih
#include "FrFaItr.xh"
#endif

#ifndef SOM_ODArbitrator_xh
#include <Arbitrat.xh>
#endif

#ifndef SOM_ODShape_xh
#include <Shape.xh>
#endif

#define VARIABLE_MACROS
#include <DrPlPrt.xih>

#include "DrPrtNat.h"

#ifndef SOM_DrawPaletteExt_xh
#include <DrPlExt.xh>
#endif

#include "StdIO.h"
#include "StdLib.h"
#include "Assert.h"

#ifdef PLATFORM_WINDOWS
	#include <mmsystem.h>
#endif

//-------------------------------------------------------------------------
// Constants
//-------------------------------------------------------------------------

#define kODKindTestDrawPalette "Apple:Kind:TestDrawPalette"

static void CreateDrawPaletteSpace(ODPartWrapper* aDrawPaletteWrapper);

//-------------------------------------------------------------------------
// Constructor/Destructor
//-------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPalettesomInit(ModDrawPalette_DrawPalette *somSelf)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_somInit(somSelf);

	_fWindowID = 0;
	_fDisplayFrames = kODNULL;
	_fMenuBar = kODNULL;
	_fFocusSet = kODNULL;
	_fTestDrawPaletteSU = kODNULL;
	_fSession     = kODNULL;
	_fDrawPaletteExt = kODNULL;
	_fModalFocus = (ODTypeToken)kODNULL;
	_fPartWrapper = kODNULL;
	_fActiveTool = (ODULong)kODNULL;
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPalettesomUninit(ModDrawPalette_DrawPalette *somSelf)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	Environment *ev = somGetGlobalEnvironment();

	ODDeleteObject(_fDrawPaletteExt);

	ODDeleteObject(_fDisplayFrames);

	ODReleaseObject(ev, _fMenuBar);
	ODReleaseObject(ev, _fTestDrawPaletteSU);

	ModDrawPalette_DrawPalette_parent_ODPart_somUninit(somSelf);
}
	
SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteInitPart(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	_fPartWrapper = partWrapper;

	somSelf->InitPersistentObject(ev, storageUnit);
	
	somSelf->CommonInitDrawPalette(ev);
	
	storageUnit->AddProperty(ev, kODPropContents)->AddValue(ev, kODKindTestDrawPalette);    

	_fTestDrawPaletteSU = storageUnit->GetDraft(ev)->CreateStorageUnit(ev);

	_fTestDrawPaletteSU->AddProperty(ev, kODPropDisplayFrames)->AddValue(ev, kODWeakStorageUnitRefs);                       
}


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteInitPartFromStorage(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	_fPartWrapper = partWrapper;

	_fSession = storageUnit->GetSession(ev);

	somSelf->CommonInitDrawPalette(ev);

	ODULong valueSize, offset;
	ODStorageUnitRef aSURef;
	ODFrame* aFrame;
	ODStorageUnit* su;

ODVolatile(su);
ODVolatile(aFrame);
	
	su = somSelf->GetStorageUnit(ev);
	su->Focus(ev, kODPropContents,kODPosSame,kODKindTestDrawPalette,1,kODPosFirstSib);
	su->GetValue(ev, sizeof(ODStorageUnitRef),&aSURef);
	_fTestDrawPaletteSU = su->GetDraft(ev)->GetStorageUnit(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
	su = _fTestDrawPaletteSU;
	
	su->Focus(ev, kODPropDisplayFrames,kODPosUndefined,0,1,kODPosFirstSib);
	valueSize = su->GetSize(ev);
	for (offset = 0; offset < valueSize; offset += sizeof(ODStorageUnitRef))
	{
		su->SetOffset(ev, offset);
		su->GetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
		
		TRY
		
			aFrame = su->GetDraft(ev)->GetFrame(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
			_fDisplayFrames->AddLast((ElementType)aFrame);
		
		CATCH_ALL
		
			aFrame = kODNULL;

		ENDTRY
	}
}

//------------------------------------------------------------------------------
// InitCompleted
//------------------------------------------------------------------------------

static void InitCompleted(ODObject* aPart)
{
	ODPartWrapper* theDrawPaletteWrapper = (ODPartWrapper*)aPart;

	CreateDrawPaletteSpace(theDrawPaletteWrapper);
}

//------------------------------------------------------------------------------
// DrawPalette::CommonInitDrawPalette
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteCommonInitDrawPalette(ModDrawPalette_DrawPalette *somSelf, Environment *ev)
{                               
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	_fSession = somSelf->GetStorageUnit(ev)->GetSession(ev);

	_fDrawPaletteExt = new DrawPaletteExt;
	_fDrawPaletteExt->InitExtension(ev, _fPartWrapper);
	_fDrawPaletteExt->SetSession(ev, _fSession);
	_fDrawPaletteExt->InstallCompletedProc(ev, InitCompleted);

	_fDisplayFrames = new OrderedCollection;                // Create an empty collection for storing the list
												// of frames to display the "DrawPalette" in.
												
	_fMenuBar = _fSession->GetWindowState(ev)->CopyBaseMenuBar(ev);

	_fFocusSet = new ODFocusSet();
	_fFocusSet->InitFocusSet(ev);
}

//------------------------------------------------------------------------------
// DrawPalette::FulfillPromise
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteFulfillPromise(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODStorageUnitView *promiseSUView)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

ODUnused(promiseSUView);
}


//------------------------------------------------------------------------------
// DrawPalette::DropCompleted
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDropCompleted(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODPart* destPart,
								ODDropResult dropResult )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_DropCompleted(somSelf, ev, destPart, dropResult);
}


//------------------------------------------------------------------------------
// DrawPalette::DragEnter
//------------------------------------------------------------------------------


SOM_Scope ODBoolean SOMLINK ModDrawPalette_DrawPaletteDragEnter(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
						ODDragItemIterator* dragInfo,                           //OLE2
						ODFacet* facet,
						ODPoint* where )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	return ModDrawPalette_DrawPalette_parent_ODPart_DragEnter(somSelf, ev, dragInfo, facet, where);
}


//------------------------------------------------------------------------------
// DrawPalette::DragWithin
//------------------------------------------------------------------------------


SOM_Scope ODBoolean SOMLINK ModDrawPalette_DrawPaletteDragWithin(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
						ODDragItemIterator* dragInfo,                   //OLE2
						ODFacet* facet,
						ODPoint* where )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	return ModDrawPalette_DrawPalette_parent_ODPart_DragWithin(somSelf, ev, dragInfo, facet, where);
}


//------------------------------------------------------------------------------
// DrawPalette::DragLeave
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDragLeave(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
						ODFacet* facet,
						ODPoint* where )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_DragLeave(somSelf, ev, facet, where);
}


//------------------------------------------------------------------------------
// DrawPalette::Drop
//------------------------------------------------------------------------------


SOM_Scope ODDropResult SOMLINK ModDrawPalette_DrawPaletteDrop(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
					ODDragItemIterator* dropInfo,
					ODFacet* facet,
					ODPoint* where )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODDropResult    dropResult = kODDropFail;

	dropResult = ModDrawPalette_DrawPalette_parent_ODPart_Drop(somSelf, ev, dropInfo, facet, where);
	
	return dropResult;
}


//------------------------------------------------------------------------------
// DrawPalette::FacetAdded
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteFacetAdded(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFacet* facet)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	somSelf -> MinimizeFrameShape( ev, facet );
}

//------------------------------------------------------------------------------
// ModDrawPalette_DrawPaletteDisplayFrameAdded
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDisplayFrameAdded(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if (frame->GetPart(ev) == _fPartWrapper) {      
		_fDisplayFrames->AddLast(frame);
		
		frame->IncrementRefCount(ev);
	}
}


//------------------------------------------------------------------------------
// ModDrawPalette_DrawPaletteDisplayFrameClosed
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDisplayFrameClosed(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if ( _fDisplayFrames->Contains( frame ))
	{
		_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet, frame);
		_fDisplayFrames->Remove( frame );
		frame -> Release(ev);
	}
}

//------------------------------------------------------------------------------
// ModDrawPalette_DrawPaletteDisplayFrameRemoved
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDisplayFrameRemoved(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* oldFrame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if ( _fDisplayFrames->Contains( oldFrame ))
	{       
		_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,oldFrame);
		_fDisplayFrames->Remove( oldFrame );

		oldFrame->Release(ev);
	}
}

//------------------------------------------------------------------------------
// DrawPalette::FrameShapeChanged
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteFrameShapeChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	frame->ChangeUsedShape(ev, kODNULL, kODNULL);

	if (_fDrawPaletteExt) {
	}
}


// --- GeometryChanged ---

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteGeometryChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
						ODFacet* facet,
						ODBoolean clipShapeChanged,
						ODBoolean externalTransformChanged)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if (facet) {
		ODFrame*        frame = facet->GetFrame(ev);
		if (!frame) {
			return;
		}
	} else {
	}
}

//------------------------------------------------------------------------------
// DrawPalette::WritePartInfo
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteWritePartInfo(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
							ODPtr partInfo,
							ODStorageUnitView* storageUnitView)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if (partInfo)
	{
	}
}


//------------------------------------------------------------------------------
// DrawPalette::ReadPartInfo
//------------------------------------------------------------------------------


SOM_Scope ODPtr SOMLINK ModDrawPalette_DrawPaletteReadPartInfo(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
							ODFrame* frame, ODStorageUnitView*      storageUnitView)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

ODUnused(frame);
	if (storageUnitView->GetSize(ev))
	{
		return ((ODPtr)kODNULL);
	}
	else
		return ((ODPtr)kODNULL);
}


//------------------------------------------------------------------------------
// DrawPalette::AdjustMenus
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteAdjustMenus(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);
}

//------------------------------------------------------------------------------
// DrawPalette::Open
//------------------------------------------------------------------------------


SOM_Scope ODID SOMLINK ModDrawPalette_DrawPaletteOpen(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame*  frame )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODWindow* window = kODNULL;

	if (frame) // Doing a View As Window
	{
		window = _fSession->GetWindowState(ev)->GetWindow(ev, _fWindowID);
		if (window)
			window->Select(ev);
		else
		{
			window = somSelf->CreateAWindow(ev, frame);
			_fWindowID = window->GetID(ev);
			window->Open(ev);
			window->Show(ev);
			window->Select(ev);                     
		}
	}
	else
	{
		window = somSelf->CreateAWindow(ev, frame);
		_fWindowID = window->GetID(ev);
		window->Open(ev);
		window->Show(ev);
		window->Select(ev);                     
	}
	return window->GetID(ev);
}

SOM_Scope ODWindow* SOMLINK ModDrawPalette_DrawPaletteCreateAWindow(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* sourceFrame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODPlatformWindow        platformWindow = kODNULL;
	ODWindow*                       window = kODNULL;

	platformWindow =  _fSession->GetWindowState(ev)->CreatePlatformWindow(ev, kODFalse, WS_CHILD | WS_CLIPSIBLINGS);
	
	window =  _fSession->GetWindowState(ev)->RegisterWindow(ev, platformWindow,
		kODNULL,                                                                                                                
		(sourceFrame==kODNULL), // Keeps draft open
		kODTrue,        // Is resizable
		kODFalse,       // Is floating
		kODTrue,  // should save
		_fPartWrapper, kODNullTypeToken, kODNullTypeToken, sourceFrame);

	return window;
}

//-------------------------------------------------------------------------
// Implementation for Imaging protocol
//-------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDraw(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
							ODFacet* facet, ODShape* invalShape )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

ODUnused(invalShape);

	ODFrame*        displayFrame = facet->GetFrame(ev);
	ODRect          anODRect;
	Rect            boundsRect;

	if (_fDisplayFrames->Contains(displayFrame)) {
		HDC     aDC;
		CFocus  f(facet, invalShape, &aDC);

		ODShape*        frameShape = displayFrame->GetFrameShape(ev, kODNULL);
		ODRgnHandle     frameRgn = frameShape->GetWinRegion(ev);
		GetRgnBox(frameRgn, &boundsRect);
		frameShape->Release(ev);

		InflateRect(&boundsRect, -1, -1);
		FillRect(aDC, &boundsRect, (HBRUSH)GetStockObject(GRAY_BRUSH));

		InflateRect(&boundsRect, 1, 1);
		FrameRect(aDC, &boundsRect, (HBRUSH)GetStockObject(BLACK_BRUSH));

		if (_fDrawPaletteExt) {
			_fDrawPaletteExt->UpdateTools(ev, aDC);
		}
	} else {
		// !!! signal error: invalid frame
	}
}

//------------------------------------------------------------------------------
// DrawPalette::CreateLink
//------------------------------------------------------------------------------


SOM_Scope ODLink* SOMLINK ModDrawPalette_DrawPaletteCreateLink(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODPtr data, ODULong size)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

ODUnused(data);
ODUnused(size);

	return kODNULL;
}


//------------------------------------------------------------------------------
// DrawPalette::LinkUpdated
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteLinkUpdated(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODLink*  updatedLink, ODChangeID id )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

ODUnused(updatedLink);
ODUnused(id);

	// does not support linking
}

//-------------------------------------------------------------------------
// Implementation for Memory Management protocol
//-------------------------------------------------------------------------

SOM_Scope ODSize SOMLINK ModDrawPalette_DrawPalettePurge(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODSize  size )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	return ModDrawPalette_DrawPalette_parent_ODPart_Purge(somSelf, ev, size);
}


//------------------------------------------------------------------------------
// DrawPalette:: Release
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteRelease(ModDrawPalette_DrawPalette *somSelf, Environment *ev)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_Release(somSelf, ev);
	if (somSelf->GetRefCount(ev) == 0) {
		somSelf->GetStorageUnit(ev)->GetDraft(ev)->ReleasePart(ev, _fPartWrapper);
	}
}

//------------------------------------------------------------------------------
// DrawPalette:: Externalize
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteExternalize(ModDrawPalette_DrawPalette *somSelf, Environment *ev)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_Externalize(somSelf, ev);

	ODStorageUnit* storageUnit = _fPartWrapper->GetStorageUnit(ev);
		// Get the reference to where we are writing to.

	storageUnit->Focus(ev, kODPropContents, kODPosSame, kODKindTestDrawPalette, 0, kODPosSame);
		// First we focus on the property we want to write out
	
	storageUnit->SetValue(ev, lstrlen("DrawPalette content"), "DrawPalette content");
		// Now we write out the property.
}


//------------------------------------------------------------------------------
// DrawPalette::BeginRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope ODBoolean SOMLINK ModDrawPalette_DrawPaletteBeginRelinquishFocus(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODTypeToken focus,
								ODFrame* currentFrame,
								ODFrame* proposedFrame )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

ODUnused(focus);
ODUnused(currentFrame);
ODUnused(proposedFrame);

	if ((focus == _fModalFocus) && (proposedFrame->GetPart(ev) != somSelf))
		return kODFalse;
	else
		return kODTrue;
}
	
	
//------------------------------------------------------------------------------
// DrawPalette::CommitRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteCommitRelinquishFocus(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
							ODTypeToken focus,
							ODFrame* currentFrame,
							ODFrame* proposedFrame )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(proposedFrame);
	somSelf->FocusLost(ev, focus, currentFrame);
}
	
							
//------------------------------------------------------------------------------
// DrawPalette::AbortRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteAbortRelinquishFocus(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODTypeToken focus,
								ODFrame* currentFrame,
								ODFrame* proposedFrame )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

ODUnused(focus);
ODUnused(currentFrame);
ODUnused(proposedFrame);
	// default is do nothing
}
			
							
//------------------------------------------------------------------------------
// DrawPalette::FocusAcquired
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteFocusAcquired(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODTypeToken focus, ODFrame* newOwner )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODFrameFacetIterator*   facets = newOwner->CreateFacetIterator(ev);
	ODFacet*                                theFacet = facets->First(ev); 
	delete(facets);
}


//------------------------------------------------------------------------------
// DrawPalette::FocusLost
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteFocusLost(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODTypeToken     focus, ODFrame* oldOwner )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODFrameFacetIterator*   facets = oldOwner->CreateFacetIterator(ev);
	ODFacet*                                theFacet = facets->First(ev); 
	delete(facets);
}


//------------------------------------------------------------------------------
// DrawPalette::MouseEnterFrame
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteMouseEnter(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFacet* facet, ODPoint*  where )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(facet);
	ODUnused(where);
}

//------------------------------------------------------------------------------
// DrawPalette::MouseWithin
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteMouseWithin(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFacet* facet, ODPoint*  where )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(facet);
	ODUnused(where);
}


//------------------------------------------------------------------------------
// DrawPalette::MouseLeaveFrame
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteMouseLeave(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFacet* facet)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(facet);
}


//------------------------------------------------------------------------------
// DrawPalette::DoIdle
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDoIdle(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODEventData* event, ODFrame* frame, ODFacet* facet)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	assert(frame != kODNULL);

	ODFrameFacetIterator*   fiter = frame->CreateFacetIterator(ev);
	ODFacet*                                theFacet = fiter->First(ev);
	delete fiter;
}

//------------------------------------------------------------------------------
// DrawPalette::HandleMouseDown
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK ModDrawPalette_DrawPaletteHandleMouseDown(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODEventData* event, ODFrame* frame, ODFacet* facet )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);

	ODBoolean       tWasHandled = kODFalse;

	if (facet == kODNULL) { // Outside modal focus
		tWasHandled = kODTrue;
	} else {
		tWasHandled = kODTrue;
		if (!IsWindowVisible(facet->GetWindow(ev)->GetPlatformWindow(ev))) {
			facet->GetWindow(ev)->Select(ev);
		} else {
			somSelf->ActivateFrame(ev, frame);

#ifndef WIN32
			Point   downPnt = MAKEPOINT(event->lParam);
#else
			Point   downPnt;
			LONG2POINT(event->lParam, downPnt);
#endif
			ODPoint anODPoint(IntToFixed(downPnt.x), IntToFixed(downPnt.y));

			if (_fDrawPaletteExt) {
				ODULong aTool = _fDrawPaletteExt->PtInTool(ev, &anODPoint);
				if (aTool) {
					if (_fActiveTool != aTool) {
						for (ODULong tmpTool = _fDrawPaletteExt->GetFirstTool(ev); tmpTool != (ODULong)kODNULL; 
										tmpTool = _fDrawPaletteExt->GetNextTool(ev, tmpTool)) {
							if (_fDrawPaletteExt->GetToolState(ev, tmpTool) == kDrawToolStateOn) {
								_fDrawPaletteExt->SetToolState(ev, tmpTool, kDrawToolStateOff);
							}               
						}

						_fDrawPaletteExt->SetToolState(ev, aTool, kDrawToolStateOn);
						_fActiveTool = aTool;
						frame->Invalidate(ev, kODNULL, kODNULL);
					}
				} else {
					ODToolSpaceObj* aTSObj = _fDrawPaletteExt->GetToolSpaceObj(ev);
					if (aTSObj) {
						ODToolSpaceManager*     aToolSpaceMgr = _fSession->GetToolSpaceManager(ev);
						if (aToolSpaceMgr) {
							ODRect  floatBounds;
							_fDrawPaletteExt->GetFloatRect(ev, &floatBounds);
							ODToolSpaceRect newHotZoneRect(_fDrawPaletteExt->GetToolWidth(ev) + IntToFixed(8), 
														_fDrawPaletteExt->GetToolHeight(ev) + IntToFixed(8),
														_fDrawPaletteExt->GetToolWidth(ev) + IntToFixed(8), 
														_fDrawPaletteExt->GetToolHeight(ev) + IntToFixed(8), 
														&floatBounds);
							aToolSpaceMgr->SetHotZones(ev, &newHotZoneRect);
							ODRect                  finalSizePos;
							ODToolSpacePos  dropPos = aToolSpaceMgr->TrackDrag(ev, aTSObj, &anODPoint, 
																				&finalSizePos, kODNULL);
							if (dropPos != aTSObj->GetPosition(ev)) {
								aTSObj->SetSizePos(ev, finalSizePos.left, finalSizePos.top, 
														finalSizePos.right - finalSizePos.left, 
														finalSizePos.bottom - finalSizePos.top, dropPos);
								if (_fDrawPaletteExt) {
									_fDrawPaletteExt->SetSize(ev, &finalSizePos);
									_fDrawPaletteExt->ArrangeTools(ev);
								}
							}
						}
					}
				}
			}
		}
	}
	return tWasHandled;
}


//------------------------------------------------------------------------------
// DrawPalette::InstallMenus
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteInstallMenus(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame*  frame )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if ( frame && _fMenuBar)
	{       
		_fMenuBar->Display(ev);
	}
}


//------------------------------------------------------------------------------
// DrawPalette::RemoveMenus
//------------------------------------------------------------------------------


SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteRemoveMenus(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);
}


//------------------------------------------------------------------------------
// DrawPalette:: CalcActualDrawPaletteShape
//------------------------------------------------------------------------------

SOM_Scope ODShape* SOMLINK ModDrawPalette_DrawPaletteCalcActualDrawPaletteShape(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODPlatformWindow window, ODFacet* facet)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(window);

	ODRect rect;

	if (_fDrawPaletteExt && facet) {
		_fDrawPaletteExt->GetSize(ev, &rect);
		ODCoordinate    width = rect.right - rect.left;
		ODCoordinate    height = rect.bottom - rect.top;
		rect.Set(0, 0, width, height);
	} else {
		rect.SetInt(480, 430, 600, 520);
	}

	ODShape *wantShape = new ODShape;
	wantShape->InitShape(ev);
	wantShape->SetRectangle(ev, &rect);
	
	return wantShape;
}

//------------------------------------------------------------------------------
// DrawPalette:: MinimizeFrameShape
//------------------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteMinimizeFrameShape(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFacet*  facet )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if (!facet) {
		return;
	}

	ODFrame*  frame = facet->GetFrame(ev);

	ODWindow*       anODWindow = facet->GetWindow(ev);

	if (!anODWindow) {
		return;
	}

	ODPlatformWindow        window = anODWindow->GetPlatformWindow(ev);

	ODShape* wantShape = somSelf->CalcActualDrawPaletteShape(ev, window, facet);
	
	frame-> Invalidate(ev, kODNULL, kODNULL);
	frame-> InvalidateActiveBorder(ev);

	ODShape* gotShape = frame -> RequestFrameShape( ev,  wantShape, kODNULL );
	frame-> Invalidate(ev, kODNULL, kODNULL);
	frame-> InvalidateActiveBorder(ev);

	frame->ChangeUsedShape(ev, kODNULL, kODNULL);
}
	

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteActivateFrame(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODBoolean succeeded = kODFalse;

	succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame);

	if (succeeded) {
		ODFrameFacetIterator*   fiter = frame->CreateFacetIterator(ev);
		ODFacet*                                facet = fiter->First(ev);
		delete fiter;
	}
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDeActivateFrame(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,frame);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteActivatingWindow(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	somSelf->ActivateFrame(ev, frame);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDeActivatingWindow(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);
}

//-------------------------------------------------------------------------
// Extension protocol
//-------------------------------------------------------------------------

SOM_Scope ODBoolean     SOMLINK ModDrawPalette_DrawPaletteHasExtension(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODType extensionName)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if ( !strcmp(extensionName, kDrawPaletteExt) )
		return kODTrue;
	else
		return kODFalse;
}

SOM_Scope ODExtension*  SOMLINK ModDrawPalette_DrawPaletteGetExtension(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODType extensionName)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if (!strcmp(extensionName, kDrawPaletteExt) && _fDrawPaletteExt) {
		return((ODExtension*)_fDrawPaletteExt);
	}
	else
		return kODNULL;
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteReleaseExtension(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODExtension* extension)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_ReleaseExtension(somSelf, ev, extension);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteContainingPartPropertiesChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* displayFrame,
								ODStorageUnit* propertyUnit)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_ContainingPartPropertiesChanged(somSelf, ev, displayFrame, propertyUnit);
}

SOM_Scope ODStorageUnit* SOMLINK ModDrawPalette_DrawPaletteGetContainingPartProperties(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* displayFrame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	return ModDrawPalette_DrawPalette_parent_ODPart_GetContainingPartProperties(somSelf, ev, displayFrame);
}

//--------------------------------------------------------------------
// DrawPalette::Redraw
//--------------------------------------------------------------------

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteRedraw(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODBoolean EraseFlag)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	OrderedCollectionIterator       frames(_fDisplayFrames);
	for (   ODFrame *theFrame = (ODFrame *)frames.First(); 
			frames.IsNotComplete(); 
			theFrame = (ODFrame *)frames.Next() )
	{

		ODFrameFacetIterator* facets = theFrame->CreateFacetIterator(ev);
		for (   ODFacet *theFacet = facets->First(ev); 
				facets->IsNotComplete(ev); 
				theFacet = facets->Next(ev) )
		{
			somSelf->Draw(ev, theFacet, kODNULL);
		}
		delete(facets);
	}
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteUndoAction(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODActionData actionState)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(actionState);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteRedoAction(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODActionData actionState)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(actionState);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteDisposeActionState(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODActionData actionState,
								ODDoneState doneState)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(actionState);
	ODUnused(doneState);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteWriteActionState(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODPtr actionState,
								 ODStorageUnitView* storageUnitView)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(actionState);
	ODUnused(storageUnitView);
}

SOM_Scope ODPtr SOMLINK ModDrawPalette_DrawPaletteReadActionState(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODStorageUnitView* storageUnitView)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(storageUnitView);

	return kODNULL;
}

SOM_Scope ODBoolean SOMLINK ModDrawPalette_DrawPaletteHandleEventInEmbedded(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODEventData* event,
								ODFrame* frame, ODFacet* facet,
								ODFrame* embeddedFrame,
								ODFacet* embeddedFacet)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(event);
	ODUnused(frame);
	ODUnused(facet);
	ODUnused(embeddedFrame);
	ODUnused(embeddedFacet);
	
	return kODFalse;
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteExternalizeKinds(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODTypeList* kindList)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_ExternalizeKinds(somSelf, ev, kindList);
	somSelf->Externalize(ev);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteChangeKind(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODType kind)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(kind);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteCloneInto(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODDraftKey key, ODStorageUnit* storageUnit, ODFrame* scopeFrame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODStorageUnit*  su = _fPartWrapper->GetStorageUnit(ev);
	ODDraft*                draft = su->GetDraft(ev);

	ODVolatile(draft);

	somSelf->Externalize(ev);
	
	su->CloneInto(ev, key, storageUnit, scopeFrame->GetStorageUnit(ev)->GetID(ev));

	if (ev->_major != NO_EXCEPTION)
		draft->AbortClone(ev, key);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteRevealLink(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODLinkSource* linkSource)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(linkSource);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteEmbeddedFrameChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* frame, ODChangeID change)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(change);
	ODUnused(frame);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteLinkStatusChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteCanvasUpdated(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODCanvas* canvas)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(canvas);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteHighlightChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFacet* facet)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(facet);
}

SOM_Scope ODULong SOMLINK ModDrawPalette_DrawPaletteGetPrintResolution(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);
	return 0;
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteFacetRemoved(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFacet* facet)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(facet);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteCanvasChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFacet* facet)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(facet);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteRemoveEmbeddedFrame(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* embeddedFrame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(embeddedFrame);

	THROW(kODErrCannotEmbed);
}

SOM_Scope ODShape* SOMLINK ModDrawPalette_DrawPaletteRequestFrameShape(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* embeddedFrame, ODShape* frameShape)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODShape* retFrameShape = 
		ModDrawPalette_DrawPalette_parent_ODPart_RequestFrameShape(somSelf, ev, embeddedFrame, frameShape);
	
	return frameShape;
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteUsedShapeChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* embeddedFrame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(embeddedFrame);
}

SOM_Scope ODShape* SOMLINK ModDrawPalette_DrawPaletteAdjustBorderShape(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFacet* embeddedFacet, ODShape* shape)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(embeddedFacet);

	return shape;
}

SOM_Scope ODFrame* SOMLINK ModDrawPalette_DrawPaletteRequestEmbeddedFrame(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* containingFrame,
								ODFrame* baseFrame,
								ODShape* frameShape,
								ODPart* embedPart,
								ODTypeToken viewType,
								ODTypeToken presentation,
								ODBoolean isOverlaid)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(containingFrame);
	ODUnused(baseFrame);
	ODUnused(frameShape);
	ODUnused(embedPart);
	ODUnused(viewType);
	ODUnused(presentation);
	ODUnused(isOverlaid);

	THROW(kODErrCannotEmbed);
	return kODNULL;
}
	
SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteViewTypeChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPalettePresentationChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteSequenceChanged(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteAttachSourceFrame(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODFrame* frame, ODFrame* sourceFrame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODUnused(frame);
	ODUnused(sourceFrame);
}

SOM_Scope ODBoolean SOMLINK ModDrawPalette_DrawPaletteRevealFrame(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* embeddedFrame, ODShape* revealShape)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	return(ModDrawPalette_DrawPalette_parent_ODPart_RevealFrame(somSelf, ev, embeddedFrame, revealShape));
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteEmbeddedFrameSpec(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* embeddedFrame, ODObjectSpec* spec)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ModDrawPalette_DrawPalette_parent_ODPart_EmbeddedFrameSpec(somSelf, ev, embeddedFrame, spec);
}

SOM_Scope ODEmbeddedFramesIterator* SOMLINK ModDrawPalette_DrawPaletteCreateEmbeddedFramesIterator(ModDrawPalette_DrawPalette *somSelf, 
								Environment *ev, ODFrame* frame)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	return ModDrawPalette_DrawPalette_parent_ODPart_CreateEmbeddedFramesIterator(somSelf, ev, frame);
}

//------------------------------------------------------------------------------
// CreateDrawPaletteSpace
//------------------------------------------------------------------------------

static void CreateDrawPaletteSpace(ODPartWrapper* aDrawPaletteWrapper)
{
	if (!aDrawPaletteWrapper) {
		return;
	}

	Environment *ev = somGetGlobalEnvironment();

	DrawPaletteExt* aDrawPaletteExt = (DrawPaletteExt*)aDrawPaletteWrapper->GetExtension(ev, kDrawPaletteExt);

	if (!aDrawPaletteExt) {
		return;
	}

	ODToolSpaceManager*     aToolSpaceMgr = aDrawPaletteExt->GetSession(ev)->GetToolSpaceManager(ev);

	if (!aToolSpaceMgr) {
		return;
	}

	ODRect  DrawPaletteBounds;
	aDrawPaletteExt->GetSize(ev, &DrawPaletteBounds);

	ODToolSpaceRect aToolSpaceRect;

	if (aToolSpaceRect.IsEmpty()) {
	}
	aToolSpaceRect.Clear();

	switch (aDrawPaletteExt->GetPos(ev)) {
		case kODTSLeft:
			aToolSpaceRect.left = DrawPaletteBounds.right - DrawPaletteBounds.left;
			break;

		case kODTSTop:
			aToolSpaceRect.top = DrawPaletteBounds.bottom - DrawPaletteBounds.top;
			break;

		case kODTSRight:
			aToolSpaceRect.right = DrawPaletteBounds.right - DrawPaletteBounds.left;
			break;

		case kODTSBottom:
			aToolSpaceRect.bottom = DrawPaletteBounds.bottom - DrawPaletteBounds.top;
			break;

		case kODTSFloat:
			aToolSpaceRect.floatRect = DrawPaletteBounds;
			break;

		default:
			return;
	}

	ODToolSpaceObj* aToolSpaceObj = kODNULL;

	if (aToolSpaceMgr->RequestToolSpace(ev, aDrawPaletteExt->GetDomain(ev), 
										aDrawPaletteExt->GetPartFrameShape(ev), &aToolSpaceRect)) {
		if (aToolSpaceObj = aToolSpaceMgr->CreateToolSpace(ev, aDrawPaletteExt->GetDomain(ev), 
															(ODPartWrapper*)aDrawPaletteExt->GetBase(ev), 
															&aToolSpaceRect, 
															aDrawPaletteExt->GetPartFrameShape(ev))) {
		}
	}

	if (aToolSpaceObj) {
		aDrawPaletteExt->SetToolSpaceObj(ev, aToolSpaceObj);
		ODPlatformWindow        toolSpaceWnd = aToolSpaceObj->GetPlatformWindow(ev);
		if (toolSpaceWnd) {
			SetWindowText(toolSpaceWnd, "Draw Tools");
			aDrawPaletteExt->SetToolSpaceWnd(ev, toolSpaceWnd);
		}
	}
}
								
// ********************************************
// Native DrawPalette methods
// ********************************************

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteAddPlatformMenu(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODMenuID aMenuID)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	if (!_fMenuBar) {
	}

	switch (aMenuID) {
		default:
			break;
	}
}

SOM_Scope void SOMLINK ModDrawPalette_DrawPaletteRemovePlatformMenu(ModDrawPalette_DrawPalette *somSelf, Environment *ev, ODMenuID aMenuID)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	switch (aMenuID) {
		default:
			break;
	}
}

//------------------------------------------------------------------------------
// DrawPalette::HandleEvent
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK ModDrawPalette_DrawPaletteHandleEvent(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODEventData* event, ODFrame* frame, ODFacet* facet )
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODBoolean       tWasHandled = kODFalse;
			
	switch ( event -> message ) {
		case WM_COMMAND:
			tWasHandled = somSelf->HandleMenuEvent(ev, frame, event);
			break;

		case WM_CHAR:
			break;

		case kODEvtNull:
			somSelf->DoIdle(ev, event, frame, facet);
			break;

		case WM_LBUTTONDOWN:
			tWasHandled = somSelf->HandleMouseDown(ev, event, frame, facet );
			break;

		case kODEvtActivate:                                                                                            //OLE2
			tWasHandled = TRUE; // actually ignored by dispatcher           //OLE2
			if (event->wParam  != WA_INACTIVE)                                                      //OLE2
				somSelf->HandleMouseDown(ev, event,frame,facet);                                //OLE2
			break;                                                                                                          //OLE2

		case WM_KEYDOWN:
			break;

		default:
			break;
	}

	return tWasHandled;
}

//------------------------------------------------------------------------------
// DrawPalette::HandleMenuEvent
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK ModDrawPalette_DrawPaletteHandleMenuEvent(ModDrawPalette_DrawPalette *somSelf, Environment *ev, 
								ODFrame* frame, ODEventData* event)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	ODCommandID command = event->message;

	ODBoolean tEventHandled = kODTrue;

	switch ( event->wParam ) {
		case kODCommandAbout:
			if (_fSession->GetArbitrator(ev)->RequestFocus(ev, _fSession->Tokenize(ev, kODModalFocus),frame)) {
				MessageBox (GetDesktopWindow(), "DrawPalette Part.", "Alert", MB_OK);
				_fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fSession->Tokenize(ev, kODModalFocus),frame);
			}
			else
				MessageBeep(MB_OK);
			break;
		
		case kODCommandViewAsWin:
			somSelf->Open(ev, frame);
			break;

		case kODCommandCut:
			tEventHandled = kODTrue;
			break;

		case kODCommandCopy:
			tEventHandled = kODTrue;
			break;

		case kODCommandPaste:
			tEventHandled = kODTrue;
			break;

		default:
			break;
	}

	if (tEventHandled) {                                                    // if change made, resize the frame
		ODFrameFacetIterator*   fiter;
		fiter = frame->CreateFacetIterator(ev);
		ODFacet*        theFacet = fiter->First(ev);
		delete fiter;
		somSelf -> MinimizeFrameShape( ev, theFacet );
	}

	return tEventHandled;
}

//------------------------------------------------------------------------------
// DrawPalette::GetDisplayFrames
//------------------------------------------------------------------------------

SOM_Scope OrderedCollection* SOMLINK ModDrawPalette_DrawPaletteGetDisplayFrames(ModDrawPalette_DrawPalette *somSelf, Environment *ev)
{
	ModDrawPalette_DrawPaletteData *somThis = ModDrawPalette_DrawPaletteGetData(somSelf);

	return _fDisplayFrames;
};
