/*
	File:		DrawPart.cpp

	Contains:	Draw test part

	Written by:	SomVersion by Eric House; original by others

	Copyright:	c 1994 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		<54>	 10/5/94	VL		After something is dropped into DrawPart,
									it will be selected.
		<53>	 10/5/94	RR		Enable dragging selected parts
		<52>	 9/30/94	SS		Added SetSelected & ChangeHighlight calls
									for embedded facets + clipping fixes
		<51>	 9/30/94	RR		#1188888 Activate on mouseUp
		<50>	 9/29/94	JBS		1188214: convert for refcounted shapes &
									transforms; #1182230 remove kODID (eeh)
		<49>	 9/23/94	VL		Made DrawPart do the right thing when the
									Drag results in a Move.
		<48>	 9/23/94	NP		1188521: CreateEmbeddedFrameIterator needs
									an ODPart* and not an ODPartWrapper*.
		<47>	 9/22/94	JBS		1188214: coordinate bias implementation
		<46>	 9/22/94	eeh		#1188170 in ::Draw, rearranged order in
									which Tokenize is called to make normal
									presentation the default.
		<45>	 9/15/94	VL		1184871: Use Promises for d&d.
		<44>	 9/12/94	CG		1183531: PartWrappler class implemented.
		<43>	  9/9/94	NP		1185425: embedded frame iterator
									instantiation.
		<42>	  9/8/94	NP		Embedded frame iterator and scripting
									changes.
		<41>	  9/6/94	RR		#1183392 Moved handling of some events to
									HandleEventInEmbedded
		<40>	  9/5/94	VL		1183174: Use IsValidStorageUnitRef instead
									of exception.
		<39>	  9/1/94	RR		Added invalidation to GeometryChanged.
									Hard-code View AS Window title for now.
									Added debugging somPrintf's for MouseEnter
									et al and activate events
		<38>	  9/1/94	CC		RADAR #1183005 - change AdjustBorderShape
									param from Frame to Facet (for JBS)
		<37>	 8/31/94	VL		1183174, 1153462: Fixed CloneInto to avoid
									multiple cloning. Also, DrawPart should not
									depend on kODPropPart to determine whether
									a clone is permissible. (Commented the loop
									which does the check).
		<36>	 8/29/94	T		#1183567 StdTypIO routine implementation &
									fixup
		<35>	 8/28/94	VL		#1182975: DragEnter & DragWithin should
									return ODDragResult (instead of ODBoolean).
		<34>	 8/26/94	T		#1181761 rename obsolete kOD IDs to correct
									kODStrong/WeakStorageUnitRefs
		<33>	 8/26/94	VL		1183174: Use updated cloning APIs.
		<32>	 8/19/94	T		#1180922 Need to Stop using obsolete types
									(kOD ID)
		<31>	 8/18/94	jpa		Use object factories (only remaining
									problem is with ODFocusModules.) [1181835]
		<30>	 8/17/94	jpa		Fixed FrameFacetIter leak in SetNewBounds
									[1181532]
		<29>	 8/16/94	VL		1143605: Fixed parameters to CloneInto.
		<28>	 8/15/94	JBS		1181138: add frameType to CreateFrame();
									1181156: UI API Cleanup
		<27>	 8/15/94	VL		#???: Added frameType (kODNULL) parameter
									to CreateFrame.
		<26>	 8/13/94	T		#1180814 Added support for ODPartWrapper
									API
		<25>	 8/12/94	JBS		1179919: add biasCanvas param to
									Draft::CreateFrame()
		<24>	 8/10/94	JBS		1179919: coordinate system bias changes
		<23>	  8/9/94	VL		1179857: DragEnter and DragWithin return
									ODBoolean.
		<22>	  8/8/94	jpa		Use shape/xform factories -- NewShape,
									NewTransform, Copy [1179574]
		<21>	  8/5/94	JBS		#1179151 Part API cleanup
		<20>	  8/4/94	eeh		1160484: fix focus bug (for Craig)
		<19>	  8/3/94	CC		Replaced clipboard locks with the clipboard
									focus. (1160484)
		<18>	  8/3/94	VL		1153123: No dependency on Storage.xh.
		<17>	  8/3/94	NP		Reenabled Undo support.
		<16>	  8/1/94	CC		Changed Point parameter to Point* in
									InvalEmbedFrameAfterResize(),
									HandleMouseDownCornerResize(), and
									HandleMouseDownEdgeResize().
		<15>	 7/27/94	T		added UNDONEEDSFIXINMAYBE #define to work
									around possible Undo problem.
		<14>	 7/27/94	JBS		ClipEmbeddedFacets in GeometryChanged
		<13>	 7/20/94	T		took out some garbage text which MPW Shell
									accidentally spewed into this file instead
									of the worksheet
		<12>	 7/20/94	eeh		hack ::Draw to work around frame
									presentation externalization problems
		<11>	 7/19/94	T		took out call to parent in GeometryChanged
		<10>	 7/19/94	jpa		Fixed another 'frame' param in
									HandlePrinting.
		 <9>	 7/19/94	eeh		fixed param in InstallMenus
		 <8>	 7/15/94	jpa		SetQDOffset now takes a Point*.
		 <7>	 7/14/94	T		fixed an IText bug, don't allocate memory
									for IText objects, let ODGetPOName do it
									for you.
		 <6>	 7/14/94	eeh		"Apple" module name -> "AppleTestDraw" (via
									search&replace rather than the C++ emitter)
		 <5>	 7/13/94	VL		Changed Release to call its parent instead
									of itself.
		 <4>	 7/12/94	eeh		add Externalize
		 <3>	 7/12/94	VL		Fixed InitPart to call its parents.
		 <2>	 7/11/94	eeh		(incomplete) changes reflecting a6->a7 Part
									API
		 <1>	  7/6/94	eeh		first checked in

	To Do:
	In Progress:
*/


#ifndef _ALTPOINT_
#include "AltPoint.h"			// Use C++ savvy ODPoint and ODRect
#endif

//skn#ifndef SOM_Module_OpenDoc_Global_Types_defined
//skn#include "ODTypesM.xh"
//skn#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _DRWSHARE_
#include "DrwShare.h"
#endif

#define SOM_Module_drawpart_Source
#define VARIABLE_MACROS
#include <DrawPart.xih>

#ifndef _DRAWOBJ_
#include "DrawObj.h"
#endif

#ifndef _DRAWDEF_
#include "Drawdef.h"
#endif

#ifndef _ODUTILW_
#include "ODUtilW.h"
#endif

#ifdef PLATFORM_MACINTOSH
#ifndef __EVENTS__
//bgn#include <Events.h>		// GetMouse, StillDown.
#endif

#ifndef __MENUS__
//bgn#include <Menus.h>
#endif

#ifndef __QUICKDRAW__
//bgn#include <Quickdraw.h>
#endif

#ifndef __RESOURCES__
//bgn#include <Resources.h>
#endif

#ifndef __ICONS__
//bgn#include <Icons.h>
#endif

#ifndef __PICKER__
//bgn#include <Picker.h>
#endif

#ifndef __TOOLUTILS__
//bgn#include <ToolUtils.h>	// HiWord etc.
#endif

#ifndef __LIMITS__
//bgn#include <limits.h>
#endif

#ifndef __STDLIB__
//bgn#include <StdLib.h>		// Abs
#endif

#ifndef _USERSRCM_
//bgn#include "UseRsrcM.h"
#endif
#endif

#ifndef SOM_Module_OpenDoc_Foci_defined
#include <Foci.xh>
#endif

#ifndef SOM_ODDragItemIterator_xh
#include "DgItmIt.xh"
#endif

#ifndef SOM_ODFocusSet_xh
#include <FocusSet.xh>
#endif

#ifndef SOM_Module_OpenDoc_Commands_defined
#include <CmdDefs.xh>
#endif

#ifndef SOM_ODArbitrator_xh
#include <Arbitrat.xh>
#endif

#ifndef SOM_ODInfo_xh
#include "Info.xh"
#endif

#ifndef _INFOUTIL_
#include "InfoUtil.h"
#endif

#ifndef _ISOSTRING_
#include "ISOStr.h"
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_ODDispatcher_xh
#include <Disptch.xh>
#endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef _ODMEMORY_
#include "ODMemory.h"
#endif

#ifndef _FOCUSLIB_
#include "FocusLib.h"
#endif

#ifndef SOM_ODFacet_xh
#include <Facet.xh>
#endif

#ifndef SOM_ODFacetIterator_xh
#include "FacetItr.xh"
#endif

#pragma message	("Before frame.xh")
#ifndef SOM_ODFrame_xh
#include <Frame.xh>
#endif
#pragma message	("After frame.xh")

#ifndef SOM_ODShape_xh
#include <Shape.xh>
#endif

#ifndef SOM_ODStorageUnit_xh
#include <StorageU.xh>
#endif

#ifndef SOM_ODToolSpaceManager_xh
#include <ODTlSpc.xh>
#endif

#ifndef SOM_ODToolSpaceObj_xh
#include <ODTlObj.xh>
#endif

#ifndef SOM_Module_OpenDoc_StdProps_defined
#include <StdProps.xh>
#endif

#ifndef SOM_Module_OpenDoc_StdTypes_defined
#include <StdTypes.xh>
#endif

#ifndef SOM_ODStorageUnitView_xh
#include <SUView.xh>
#endif

#ifndef SOM_ODStorageUnitCursor_xh
#include <SUCursor.xh>
#endif

#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_ODDocument_xh
#include <Document.xh>
#endif

//#ifndef SOM_ODContainer_xh
//#include <ODCtr.xh>
//#endif

#ifndef SOM_ODMenuBar_xh
#include "MenuBar.xh"
#endif

#ifndef SOM_ODWindow_xh
#include <Window.xh>
#endif

#ifndef SOM_ODWindowState_xh
#include <WinStat.xh>
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef SOM_ODFrameFacetIterator_xh
#include "FrFaItr.xh"
#endif

#ifdef LATER
#ifndef SOM_ODSemanticInterface_xh
//bgn#include <SemtIntf.xh>
#endif
#endif

#ifdef PLATFORM_MACINTOSH
#ifndef _SIHELPER_
//bgn#include <SIHelper.h>
#endif
#endif

#ifdef LATER
#ifndef SOM_ODNameResolver_xh
//bgn#include <NamRslvr.xh>
#endif

#ifndef _SEUTILS_
#include "SEUtils.h"
#endif
#endif

#ifndef SOM_Module_OpenDoc_StdProps_defined
#include <StdProps.xh>
#endif

#ifndef SOM_ODDragAndDrop_xh
#include <DragDrp.xh>
#endif

#ifndef SOM_Module_OpenDoc_StdDefs_defined
#include <StdDefs.xh>
#endif

#ifndef SOM_ODCanvas_xh
#include <Canvas.xh>
#endif

#ifndef _ODUTILS_
#include <ODUtils.h>
#endif

//bgn#ifndef _PASCLSTR_
//bgn#include "PasclStr.h"
//bgn#endif

#ifndef SOM_ODUndo_xh
#include <Undo.xh>
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODClipboard_xh
#include <Clipbd.xh>
#endif

#ifndef _DRAWPART_
#include "DrawPart.h"
#endif

//#ifndef _DFRMITER_
//#include "DFrmIter.h"
//#endif

//skn#ifndef SOM_DrawEmbeddedFramesIterator_xh
//skn#include "DrwEmFrI.xh"
//skn#endif

#ifdef PLATFORM_MACINTOSH
#ifndef mathRoutinesIncludes
//bgn#include <math routines.h>		// See MoveTransformBy
#endif
#endif

#ifndef SOM_ODPartWrapper_xh
#include "PartWrap.xh"
#endif

#ifndef _T_REGIST_
#include "t_regist.h"
#endif

#ifndef SOM_DrawPaletteExt_xh
#include <DrPlExt.xh>
#endif

#ifndef _DRAWSHAP_
#include "DrawShap.h"
#endif

#include "DrawPart.rh"
#include "stdidsw.h"

#define kDrawPalette "Apple:Kind:TestDrawPalette"

//bt Test Printing
void ShowRgn(HRGN rgn);

//skn#pragma segment DrawPart

#ifdef TO_BE_DELETED
// NOTE: these three not yet implemented, as I'm not sure how.
SOM_Scope void  SOMLINK AppleTestDraw_DrawPartGeometryChanged()
SOM_Scope ODFrame*  SOMLINK AppleTestDraw_DrawPartRequestEmbeddedFrame()
SOM_Scope void  SOMLINK AppleTestDraw_DrawPartSequenceChanged()
#endif // TO_BE_DELETED

LRESULT CALLBACK ShadowWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

//==============================================================================
// Constants
//==============================================================================

	const ODSShort kODBorderWidth = 4;
	const ODSShort kODHandleLenMultiplier = 1;


	static const COLORREF rgbGray =	 	RGB(127, 127, 127 );
	static const COLORREF rgbRed =		RGB(255, 0, 0 );
	static const COLORREF rgbGreen =	RGB(0, 255, 0 );
	static const COLORREF rgbYellow =	RGB(255, 255, 0 );
	static const COLORREF rgbBlue =	 	RGB(0, 0, 255 );
	static const COLORREF rgbMagenta =	RGB(255, 0, 255 );
	static const COLORREF rgbCyan =	 	RGB(0, 255, 255 );
	static const COLORREF rgbWhite =	RGB(255, 255, 255 );
	static const COLORREF rgbBlack =	RGB(0, 0, 0 );

	const ODSShort kPaletteLeft = 0;
	const ODSShort kPaletteRight = 50;
	const ODSShort kPaletteTop = 0;
	const ODSShort kPaletteBottom = 200;

	enum {
		kGray = 0,
		kRed,
		kGreen,
		kYellow,
		kBlue,
		kMagenta,
		kCyan,
		kWhite,
		kNumColors
	};

	const		ODSShort	kMargin = 10;

const short 	kSuspendResumeMessage = 0x01;	// Resume vs. suspend mask
const short 	kMouseMovedMessage    = 0xFA;	// High byte mouse-moved event message

// $$$$$ STATIC BUILD CRUFT
// $$$$$ EMBED MENU CRUFT.  SHOULD NOT BE HARDCODING OTHER PART KINDS INTO CODE.
static const ODType kODPartTogglePart        = "TogglePart";
static const ODType kODPartButtonPart        = "ButtonPart";
static const ODType kODPartTextPart          = "TextPart";
static const ODType kODPartDrawPart          = "Apple:Kind:TestDraw";
static const ODType kODPartMoviePart         = "MoviePart";
static const ODType kODPartClockPart         = "Apple:Kind:TestClock";
static const ODType kODPartStylPart          = "StylPart";
static const ODType kODPartTestPart          = "TestPart";
static const ODType kODPartDragPart          = "Apple:Kind:TestDrag";
static const ODType kODPartPartsBin          = "Apple:Kind:PartsBin";

//==============================================================================
// Commands
//==============================================================================
	
	const ODCommandID cGray = 2001;
	const ODCommandID cRed = 2002;
	const ODCommandID cGreen = 2003;
	const ODCommandID cYellow = 2004;
	const ODCommandID cBlue = 2005;
	const ODCommandID cMagenta = 2006;
	const ODCommandID cCyan = 2007;
	const ODCommandID cWhite = 2008;
	const ODCommandID cOtherColor = 2009;


//==============================================================================
// 'ternalization
//==============================================================================
		
	static const ODPropertyName	kPropFrameInfo = "DrawPart:Property:FrameInfo";
	static const ODPropertyName	kPropMouseDownOffset = "DrawPart:Property:MouseDownOffset";

	static const ODValueType		kWinPoint = "DrawPart:Type:Point";
	static const ODValueType		kTPrintRec = "Macintosh:Type:TPrint Record";
	static const ODValueType		kODFrameRef = "Macintosh:Type:FrameReference";

	static const ODType			kDrawPresNormal =  "DrawPart:Presentation:Normal";
	static const ODType			kDrawPresPalette = "DrawPart:Presentation:Palette";

	static const ODPropertyName kODPropBGColor = "BGColor";

#define kKindTestDraw "Apple:Kind:TestDraw"

//==============================================================================
// Function Prototype
//==============================================================================


ODBoolean RGBEqual(ODULong a, ODULong b);	// Function Prototype for correctness

ODBoolean RGBEqual(ODULong a,ODULong b)
{
	return (a == b);
}

ODUShort DetermineNumberOfPagesinDoc(Environment* ev, ODFrame* frame, Rect page);
ODBoolean ValueOnClipboard(Environment* ev, ODSession* session);
ODHandle DPCopyHandle (ODHandle hRgn);
BOOL WaitMouseMoved(HWND    hwnd);


//==============================================================================
// Global Variable
//==============================================================================

static Proxy*	dadSelection;

HINSTANCE	gDrawPartDllInstance;								// DLL instance handle

//==============================================================================
// Finally, the code....
//==============================================================================

//==============================================================================
// Function:	DrawPartDLLEntry
//
// Parameters:
//		hInst - Dll instance handle
//		fdwReason - Reason code
//		lpvReserved - Reserved
//
// Return:	BOOL
//	
// Description:  This function is called by Windows when the Dll is loaded
//
BOOL WINAPI DrawPartDLLEntry( HINSTANCE hInst, DWORD fdwReason, LPVOID lpvReserved)
{
	// Store the instance of the dll for later use.
   gDrawPartDllInstance = hInst;
   return 1;
}

//------------------------------------------------------------------------------
// DrawPart::GetSemanticInterface
//------------------------------------------------------------------------------

#ifdef LATER
SOM_Scope ODSemanticInterface*  SOMLINK AppleTestDraw_DrawPartGetSemanticInterface(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetSemanticInterface");

	 return _fSemtIntf;
}

// $$$$$ a very temporary hack....
static short ItemFromClass(DescType theClass)
{
	short item;
	
	switch(theClass)
	{
		case cDrawPart : item = 1;
		case cDragPart : item = 2;
		case cClockPart : item = 3;
		case cTestPart : item = 4;
	}
	
	return item;
}
#endif

//------------------------------------------------------------------------------
// DrawPart::CreateNewPart
//------------------------------------------------------------------------------

//sknSOM_Scope ODPart*  SOMLINK AppleTestDraw_DrawPartCreateNewPart(AppleTestDraw_DrawPart *somSelf, Environment *ev,
//skn		ODULong theClass,
//skn		AEDesc* theLocation)
//skn{	
//skn	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
//skn	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CreateNewPart");
//skn
//skn	ODUnused(theLocation);
//skn	OrderedCollectionIterator iter(_fDisplayFrames);
//skn	ODFrame* frame = (ODFrame*)iter.First();
//skn
//skn	ODPart* theResult;
//skn	somSelf->Embed(ev, ItemFromClass(theClass), frame, &theResult);
//skn	return theResult;
//skn}

//------------------------------------------------------------------------------
// DrawPart::SetNewBounds
//------------------------------------------------------------------------------

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartSetNewBounds(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame,
		Rect* r)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","SetNewBounds");

	Proxy* p = somSelf->ProxyForFrame(ev, frame);

	Point pt = *(Point*)r;
	p->transform->SetWinOffset(ev, &pt);

	Rect rNormalized = *r;
	OffsetRect(&rNormalized, -pt.x, -pt.y);
	ODRect ODr = rNormalized;
	ODShape* shape = frame->GetFrameShape(ev, kODNULL);
	shape->SetRectangle(ev, &ODr);
	
	ODTransform* newXform = kODNULL;
	ODFrameFacetIterator* fi = frame->CreateFacetIterator(ev);
	for(ODFacet* facet = fi->First(ev); fi->IsNotComplete(ev);
			facet = fi->Next(ev))
	{
		newXform = p->transform->Copy(ev);
		facet->ChangeGeometry(ev, kODNULL, newXform, kODNULL);
		facet->Invalidate(ev, kODNULL, kODNULL);
		newXform->Release(ev);
	}
	delete fi;

	frame->ChangeFrameShape(ev, shape, kODNULL);
	shape->Release(ev);
}

SOM_Scope Proxy*  SOMLINK AppleTestDraw_DrawPartProxyForFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ProxyForFrame");

	if (_fEmbeddedFrames->Contains(frame))
	{
		Proxy* p;
		OrderedCollectionIterator i(_fContents);
		for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
			if (p->frame == frame) return p;
		return kODNULL;
	}
	else
		THROW(kODErrInvalidFrame);

	return kODNULL;
}


/*
 * SOM_Scope void  SOMLINK AppleTestDraw_DrawPartUpdateProxyRegion(AppleTestDraw_DrawPart *somSelf, Environment *ev,
 * 		Proxy proxy)
 */

/*
 * The prototype for AppleTestDraw_DrawPartUpdateProxyRegion was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK AppleTestDraw_DrawPartUpdateProxyRegion(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		Proxy* proxy)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","UpdateProxyRegion");

	ODShape* frameShape = proxy->frame->GetFrameShape(ev, kODNULL);
	ODShape* scratch = frameShape->Copy(ev);
	scratch->Transform(ev, proxy->transform);
	RgnHandle scratchRgn = scratch->GetWinRegion(ev);
	CombineRgn (proxy->region, scratchRgn, scratchRgn, RGN_COPY);
	frameShape->Release(ev);
	scratch->Release(ev);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartCreateProxySelectionBorder(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		Proxy* p)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CreateProxySelectionBorder");

	// -- selection border region --

	ODRgnHandle border = ODNewRgn();
	CombineRgn (border, p->region, p->region, RGN_COPY);
	border = InflateRGN (border, kODBorderWidth);
	CombineRgn (border, border, p->region, RGN_DIFF);

	RECT borderRect, tempRect;
	RgnHandle tempRgn;
	GetRgnBox (border, &borderRect);

	// -- corner region --

RgnHandle cornerHdlRgn = ODNewRgn();

	// top left handle
	CopyRect (&tempRect, &borderRect);
	tempRect.right = borderRect.left + (kODHandleLenMultiplier * kODBorderWidth);
	tempRect.bottom = borderRect.top + kODBorderWidth;
	tempRgn = CreateRectRgnIndirect (&tempRect);
	CombineRgn (cornerHdlRgn, cornerHdlRgn, tempRgn, RGN_OR);
	DeleteObject (tempRgn);
	
	CopyRect (&tempRect, &borderRect);
	tempRect.right = borderRect.left + kODBorderWidth;
	tempRect.bottom = borderRect.top + (kODHandleLenMultiplier * kODBorderWidth);
	tempRgn = CreateRectRgnIndirect (&tempRect);
	CombineRgn (cornerHdlRgn, cornerHdlRgn, tempRgn, RGN_OR);
	DeleteObject (tempRgn);
	
	// top right handle
	CopyRect (&tempRect, &borderRect);
	tempRect.left = borderRect.right - (kODHandleLenMultiplier * kODBorderWidth);
	tempRect.bottom = borderRect.top + kODBorderWidth;
	tempRgn = CreateRectRgnIndirect (&tempRect);
	CombineRgn (cornerHdlRgn, cornerHdlRgn, tempRgn, RGN_OR);
	DeleteObject (tempRgn);
	
	CopyRect (&tempRect, &borderRect);
	tempRect.left = borderRect.right - kODBorderWidth;
	tempRect.bottom = borderRect.top + (kODHandleLenMultiplier * kODBorderWidth);
	tempRgn = CreateRectRgnIndirect (&tempRect);
	CombineRgn (cornerHdlRgn, cornerHdlRgn, tempRgn, RGN_OR);
	DeleteObject (tempRgn);

	// bottom right handle
	CopyRect (&tempRect, &borderRect);
	tempRect.left = borderRect.right - (kODHandleLenMultiplier * kODBorderWidth);
	tempRect.top = borderRect.bottom - kODBorderWidth;
	tempRgn = CreateRectRgnIndirect (&tempRect);
	CombineRgn (cornerHdlRgn, cornerHdlRgn, tempRgn, RGN_OR);
	DeleteObject (tempRgn);
	
	CopyRect (&tempRect, &borderRect);
	tempRect.left = borderRect.right - kODBorderWidth;
	tempRect.top = borderRect.bottom - (kODHandleLenMultiplier * kODBorderWidth);
	tempRgn = CreateRectRgnIndirect (&tempRect);
	CombineRgn (cornerHdlRgn, cornerHdlRgn, tempRgn, RGN_OR);
	DeleteObject (tempRgn);
							
	// bottom left handle
	CopyRect (&tempRect, &borderRect);
	tempRect.right = borderRect.left + (kODHandleLenMultiplier * kODBorderWidth);
	tempRect.top = borderRect.bottom - kODBorderWidth;
	tempRgn = CreateRectRgnIndirect (&tempRect);
	CombineRgn (cornerHdlRgn, cornerHdlRgn, tempRgn, RGN_OR);
	DeleteObject (tempRgn);
	
	CopyRect (&tempRect, &borderRect);
	tempRect.right = borderRect.left + kODBorderWidth;
	tempRect.top = borderRect.bottom - (kODHandleLenMultiplier * kODBorderWidth);
	tempRgn = CreateRectRgnIndirect (&tempRect);
	CombineRgn (cornerHdlRgn, cornerHdlRgn, tempRgn, RGN_OR);
	DeleteObject (tempRgn);

	// -- edge region --

	RgnHandle edgeHdlRgn = ODNewRgn();

	if ((borderRect.right - borderRect.left) >= (5 * kODHandleLenMultiplier * kODBorderWidth)) {
	
		short hcenter = (borderRect.right - borderRect.left) / 2;
		short hdist = (kODHandleLenMultiplier * kODBorderWidth) / 2;
		
		// top middle handle
		CopyRect (&tempRect, &borderRect);
		tempRect.left = borderRect.left + hcenter - hdist;
		tempRect.right = borderRect.left + hcenter + hdist;
		tempRect.bottom = borderRect.top + kODBorderWidth;
		tempRgn = CreateRectRgnIndirect (&tempRect);
		CombineRgn (edgeHdlRgn, edgeHdlRgn, tempRgn, RGN_OR);
		DeleteObject (tempRgn);
	
		// bottom middle handle
		CopyRect (&tempRect, &borderRect);
		tempRect.left = borderRect.left + hcenter - hdist;
		tempRect.right = borderRect.left + hcenter + hdist;
		tempRect.top = borderRect.bottom - kODBorderWidth;
		tempRgn = CreateRectRgnIndirect (&tempRect);
		CombineRgn (edgeHdlRgn, edgeHdlRgn, tempRgn, RGN_OR);
		DeleteObject (tempRgn);

	}
	
	if ((borderRect.bottom - borderRect.top) >= (5 * kODHandleLenMultiplier * kODBorderWidth)) {
	
		short vcenter = (borderRect.bottom - borderRect.top) / 2;
		short vdist = (kODHandleLenMultiplier * kODBorderWidth) / 2;
		
		// left middle handle
		CopyRect (&tempRect, &borderRect);
		tempRect.right = borderRect.left + kODBorderWidth;
		tempRect.top = borderRect.top + vcenter - vdist;
		tempRect.bottom = borderRect.top + vcenter + vdist;
		tempRgn = CreateRectRgnIndirect (&tempRect);
		CombineRgn (edgeHdlRgn, edgeHdlRgn, tempRgn, RGN_OR);
		DeleteObject (tempRgn);
	
		// right middle handle
		CopyRect (&tempRect, &borderRect);
		tempRect.left = borderRect.right - kODBorderWidth;
		tempRect.top = borderRect.top + vcenter - vdist;
		tempRect.bottom = borderRect.top + vcenter + vdist;
		tempRgn = CreateRectRgnIndirect (&tempRect);
		CombineRgn (edgeHdlRgn, edgeHdlRgn, tempRgn, RGN_OR);
		DeleteObject (tempRgn);
	}
	

	// clip by obscuring frames

	Proxy* q;
	OrderedCollectionIterator i(_fContents);
	ODBoolean above = TRUE;
	for (q = (Proxy*) i.First(); i.IsNotComplete(); q = (Proxy*) i.Next())
	{	if (p == q) {above = FALSE; continue;}
		if (!above) {continue;}
		CombineRgn (border, border, q->region, RGN_DIFF);
		CombineRgn (cornerHdlRgn, cornerHdlRgn, q->region, RGN_DIFF);
		CombineRgn (edgeHdlRgn, edgeHdlRgn, q->region, RGN_DIFF);
	};


	DeleteObject(_fCornerHandleRgn);
	_fCornerHandleRgn = cornerHdlRgn;
	CombineRgn (border, border, cornerHdlRgn, RGN_OR);

	DeleteObject(_fEdgeHandleRgn);
	_fEdgeHandleRgn = edgeHdlRgn;
	CombineRgn (border, border, edgeHdlRgn, RGN_OR);
	
	DeleteObject(_fSelectRgn);
	_fSelectRgn = border;
	
	// clip path from obscured frames
	somSelf->ClipEmbeddedFrames(ev, p->frame->GetContainingFrame(ev));
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartInvalidateSelection(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","InvalidateSelection");

	ODShape* selectShape = frame->CreateShape(ev);
	CombineRgn(_fSelectRgn,_fCornerHandleRgn,_fSelectRgn, RGN_OR);
	selectShape->SetWinRegion(ev, (RgnHandle)DPCopyHandle((ODHandle)_fSelectRgn));
	frame->Invalidate(ev, selectShape, kODNULL);
	selectShape ->Release(ev);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartClipEmbeddedFrames(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ClipEmbeddedFrames");

	ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
	for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev);
			facet = facets->Next(ev))
		somSelf->ClipEmbeddedFacets(ev, facet);
	delete facets;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartCommonInitDrawPart(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CommonInitDrawPart");

	srand((ODUShort)GetTickCount());

	_fShapes = new OrderedCollection;
	_fDisplayFrames = new OrderedCollection;
	_fEmbeddedFrames = new OrderedCollection;

	_fContents = new OrderedCollection;
	_fSelection = new OrderedCollection;
	
	_fSelectRgn = ODNewRgn();
	_fCornerHandleRgn = ODNewRgn();
	_fEdgeHandleRgn = ODNewRgn();


	_fEmbedMenu.menu = CreatePopupMenu();
	strcpy (_fEmbedMenu.strMenu, "E&mbed");
	_fColorMenu.menu = CreatePopupMenu();
	strcpy (_fColorMenu.strMenu, "&Background");
	_fFrameMenu.menu = CreatePopupMenu();
	strcpy (_fFrameMenu.strMenu, "F&rame");
	_fPaletteMenu.menu = CreatePopupMenu();
	strcpy (_fPaletteMenu.strMenu, "&Palette");
	
//skn	if (!_fEmbedMenu.hMenu || !_fColorMenu.hMenu || !_fFrameMenu.hMenu)
//skn		DebugStr("\pError creating menus");
	
	_fSession = somSelf->/*ODPersistentObject::*/GetStorageUnit(ev)->GetSession(ev);

//skn	_fPartCount = -1; 	//TAG - this will increment the 1st time to 0 to
						//		exclude the omnipresent IDM_DRAW part...
//skn	_fStringIndex = 0;	//	This indexes into part type string buffer.
	_firstPartToken = kODPartCmdRangeBegin + 0x8000;
	_lastPartToken = somSelf->AddPartsToMenu(ev, _fEmbedMenu, _firstPartToken);
	
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_GRAY,   "Gray");
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_RED,    "Red");
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_GREEN,  "Green");
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_YELLOW, "Yellow");
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_BLUE, 	 "Blue");
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_MAGENTA,"Magenta");
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_CYAN,	 "Cyan");
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_WHITE,	 "White");
	AppendMenu(_fColorMenu.menu, MF_STRING | MF_ENABLED, IDM_OTHER,	 "Other...");

	AppendMenu(_fFrameMenu.menu, MF_STRING | MF_ENABLED, IDM_FREEZE, "Freeze");
	AppendMenu(_fFrameMenu.menu, MF_STRING | MF_ENABLED, IDM_DEFROST, "Defrost");
		
	AppendMenu(_fPaletteMenu.menu, MF_STRING | MF_ENABLED, IDM_SHOWPALETTE, "Show");
	AppendMenu(_fPaletteMenu.menu, MF_STRING | MF_ENABLED, IDM_HIDEPALETTE, "Hide");
		
	_fMenuBar = _fSession->GetWindowState(ev)->CopyBaseMenuBar(ev);

	_fMenuBar->AddMenuLast(ev, (ODMenuID)"E&mbed", &_fEmbedMenu, _fPartWrapper);
	_fMenuBar->AddMenuLast(ev, (ODMenuID)"&Background", &_fColorMenu, _fPartWrapper);
	_fMenuBar->AddMenuLast(ev, (ODMenuID)"F&rame", &_fFrameMenu, _fPartWrapper);
	_fMenuBar->AddMenuLast(ev, (ODMenuID)"&Palette", &_fPaletteMenu, _fPartWrapper);
	
	_fSelectionFocus = _fSession->Tokenize(ev, kODSelectionFocus);
	_fMenuFocus = _fSession->Tokenize(ev, kODMenuFocus);
	_fKeyFocus = _fSession->Tokenize(ev, kODKeyFocus);
	_fClipboardFocus = _fSession->Tokenize(ev, kODClipboardFocus);

#if 0
	// The way it should be
	_fFocusSet = _fSession->GetArbitrator(ev)->CreateFocusSet(ev);
#else
	// The way it has to be until Richard implements the above:
	_fFocusSet = new ODFocusSet; _fFocusSet->InitFocusSet(ev);
#endif
	_fFocusSet->Add(ev, _fSelectionFocus);
	_fFocusSet->Add(ev, _fMenuFocus);
	_fFocusSet->Add(ev, _fKeyFocus);

#ifdef OSA_SUPPORT	
	_fSemtIntf = new ODSemanticInterface;
	SIHelper* semItfcHelper = new SIHelper;
	semItfcHelper->InitSIHelper(_fSemtIntf);
	_fSemtIntf->InitSemanticInterface(ev, _fPartWrapper, semItfcHelper, _fSession);

	somSelf->InstallObjectAccessors(ev);
#endif	
}

#ifdef PLATFORM_MACINTOSH
SOM_Scope void  SOMLINK AppleTestDraw_DrawPartLoadIcons(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","LoadIcons");

	ODSLong		savedRefNum;
	BeginUsingLibraryResources(savedRefNum);

	Handle largesuite;
	OSErr osr = NewIconSuite(&largesuite);
	THROW_IF_ERROR(osr,"Error creating icon suite");
	
	Handle icon = GetResource('icl8',90);
	THROW_IF_ERROR(ResError(),"Trouble loading icons (icl8)");
	DetachResource(icon);
	osr = AddIconToSuite(icon,largesuite,'icl8');
	
	icon = GetResource('icl4',90);
	THROW_IF_ERROR(ResError(),"Trouble loading icons (icl4)");
	DetachResource(icon);
	osr = AddIconToSuite(icon,largesuite,'icl4');
	
	icon = GetResource('ICN#',90);
	THROW_IF_ERROR(ResError(),"Trouble loading icons (ICN#)");
	DetachResource(icon);
	osr = AddIconToSuite(icon,largesuite,'ICN#');

	if (largesuite) _fLargeIcons = largesuite;

	Handle smallsuite;
	osr = NewIconSuite(&smallsuite);
	THROW_IF_ERROR(osr,"Error creating icon suite");
	
	icon = GetResource('ics8',90);
	THROW_IF_ERROR(ResError(),"Trouble loading icons (ics8)");
	DetachResource(icon);
	osr = AddIconToSuite(icon,smallsuite,'ics8');
	
	icon = GetResource('ics4',90);
	THROW_IF_ERROR(ResError(),"Trouble loading icons (ics4)");
	DetachResource(icon);
	osr = AddIconToSuite(icon,smallsuite,'ics4');
	
	icon = GetResource('ics#',90);
	THROW_IF_ERROR(ResError(),"Trouble loading icons (ics#)");
	DetachResource(icon);
	osr = AddIconToSuite(icon,smallsuite,'ics#');

	if (smallsuite) _fSmallIcons = smallsuite;
	
	EndUsingLibraryResources(savedRefNum);
}
#endif

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartRelease(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","Release");

	Proxy*		p;
	ODFrame*	frame;
	
	AppleTestDraw_DrawPart_parent_ODPart_Release(somSelf, ev);
	if (somSelf->GetRefCount(ev) == 0) {
		somSelf->HidePalette(ev);
		frame = (ODFrame*) _fDisplayFrames->First();
		while (frame != kODNULL) {
			_fDisplayFrames->Remove(frame);
			ODReleaseObject(ev,frame);
			frame = (ODFrame*) _fDisplayFrames->First();
		}
		frame = (ODFrame*) _fEmbeddedFrames->First();
		while (frame != kODNULL) {
			p = somSelf->ProxyForFrame(ev, frame);
			_fContents->Remove(p);
			_fEmbeddedFrames->Remove(frame);
			ODReleaseObject(ev,frame);
			frame = (ODFrame*) _fEmbeddedFrames->First();
		}
		somSelf->GetStorageUnit(ev)->GetDraft(ev)->ReleasePart(ev, _fPartWrapper);
	}
}

#ifdef LATER
SOM_Scope void  SOMLINK AppleTestDraw_DrawPartInstallObjectAccessors(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","InstallObjectAccessors");

	ODObjectAccessorUPP theAccessorUPP ;

	theAccessorUPP = NewODObjectAccessorProc( GetPropertyFromNULL ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallObjectAccessor(cProperty, typeNull, theAccessorUPP,
										(ODSLong)_fSession);

	theAccessorUPP = NewODObjectAccessorProc( GetPartFromNULL ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallObjectAccessor(cPart, typeNull, theAccessorUPP,
										(ODSLong)_fSession);

	theAccessorUPP = NewODObjectAccessorProc( GetPropertyFromPart ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallObjectAccessor(cProperty, cPart, theAccessorUPP,
										(ODSLong)_fSession);

	theAccessorUPP = NewODObjectAccessorProc( GetWildcardFromPart ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallObjectAccessor(typeWildCard, cPart, theAccessorUPP,
										(ODSLong)_fSession);

	theAccessorUPP = NewODObjectAccessorProc( GetWildcardFromList ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallObjectAccessor(typeWildCard, typeAEList,
										theAccessorUPP, (ODSLong)_fSession);


	ODEventHandlerUPP theEventHandlerUPP ;

	theEventHandlerUPP = NewODEventHandlerProc( HandleSetData ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallEventHandler(kAECoreSuite, kAESetData,
												theEventHandlerUPP,
												(ODSLong)_fSession,
												kODStandardDispatch);

	theEventHandlerUPP = NewODEventHandlerProc( HandleGetData ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallEventHandler(kAECoreSuite, kAEGetData,
												theEventHandlerUPP,
												(ODSLong)_fSession,
												kODStandardDispatch);

	theEventHandlerUPP = NewODEventHandlerProc( HandleCreate ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallEventHandler(kAECoreSuite, kAECreateElement,
												theEventHandlerUPP,
												(ODSLong)_fSession,
												kODStandardDispatch);

	theEventHandlerUPP = NewODEventHandlerProc( HandleMove ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallEventHandler(kAECoreSuite, kAEMove, theEventHandlerUPP,
												(ODSLong)_fSession,
												kODStandardDispatch);

	ODCoercionHandlerUPP coercionHndUPP =
			NewODDescCoercionHandlerProc( CoerceList2RGB ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallCoercionHandler(typeAEList, cRGBColor,
			coercionHndUPP, (ODSLong)kODNULL, kODTrue);


	ODCompareUPP compUPP = NewODCompareProc( DrawCompare ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallCompareProc(compUPP, (ODSLong)_fSession);

	ODCountUPP countUPP = NewODCountProc( DrawCount ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallCountProc(countUPP, (ODSLong)_fSession);

	ODDisposeTokenUPP disposeTokenUPP
			= NewODDisposeTokenProc( DrawDisposeToken ) ;
	((SIHelper*)_fSemtIntf->GetSIHelper(ev))->InstallDisposeTokenProc( disposeTokenUPP, (ODSLong)_fSession);

//	fSemtIntf->InstallObjectAccessor(cPart, cFrame, GetPartFromFrame,
//										(ODSLong)fSession);
// 	fSemtIntf->InstallObjectAccessor(cProperty, cFrame, GetPropertyFromFrame,
//										(ODSLong)fSession);
// 	fSemtIntf->InstallObjectAccessor(cFrame, typeNull, GetFrameFromNULL,
//										(ODSLong)fSession);
}
#endif

//------------------------------------------------------------------------------
// AppleTestDraw_DrawPartGetEmbeddedFrames
//------------------------------------------------------------------------------

SOM_Scope OrderedCollection*  SOMLINK AppleTestDraw_DrawPartGetEmbeddedFrames(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetEmbeddedFrames");

	return _fEmbeddedFrames;
}

//------------------------------------------------------------------------------
// AppleTestDraw_DrawPartGetDisplayFrames
//------------------------------------------------------------------------------

SOM_Scope OrderedCollection*  SOMLINK AppleTestDraw_DrawPartGetDisplayFrames(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetDisplayFrames");

	return _fDisplayFrames;
}

SOM_Scope Proxy*  SOMLINK AppleTestDraw_DrawPartProxyForFrameID(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODID frameID)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ProxyForFrameID");

	ODFrame* frame = somSelf->GetStorageUnit(ev)->GetDraft(ev)->GetFrame(ev, frameID);
	Proxy* p = somSelf->ProxyForFrame(ev, frame);
	frame->Release(ev);
	return p;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartHighlightSelection(AppleTestDraw_DrawPart *somSelf, Environment *ev,
	ODPlatformCanvas hdc)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HighlightSelection");

	switch (_fSelection->Count())
	{
		case 0:		// no selection
			break;

		case 1:		// single selection
			{	OrderedCollectionIterator i(_fSelection);
				somSelf->HighlightProxyBorder(ev, hdc, (Proxy*) i.First());
			};
			break;

		default:	// multiple selection
			{	Proxy* p;
				OrderedCollectionIterator i(_fSelection);
				for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
				{	if (_fSelection->Contains(p))
						somSelf->HighlightContentObject(ev, hdc, p);
				}
			}
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartHighlightProxyBorder(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODPlatformCanvas hdc,
		Proxy* p)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HighlightProxyBorder");

	ODUnused(p);

	HBRUSH hGray = GetStockObject (GRAY_BRUSH);
	HBRUSH hBlack = GetStockObject (BLACK_BRUSH);

	FillRgn(hdc, _fSelectRgn, hGray);
	FillRgn(hdc, _fCornerHandleRgn, hBlack);
	FillRgn(hdc, _fEdgeHandleRgn, hBlack);
	
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartHighlightContentObject(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODPlatformCanvas hdc,
		Proxy* p)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HighlightContentObject");

	ODUnused(p);
	ODUnused(hdc);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartClipEmbeddedFacets(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ClipEmbeddedFacets");

/*
	ODShape* clipShape = facet->GetClipShape(ev, kODNULL);
	ODShape* workingClip = clipShape->Copy(ev);
	clipShape->Release(ev);
*/

	ODShape* shape;
	if ( facet->GetFrame(ev)->IsRoot(ev) )
		shape = facet->GetFrame(ev)->GetFrameShape(ev, kODNULL);
	else
		shape = facet->GetClipShape(ev, kODNULL);
		
	ODShape* workingClip = shape->Copy(ev);
	shape->Release(ev);

	// let selection obscure embedded parts

	ODRgnHandle tempRgn;
	ODShape* tempShape = workingClip->NewShape(ev);
	
	if (_fSelectRgn && !EmptyRgn(_fSelectRgn))
	{
		tempRgn = ODNewRgn();
		CombineRgn (tempRgn, _fSelectRgn, _fSelectRgn, RGN_COPY);
		tempShape->SetPlatformShape(ev, kODWindows, tempRgn);
		workingClip->Subtract(ev, tempShape);
	}

	if (_fCornerHandleRgn && !EmptyRgn(_fCornerHandleRgn))
	{
		tempRgn = ODNewRgn();
		CombineRgn (tempRgn, _fCornerHandleRgn, _fCornerHandleRgn, RGN_COPY);
		tempShape->SetPlatformShape(ev, kODWindows, tempRgn);
		workingClip->Subtract(ev, tempShape);
	}

	if (_fEdgeHandleRgn && !EmptyRgn(_fEdgeHandleRgn))
	{
		tempRgn = ODNewRgn();
		CombineRgn (tempRgn, _fEdgeHandleRgn, _fEdgeHandleRgn, RGN_COPY);
		tempShape->SetPlatformShape(ev, kODWindows, tempRgn);
		workingClip->Subtract(ev, tempShape);
	}

	tempShape->Release(ev);

/*
	ODTransform* wfTrans = facet->GetWindowFrameTransform(ev, kODNULL);
	ODTransform* wclipTrans = wfTrans->Copy(ev);
	workingClip->Transform(ev, wclipTrans);		// now in window coordinates
	wfTrans->Release(ev);
	wclipTrans->Release(ev);
*/
	
	ODFacet* embFacet;	
	ODFacetIterator* facets = facet->CreateFacetIterator(ev, kODChildrenOnly, kODFrontToBack);
	for (embFacet = facets->First(ev);
			facets->IsNotComplete(ev);
			embFacet = facets->Next(ev))
	{
		ODShape* usedShape = embFacet->GetFrame(ev)->GetUsedShape(ev, kODNULL);
		ODShape* newClipShape = usedShape->Copy(ev);
		usedShape->Release(ev);

		ODTransform* wclipTrans = embFacet->GetExternalTransform(ev, kODNULL);

		newClipShape->Transform(ev, wclipTrans);			// now in containing frame coordinates
		newClipShape->Intersect(ev, workingClip);
		workingClip->Subtract(ev, newClipShape);
		newClipShape->InverseTransform(ev, wclipTrans);		// now in embedded frame coordinates
		
		embFacet->ChangeGeometry(ev, newClipShape, kODNULL, kODNULL);

		newClipShape->Release(ev);
		wclipTrans->Release(ev);
	}
	delete facets;
	
	// loop to clip for part content here
	
	workingClip->Release(ev);
}


SOM_Scope void  SOMLINK AppleTestDraw_DrawPartEmptySelection(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","EmptySelection");

	for(ODULong i = _fSelection->Count(); i > 0; i--)
	{
		Proxy* sp = (Proxy*) _fSelection->RemoveFirst();
		ODFrameFacetIterator* facets = sp->frame->CreateFacetIterator(ev);
		for (ODFacet* f1 = facets->First(ev); facets->IsNotComplete(ev); f1 = facets->Next(ev)) {
			if ( f1->IsSelected(ev) ) {
				f1->SetSelected(ev, kODFalse);
				f1->ChangeHighlight(ev, kODNoHighlight);
			}
		}
		delete facets;
	}
	DeleteObject(_fSelectRgn);
	_fSelectRgn = ODNewRgn();
	DeleteObject(_fCornerHandleRgn);
	_fCornerHandleRgn = ODNewRgn();
	DeleteObject(_fEdgeHandleRgn);
	_fEdgeHandleRgn = ODNewRgn();
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleMouseDown(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where,
		ODEventData* event)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HandleMouseDown");

	if (!facet->GetWindow(ev)->IsActive(ev))
		facet->GetWindow(ev)->Select(ev);
	else
		somSelf->ActivateFrame(ev, facet->GetFrame(ev));

	ODTransform *wcTrans = facet->GetWindowContentTransform(ev, kODNULL);
	Point mouse = wcTrans->InvertPoint(ev, where).AsWinPoint();
	ODReleaseObject(ev, wcTrans);

//	if (facet->GetWindow(ev) == _fPalette) {
//		
//		ODShape*	frameShape = facet->GetFrame(ev)->GetFrameShape(ev, kODNULL);
//		RgnHandle	bRgn = frameShape->GetWinRegion(ev);
//		frameShape->Release(ev);
//		Rect		bRect, rgnBBox;
//		ODUShort	height;
//		ODUShort	whichColor;
//		ODBoolean	didHitMargin;
//		
//		GetRgnBox (bRgn, &rgnBBox);
//		bRect.left = rgnBBox.left;
//		bRect.top = rgnBBox.top;
//		bRect.bottom = rgnBBox.bottom;
//		bRect.right = rgnBBox.right;
//		height = ((bRect.bottom - bRect.top) - kMargin - ((kNumColors-1) * kMargin) - kMargin) / kNumColors;
//		
//		whichColor = mouse.y / (kMargin + height);
//		didHitMargin = ((mouse.y  % (kMargin + height)) < kMargin) ||
//						(mouse.x < kMargin) ||
//						((mouse.x + kMargin) >  bRect.right);
//		
//		if (didHitMargin == kODFalse) {
//			OrderedCollectionIterator aIter(_fDisplayFrames);
//			
//			ODFrame*	displayFrame;
//			for (displayFrame = (ODFrame*) aIter.First(); aIter.IsNotComplete(); displayFrame = (ODFrame*) aIter.Next())
//			{
//				ODFrameFacetIterator*	facets = displayFrame->CreateFacetIterator(ev);
//				for (ODFacet* facet = (ODFacet*) facets->First(ev);
//						facets->IsNotComplete(ev);
//						facet = (ODFacet*) facets->Next(ev))
//				{
//					if (facet->GetWindow(ev) != _fPalette)
//					{
//						somSelf->SetBGColor1(ev, displayFrame, whichColor);
//						displayFrame->Invalidate(ev, kODNULL, kODNULL);
//					}
//				}
//				delete facets;
//			}
//		}
//	}
	
	OrderedCollectionIterator i(_fSelection);
	Proxy* p = (Proxy*)i.First();

	Point qdWhere = where->AsWinPoint();
		
	if (event->message == WM_RBUTTONDOWN) {
		DrawShape*		aShape;
		ODTransform*	wcXForm = facet->GetWindowContentTransform(ev, kODNULL);
		ODPoint			anODPnt(where->x, where->y);
		anODPnt = wcXForm->InvertPoint(ev, &anODPnt);
		ODReleaseObject(ev, wcXForm);

		ODPlatformWindow	ownerWnd = facet->GetWindow(ev)->GetPlatformWindow(ev);
		Point	winPoint = qdWhere;
		ClientToScreen(ownerWnd, &winPoint);
		HMENU	aMenu = CreatePopupMenu();

		if (aShape = somSelf->PtInDrawShape(ev, &anODPnt)) {
			DrawShape*	selectedShape = somSelf->GetSelectedShape(ev);
			if (selectedShape && (selectedShape != aShape)) {
				selectedShape->SetSelected(kODFalse);
				aShape->SetSelected(kODTrue);
				selectedShape->Invalidate(ev, facet->GetFrame(ev));
				aShape->Invalidate(ev, facet->GetFrame(ev));
			} else if (!selectedShape) {
				aShape->SetSelected(kODTrue);
				aShape->Invalidate(ev, facet->GetFrame(ev));
			}
			AppendMenu(aMenu, MF_ENABLED | MF_STRING, IDM_CHOOSEFILLCOLOR, "Choose Selected Shape Fill Color...");	
		} else {
			DrawShape*	selectedShape = somSelf->GetSelectedShape(ev);
			if (selectedShape) {
				selectedShape->SetSelected(kODFalse);
				selectedShape->Invalidate(ev, facet->GetFrame(ev));
			}
			AppendMenu(aMenu, MF_ENABLED | MF_STRING, IDM_CHOOSEFILLCOLOR, "Choose Default Shape Fill Color...");	
		}

		TrackPopupMenu(aMenu, 0, winPoint.x, winPoint.y, 0, ownerWnd, kODNULL);
		DestroyMenu(aMenu);
		return kODTrue;
	}
	
	if (PtInRegion(_fCornerHandleRgn, mouse.x, mouse.y))
		return somSelf->HandleMouseDownCornerResize(ev, facet, p, &mouse);
	else if (PtInRegion(_fEdgeHandleRgn, mouse.x, mouse.y))
		return somSelf->HandleMouseDownEdgeResize(ev, facet, p, &mouse);
	else if (PtInRegion(_fSelectRgn, mouse.x, mouse.y))
		return somSelf->HandleMouseDownDrag(ev, facet, p, event);
	else
		switch (_fSelection->Count())
		{
			case 0:
			{
				DrawShape*		aShape;
				DrawPaletteExt*	aDrawPaletteExt = somSelf->GetDrawPaletteExt(ev);
				ODTransform*	wcXForm = facet->GetWindowContentTransform(ev, kODNULL);
				ODPoint			anODPnt(where->x, where->y);
				anODPnt = wcXForm->InvertPoint(ev, &anODPnt);
				ODReleaseObject(ev, wcXForm);

				if (aShape = somSelf->PtInDrawShape(ev, &anODPnt)) {
					DrawShape*	selectedShape = somSelf->GetSelectedShape(ev);
					if (selectedShape && (selectedShape != aShape)) {
						selectedShape->SetSelected(kODFalse);
						aShape->SetSelected(kODTrue);
						selectedShape->Invalidate(ev, facet->GetFrame(ev));
						aShape->Invalidate(ev, facet->GetFrame(ev));
					} else if (selectedShape) {
						if (selectedShape->PtInBorder(&anODPnt)) {
							if (selectedShape->PtInResizeBox(&anODPnt)) {
								selectedShape->DragResize(ev, facet, &anODPnt);
							} else {
								selectedShape->DragMove(ev, facet, &anODPnt);
							}
							selectedShape->Invalidate(ev, facet->GetFrame(ev));
						}
					} else {
						aShape->SetSelected(kODTrue);
						aShape->Invalidate(ev, facet->GetFrame(ev));
					}
				} else if (aDrawPaletteExt) {
					DrawShape*	selectedShape = somSelf->GetSelectedShape(ev);
					if (selectedShape) {
						selectedShape->SetSelected(kODFalse);
						selectedShape->Invalidate(ev, facet->GetFrame(ev));
					}

					ODULong			activeTool = somSelf->GetActiveTool(ev);
					DrawShapeType	activeToolType = (DrawShapeType)(aDrawPaletteExt->GetToolID(ev, activeTool));
					DrawShape*		aShape = new DrawShape;
					if (aShape->DragCreate(ev, facet, where, activeToolType)) {
						_fShapes->AddLast(aShape);
						aShape->Invalidate(ev, facet->GetFrame(ev));
					} else {
						delete aShape;
					}
				}
			}
				break;
		
			case 1:
				somSelf->InvalidateSelection(ev, facet->GetFrame(ev));
				somSelf->EmptySelection(ev);
				somSelf->ClipEmbeddedFrames(ev, facet->GetFrame(ev));
				break;
				
			default:
				// !!! handle multiple selection
				break;
		}

	return kODTrue;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleMouseDownDrag(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		Proxy* selection,
		ODEventData* event)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	ODBoolean handled = kODFalse;
	ODPart* destPart;
	ODShape* scratch;
	ODPoint translation (0,0);
	Point mdOffset = {0,0};
	RgnHandle dragRgn, tempRgn;
	ODDragAndDrop*	dad;
	ODStorageUnit*	unit;
	ODDropResult dropResult;
	ODTransform* wcTrans = kODNULL;

	/* Don't drag unless the user is really moving the mouse after the click..
	 */
	if (!WaitMouseMoved(facet->GetWindow(ev)->GetPlatformWindow(ev)))
		return	kODFalse;

	// Build the drag outline
	ODShape* frameShape = selection->frame->GetFrameShape(ev, kODNULL);
	scratch = frameShape->Copy(ev);
	frameShape->Release(ev); frameShape = kODNULL;
	scratch->Transform(ev, selection->transform);
	dragRgn = scratch->CopyWinRegion(ev);
	wcTrans = facet->GetWindowContentTransform(ev, kODNULL);
	Point QDtranslation = wcTrans->TransformPoint(ev, &translation).AsWinPoint();
	ODReleaseObject(ev, wcTrans);
	OffsetRgn(dragRgn, QDtranslation.x, QDtranslation.y);
	tempRgn = ODNewRgn();
	CombineRgn (tempRgn, dragRgn, dragRgn, RGN_COPY);
	tempRgn = InflateRGN (tempRgn, -1);
	CombineRgn (dragRgn, dragRgn, tempRgn, RGN_DIFF);
	DeleteObject(tempRgn);
	ODReleaseObject(ev, scratch);
	
	//  Fill DAD SU with Props n' Vals
	
	dad = _fSession->GetDragAndDrop(ev);
	dad->Clear(ev);
	unit = dad->GetContentStorageUnit(ev);

#ifdef PLATFORM_WINDOWS
	// HACK HACK HACK....
	char partType[255];
	ODUShort length;
	ODStorageUnit *ssu = selection->frame->GetPart(ev)->GetStorageUnit(ev);
	ssu->Focus(ev, kODPropPart, kODPosUndefined, kODISOStr, 0, kODPosUndefined);
	length = (ODUShort) ssu->GetSize(ev);
	ssu->GetValue(ev, length, (ODValue)partType);

	unit->AddProperty(ev,kODPropPart)->AddValue(ev,kODISOStr);
	unit->SetValue(ev, length, (ODValue)partType);
#endif

	//  if dragging one frame, create the content frame property
	// This property cannot be promised, and must be written after the embedded part
	unit->AddProperty(ev, kODPropContentFrame)->AddValue(ev, kODStrongStorageUnitRef);

	//  if dragging one frame, clone the embedded part into the root storage unit
	// if the embedded part is savy, it will notice the kODPropContentFrame property
	// and promise its content
	ODDraft* fromDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
	ODDraft* toDraft = unit->GetDraft(ev);
	ODDraftKey key = 0;
	ODID toRootID = 0;
	ODID toFrameID = 0;
	TRY
		key = fromDraft->BeginClone(ev, toDraft, kODCloneCopy);	// May use cut or copy
		// Clone the embedded part to the root storage unit of the drag and drop container
		toRootID = fromDraft->Clone(ev, key, selection->frame->GetPart(ev)->GetID(ev), unit->GetID(ev), selection->frame->GetID(ev));
		// Clone the embedded frame to any storage unit; must be done after cloning the part because
		// the embedded frame strongly references the part.
		toFrameID = fromDraft->Clone(ev, key, selection->frame->GetID(ev), 0, selection->frame->GetID(ev));
		fromDraft->EndClone(ev, key);
	CATCH_ALL
//bt		WARN("Draw: Clone to drag-and-drop container failed");
		if (key != 0)
			fromDraft->AbortClone(ev, key);
		RERAISE;
	ENDTRY

	if ( toFrameID )
	{
		// Weakly reference the frame so it must be explicitly cloned into the receiving draft
		unit->Focus(ev, kODPropContentFrame, kODPosUndefined, kODWeakStorageUnitRef, 0, kODPosUndefined);
		ODStorageUnitRef aSURef = unit->GetWeakStorageUnitRef(ev, toFrameID);
		unit->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
	}

	//  (optional) save offset between mousedown pt and topLeft pt of selection
	
	ODFrameFacetIterator* faceti = selection->frame->CreateFacetIterator(ev);
	wcTrans = faceti->First(ev)->GetWindowContentTransform(ev, kODNULL);
	Point topLeft = wcTrans->GetWinOffset(ev);
	LONG2POINT(event->lParam, mdOffset);		  // device units

	//bt convert from device units to logical (frame) units
	ODPoint	frameTopLeft(0,0);
	wcTrans->GetOffset(ev, &frameTopLeft);
	frameTopLeft = wcTrans->InvertPoint(ev, &frameTopLeft);
	ODPoint deltaLog = mdOffset;
	deltaLog = wcTrans->InvertPoint(ev, &deltaLog);
	deltaLog.x -= frameTopLeft.x;					  // delta from top left of frame
	deltaLog.y -= frameTopLeft.y;

	mdOffset = deltaLog.AsWinPoint();

	ODReleaseObject(ev, wcTrans);
	
	unit->AddProperty(ev, kPropMouseDownOffset);
	unit->SetPromiseValue(ev, kWinPoint, 0, sizeof(Point), (ODValue) &mdOffset, somSelf);

	//  (optional) if dragging one frame, save its external transform (not aggregate)
	unit->AddProperty(ev, kODPropExternalTransform)->AddValue(ev, kWinPoint);
	unit->SetValue(ev, sizeof(Point), (ODValue) &topLeft);

	//  if dragging one frame, write its shape   [jpa]
	unit->AddProperty(ev, kODPropFrameShape);
	ODShape* tempShape = selection->frame->GetFrameShape(ev, kODNULL);
	tempShape->WriteShape(ev, unit);
	ODReleaseObject(ev, tempShape);

	// Write out the dragged frame's ID in case it is dropped back to this part.
	unit->AddProperty(ev, kPropFrameInfo);
	unit->SetPromiseValue(ev, kODFrameRef, 0, sizeof(Proxy*), &selection, somSelf);
	
	dadSelection = selection;
	
	selection->frame->SetDragging(ev, kODTrue);
	
	dropResult = dad->StartDrag(ev, facet->GetFrame(ev), "RGNH",
			(ODPtr)(&dragRgn), &destPart, event);
	
	dadSelection = kODNULL;
	
	if ( (dropResult == kODDropCopy) || (dropResult == kODDropMove) )
	{
		if (destPart == _fPartWrapper)
		{
			// The frame was dropped within the same part
			if (dropResult == kODDropMove)
				facet->GetFrame(ev)->Invalidate(ev, kODNULL, kODNULL);
			selection->frame->SetDragging(ev, kODFalse);				
		}
		else if (dropResult == kODDropMove)
		{
#ifdef ODDebug
		somPrintf("Draw %d::Drag: Cleaning up after move\n", somSelf->GetID(ev));
#endif
			// The frame was moved out
			facet->GetFrame(ev)->Invalidate(ev, kODNULL, kODNULL);
			// $$$$$ Doesn't invalidating the containing frame make the next line unnecessary
			somSelf->InvalidateSelection(ev, selection->frame);	// $$$$$ The frame has been moved elsewhere
			somSelf->EmptySelection(ev);
			
			OrderedCollection* tempFacets = new OrderedCollection;
			
#ifdef ODDebug
		somPrintf("Draw %d::Drag: Deleting old facets\n", somSelf->GetID(ev));
#endif
			// Get all facets displaying the moved frame
			// Necessary because they can't be deleted during iteration
			// We can't use the frame's facet iterator because the destination
			// of the move will have changed the frame's containing frame,
			// which eliminates all facets.
			ODFacetIterator* facets = facet->CreateFacetIterator(ev, kODChildrenOnly, kODFrontToBack);
			for (ODFacet* f1 = facets->First(ev);
					facets->IsNotComplete(ev);
					f1 = facets->Next(ev))
			{
				if ( f1->GetFrame(ev) == selection->frame )
					tempFacets->AddLast(f1);
			}
			delete facets;
			
			// Now delete all facets displaying the moved frame
			OrderedCollectionIterator t(tempFacets);
			for (ODFacet* f2 = (ODFacet*)t.First();
					t.IsNotComplete();
					f2 = (ODFacet*)t.Next())
			{
#ifdef ODDebug
				somPrintf("Draw:: Deleting facet displaying moved frame\n");
#endif
				f2->GetContainingFacet(ev)->RemoveFacet(ev, f2);
				ODDeleteObject(f2);
			}
			delete tempFacets;

			ODFrame* movedFrame = selection->frame;

#ifdef ODDebug
		somPrintf("Draw %d::Drag: Deleting old proxy\n", somSelf->GetID(ev));
#endif
			// Remove our proxy for the moved frame
//bt should call ->	somSelf->DeleteFrameProxy(ev, selection); 		(after we install the method)
			if ( _fEmbeddedFrames->Contains(selection->frame) )
				_fEmbeddedFrames->Remove(selection->frame);
 			_fContents->Remove(selection);
			selection->transform->Release(ev); selection->transform = kODNULL;
			DeleteObject(selection->region);
			delete selection;


			// If the frame was moved within the same draft, release it,
			// otherwise remove it.
			ODDraft* thisDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
			if ( (destPart == kODNULL) || (destPart->GetStorageUnit(ev)->GetDraft(ev) != thisDraft) )
				movedFrame->Remove(ev);
			else
				movedFrame->Release(ev);
			movedFrame = kODNULL;
			
#ifdef ODDebug
		somPrintf("Draw %d::Drag: Resetting cliping\n", somSelf->GetID(ev));
#endif
			// Reset clipping of the remaining embedded facets
			somSelf->ClipEmbeddedFrames(ev, facet->GetFrame(ev));

			somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
		}
		else
		{
			// The frame was copied
			selection->frame->SetDragging(ev, kODFalse);
		}
		
		handled = kODTrue;
	}
	else
	{
		selection->frame->SetDragging(ev, kODFalse);
	}

	DeleteObject(dragRgn);

	return handled;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleMouseDownEdgeResize(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		Proxy* selection,
		Point* mouse)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	enum edge {kNone, kTE, kLE, kBE, kRE};
	edge growEdge = kNone;

	HDC		hdc;
	HWND	hwnd;

	CFocusWindow f(facet, NULL, &hdc, &hwnd);

	Rect* sr = somSelf->GetSelectionRectLocal(ev, selection);

	if		(mouse->y <= (sr->top + (0.1 * sr->top))) growEdge = kTE;
	else if (mouse->x <= (sr->left + (0.1 * sr->left))) growEdge = kLE;
	else if (mouse->y >= (sr->bottom - (0.1 * sr->bottom))) growEdge = kBE;
	else if (mouse->x >= (sr->right -  (0.1 * sr->right))) growEdge = kRE;

	Rect growBox = (*sr);
	Rect oldBox = {0,0,0,0};
	
	SetROP2(hdc, R2_NOT);
	SetBkMode (hdc, TRANSPARENT);
	HBRUSH hbrsh = GetStockObject(BLACK_BRUSH);
	
	Point theLoc = {0,0};
	Point lastLoc = {0,0};
	GetCursorPos (&lastLoc);
	ScreenToClient (hwnd, &lastLoc);
	DPtoLP(hdc,	&lastLoc,	1);			// convert to Logical Units (OD Coordinates)
	Point origPt = lastLoc;
	MSG msg;

	SetCapture(hwnd);
	int inDrag = kODTrue;
	while (inDrag)
	{
		GetMessage(&msg, hwnd, WM_MOUSEFIRST, WM_MOUSELAST);
#ifndef WIN32
		theLoc = MAKEPOINT(msg.lParam);
#else
		LONG2POINT(msg.lParam, theLoc);
#endif
				DPtoLP(hdc,	&theLoc,	1);		// convert to Logical Units (OD Coordinates)
		switch(msg.message)
		{
			case WM_MOUSEMOVE:
				break;

			case WM_LBUTTONUP:
				inDrag = kODFalse;
				break;
		}

		if ((theLoc.x != lastLoc.x) || (theLoc.y != lastLoc.y))
		{
			switch (growEdge)
			{
				case kTE:
					growBox.top -= (lastLoc.y - theLoc.y);
					break;

				case kLE:
					growBox.left -= (lastLoc.x - theLoc.x);
					break;

				case kBE:
					growBox.bottom -= (lastLoc.y - theLoc.y);
					break;

				case kRE:
					growBox.right -= (lastLoc.x - theLoc.x);
					break;

				default:
					break;
			}

			DrawFocusRect (hdc, &oldBox);
			DrawFocusRect (hdc, &growBox);
		}

		lastLoc = theLoc;
		oldBox = growBox;
	}
	ReleaseCapture();

	DrawFocusRect (hdc, &oldBox);
	
	Point delta;
	delta.x = theLoc.x - origPt.x;
	delta.y = theLoc.y - origPt.y;
	Point transOffset = { 0, 0 };

	ODShape* oldShape = selection->frame->GetFrameShape(ev, kODNULL);
	ODRect newBounds;
	oldShape->GetBoundingBox(ev, &newBounds);

	switch (growEdge)
	{
		case kTE:
			newBounds.bottom -= ff(delta.y);
			transOffset.y += delta.y;
			break;

		case kLE:
			newBounds.right -= ff(delta.x);
			transOffset.x += delta.x;
			break;

		case kBE:
			newBounds.bottom += ff(delta.y);
			break;

		case kRE:
			newBounds.right += ff(delta.x);
			break;

		default:
			break;
	}
	
	ODShape* newShape = oldShape->NewShape(ev);
	newShape->SetRectangle(ev, &newBounds);
	
	somSelf->InvalEmbedFrameAfterResize(ev, facet, selection, oldShape, newShape, &transOffset);
	oldShape->Release(ev); oldShape = kODNULL;
	newShape->Release(ev); newShape = kODNULL;
	
	return kODTrue;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleMouseDownCornerResize(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		Proxy* selection,
		Point* mouse)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
//skn  Including the following line causes a compile error on the subsequent enum variable declaration.
//skn	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HandleMouseDownCornerResize");

	enum corner {kNone, kTL, kTR, kBL, kBR};
	corner growCorner = kNone;

	HDC		hdc;
	HWND	hwnd;

	CFocusWindow f(facet, NULL, &hdc, &hwnd);

	Rect* sr = somSelf->GetSelectionRectLocal(ev, selection);
	Point center = { (sr->right + sr->left) / 2, (sr->bottom + sr->top) / 2};		// center of FrameShape
	
	if		((mouse->y <= center.y) && (mouse->x <= center.x)) growCorner = kTL;
	else if ((mouse->y <  center.y) && (mouse->x >  center.x)) growCorner = kTR;
	else if ((mouse->y >  center.y) && (mouse->x <  center.x)) growCorner = kBL;
	else if ((mouse->y >  center.y) && (mouse->x >  center.x)) growCorner = kBR;
		
	Rect growBox = (*sr);
	Rect oldBox = {0,0,0,0};
	
	SetROP2(hdc, R2_NOT);
	SetBkMode (hdc, TRANSPARENT);
	HBRUSH hbrsh = GetStockObject(BLACK_BRUSH);

	Point theLoc = {0,0};
	Point lastLoc = {0,0};
	GetCursorPos (&lastLoc);
	ScreenToClient (hwnd, &lastLoc);
	DPtoLP(hdc,	&lastLoc,	1);			// convert to Logical Units (OD Coordinates)
	Point origPt = lastLoc;
	MSG msg;
	
	SetCapture(hwnd);
	int inDrag = kODTrue;
	while (inDrag)
	{
		GetMessage(&msg, hwnd, WM_MOUSEFIRST, WM_MOUSELAST);
#ifndef WIN32
		theLoc = MAKEPOINT(msg.lParam);
#else
		LONG2POINT(msg.lParam, theLoc);
#endif
				DPtoLP(hdc,	&theLoc,	1);			// convert to Logical Units (OD Coordinates)
		switch(msg.message)
		{
			case WM_MOUSEMOVE:
				break;

			case WM_LBUTTONUP:
				inDrag = kODFalse;
				break;
		}

		if ((theLoc.x != lastLoc.x) || (theLoc.y != lastLoc.y))
		{
			switch (growCorner)
			{
				case kTL:
					growBox.top -= (lastLoc.y - theLoc.y);
					growBox.left -= (lastLoc.x - theLoc.x);
					break;

				case kTR:
					growBox.top -= (lastLoc.y - theLoc.y);
					growBox.right -= (lastLoc.x - theLoc.x);
					break;

				case kBL:
					growBox.left -= (lastLoc.x - theLoc.x);
					growBox.bottom -= (lastLoc.y - theLoc.y);
					break;

				case kBR:
					growBox.bottom -= (lastLoc.y - theLoc.y);
					growBox.right -= (lastLoc.x - theLoc.x);
					break;

				default:
					break;
			}

			DrawFocusRect (hdc, &oldBox);
			DrawFocusRect (hdc, &growBox);
		}

		lastLoc = theLoc;
		oldBox = growBox;
	}
	ReleaseCapture();

	DrawFocusRect (hdc, &oldBox);

	Point delta;
	delta.x = theLoc.x - origPt.x;
	delta.y = theLoc.y - origPt.y;
	Point transOffset = { 0, 0 };

	ODShape* oldShape = selection->frame->GetFrameShape(ev, kODNULL);
	ODRect newBounds;
	oldShape->GetBoundingBox(ev, &newBounds);
	ODPoint fixDelta = delta;

	switch (growCorner)
	{
		case kTL:
			newBounds.bottom -= fixDelta.y; newBounds.right -= fixDelta.x;
			transOffset.y += delta.y; transOffset.x += delta.x;
			break;

		case kTR:
			newBounds.bottom -= fixDelta.y; newBounds.right += fixDelta.x;
			transOffset.y += delta.y;
			break;

		case kBL:
			newBounds.bottom += fixDelta.y; newBounds.right -= fixDelta.x;
			transOffset.x += delta.x;
			break;

		case kBR:
			newBounds.bottom += fixDelta.y;
			newBounds.right += fixDelta.x;
			break;

		default:
			break;
	}

	ODShape* newShape = oldShape->NewShape(ev);
	newShape->SetRectangle(ev, &newBounds);

	somSelf->InvalEmbedFrameAfterResize(ev, facet, selection, oldShape, newShape, &transOffset);
	oldShape->Release(ev); oldShape = kODNULL;
	newShape->Release(ev); newShape = kODNULL;
	
	return kODTrue;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleMouseDownInEmbeddedFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* container,
		ODFacet* facet,
		ODPoint* where,
		ODEventData* event)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HandleMouseDownInEmbeddedFrame");

	ODUnused(where);
	ODUnused(event);

	somSelf->ActivateFrame(ev, container->GetFrame(ev));

	Proxy* p = somSelf->ProxyForFrame(ev, facet->GetFrame(ev));

	switch (_fSelection->Count())
	{
		case 0:
			_fSelection->AddFirst((ElementType)p);
			somSelf->CreateProxySelectionBorder(ev, p);
			somSelf->ClipEmbeddedFrames(ev, container->GetFrame(ev));
			somSelf->InvalidateSelection(ev, container->GetFrame(ev));
			break;

		case 1:
				
			//dkf: I added the following line to fix the problem of deselecting
			//     a frame when a second (frozen) frame gets selected
			somSelf->InvalidateSelection(ev, container->GetFrame(ev));
			_fSelection->RemoveFirst();
			_fSelection->AddFirst((ElementType)p);
			somSelf->CreateProxySelectionBorder(ev, p);
			somSelf->ClipEmbeddedFrames(ev, container->GetFrame(ev));
			somSelf->InvalidateSelection(ev, container->GetFrame(ev));
			break;
			
		default:
			// !!! handle multiple selection
			break;
	}

	somSelf->InvalidateSelection(ev, container->GetFrame(ev));
	//return somSelf->HandleMouseDownDrag(ev, container, p, event);

	return kODTrue;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleKeyDown(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* focusFrame,
		ODEventData* event)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HandleKeyDown");

	ODUnused(focusFrame);
	ODUnused(event);
	// cursor keys? !!!

	return kODFalse;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleMenuEvent(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* focusFrame,
		ODEventData* event)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HandleMenuEvent");

//skn	ASSERTM(_fMenuBar != kODNULL, 0, "Menubar is NULL");
	
	long menuResult = event->message;
	ODBoolean handled = kODFalse;
	
//TAG - Process any menu ID that results from the part registry.  They begin with IDM_DRAW
// and work their way up from there.  IDM_DRAW is processed in the default switch below...

	if ((event->wParam >= _firstPartToken) && (event->wParam <= _lastPartToken))
	{
		somSelf->InvalidateSelection(ev, focusFrame);
		somSelf->EmptySelection(ev);
		somSelf->ClipEmbeddedFrames(ev, focusFrame);
		somSelf->Embed(ev, event->wParam, focusFrame, kODNULL);
		return kODTrue;
	}

	// Until such time as we clean this up and register all commands:
	switch (event->wParam)
	{
		case kODCommandPageSetup:
			handled = somSelf->HandlePageSetup(ev, focusFrame);
			break;
		case kODCommandPrint:
			handled = somSelf->HandlePrinting(ev, focusFrame);
			break;
		
		case kODCommandCut:
			handled = somSelf->DoCut(ev, focusFrame); break;
		case kODCommandCopy:
			handled = somSelf->DoCopy(ev, focusFrame); break;
		case kODCommandPaste:
			handled = somSelf->DoPaste(ev, focusFrame); break;
		case kODCommandPasteAs:
			handled = somSelf->DoPasteLink(ev, focusFrame); break;
		case kODCommandClear:
			handled = somSelf->DoClear(ev, focusFrame); break;
		case kODCommandSelectAll:
			handled = somSelf->DoSelectAll(ev, focusFrame); break;
		
		case kODCommandOpen :
			{
				Proxy* p;
				OrderedCollectionIterator i(_fSelection);
				for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
				{	
					ODFrame* frame = p->frame;
					ODPart* part
							= frame ? frame->GetPart(ev) : (ODPart*)kODNULL;
					if (part)
						part->Open(ev, frame);
					handled = kODTrue;
				}
			}
			break;
			
		case IDM_DRAW:
			somSelf->Embed(ev, event->wParam, focusFrame, kODNULL);
			handled = kODTrue;
			break;

		case IDM_GRAY:
		case IDM_RED:
		case IDM_GREEN:
		case IDM_YELLOW:
		case IDM_BLUE:
		case IDM_MAGENTA:
		case IDM_CYAN:
		case IDM_WHITE:
		case IDM_OTHER:
			somSelf->SetBGColor1(ev, focusFrame, event->wParam);
			focusFrame->Invalidate(ev, kODNULL, kODNULL);
			handled = kODTrue;
			break;

		case IDM_CHOOSEFILLCOLOR:
		{
			ODFrameFacetIterator* facets = focusFrame->CreateFacetIterator(ev);
 			ODFacet*	facet = facets->First(ev);
			static DWORD	custColors[16];
			CHOOSECOLOR	cc;
			cc.lStructSize = sizeof(CHOOSECOLOR);
			cc.hwndOwner = facet->GetWindow(ev)->GetPlatformWindow(ev);
			cc.hInstance = gDrawPartDllInstance;
			cc.rgbResult = RGB(0x80, 0x80, 0x80);
			cc.lpCustColors = custColors;
			cc.Flags = CC_RGBINIT | CC_FULLOPEN;
			cc.lCustData = 0L;
			cc.lpfnHook = kODNULL;
			cc.lpTemplateName = kODNULL;
			if (ChooseColor(&cc)) {
				DrawShape*	selectedShape = somSelf->GetSelectedShape(ev);
				if (selectedShape) {
					if (selectedShape->GetType() == kRectShape) {
						selectedShape->SetType(kRectFillShape);	
					}
					if (selectedShape->GetType() == kRoundRectShape) {
						selectedShape->SetType(kRoundRectFillShape);	
					}
					if (selectedShape->GetType() == kEllipseShape) {
						selectedShape->SetType(kEllipseFillShape);	
					}
					selectedShape->SetFillColor((COLORREF)cc.rgbResult);
					selectedShape->Invalidate(ev, focusFrame);
				} else {
					DrawShape::fDefaultFillColor = (COLORREF)cc.rgbResult;
				}
			}
		}
			break;

		case kODCommandViewAsWin :
			somSelf->Open(ev, focusFrame);
			handled = kODTrue;
			break;
			
		case kODCommandGetPartInfo :
			{
				Proxy* p;
				OrderedCollectionIterator i(_fSelection);
				p = (Proxy*) i.First();

				ODFrame* theFrame = p==kODNULL?focusFrame:p->frame;
				ODFrameFacetIterator* facets =
						theFrame->CreateFacetIterator(ev);
				ODInfo* info = _fSession->GetInfo(ev);
				info->ShowPartFrameInfo( ev, facets->First(ev));
				handled = kODTrue;
			}
			break;

		case IDM_FREEZE:
		{
			Proxy* p;
			OrderedCollectionIterator i(_fSelection);
			for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
			{
				p->frame->SetFrozen(ev, kODTrue);
			}
		  break;
		}

		case IDM_DEFROST:
		{
			Proxy* p;
			OrderedCollectionIterator i(_fSelection);
			for (p = (Proxy*) i.First(); i.IsNotComplete(); p = (Proxy*) i.Next())
			{
				p->frame->SetFrozen(ev, kODFalse);
			}
		  break;
		}

		case IDM_SHOWPALETTE:
			if (_fPalette == kODNULL) {
				somSelf->CreatePalette(ev);
			}

			somSelf->ShowPalette(ev);
			_fPaletteWasShown = kODTrue;
		  break;

		case IDM_HIDEPALETTE:
			somSelf->HidePalette(ev);
			_fPaletteWasShown = kODFalse;
		  break;

		default:
			break;
	}
			
	return handled;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandlePageSetup(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* focusFrame)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	ODUnused(focusFrame);

	if (_fPrinter == kODNULL)
	{
		ODFacet *rootFacet;

		ODFrameFacetIterator* fIter = focusFrame->CreateFacetIterator(ev);
		rootFacet = fIter->First(ev);
		delete fIter;

		_fPrinter = new CPrint(rootFacet);
	}

	return _fPrinter->HandlePageSetup();
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandlePrinting(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* focusFrame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	int		realNumberOfPagesinDoc, numberOfCopies;
	int		pageNumber, firstPage, lastPage, copies;
	ODFacet *rootFacet;

	ODFrameFacetIterator* fIter = focusFrame->CreateFacetIterator(ev);
	rootFacet = fIter->First(ev);
	delete fIter;

	if (_fPrinter == kODNULL)
		_fPrinter = new CPrint(rootFacet);

	LPPRINTDLG	myPrintRecPtr = _fPrinter->BeginPrinting(ev, rootFacet);

	if (myPrintRecPtr == kODFalse)
		return kODFalse;

	_fPrinter->SetDocName("PrintLib:OpenDoc");

	if (_fPrinter->StartPrintJob())
	{
		ODFacet *prFacet = _fPrinter->CreatePrinterFacet(ev, focusFrame, _fSession);
		realNumberOfPagesinDoc = DetermineNumberOfPagesinDoc(ev, focusFrame, _fPrinter->fPageSize);

		numberOfCopies = myPrintRecPtr->nCopies;

		if (myPrintRecPtr->Flags & PD_ALLPAGES) {
			firstPage = 1;
			lastPage = realNumberOfPagesinDoc;
		} else {
			firstPage = myPrintRecPtr->nFromPage;
			lastPage = myPrintRecPtr->nToPage;
		}

		if (realNumberOfPagesinDoc < lastPage)
			lastPage = realNumberOfPagesinDoc;

		for (copies = 1; copies <= numberOfCopies; copies++)
		{
			pageNumber = firstPage;
			if (pageNumber == 0)
				pageNumber = 1;

			while (pageNumber <= lastPage)
			{
				somSelf->PrintPage(ev, prFacet, pageNumber);

				if (pageNumber < lastPage)
					_fPrinter->NewPage();
				pageNumber++;
			}
		}
		_fPrinter->DeletePrinterFacet(ev);
		_fPrinter->EndPrinting();
	}else
		return kODFalse;

	return kODTrue;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartPrintPage(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* prFacet,
		ODUShort page)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	ODRect bbox;
	Rect frect;
	
	ODShape *frameShape = prFacet->GetFrame(ev)->GetFrameShape(ev, kODNULL);
	frameShape->GetBoundingBox(ev, &bbox);
	frameShape->Release(ev);
	bbox.AsWinRect(frect);
	
	ODULong height = frect.bottom;
	ODULong width  = frect.right;
	
	Point 		pt = {0,0};
	ODUShort 	locator = page-1;
	
	while (locator)
	{
		pt.y += (_fPrinter->fPageSize.bottom+1);
		locator--;

		if (PtInRect(&frect, pt))
		{
			continue;
		}
		else
		{
			pt.y = 0;
			pt.x += (_fPrinter->fPageSize.right+1);
		}
	}

	ODTransform* xtransform = prFacet->CreateTransform(ev);
	
	xtransform->SetWinOffset(ev, &pt);

	ODShape* clipshape = prFacet->CreateShape(ev);
	ODRect cliprect(_fPrinter->fPageSize);
	clipshape->SetRectangle(ev, &cliprect);
	xtransform->ScaleBy(ev, &_fPrinter->fPrintScale);
	ODShape* invalshape = clipshape->Copy(ev);
	prFacet->ChangeGeometry(ev, invalshape, xtransform, prFacet->GetCanvas(ev));
	clipshape->Release(ev); clipshape = kODNULL;
	xtransform->Release(ev); xtransform = kODNULL;

	prFacet->Invalidate(ev, invalshape, kODNULL);
	prFacet->Update(ev, invalshape, kODNULL);
}

ODUShort DetermineNumberOfPagesinDoc(Environment* ev, ODFrame* frame, Rect page)
{
	ODRect bbox;
	Rect frect;
	
	ODShape *frameShape = frame->GetFrameShape(ev, kODNULL);
	frameShape->GetBoundingBox(ev, &bbox);
	frameShape->Release(ev);
	bbox.AsWinRect(frect);
	
	ODSLong height = frect.bottom;
	ODSLong width  = frect.right;
	
	ODUShort pages = 0;
	
	ODSLong wt = width;
	while (wt > 0)
	{
		ODSLong ht = height;
		while (ht > 0)
		{
			ht -= page.bottom;
			pages++;
		}
		
		wt -= page.right;
	}
	
	return pages;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartDoCut(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
//	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	
	// Put the selected frame on the Clipboard
	somSelf->DoCopy(ev, frame);	
	return somSelf->DoClear(ev, frame);
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartDoCopy(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	ODArbitrator* arbitrator = _fSession->GetArbitrator(ev);
	OrderedCollectionIterator i(_fSelection);
	Proxy* pSelection = (Proxy*) i.First();
	if (pSelection && ((frame == arbitrator->GetFocusOwner(ev, _fClipboardFocus)) ||
		 (arbitrator->RequestFocus(ev, _fClipboardFocus, frame))) )
	{

		// Put the selected frame on the Clipboard

		ODClipboard *clipboard = somSelf->GetStorageUnit(ev)->GetSession(ev)->GetClipboard(ev);

		// Remove any existing data on the clipboard
		clipboard->Clear(ev);

		// Get the root storage unit for the clipboard
		ODStorageUnit *clipRootSU = clipboard->GetContentStorageUnit(ev);

#ifdef PLATFORM_WINDOWS
		// HACK HACK HACK....
		char partType[255];
		ODUShort length;
		ODStorageUnit *ssu = pSelection->frame->GetPart(ev)->GetStorageUnit(ev);
		ssu->Focus(ev, kODPropPart, kODPosUndefined, kODISOStr, 0, kODPosUndefined);
		length = (ODUShort) ssu->GetSize(ev);
		ssu->GetValue(ev, length, (ODValue)partType);

		clipRootSU->AddProperty(ev,kODPropPart)->AddValue(ev,kODISOStr);
		clipRootSU->SetValue(ev, length, (ODValue)partType);
#endif

		ODDraft *fromDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
		ODDraft *toDraft = clipRootSU->GetDraft(ev);
		ODDraftKey key = 0;
		ODID toRootID = 0;
		ODID toFrameID = 0;

		TRY
			key = fromDraft->BeginClone(ev, toDraft, kODCloneCut);

			// This property cannot be promised, and must be written after 
			// the embedded part has been cloned.
			clipRootSU->AddProperty(ev, kODPropContentFrame);
			clipRootSU->AddValue(ev, kODWeakStorageUnitRef);

			// Clone the embedded frame to any storage unit; must be done after
			// cloning the part because the embedded frame stongly references the part.

			toRootID = fromDraft->Clone(ev, key, pSelection->frame->GetPart(ev)->GetID(ev)
											, clipRootSU->GetID(ev), pSelection->frame->GetID(ev));

			toFrameID = fromDraft->Clone(ev, key, pSelection->frame->GetID(ev)
											, 0, pSelection->frame->GetID(ev));
			// Weakly feference the frame so it must be explicitly cloned
			// into  the receiving draft

			clipRootSU->Focus(ev, kODPropContentFrame, kODPosUndefined,
								kODWeakStorageUnitRef, 0, kODPosUndefined);

			ODStorageUnitRef aSURef = clipRootSU->GetWeakStorageUnitRef(ev,toFrameID); 
			clipRootSU->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);

			// if one frame, write its shape   
			clipRootSU->AddProperty(ev, kODPropFrameShape);
			ODShape* tempShape = pSelection->frame->GetFrameShape(ev, kODNULL);
			tempShape->WriteShape(ev, clipRootSU);
			ODReleaseObject(ev, tempShape);

			// (Optional) Add frameInfo 'promise content' to the clipboard

			clipRootSU->AddProperty(ev, kPropFrameInfo);
			clipRootSU->SetPromiseValue(ev, kODFrameRef, 0, sizeof(Proxy*), &pSelection, somSelf);

			// Complete the clone transaction 
			fromDraft->EndClone(ev, key);

		CATCH_ALL
			if (key != 0) 
				fromDraft->AbortClone(ev, key); 
			clipboard->Clear(ev); 
			RERAISE;
		ENDTRY
 		
 		// Update the clipboard 
		clipRootSU->Externalize(ev);
		clipboard->SetPlatformClipboard( ev, kODNULL );

		arbitrator->RelinquishFocus(ev, _fClipboardFocus, frame);

		return kODTrue;
	}else
		return kODFalse;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartDoPaste(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	ODFrame *parentFrame;

	ODArbitrator* arbitrator = _fSession->GetArbitrator(ev);
	OrderedCollectionIterator i(_fSelection);
	Proxy* pSelection = (Proxy*) i.First();
	if (!pSelection)
		parentFrame = frame;	  			// get the focus frame
	else
		parentFrame = pSelection->frame;

	if ( (frame == arbitrator->GetFocusOwner(ev, _fClipboardFocus)) ||
		 (arbitrator->RequestFocus(ev, _fClipboardFocus, frame)) )
	{
		ODClipboard* clipboard = somSelf->GetStorageUnit(ev)->GetSession(ev)->GetClipboard(ev);
		// Get the root storage unit for the clipboard 
		ODStorageUnit* clipRootSU = clipboard->GetContentStorageUnit(ev);
		ODDraft* clipDraft = clipRootSU->GetDraft(ev); 
		ODDraft* myDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev); 
		ODDraftKey key = 0;
		ODID newFrameID = 0; 
		ODID newPartID = 0;
		ODPart *newPart = kODNULL; 
		ODFrame *newFrame = kODNULL;
		ODShape *newFrameShape = kODNULL;
		ODTransform *newExternalXForm = kODNULL;
		ODBoolean foundAFrame = kODFalse;
		ODVolatile(key); 

		TRY
			// Begin a transfer from the clipboard into this draft. 
//			key = clipDraft->BeginClone(ev, myDraft, kODClonePaste);
			key = clipDraft->BeginClone(ev, myDraft, kODCloneCopy);

			// Clone the root part from the clipboard 
			// The scopeID of zero indicates the clone is not restricted to a 
			// particular frame context. 
			newPartID = clipDraft->Clone(ev, key, clipRootSU->GetID(ev), 0, 0);

			// If a content frame is present, clone it, too 
			if (clipRootSU->Exists(ev, kODPropContentFrame, kODWeakStorageUnitRef, 0)) 
			{ 
				ODStorageUnitRef aSURef;
				clipRootSU->Focus(ev, kODPropContentFrame, kODPosSame, 
									kODWeakStorageUnitRef, 0, kODPosUndefined);
				clipRootSU->GetValue(ev, sizeof(ODStorageUnitRef), &aSURef);

				if ( clipRootSU->IsValidStorageUnitRef(ev, aSURef) ) 
				{ 
					ODID clipFrameID = clipRootSU->GetIDFromStorageUnitRef(ev, aSURef); 
					newFrameID = clipDraft->Clone(ev, key, clipFrameID,	0, 0); 
					foundAFrame = kODTrue;
				}
			}
			clipDraft->EndClone(ev, key);
		CATCH_ALL
			if ( key != 0 ) 
				clipDraft->AbortClone(ev, key);
			RERAISE;
		ENDTRY

		if ( foundAFrame )
		{
			// Get the new embedded part 
			newPart = myDraft->GetPart(ev, newPartID);

			Point ptTemp;
			ptTemp.x = ptTemp.y = 20;
			newExternalXForm = parentFrame->CreateTransform(ev);
			newExternalXForm->SetWinOffset(ev, &ptTemp);
		
			if (clipRootSU->Exists(ev, kODPropFrameShape, NULL, 0))
			{
				clipRootSU->Focus(ev, kODPropFrameShape, kODPosUndefined, NULL, 1, kODPosUndefined);
				newFrameShape = parentFrame->CreateShape(ev);
				newFrameShape->ReadShape(ev, clipRootSU);
			}else
				newFrameShape = kODNULL;

			if ( newFrameID == 0 ) 
			{ 
				// Create a new embedded frame for newPart, using the frame shape 
				// on the clipboard, if present. This is part-specific. 

 				newFrame = somSelf->MakeEmbeddedFrame(ev, parentFrame,
						newFrameShape, newExternalXForm, newPart, kODFalse);
			} 
			else 
			{ 
				newFrame = myDraft->GetFrame(ev, newFrameID);
				newFrame->SetContainingFrame(ev, parentFrame); 
	//bt add method	to replace the following	somSelf->CreateFrameProxy(ev, newFrame, newExternalXForm);
				// add the frame to the collection of embedded frames
				_fEmbeddedFrames->AddFirst(newFrame);
				// calculate the frame shape's region
				ODShape* shape = newFrame->GetFrameShape(ev, kODNULL);
				ODShape* shapeCopy = shape->Copy(ev);
				shapeCopy->Transform(ev, newExternalXForm);
				RgnHandle shapeRgn = shapeCopy->CopyWinRegion(ev);
				ODReleaseObject(ev,shapeCopy);
				ODReleaseObject(ev,shape);
				// create a proxy to hold the embedded frame
				Proxy* p = new Proxy(shapeRgn, newFrame, newExternalXForm);  // new for Facets
				// put proxy into contents, possibly adjusting other content
				_fContents->AddFirst(p);
	//bt end
			}

			// Set the link status of the embedded frame 
			newFrame->ChangeLinkStatus(ev, kODNotInLink);

			ODShape* newFrameShape = newFrame->GetFrameShape(ev, kODNULL);

		  	// Add a new facet
			ODFrameFacetIterator* facets = parentFrame->CreateFacetIterator(ev);
			for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev);
					facet = facets->Next(ev))
			{
				ODShape* clipShape = newFrameShape->Copy(ev);
				ODTransform* xform = newExternalXForm->Copy(ev);
				facet->CreateEmbeddedFacet(ev, newFrame, clipShape, xform,
											kODNULL, kODNULL, kODNULL, kODFrameInFront);
				ODReleaseObject(ev,xform);
				ODReleaseObject(ev,clipShape);
			}
			delete facets;

			somSelf->ClipEmbeddedFrames(ev, parentFrame);
			parentFrame->Invalidate(ev, kODNULL, kODNULL);

			if (newFrameShape)
				ODReleaseObject(ev, newFrameShape);

			newPart->Release(ev);

			return kODTrue;
		}
	}
	return kODFalse;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartDoPasteLink(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DoPasteLink");

	ODUnused(frame);
	return kODFalse;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartDoClear(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	
	// Just Clear the selected frame and its facets

	OrderedCollectionIterator i(_fSelection);
	Proxy* pSelection = (Proxy*) i.First();
	
	if (pSelection)
	{
		pSelection->frame->Invalidate(ev, kODNULL, kODNULL);
		somSelf->InvalidateSelection(ev, frame);	
		somSelf->EmptySelection(ev);
		somSelf->ClipEmbeddedFrames(ev, frame);

		OrderedCollection* tempFacets = new OrderedCollection;

		// Get all facets displaying the moved frame
		// Necessary because they can't be deleted during iteration
		ODFrameFacetIterator* facets = pSelection->frame->CreateFacetIterator(ev);
		for (ODFacet* f1 = facets->First(ev);
				facets->IsNotComplete(ev);
				f1 = facets->Next(ev))
		{
			if ( f1->GetFrame(ev) == pSelection->frame )
				tempFacets->AddLast(f1);
		}
		delete facets;

		// Now delete all facets displaying the frame
		OrderedCollectionIterator t(tempFacets);
		for (ODFacet* f2 = (ODFacet*)t.First();
				t.IsNotComplete();
				f2 = (ODFacet*)t.Next())
		{	
			ODFacet *parentFacet = f2->GetContainingFacet(ev);
			if (parentFacet)
				parentFacet->RemoveFacet(ev, f2);
			ODDeleteObject(f2);
		}
		delete tempFacets;

		somSelf->RemoveEmbeddedFrame(ev, pSelection->frame);

		somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);

		return kODTrue;
	} // end if (pSelection)
	else
		return kODFalse;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartDoSelectAll(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DoSelectAll");

	ODUnused(frame);
	return kODFalse;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartActivateFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ActivateFrame");

	if (frame != kODNULL) {
		PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
		if (!(pInfo->fIsActive))
		{
			ODBoolean succeeded = kODFalse;
								
			succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame);
					
			if (succeeded)
			{
				somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
				somSelf->FocusAcquired(ev, _fMenuFocus, frame);
				somSelf->FocusAcquired(ev, _fKeyFocus, frame);
			}
		}
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDeActivateFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DeActivateFrame");

	if (frame != kODNULL) {
		ODArbitrator* arbitrator = _fSession->GetArbitrator(ev);

		arbitrator->RelinquishFocusSet(ev, _fFocusSet,frame);
		somSelf->FocusLost(ev, _fSelectionFocus, frame);
		somSelf->FocusLost(ev, _fMenuFocus, frame);
		somSelf->FocusLost(ev, _fKeyFocus, frame);

		if ( frame == arbitrator->GetFocusOwner(ev, _fClipboardFocus) )
		{
			arbitrator->RelinquishFocus(ev, _fClipboardFocus, frame);
			somSelf->FocusLost(ev, _fClipboardFocus, frame);
		}
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartActivatingWindow(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ActivatingWindow");

#ifdef ODDebug
	// somPrintf("DrawPart Activate Event\n");
#endif

	PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
	if (pInfo->fNeedsActivating)
	{
		somSelf->ActivateFrame(ev, frame);
		if (_fPaletteWasShown) {
			somSelf->ShowPalette(ev);
		}
		pInfo->fNeedsActivating = kODFalse;
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDeActivatingWindow(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DeActivatingWindow");

#ifdef ODDebug
	// somPrintf("DrawPart De-activate Event\n");
#endif

	PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
	if (frame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev, _fSelectionFocus))
	{
		pInfo->fNeedsActivating = kODTrue;
		//somSelf->DeActivateFrame(ev, frame);
	}
	else
		pInfo->fNeedsActivating = kODFalse;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartInstallMenus(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* aFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","InstallMenus");

	if (aFrame && _fMenuBar)
		_fMenuBar->Display(ev);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartRemoveMenus(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* aFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","RemoveMenus");

	ODUnused(aFrame);

// Don't need to remove the menus we've added
// Just disable Shell menu items we've enabled
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartSetBGColor1(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* aFrame,
		ODUShort whichColor)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","SetBGColor1");

	PartInfoRec* pInfo = (PartInfoRec *) aFrame->GetPartInfo(ev);
	if (!pInfo)
	{	pInfo = new PartInfoRec;
		aFrame->SetPartInfo(ev, (ODInfoType) pInfo);
	};

	COLORREF newColor = pInfo->bgColor;
	
	switch (whichColor)
	{
		case  IDM_GRAY:
			newColor = rgbGray;
			break;
		case  IDM_RED:
			newColor = rgbRed;
			break;
		case  IDM_GREEN:
			newColor = rgbGreen;
			break;
		case  IDM_YELLOW:
			newColor = rgbYellow;
			break;
		case  IDM_BLUE:
			newColor = rgbBlue;
			break;
		case  IDM_MAGENTA:
			newColor = rgbMagenta;
			break;
		case  IDM_CYAN:
			newColor = rgbCyan;
			break;
		case  IDM_WHITE:
			newColor = rgbWhite;
			break;

//skn		case  IDM_OTHER:
//skn			newColor = m_ChooseColor (frame, newColor);
//skn			break;

		default:
			break;
	}
	somSelf->UserSetBGColor(ev, aFrame, newColor);
}

struct SetBGColorRec
{
	SetBGColorRec(RGBColor oldColor, RGBColor newColor, ODFrame* frame)
					{_fOldColor = oldColor; _fNewColor = newColor;
						_fFrame = frame;}
	RGBColor 	_fOldColor;
	RGBColor 	_fNewColor;
	ODFrame*	_fFrame;
};


#undef UNDONEEDSFIXINMAYBE // $$$$$ This should be removed when we are sure Undo works

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartUserSetBGColor(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame,
		ODULong whichColor)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","UserSetBGColor");

	PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo(ev);
	if (!pInfo)
	{	pInfo = new PartInfoRec;
		frame->SetPartInfo(ev, (ODInfoType) pInfo);
	}
	if (!RGBEqual(whichColor,pInfo->bgColor))
	{
		ODIText*	undoActionName;
		ODIText*	redoActionName;
	
#ifdef LATER
		undoActionName = PStrToIntl("\pUndo Set Color", kODNULL );
		redoActionName = PStrToIntl("\pRedo Set Color", kODNULL );
		SetBGColorRec* undoRec = new SetBGColorRec(pInfo->bgColor, whichColor,
													frame);
#ifndef UNDONEEDSFIXINMAYBE
		_fSession->GetUndo(ev)->AddActionToHistory(ev, _fPartWrapper, (ODActionData)undoRec,
												kODSingleAction,
												(ODName*)undoActionName,
												(ODName*)redoActionName);
#endif
#endif
		somSelf->SetBGColor2(ev, frame, whichColor);
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartSetBGColor2(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* aFrame,
		ODULong whichColor)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","SetBGColor2");

	PartInfoRec* pInfo = (PartInfoRec *) aFrame->GetPartInfo(ev);
	if (!pInfo)
	{	pInfo = new PartInfoRec;
		aFrame->SetPartInfo(ev, (ODInfoType) pInfo);
	}
	if (!RGBEqual(whichColor,pInfo->bgColor))
	{
		pInfo->bgColor = whichColor;
		somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
		// OLE: note that SetChangedFromPrev also updates cached
		// image when running in OLE container applications

		aFrame->Invalidate(ev, kODNULL, kODNULL);
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartEmbed(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODUShort item,
		ODFrame* frame,
		ODPart** newPart)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","Embed");

	ODPart* embeddedPart;
	ODFrame* embeddedFrame;
	ODTransform* externalXForm = frame->CreateTransform(ev);
	ODSLong count = 1 + _fContents->Count();

	ODStorageUnit* su = somSelf->GetStorageUnit(ev);
	
	TRY

	embeddedPart = su->GetDraft(ev)->
				CreatePart(ev, _typePtr[item-_firstPartToken],kODNULL);

	Point ptTemp;
	ptTemp.x = ptTemp.y = count*20;
	externalXForm->SetWinOffset(ev, &ptTemp);
	embeddedFrame = somSelf->MakeEmbeddedFrame(ev, frame,
												kODNULL,
												externalXForm,
												embeddedPart,
												kODFalse);
											
	ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
	for (ODFacet* facet = facets->First(ev); facets->IsNotComplete(ev);
			facet = facets->Next(ev))
	{
		ODShape* frameShape = embeddedFrame->GetFrameShape(ev, kODNULL);
		ODShape* clip = frameShape->Copy(ev);
		ODTransform* xform = somSelf->ProxyForFrame(ev, embeddedFrame)->transform->Copy(ev);
		facet->CreateEmbeddedFacet(ev, embeddedFrame, clip, xform,
									kODNULL, kODNULL, kODNULL, kODFrameInFront);
		//facet->GetFrame(ev)->SetDragging(ev, kODTrue);
		frameShape->Release(ev); frameShape = kODNULL;
		clip->Release(ev); clip = kODNULL;
		xform->Release(ev); xform = kODNULL;
	}
	delete facets;
	somSelf->ClipEmbeddedFrames(ev, frame);
	frame->Invalidate(ev, kODNULL, kODNULL);

	CATCH_ALL
		if(newPart)
			*newPart = NULL;
			return;
	ENDTRY
	
	if (newPart)
		*newPart = embeddedPart;
	else
		ODReleaseObject(ev,embeddedPart);
}

#ifdef PLATFORM_MACINTOSH
SOM_Scope void  SOMLINK AppleTestDraw_DrawPartSetGrafPortOrigin(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","SetGrafPortOrigin");

	ODTransform* localToGlobal = facet->GetContentTransform(ev, kODNULL);
	ODPoint offset(0,0);
	offset = localToGlobal->TransformPoint(ev, &offset);
	SetOrigin(-offset.IntX(), -offset.IntY());
	localToGlobal->Release(ev); localToGlobal = kODNULL;
}
#endif

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartInvalEmbedFrameAfterResize(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		Proxy* selection,
		ODShape* oldShape,
		ODShape* newShape,
		Point* transOffset)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","InvalEmbedFrameAfterResize");

	// invalidate old frame shape
	ODShape* oldShapeCopy = oldShape->Copy(ev);
	oldShapeCopy->Transform(ev, selection->transform);
	facet->GetFrame(ev)->Invalidate(ev, oldShapeCopy, kODNULL);
	oldShapeCopy->Release(ev); oldShapeCopy = kODNULL;

	ODShape* newShapeCopy = newShape->Copy(ev);		// save to invalidate later

	selection->frame->ChangeFrameShape(ev, newShape, kODNULL);	// already in frame coords

	// if the left or top side of the frame was adjusted, the transform will be updated
	if ((transOffset->x != 0) || (transOffset->y != 0))
	{
		ODPoint ODtransOffset (*transOffset);
		selection->transform->MoveBy(ev, &ODtransOffset);

		// $$$$$ move facets for selected frame - this is slightly hackish
		ODTransform* newTrans;
		ODFacetIterator* facets =
			facet->GetWindow(ev)->GetRootFacet(ev)->CreateFacetIterator(ev, kODTopDown, kODFrontToBack);
		for (ODFacet* child = facets->First(ev);
				facets->IsNotComplete(ev); child = facets->Next(ev))
		{
			if (child->GetFrame(ev) == selection->frame)
			{
				newTrans = selection->transform->Copy(ev);
				child->ChangeGeometry(ev, kODNULL, newTrans, kODNULL);
				newTrans->Release(ev); newTrans = kODNULL;
				facets->SkipChildren(ev);
			}
		}
		delete facets;
	}

	// invalidate changed areas
	newShapeCopy->Transform(ev, selection->transform);
	facet->GetFrame(ev)->Invalidate(ev, newShapeCopy, kODNULL);
	newShapeCopy->Release(ev); newShapeCopy = kODNULL;

	somSelf->InvalidateSelection(ev, facet->GetFrame(ev));
	somSelf->UpdateProxyRegion(ev, selection);
	somSelf->CreateProxySelectionBorder(ev, selection);
	somSelf->ClipEmbeddedFrames(ev, facet->GetFrame(ev));
	somSelf->InvalidateSelection(ev, facet->GetFrame(ev));
	
	somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
	// OLE: note that SetChangedFromPrev also updates cached
	// image when running in OLE container applications
}


SOM_Scope Rect*  SOMLINK AppleTestDraw_DrawPartGetSelectionRectLocal(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		Proxy* selection)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetSelectionRectLocal");

	Rect shapeRect;
	ODShape* frameShape = selection->frame->GetFrameShape(ev, kODNULL);
	RgnHandle shapeRgn = frameShape->GetWinRegion(ev);
	frameShape->Release(ev); frameShape = kODNULL;
	GetRgnBox (shapeRgn, &shapeRect);
	
	Rect* localRect = new Rect;
	SetRect(localRect, shapeRect.left, shapeRect.top,
						shapeRect.right, shapeRect.bottom);
	
	Point offset = selection->transform->GetWinOffset(ev);
	OffsetRect(localRect, offset.x, offset.y);
	
	return localRect;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartCreatePalette(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CreatePalette");

	if (_fPalette == kODNULL) {
		_fPalette = somSelf->GetStorageUnit(ev)->GetDraft(ev)->CreatePart(ev, kDrawPalette, kODNULL);

		if (!_fPalette) {
			return;
		}
	
		DrawPaletteExt*	aDrawPaletteExt = somSelf->GetDrawPaletteExt(ev);
		if (aDrawPaletteExt) {
			ODRect	anODRect;
			OrderedCollectionIterator	displayFramesIter(_fDisplayFrames);
			ODFrame*	frame = (ODFrame*) displayFramesIter.First();
			ODFrameFacetIterator*	facets = frame->CreateFacetIterator(ev);
			ODFacet*	theFacet = facets->First(ev); 
			delete(facets);

			Rect	clientRect;
			GetClientRect(GetParent(theFacet->GetWindow(ev)->GetPlatformWindow(ev)), &clientRect);
			ODRect	ODClientRect(IntToFixed(clientRect.left), IntToFixed(clientRect.top), 
										IntToFixed(clientRect.right), IntToFixed(clientRect.bottom));

			anODRect.Set(IntToFixed(100), IntToFixed(100), IntToFixed(220), IntToFixed(180));

			// set tool space values

			aDrawPaletteExt->SetSize(ev, &anODRect);
			aDrawPaletteExt->SetDomain(ev, kODDocument);
			aDrawPaletteExt->SetPos(ev, kODTSFloat);
			aDrawPaletteExt->SetFloatRect(ev, &anODRect);
			aDrawPaletteExt->SetPartFrameShape(ev, kODNULL);

			// now, let tool bar create tool space

			aDrawPaletteExt->CallInitCompleted(ev);	// must be called only after all data members are set
			
			// now, add tools 

			if (_fArrowBmp = LoadBitmap (gDrawPartDllInstance, MAKEINTRESOURCE(IDB_ARROW))) {
				aDrawPaletteExt->CreateTool(ev, (ODULong)kNullShape, _fArrowBmp, kDrawToolStateOn);
			}
			if (_fLineBmp = LoadBitmap (gDrawPartDllInstance, MAKEINTRESOURCE(IDB_LINE))) {
				aDrawPaletteExt->CreateTool(ev, (ODULong)kLineShape, _fLineBmp, kDrawToolStateOff);
			}
			if (_fRectBmp = LoadBitmap (gDrawPartDllInstance, MAKEINTRESOURCE(IDB_RECT))) {
				aDrawPaletteExt->CreateTool(ev, (ODULong)kRectShape, _fRectBmp, kDrawToolStateOff);
			}
			if (_fRoundRectBmp = LoadBitmap (gDrawPartDllInstance, MAKEINTRESOURCE(IDB_ROUNDRECT))) {
				aDrawPaletteExt->CreateTool(ev, (ODULong)kRoundRectShape, _fRoundRectBmp, kDrawToolStateOff);
			}
			if (_fEllipseBmp = LoadBitmap (gDrawPartDllInstance, MAKEINTRESOURCE(IDB_ELLIPSE))) {
				aDrawPaletteExt->CreateTool(ev, (ODULong)kEllipseShape, _fEllipseBmp, kDrawToolStateOff);
			}
			if (_fRectFillBmp = LoadBitmap (gDrawPartDllInstance, MAKEINTRESOURCE(IDB_RECTFILL))) {
				aDrawPaletteExt->CreateTool(ev, (ODULong)kRectFillShape, _fRectFillBmp, kDrawToolStateOff);
			}
			if (_fRoundRectFillBmp = LoadBitmap (gDrawPartDllInstance, MAKEINTRESOURCE(IDB_ROUNDRECTFILL))) {
				aDrawPaletteExt->CreateTool(ev, (ODULong)kRoundRectFillShape, _fRoundRectFillBmp, kDrawToolStateOff);
			}
			if (_fEllipseFillBmp = LoadBitmap (gDrawPartDllInstance, MAKEINTRESOURCE(IDB_ELLIPSEFILL))) {
				aDrawPaletteExt->CreateTool(ev, (ODULong)kEllipseFillShape, _fEllipseFillBmp, kDrawToolStateOff);
			}
		}
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDestroyPalette(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DestroyPalette");

	if (_fPalette != kODNULL) {
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartShowPalette(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ShowPalette");

	if (_fPaletteUp == kODFalse) {
		if (_fPalette) {
			DrawPaletteExt*	aDrawPaletteExt = somSelf->GetDrawPaletteExt(ev);
			if (aDrawPaletteExt) {
				ODToolSpaceObj*	aTSObj = aDrawPaletteExt->GetToolSpaceObj(ev);
				if (aTSObj) {
					aTSObj->Show(ev, (int)kODTrue);
					_fPaletteUp = kODTrue;
				}
			}
		}
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartHidePalette(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HidePalette");

	if (_fPaletteUp == kODTrue) {
		if (_fPalette) {
			DrawPaletteExt*	aDrawPaletteExt = somSelf->GetDrawPaletteExt(ev);
			if (aDrawPaletteExt) {
				ODToolSpaceObj*	aTSObj = aDrawPaletteExt->GetToolSpaceObj(ev);
				if (aTSObj) {
					aTSObj->Show(ev, (int)kODFalse);
					_fPaletteUp = kODFalse;
				}
			}
		}
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartGetBGColor(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODUShort whichColor,
		ODULong* newColor)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetBGColor");

	switch (whichColor)
	{
		case  kGray: *newColor = rgbGray;		break;
		case  kRed: *newColor = rgbRed;		break;
		case  kGreen: *newColor = rgbGreen;		break;
		case  kYellow: *newColor = rgbYellow;	break;
		case  kBlue: *newColor = rgbBlue;		break;
		case  kMagenta: *newColor = rgbMagenta;	break;
		case  kCyan: *newColor = rgbCyan;		break;
		case  kWhite: *newColor = rgbWhite;		break;
		
		default:
BGNBP//skn			WASSERTM(kODFalse, "No such color.");
			break;
	}
}


SOM_Scope ODFrame*  SOMLINK AppleTestDraw_DrawPartMakeEmbeddedFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* containingFrame,
		ODShape* frameShape,
		ODTransform* externalTransform,
		ODPart* embedPart,
		ODBoolean isOverlaid)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","MakeEmbeddedFrame");

	ODShape* newShape = NULL;

	// decide what newShape should be - for now, give it what it asked for
	if (frameShape)
	{	
		newShape = frameShape;
		newShape ->IncrementRefCount(ev);
	}
	else
	{	// no frameShape specified, use a default size
		ODRect rect;
		rect.SetInt(0,0,72,72);
		newShape = containingFrame->CreateShape(ev);
		newShape->SetRectangle(ev, &rect);
	};
	
	// create the new frame
	// kODNullTypeToken
	ODFrame* newFrame = somSelf->GetStorageUnit(ev)->GetDraft(ev)->
			CreateFrame(ev, kODNULL, containingFrame, newShape, (ODCanvas*)kODNULL,
						embedPart, _fSession->Tokenize(ev, kODViewAsFrame), kODNullTypeToken,
						kODFalse, isOverlaid);
	_fEmbeddedFrames->AddFirst(newFrame);

	// create a proxy to hold the embedded frame
	ODShape* scratch = newShape->Copy(ev);
	scratch->Transform(ev, externalTransform);
	RgnHandle scratchRgn = scratch->CopyWinRegion(ev);
RECT rc;
GetRgnBox (scratchRgn, &rc);
	newShape->Release(ev); newShape = kODNULL;
	scratch->Release(ev); scratch = kODNULL;
	
	Proxy* p = new Proxy(scratchRgn, newFrame, externalTransform);  // new for Facets
	// put proxy into contents, possibly adjusting other content
	_fContents->AddFirst(p);

	return newFrame;
}

/*
 * SOM_Scope ODWindow**  SOMLINK AppleTestDraw_DrawPartCreateWindow(AppleTestDraw_DrawPart *somSelf, Environment *ev,
 * 		ODFrame* sourceFrame)
 */

/*
 * The prototype for AppleTestDraw_DrawPartCreateWindow was replaced by the following prototype:
 */
SOM_Scope ODWindow*  SOMLINK AppleTestDraw_DrawPartODCreateWindow(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* sourceFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CreateWindow");

	Rect windRect;
	ODPlatformWindow platformWindow = kODNULL;
	ODWindow* window = kODNULL;

#ifdef PLATFORM_MACINTOSH	
	if (sourceFrame)
	{
		SetRect(&windRect, 100, 100, 300, 300);	
	}
	else
	{
		const	ODSShort		kOnePageWidth = 600;
		// Get the menu bar height, for figuring the top of our windows
		ODSShort	mbHeight	= 24; //(*(ODSShort*)MBarHeight);	//get it from lomem
		SetRect(&windRect, 4, mbHeight+16,
				ODQDGlobals.screenBits.bounds.right - 64,
				ODQDGlobals.screenBits.bounds.bottom - 4);		
		
		if (windRect.right-windRect.left > kOnePageWidth)
		{
			windRect.right = windRect.left + kOnePageWidth;
		}
	}

	Str255 aStr255;
	ODName* partName = ODGetPOName( _fPartWrapper, kODNULL);
	IntlToPStr(partName,(StringPtr)&aStr255);
	ODDisposePtr(partName);
	
	platformWindow = NewCWindow(kODNULL, &windRect, /*aStr255*/ "\pDrawing", false, zoomDocProc, (WindowPtr)-1L, true, kODNULL);
#endif

	platformWindow =  _fSession->GetWindowState(ev)->CreatePlatformWindow(ev, kODFalse, WS_CHILD | WS_CLIPSIBLINGS);
	
	window =  _fSession->GetWindowState(ev)->RegisterWindow(ev, platformWindow,
		kODNULL,														
		(sourceFrame==kODNULL),	// Keeps draft open
		kODTrue,	// Is resizable
		kODFalse,	// Is floating
		kODTrue,  // should save
		_fPartWrapper, kODNullTypeToken, kODNullTypeToken, sourceFrame);

#ifdef PLATFORM_MACINTOSH
	window =  _fSession->GetWindowState(ev)->RegisterWindow(ev, platformWindow,
													kODNULL,
													 (sourceFrame==kODNULL),	// Keeps draft open
													 kODTrue,	// Is resizable
													 kODFalse,	// Is floating
													 kODTrue,  // should save
												 _fPartWrapper, kODNullTypeToken, kODNullTypeToken, sourceFrame);
#endif

	return window;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartsomInit(AppleTestDraw_DrawPart *somSelf)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("DrawPart","somInit");

	 AppleTestDraw_DrawPart_parent_ODPart_somInit(somSelf);

	_fShapes 			= kODNULL;
	_fDisplayFrames 	= kODNULL;
	_fEmbeddedFrames 	= kODNULL;
	_fWindowID 			= 0;

	_fFrameGroupIDCounter = 1;

	_fContents 			= kODNULL;
	_fSelection 		= kODNULL;

	_fSelectRgn 		= kODNULL;
	_fCornerHandleRgn 	= kODNULL;
	_fEdgeHandleRgn 	= kODNULL;

	_fEmbedMenu.menu 	= kODNULL;
	_fColorMenu.menu 	= kODNULL;
	_fFrameMenu.menu 	= kODNULL;
	_fPaletteMenu.menu 	= kODNULL;
	_fMenuBar 			= kODNULL;
	_fFocusSet 			= kODNULL;

	_fSemtIntf 			= kODNULL;
	_fTestDrawSU 		= kODNULL;
	
	_fPalette 			= kODNULL;
	_fPaletteUp 		= kODFalse;
	_fPaletteWasShown 	= kODFalse;
	_fbDropTarget	 	= kODFalse;										//OLE2
			
#ifdef PLATFORM_MACINTOSH
	_fLargeIcons 		= kODNULL;
	_fSmallIcons 		 kODNULL;
#endif

	_fSession = kODNULL;
	
	_fPartWrapper 		= kODNULL;

	_fShadowWindow		= kODNULL;
	_fShadowUsage		= 0;
	_fDefaultColor		= IDM_GREEN;
	_fPrinter			= kODNULL;

	_fArrowBmp			= kODNULL;
	_fLineBmp			= kODNULL;
	_fRectBmp			= kODNULL;
	_fRoundRectBmp		= kODNULL;
	_fEllipseBmp		= kODNULL;
	_fRectFillBmp		= kODNULL;
	_fRoundRectFillBmp	= kODNULL;
	_fEllipseFillBmp	= kODNULL;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartsomUninit(AppleTestDraw_DrawPart *somSelf)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("DrawPart","somUninit");

	if (_fContents != kODNULL)
	{
		OrderedCollectionIterator	contentsIter(_fContents);
		Proxy*						proxy;
	
		for (proxy = (Proxy*) contentsIter.First();
				contentsIter.IsNotComplete();
				proxy = (Proxy*) contentsIter.Next())
		{
			DeleteObject (proxy->region);
			delete proxy;
		}
		delete _fContents;
	}
	if (_fSelection != kODNULL)
	{
		delete _fSelection;
	}
	if (_fSelectRgn) DeleteObject(_fSelectRgn);
	if (_fCornerHandleRgn) DeleteObject(_fCornerHandleRgn);
	if (_fEdgeHandleRgn) DeleteObject(_fEdgeHandleRgn);
	
	Environment* ev = somGetGlobalEnvironment();

	if (_fMenuBar != kODNULL) {	
		if (_fMenuBar->GetRefCount(ev) <= 1)
		{	
			if (_fEmbedMenu.menu)
			{
				_fMenuBar->RemoveMenu (ev, IDM_EMBED);
				DestroyMenu (_fEmbedMenu.menu);
			}
			if (_fColorMenu.menu)
			{
				_fMenuBar->RemoveMenu (ev, IDM_COLOR);
				DestroyMenu (_fColorMenu.menu);
			}
			if (_fFrameMenu.menu)
			{
				_fMenuBar->RemoveMenu (ev, IDM_FRAME);
				DestroyMenu (_fFrameMenu.menu);
			}
			if (_fPaletteMenu.menu)
			{
				_fMenuBar->RemoveMenu (ev, IDM_PALETTE);
				DestroyMenu (_fPaletteMenu.menu);
			}
		}

		_fMenuBar->Release(ev);
	}
	
	if (_fShapes != kODNULL) {
		OrderedCollectionIterator	shapesIter(_fShapes);
		DrawShape*					aShape;
	
		for (aShape = (DrawShape*)shapesIter.First(); shapesIter.IsNotComplete();
			aShape = (DrawShape*)shapesIter.Next()) {
			delete aShape;
		}
		delete _fShapes;
	}
	if (_fDisplayFrames != kODNULL)
		delete _fDisplayFrames;		// make sure it's empty first
	if (_fEmbeddedFrames != kODNULL)
		delete _fEmbeddedFrames;		// make sure it's empty first

#ifdef LATER
#ifndef SEMANTIC_INTERFACES_NOT_DONE
	if (_fSemtIntf != kODNULL)	
		delete _fSemtIntf;
#endif
#endif
	
	ODReleaseObject(ev,_fTestDrawSU);

	if (_fShadowWindow)
		DestroyWindow (_fShadowWindow);
				
	if (_fArrowBmp) {
		DeleteObject((HGDIOBJ)_fArrowBmp);
	}
	if (_fLineBmp) {
		DeleteObject((HGDIOBJ)_fLineBmp);
	}
	if (_fRectBmp) {
		DeleteObject((HGDIOBJ)_fRectBmp);
	}
	if (_fRoundRectBmp) {
		DeleteObject((HGDIOBJ)_fRoundRectBmp);
	}
	if (_fEllipseBmp) {
		DeleteObject((HGDIOBJ)_fEllipseBmp);
	}
	if (_fRectFillBmp) {
		DeleteObject((HGDIOBJ)_fRectFillBmp);
	}
	if (_fRoundRectFillBmp) {
		DeleteObject((HGDIOBJ)_fRoundRectFillBmp);
	}
	if (_fEllipseFillBmp) {
		DeleteObject((HGDIOBJ)_fEllipseFillBmp);
	}

	 AppleTestDraw_DrawPart_parent_ODPart_somUninit(somSelf);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartFulfillPromise(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODStorageUnitView* promiseSUView)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	
	ODPropertyName property = promiseSUView->GetProperty(ev);

#ifdef ODDebug
	somPrintf("Draw %d::FulfillPromise: Entering for property %s\n", somSelf->GetID(ev), property);
#endif

	if ( ODISOStrEqual(property, kPropFrameInfo) ) {
		Proxy* selection = kODNULL;
		
//bgn		ASSERTM(
		promiseSUView->GetValue(ev, sizeof(Proxy*), &selection);
//bgn		 == sizeof(Proxy*), kODErrInvalidParameter,	"Invalid Proxy");
	
		promiseSUView->SetOffset(ev, 0);
		ODID frameInfoData = selection->frame->GetID(ev);
		promiseSUView->SetValue(ev, sizeof(ODID), (ODValue) &frameInfoData);
	}
	else if ( ODISOStrEqual(property, kPropMouseDownOffset) ) {
		// The promise data is also the correct value
		// $$$$$ Is it mandatory that the promise be replaced by SetValue???
		Point mdOffset;
		promiseSUView->GetValue(ev, sizeof(Point), (ODValue) &mdOffset);
		promiseSUView->SetOffset(ev, 0);
		promiseSUView->SetValue(ev, sizeof(Point), (ODValue) &mdOffset);
	}
	else if ( ODISOStrEqual(property, kODPropContents) ) {
		
#ifdef ODDebug
		somPrintf("Draw %d::FulfillPromise: Fulfilling promised content\n", somSelf->GetID(ev));
#endif
		// Clone this part's content
		ODStorageUnit*	toSU = promiseSUView->GetStorageUnit(ev);
		ODDraft*		toDraft = promiseSUView->GetStorageUnit(ev)->GetDraft(ev);
		ODDraft*		fromDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
		ODStorageUnit*	testDrawContentSU = toDraft->CreateStorageUnit(ev);
		ODDraftKey		key = 0;
		ODID			toID = 0;
		ODFrame*		scopeFrame = kODNULL;	// $$$$$ should come from promise value
		TRY
			key = fromDraft->BeginClone(ev, toDraft, kODCloneCut);	// $$$$$ is cut vs. copy significant???
			somSelf->CloneTestDrawContent(ev, key, testDrawContentSU, scopeFrame);
			fromDraft->EndClone(ev, key);
		CATCH_ALL
//bt			WARN("Clone Problem in DrawPartFulfillPromise.");
			if (key != 0)
				fromDraft->AbortClone(ev, key);
			RERAISE;
		ENDTRY
		
		// Replace the promise with a reference to the cloned storage unit
		ODStorageUnitRef aSURef = promiseSUView->GetStrongStorageUnitRef(ev, testDrawContentSU->GetID(ev));
		promiseSUView->SetOffset(ev, 0);
		promiseSUView->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
	}

#ifdef ODDebug
	somPrintf("Draw %d::FulfillPromise: Complete\n", somSelf->GetID(ev));
#endif

}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDropCompleted(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODPart* destPart,
		ODDropResult dropResult)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DropCompleted");

	ODUnused(destPart);
	ODUnused(dropResult);
//    AppleTestDraw_DrawPart_parent_ODPart_DropCompleted(somSelf,ev,destPart,dropResult);
}

SOM_Scope ODDragResult  SOMLINK AppleTestDraw_DrawPartDragEnter(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODDragItemIterator* dragInfo,
		ODFacet* facet,
		ODPoint* where)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DragEnter");
	ODULong        	attributes;
	ODStorageUnit	*dragSU;
	BOOL			rc;
	ODUnused(facet);
	ODUnused(where);

	/* We don't support linking to parts
	 */
	attributes = _fSession->GetDragAndDrop(ev)->GetDragAttributes(ev);
	rc 		   = (attributes & kODdragLink) ? kODFalse : kODTrue;

	/* Make sure we can accept the info in this drag (right now only parts)
	 */
	if (rc)
	{
		for (dragSU = dragInfo->First(ev); dragSU; dragSU = dragInfo->Next(ev))
			if (!dragSU->Exists(ev, kODPropPart, kODISOStr, 0))
				rc	= FALSE;
	}

	/* Draw target emphasis if we are allowing the drop operation
	 */
	if (rc != _fbDropTarget)
	{
		_fbDropTarget	= rc;
		somSelf->DrawTarget(ev, facet);
	}
	return	rc;
}

SOM_Scope ODDragResult  SOMLINK AppleTestDraw_DrawPartDragWithin(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODDragItemIterator* dragInfo,
		ODFacet* facet,
		ODPoint* where)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DragWithin");
	BOOL			rc;
	ODULong     	attributes;
	ODStorageUnit	*dragSU;
	ODUnused(facet);
	ODUnused(where);

	/* We don't support linking to parts
	 */
	attributes 	= _fSession->GetDragAndDrop(ev)->GetDragAttributes(ev);
	rc 			=  (attributes & kODdragLink) ? kODFalse : kODTrue;

	/* Make sure we can accept the info in this drag (right now only parts)
	 */
	if (rc)
	{
		for (dragSU = dragInfo->First(ev); dragSU; dragSU = dragInfo->Next(ev))
			if (!dragSU->Exists(ev, kODPropPart, kODISOStr, 0))
				rc	= FALSE;
	}

	/* Draw or erase target emphasis
	 */
	if (rc != _fbDropTarget)
	{
		_fbDropTarget	= rc;
		somSelf->DrawTarget(ev, facet);
	}
	return rc;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDragLeave(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DragLeave");
	ODUnused(facet);
	ODUnused(where);

	/* Erase target emphasis
	 */
	if (_fbDropTarget)
	{
		_fbDropTarget	= FALSE;
		somSelf->DrawTarget(ev, facet);
	}
}

SOM_Scope ODDropResult  SOMLINK AppleTestDraw_DrawPartDrop(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODDragItemIterator* dropInfo,
		ODFacet* facet,
		ODPoint* where)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	ODDraft  		*theDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
	ODULong    		attributes;
	ODULong       	keystate;
	Point           delta, dragPoint, dropPoint, pinnedPoint, newXTrans;
	short           mouseDownModifiers, mouseUpModifiers, movePart;
	ODStorageUnit 	*dropSU = kODNULL;
	ODStorageUnit 	*newSU = kODNULL;
	ODID			draggedFrameID;
	Proxy			*p = kODNULL;
	ODFrame			*frameDroppedIn;
	ODFrame			*newFrame = kODNULL;
	ODPart			*newPart = kODNULL;
	ODShape			*clipShape = kODNULL;
	ODShape			*newFrameShape = kODNULL;
	ODTransform		*newExternalXForm = kODNULL;
	
	/* Erase target emphasis
	 */
	if (_fbDropTarget)
	{
		_fbDropTarget	= FALSE;
		somSelf->DrawTarget(ev,facet);
	}

	ODDropResult	dropResult = kODDropMove;
			
	// Check to see if we can handle the info in this drag (right now only parts)
//	for (dropSU = dropInfo->First(ev); dropSU; dropSU = dropInfo->Next(ev))
//		if (dropSU->Exists(ev, kODPropPart, kODISOStr, 0))
//			canHandleDrop = kODTrue;
			
//	if (canHandleDrop == kODFalse)
//			return kODDropFail;

	// Get the attributes and other crap for this drag
	attributes = _fSession->GetDragAndDrop(ev)->GetDragAttributes(ev);
#ifdef PLATFORM_MACINTOSH
	theDrag = _fSession->GetDragAndDrop(ev)->GetDragReference(ev);
	GetDragModifiers(theDrag, 0L, &mouseDownModifiers, &mouseUpModifiers);
	if ((mouseDownModifiers & optionKey) || (mouseUpModifiers & optionKey))
		dropResult = kODDropCopy;
#endif

	keystate = _fSession->GetDragAndDrop(ev)->GetDropKeyState(ev);

	movePart = (attributes & kODdragIsInSourceFrame) && ((keystate & 0x00008000) == 0);

	if (movePart)
		dropResult = kODDropMove;
	else
		dropResult = kODDropCopy;
		
	ODBoolean	notDone = kODTrue;
	for (dropSU = dropInfo->First(ev); dropSU && notDone;
			dropSU = dropInfo->Next(ev))
	{		
		if ((attributes & kODdragIsInSourceFrame) && (dropResult == kODDropMove))
		{
			// Get where drag started and tweak our own structures to do the move.
#ifdef PLATFORM_MACINTOSH
			GetDragOrigin(theDrag, &dragPoint);
			GetDragMouse(theDrag, &dropPoint, &pinnedPoint);
			delta.h = dropPoint.h - dragPoint.h;
			delta.v = dropPoint.v - dragPoint.v;
#endif
			ODPoint thePoint = _fSession->GetDragAndDrop(ev)->GetDragOrigin(ev);
			dragPoint = thePoint.AsWinPoint();
			GetCursorPos (&dropPoint);
			delta.x = dropPoint.x - dragPoint.x;
			delta.y = dropPoint.y - dragPoint.y;
			dropSU->Focus(ev, kPropFrameInfo, kODPosUndefined, kODFrameRef, 0, kODPosFirstSib);
			dropSU->GetValue(ev, sizeof(ODID), (ODValue) &draggedFrameID);
#ifdef STORAGE_CHANGE
			dropSU->GetULongValue(ev,sizeof(ODID), (ODValue) &draggedFrameID);
#endif
			p = somSelf->ProxyForFrameID(ev, draggedFrameID);
			
			// $$$$$ this is a single-facet hack
			ODPoint ODDelta (delta);
			p->transform->MoveBy(ev, &ODDelta);
			newExternalXForm = p->transform->Copy(ev);
			ODFrameFacetIterator* facets = p->frame->CreateFacetIterator(ev);
			facets->First(ev)->ChangeGeometry(ev, kODNULL, newExternalXForm, kODNULL);
			newExternalXForm->Release(ev); newExternalXForm = kODNULL;
			delete facets;
			
			somSelf->UpdateProxyRegion(ev, p);
			somSelf->CreateProxySelectionBorder(ev, p);
			
			notDone = kODFalse;
		}
		else
		{
			ODDraft*	fromDraft = dropSU->GetDraft(ev);
			ODDraftKey	key;
			ODID		newPartID;
			ODID		newFrameID = 0;
//			ODCloneKind	cloneKind = (dropResult == kODDropMove ? kODCloneDropMove : kODCloneDropCopy);
			ODCloneKind	cloneKind;
			
			if ((keystate & 0x8000) == 0){
				cloneKind = kODClonePaste;
				dropResult = kODDropMove;
			}else{
				cloneKind = kODClonePaste;
				dropResult = kODDropCopy;
			}  

			ODVolatile(fromDraft);
			ODVolatile(key);
			
#ifdef ODDebug
			somPrintf("Draw::Drop: Cloning root su\n");
#endif
			
			TRY
			key = fromDraft->BeginClone(ev, theDraft, cloneKind);
				newPartID = fromDraft->Clone(ev, key, dropSU->GetID(ev), 0, 0);				
				if (dropSU->Exists(ev, kODPropContentFrame, kODWeakStorageUnitRef, 0))
				{
					ODStorageUnitRef aSURef;
					dropSU->Focus(ev, kODPropContentFrame, kODPosSame, kODWeakStorageUnitRef, 0, kODPosUndefined);
					dropSU->GetValue(ev, sizeof(ODStorageUnitRef), &aSURef);
					if ( dropSU->IsValidStorageUnitRef(ev, aSURef) )
						newFrameID = fromDraft->Clone(ev, key, dropSU->GetIDFromStorageUnitRef(ev, aSURef), 0, 0);				
#ifdef ODDebug
					else
						somPrintf("Draw::Drop: Invalid reference to content frame\n");
#endif
				}
				fromDraft->EndClone(ev, key);
				
			CATCH_ALL
				fromDraft->AbortClone(ev, key);
				RERAISE;
			ENDTRY
			
			
			// Get the mouse down offset from the drop storage unit
			if (dropSU->Exists(ev, kPropMouseDownOffset, kWinPoint, 0))
			{
				Point mdOffset = {0,0};
				newXTrans = where->AsWinPoint();
				
				dropSU->Focus(ev, kPropMouseDownOffset, kODPosUndefined, kWinPoint, 0, kODPosFirstSib);
				dropSU->GetValue(ev, sizeof(Point), (ODValue) &mdOffset);

#ifdef PLATFORM_MACINTOSH				
				SubPt(mdOffset,&newXTrans);
#endif
				newXTrans.x -= mdOffset.x;
				newXTrans.y -= mdOffset.y;
			}
			else
			{
#ifdef PLATFORM_MACINTOSH
				SetPt(&newXTrans, 20, 20);
#endif
				newXTrans.x = 20;
				newXTrans.y = 20;
			}
			
			newExternalXForm = facet->CreateTransform(ev);
			newExternalXForm->SetWinOffset(ev, &newXTrans);

			newPart = theDraft->GetPart(ev, newPartID);

			frameDroppedIn = facet->GetFrame(ev);
			
			if ( newFrameID == 0 )
			{
				if (dropSU->Exists(ev, kODPropFrameShape, NULL, 0))
				{
					dropSU->Focus(ev, kODPropFrameShape, kODPosUndefined, NULL, 1, kODPosUndefined);
					newFrameShape = facet->CreateShape(ev);
					newFrameShape->ReadShape(ev, dropSU);
				}

				newFrame = somSelf->MakeEmbeddedFrame(ev, frameDroppedIn,
						newFrameShape, newExternalXForm, newPart, kODFalse);
				if (newFrameShape){
					newFrameShape->Release(ev);
					newFrameShape = kODNULL;
				}
			}
			else
			{
#ifdef JUNK
				if (dropResult != kODDropMove)
				{
					// Get source frame attributes
					ODFrame *tmpFrame = theDraft->GetFrame(ev, newFrameID);
					PartInfoRec* oldPInfo = (PartInfoRec*) tmpFrame->GetPartInfo(ev);

					// Make a new display frame for the part
					newFrame = somSelf->MakeEmbeddedFrame(ev, frameDroppedIn,
						newFrameShape, newExternalXForm, newPart, kODFalse);

					newFrame->IncrementRefCount(ev);
					// set new frame attributes
					newFrame->SetFrozen(ev, tmpFrame->IsFrozen(ev));
					PartInfoRec* pInfo = (PartInfoRec*) newFrame->GetPartInfo(ev);
					if (!RGBEqual(oldPInfo->bgColor,pInfo->bgColor))
					{
						pInfo->bgColor = oldPInfo->bgColor;
						somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
					}
					// Copy all embedded & display frames
				}else
				{
					newFrame = theDraft->GetFrame(ev, newFrameID);
					// move embedded  & display frames
				}
#endif
				newFrame = theDraft->GetFrame(ev, newFrameID);

				if (newFrame->GetPart(ev) == newPart)
				{
					newFrame->SetDragging(ev, kODFalse);
					newFrame->SetContainingFrame(ev, frameDroppedIn);
					newFrame->SetDroppable(ev, kODTrue);
	//bt add method	to replace the following	somSelf->CreateFrameProxy(ev, newFrame, newExternalXForm);
					// add the frame to the collection of embedded frames
					_fEmbeddedFrames->AddFirst(newFrame);
					// calculate the frame shape's region
					ODShape* shape = newFrame->GetFrameShape(ev, kODNULL);
					ODShape* shapeCopy = shape->Copy(ev);
					shapeCopy->Transform(ev, newExternalXForm);
					RgnHandle shapeRgn = shapeCopy->CopyWinRegion(ev);
					ODReleaseObject(ev,shapeCopy);
					ODReleaseObject(ev,shape);
					// create a proxy to hold the embedded frame
					Proxy* p = new Proxy(shapeRgn, newFrame, newExternalXForm);  // new for Facets
					// put proxy into contents, possibly adjusting other content
					_fContents->AddFirst(p);
	//bt end
				}
#ifdef ODDebug
				else
					somPrintf("Draw::Drop - Embedded frame not display frame of embedded part" );
#endif			
			}
			// Create facets
			newFrameShape = newFrame->GetFrameShape(ev, kODNULL);
			clipShape = newFrameShape->Copy(ev);

			newExternalXForm = somSelf->ProxyForFrame(ev, newFrame)->transform->Copy(ev);
			ODFacet* newFacet = facet->CreateEmbeddedFacet(ev, newFrame, clipShape, newExternalXForm,
										kODNULL, kODNULL, kODNULL, kODFrameInFront);
			frameDroppedIn->Invalidate(ev, kODNULL, kODNULL);
			newPart->Release(ev);
			ODReleaseObject(ev,newFrameShape);
			ODReleaseObject(ev,clipShape);
			ODReleaseObject(ev,newExternalXForm);
			
			// Activate frame receiving the drop
#ifdef PLATFORM_MACINTOSH
			ProcessSerialNumber current, front;
			ODBoolean			sameProcess;
			OSErr	err = GetFrontProcess(&front);
			if (err == noErr) {
				err = GetCurrentProcess(&current);
				if (err == noErr) {
					err = SameProcess(&front, &current, &sameProcess);
					if ((err == noErr) && !sameProcess)
						SetFrontProcess(&current);
				}
			}
#endif
			if (!facet->GetWindow(ev)->IsActive(ev))
				facet->GetWindow(ev)->Select(ev);
			else
				somSelf->ActivateFrame(ev, facet->GetFrame(ev));
			
			// Invalidate Clipping	
			ODFrame* selectedFrame = kODNULL;
			Proxy* p = kODNULL;
			OrderedCollectionIterator i(_fSelection);
			p = (Proxy*) i.First();
			if (p != kODNULL) {
				selectedFrame = p->frame;
				if (selectedFrame != kODNULL)
					somSelf->InvalidateSelection(ev, selectedFrame);
			}
			somSelf->EmptySelection(ev);
			if (selectedFrame)
				somSelf->ClipEmbeddedFrames(ev, selectedFrame);
			// Hilight selected frame
			p = somSelf->ProxyForFrame(ev, newFrame);
			_fSelection->AddFirst((ElementType)p);
			newFacet->SetSelected(ev, kODTrue);
			newFacet->ChangeHighlight(ev, kODFullHighlight);
			somSelf->CreateProxySelectionBorder(ev, p);
					
			notDone = kODFalse;
		}
	}
	somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
	// OLE: note that SetChangedFromPrev also updates cached
	// image when running in OLE container applications

	return dropResult;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartContainingPartPropertiesChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame,
		ODStorageUnit* propertyUnit)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ContainingPartPropertiesChanged");

	ODUnused(frame);
	ODUnused(propertyUnit);
}

SOM_Scope ODStorageUnit*  SOMLINK AppleTestDraw_DrawPartGetContainingPartProperties(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetContainingPartProperties");

	ODUnused(frame);

	return kODNULL;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartRevealFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* revealShape)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","RevealFrame");

	ODUnused(embeddedFrame);
	ODUnused(revealShape);

	// $$$$$ THROW(kODErrCannotEmbed);
	return kODFalse;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartEmbeddedFrameSpec(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODObjectSpec* spec)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","EmbeddedFrameSpec");

	ODUnused(embeddedFrame);
	ODUnused(spec);

	THROW(kODErrCannotEmbed);
}

SOM_Scope ODEmbeddedFramesIterator*  SOMLINK AppleTestDraw_DrawPartCreateEmbeddedFramesIterator(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CreateEmbeddedFramesIterator");

	ODUnused(frame);
BGNBP
/* Remove this line when following two lines can be used - skn >>> */ODEmbeddedFramesIterator* iter = kODNULL;
//skn	DrawEmbeddedFramesIterator* iter = new DrawEmbeddedFramesIterator;
//skn	iter->InitEmbeddedFramesIterator(ev, somSelf);
	return iter;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDisplayFrameAdded(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DisplayFrameAdded");

	if (frame->GetPart(ev) == _fPartWrapper)		// frame belongs to me
	{
		OrderedCollectionIterator	displayFramesIter(_fDisplayFrames);
		ODFrame* displayFrame = (ODFrame*) displayFramesIter.First();
		if (displayFramesIter.IsNotComplete() == kODFalse) {
			OrderedCollectionIterator	contentsIter(_fContents);
			Proxy*						proxy;
			
			for (proxy = (Proxy*) contentsIter.First();
					contentsIter.IsNotComplete();
					proxy = (Proxy*) contentsIter.Next())
			{
				proxy->frame->SetContainingFrame(ev, frame);
			}
		}

		// !!! do something with viewType and partInfo...
		PartInfoRec* pInfo = new PartInfoRec;

		pInfo->bgColor = _fDefaultColor;
		//pInfo->bgClipRegion = frame->GetFrameShape(ev, kODNULL)->CopyQDRegion(ev);			// <12> was GetQDRegion()
		if (frame->IsRoot(ev))
			pInfo->fNeedsActivating = kODTrue;

		frame->SetPartInfo(ev, (ODInfoType) pInfo);
		somSelf->SetBGColor1(ev, frame, _fDefaultColor);
		_fDisplayFrames->AddLast(frame);
		frame->IncrementRefCount(ev);
		frame->SetDroppable(ev, kODTrue);
		
		if (frame->GetViewType(ev) == kODNullTypeToken)						// if frame view is set don't change it
			frame->SetViewType(ev, _fSession->Tokenize(ev, kODViewAsFrame));		// if not, make it viewasframe
		if (frame->GetPresentation(ev) == kODNullTypeToken)					
			frame->SetPresentation(ev, _fSession->Tokenize(ev, kDrawPresNormal));
		
		if (frame->GetContainingFrame(ev) == kODNULL)
		{
			//Wrong place. somSelf->ActivateFrame(ev, frame);
		}
	}
	else
		THROW(kODErrInvalidFrame);

	// render in frame?
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartAttachSourceFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame,
		ODFrame* sourceFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","AttachSourceFrame");

	if (_fDisplayFrames->Contains(frame)
		 && sourceFrame && _fDisplayFrames->Contains(sourceFrame))
	{
		//RCR Note. DrawPart does not currently store embedded
		// frames on a per-containing-frame basis (eg. in the part info
		// of each frame). Since we can't add to the embedded frames list
		// while iterating over it, we make a temporary list here
		
			OrderedCollection* embeddedFrames = new OrderedCollection;
			{
				OrderedCollectionIterator iter(_fEmbeddedFrames);
				for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
						iter.IsNotComplete();
						embeddedFrame = (ODFrame*) iter.Next())
				{
					embeddedFrames->AddLast(embeddedFrame);
				}
			}
			
			OrderedCollectionIterator iter(embeddedFrames);
			for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
					iter.IsNotComplete();
					embeddedFrame = (ODFrame*) iter.Next())
			{
				if (embeddedFrame->GetContainingFrame(ev) == sourceFrame)
				{
					ODPart* embeddedPart = embeddedFrame->GetPart(ev);
					ODShape* frameShape = embeddedFrame->GetFrameShape(ev, kODNULL);
					ODShape* newShape = frameShape->Copy(ev);
					ODTransform* newXForm = somSelf->ProxyForFrame(ev, embeddedFrame)->transform->Copy(ev);
					ODFrame* newFrame = somSelf->MakeEmbeddedFrame(ev, frame,
							newShape, newXForm, embeddedPart,
							embeddedFrame->IsOverlaid(ev));
					embeddedPart->AttachSourceFrame(ev, newFrame, embeddedFrame);
					frameShape->Release(ev); frameShape = kODNULL;
//bgn					newShape->Release(ev); newShape = kODNULL;
//bgn					newXForm->Release(ev); newXForm = kODNULL;
				}
			}
			delete embeddedFrames; // Delete the copy
		}
	else
		THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDisplayFrameRemoved(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DisplayFrameRemoved");

	if (frame != kODNULL) {
		if (_fDisplayFrames->Contains(frame))
		{
			OrderedCollection* embeddedFrames = new OrderedCollection;
			{
				OrderedCollectionIterator iter(_fEmbeddedFrames);
				for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
						iter.IsNotComplete();
						embeddedFrame = (ODFrame*) iter.Next())
				{
					embeddedFrames->AddLast(embeddedFrame);
				}
			}
			OrderedCollectionIterator iter(embeddedFrames);
			for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
					iter.IsNotComplete();
					embeddedFrame = (ODFrame*) iter.Next())
			{
				if (embeddedFrame->GetContainingFrame(ev) == frame)
				{
////				embeddedFrame->Close(ev);
//					_fEmbeddedFrames->Remove(embeddedFrame);
////				embeddedFrame->Release(ev);
//					embeddedFrame->Remove(ev);
					somSelf->RemoveEmbeddedFrame(ev, embeddedFrame);
				}
			}
			delete embeddedFrames; // Delete the copy
	
			_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet,frame);
	
			if ( frame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev, _fClipboardFocus) )
			{
				_fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fClipboardFocus, frame);
				somSelf->FocusLost(ev, _fClipboardFocus, frame);
			}

			PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
			frame->SetPartInfo(ev, (ODInfoType) kODNULL);
			delete pInfo;
			_fDisplayFrames->Remove(frame);
			frame->Release(ev);
			
			OrderedCollectionIterator dIter(_fDisplayFrames);
			ODFrame*	displayFrame = (ODFrame*) dIter.First();
			if (dIter.IsNotComplete() == kODFalse) {
				somSelf->DestroyPalette(ev);
			}
		}
		else
			THROW(kODErrInvalidFrame);
	}

	// any display frames left?
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDisplayFrameConnected(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DisplayFrameConnected");

	// $$$$$ add frame to fDisplayFrames if reference lazily internalized
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDisplayFrameClosed(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DisplayFrameClosed");

	if (_fDisplayFrames->Contains(frame))
	{
		OrderedCollection* embeddedFrames = new OrderedCollection;
		{
			OrderedCollectionIterator iter(_fEmbeddedFrames);
			for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
					iter.IsNotComplete();
					embeddedFrame = (ODFrame*) iter.Next())
			{
				embeddedFrames->AddLast(embeddedFrame);
			}
		}
		
		OrderedCollectionIterator iter(embeddedFrames);
		for (ODFrame* embeddedFrame = (ODFrame*) iter.First();
				iter.IsNotComplete();
				embeddedFrame = (ODFrame*) iter.Next())
		{
			if (embeddedFrame->GetContainingFrame(ev) == frame)
			{
				embeddedFrame->Close(ev);
				_fEmbeddedFrames->Remove(embeddedFrame);
				ODReleaseObject(ev,embeddedFrame);
			}
		}
		delete embeddedFrames; // Delete the copy
		
		_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet, frame);

		if ( frame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev, _fClipboardFocus) )
		{
			_fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fClipboardFocus, frame);
			somSelf->FocusLost(ev, _fClipboardFocus, frame);
		}

		PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
		frame->SetPartInfo(ev, (ODInfoType) kODNULL);
		delete pInfo;
		_fDisplayFrames->Remove(frame);
		ODReleaseObject(ev,frame);
	}
	else
		THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartFrameShapeChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","FrameShapeChanged");

	if (_fDisplayFrames->Contains(frame))
	{
		/// !!! should leave UsedShape and ActiveShape null to inherit FrameShape
//		ODShape* scratch;
//		scratch = new ODShape();
//		scratch->CopyFrom(frame->GetFrameShape(ev, kODNULL));
//		frame->ChangeUsedShape(ev, scratch);
// 		scratch = new ODShape();
//		scratch->CopyFrom(frame->GetFrameShape(ev, kODNULL));
//		frame->ChangeActiveShape(ev, scratch);
	}
	else
		THROW(kODErrInvalidFrame);

	somSelf->MoveSizeShadowWindow(ev, frame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartViewTypeChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ViewTypeChanged");

	if (_fDisplayFrames->Contains(frame))
		{ /* $$$$$ change viewType of frame */ }
	else
		THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartPresentationChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","PresentationChanged");

	if (_fDisplayFrames->Contains(frame))
		{ /* $$$$$ change presentation of frame */ }
	else
		THROW(kODErrInvalidFrame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartSequenceChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","SequenceChanged");

    AppleTestDraw_DrawPart_parent_ODPart_SequenceChanged(somSelf,ev,frame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartWritePartInfo(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODPtr partInfo,
		ODStorageUnitView* storageUnitView)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","WritePartInfo");

	if (partInfo)
	{
#ifdef PLATFORM_MACINTOSH
		RGBColor forDebuggingRGBColor ;
		forDebuggingRGBColor = ((PartInfoRec*)partInfo)->bgColor;
		storageUnitView->SetValue(ev, sizeof(RGBColor), (ODValue)&forDebuggingRGBColor);
		ODBoolean needsActivating = ((PartInfoRec*)partInfo)->fNeedsActivating
									|| ((PartInfoRec*)partInfo)->fIsActive;
		storageUnitView->SetValue(ev, sizeof(ODBoolean),
									(ODValue)&needsActivating);
#endif

		// try to munge around with the color enough to get it into something
		//  close to Apple color format
		ODUShort usred = ((ODUShort) GetRValue(((PartInfoRec*)partInfo)->bgColor) & 0xff) << 8;
		ODUShort usgreen = ((ODUShort) GetGValue(((PartInfoRec*)partInfo)->bgColor) & 0xff) << 8;
		ODUShort usblue = ((ODUShort) GetBValue(((PartInfoRec*)partInfo)->bgColor) & 0xff) << 8;
		if ((usred & 0x0f00) == 0x0f00)
			usred |= 0xff;
		if ((usgreen & 0x0f00) == 0x0f00)
			usgreen |= 0xff;
		if ((usblue & 0x0f00) == 0x0f00)
			usblue |= 0xff;
		// adjust endianess
//BGNBP//bgn		usred = ODMoveFileShort(usred);
//bgn		usgreen = ODMoveFileShort(usgreen);
//bgn		usblue = ODMoveFileShort(usblue);
		storageUnitView->SetValue(ev, sizeof(ODUShort), (ODValue)&usred);
		storageUnitView->SetValue(ev, sizeof(ODUShort), (ODValue)&usgreen);
		storageUnitView->SetValue(ev, sizeof(ODUShort), (ODValue)&usblue);
		ODBoolean needsActivating = ((PartInfoRec*)partInfo)->fNeedsActivating
									|| ((PartInfoRec*)partInfo)->fIsActive;
		storageUnitView->SetValue(ev, sizeof(ODBoolean),(ODValue)&needsActivating);
	}
}

SOM_Scope ODPtr  SOMLINK AppleTestDraw_DrawPartReadPartInfo(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame,
		ODStorageUnitView* storageUnitView)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ReadPartInfo");

	ODUnused(frame);
	if (storageUnitView->GetSize(ev))
	{
#ifdef PLATFORM_MACINTOSH
		PartInfoRec* partInfo = new PartInfoRec;
		
		RGBColor forDebuggingRGBColor ;
		storageUnitView->GetValue(ev, sizeof(RGBColor),
									(ODValue)&forDebuggingRGBColor);
		partInfo->bgColor = forDebuggingRGBColor;
//		storageUnitView->GetValue(ev, sizeof(RGBColor),
//									(ODValue)&(partInfo->bgColor));
		ODBoolean needsActivating;
		storageUnitView->GetValue(ev, sizeof(ODBoolean),
									(ODValue)&(needsActivating));
		partInfo->fNeedsActivating = needsActivating;
									
		OrderedCollectionIterator d(_fDisplayFrames);
		ODFrame* dispFrame = (ODFrame*) d.First();
#endif
	
//BGNBP
		ODUShort usred;
		ODUShort usgreen;
		ODUShort usblue;

		PartInfoRec* partInfo = new PartInfoRec;

		// retrieve RGB info (Apple format: 3 shorts)
		storageUnitView->GetValue(ev, sizeof(ODUShort), (ODValue)&usred);
		storageUnitView->GetValue(ev, sizeof(ODUShort), (ODValue)&usgreen);
		storageUnitView->GetValue(ev, sizeof(ODUShort), (ODValue)&usblue);
		// adjust endianess, throw away lower bits
//BGNBP//bgn		usred = ODMoveFileShort(usred) >> 8;
//bgn		usgreen = ODMoveFileShort(usgreen) >> 8;
//bgn		usblue = ODMoveFileShort(usblue) >> 8;
		((PartInfoRec*)partInfo)->bgColor = RGB(usred, usgreen, usblue);

		ODBoolean needsActivating;
		storageUnitView->GetValue(ev, sizeof(ODBoolean),
									(ODValue)&(needsActivating));
		partInfo->fNeedsActivating = needsActivating;

		OrderedCollectionIterator d(_fDisplayFrames);
		ODFrame* dispFrame = (ODFrame*) d.First();
		return partInfo;
	}
	else
		return ((ODPtr)kODNULL);
}

SOM_Scope ODID  SOMLINK AppleTestDraw_DrawPartOpen(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","Open");

	ODWindow* window = kODNULL;

	if (frame) // Doing a View As Window
	{
		window = _fSession->GetWindowState(ev)->GetWindow(ev, _fWindowID);
		if (window)
			window->Select(ev);
		else
		{
			window = somSelf->ODCreateWindow(ev, frame);
			_fWindowID = window->GetID(ev);
			window->Open(ev);
			window->Show(ev);
			window->Select(ev);			
		}
	}
	else
	{
		window = somSelf->ODCreateWindow(ev, frame);
		_fWindowID = window->GetID(ev);
		window->Open(ev);
		window->Show(ev);
		window->Select(ev);			
	}
	return window->GetID(ev);
}

SOM_Scope ODFrame*  SOMLINK AppleTestDraw_DrawPartRequestEmbeddedFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* containingFrame,
		ODFrame* baseFrame,
		ODShape* frameShape,
		ODPart* embedPart,
		ODTypeToken viewType,
		ODTypeToken presentation,
		ODBoolean isOverlaid)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","RequestEmbeddedFrame");

    return (AppleTestDraw_DrawPart_parent_ODPart_RequestEmbeddedFrame(somSelf,ev,containingFrame,baseFrame,frameShape,embedPart,viewType,presentation,isOverlaid));
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartRemoveEmbeddedFrame(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* embeddedFrame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","RemoveEmbeddedFrame");

	if (_fEmbeddedFrames->Contains(embeddedFrame))
	{
		ODFrame* containingFrame = embeddedFrame->GetContainingFrame(ev);
		Proxy* p = somSelf->ProxyForFrame(ev, embeddedFrame);
		if (p)
		{	
			_fContents->Remove(p);
			p->transform->Release(ev); p->transform = kODNULL;
			DeleteObject(p->region);
			delete p;
		}
		_fEmbeddedFrames->Remove(embeddedFrame);
		embeddedFrame->Remove(ev);
		//somSelf->GetStorageUnit(ev)->GetDraft(ev)->RemoveFrame(ev, embeddedFrame);
		
		somSelf->ClipEmbeddedFrames(ev, containingFrame);

	}
	else
		THROW(kODErrInvalidFrame);
}

SOM_Scope ODShape*  SOMLINK AppleTestDraw_DrawPartRequestFrameShape(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* frameShape)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","RequestFrameShape");

	if (_fEmbeddedFrames->Contains(embeddedFrame))
	{	// find frame proxy and fix cached region
		Proxy* p = somSelf->ProxyForFrame(ev, embeddedFrame);
		if (p)
		{
			ODShape* scratch = frameShape->Copy(ev);
			scratch->Transform(ev, p->transform);
			p->region = scratch->CopyWinRegion(ev);
			scratch->Release(ev); scratch = kODNULL;

			p->frame->Invalidate(ev, kODNULL, kODNULL);
		//	p->frame->Invalidate(ev, frameShape, kODNULL);	// $$$$$ why do we need this?

			if (_fSelection->Contains(p)) { /* !!! fix highlighting */ };
			
			// fix clipping of obscured frames
			somSelf->ClipEmbeddedFrames(ev, embeddedFrame->GetContainingFrame(ev));
		}
	}
	else
		THROW(kODErrInvalidFrame);

	return frameShape;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartUsedShapeChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* embeddedFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","UsedShapeChanged");

	if (_fEmbeddedFrames->Contains(embeddedFrame))
	{
		somSelf->ClipEmbeddedFrames(ev, embeddedFrame->GetContainingFrame(ev));
	}
	else
		THROW(kODErrInvalidFrame);
}

SOM_Scope ODShape*  SOMLINK AppleTestDraw_DrawPartAdjustBorderShape(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* embeddedFacet,
		ODShape* shape)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","AdjustBorderShape");

	ODUnused(embeddedFacet);

	return shape;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartFacetAdded(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","FacetAdded");

	ODFrame* dispFrame = facet->GetFrame(ev);
	if (!_fDisplayFrames->Contains(dispFrame))
		THROW(kODErrInvalidFacet);

	if (_fShadowWindow == kODNULL) {
		_fShadowWindow = somSelf->CreateShadowWindow (ev, facet->GetFrame(ev), facet->GetWindow(ev)->GetPlatformWindow(ev));
		if(_fShadowWindow)
			_fShadowUsage  = 1;

		ODFrame *containingFrame = facet->GetFrame(ev)->GetContainingFrame(ev);
		if (containingFrame) {
			ODPart *containingPart = containingFrame->GetPart(ev);
			if (containingPart->HasExtension (ev, "WindowsShadowWindow")) {

				ODPlatformWindow *shadowWindow =
					(ODPlatformWindow*)containingPart->GetExtension(ev, "WindowsShadowWindow");
				SetParent (_fShadowWindow, *shadowWindow);
			}
		}
		somSelf->MoveSizeShadowWindow(ev, dispFrame);
	}
	else
		_fShadowUsage++;

	OrderedCollectionIterator frames(_fEmbeddedFrames);
	for (ODFrame* frame = (ODFrame*) frames.First();
			frames.IsNotComplete();
			frame = (ODFrame*) frames.Next())
	{
		if (frame->GetContainingFrame(ev) == dispFrame)
		{
			ODShape* frameShape = frame->GetFrameShape(ev, kODNULL);
			ODShape* clip = frameShape->Copy(ev);
			ODTransform* xform = somSelf->ProxyForFrame(ev, frame)->transform->Copy(ev);
			facet->CreateEmbeddedFacet(ev, frame,
										clip, xform, kODNULL, kODNULL,
										kODNULL, kODFrameBehind);
			frameShape->Release(ev); frameShape = kODNULL;
			clip->Release(ev); clip = kODNULL;
			xform->Release(ev); xform = kODNULL;
		}
	}
	
	somSelf->ClipEmbeddedFacets(ev, facet);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartFacetRemoved(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","FacetRemoved");

	ODFrame* dispFrame = facet->GetFrame(ev);
	if (!_fDisplayFrames->Contains(dispFrame))
		THROW(kODErrInvalidFacet);
	
	OrderedCollection* children = new OrderedCollection;
	ODFacetIterator* facets = facet->CreateFacetIterator(ev, kODChildrenOnly, kODFrontToBack);
	for (ODFacet* childFacet = facets->First(ev);
		facets->IsNotComplete(ev);
		childFacet = facets->Next(ev))
	{
		children->AddLast(childFacet);
	}
	delete facets;
	OrderedCollectionIterator iter(children);
	for (childFacet = (ODFacet*)iter.First();
			iter.IsNotComplete();
			childFacet = (ODFacet*)iter.Next())
	{
		facet->RemoveFacet(ev, childFacet);
		delete childFacet;
	}
	delete children;

	if (_fShadowWindow)
	{
		_fShadowUsage--;
		if(!_fShadowUsage)
		{
			DestroyWindow (_fShadowWindow);
			_fShadowWindow	= 0;
		}
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartCanvasChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CanvasChanged");

	ODUnused(facet);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartGeometryChanged(AppleTestDraw_DrawPart *somSelf,
		Environment *ev, ODFacet* facet,
		ODBoolean clipShapeChanged,
		ODBoolean externalTransformChanged)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	somSelf->ClipEmbeddedFacets(ev, facet);  // extra work, but gives correct display

	if (externalTransformChanged){
		facet->Invalidate(ev, kODNULL, kODNULL);
		somSelf->MoveSizeShadowWindow(ev, facet->GetFrame(ev));
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDraw(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		ODShape* invalidShape)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","Draw");

	ODBoolean drawing = facet->GetCanvas(ev)->IsDynamic(ev);
	
	ODUnused(invalidShape);

	ODFrame* displayFrame = facet->GetFrame(ev);
	if (_fDisplayFrames->Contains(displayFrame))	
	{
		HDC hdc;

		CFocus	f(facet, invalidShape, &hdc);

		PartInfoRec* pInfo = (PartInfoRec*) displayFrame->GetPartInfo(ev);

		if (facet->GetFrame(ev)->GetPresentation(ev) == _fSession->Tokenize(ev, kDrawPresNormal))
		{
			ODTypeToken curView = facet->GetFrame(ev)->GetViewType(ev);

			if (curView == _fSession->Tokenize(ev, kODViewAsFrame))
			{
				PartInfoRec* pInfo = (PartInfoRec*) displayFrame->GetPartInfo(ev);
				
				// paint the background

				ODULong bgRGB = pInfo->bgColor;
				HBRUSH hbr = CreateSolidBrush (bgRGB);

				ODShape *frameShape = displayFrame->GetFrameShape(ev, kODNULL);
				FillRgn (hdc, frameShape->GetWinRegion(ev), hbr);
				ODReleaseObject (ev, frameShape);
				DeleteObject (hbr);

				if (_fShadowWindow)
					InvalidateRect (_fShadowWindow, NULL, TRUE);

				if (_fShapes != kODNULL) {
					OrderedCollectionIterator	shapesIter(_fShapes);
					DrawShape*					aShape;

					for (aShape = (DrawShape*)shapesIter.First(); shapesIter.IsNotComplete();
						aShape = (DrawShape*)shapesIter.Next()) {
						aShape->Draw(hdc);
					}
				}

				if (displayFrame == _fSession->GetArbitrator(ev)->GetFocusOwner(ev, _fSelectionFocus))
				{	
					// Our we Printing
					ODBoolean isPrinting = !(facet->GetCanvas(ev)->IsDynamic(ev));
	
					// drawing active frame - highlight selection
					if(!facet->GetCanvas(ev)->IsOffscreen(ev) && !isPrinting)				//OLE2
						somSelf->HighlightSelection(ev, hdc);
				}
				else
				{	// drawing inactive frame - do nothing for now
				}
			}
		}
		else if ((drawing) && (facet->GetFrame(ev)->GetPresentation(ev) == _fSession->Tokenize(ev, kDrawPresPalette)))
		{
			ODShape *frameShape = facet->GetFrame(ev)->GetFrameShape(ev, kODNULL);
			ODRgnHandle	bRgn = frameShape->GetWinRegion(ev);
			ODReleaseObject (ev, frameShape);
			Rect		bRect, rgnBBox;
			Rect		colorRect;
			ODUShort	i;
			ODULong		bgColor;
			ODSShort	height;
//bgn			OSErr		err = noErr;

			HBRUSH hbr = GetStockObject (BLACK_BRUSH);
			FillRgn (hdc, bRgn, hbr);

			GetRgnBox (bRgn, &rgnBBox);
			bRect.left = rgnBBox.left;
			bRect.top = rgnBBox.top;
			bRect.bottom = rgnBBox.bottom;
			bRect.right = rgnBBox.right;

			height = ((bRect.bottom - bRect.top) - kMargin - ((kNumColors-1) * kMargin) - kMargin) / kNumColors;

			colorRect.left = bRect.left + kMargin;
			colorRect.right = bRect.right - kMargin;
			colorRect.top = bRect.top + kMargin;
			colorRect.bottom = colorRect.top + height;

			for (i = 0; i < kNumColors; i++) {
BGNBP//bgn				this->GetBGColor(i, &bgColor);
				hbr = CreateSolidBrush (bgColor);
				FillRect (hdc, &colorRect, hbr);
				DeleteObject (hbr);
				colorRect.top = colorRect.bottom + kMargin;
				colorRect.bottom = colorRect.top + height;
			}
		}

		/* Draw our target emphasis rectangle during drag-drop operations
		 */
		if(_fbDropTarget && !facet->GetCanvas(ev)->IsOffscreen(ev))		//OLE2
		{																//OLE2
//bgn			ODShape	*Shape;
			RECT rect;													//OLE2
																		//OLE2
//bgn			Shape = facet->GetActiveShape(ev,kODNULL)->Copy(ev);
//bgn			GetRgnBox(Shape->GetPlatformShape(ev, kODWindows),&rect);		//OLE2
			GetRgnBox(facet->GetActiveShape(ev,kODNULL)->GetPlatformShape(ev, kODWindows),&rect);		//OLE2
			InflateRect(&rect,-4,-4);									//OLE2
			HPEN hpen = CreatePen(PS_SOLID,4,RGB(0,0,0));					//OLE2
			HPEN hpenOld	= SelectObject(hdc,hpen);							//OLE2
			MoveToEx(hdc,rect.left,rect.top,NULL);						//OLE2
			LineTo(hdc,rect.right,rect.top);							//OLE2
			LineTo(hdc,rect.right,rect.bottom);							//OLE2
			LineTo(hdc,rect.left,rect.bottom);							//OLE2
			LineTo(hdc,rect.left,rect.top);								//OLE2
			SelectObject(hdc,hpenOld);									//OLE2
			DeleteObject(hpen);											//OLE2
		}																//OLE2
	}
	else
	{
		// !!! signal error: invalid frame
	}
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartCanvasUpdated(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODCanvas* canvas)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CanvasUpdated");

	ODUnused(canvas);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartHighlightChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HighlightChanged");

	ODUnused(facet);
}

SOM_Scope ODULong  SOMLINK AppleTestDraw_DrawPartGetPrintResolution(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetPrintResolution");

	ODUnused(frame);

	return 0;
}

SOM_Scope ODLink*  SOMLINK AppleTestDraw_DrawPartCreateLink(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODPtr data,
		ODULong size)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CreateLink");

	ODUnused(data);
	ODUnused(size);
	return NULL;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartLinkUpdated(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODLink* updatedLink,
		ODChangeID id)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","LinkUpdated");

	ODUnused(updatedLink);
	ODUnused(id);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartRevealLink(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODLinkSource* linkSource)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","RevealLink");

	ODUnused(linkSource);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartEmbeddedFrameChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame,
		ODChangeID change)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","EmbeddedFrameChanged");

	ODUnused(change);
	ODUnused(frame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartLinkStatusChanged(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","LinkStatusChanged");

	ODUnused(frame);
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartBeginRelinquishFocus(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","BeginRelinquishFocus");

	ODUnused(focus);
	ODUnused(ownerFrame);
	ODUnused(proposedFrame);

	return kODTrue;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartCommitRelinquishFocus(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CommitRelinquishFocus");

	ODUnused(proposedFrame);

	somSelf->FocusLost(ev, focus, ownerFrame);
	if (focus != _fClipboardFocus)
		somSelf->HidePalette(ev);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartAbortRelinquishFocus(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","AbortRelinquishFocus");

	ODUnused(focus);
	ODUnused(ownerFrame);
	ODUnused(proposedFrame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartFocusAcquired(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","FocusAcquired");

	if (focus == _fSelectionFocus)
	{
		PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo(ev);
		pInfo->fIsActive = kODTrue;
		
		if (_fPaletteWasShown) {
			somSelf->ShowPalette(ev);
		}
	}
	else if (focus == _fMenuFocus)
		somSelf->InstallMenus(ev, ownerFrame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartFocusLost(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","FocusLost");

	if (focus == _fSelectionFocus)
	{
		PartInfoRec* pInfo = (PartInfoRec*) ownerFrame->GetPartInfo(ev);
		pInfo->fIsActive = kODFalse;
		somSelf->InvalidateSelection(ev, ownerFrame);
		//somSelf->EmptySelection(ev);
		somSelf->ClipEmbeddedFrames(ev, ownerFrame);
		
		somSelf->HidePalette(ev);
	}
	else if (focus == _fMenuFocus)
		somSelf->RemoveMenus(ev, ownerFrame);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartCloneInto(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODDraftKey key,
		ODStorageUnit* toSU,
		ODFrame* scopeFrame)
{
	SOM_CATCH return;
	
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);

	 AppleTestDraw_DrawPart_parent_ODPart_CloneInto(somSelf,ev,key,toSU,scopeFrame);

	// First check for the existence of my content kind;
	if ( !toSU->Exists(ev, kODPropContents, kKindTestDraw, 0) )
	{
		if ( toSU->Exists(ev, kODPropContentFrame, kODWeakStorageUnitRef, 0) )
		{
			// This part is being cloned as a single embedded part, so promise our content.
#ifdef ODDebug
			somPrintf("Draw %d::CloneInto: Promising content\n", somSelf->GetID(ev));
#endif
			// Add the contents property if not already present
			if ( !toSU->Exists(ev, kODPropContents, kODNULL, 0) )
				toSU->AddProperty(ev, kODPropContents);
			// $$$$$ Should store the scopeFrame as the promise value so FulFill promise
			// can enforce scope restrictions correctly.
			ODSShort dummy = 0;
			toSU->SetPromiseValue(ev, kKindTestDraw, 0, 0, kODNULL, somSelf);
		}
		else
		{
#ifdef ODDebug
			somPrintf("Draw %d::CloneInto: Cloning content to %d %d\n", somSelf->GetID(ev), toSU, scopeFrame);
#endif
			ODStorageUnit* testDrawContentSU = toSU->GetDraft(ev)->CreateStorageUnit(ev);
			somSelf->CloneTestDrawContent(ev, key, testDrawContentSU, scopeFrame);
			
			toSU->AddProperty(ev, kODPropContents)->AddValue(ev, kKindTestDraw);
			ODStorageUnitRef aSURef = toSU->GetStrongStorageUnitRef(ev, testDrawContentSU->GetID(ev));
			toSU->SetValue(ev, sizeof(ODStorageUnitRef),&aSURef);
	
			testDrawContentSU->Release(ev);
#ifdef ODDebug
			somPrintf("Draw %d::CloneInto: Cloning Done\n", somSelf->GetID(ev));
#endif
		}

	}
}

//------------------------------------------------------------------------------
// Draw: CloneTestDrawContent
//------------------------------------------------------------------------------
SOM_Scope void  SOMLINK AppleTestDraw_DrawPartCloneTestDrawContent(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODDraftKey		key,
		ODStorageUnit*	toSU,
		ODFrame*		scopeFrame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","CloneTestDrawContent");

	SOM_CATCH
	{
#ifdef ODDebug
		somPrintf("Draw %d::CloneTestDrawContent: Exception caught\n", somSelf->GetID(ev));
#endif
		return;
	}
	
#ifdef ODDebug
	somPrintf("Draw %d::CloneTestDrawContent: Cloning content\n", somSelf->GetID(ev));
#endif

	ODDraft* fromDraft = somSelf->GetStorageUnit(ev)->GetDraft(ev);
	ODDraft* toDraft = toSU->GetDraft(ev);
	
	ODStorageUnitRef aSURef;
	ODULong offset;
	ODFrame* frame;
	Proxy* proxy;
	OrderedCollectionIterator aIter(_fDisplayFrames);
	OrderedCollectionIterator cIter(_fContents);
	Point xform;
	ODID scopeFrameID = ( scopeFrame ? scopeFrame->GetID(ev) : 0 );

	toSU->AddProperty(ev, kODPropDisplayFrames)->AddValue(ev, kODWeakStorageUnitRef);

	offset = 0;
	for (frame = (ODFrame*)aIter.First(); aIter.IsNotComplete();
			frame = (ODFrame*)aIter.Next(), offset+=sizeof(ODStorageUnitRef))
	{
		// $$$$$ Don't copy display frames unless they're in scope;
		// Currently, this part supports only one display frame
		ODID toFrameID = fromDraft->WeakClone(ev, key, frame->GetID(ev), 0, scopeFrameID);
		aSURef = toSU->GetWeakStorageUnitRef(ev, toFrameID);
		toSU->SetOffset(ev, offset);
		toSU->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
	}

 	toSU->AddProperty(ev, kODPropFrameGroup)->AddValue(ev, kODULong);
	toSU->SetValue(ev, sizeof(_fFrameGroupIDCounter), (ODValue)&_fFrameGroupIDCounter);
	
 	toSU->AddProperty(ev, kODPropContents)->AddValue(ev, kODStrongStorageUnitRef);
	offset = 0;
	for (proxy = (Proxy*)cIter.First();
			cIter.IsNotComplete();
			proxy = (Proxy*)cIter.Next())
	{
#ifdef ODDebug
	somPrintf("Draw %d::CloneTestDrawContent: Clone Proxy: %d\n", somSelf->GetID(ev), proxy->frame->GetID(ev));
#endif
		ODID toFrameID = fromDraft->Clone(ev, key, proxy->frame->GetID(ev), 0, scopeFrameID);
		aSURef = toSU->GetStrongStorageUnitRef(ev, toFrameID);
		toSU->SetOffset(ev, offset);
		toSU->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
		offset += sizeof(ODStorageUnitRef);
		
		xform = proxy->transform->GetWinOffset(ev);
		toSU->SetOffset(ev, offset);
		toSU->SetValue(ev, sizeof(ODPlatformTransform), (ODValue)&xform);
		offset += sizeof(Point);
	}

#ifdef ODDebug
	somPrintf("Draw %d::CloneTestDrawContent: Done\n", somSelf->GetID(ev));
#endif
}

/*
 * SOM_Scope void  SOMLINK AppleTestDraw_DrawPartExternalizeKinds(AppleTestDraw_DrawPart *somSelf, Environment *ev,
 * 		ODTypeSet* kindset)
 */

/*
 * The prototype for AppleTestDraw_DrawPartExternalizeKinds was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK AppleTestDraw_DrawPartExternalizeKinds(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODTypeList* kindset)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ExternalizeKinds");

	ODUnused(kindset);
	somSelf->Externalize(ev);
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartExternalize(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","Externalize");

	 AppleTestDraw_DrawPart_parent_ODPart_Externalize(somSelf,ev);

//	SimplePart::Externalize();
//  since SimplePart has no Externalize method, I assume this just calls
//  the same code as AppleTestDraw_DrawPart_parent_ODPart_Externalize.  So ignore.
	
	ODStorageUnit* su = _fTestDrawSU;
	ODStorageUnitRef aSURef;
	ODULong offset;
	ODFrame* frame;
	Proxy* proxy;
	OrderedCollectionIterator aIter(_fDisplayFrames);
	OrderedCollectionIterator bIter(_fEmbeddedFrames);
	OrderedCollectionIterator cIter(_fContents);
	Point xform;

	su->Focus(ev, kODPropDisplayFrames,kODPosUndefined,0,1,kODPosFirstSib);
#ifndef SSREMOVEWORKAROUND
	su->Remove(ev);
	su->AddProperty(ev, kODPropDisplayFrames);
	su->AddValue(ev, kODWeakStorageUnitRef);
#else
	ODULong oldValueSize = su->GetSize(ev);;
#endif
	offset = 0;
	for (frame = (ODFrame*)aIter.First(); aIter.IsNotComplete();
			frame = (ODFrame*)aIter.Next(), offset+=sizeof(ODStorageUnitRef))
	{
		frame->Externalize(ev);
		aSURef = su->GetWeakStorageUnitRef(ev, frame->GetStorageUnit(ev)->GetID(ev));
		su->SetOffset(ev, offset);
		su->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
	}
#ifdef SSREMOVEWORKAROUND
	if (oldValueSize > offset)
		su->DeleteValue(ev, oldValueSize-offset);
#endif

	su->Focus(ev, kODPropFrameGroup,kODPosUndefined,0,1,kODPosFirstSib);
	su->SetValue(ev, sizeof(_fFrameGroupIDCounter), (ODValue)&_fFrameGroupIDCounter);
	
	su->Focus(ev, kODPropContents,kODPosUndefined,0,1,kODPosFirstSib);
#ifndef SSREMOVEWORKAROUND
	su->Remove(ev);
	su->AddProperty(ev, kODPropContents);
	// $$$$$ It is confusing to use prop contents in a storageunit which is
	// not the primary storageunit of the part
	su->AddValue(ev, kODStrongStorageUnitRef);
	// $$$$$ should be something DrawPart specific, not kODStrongStorageUnitRef
	// since it is storing StorageUnitRefs and xforms in the same stream.
#else
	oldValueSize = su->GetSize(ev);;
#endif
	offset = 0;
	for (proxy = (Proxy*)cIter.First();
			cIter.IsNotComplete();
			proxy = (Proxy*)cIter.Next())
	{
		proxy->frame->Externalize(ev);
		aSURef = su->GetStrongStorageUnitRef(ev, proxy->frame->GetStorageUnit(ev)->GetID(ev));
		su->SetOffset(ev, offset);
		su->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
		offset += sizeof(ODStorageUnitRef);
		
		xform = proxy->transform->GetWinOffset(ev);
		su->SetOffset(ev, offset);
		su->SetValue(ev, sizeof(ODPlatformTransform), (ODValue)&xform);
		offset += sizeof(Point);
	}
#ifdef SSREMOVEWORKAROUND
	if (oldValueSize > offset)
		su->DeleteValue(ev, oldValueSize-offset);
#endif

	su = somSelf->GetStorageUnit(ev);
	su->Focus(ev, kODPropContents,kODPosSame,kKindTestDraw,1,kODPosFirstSib);
	aSURef = su->GetStrongStorageUnitRef(ev, _fTestDrawSU->GetID(ev));
	su->SetValue(ev, sizeof(ODStorageUnitRef),&aSURef);
 }

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartChangeKind(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODType kind)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ChangeKind");

	ODUnused(kind);
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleEvent(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODEventData* event,
		ODFrame* frame,
		ODFacet* facet)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HandleEvent");

	Point windowPoint;
	ODBoolean handled = kODFalse;
#ifndef WIN32
	POINT	p = MAKEPOINT(event->lParam);
#else
	POINT p;
	LONG2POINT(event->lParam, p);
#endif
	ODPoint point = p;
	
	switch (event->message)
	{
#ifdef PLATFORM_MACINTOSH
		case nullEvent:
			break;
		
		case mouseDown:
			{
				windowPoint = event->where;
				GetPort(&curPort);
				SetPort(facet->GetWindow(ev)->GetPlatformWindow(ev));
				SetOrigin(0,0);
				GlobalToLocal(&windowPoint);
				ODPoint windowODPoint(windowPoint);
				handled = somSelf->HandleMouseDown(ev, facet, &windowODPoint, event);
				SetPort(curPort);
			}
			break;
			
		case kODEvtWindow:
			{
				switch (event->message)
				{
					case inGoAway:
						ODWindow*	window = facet->GetWindow(ev);
						if (window == _fPalette) {
							somSelf->HidePalette(ev);
						}
						break;
					case inZoomIn:
					case inZoomOut:
						SysBeep(2);
						handled = kODTrue;
						break;
					default:
						break;
				}
			}
			break;
		
		case mouseUp:
			if (!facet->GetWindow(ev)->IsActive(ev))
				facet->GetWindow(ev)->Select(ev);
			else
				somSelf->ActivateFrame(ev, facet->GetFrame(ev));
			handled = kODTrue;
			break;
			
		case keyDown:
		case autoKey:
			handled = somSelf->HandleKeyDown(ev, frame, event);
			break;
	
		case activateEvt:
			handled = true; // actually ignored by dispatcher
			if ((event->modifiers & activeFlag) != 0)
				somSelf->ActivatingWindow(ev, frame);
			else
				somSelf->DeActivatingWindow(ev, frame);
			break;
		
		case keyUp:
			break;
						
		case osEvt:
			{
				unsigned char 	typeOSEvent;
				
				//  Is it a multifinder event?
				typeOSEvent = (unsigned char) (event->message >> 24) & 0x00FF;
				
				//  Switch on the type of OSEvent that occurred, high byte of message is event type
				switch (typeOSEvent)
				{ 	
					case kMouseMovedMessage:
						break;
						
					case kSuspendResumeMessage:
						{
							const short kResumeMask = 0x01;	// High byte suspend/resume event
							ODBoolean	goingToBackground = (event->message & kResumeMask) == 0;
							ODWindow*	window = facet->GetWindow(ev);
							if (window && window != _fPalette)
							{
								if (goingToBackground)
								{
#ifdef ODDebug
	somPrintf("DrawPart Suspend Event\n");
#endif
									if (_fPalette && _fPalette->IsShown(ev))
									{
										_fPaletteWasShown = kODTrue;
										somSelf->HidePalette(ev);
									}
									else
										_fPaletteWasShown = kODFalse;
								}
								else
								{
#ifdef ODDebug
	somPrintf("DrawPart Resume Event\n");
#endif
									if (_fPaletteWasShown)
									{
										somSelf->ShowPalette(ev);
									}
								}
							}
								
						}
						break;
				}
			}

			break;
	
		case kHighLevelEvent:
			break;

		case kODEvtMenu:
			handled = somSelf->HandleMenuEvent(ev, frame, event);
			break;
#endif

		case WM_RBUTTONDOWN:
		case WM_LBUTTONDOWN:
			handled = somSelf->HandleMouseDown(ev, facet, &point,event);
			break;

		case WM_MOUSEMOVE:
			 if (event->wParam & MK_LBUTTON)
				handled = somSelf->HandleMouseDown(ev, facet, &point,event);
			break;

		case WM_KEYDOWN:
			handled = somSelf->HandleKeyDown(ev, frame, event );
			break;

		case WM_CHAR:
			handled = FALSE;
			break;

		case WM_COMMAND:
			handled = somSelf->HandleMenuEvent(ev, frame,event);
			break;

		case kODEvtMouseDownEmbedded:
			{
				handled = somSelf->HandleMouseDownInEmbeddedFrame(ev, facet,
					(ODFacet*) event->lParam, &point,event);
			}
			break;

		case kODEvtMouseDownBorder:
			{
				handled = somSelf->HandleMouseDownInEmbeddedFrame(ev, facet,
					(ODFacet*) event->lParam, &point,event);
			}
			break;

		case kODEvtWindow:
			{
				ODWindow*	window = facet->GetWindow(ev);
				switch (event->message)
				{
					default:
						break;
				}
			}
			break;

		case WM_LBUTTONUP:
			break;
	
		case WM_ACTIVATE:
			handled = kODTrue; // actually ignored by dispatcher
			if (event->wParam  != WA_INACTIVE)
				somSelf->ActivatingWindow(ev, frame);
			else
				somSelf->DeActivatingWindow(ev, frame);
			break;

		case WM_VSCROLL:
			somSelf->SetBGColor1(ev, frame, (ODUShort)((rand()%6)+IDM_RED));
			break;


		default:
			return kODFalse;
	}
	return handled;
}

SOM_Scope ODBoolean  SOMLINK AppleTestDraw_DrawPartHandleEventInEmbedded(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODEventData* event,
		ODFrame* frame,
		ODFacet* facet,
		ODFrame* embeddedFrame,
		ODFacet* embeddedFacet)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HandleEventInEmbedded");

	ODUnused(event);
	ODUnused(frame);
	ODUnused(embeddedFrame);

	ODBoolean handled = kODFalse;
	Point windowPoint;
#ifdef PLATFORM_MACINTOSH
	GrafPtr curPort;
#endif
#ifdef PLATFORM_WINDOWS
#ifndef WIN32
	POINT	p = MAKEPOINT(event->lParam);
#else
	POINT p;
	LONG2POINT(event->lParam, p);
#endif
	ODPoint ODWindowPoint = p;
#endif
	
	switch (event->message)
	{
		case kODEvtMouseDownEmbedded:
			{
#ifdef PLATFORM_MACINTOSH
				windowPoint = event->where;
				GetPort(&curPort);
				SetPort(facet->GetWindow(ev)->GetPlatformWindow(ev));
				SetOrigin(0,0);
				GlobalToLocal(&windowPoint);
				ODPoint ODWindowPoint (windowPoint);
				handled = somSelf->HandleMouseDownInEmbeddedFrame(ev, facet,
										embeddedFacet,
										&ODWindowPoint, event);
				SetPort(curPort);
#endif
#ifdef PLATFORM_WINDOWS
				handled = somSelf->HandleMouseDownInEmbeddedFrame(ev, facet,
					embeddedFacet, &ODWindowPoint, event);
#endif
			}
			break;
		
		case kODEvtMouseDownBorder:
			{
#ifdef PLATFORM_MACINTOSH
				windowPoint = event->where;
				GetPort(&curPort);
				SetPort(facet->GetWindow(ev)->GetPlatformWindow(ev));
				SetOrigin(0,0);
				GlobalToLocal(&windowPoint);
				ODPoint ODWindowPoint (windowPoint);
				handled = somSelf->HandleMouseDownInEmbeddedFrame(ev, facet,
										embeddedFacet,
										&ODWindowPoint, event);
				SetPort(curPort);
#endif
#ifdef PLATFORM_WINDOWS
				handled = somSelf->HandleMouseDownInEmbeddedFrame(ev, facet,
					embeddedFacet, &ODWindowPoint, event);
#endif
			}
			break;
		
		case kODEvtMouseUpEmbedded:
			//facet->GetFrame(ev)->SetDragging(ev, kODFalse);
			if (!facet->GetWindow(ev)->IsActive(ev))
				facet->GetWindow(ev)->Select(ev);
			else
				somSelf->ActivateFrame(ev, facet->GetFrame(ev));
			handled = kODTrue;
					
		default:
			return kODFalse;
	}
	return handled;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartMouseEnter(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","MouseEnter");

	ODPlatformWindow window = facet->GetWindow(ev)->GetPlatformWindow(ev);	
#ifndef WIN32
	_fSaveCursor = GetClassWord (window, GCW_HCURSOR);
	SetClassWord (window, GCW_HCURSOR, 0);
#else
	_fSaveCursor = (HCURSOR)GetClassLong (window, GCL_HCURSOR);
	SetClassLong (window, GCL_HCURSOR, 0);
#endif
	SetCursor(LoadCursor(NULL, IDC_CROSS)); // For now.
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartMouseWithin(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","MouseWithin");

// #ifdef ODDebug
//	somPrintf("MouseWithin %d %d\n",where->IntX(),where->IntY());
// #else
//	ODUnused(where);
// #endif
//	ODUnused(facet);

	ODFacet*	rootFacet = facet->GetWindow(ev)->GetRootFacet(ev);

	Point	cursorPnt;
	GetCursorPos(&cursorPnt);
	ScreenToClient(rootFacet->GetWindow(ev)->GetPlatformWindow(ev), &cursorPnt);

	ODTransform*	wcXForm = rootFacet->GetExternalTransform(ev, kODNULL);
	ODPoint	anODPnt(IntToFixed(cursorPnt.x), IntToFixed(cursorPnt.y));
	anODPnt = wcXForm->InvertPoint(ev, &anODPnt);
	ODReleaseObject(ev, wcXForm);

	if (somSelf->PtInDrawShape(ev, &anODPnt)) {
		SetCursor(LoadCursor(NULL, IDC_ARROW));
	} else {
		DrawPaletteExt*	aDrawPaletteExt = somSelf->GetDrawPaletteExt(ev);
		if (aDrawPaletteExt) {
			ODULong	activeTool = somSelf->GetActiveTool(ev);
			if (activeTool > 0L) {
				DrawShapeType	activeToolType = (DrawShapeType)(aDrawPaletteExt->GetToolID(ev, activeTool));
				if (activeToolType == kNullShape) {
					SetCursor(LoadCursor(NULL, IDC_ARROW));
				} else {
					SetCursor(LoadCursor(NULL, IDC_CROSS));
				}
				return;
			}
		}
	}

	SetCursor(LoadCursor(NULL, IDC_ARROW));	// default
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartMouseLeave(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFacet* facet)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","MouseLeave");

// #ifdef ODDebug
//	somPrintf("MouseLeave\n");
// #endif

	ODPlatformWindow window = facet->GetWindow(ev)->GetPlatformWindow(ev);	
//bgn	SetCursor(LoadCursor(NULL, IDC_ARROW)); // For now.
#ifndef WIN32
	SetClassWord (window, GCW_HCURSOR, _fSaveCursor);
#else
	SetClassLong (window, GCL_HCURSOR, (LONG)_fSaveCursor);
#endif
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartAdjustMenus(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","AdjustMenus");

#ifdef PLATFORM_MACINTOSH
	PartInfoRec* pInfo = (PartInfoRec*) frame->GetPartInfo(ev);
#endif

	// if this frame is the root frame, enable printing.
	
	if (frame->GetContainingFrame(ev) == kODNULL)
	{
		_fMenuBar->EnableCommand(ev, kODCommandPageSetup, kODTrue);
		_fMenuBar->EnableCommand(ev, kODCommandPrint, kODTrue);
	}
	else
	{
		_fMenuBar->EnableCommand(ev, kODCommandPageSetup, kODFalse);
		_fMenuBar->EnableCommand(ev, kODCommandPrint, kODFalse);
	}

	_fMenuBar->EnableCommand(ev, kODCommandGetPartInfo, kODTrue);

	// if a part is selected
		_fMenuBar->EnableCommand(ev, kODCommandOpen, kODTrue);
		
	_fMenuBar->EnableCommand(ev, kODCommandViewAsWin, !frame->IsRoot(ev));

#ifdef PLATFORM_MACINTOSH
	_fMenuBar->EnableAndCheckCommand(ev, cGray, kODTrue, RGBEqual(pInfo->bgColor,rgbGray));
	_fMenuBar->EnableAndCheckCommand(ev, cRed, kODTrue, RGBEqual(pInfo->bgColor,rgbRed));
	_fMenuBar->EnableAndCheckCommand(ev, cGreen, kODTrue, RGBEqual(pInfo->bgColor,rgbGreen));
	_fMenuBar->EnableAndCheckCommand(ev, cYellow, kODTrue, RGBEqual(pInfo->bgColor,rgbYellow));
	_fMenuBar->EnableAndCheckCommand(ev, cBlue, kODTrue, RGBEqual(pInfo->bgColor,rgbBlue));
	_fMenuBar->EnableAndCheckCommand(ev, cMagenta, kODTrue, RGBEqual(pInfo->bgColor,rgbMagenta));
	_fMenuBar->EnableAndCheckCommand(ev, cCyan, kODTrue, RGBEqual(pInfo->bgColor,rgbCyan));
	_fMenuBar->EnableAndCheckCommand(ev, cWhite, kODTrue, RGBEqual(pInfo->bgColor,rgbWhite));
	_fMenuBar->EnableCommand(ev, cOtherColor, kODTrue);
#endif

	ODBoolean hasSelection = _fSelection->Count()>0;

	_fMenuBar->EnableCommand(ev, kODCommandClear, hasSelection);
	_fMenuBar->EnableCommand(ev, kODCommandSelectAll, _fEmbeddedFrames->Count()>0);

	ODArbitrator* arbitrator = _fSession->GetArbitrator(ev);

	if ( (frame == arbitrator->GetFocusOwner(ev, _fClipboardFocus)) ||
		 (arbitrator->RequestFocus(ev, _fClipboardFocus, frame)) )
	{
		_fMenuBar->EnableCommand(ev, kODCommandCut, hasSelection);
		_fMenuBar->EnableCommand(ev, kODCommandCopy, hasSelection);
		_fMenuBar->EnableCommand(ev, kODCommandPaste, ValueOnClipboard(ev, _fSession));
		_fMenuBar->EnableCommand(ev, kODCommandPasteAs, kODFalse);
	}

	_fMenuBar->CheckCommand(ev, IDM_SHOWPALETTE, _fPaletteWasShown);
	_fMenuBar->CheckCommand(ev, IDM_HIDEPALETTE, (_fPaletteWasShown == kODFalse));
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartUndoAction(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODActionData actionState)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","UndoAction");

#ifdef LATER
	// FOR NOW, WE JUST HAVE ONE ACTION THAT CAN BE UNDONE OR REDONE.
	SetBGColorRec*	undoRec = (SetBGColorRec*)actionState;
	
	somSelf->SetBGColor2(ev, undoRec->_fFrame, undoRec->_fOldColor);
#endif
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartRedoAction(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODActionData actionState)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","RedoAction");

#ifdef LATER
	// FOR NOW, WE JUST HAVE ONE ACTION THAT CAN BE UNDONE OR REDONE.
	SetBGColorRec*	undoRec = (SetBGColorRec*)actionState;
	
	somSelf->SetBGColor2(ev, undoRec->_fFrame, undoRec->_fNewColor);
#endif
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartDisposeActionState(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODActionData actionState,
		ODDoneState doneState)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DisposeActionState");

	ODUnused(doneState);
	// FOR NOW, WE JUST HAVE ONE ACTION THAT CAN BE UNDONE OR REDONE.
	delete (SetBGColorRec*)actionState;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartWriteActionState(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODPtr actionState,
		ODStorageUnitView* storageUnitView)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","WriteActionState");

	ODUnused(actionState);
	ODUnused(storageUnitView);
}

SOM_Scope ODPtr  SOMLINK AppleTestDraw_DrawPartReadActionState(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODStorageUnitView* storageUnitView)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","ReadActionState");

	ODUnused(storageUnitView);
	return kODNULL;
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartInitPart(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
    AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","InitPart");

	if (somSelf->IsInitialized(ev))
		return;

	somSelf->InitPersistentObject(ev, storageUnit);
	
	_fPartWrapper = partWrapper;

	static	ODUShort	Color	= 0;

#ifdef PLATFORM_WINDOWS
	/* Don't use random colors. They come out the same quite often !
	 */
	if (!Color)
		Color	= (ODUShort)((rand()%6)+IDM_RED);
	else if (Color > IDM_RED + 5)
		Color 	= IDM_RED;
	else
		Color++;
	_fDefaultColor	= Color;

	somSelf->CommonInitDrawPart(ev);
	
	ODStorageUnit* msu = somSelf->GetStorageUnit(ev);
	msu->AddProperty(ev, kODPropContents)->AddValue(ev, kKindTestDraw);	

	// dkf todo: this is a temp hack!
	//  Apple A6 expects the following property and value in this
	//  storage unit. In Apple's code, this prop/value is created in
	//  binding code. We must create the prop/value on a temp basis
	//  so that our files can be read by the Mac. This hack will go
	//  away when we implement binding more like Apple does or Apple
	//  makes the code that reads this prop/value conditional on its
	//  existence.
	msu->AddProperty(ev, kODPropPreferredEditor)->AddValue(ev, kODEditor);
	msu->SetValue(ev, sizeof("appl:drawpart$class"),(ODValue)"appl:drawpart$class");
	// end todo: temp hack

	_fTestDrawSU = msu->GetDraft(ev)->CreateStorageUnit(ev);

	_fTestDrawSU->AddProperty(ev, kODPropDisplayFrames)->AddValue(ev, kODWeakStorageUnitRefs);
	_fTestDrawSU->AddProperty(ev, kODPropEmbeddedFrames)->AddValue(ev, kODStrongStorageUnitRefs);
	_fTestDrawSU->AddProperty(ev, kODPropFrameGroup)->AddValue(ev, kODULong);			
	_fTestDrawSU->AddProperty(ev, kODPropContents)->AddValue(ev, kODStrongStorageUnitRef);
	// $$$$$ It is confusing to use prop contents in a storageunit which is
	// not the primary storageunit of the part
	// $$$$$ also, the type should be something DrawPart specific, not kODStrongStorageUnitRef
	// since it is storing StorageUnitRefs and xforms in the same stream.

	_fTestDrawSU->AddProperty(ev, kODPropBGColor)->AddValue(ev, kODUShort);			

	/* Update the cached presentation           						//OLE2
	 */																	//OLE2
	somSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);	//OLE2

#endif //PLATFORM_WINDOWS
}

SOM_Scope void  SOMLINK AppleTestDraw_DrawPartInitPartFromStorage(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
	 AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","InitPartFromStorage");

	if (somSelf->IsInitialized(ev))
		return;
	
	somSelf->InitPersistentObjectFromStorage(ev, storageUnit);
	
	_fPartWrapper = partWrapper;
	
	somSelf->CommonInitDrawPart(ev);
	

	ODStorageUnit* su;
	ODStorageUnitRef aSURef;
	ODFrame* frame;
	ODShape* newShape;
	ODULong offset, offsetLimit;
	ODRgnHandle newRegion;
	Point xform;
	ODTransform* transform;
  	ODUShort tempshort;

ODUnused(newRegion);
// $$$$$ OBSOLETE: Volatile(frame);

	su = somSelf->GetStorageUnit(ev);
	su->Focus(ev, kODPropContents,kODPosSame,kKindTestDraw,1,kODPosFirstSib);
	su->GetValue(ev, sizeof(ODStorageUnitRef),&aSURef);
	_fTestDrawSU = su->GetDraft(ev)->GetStorageUnit(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
	su = _fTestDrawSU;

	su->Focus(ev, kODPropDisplayFrames, kODPosSame, 0, 1, kODPosFirstSib);
	offsetLimit = su->GetSize(ev);
	for (offset = 0; offset < offsetLimit; offset += sizeof(ODStorageUnitRef))
	{
		su->SetOffset(ev, offset);
		su->GetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
		
		if (su->IsValidStorageUnitRef(ev, aSURef)) {		
			frame = su->GetDraft(ev)->GetFrame(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
			_fDisplayFrames->AddLast((ElementType)frame);
			frame->SetDroppable(ev, kODTrue);
		}
		else {		
			frame = kODNULL;
		}
	}

	su->Focus(ev, kODPropFrameGroup,kODPosSame,0,1,kODPosFirstSib);
	su->GetValue(ev, sizeof(_fFrameGroupIDCounter),(ODValue)&_fFrameGroupIDCounter);
	
	// todo: this if is a temp workaround; MAC files don't have this property currently.
	if (su->Exists(ev, kODPropBGColor, kODUShort, 0))
	{
		su->Focus(ev, kODPropBGColor,kODPosSame,0,1,kODPosFirstSib);
		su->GetValue(ev, sizeof(_fDefaultColor),(ODValue)&_fDefaultColor);
	} else
	{
		// property doesn't exist, use default
		if (_fDefaultColor > IDM_RED + 5)
			_fDefaultColor = IDM_RED;
		else
			_fDefaultColor++;
	}
	
	su->Focus(ev, kODPropContents,kODPosSame,0,1,kODPosFirstSib);
	offsetLimit = su->GetSize(ev);
#ifdef WINDOWS_CODE
	newShape = new ODShape();
#endif
	newShape = kODNULL;
	for (offset = 0; offset < offsetLimit;)
	{
		su->SetOffset(ev, offset);
		su->GetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
		offset += sizeof(ODStorageUnitRef);
		frame = su->GetDraft(ev)->GetFrame(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
		_fEmbeddedFrames->AddLast((ElementType)frame);

#ifdef WINDOWS_CODE
		// dkf: Apple is writing this data out from a native "point",
		//  which on a big-endian machine turns out to be first Y, then
		//  X, with each member being big-endian.
		su->SetOffset(offset);
		su->GetValue(sizeof(tempshort), (ODValue)&tempshort);
		xform.y = ODMoveFileShort(tempshort);
		su->GetValue(sizeof(tempshort), (ODValue)&tempshort);
		xform.x = ODMoveFileShort(tempshort);
		offset += 2 * sizeof(tempshort);
		transform = new ODTransform;
		transform->SetWinOffset(xform);
//bgn<<<<<<<<<<  \od\port\merge\src\drawpart.cpp
//bgn		transform->SetPlatformTransform(kODWindows, xform);
//bgn==========
#endif

		su->SetOffset(ev, offset);
		su->GetValue(ev, sizeof(ODPlatformTransform), (ODValue)&xform);
		offset += sizeof(Point);
		transform = frame->CreateTransform(ev)->SetWinOffset(ev, &xform);
		
		ODShape* frameShape = frame->GetFrameShape(ev, kODNULL);
		if( newShape )
			newShape->CopyFrom(ev, frameShape);
		else
			newShape = frameShape->Copy(ev);
		frameShape->Release(ev); frameShape = kODNULL;
		newShape->Transform(ev, transform);
		ODRgnHandle newRegion = newShape->CopyWinRegion(ev);
		_fContents->AddLast((ElementType)(new Proxy(newRegion, frame, transform)));
	}
	if (newShape) newShape->Release(ev);
		newShape = kODNULL;
}

//  ValueOnClipboard 

ODBoolean ValueOnClipboard(Environment* ev, ODSession* session)
{
	ODBoolean		result = kODFalse;
	ODClipboard*	clipboard = session->GetClipboard(ev);

	TRY
		ODStorageUnit* su = clipboard->GetContentStorageUnit(ev);
		result =  su->Exists(ev, kODPropContentFrame, kODNULL, 0);
	CATCH_ALL
	ENDTRY

	return result;
}

//------------------------------------------------------------------------------
// DrawPart::HasExtension
//------------------------------------------------------------------------------

SOM_Scope ODBoolean	 SOMLINK AppleTestDraw_DrawPartHasExtension(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODType extensionName)
{
//	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	 AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","HasExtension");

	LPSTR	shadowWindow = "WindowsShadowWindow";
	LPSTR	semtIntf = "SemanticInterface";

	if (!lstrcmpi((LPSTR)extensionName, (LPSTR)shadowWindow))
		return kODTrue;
//BGNBP
//skn	else if (!lstrcmpi((LPSTR)extensionName, (LPSTR)semtIntf))
//skn		return kODTrue;
	else
		return kODFalse;
}


//------------------------------------------------------------------------------
// DrawPart::GetExtension
//------------------------------------------------------------------------------

SOM_Scope ODExtension*	 SOMLINK AppleTestDraw_DrawPartGetExtension(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODType extensionName)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetExtension");

	LPSTR	shadowWindow = "WindowsShadowWindow";
	LPSTR	semtIntf = "SemanticInterface";

	if (!lstrcmpi((LPSTR)extensionName, (LPSTR)shadowWindow))
		return (ODExtension*)&_fShadowWindow;
//skn	else if (!lstrcmpi((LPSTR)extensionName, (LPSTR)kODExtSemanticInterface))
//skn		return _fSemtIntf;
	else
		return (ODExtension*)kODNULL;
}

#undef VARIABLE_MACROS

SOM_Scope ODPlatformWindow	 SOMLINK AppleTestDraw_DrawPartCreateShadowWindow(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame,
		ODPlatformWindow hParent)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	WNDCLASS  wc;

#ifdef WIN32
	if (!GetClassInfo((HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE), "ShadowWindow", &wc)) {
#else			
	if (!GetClassInfo(GetWindowWord (hParent, GWW_HINSTANCE), "ShadowWindow", &wc)) {
#endif			
		wc.style	        = CS_DBLCLKS;
		wc.lpfnWndProc   = ShadowWindowProc;			// exported static member of ODShell
		wc.cbClsExtra    = 0;
		wc.cbWndExtra    = 4;
#ifdef WIN32
		wc.hInstance     = (HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE);
#else
		wc.hInstance     = GetWindowWord (hParent, GWW_HINSTANCE);
#endif		
		wc.hIcon	     = NULL;
		wc.hCursor	     = LoadCursor(NULL,IDC_ARROW);
		wc.hbrBackground = NULL;
		wc.lpszMenuName  = NULL;
		wc.lpszClassName = "ShadowWindow";

		if (!RegisterClass (&wc) )
			return (HWND)kODFalse;
	}

#ifdef WIN32
	_fShadowWindow = CreateWindowEx (WS_EX_TRANSPARENT, "ShadowWindow", "", WS_CHILD | WS_VISIBLE,
		0, 0, 0, 0, hParent, NULL, (HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE), NULL);
#else
	fShadowWindow = CreateWindowEx (WS_EX_TRANSPARENT, "ShadowWindow", "", WS_CHILD | WS_VISIBLE,
		0, 0, 0, 0, hParent, NULL, GetWindowWord (hParent, GWW_HINSTANCE), NULL);
#endif

	if (_fShadowWindow) {

		SetWindowLong (_fShadowWindow, 0, (LONG)somSelf);

	}
	
	return _fShadowWindow;
}

SOM_Scope void	 SOMLINK AppleTestDraw_DrawPartCreateEmbedControl(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","EmbedControl");
//bgnVOID DrawPart::EmbedControl()
//bgn{
	RECT rc;

	GetClientRect (_fShadowWindow, &rc);
#ifdef WIN32
	CreateWindow ("ScrollBar", "", WS_CHILD | WS_VISIBLE | SBS_VERT,
		rc.right - GetSystemMetrics(SM_CXVSCROLL), rc.top,
		GetSystemMetrics(SM_CXVSCROLL), rc.bottom, _fShadowWindow, (HMENU)100,
		(HINSTANCE)GetWindowLong (_fShadowWindow, GWL_HINSTANCE), NULL);
#else
	::CreateWindow ("ScrollBar", "", WS_CHILD | WS_VISIBLE | SBS_VERT,
		rc.right - GetSystemMetrics(SM_CXVSCROLL), rc.top,
		GetSystemMetrics(SM_CXVSCROLL), rc.bottom, fShadowWindow, 100,
		GetWindowWord (fShadowWindow, GWW_HINSTANCE), NULL);
#endif
}

SOM_Scope void	 SOMLINK AppleTestDraw_DrawPartMoveSizeShadowWindow(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame* frame)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	HWND		hwndMove;

	if (_fShadowWindow) {
		ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
		ODShape *ActiveShape = facets->First(ev)->GetActiveShape(ev, kODNULL);
		ODShape* tempShape = (ODShape*) ActiveShape->Copy(ev);
		ODReleaseObject (ev, ActiveShape);

		if (facets->First(ev)->GetWindow(ev)->GetPlatformWindow(ev) == GetParent(_fShadowWindow)){
			ODTransform *wcTrans = facets->First(ev)->GetWindowContentTransform(ev, kODNULL);
			tempShape->Transform(ev, wcTrans);
			ODReleaseObject(ev, wcTrans);
		}
		else{
			ODTransform *xTrans = facets->First(ev)->GetExternalTransform(ev, kODNULL);
			ODTransform *newTrans = xTrans->Copy(ev);
			// Get the scale from the Root Facet
			ODTransform *scaleTrans = facets->First(ev)->GetWindow(ev)
										->GetRootFacet(ev)->GetExternalTransform(ev, kODNULL);
			newTrans = newTrans->PostCompose(ev, scaleTrans);
			tempShape->Transform(ev, newTrans);
			ODReleaseObject(ev, scaleTrans);
			ODReleaseObject(ev, xTrans);
			ODReleaseObject(ev, newTrans);
		}

		RECT rc;
		GetRgnBox (	tempShape->GetWinRegion(ev), &rc);
		MoveWindow (_fShadowWindow, rc.left, rc.top,
			rc.right - rc.left, rc.bottom - rc.top, TRUE);
		ODReleaseObject(ev, tempShape);
		delete facets;
		GetClientRect (_fShadowWindow, &rc);

		hwndMove	= GetDlgItem(_fShadowWindow,100);
		if(hwndMove)
			MoveWindow (hwndMove, rc.right - GetSystemMetrics(SM_CXVSCROLL), rc.top,
						GetSystemMetrics(SM_CXVSCROLL), rc.bottom, TRUE);
	}
}

LRESULT CALLBACK ShadowWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	ODEventData event;
	AppleTestDraw_DrawPart *part;
	OrderedCollection *frames;
	ODFrameFacetIterator* facets;
							
	switch (message) {

		case WM_NCHITTEST:
			return HTTRANSPARENT;
			break;

		case WM_COMMAND:
		case WM_VSCROLL:
			{
			Environment *ev = somGetGlobalEnvironment();
			part = (AppleTestDraw_DrawPart*)GetWindowLong (hWnd, 0);
			frames = part->GetDisplayFrames(ev);
			facets = ((ODFrame*)frames->First())->CreateFacetIterator(ev);
			
			part->ActivateFrame(ev, (ODFrame *)frames->First());
			
			event.message = message;
			event.wParam = wParam;
			event.lParam = lParam;
			part->HandleEvent (ev, &event, (ODFrame *)frames->First(), facets->First(ev));
			delete facets;
			}
			break;
	}
	
	return (DefWindowProc(hWnd, message, wParam, lParam));
}

#ifdef LATER
/* FUNCTION: WaitMouseMoved
 *
 * DESCRIPTION:
 *   Wait till we get a mousebutton up or mouse move event so we know if this
 *   is a selection, dragging or set-the-cursor type of mouse click !
 */
BOOL WaitMouseMoved(
	HWND    hwnd)
{
	MSG             event;
	BOOL    bMoved          = FALSE;
	DWORD   InitialTick     = GetTickCount();

	/* Don't capture the mouse if we're minimized!
	 */
	if(IsIconic(hwnd))
		return FALSE;

	SetCapture(hwnd);
	do
	{
		GetMessage(&event,NULL,NULL,NULL);
		TranslateMessage(&event);    // Translates virtual key codes
		DispatchMessage(&event);     // Dispatches message to window
	
		if (  (event.message == WM_LBUTTONUP)
			|| (event.message == WM_RBUTTONUP)
			|| (event.message == WM_LBUTTONDOWN)
			|| (event.message == WM_RBUTTONDOWN)
			|| (event.message == WM_CHAR)
			|| (GetTickCount() < InitialTick)
			|| (GetTickCount() > InitialTick+300)
			)
			break;
		else if (event.message == WM_MOUSEMOVE)
			bMoved  = TRUE;
	} while(!bMoved);
	ReleaseCapture();

	/* Don't return TRUE if the mouse button is not really down !
	 */
	if (  (GetKeyState(VK_LBUTTON) < 0)
	   || (GetKeyState(VK_RBUTTON) < 0)
	   )
		return  bMoved;
	else
		return	FALSE;
}
#endif //LATER


// DrawPart::AddPartsToMenu
//
// Using the Part Registry Iterator, add registered parts to a given menu
//  with tokens assigned to each part starting at 'firstToken'.
// In:	hMenu - the menu to add the part list to
//      firstToken - the token ID to assign to the first part in the list.
//					 Subsequent parts are numbered firstToken + 1, firstToken + 2, ...

SOM_Scope ODULong SOMLINK AppleTestDraw_DrawPartAddPartsToMenu(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODPlatformMenu hMenu,
		ODULong	firstToken)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","AddPartsToMenu");

//bgnUINT DrawPart::AddPartsToMenu(HMENU hMenu, UINT firstToken)
//bgn{

	ODPartRegistryIterator	iter;
	ODPartRegistryData		data;
	char 							partString[50];
	LPSTR							partPtr, tmpPtr;

//TAG - the assumption here is that firstToken is always IDM_PART...
	for (iter.First(kODTrue,&data);iter.IsNotComplete();iter.Next(&data)) {
		_fPartCount++;

//TAG - Clear the string of any "Apple" references.
		strcpy(partPtr=partString, data.partKind);
		if (tmpPtr = strtok(partPtr,":"))
			while (NULL != (tmpPtr = strtok(NULL,":")))
				{
		       partPtr = tmpPtr;
				}

		AppendMenu(hMenu.menu, MF_STRING | MF_ENABLED,
					(firstToken + _fPartCount), partPtr);
		strcpy (_typePtr[_fPartCount]=&(_typeString[_fStringIndex]), data.partKind);
		_fStringIndex += strlen(_typePtr[_fPartCount]) + 1;
	}
	return firstToken + _fPartCount;
}


#ifdef LATER
struct SetBGColorRec
{
	SetBGColorRec(ODRGBColor oldColor, ODRGBColor newColor, ODFrame* frame)
					{fOldColor = oldColor; fNewColor = newColor;
						fFrame = frame;}
	ODRGBColor 	fOldColor;
	ODRGBColor 	fNewColor;
	ODFrame*	fFrame;
};
#endif

//  UserSetBGColor 

SOM_Scope void SOMLINK AppleTestDraw_DrawPartUserSetBGColor2(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame *frame,
		ODULong whichColor)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","UserSetBGColor");

//bgnvoid DrawPart::UserSetBGColor(ODFrame* frame, ODRGBColor whichColor)
//bgn{
BGNBP
#ifdef LATER
	PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo();
	if (!pInfo)
	{	pInfo = new PartInfoRec;
		frame->SetPartInfo((ODInfoType) pInfo);
	}
	if (!RGBEqual(whichColor,pInfo->bgColor))
	{
		ODIText*	undoActionName;
		ODIText*	redoActionName;
	
//bgn>>>>>>>>>>  \od\port\new\src\drawpart.cpp
//bgn		undoActionName = PStrToIntl("\pUndo Set Color", kODNULL );
//bgn		redoActionName = PStrToIntl("\pRedo Set Color", kODNULL );
//bgn		SetBGColorRec* undoRec = new SetBGColorRec(pInfo->bgColor, whichColor,
//bgn													frame);
//bgn		fSession->GetUndo()->AddActionToHistory(this, (ODActionData)undoRec,
//bgn												kODSingleAction,
//bgn												(ODName*)undoActionName,
//bgn												(ODName*)redoActionName);
//bgn<<<<<<<<<<  \od\port\merge\src\drawpart.cpp
//bgn==========
		somSelf->SetBGColor(frame, whichColor);
	}
	frame->Invalidate(NULL);
#endif
}

#ifdef LATER
//  SetBGColor 

SOM_Scope void SOMLINK AppleTestDraw_DrawPartSetBGColor(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODFrame *frame,
		ODRGBColor whichColor)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","SetBGColor");

//bgnvoid DrawPart::SetBGColor(ODFrame* frame, ODRGBColor whichColor)
//bgn{
	PartInfoRec* pInfo = (PartInfoRec *) frame->GetPartInfo();
	if (!pInfo)
	{	pInfo = new PartInfoRec;
		frame->SetPartInfo((ODInfoType) pInfo);
	}
	if (!RGBEqual(whichColor,pInfo->bgColor))
	{
		pInfo->bgColor = whichColor;
		somSelf->GetStorageUnit()->GetDraft()->SetChangedFromPrev();
		// OLE: note that SetChangedFromPrev also updates cached
		// image when running in OLE container applications

		frame->Invalidate(NULL);
	}
}
#endif

#ifdef LATER
SOM_Scope void SOMLINK AppleTestDraw_DrawPartGetBGColor(AppleTestDraw_DrawPart *somSelf, Environment *ev,
		ODUShort whichColor,
		ODULong *newColor)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
    AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetBGColor");

//bgnvoid DrawPart::GetBGColor(ODUShort whichColor, ODRGBColor* newColor)
//bgn{
	switch (whichColor)
	{
		case  kGray: *newColor = rgbGray;		break;
		case  kRed: *newColor = rgbRed;		break;
		case  kGreen: *newColor = rgbGreen;		break;
		case  kYellow: *newColor = rgbYellow;	break;
		case  kBlue: *newColor = rgbBlue;		break;
		case  kMagenta: *newColor = rgbMagenta;	break;
		case  kCyan: *newColor = rgbCyan;		break;
		case  kWhite: *newColor = rgbWhite;		break;

		default:
//BGNBP//bgn			WASSERTM(kODFalse, "No such color.");
			break;
	}
}
#endif


ODHandle DPCopyHandle (ODHandle handle)
{
   ODHandle NewRgn = CreateRectRgn(0,0,0,0);

   CombineRgn (NewRgn, handle, NewRgn, RGN_COPY);

   return NewRgn;
}

/* FUNCTION: WaitMouseMoved
 *
 * DESCRIPTION:
 *   Wait till we get a mousebutton up or mouse move event so we know if this
 *   is a selection, dragging or set-the-cursor type of mouse click !
 */
BOOL WaitMouseMoved(
	HWND    hwnd)
{
	MSG             event;
	BOOL    bMoved          = FALSE;
	DWORD   InitialTick     = GetTickCount();

	/* Don't capture the mouse if we're minimized!
	 */
	if(IsIconic(hwnd))
		return FALSE;

	SetCapture(hwnd);
	do
	{
		GetMessage(&event,NULL,NULL,NULL);
		TranslateMessage(&event);    // Translates virtual key codes
		DispatchMessage(&event);     // Dispatches message to window
	
		if (  (event.message == WM_LBUTTONUP)
			|| (event.message == WM_RBUTTONUP)
			|| (event.message == WM_LBUTTONDOWN)
			|| (event.message == WM_RBUTTONDOWN)
			|| (event.message == WM_CHAR)
			|| (GetTickCount() < InitialTick)
			|| (GetTickCount() > InitialTick+300)
			)
			break;
		else if (event.message == WM_MOUSEMOVE)
			bMoved  = TRUE;
	} while(!bMoved);
	ReleaseCapture();

	/* Don't return TRUE if the mouse button is not really down !
	 */
	if (  (GetKeyState(VK_LBUTTON) < 0)
	   || (GetKeyState(VK_RBUTTON) < 0)
	   )
		return  bMoved;
	else
		return	FALSE;
}

/* METHOD: DrawTarget
 *
 * DESCRIPTION:
 *   Draw target emphasis on this part during a drag-drop operation. We use
 *   a 4 pel border to indicate that we are a drop-target.
 */
SOM_Scope void SOMLINK AppleTestDraw_DrawPartDrawTarget(				//OLE2
	AppleTestDraw_DrawPart	*somSelf,
	Environment				*ev,
	ODFacet					*facet)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","DrawTarget");
	ODShape		*updateShape, *clipShape;
	HRGN		hrgnOuter,hrgnInner;
	RECT		rect;
	
	/* Get our border rectangle
	 */
	clipShape = facet->GetActiveShape(ev,kODNULL)->Copy(ev);
	clipShape->SetGeometryMode(ev, kODLoseGeometry);
	ODTransform *frameTrans = facet->GetFrameTransform(ev,kODNULL);
	clipShape->Transform(ev,frameTrans);
	ODReleaseObject(ev, frameTrans);

	ODShape *scratch = (ODShape*) clipShape->Copy(ev);
				
	scratch->Outset(ev, (ODCoordinate)((-5) << 16));
	clipShape->Subtract(ev, scratch);
				
	ODShape *adjusted = clipShape->Copy(ev);
	facet->Update(ev,adjusted,kODNULL);

	ODReleaseObject(ev, clipShape);
	ODReleaseObject(ev, scratch);
	ODReleaseObject(ev, adjusted);
}

/* METHOD: GetActiveTool
 *
 * DESCRIPTION:
 *   Retrieve the current active tool in palette.
 */
SOM_Scope ODULong SOMLINK AppleTestDraw_DrawPartGetActiveTool(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetActiveTool");

	if (_fPalette) {
		DrawPaletteExt*	aDrawPaletteExt = somSelf->GetDrawPaletteExt(ev);
		if (aDrawPaletteExt) {
			for (ODULong tmpTool = aDrawPaletteExt->GetFirstTool(ev); tmpTool != (ODULong)kODNULL; 
							tmpTool = aDrawPaletteExt->GetNextTool(ev, tmpTool)) {
				if (aDrawPaletteExt->GetToolState(ev, tmpTool) == kDrawToolStateOn) {
					return(tmpTool);
				}		
			}
		}
	}

	return((ODULong)kODNULL);
}

/* METHOD: PtInDrawShape
 *
 * DESCRIPTION:
 *   DrawShape hit test.
 */
SOM_Scope DrawShape* SOMLINK AppleTestDraw_DrawPartPtInDrawShape(AppleTestDraw_DrawPart *somSelf, Environment *ev,
								ODPoint* aPnt)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","PtInDrawShape");

	if (_fShapes != kODNULL) {
		OrderedCollectionIterator	shapesIter(_fShapes);
		DrawShape*					aShape;

		for (aShape = (DrawShape*)shapesIter.Last(); shapesIter.IsNotComplete();
			aShape = (DrawShape*)shapesIter.Previous()) {
			if (aShape->ContainsPoint(aPnt)) {
				return(aShape);
			}
		}
	}

	return(kODNULL);
}

/* METHOD: GetSelectedShape
 *
 * DESCRIPTION:
 *   Retrieve the selected shape.
 */
SOM_Scope DrawShape* SOMLINK AppleTestDraw_DrawPartGetSelectedShape(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetSelectedShape");

	if (_fShapes != kODNULL) {
		OrderedCollectionIterator	shapesIter(_fShapes);
		DrawShape*					aShape;

		for (aShape = (DrawShape*)shapesIter.First(); shapesIter.IsNotComplete();
			aShape = (DrawShape*)shapesIter.Next()) {
			if (aShape->GetSelected()) {
				return(aShape);
			}
		}
	}

	return(kODNULL);
}

/* METHOD: GetDrawPaletteExt
 *
 * DESCRIPTION:
 *   Retrieve the DrawPalette extension.
 */
SOM_Scope DrawPaletteExt* SOMLINK AppleTestDraw_DrawPartGetDrawPaletteExt(AppleTestDraw_DrawPart *somSelf, Environment *ev)
{
	AppleTestDraw_DrawPartData *somThis = AppleTestDraw_DrawPartGetData(somSelf);
	AppleTestDraw_DrawPartMethodDebug("AppleTestDraw_DrawPart","GetDrawPaletteExt");

	if (!_fPalette) {
		return(kODNULL);
	}

	if (!_fPalette->HasExtension(ev, kDrawPaletteExt)) {
		return(kODNULL);
	}

	return((DrawPaletteExt*)_fPalette->GetExtension(ev, kDrawPaletteExt));
}

