/*
	File:		DrawObj.cpp

	Contains:	Object accessor implementation for the AppleTestDraw_DrawPart

	Written by:	Caia Grisar

	Copyright:	c 1993 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <8>	 10/6/94	JBS		1188214: use refcounted Shape & Transform
		 <7>	 9/29/94	RA		1189812: Mods for 68K build.
		 <6>	 9/23/94	NP		1185420. Fixed a few problems, some of
									which I had probably introduced before.
		 <5>	 9/22/94	JBS		1188214: coordinate bias implementation
		 <4>	 9/15/94	NP		1186778: Changed token handling code.
		 <3>	  9/9/94	NP		1185851: implement scripting.
		 <2>	  9/8/94	NP		Backed off of a change until SE is working.
		 <1>	 8/30/94	NP		first checked in
		<11>	 5/27/94	jpa		Support new exceptions [1165267]
		<10>	  4/6/94	JBS		1155477
		 <9>	 3/28/94	CG		1153547: include ODSessM.h instead of
									ODSessn.h.
		 <8>	 3/26/94	NP		1153509. Messaging not PowerPC ready.
		 <7>	 3/26/94	NP		1153053.
		 <6>	 3/25/94	JA		JPA: GetPlatformTransform -> GetQDOffset
									(1153438). JBS: Changed API of
									CreateEmbeddedFrameIterator, CanvasChanged
									(1153056, 1153059).
		 <5>	 3/25/94	MB		Symantec ASLM fixes. #1150864
		 <4>	 3/25/94	eeh		bug #1153053: Changes for PPC nativity
		 <3>	 3/15/94	MB		Changes to support SCpp/ASLM builds,
									#1150864.
		 <2>	 2/16/94	JA		Include new AltPoint.h.
		<21>	  2/8/94	JA		Added missing #includes.
		<20>	  2/8/94	T		Throw -> THROW & some code clean up
		<19>	  2/7/94	JA		Utility.h --> ODUtils.h
		<18>	  2/7/94	T		fixes to compile with PPC Headers
		<17>	  2/2/94	JBS		new AddDisplayFrame recipie
		<16>	 1/31/94	NP		Fixed coercion handler to conform to new
									interface.
		<15>	 1/28/94	NP		Fixed include statements.
		<14>	 1/17/94	NP		Removed consts from public API.
		<13>	 1/17/94	NP		Semantic Events callbacks API changes.
		<12>	 1/14/94	NP		Removed CreateObjSpecifier (it's already in
									OpenDoc) and fixed some include statements.
		<11>	 1/11/94	eeh		removed "frame" from objspec vocab; work on
									Move event and bounds property (not done)
		<10>	12/20/93	NP		Changed calls to CreateSwapToken.
		 <9>	12/17/93	eeh		object accessors for frames
		 <8>	12/15/93	NP		CreatePartToken -> CreateSwapToken.
		 <7>	 12/9/93	SS		Compiler conditional #include
		 <6>	 12/9/93	eeh		implement CreateNewPart,
									CreatePartObjectSpec, and SetNewBounds,
									helpers, and general support for scripting,
									esp the make event
		 <5>	 12/3/93	T		Stop including ODError.h, it is included
									as ErrorDef.h inside Except.h
		 <4>	 12/1/93	CG		bug fix.
		 <3>	 12/1/93	CG		Added CreateNewPart, CreatePartObjectSpec,
									GetPropertyFromPart,GetPartFromPart,
									updated HandleGetData and HandleSetData.
		 <2>	11/30/93	JA		Rearranged #includes for new "frame"
									constant fix.
		 <1>	11/16/93	CG		first checked in
	To Do:
*/

#ifndef _ALTPOINT_
#include "AltPoint.h"			// Use C++ savvy ODPoint and ODRect
#endif


//#ifndef _PLFMTYPE_
//#include "PlfmType.h"
//#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

#ifndef _DRAWOBJ_
#include "DrawObj.h"
#endif

#ifndef _PRTPRPAC_
#include "PrtPrpAc.h"
#endif

//#ifndef _DFRMITER_
//#include "DFrmIter.h"
//#endif

#ifndef SOM_DrawEmbeddedFramesIterator_xh
#include "DrwEmFrI.xh"
#endif

#ifndef SOM_ODDraft_xh
#include "Draft.xh"
#endif

#ifndef SOM_Module_AppleTestDraw_defined
#include "DrawPart.xh"
#endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifndef SOM_ODFacet_xh
#include "Facet.xh"
#endif

#ifndef SOM_ODFrame_xh
#include "Frame.xh"
#endif

#ifndef __LIMITS__
#include <limits.h>
#endif

#ifndef SOM_ODNameResolver_xh
#include "NamRslvr.xh"
#endif

#ifndef SOM_ODPart_xh
#include "Part.xh"
#endif

#ifndef SOM_ODSemanticInterface_xh
#include "SemtIntf.xh"
#endif

#ifndef _SIHELPER_
#include "SIHelper.h"
#endif

#ifndef SOM_ODSession_xh
#include "ODSessn.xh"
#endif

#ifndef _SEUTILS_
#include "SEUtils.h"
#endif

#ifndef SOM_ODShape_xh
#include "Shape.xh"
#endif

#ifndef SOM_ODStorageUnit_xh
#include "StorageU.xh"
#endif

#ifndef SOM_ODTransform_xh
#include "Trnsform.xh"
#endif

#ifndef SOM_ODMessageInterface_xh
#include "MssgIntf.xh"
#endif

#ifndef SOM_ODFrameFacetIterator_xh
#include "FrFaItr.xh"
#endif

#ifndef _ODUTILS_
#include "ODUtils.h"
#endif

#ifndef __AEOBJECTS__
#include <AEObjects.h>
#endif

#ifndef __AEPACKOBJECT__
#include <AEPackObject.h>
#endif

#ifndef __AEREGISTRY__
#include <AERegistry.h>
#endif

#ifndef __TEXTUTILS__
#include <TextUtils.h>
#endif

#include <string.h>

#pragma segment DrawObj


//==============================================================================
// Function prototypes
//==============================================================================

static void MoveFacetTransform(ODFacet* facet, Point* desiredLocation,
		ODPart* part);

//------------------------------------------------------------------------------
// CreatePartObjectSpec
//------------------------------------------------------------------------------

static void CreatePartObjectSpec(DescType keyForm, AEDesc* containerObjSpec,
		AEDesc *objectSpec)
{
	// We'll really return a spec to the FRAME containing the part.
	// This cause you can get to the part from the frame, but not the other
	// way 'round.
	
	AEDesc keyData;
	
	switch(keyForm)
	{
		case formAbsolutePosition :
			long index = 1;			// <eeh> we should figure out where
			THROW_IF_ERROR(AECreateDesc(typeLongInteger, &index, sizeof(index),
					&keyData));
			break;
		default :
			ASSERTM(false, -1, "Can't handle that form!!! (yet)");
	}

	CreateObjSpecifier(cPart, containerObjSpec, keyForm, &keyData, true,
			objectSpec);
}	// CreatePartObjectSpec()



//------------------------------------------------------------------------------
// GetPropertyFromNULL
//------------------------------------------------------------------------------

ODError GetPropertyFromNULL(ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
ODUnused(desiredClass);
ODUnused(container);
ODUnused(containerClass);

	Environment*			ev = somGetGlobalEnvironment();
	ODSession*				session = (ODSession*)refCon;
	ODNameResolver*		resolver = session->GetNameResolver(ev);
	DescType				propID;
	DrawPartPropAccessor*	accessorObj;
	ODError	error = noErr;

	TRY

	if (form != formPropertyID)
		THROW(errAEWrongDataType);

	switch(propID = **(DescType**)(selectionData->dataHandle))
	{
//		case pBounds:
		case pColor:
		case pName:
			resolver->CreateToken(ev, value, cProperty, thisPart);
			accessorObj = new DrawPartPropAccessor(propID, (AppleTestDraw_DrawPart*)thisPart);
			AllocAndStuff1st4Bytes(value, (ODULong)accessorObj);
			break;
		default:
			THROW(errAECantSupplyType);
			break;
	}
	
	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
}	// GetPropertyFromNULL()



//------------------------------------------------------------------------------
// GetPartFromNULL
//------------------------------------------------------------------------------

ODError GetPartFromNULL(ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
	ODUnused(desiredClass);
	ODUnused(container);
	ODUnused(containerClass);

	Environment*		ev = somGetGlobalEnvironment();
	ODSession*				session = (ODSession*)refCon;
	ODNameResolver*		resolver = session->GetNameResolver(ev);
	ODSLong				partCount;
	ODSLong				theIndex;
	ODBoolean				allFlag;
	ODBoolean				zeroFlag;
	ODError				result;
	ODUShort 				i;
//	ODPart* 				theEmbeddedPart;
	ODFrame* 				frame;
	ODOSLToken				listItem;
	ODError				error = noErr;

	TRY

	partCount = (((AppleTestDraw_DrawPart*)thisPart)->GetEmbeddedFrames(ev))->Count();
	
	if (partCount != 0)
	{
		switch (form)
		{
			case formAbsolutePosition:
					// Are we being asked for and indexed part
					// or for all parts?
				result = DecodeOrdinal(*selectionData, (long)partCount, 
								(long*)&theIndex, (Boolean*)&allFlag, (Boolean*)&zeroFlag);
				THROW_IF_ERROR(result);
				
				if (allFlag)
				{
					result = AECreateList(kODNULL, 0, kODFalse, (AEDesc*)value);
					THROW_IF_ERROR(result);
		
						// Get theEmbeddedPart number theIndex
					DrawEmbeddedFramesIterator* iter = 
							(DrawEmbeddedFramesIterator*)thisPart->CreateEmbeddedFramesIterator(ev, kODNULL);
					for (frame = iter->First(ev), i=1; iter->IsNotComplete(ev); frame = iter->Next(ev), i++)
					{	
//						theEmbeddedPart = frame ? frame->GetPart() : (ODPart*)kODNULL;
						
						if (frame)
						{
							resolver->CreateToken(ev, &listItem, cPart, thisPart);
//							ReallocAndStuff2nd4Bytes(&listItem, (ODULong)frame);
							AllocAndStuff1st4Bytes(&listItem, (ODULong)frame);
						
							result = AEPutDesc((AEDesc*)value, i, (AEDesc*)&listItem);
							THROW_IF_ERROR(result);
							
							result = AEDisposeDesc((AEDesc*)&listItem);
							THROW_IF_ERROR(result);
						}
					}
				}
				else
				{
						// Get theEmbeddedPart number theIndex
					DrawEmbeddedFramesIterator* iter = 
							(DrawEmbeddedFramesIterator*)thisPart->CreateEmbeddedFramesIterator(ev, kODNULL);
					for (frame = iter->First(ev), i=1; iter->IsNotComplete(ev); frame = iter->Next(ev), i++)
					{	
						if (i == theIndex)
						{
					//		theEmbeddedPart = frame ? frame->GetPart() : (ODPart*)kODNULL;
							break;
						}
					}
					
					if (frame)
					{
						resolver->CreateToken(ev, value, cPart, thisPart);
//						ReallocAndStuff2nd4Bytes(value, (ODULong)frame);
						AllocAndStuff1st4Bytes(value, (ODULong)frame);
					}
					else
						THROW(errAENoSuchObject);
				}
				break;
			default:
				THROW(errAENoSuchObject);
				break;
		}
	}
	else
		THROW(errAENoSuchObject);
	
	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
}	// GetPartFromNULL()


//------------------------------------------------------------------------------
// GetPartFromFrame
//------------------------------------------------------------------------------

static void GetPartFromFrame(	ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
	ODUnused(thisPart);
	ODUnused(desiredClass);
	ODUnused(containerClass);
	ODUnused(form);
	ODUnused(selectionData);

	Environment*	ev = somGetGlobalEnvironment();

	// Here I'm ASSUMING Part 1 of frame.  Nothing else will work just now.
	
	
	// A part is represented by its frame, as you can
	// always get the part when you need it.  Leave it that way until
	// the swap (save that the "type" of the token needs to be changed.)
	
	ODFrame* theFrame = (ODFrame*)GetFirstFourBytesFromDataHandle(container);

	ODNameResolver* resolver = ((ODSession*)refCon)->GetNameResolver(ev);
	resolver->CreateToken(ev, value, cPart, thisPart);
	AllocAndStuff1st4Bytes(value, (ODULong)theFrame);
//	ReallocAndStuff2nd4Bytes(value, (ODULong)theFrame);

}	// GetPartFromFrame()


//------------------------------------------------------------------------------
// GetFrameFromNULL
//------------------------------------------------------------------------------

#ifdef TO_BE_DELETED
static void GetFrameFromNULL(	ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
	ODUnused(desiredClass);
	ODUnused(container);
	ODUnused(containerClass);

	Environment*		ev = somGetGlobalEnvironment();
	ODSession*				session = (ODSession*)refCon;
	ODNameResolver*		resolver = session->GetNameResolver(ev);
	ODSLong				partCount;
	ODSLong				theIndex;
	ODBoolean				allFlag;
	ODBoolean				zeroFlag;
	ODError				result;
	ODUShort 				i;
//	ODPart* 				theEmbeddedPart;
	ODFrame* 				frame;
	ODOSLToken				listItem;

	partCount = ((AppleTestDraw_DrawPart*)thisPart)->CountEmbeddedFrames(ev);
	
	if (partCount != 0)
	{
		switch (form)
		{
			case formAbsolutePosition:
					// Are we being asked for an indexed frame
					// or for all parts?
				result = DecodeOrdinal((AEDesc)*selectionData, (long)partCount, 
								(long*)&theIndex, (Boolean*)&allFlag, (Boolean*)&zeroFlag);
				THROW_IF_ERROR(result);
				
				if (allFlag)
				{
					result = AECreateList(kODNULL, 0, kODFalse, (AEDesc*)value);
					THROW_IF_ERROR(result);
		
						// Get theEmbeddedPart number theIndex
					DrawEmbeddedFramesIterator* iter = 
							(DrawEmbeddedFramesIterator*)thisPart->CreateEmbeddedFramesIterator(ev, kODNULL);
					for (frame = iter->First(ev), i=1; iter->IsNotComplete(ev); frame = iter->Next(ev), i++)
					{	
						if (frame)
						{
							resolver->CreateToken(ev, &listItem, cFrame, thisPart);
							ReallocAndStuff2nd4Bytes(&listItem, (ODULong)frame);
						
							result = AEPutDesc((AEDesc*)value, i, (AEDesc*)&listItem);
							THROW_IF_ERROR(result);
							
							result = AEDisposeDesc((AEDesc*)&listItem);
							THROW_IF_ERROR(result);
						}
					}
				}
				else
				{
						// Get theEmbeddedPart number theIndex
					DrawEmbeddedFramesIterator* iter = 
							(DrawEmbeddedFramesIterator*)
							thisPart->CreateEmbeddedFramesIterator(ev, kODNULL);
					for (frame = iter->First(ev), i=1; iter->IsNotComplete(ev);
							frame = iter->Next(ev), i++)
					{	
						if (i == theIndex)
						{
							break;
						}
					}
					
					if (frame)
					{
						resolver->CreateToken(value, cFrame, thisPart);
						ReallocAndStuff2nd4Bytes(value, (ODULong)frame);
					}
					else
						THROW(errAENoSuchObject);
				}
				break;
			default:
				THROW(errAENoSuchObject);
				break;
		}
	}
	else
		THROW(errAENoSuchObject);
}	// GetFrameFromNULL()
#endif // TO_BE_DELETED


								
//------------------------------------------------------------------------------
// GetPropertyFromPart
//------------------------------------------------------------------------------

ODError GetPropertyFromPart(ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
ODUnused(desiredClass);
ODUnused(containerClass);

	Environment*	ev = somGetGlobalEnvironment();
	ODSession*			session = (ODSession*)refCon;
	ODNameResolver*	resolver = session->GetNameResolver(ev);
	DescType			propID;
	ODError			error = noErr;

	TRY

	if (form != formPropertyID)
		THROW(errAEWrongDataType);

	ODFrame* frame = (ODFrame*)GetFirstFourBytesFromDataHandle(container);

	propID = **(DescType**)(selectionData->dataHandle);
	switch (propID)
	{
 		case pTranslation:
		case pBounds:
		{
			resolver->CreateToken(ev, value, typeEmbededPartProp, thisPart);
			EmbeddedPartPropAccessor* accessorObj =
					new EmbeddedPartPropAccessor(propID, frame,
							(AppleTestDraw_DrawPart*)thisPart);
			AllocAndStuff1st4Bytes(value, (ODULong)accessorObj);
		}
		default:
		{
			break;
		}
	}

	resolver->CreateSwapToken(ev, value, frame);
	
	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
}	// GetPropertyFromPart()

//------------------------------------------------------------------------------
// GetWildcardFromPart
//------------------------------------------------------------------------------

ODError GetWildcardFromPart(ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
	ODUnused(thisPart);
	ODUnused(desiredClass);
	ODUnused(containerClass);
	ODUnused(form);
	ODUnused(selectionData);

	Environment*	ev = somGetGlobalEnvironment();
	ODError			error = noErr;

	TRY

	// we need to just return a switch here: we can't go into the part.
	ODNameResolver* resolver = ((ODSession*)refCon)->GetNameResolver(ev);

	// REMEMBER: I don't know what kind of part this is!
	ODFrame* frame = (ODFrame*)GetFirstFourBytesFromDataHandle(container);

	resolver->CreateSwapToken(ev, value, frame);
	
	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
}	// GetWildcardFromPart()

//------------------------------------------------------------------------------
// GetPropertyFromFrame
//------------------------------------------------------------------------------

#ifdef TO_BE_DELETED
static void GetPropertyFromFrame(ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
ODUnused(desiredClass);
ODUnused(containerClass);

	Environment*		ev = somGetGlobalEnvironment();
	ODSession*			session = (ODSession*)refCon;
	ODNameResolver*	resolver = session->GetNameResolver(ev);
	DescType			propID;
	FramePropAccessor*	accessorObj;

	if (form != formPropertyID)
		THROW(errAEWrongDataType);

	propID = **(DescType**)(selectionData->dataHandle);
	switch (propID)
	{
		case pBounds:
		{
			ODFrame* theFrame
					= (ODFrame*)GetSecondFourBytesFromDataHandle(container);
			resolver->CreateToken(ev, value, typeFrameProp, thisPart);
			accessorObj = new FramePropAccessor(propID, theFrame);
			ReallocAndStuff2nd4Bytes(value, (ODULong)accessorObj);
			break;
		}
		default:
		{
			THROW(errAENoSuchObject);
		}
	}
}	// GetPropertyFromFrame()
#endif // TO_BE_DELETED


//------------------------------------------------------------------------------
// GetPartFromPart
//------------------------------------------------------------------------------

#ifdef TO_BE_DELETED
static void GetPartFromPart(ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
ODUnused(thisPart);
ODUnused(desiredClass);
ODUnused(container);
ODUnused(containerClass);
ODUnused(form);
ODUnused(selectionData);

	Environment*	ev = somGetGlobalEnvironment();
	ODSession*				session = (ODSession*)refCon;
	ODNameResolver*		resolver = session->GetNameResolver(ev);

	ODFrame* frame
			= (ODFrame*)GetSecondFourBytesFromDataHandle(container);
	resolver->CreateSwapToken(ev, value, frame);
}	// GetPartFromPart()
#endif // TO_BE_DELETED


//------------------------------------------------------------------------------
// GetWildcardFromList
//------------------------------------------------------------------------------

ODError GetWildcardFromList(ODPart*			thisPart,
								DescType			desiredClass,
								ODOSLToken*	container,
								DescType			containerClass,
								DescType			form,
								AEDesc*		selectionData,
								ODOSLToken*		value,
								ODSLong			refCon)
{
ODUnused(containerClass);

	ODError	result;
	ODSLong	itemCount;
	AEKeyword	theAEKeyword;
	ODOSLToken	thisItem;
	ODOSLToken	myToken;
	ODSLong	i;
	ODError	error = noErr;

	TRY

	Environment*	ev = somGetGlobalEnvironment();
	ODSession*				session = (ODSession*)refCon;
	ODNameResolver*		resolver = session->GetNameResolver(ev);

	result = AECountItems((AEDesc*)container, &itemCount);
	THROW_IF_ERROR(result);
	
	result = AECreateList(nil,0,false,(AEDesc*)value);
	THROW_IF_ERROR(result);

	for (i=1;i<=itemCount;++i)
	{
		result = AEGetNthDesc((AEDesc*)container,i,typeWildCard, 
											&theAEKeyword, (AEDesc*)&thisItem);
		THROW_IF_ERROR(result);

		resolver->CallObjectAccessor(ev, thisPart, desiredClass, &thisItem, 
						thisItem.descriptorType, form, (ODDesc*)selectionData, 
						&myToken);

		result = AEPutDesc((AEDesc*)value, 0, (AEDesc*)&myToken);
		THROW_IF_ERROR(result);

		result = AEDisposeDesc((AEDesc*)&thisItem);
		THROW_IF_ERROR(result);

		result = AEDisposeDesc((AEDesc*)&myToken);
		THROW_IF_ERROR(result);
	}
	
	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
}	// GetWildcardFromList()


//------------------------------------------------------------------------------
// HandleSetData
//------------------------------------------------------------------------------

ODError HandleSetData(ODPart*	thisPart,
					AppleEvent*	theAppleEvent,
					AppleEvent*	reply,
					ODSLong	handlerRefcon)
{
	ODUnused(thisPart);
	ODUnused(reply);
	ODUnused(handlerRefcon);

	AEDesc theData;
	ODError	error = noErr;
	
	TRY
	
	THROW_IF_ERROR(AEGetKeyDesc(theAppleEvent, keyAEData,
              typeWildCard, &theData));

	AEDesc theToken;
	OSErr err =  AEGetParamDesc(theAppleEvent, keyDirectObject, typeWildCard,
			&theToken);
	if (err == noErr)
	{
		switch (theToken.descriptorType)
		{
			case typeEmbededPartProp:
			case typeFrameProp:
			case typeProperty:
				AbsDrawPartPropAccessor* embedPropAccessorObj
						= (AbsDrawPartPropAccessor*)GetFirstFourBytesFromDataHandle
								((ODOSLToken*)&theToken);
					embedPropAccessorObj->SetData(&theData);
				delete embedPropAccessorObj;
				break;
			
			default:
				ASSERTM(false, errAECantSupplyType, "You shouldn't be here");
			
		}
	}
	AEDisposeDesc(&theData);
	THROW_IF_ERROR(err);

	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
}	// HandleSetData()


//------------------------------------------------------------------------------
// HandleGetData
//------------------------------------------------------------------------------

ODError HandleGetData(ODPart*	thisPart,
					AppleEvent*	theAppleEvent,
					AppleEvent*	reply,
					ODSLong	handlerRefcon)
{
ODUnused(thisPart);
ODUnused(handlerRefcon);

	DescType		reqType;
	AEDesc			theToken;
	Size			theSize;
	AEDesc			objectData;
	ODError		result;
	ODError		error;

	TRY

	result = AEGetParamDesc(theAppleEvent, keyDirectObject, typeWildCard,
								&theToken);
	THROW_IF_ERROR(result);

			//	Next, get the requested return type, if it exists.
	result = AEGetParamPtr(theAppleEvent,keyAERequestedType,typeType,
					&reqType,(Ptr)&reqType,sizeof(reqType),&theSize);
	if (result == errAEDescNotFound)		// Not an error if return type is not found.
	{
		result = noErr;
		reqType = typeWildCard;
	}
	THROW_IF_ERROR(result);

	switch (theToken.descriptorType)
	{
#ifdef TO_BE_DELETED
		case typeEmbededPartProp:
			EmbeddedPartPropAccessor* embedPropAccessorObj
					= (EmbeddedPartPropAccessor*)GetSecondFourBytesFromDataHandle
							((ODOSLToken*)&theToken);
			embedPropAccessorObj->GetData(&objectData); //, reqType);
			delete embedPropAccessorObj;
			break;
		
#endif // TO_BE_DELETED

		case typeEmbededPartProp:
		case typeFrameProp:
		case typeProperty:
			AbsDrawPartPropAccessor* propAccessorObj
					= (AbsDrawPartPropAccessor*)GetFirstFourBytesFromDataHandle
							((ODOSLToken*)&theToken);
			propAccessorObj->GetData(&objectData); //, reqType);
			delete propAccessorObj;
			break;
		default:
			ASSERTM(false, errAECantSupplyType, "You shouldn't be here");
		
	}
	
	result = AEPutParamDesc(reply, keyAEResult, &objectData);
	THROW_IF_ERROR(result);

//	delete propAccessorObj;

	CATCH_ALL
		error = ErrorCode();
	ENDTRY
	
	return error;
}	// HandleGetData()

//------------------------------------------------------------------------------
// HandleCreate
//------------------------------------------------------------------------------

// This guy translates the name of the user's new part into a class that
// we can actually use.  Or at least I think that's how it will work.

static DescType Partstring2Type(AEDesc* thePartType)
{
	DescType result = cDrawPart;		// default (for now)

	if(thePartType->dataHandle != NULL)
	{
		HLock(thePartType->dataHandle);
		short len = (short)GetHandleSize(thePartType->dataHandle);
		
		char* drawpart = "drawpart";
		char* dragpart = "dragpart";
		char* clockpart = "clockpart";
		char* testpart = "testpart";
		if (IUMagString(*thePartType->dataHandle, drawpart, len,
				strlen(drawpart)) == 0)
			result = cDrawPart;
		else if (IUMagString(*thePartType->dataHandle, dragpart, len,
				strlen(dragpart)) == 0)
			result = cDragPart;
		else if (IUMagString(*thePartType->dataHandle, clockpart, len,
				strlen(clockpart)) == 0)
			result = cClockPart;
		else if (IUMagString(*thePartType->dataHandle, testpart, len,
				strlen(testpart)) == 0)
			result = cTestPart;
			
		AEDisposeDesc(thePartType);
	}
	return result;

}	// Partstring2Type()

ODError HandleCreate(ODPart*	thisPart,
					AppleEvent*	theAppleEvent,
					AppleEvent*	reply,
					ODSLong	handlerRefcon)
{
ODUnused(thisPart);
ODUnused(reply);
ODUnused(handlerRefcon);

	Environment*	ev = somGetGlobalEnvironment();
	ODError			result;
	DescType		theType;
	DescType		theClass;
	ODSize			theSize;
	AEDesc			replyObject;
	ODPart* 		theNewPart;
	ODError			error = noErr;

	TRY

		//	First, get the object class -- a required parameter
	result = AEGetParamPtr(theAppleEvent, keyAEObjectClass, typeType, &theType, 
					(Ptr)&theClass, sizeof(DescType), (Size *)&theSize);
	THROW_IF_ERROR(result);

	if(theClass != cPart)
		THROW(errAENoSuchObject);
	
	AEDesc thePartType;
	ThrowIfNotAbsent(AEGetParamDesc(theAppleEvent, typeType, typeChar,
								&thePartType));
	DescType partKind = Partstring2Type(&thePartType);
	
		//	Next, get the insertion location -- a required parameter
	AEDesc theLocation;
	result = AEGetParamDesc(theAppleEvent, keyAEInsertHere, typeInsertionLoc, 
					&theLocation);
	if (result != errAEDescNotFound)
		THROW_IF_ERROR(result);

		// Create the new part
	theNewPart=((AppleTestDraw_DrawPart*)thisPart)->CreateNewPart(ev, partKind, &theLocation);
	
		// have the new part create an object specifier for itself
	AEDesc containerObjSpec;
	THROW_IF_ERROR(AEGetAttributeDesc(theAppleEvent, 'subj',
			typeObjectSpecifier, &containerObjSpec));
	CreatePartObjectSpec(formAbsolutePosition, &containerObjSpec, &replyObject);
	AEDisposeDesc(&containerObjSpec);

		// put the object spec in the result field of reply
	result = AEPutParamDesc(reply, keyAEResult, &replyObject);
	AEDisposeDesc(&replyObject);
	THROW_IF_ERROR(result);

	// <eeh> But I want it to stick around!!!!
	// delete theNewPart;
	// ODReleaseObject(theNewPart);

	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
}	// HandleCreate()

//------------------------------------------------------------------------------
// HandleMove
//
// ALL THIS HANDLES right now is moving a part's frame[s], though I've
// never tested it on any part with more than one frame!
//------------------------------------------------------------------------------

static void MoveFacetTransform(ODFacet* facet, Point* desiredLocation,
		ODPart* part)
{
#if 0
	Environment*	ev = somGetGlobalEnvironment();
	ODTransform* newXForm = ODCopyAndRelease(facet->GetExternalTransform(ev));
	Point curOffset = newXForm->GetQDOffset(ev);
	Point scratch = *desiredLocation;
	scratch.h -= curOffset.h;
	scratch.v -= curOffset.v;

	ODPoint newDelta = *desiredLocation = scratch;
	newXForm->MoveBy(ev, &newDelta);
	facet->ChangeGeometry(ev, kODNULL, newXForm);
	facet->Invalidate(ev, kODNULL);
#endif // 0
}

ODError HandleMove(ODPart*	thisPart,
					AppleEvent*	theAppleEvent,
					AppleEvent*	reply,
					ODSLong	handlerRefcon)
{
#if 0
	ODUnused(handlerRefcon);
	ODUnused(reply);

	Environment*	ev = somGetGlobalEnvironment();
	AppleTestDraw_DrawPart*		thisDrawPart = (AppleTestDraw_DrawPart*) thisPart;
	
	// Size theSize;
	// DescType theType;
	ODError	error = noErr;

	TRY

	AEDesc destination;		// where it's to be moved to
	OSErr result = AEGetParamDesc(theAppleEvent, keyAEInsertHere, typeWildCard,
			&destination);
	THROW_IF_ERROR(result);
	
	ODOSLToken theToken;		// what I'm supposed to move
	THROW_IF_ERROR(AEGetParamDesc(theAppleEvent, keyDirectObject, typeWildCard,
			(AEDesc*)&theToken));
	WASSERT(((AEDesc*)&theToken)->descriptorType == cPart);

	if (destination.descriptorType == typeObjectSpecifier)	// a path
	{
		ODOSLToken token;
	
		ODNameResolver* resolver = ((ODSession*)handlerRefcon)->
				GetNameResolver(ev);
		// start resolution at the shell
		resolver->Resolve(&destination, &token, kODAppShell);

		// now replace the location with the token, and pass the
		// event to that part.  should I dispose of the token after
		// putting it in the AppleEvent?
		
		THROW_IF_ERROR(AEPutParamDesc(theAppleEvent, keyAEInsertHere, 
				(AEDesc*)&token));
		ODPart* embedder;
		ODFrame* ignoreF;
		resolver->GetContextInfo(ev, &ignoreF, &embedder);
		ODMessageInterface* msgInterface = ((ODSession*)handlerRefcon)->
				GetMessageInterface(ev);
		// NO! PRIVATE METHOD. MUST USE SEND.
//		THROW_IF_ERROR(msgInterface->DispatchToEventHandler(theAppleEvent,
//				reply, embedder));

	}
	else if (destination.descriptorType == cPart)
	{
		// Here the destination is a token belonging to me.  As the
		// embedding part (the last to deal with the token before the
		// original recipient of the event finished resolving it) I
		// own the destination and can get out of the token what I
		// need.
		
		ODFrame* frameToMoveTo = (ODFrame*)
				GetSecondFourBytesFromDataHandle((ODOSLToken*)&destination);
		ODFrame* frameToMove
				= (ODFrame*)GetSecondFourBytesFromDataHandle(&theToken);


		// get some info for the embed call
		ODShape* frameShape = ODCopyAndRelease(frameToMove->GetFrameShape(ev));

		ODTransform* xtrnlXfrm = ODCopyAndRelease(facet->GetExternalTransform(ev));
		ODFrameFacetIterator* fi = frameToMove->CreateFacetIterator(ev);
		ODFacet* facet = fi->First(ev);


		// remove the frame from the old place
		frameToMove->GetContainingFrame(ev)->GetPart(ev)->
				RemoveEmbeddedFrame(ev, frameToMove);

		// embed it in the new

		WASSERT(thisPart == frameToMoveTo->GetPart(ev));

		ODFrame* newFrame = thisDrawPart->CreateEmbeddedFrame(ev,
												frameToMoveTo,
												frameShape,
												xtrnlXfrm,
												frameToMove->GetPart(ev),
												kODNullTypeToken,
												kODNullTypeToken,
												0,
												kODFalse);
		ODReleaseObject(ev, frameShape);
		ODReleaseObject(ev, xtrnlXfrm);
	}
	else
	{
		// get the point
		AEDesc dPoint;
		result = AECoerceDesc(&destination, typeQDPoint, &dPoint);
		THROW_IF_ERROR(result);
		Point pt = **(Point**)dPoint.dataHandle;
		AEDisposeDesc(&dPoint);

		ODFrame* frameToMove
				= (ODFrame*)GetSecondFourBytesFromDataHandle(&theToken);
		ODFrameFacetIterator* fi = frameToMove->CreateFacetIterator(ev);
		ODFacet* facet = fi->First(ev);
		MoveFacetTransform(facet, &pt, frameToMove->GetPart(ev));

		Proxy* p = thisDrawPart->ProxyForFrame(frameToMove);

		// !!! this is a single-facet hack
		p->transform->MoveBy(ev, pt);		
		thisDrawPart->UpdateProxyRegion(ev, p);
		thisDrawPart->CreateProxySelectionBorder(ev, p);

		frameToMove->GetContainingFrame(ev)->Invalidate(ev, (ODShape*)kODNULL);
	}

	AEDisposeDesc(&destination);

	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
#endif // 0
	return errAEEventNotHandled;
}	// HandleMove()

//------------------------------------------------------------------------------
// Coercelist2RGB
//
//	From the AppleScript code and tweaked.
//------------------------------------------------------------------------------

#define QDRGBsize			3

ODError CoerceList2RGB(ODPart* thisPart, AEDesc* from, DescType toType,
					ODSLong refcon, AEDesc* result)
{
ODUnused(thisPart);
ODUnused(refcon);

	OSErr err;
	AEKeyword dummyKeyword;
	DescType dummyCode;
	Size itemSize;
	long theData[QDRGBsize];
	unsigned short theRealData[QDRGBsize];
	ODError	error = noErr;

	TRY

	// the data goes R, G, B
	for (int i=0; i<QDRGBsize; i++) {
		err = AEGetNthPtr(from, i+1, typeLongInteger, &dummyKeyword,
						  &dummyCode, (Ptr) &theData[i], sizeof(theData[0]),
						  &itemSize);
		if ((err != noErr) || (theData[i] < 0) || (theData[i] > USHRT_MAX))
			THROW(errAECoercionFail);
		theRealData[i] = (unsigned short)theData[i];
	}
	THROW_IF_ERROR(AECreateDesc(toType, (Ptr)&theRealData,
								QDRGBsize * sizeof(short), result));
	
	CATCH_ALL
	error = ErrorCode();
	ENDTRY
	
	return error;
}

//------------------------------------------------------------------------------
// DrawCompare
// For now, just handle what we need to handle
//------------------------------------------------------------------------------
ODError DrawCompare(	ODPart*			thePart,
							DescType			oper,
							ODOSLToken*	obj1,
							ODOSLToken*	obj2,
							ODBoolean*			result,
							ODSLong			refCon)
{
	ODUnused(thePart);
	ODUnused(obj1);
	ODUnused(result);
	ODUnused(refCon);

	ODError	error = noErr;

	switch(oper)
	{
		case kAEEquals:
			if (((AEDesc*)obj2)->descriptorType == typeChar)
				break;
		default:
			error = errAEEventNotHandled;
	}
	
	return error;
}

//------------------------------------------------------------------------------
// DrawCount
//------------------------------------------------------------------------------
ODError DrawCount(		ODPart*			thePart,
							DescType			desiredType,
							DescType			containerClass,
							ODOSLToken*	container,
							ODSLong*			result,
							ODSLong			refCon)
{
	ODUnused(thePart);
	ODUnused(desiredType);
	ODUnused(containerClass);
	ODUnused(container);
	ODUnused(result);
	ODUnused(refCon);

	Environment*	ev = somGetGlobalEnvironment();
	ODError			error = noErr;

	TRY

	if (containerClass == cPart)
	{
		ODNameResolver* resolver = ((ODSession*)refCon)->GetNameResolver(ev);
	
		ODPart* part
				= (ODPart*)GetFirstFourBytesFromDataHandle(container);
		// resolver->CreateSwapToken(value, part);
	}
	
	CATCH_ALL
		error = ErrorCode();
	ENDTRY

	return error;
}

//------------------------------------------------------------------------------
// DrawDisposeToken
//------------------------------------------------------------------------------
ODError DrawDisposeToken(ODPart*			thePart,
							ODOSLToken*	unneededToken,
							ODSLong		refCon)
{
	ODUnused(thePart);
	ODUnused(unneededToken);
	ODUnused(refCon);
	return errAEEventNotHandled;
}

#undef ODOJBECT_ACCESSOR_PARAMS
