/*
	File:		Clock.cpp

	Contains:	Source code for the sample "Clock" part

	Owned by:	SOMverted by Tantek elik, written by many

	Copyright:	c 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		<43>	 1/26/95	eeh		1213354: ODActionData now an ODByteArray.
		<42>	 1/26/95	VL		#???: Use updated Storage Unit Ref API.
		<41>	 1/23/95	RR		# 1212896 Use ODMenuBar:: EnableAll and
									DisableAll
		<40>	 1/22/95	NP		EmbeddedFrameSpec signature changed because
									of change to AE types.
		<39>	 1/20/95	JBS		1195017, 1205669: part API changes
		<38>	 1/13/95	RR		Removed overrides of HandleEventInEmbedded,
									MouseEnter, MouseWIthin and MouseLeave.
									Moved functionality to HandleEvent
		<37>	 1/12/95	jpa		Don't use obsolete Toolbox names [1211211]
		<36>	  1/9/95	NP		1194880: SemtIntf name changes.
		<35>	12/23/94	JBS		1186869: hide ODPartWrapper from public
									API; 1192557: ODPartWrapper realPart access
		<34>	12/20/94	VL		1195012: Make Storage calls be
									marshallable.
		<33>	12/15/94	CC		1197221 CreateLink() takes ODByteArray
									parameter.
									1205684 LinkUdated parameter renamed to
									"change" from "id".
		<32>	11/28/94	RR		Analog, about box, etc. etc.
		<30>	10/27/94	eeh		#1191434 for RR: handle null facet in
									mouseup case (b/c of change to
									StdDispM.cpp)
		<29>	10/27/94	RR		Call DrawDialog because dispatcher no
									longer does it
		<28>	 10/4/94	JBS		1188214: convert for coord bias
		<27>	 9/30/94	RR		#1188888 Activate on mouseUp
		<26>	 9/29/94	eeh		#1185147: ShowPartsBin menu change to
									accomodate non-floating PB window
		<25>	 9/29/94	RA		1189812: Mods for 68K build.
		<24>	 9/20/94	RR		#1183395. Use menu bar methods to disable
									menus when invoking Synchronize dialog.
		<23>	 9/15/94	VL		1184871: Fixed parameters to Focus not to
									rely on the indices.
		<22>	  9/9/94	CG		#1183531: PartWrapper API implemented.
		<21>	  9/5/94	VL		1183174: Use IsValidStorageUnitRef instead
									of exception.
		<20>	  9/1/94	RR		#115685 Added invalidation to
									GeometryChanged . Changed window type to
									rDocProc
		<19>	  9/1/94	CC		RADAR #1183005 - change AdjustBorderShape
									param from Frame to Facet (for JBS)
		<18>	 8/31/94	T		#1183129, #1183116, #1183119, #1183111:
									Lots of ErrorCode cleanup.
		<17>	 8/28/94	VL		#1182975: DragEnter & DragWithin should
									return ODDragResult (instead of ODBoolean).
		<16>	 8/26/94	T		#1181761 rename obsolete kOD IDs to correct
									kODStrong/WeakStorageUnitRefs
		<15>	 8/26/94	VL		1183174: Use updated cloning APIs.
		<14>	 8/25/94	RR		Call MenuBar::IsValid
		<13>	 8/19/94	T		#1180922 Need to Stop using obsolete types
									(kOD ID)
		<12>	 8/18/94	jpa		Use object factories (only remaining
									problem is with ODFocusModules.) [1181835]
		<11>	 8/16/94	VL		1143605: Fixed parameters to CloneInto.
		<10>	 8/15/94	JBS		1181138: add frameType to CreateFrame();
									1181156: UI API Cleanup
		 <9>	 8/13/94	T		#1180814 Added support for ODPartWrapper
									API
		 <8>	 8/10/94	NP		1179997-corresponding checkin for idl file.
									no changes.
		 <7>	 8/10/94	JBS		1179919: coordinate system bias changes
		 <6>	  8/9/94	VL		1179857: DragEnter and DragWithin return
									ODBoolean.
		 <5>	  8/5/94	JBS		#1179151 Part API cleanup
		 <4>	  8/3/94	VL		1153123: No dependency on Storage.xh.
		 <3>	 7/28/94	T		ifdefd out IUEQUALSTRING call with
									IUEQUALNOTWORKING because it was hanging
									sometimes, the parameters looked fine going
									in.
		 <2>	 7/28/94	T		fixed a problem with having Clock as the
									root part of a document
		 <1>	 7/28/94	T		first checked in
		 <0>	 7/27/94	SV		SOMverted
		<12>	 5/27/94	jpa		Support new exceptions [1165267]
		<11>	 5/10/94	T		#1162405 Removed explicit ASLM dependency
									for using resources
		<10>	 4/16/94	T		#1157828 Move kODKindPartsBin to a public
									header
		 <9>	  4/8/94	RR		Handle kODCommandClose for settings window
		 <8>	  4/1/94	T		#1154941: Get OpenDoc source to actually
									compile for PowerPC
		 <7>	 3/28/94	T		#1145834.  Remove PrtType.h & .cpp from the
									project
		 <6>	 3/28/94	CG		1153547: include ODSessM.h instead of
									ODSessn.h.
		 <5>	 3/25/94	CC		Replaced kODDropSucceed with kODDropCopy
									(1153424); use
									ODDragAndDrop::GetContentStorageUnit()
									(1153043).
		 <4>	 2/23/94	VL		114????, fixed nasty linking problem
									(PartInfoRec::~PartInfoRec linked to the
									one in DrawPart.) by changing PartInfoRec
									to ClockInfoRec.
		 <3>	 2/16/94	T		fix #1144525
		 <2>	 2/16/94	JA		Include new AltPoint.h.
		<54>	  2/8/94	JA		Added missing #includes.
		<53>	  2/7/94	JA		Utility.h --> ODUtils.h
		<52>	  2/7/94	T		fixes to compile with PPC Headers
		<51>	  2/3/94	CG		Session organization changes.
		<50>	  2/2/94	JBS		removed sourceFrame from AddDisplayFrame()
		<49>	  2/1/94	SS		PartsBin menu item handling
		<48>	 1/28/94	RR		macro for ASLM QD globals
		<47>	 1/27/94	RR		Enable Show Parts Bin
		<46>	 1/27/94	RR		Added CreateWindow. Reworked Open.
									Implementated activation recipe
		<45>	 1/26/94	RR		Removed calls to invalidate facet under
									mouse when dismissing dialogs
		<44>	 1/25/94	RR		Call window->Open,Show,Select
		<43>	 1/24/94	SS		Additional work on Open method,
		<42>	 1/24/94	CC		Added ODChangeID parameter to
									LinkUpdated(ev).
		<41>	 1/21/94	RR		Added shouldSave to CreateWindow
		<40>	 1/20/94	SS		::Open returns a window id
		<39>	 1/20/94	SS		Updated partsbin support
		<38>	 1/15/94	RR		WinState.h->WinStat.h,
									Dispatch.h->Disptch.h
		<37>	 1/15/94	RR		Updated HandleMenuEvent (command no. is no
									longer in event)
		<36>	 1/14/94	RR		Entirely formatting
		<35>	 1/11/94	T		Init... changes
		<34>	 1/10/94	RR		Removed HiliteMenu calls. Used new
									TransferFocus calls
		<33>	  1/7/94	EL		Remove extra declaration of wasHandled
									in HandleMenuEvent.
		<32>	12/23/93	RR		Call InitFocusSet
		<31>	12/22/93	RR		Save reference to fSettingsWindow as an ID
		<30>	12/21/93	VL		Changed ODStorageUnit::GetValueSize to
									ODStorageUnit::GetSize.
		<29>	12/21/93	JBS		CreateFrame with viewType & presentation
		<28>	12/20/93	SS		Added partsbin support
		<27>	12/20/93	VL		Used WindowState to create window.
		<26>	12/20/93	RR		RegisterIdleFrame -> RegisterIdle
		<25>	12/16/93	RR		Added a variety of dialogs
		<24>	12/15/93	JBS		add FrameClosed
		<23>	12/13/93	T		InitPart changes
		<22>	12/13/93	RR		Implement About box from resources. Added
									gSession global for use by dialog filter.
		<21>	 12/8/93	RR		Fix syntax error
		<20>	 12/8/93	RR		Added (inactive) code for testing modal
									dialogs
		<19>	11/30/93	LM		Added an ODFrame parameter to ReadPartInfo
		<18>	11/23/93	JA		Updated for new Shape API.
		<17>	11/23/93	T		fTestClockSU = kODNULL; in constructor
		<16>	11/22/93	T		modifications to use the correct part
									storage model
		<15>	11/19/93	RR		Use correct event constants from
									PlfTypes.h.
		<14>	11/18/93	T		call inherited::InitializePersistent() and
									::Externalize()
		<13>	11/18/93	EL		Use standard property and types.
		<12>	11/16/93	SS		Fixed bug that caused menubar font/size to
									change
		<11>	11/16/93	RR		Added AdjustMenus (not yet called), and
									MouseWithin. Removed point from
									MouseLeave
		<10>	11/15/93	CC		Added stubs for CreateLink() and
									LinkUpdated()
		 <9>	11/12/93	JBS		use Facets
		 <8>	 11/1/93	VL		Used BeginClone, CloneTo and EndClone.
		 <7>	10/27/93	RR		Set Cursor in
									MouseEnterFrame/MouseLeaveFrame
		 <6>	10/21/93	PH		Change FulfillPromise call
		 <5>	10/14/93	RR		Add source frame parameter to
									AddDisplayFrame
		 <4>	10/14/93	JA		ODShape fu: No longer returns copies from
									GetPlatformShape. Deal w/it.
		 <2>	 10/8/93	T		call SetChangedFromPrev when content
									changes
		<47>	 10/6/93	JA		Use new fixed-point ODPoint.
		<46>	 10/5/93	T		In Initialize set fSemanticInterface =
									kODNULL.   Use ODDeleteObject and
									ODReleaseObject on appropriate fields
									inside destructor.
		<45>	 10/5/93	T		RelinquishFocusSet inside
									RemoveDisplayFrame
		<44>	 10/5/93	T		fixed InstallMenu to DisplayMenu before
									annotating it
		<43>	 10/5/93	T		fixed InstallMenu to DisplayMenu before
									annotating it
		<42>	 9/30/93	PH		Support new Drag and Drop protocol
		<41>	 9/30/93	RR		Added fFocusSet
		<40>	 9/29/93	VL		Added InitializePersistent.
		<39>	 9/23/93	JA		Use new convenience methods from Shape and
									Transform.
		<38>	 9/22/93	RR		Release menu bar, instead of deleting it
		<37>	 9/16/93	RR		Added fMenuBar
		<36>	 9/16/93	JA		Dispose rgn returned from GetPlatformShape.
		<35>	 9/10/93	RR		Use new menubar calls
		<34>	 8/23/93	PH		Fix in/externalize
		<33>	 8/20/93	PH		Fix ref counting
		<32>	 8/20/93	CG		Removed SemtIntf test methods.
		<31>	 8/13/93	RR		Use OrdColl.h instead of Collect.h
		<30>	 7/29/93	NP		Global variable change for ASLM.
		<29>	 7/28/93	PH		Move menu setup to constructor
		<28>	 7/26/93	CG		Added Reply handler to SemtItnf test code.
		<27>	 7/21/93	PH		Fix menus
		<26>	 7/21/93	CG		Sending a reply after AEvent is handled
									does not work.
		<25>	 7/20/93	CG		Added SemanticIntf test code.
		<24>	 7/16/93	PH		Call Get/PutOrderedCollection in DrawPart
		<23>	 7/13/93	PH		Comments on internalize code
		<22>	 7/13/93	PH		RegisterIdleFrame on internalize
		<21>	 7/12/93	PH		Externalize/Internalize fDisplayFrames
		<20>	  7/6/93	PH		Fix MinimizeFrameShape
		<19>	  7/6/93	PH		Fix FrameShapeChanged
		<16>	 6/24/93	RCR		Added #include Disptch.h
		<16>	 6/23/93	RCR		Use tokens for foci
		<15>	 6/15/93	RCR		Compare foci using ODISOStrCompare
		<14>	 5/26/93	JBS		update Active and Used shapes in
									FrameShapeChanged()
		<13>	 5/21/93	JBS		fix typo
		 <11>	 5/19/93	RCR		Part.h NameSmith.
		 <10>	 5/13/93	RCR		Adjust to Shape/Transform changes.
		 <9>	 4/29/93	VL		8.3 Name Changes.
		 <3>	  4/1/93	SES		Implemented "Font","Size", and "Style" menus. Added menu and
									selection focus/handling code.
		 <2>	 3/29/93	SES		Changed the text drawing mode to (srcCopy) so that updating
									works
		 <1>	 3/29/93	SES		first checked in
	To Do:
	
	In Progress:
*/

#ifndef _ALTPOINT_
#include "AltPoint.h"			// Use C++ savvy ODPoint and ODRect
#endif


#define SOM_Module_clock_Source
#define VARIABLE_MACROS
#include <Clock.xih>

#ifndef _CLOCKDEF_
#include "ClockDef.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif


#ifndef _SIHELPER_
//bgn#include "SIHelper.h"
#endif


#ifndef _ALTPOINT_
#include "AltPoint.h"			// Use C++ savvy ODPoint and ODRect
#endif


#ifndef SOM_Module_OpenDoc_Foci_defined
#include <Foci.xh>
#endif

#ifdef PLATFORM_MACINTOSH
#ifndef _USERSRCM_
#include "UseRsrcM.h"
#endif
#endif

#ifndef SOM_ODFocusSet_xh
#include <FocusSet.xh>
#endif

#ifndef SOM_Module_OpenDoc_StdProps_defined
#include <StdProps.xh>
#endif

#ifndef SOM_Module_OpenDoc_StdTypes_defined
#include <StdTypes.xh>
#endif

#ifndef _ODTYPES_
#include <ODTypes.h>
#endif

#ifndef SOM_Module_OpenDoc_StdDefs_defined
#include <StdDefs.xh>
#endif

#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_ODDocument_xh
#include <Document.xh>
#endif

#ifndef SOM_ODContainer_xh
#include <ODCtr.xh>
#endif

#ifndef SOM_ODStorageUnit_xh
#include <StorageU.xh>
#endif

#ifndef SOM_ODStorageUnitView_xh
#include <SUView.xh>
#endif

#ifndef SOM_ODStorageUnitCursor_xh
#include <SUCursor.xh>
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODWindowState_xh
#include <WinStat.xh>
#endif

#ifndef SOM_ODFrame_xh
#include <Frame.xh>
#endif

#ifndef SOM_ODFacet_xh
#include <Facet.xh>
#endif

#ifndef SOM_ODFrameFacetIterator_xh
#include <FrFaItr.xh>
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

#ifndef SOM_ODDispatcher_xh
#include <Disptch.xh>
#endif

#ifndef _ODUTILS_
#include <ODUtils.h>
#endif

#ifndef SOM_ODMenuBar_xh
#include <MenuBar.xh>
#endif

#ifndef SOM_Module_OpenDoc_Commands_defined
#include <CmdDefs.xh>
#endif

#ifndef _ITEXT_
#include <IText.h>
#endif

#ifndef _ISOSTRING_
#include "ISOStr.h"
#endif

#ifndef SOM_ODMessageInterface_xh
//bgn#include <MssgIntf.xh>
#endif

#ifndef _AEOBJECTS_
//bgn#include "AEObjects.h"
#endif

#ifndef _FOCUSLIB_
#include "FocusLib.h"
#endif

#ifndef SOM_ODArbitrator_xh
#include <Arbitrat.xh>
#endif

#ifndef SOM_ODWindow_xh
#include <Window.xh>
#endif

#ifndef SOM_ODShape_xh
#include <Shape.xh>
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef _EXCEPT_
#include "Except.h"
#endif

#ifdef PLATFORM_MACINTOSH
#ifndef __MENUS__
#include <Menus.h>
#endif

#ifndef __OSUTILS__
#include <OSUtils.h>
#endif

#ifndef __TOOLUTILS__
#include <ToolUtils.h>
#endif

#ifndef __FONTS__
#include <Fonts.h>
#endif

#ifndef __TYPES__
#include <Types.h>
#endif

#ifndef __PACKAGES__
#include <Packages.h>
#endif

#ifndef __RESOURCES__
#include <Resources.h>
#endif

#ifndef __DIALOGS__
#include "Dialogs.h"
#endif

#ifndef __TEXTEDIT__
#include <TextEdit.h>
#endif

#ifndef __PACKAGES__
#include <Packages.h>
#endif

#ifndef __STRINGS__
#include <Strings.h>
#endif

#ifndef __FP__
#include <Fp.h>
#endif
#endif

#include <string.h>
#include <time.h>

//bln#ifndef _ODDEBUG_
//bln#include "ODDebug.h"	
//bln#endif


#ifndef _STORUTIL_
#include <StorUtil.h>
#endif

//bgn#pragma segment Clock

#ifdef PLATFORM_WINDOWS

#include <math.h>

#ifndef M_PI
#define M_PI  3.14159265358979323846
#endif

#define rint

#include "stdidsw.h"

#endif

static ODSession* gSession;	// For use in Dialog Filter Proc

//=========================================================================
// Constants
//=========================================================================

#define kCPIdleFrequency				20
#define kClockMinimumSize  				120

const	ODPropertyName	kPropClockType   = "Clock:Property:Type";
const	ODPropertyName	kPropClockFont   = "Clock:Property:Font";
const	ODPropertyName	kPropClockStyle  = "Clock:Property:Style";
const	ODPropertyName	kPropClockSize   = "Clock:Property:Size";

// To identify different frames 

const ODType kClockFrame   = "Clock:Presentation:Time";
const ODType kSynchronizeFrame  = "Clock:Presentation:Synchronize";
const ODType kAlarmSettingsFrame   = "Clock:Presentation:Settings";

// Command IDs

const ODCommandID cSynchronize = 2001;
const ODCommandID cShowSettings = 2002;
const ODCommandID cAnalog = 2003;
const ODCommandID cDigital = 2004;


// private error codes:

const ODError  kODErrCannotGetWindow        = 71;

#ifdef WIN32
// dkf: the following is a temp hack so we can write the log font in the same way under 16 bit and 32 bit.
//      we standardize on the 16 bit version since it was here first
#define LF_FACESIZE_WIN16	    32
typedef struct tagLOGFONT_WIN16
{
    short     lfHeight;
    short     lfWidth;
    short     lfEscapement;
    short     lfOrientation;
    short     lfWeight;
    BYTE    lfItalic;
    BYTE    lfUnderline;
    BYTE    lfStrikeOut;
    BYTE    lfCharSet;
    BYTE    lfOutPrecision;
    BYTE    lfClipPrecision;
    BYTE    lfQuality;
    BYTE    lfPitchAndFamily;
    char    lfFaceName[LF_FACESIZE_WIN16];
} LOGFONT_WIN16;
#endif

//=========================================================================
// Implementation Classes
//=========================================================================

class ClockPart;
class ClockFrame;
	class ClockTimeFrame;
	class ClockDialogFrame;
		class ClockSynchroDialogFrame;
		class ClockSettingsDialogFrame;


//=========================================================================
// Function Prototypes
//=========================================================================

#ifdef PLATFORM_MACINTOSH
pascal Boolean ClockDialogFilter(DialogPtr dialog,
							  EventRecord* event,
							  short* itemHit);
pascal Boolean AboutDialogFilter(DialogPtr dialog,
							  EventRecord* event,
							  short* itemHit);
#endif
							  
static void CheckMarkMenu(MenuHandle menu, Str255 checkItem, ODBoolean checkIt);
static void StyleToString(ODUByte	style, Str255*	styleName );

#ifdef PLATFORM_WINDOWS
static void SquareRect(HDC hDC, RECT &rect);
#endif

//=========================================================================
// Clock Part
//=========================================================================

class ClockPart
{
public:
	ClockPart();
	virtual ~ClockPart();
	void InitClockPart(Environment* ev,
					   	ODSession* session, 
						ODPart* somSelf, 
						ODPartWrapper* partWrapper);
						
	void PrepareStorage(Environment* ev, ODStorageUnit* storageUnit);
	void Internalize(Environment* ev, ODStorageUnit* storageUnit);
	void Externalize(Environment* ev);

	void DisplayFrameAdded(Environment *ev, ODFrame* frame);
	void DisplayFrameConnected(Environment *ev, ODFrame* frame);
	ODPtr ReadPartInfo(Environment *ev,
								ODFrame* frame, 
								ODStorageUnitView*	storageUnitView);
								
	ODBoolean ContainsDisplayFrame(Environment* ev, ODFrame* frame);
	void AddDisplayFrame(Environment* ev, ODFrame* frame);
	void RemoveDisplayFrame(Environment* ev, ODFrame* frame);
	
	void BuildMenuBar(Environment* ev);
	void InstallMenus(Environment* ev);
	void OutlineSizeMenu(Environment *ev);
	void HandleFontMenu(Environment *ev, ODFrame *frame);
#ifdef PLATFORM_MACINTOSH
	void HandleSizeMenu(Environment *ev, ODUShort item);
	void HandleStyleMenu(Environment *ev, ODUShort item);
#endif
	
	void ShowAboutBox(Environment* ev, ODFrame* frame);
	void ShowSynchDialog(Environment* ev);
	void ShowSettingsDialog(Environment* ev);
	
	ODWindow* CLKCreateWindow(Environment *ev, ODFrame* sourceFrame);
	ODID OpenInitialWindow(Environment *ev);

	void ShowHidePartsBin(Environment *ev, ODFrame* frame);
	void ShowPartsBin(Environment *ev, ODFrame* frame);
	void HidePartsBin(Environment *ev, ODFrame* frame);
	void CalcClockBounds(Rect& rect);
	void Idle(Environment* ev, ODEventData* event) { };
	void AdjustMenus(Environment *ev, ODFrame* frame);
	void AcquiredSelectionFocus(Environment* ev, ClockFrame* frame);
	void LostSelectionFocus(Environment* ev, ClockFrame* frame);
	ODBoolean CloseWindow(Environment* ev, ODFrame* frame);
	
	ODMenuBar* GetMenuBar() { return fMenuBar; };
	
	LPLOGFONT GetFont() { return &fFont; }
	LPLOGFONT m_ChooseFont (Environment *ev, ODFrame*  frame, LOGFONT * pLogFont);

#ifdef PLATFORM_MACINTOSH		
	ODSShort GetSize() { return fSize; }
		
	ODUByte GetStyle() { return fStyle; }
#endif
	
	void SetFont(Environment *ev, LOGFONT lf);
	void SetFontSize(Environment *ev, ODSShort fontSize);
	void SetFontStyle(Environment *ev, ODUByte fontStyle);
	
	ODSShort GetLastAscent() { return fLastAscent;};
	void SetLastAscent(ODSShort ascent) { fLastAscent = ascent;};
	
	ODPartWrapper* GetPartWrapper() { return fPartWrapper; };
	
	ODBoolean AlarmEnabled() { return fAlarmEnabled; };
	void ToggleAlarm() { fAlarmEnabled = !fAlarmEnabled; };

	ODBoolean IsAnalog() { return fAnalog; };
	void SetAnalog(Environment* ev, ODBoolean analog);
	
	ODShape* CreateOvalShape(Environment* ev, ODFrame* frame, Rect& rect);
	
public:	// Tokenized strings

	ODTypeToken fTimePresentation;				
	ODTypeToken fSynchronizePresentation;		
	ODTypeToken fAlarmSettingsPresentation;	
		
private: // With inline accessors
	ODPartWrapper*		fPartWrapper;
	ODMenuBar* 			fMenuBar;
#ifdef PLATFORM_MACINTOSH
	ODSShort 			fFont; 					// text font
	ODUByte 			fStyle; 				// text style
#endif
	ODSShort 			fSize; 					// text size
#ifdef PLATFORM_WINDOWS
	LOGFONT 			fFont; 					// text font (Windows)
	TEXTMETRIC			tMetric;				// text metric structure (Windows)
	ODSShort 			fMode; 					// text draw mode (srcOr/srcXor/srcBic)
	ODSShort 			fJustification; 		// text justification
#endif
	ODSShort 			fLastAscent; 			// font ascent
	ODBoolean 			fAlarmEnabled;
	ODBoolean			fAnalog;
private: 
	ODSession* 			fSession;
	ODArbitrator*		fArbitrator;
	ODDispatcher*		fDispatcher;
	ODWindowState*		fWindowState;

	ODPart*				fSOMSelf;
	ODStorageUnit* 		fTestClockSU;
	OrderedCollection* 	fDisplayFrames;

	WindowPtr			fWorkPort;
#ifdef PLATFORM_MACINTOSH
	MenuHandle 			fFontMenu;
	MenuHandle 			fSizeMenu;
	MenuHandle 			fStyleMenu;
	MenuHandle 			fSettingsMenu;
#endif
#ifdef PLATFORM_WINDOWS
	ODPlatformMenu		fFontMenu;
	ODPlatformMenu		fSettingsMenu;
#endif
	ODTypeToken 		fModalFocus;
	ODID 				fSettingsWindow;
	ODBoolean 			fSettingsWindowWasShown;
	ODID 				fPartsBinWin;
	ODBoolean 			fPartsBinOpen;
//	ODSemanticInterface* fSemanticInterface; 	// Not yet implemented
};

//=========================================================================
// Clock Frame
//=========================================================================

class ClockFrame
{
public:
	ClockFrame();
	~ClockFrame();
	void InitClockFrame(Environment* ev, 
						ODSession* session,
						ODFrame* frame, 
						ClockPart* clockPart);
	
	virtual void Draw(Environment* ev, ODFacet* facet, ODShape* invalShape) {  };
	virtual ODBoolean HandleMouseDown(Environment* ev, ODFacet* facet, ODEventData* event) { return kODFalse; };
	virtual ODBoolean HandleMouseUp(Environment* ev, ODFacet* facet, ODEventData* event) { return kODFalse; };
	virtual void ActivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event) {};
	virtual void DeactivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event) {};
	virtual void MouseEnter(Environment* ev, ODFacet* facet, ODPoint* where);
	virtual void MouseWithin(Environment* ev, ODFacet* facet, ODPoint* where);
	virtual void MouseLeave(Environment* ev, ODFacet* facet);
	virtual void Activate(Environment* ev) { };
	virtual ODBoolean HandleMenuEvent(Environment* ev, ODEventData* event) { return kODFalse; };
	virtual void Idle(Environment* ev, ODEventData* event) { };
	virtual void FacetAdded(Environment* ev, ODFacet* facet) { };
	virtual ODID ViewInWindow(Environment *ev) { return 0; };

	virtual ODBoolean BeginRelinquishFocus(Environment *ev,
			 									ODTypeToken focus,
										 		ODFrame* proposedFrame);
	virtual void CommitRelinquishFocus(Environment *ev,
			 								ODTypeToken focus,
										 	ODFrame* proposedFrame);
	virtual void AbortRelinquishFocus(Environment *ev,
			 								ODTypeToken	focus,
									 		ODFrame* proposedFrame);
	virtual void FocusAcquired(Environment *ev,
			 						ODTypeToken	focus);
	virtual void FocusLost(Environment *ev,
			 					ODTypeToken	focus);
			 					
	virtual void Add(Environment* ev);
	virtual void Connect(Environment* ev);
	virtual void Remove(Environment* ev);
	virtual void Close(Environment* ev);
	virtual void FrameShapeChanged(Environment* ev) {};


protected:
	ODSession*		fSession;
	ODArbitrator*	fArbitrator;
	ODDispatcher*	fDispatcher;
	ODWindowState*	fWindowState;
	ODTypeToken 	fSelectionFocus;
	ODTypeToken 	fMenuFocus;
	ODTypeToken		fKeyFocus;
	ODTypeToken		fModalFocus;

	ODFrame*   	fFrame;
	ClockPart* 	fClockPart;
	HCURSOR		fArrowCursor; 			// pointer cursor
	ODFocusSet* fFocusSet;
	ODBoolean	fIsActive;			// Does this frame have its focus set?
	ODBoolean	fNeedsActivating;	// should this be activated when its window is activated?
	ODID 		fWindowID; 			// ID of View As Window window

	HPEN		fHourPen;
	HPEN		fMinutePen;
	HPEN		fSecondPen;
};

//=========================================================================
// ClockTimeFrame
//=========================================================================

class ClockTimeFrame : public ClockFrame
{
public:
	ClockTimeFrame();
	virtual ~ClockTimeFrame();
	void InitClockTimeFrame(Environment* ev, 
							ODSession* session,
							ODFrame* frame, 
							ClockPart* clockPart);
	
	virtual void Draw(Environment* ev, ODFacet* facet, ODShape* invalShape);	
	void DrawClockFace(Environment* ev, ODFacet* facet, HDC hDC);
	void DrawTime(Environment* ev,  ODFacet* facet, ODULong tickCount, HDC hDC);
	void UpdateTime(Environment* ev,  ODFacet* facet, ODULong tickCount);
	
	void DrawAnalogFace(Environment* ev,  ODFacet* facet, HDC hDC);
	void DrawDigitalTime(Environment* ev, ODFacet* facet, ODULong tickCount, HDC hDC);
	void DrawClockHands(Environment* ev,  ODFacet* facet, ODULong tickCount, HDC hDC);
	void UpdateClockHands(Environment* ev,  ODFacet* facet, ODULong tickCount, HDC hDC);
	void DrawHourHand(Rect* clockRect, Point* centerPoint, ODSShort radius, ODSShort hour, ODSShort minute, HDC hDC);
	void DrawMinuteHand(Rect* clockRect, Point* centerPoint, ODSShort radius, ODSShort minute, HDC hDC);
	void DrawSecondHand(Rect* clockRect, Point* centerPoint, ODSShort radius, ODSShort second, HDC hDC);
	
	
	
		
	virtual void Idle(Environment* ev, ODEventData* event);
	virtual ODBoolean HandleMouseDown(Environment* ev, ODFacet* facet, ODEventData* event);
	virtual ODBoolean HandleMouseUp(Environment* ev, ODFacet* facet, ODEventData* event);
	virtual void MouseEnter(Environment* ev,  ODFacet* facet, ODPoint* where);
	virtual void ActivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event);
	virtual void DeactivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event);
	virtual void Activate(Environment* ev);
	virtual void MinimizeFrameShape(Environment* ev);
	virtual void FacetAdded(Environment* ev, ODFacet* facet);
	virtual ODBoolean HandleMenuEvent(Environment* ev, ODEventData* event);
	virtual ODID ViewInWindow(Environment *ev);
	virtual void Add(Environment* ev);
	virtual void Connect(Environment* ev);
	virtual void Remove(Environment* ev);
	virtual void Close(Environment* ev);
	virtual void FrameShapeChanged(Environment* ev);
	virtual void FitToFrameShape(Environment* ev);
	virtual ODShape* GetNewFrameShape(Environment *ev);

private:
	HCURSOR				fCrossCursor; 			// cross cursor
	ODSLong 			fLastTime; 				// tick count last time we drew time
};

//=========================================================================
// ClockDialogFrame
//=========================================================================

class ClockDialogFrame : public ClockFrame
{
public:
	ClockDialogFrame();
	virtual ~ClockDialogFrame();
	void InitClockDialogFrame(Environment* ev, 
								ODSession* session,
								ODFrame* frame, 
								ClockPart* clockPart);
	
	virtual void Draw(Environment* ev, ODFacet* facet, ODShape* invalShape);
	virtual void Idle(Environment* ev, ODEventData* event);
	virtual void ActivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event);
	virtual void DeactivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event);
	
private:
};

//=========================================================================
// ClockSynchroDialogFrame
//=========================================================================

class ClockSynchroDialogFrame : public ClockDialogFrame
{
public:
	ClockSynchroDialogFrame();
	virtual ~ClockSynchroDialogFrame();
	void InitClockSynchroDialogFrame(Environment* ev, 
										ODSession* session,
										ODFrame* frame, 
										ClockPart* clockPart);

	virtual ODBoolean HandleMouseDown(Environment* ev, ODFacet* facet, ODEventData* event);
		
private:
};

//=========================================================================
// ClockSettingsDialogFrame
//=========================================================================

class ClockSettingsDialogFrame : public ClockDialogFrame
{
public:
	ClockSettingsDialogFrame();
	virtual ~ClockSettingsDialogFrame();
	void InitClockSettingsDialogFrame(Environment* ev, 
										ODSession* session,
										ODFrame* frame, 
										ClockPart* clockPart);

	virtual ODBoolean HandleMouseDown(Environment* ev, ODFacet* facet, ODEventData* event);
	
	
private:
};

//=========================================================================
// SOM methods for Clock
//=========================================================================

//-------------------------------------------------------------------------
// Constructor/Destructor
//-------------------------------------------------------------------------
	
SOM_Scope void  SOMLINK AppleTestClock_ClocksomInit(AppleTestClock_Clock *somSelf) 
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
	AppleTestClock_ClockMethodDebug("Clock","somInit");

    AppleTestClock_Clock_parents_somInit(somSelf);
		
	gSession = kODNULL;
	_fClockPart = kODNULL;
}

SOM_Scope void  SOMLINK AppleTestClock_ClockInitPart(AppleTestClock_Clock *somSelf, Environment *ev,
		ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","InitPart");

	if (somSelf->IsInitialized(ev))
		return;
		
	somSelf->InitPersistentObject(ev, storageUnit);
	
	ODSession* session = somSelf->GetStorageUnit(ev)->GetSession(ev); 
		//$$$$$ Shouldn't OpenDoc pass the session to InitPart?
	
	_fClockPart = new ClockPart;
	_fClockPart->InitClockPart(ev, session, somSelf, partWrapper);
	
	_fClockPart->PrepareStorage(ev, storageUnit); 
}
	
SOM_Scope void  SOMLINK AppleTestClock_ClockInitPartFromStorage(AppleTestClock_Clock *somSelf, Environment *ev,
		ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","InitPartFromStorage");

	if (somSelf->IsInitialized(ev))
		return;
	
	
	somSelf->InitPersistentObjectFromStorage(ev, storageUnit);
	
	ODSession* session = somSelf->GetStorageUnit(ev)->GetSession(ev); 
		//$$$$$ Shouldn't OpenDoc pass the session to InitPartFromStorage?

	_fClockPart = new ClockPart;
	_fClockPart->InitClockPart(ev, session, somSelf, partWrapper);
	_fClockPart->Internalize(ev, storageUnit);
	
}

	
SOM_Scope void  SOMLINK AppleTestClock_ClocksomUninit(AppleTestClock_Clock *somSelf)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","somUninit");

	delete _fClockPart;
	
    AppleTestClock_Clock_parents_somUninit(somSelf);

}
	


//-------------------------------------------------------------------------
// Implementation for DragAndDrop protocol:
//
//		The Drag and Drop protocol provides facilities for interaction with
//		the user during the dragging of OpenDoc objects. Only part handlers 
//		that support embedding of content need to implement the following
//		methods.
//
//		The Clock Part implements the ::DragEnter, ::DragLeave, and ::Drop
//		methods only to provide the user a bit of feedback while dragging
//		objects.
//
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Clock: FulfillPromise
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockFulfillPromise(AppleTestClock_Clock *somSelf, Environment *ev,
		ODStorageUnitView *promiseSUView)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","FulfillPromise");

ODUnused(promiseSUView);
	// Clock Part does not allow embedding of data.
	// This method is not needed.
}


//------------------------------------------------------------------------------
// Clock: DropCompleted
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockDropCompleted(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODPart* 		destPart, 
							   ODDropResult 	dropResult )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","DropCompleted");

ODUnused(destPart);
ODUnused(dropResult);

	// Clock Part does not allow embedding of data.
	// This method is not needed.
}


//------------------------------------------------------------------------------
// Clock: DragEnter 
//------------------------------------------------------------------------------


SOM_Scope ODDragResult  SOMLINK AppleTestClock_ClockDragEnter(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODDragItemIterator* dragInfo, 
					  ODFacet*            facet, 
					  ODPoint* 			   where ) 
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","DragEnter");

ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

	// SetCursor(&_fClockPart->fCrossCursor);
	
	return kODFalse;
}


//------------------------------------------------------------------------------
// Clock: DragWithin 
//------------------------------------------------------------------------------


SOM_Scope ODDragResult  SOMLINK AppleTestClock_ClockDragWithin(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODDragItemIterator*	dragInfo, 
					   ODFacet*            facet,
					   ODPoint* 		    where ) 
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","DragWithin");

ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

	// Clock Part does not allow embedding of data.
	// This method is not needed.

	return kODFalse;
}


//------------------------------------------------------------------------------
// Clock: DragLeave  
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockDragLeave(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODFacet*     facet, 
		ODPoint*		where ) 
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","DragLeave");

ODUnused(facet);
ODUnused(where);

	// SetCursor(&_fClockPart->fArrowCursor);
}


//------------------------------------------------------------------------------
// Clock: Drop 
//------------------------------------------------------------------------------



SOM_Scope ODDropResult SOMLINK AppleTestClock_ClockDrop(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODDragItemIterator* dropInfo, 
				 ODFacet*	           facet,
				 ODPoint* 			  where ) 
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","Drop");

ODUnused(dropInfo);
ODUnused(facet);
ODUnused(where);

	MessageBeep(MB_OK);
	
	return kODDropFail;
}


//-------------------------------------------------------------------------
// Implementation for Frame protocol:
//
//		The Frame protocol...
//
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Clock: DisplayFrameAdded 
//------------------------------------------------------------------------------



SOM_Scope void  SOMLINK AppleTestClock_ClockDisplayFrameAdded(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","DisplayFrameAdded");

	_fClockPart->DisplayFrameAdded(ev, frame);
}


//------------------------------------------------------------------------------
// Clock: DisplayFrameRemoved
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockDisplayFrameRemoved(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODFrame* oldFrame )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","DisplayFrameRemoved");

	if ( _fClockPart->ContainsDisplayFrame(ev, oldFrame))
	{	
		ClockFrame* clockFrame = (ClockFrame*) oldFrame->GetPartInfo(ev);
		
		clockFrame->Remove(ev);
		oldFrame->SetPartInfo(ev, (ODInfoType) kODNULL);
		delete clockFrame;

	}
}

//------------------------------------------------------------------------------
// Clock: DisplayFrameConnected
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockDisplayFrameConnected(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","DisplayFrameConnected");
    
	_fClockPart->DisplayFrameConnected(ev, frame);
}

//------------------------------------------------------------------------------
// Clock: DisplayFrameClosed
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockDisplayFrameClosed(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","DisplayFrameClosed");

	if ( _fClockPart->ContainsDisplayFrame(ev, frame))
	{	
		ClockFrame* clockFrame = (ClockFrame*) frame->GetPartInfo(ev);
		
		clockFrame->Close(ev);
		frame->SetPartInfo(ev, (ODInfoType) kODNULL);
		delete clockFrame;

	}

}

//------------------------------------------------------------------------------
// Clock: FacetAdded 
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockFacetAdded(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* facet)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","FacetAdded");
    
    ClockFrame* clockFrame = (ClockFrame*) facet->GetFrame(ev)->GetPartInfo(ev);
    if (clockFrame)
    	clockFrame->FacetAdded(ev, facet);	
}

//------------------------------------------------------------------------------
// Clock: FrameShapeChanged 
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockFrameShapeChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","FrameShapeChanged");

    ClockFrame* clockFrame = (ClockFrame*) frame->GetPartInfo(ev);
    if (clockFrame)
    	clockFrame->FrameShapeChanged(ev);	
}


//------------------------------------------------------------------------------
// Clock: WritePartInfo
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockWritePartInfo(AppleTestClock_Clock *somSelf, Environment *ev,
					ODPtr	 			partInfo, 
					ODStorageUnitView*	storageUnitView)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","WritePartInfo");

	
/* We don't need to do this if we don't care about coming up active when embedded
	if (partInfo)
	{
		ODBoolean needsActivating = ((ClockFrame*)partInfo)->fNeedsActivating 
									 || ((ClockFrame*)partInfo)->fIsActive;
		StorageUnitSetValue(storageUnitView, ev, sizeof(ODBoolean),
									(ODValue)&needsActivating);
	}
*/
}


//------------------------------------------------------------------------------
// Clock: ReadPartInfo
//------------------------------------------------------------------------------


SOM_Scope ODPtr  SOMLINK AppleTestClock_ClockReadPartInfo(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame, ODStorageUnitView*	storageUnitView)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","ReadPartInfo");

	//$$$$$ Shouldn't DisplayFrameConnected get called BEFORE ReadPartInfo?

	return _fClockPart->ReadPartInfo(ev, frame, storageUnitView);
}


//------------------------------------------------------------------------------
// Clock: Open
//------------------------------------------------------------------------------
 
	
SOM_Scope ODID  SOMLINK AppleTestClock_ClockOpen(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODFrame*  frame )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","Open");
	
	ODID windowID;

	if (frame) // Doing a View As Window
	{
		ClockFrame* clockFrame = (ClockFrame*) frame->GetPartInfo(ev);
		if (clockFrame)
			windowID = clockFrame->ViewInWindow(ev);
	}
	else
	{
		windowID = _fClockPart->OpenInitialWindow(ev);
	}
	return windowID;
}



//-------------------------------------------------------------------------
// Implementation for Imaging protocol
//-------------------------------------------------------------------------
	
//------------------------------------------------------------------------------
// Clock::Draw
//------------------------------------------------------------------------------
 
	
SOM_Scope void  SOMLINK AppleTestClock_ClockDraw(AppleTestClock_Clock *somSelf, 
												Environment *ev,
		 										ODFacet* facet, 
				 								ODShape* invalShape)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","Draw");

	ClockFrame* clockFrame = (ClockFrame*) facet->GetFrame(ev)->GetPartInfo(ev);
	if (clockFrame)
	{
		clockFrame->Draw(ev, facet, invalShape);
	}
}


//-------------------------------------------------------------------------
// Implementation for Linking protocol
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Clock: CreateLink
//------------------------------------------------------------------------------



SOM_Scope ODLink* SOMLINK AppleTestClock_ClockCreateLink(AppleTestClock_Clock *somSelf, Environment *ev,
		ODPtr data,
		ODULong size)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","CreateLink");

ODUnused(data);

	return kODNULL;
}


//------------------------------------------------------------------------------
// Clock: LinkUpdated
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockLinkUpdated(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODLink*  updatedLink, ODChangeID change)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","LinkUpdated");

ODUnused(updatedLink);
ODUnused(change);

	// does not support linking
}



//-------------------------------------------------------------------------
// Implementation for Memory Management protocol
//-------------------------------------------------------------------------

SOM_Scope ODSize SOMLINK AppleTestClock_ClockPurge(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODSize  size )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","Purge");

	ODStorageUnit* su = somSelf->GetStorageUnit(ev);
	return su -> Purge(ev,  size );
}


//-------------------------------------------------------------------------
// Implementation for Storage Management protocol
//-------------------------------------------------------------------------

//------------------------------------------------------------------------------
// Clock:  GetOrderedFrameCollection
//------------------------------------------------------------------------------


extern void GetOrderedFrameCollection(OrderedCollection* aCollection,ODStorageUnit* vfSU);

//------------------------------------------------------------------------------
// Clock:  PutOrderedFrameCollection
//------------------------------------------------------------------------------


extern void PutOrderedFrameCollection(OrderedCollection* aCollection,ODStorageUnit* vfSU);

//------------------------------------------------------------------------------
// Clock:  Externalize
//------------------------------------------------------------------------------

SOM_Scope void  SOMLINK AppleTestClock_ClockExternalize(AppleTestClock_Clock *somSelf, Environment *ev)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","Externalize");

	AppleTestClock_Clock_parent_ODPart_Externalize(somSelf,ev);
	
	_fClockPart->Externalize(ev);

}



//-------------------------------------------------------------------------
// Implementation for Part Activation protocol
//-------------------------------------------------------------------------
	
//------------------------------------------------------------------------------
// Clock: BeginRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope ODBoolean  SOMLINK AppleTestClock_ClockBeginRelinquishFocus(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODTypeToken 	focus,
									 ODFrame* 		currentFrame,
									 ODFrame* 		proposedFrame )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","BeginRelinquishFocus");

	ClockFrame* clockFrame = (ClockFrame*) currentFrame->GetPartInfo(ev);
	
	if (clockFrame)
		return clockFrame->BeginRelinquishFocus(ev, focus, proposedFrame); 
	else 
		return kODTrue;

}
	
	
//------------------------------------------------------------------------------
// Clock: CommitRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockCommitRelinquishFocus(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODTypeToken 	focus,
							ODFrame* 		currentFrame,
							ODFrame*		proposedFrame )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","CommitRelinquishFocus");

	ClockFrame* clockFrame = (ClockFrame*) currentFrame->GetPartInfo(ev);
	
	if (clockFrame)
		clockFrame->CommitRelinquishFocus(ev, focus, proposedFrame); 
}
	
							
//------------------------------------------------------------------------------
// Clock: AbortRelinquishFocus
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockAbortRelinquishFocus(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODTypeToken	focus,
								  ODFrame*		currentFrame,
								  ODFrame*		proposedFrame )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","AbortRelinquishFocus");

	ClockFrame* clockFrame = (ClockFrame*) currentFrame->GetPartInfo(ev);
	
	if (clockFrame)
		clockFrame->AbortRelinquishFocus(ev, focus, proposedFrame); 
}
			
							  
//------------------------------------------------------------------------------
// Clock: FocusAcquired
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockFocusAcquired(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODTypeToken	focus, 
						  ODFrame*		newOwner )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","FocusAcquired");

	ClockFrame* clockFrame = (ClockFrame*) newOwner->GetPartInfo(ev);
	
	if (clockFrame)
		clockFrame->FocusAcquired(ev, focus); 
}	


//------------------------------------------------------------------------------
// Clock: FocusLost
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockFocusLost(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODTypeToken	focus, 
					  ODFrame* 	oldOwner )
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","FocusLost");

	ClockFrame* clockFrame = (ClockFrame*) oldOwner->GetPartInfo(ev);
	
	if (clockFrame)
		clockFrame->FocusLost(ev, focus); 
}	


//-------------------------------------------------------------------------
// Implementation for UI Events protocol
//-------------------------------------------------------------------------
	
//------------------------------------------------------------------------------
// Clock: HandleEvent
//------------------------------------------------------------------------------


SOM_Scope ODBoolean  SOMLINK AppleTestClock_ClockHandleEvent(AppleTestClock_Clock *somSelf, Environment *ev,
		 				ODEventData* event,
						ODFrame* frame,
						ODFacet* facet)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","HandleEvent");

	ODBoolean	wasHandled = kODFalse;
	ClockFrame* clockFrame = (ClockFrame*) frame->GetPartInfo(ev);

	switch ( event -> message ) {
		case kODEvtNull:
			{
				if (clockFrame)
					clockFrame->Idle(ev, event);
				else
					_fClockPart->Idle(ev, event);
				wasHandled = kODTrue;
				break;
			}
			
		case WM_LBUTTONDOWN:
			if (facet == kODNULL)
			{
				MessageBeep(MB_OK);
				wasHandled = kODTrue;
			}
			else
			{
				wasHandled = clockFrame->HandleMouseDown(ev, facet, event);
			}
			break;

		case WM_LBUTTONUP:
			wasHandled = kODTrue;
			break;
									
		case kODEvtMouseDownEmbedded:
			break;
			
		case WM_ACTIVATE:
			wasHandled = TRUE; // actually ignored by dispatcher
			if (event->wParam  != WA_INACTIVE)
				clockFrame->ActivatingWindow(ev, facet, event);
			else
				clockFrame->DeactivatingWindow(ev, facet, event);
			break;
		case WM_KEYDOWN:
		case WM_CHAR:
			break;

		case WM_COMMAND:
			wasHandled = clockFrame->HandleMenuEvent(ev, event);
			break;

#ifdef PLATFORM_MACINTOSH	
		case kODEvtWindow: 
			{
				switch (event->message)
				{
					case inGoAway:
						wasHandled = _fClockPart->CloseWindow(ev, frame);
						break;
					case inZoomIn:
					case inZoomOut:
						SysBeep(2); 
						wasHandled = kODTrue;
						break;
					default:
						break;
				}
			}
			break;
		case kODEvtMouseEnter:
			clockFrame->MouseEnter(ev, facet, &(eventInfo->where));
			wasHandled = kODTrue;
			break;
		case kODEvtMouseWithin:
			clockFrame->MouseWithin(ev, facet, &(eventInfo->where));
			wasHandled = kODTrue;
			break;
		case kODEvtMouseLeave:
			clockFrame->MouseLeave(ev, facet);
			wasHandled = kODTrue;
			break;
#endif
		default:
			break;
	}
	
	return wasHandled;
}

//------------------------------------------------------------------------------
// Clock: AdjustMenus
//------------------------------------------------------------------------------

SOM_Scope void  SOMLINK AppleTestClock_ClockAdjustMenus(AppleTestClock_Clock *somSelf, Environment *ev,
		 ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","AdjustMenus");
    
    _fClockPart->AdjustMenus(ev, frame);
}




//-------------------------------------------------------------------------
// SemanticInterface
//-------------------------------------------------------------------------


SOM_Scope ODExtension* SOMLINK AppleTestClock_ClockGetExtension(AppleTestClock_Clock *somSelf, Environment *ev,
		ODType extensionName)
{
//    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","GetExtension");

	/* Not yet implemented
	ODISOStr	semtIntf = "SemanticInterface";
	if (!ODISOStrCompare( (ODISOStr)extensionName, semtIntf ))
		return ( (ODExtension*)_fClockPart->fSemanticInterface );
	else
	*/
	return kODNULL;
}


SOM_Scope ODBoolean  SOMLINK AppleTestClock_ClockHasExtension(AppleTestClock_Clock *somSelf, Environment *ev,
		ODType extensionName)
{
//    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("Clock","HasExtension");

	/* Not yet implemented
	ODISOStr	semtIntf = "SemanticInterface";
	if (!ODISOStrCompare( (ODISOStr)extensionName, semtIntf ))
		return ( _fClockPart->fHasSemanticInterface );
	else
	*/
		
	return kODFalse;
}

//------------------------------------------------------------------------------
// Clock: Stubs for unimplemented methods
//------------------------------------------------------------------------------


SOM_Scope void  SOMLINK AppleTestClock_ClockUndoAction(AppleTestClock_Clock *somSelf, Environment *ev,
		ODActionData actionState)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockUndoAction");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockRedoAction(AppleTestClock_Clock *somSelf, Environment *ev,
		ODActionData actionState)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockRedoAction");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockDisposeActionState(AppleTestClock_Clock *somSelf, Environment *ev,
		ODActionData actionState,
		ODDoneState doneState)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockDisposeActionState");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockWriteActionState(AppleTestClock_Clock *somSelf, Environment *ev,
		ODActionData actionState,
		ODStorageUnitView* storageUnitView)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockWriteActionState");
}

SOM_Scope ODActionData  SOMLINK AppleTestClock_ClockReadActionState(AppleTestClock_Clock *somSelf, Environment *ev,
		ODStorageUnitView* storageUnitView)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockReadActionState");

BGNBP
#ifdef PLATFORM_MACINTOSH
	ODActionData data;
	data._maximum = 0;
	data._length = 0;
	data._buffer = kODNULL;
	return ((ODActionData) data);
#endif
return NULL;
}

SOM_Scope void  SOMLINK AppleTestClock_ClockCloneInto(AppleTestClock_Clock *somSelf, Environment *ev,
		ODDraftKey key,
		ODStorageUnit* storageUnit,
		ODFrame* scopeFrame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockCloneInto");

	ODStorageUnit*	su = somSelf->GetStorageUnit(ev);
	ODDraft*		draft = su->GetDraft(ev);

	ODVolatile(draft);

	// $$$$$ Should clone directly into the argument storage unit, rather
	// than externalizing first!	
	somSelf->Externalize(ev);
	TRY
	
		ODID scopeFrameID = 0;
		if (scopeFrame != kODNULL)
			scopeFrameID = scopeFrame->GetStorageUnit(ev)->GetID(ev);
		su->CloneInto(ev, key, storageUnit, scopeFrameID);
		
	CATCH_ALL
	
		draft->AbortClone(ev, key);
		
	ENDTRY
}

SOM_Scope void  SOMLINK AppleTestClock_ClockExternalizeKinds(AppleTestClock_Clock *somSelf, Environment *ev,
		ODTypeList* kindset)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockExternalizeKinds");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockChangeKind(AppleTestClock_Clock *somSelf, Environment *ev,
		ODType kind)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockChangeKind");
}


SOM_Scope void  SOMLINK AppleTestClock_ClockCanvasUpdated(AppleTestClock_Clock *somSelf, Environment *ev,
		ODCanvas* canvas)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockCanvasUpdated");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockHighlightChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* facet)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockHighlightChanged");
}

SOM_Scope ODULong  SOMLINK AppleTestClock_ClockGetPrintResolution(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockGetPrintResolution");

	return 0;
}

SOM_Scope void  SOMLINK AppleTestClock_ClockRevealLink(AppleTestClock_Clock *somSelf, Environment *ev,
		ODLinkSource* linkSource)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockRevealLink");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockEmbeddedFrameChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame,
		ODChangeID change)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockEmbeddedFrameChanged");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockLinkStatusChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockLinkStatusChanged");
}


SOM_Scope void  SOMLINK AppleTestClock_ClockFacetRemoved(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* facet)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockFacetRemoved");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockCanvasChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* facet)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockCanvasChanged");
}

SOM_Scope ODFrame*  SOMLINK AppleTestClock_ClockRequestEmbeddedFrame(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* containingFrame,
		ODFrame* baseFrame,
		ODShape* frameShape,
		ODPart* embedPart,
		ODTypeToken viewType,
		ODTypeToken presentation,
		ODBoolean isOverlaid)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockRequestEmbeddedFrame");

BGNBP
#ifdef PLATFORM_MACINTOSH
	ODSetSOMException(ev, kODErrCannotEmbed);
#endif

    return kODNULL;
}

SOM_Scope void  SOMLINK AppleTestClock_ClockRemoveEmbeddedFrame(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* embeddedFrame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockRemoveEmbeddedFrame");
}

SOM_Scope ODShape*  SOMLINK AppleTestClock_ClockRequestFrameShape(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* frameShape)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockRequestFrameShape");

    return (frameShape);
}

SOM_Scope void  SOMLINK AppleTestClock_ClockUsedShapeChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* embeddedFrame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockUsedShapeChanged");
}

SOM_Scope ODShape*  SOMLINK AppleTestClock_ClockAdjustBorderShape(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* embeddedFacet,
		ODShape* shape)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockAdjustBorderShape");

	return shape;
}


SOM_Scope void  SOMLINK AppleTestClock_ClockViewTypeChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockViewTypeChanged");

	//$$$$$ Delegate to frame method. Clock doesn't yet support other view types 
}

SOM_Scope void  SOMLINK AppleTestClock_ClockPresentationChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockPresentationChanged");
	
	//$$$$$ Delegate to frame method. 
}

SOM_Scope void  SOMLINK AppleTestClock_ClockSequenceChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockSequenceChanged");
}


SOM_Scope void  SOMLINK AppleTestClock_ClockGeometryChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* facet, ODBoolean clipShapeChanged, ODBoolean externalTransformChanged)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockGeometryChanged");

	facet->Invalidate(ev, kODNULL, kODNULL); // Would be better to invalidate difference
	//$$$$$ Delegate to frame method
}


SOM_Scope void  SOMLINK AppleTestClock_ClockAttachSourceFrame(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame,
		ODFrame* sourceFrame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockAttachSourceFrame");
}


SOM_Scope void  SOMLINK AppleTestClock_ClockRelease(AppleTestClock_Clock *somSelf, Environment *ev)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockRelease");

	AppleTestClock_Clock_parent_ODPart_Release(somSelf, ev);
}

SOM_Scope void  SOMLINK AppleTestClock_ClockReleaseAll(AppleTestClock_Clock *somSelf, Environment *ev)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockReleaseAll");
}

SOM_Scope void  SOMLINK AppleTestClock_ClockContainingPartPropertiesChanged(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame,
		ODStorageUnit* propertyUnit)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockContainingPartPropertiesChanged");

    AppleTestClock_Clock_parent_ODPart_ContainingPartPropertiesChanged(somSelf,ev,frame,propertyUnit);
}

SOM_Scope ODStorageUnit*  SOMLINK AppleTestClock_ClockGetContainingPartProperties(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockGetContainingPartProperties");

BGNBP
#ifdef PLATFORM_MACINTOSH
	ODSetSOMException(ev, kODErrCannotEmbed);
#endif

	return kODNULL;
}

SOM_Scope ODBoolean  SOMLINK AppleTestClock_ClockRevealFrame(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* revealShape)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockRevealFrame");

BGNBP
#ifdef PLATFORM_MACINTOSH
	ODSetSOMException(ev, kODErrInvalidFrame);
#endif
	return kODFalse;
}

SOM_Scope void  SOMLINK AppleTestClock_ClockEmbeddedFrameSpec(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODObjectSpec* spec)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockEmbeddedFrameSpec");

BGNBP
#ifdef PLATFORM_MACINTOSH
	ODSetSOMException(ev, kODErrInvalidFrame);
#endif
}

SOM_Scope ODEmbeddedFramesIterator*  SOMLINK AppleTestClock_ClockCreateEmbeddedFramesIterator(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFrame* frame)
{
    AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
    AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","AppleTestClock_ClockCreateEmbeddedFramesIterator");

BGNBP
#ifdef PLATFORM_MACINTOSH
	ODSetSOMException(ev, kODErrCannotEmbed);
#endif

    return kODNULL;
}


/************************************************************************/
//bgn These functions appear to go away in the next drop of Opendoc
/************************************************************************/
SOM_Scope void  SOMLINK AppleTestClock_ClockMouseEnter(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)
{
	 AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
	 AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","MouseEnter");

//bgn	SetCursor(LoadCursor(NULL, IDC_CROSS)); // For now.
	ClockFrame* clockFrame = (ClockFrame*) facet->GetFrame(ev)->GetPartInfo(ev);
	clockFrame->MouseEnter(ev, facet, where);

}

SOM_Scope void  SOMLINK AppleTestClock_ClockMouseWithin(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)
{
	 AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
	 AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","MouseWithin");

	ClockFrame* clockFrame = (ClockFrame*) facet->GetFrame(ev)->GetPartInfo(ev);
	clockFrame->MouseWithin(ev, facet, where);
}

SOM_Scope void  SOMLINK AppleTestClock_ClockMouseLeave(AppleTestClock_Clock *somSelf, Environment *ev,
		ODFacet* facet)
{
	 AppleTestClock_ClockData *somThis = AppleTestClock_ClockGetData(somSelf);
	 AppleTestClock_ClockMethodDebug("AppleTestClock_Clock","MouseLeave");

//bgn	SetCursor(LoadCursor(NULL, IDC_ARROW)); // For now.
	ClockFrame* clockFrame = (ClockFrame*) facet->GetFrame(ev)->GetPartInfo(ev);
	clockFrame->MouseLeave(ev, facet);
}


//=========================================================================
// Methods of Implementation Classes
//=========================================================================

//=========================================================================
// ClockPart
//=========================================================================

ClockPart::ClockPart()
{
	fDisplayFrames = kODNULL;						// Create an empty collection for storing the list 
												// of frames to display	the "clock" in.	
#ifdef PLATFORM_MACINTOSH	
	fFont   = GetSysFont();					// Script Mgr: get the current system font
	fSize   = GetDefFontSize();				// Script Mgr: get the current default font size
	fStyle  = normal;							// Font Mgr: enum for plain style
#endif

#ifdef PLATFORM_WINDOWS
	fSize   = -17;								// Script Mgr: get the current default font size
	GetObject (GetStockObject(SYSTEM_FONT), sizeof(fFont), &fFont);
	fFont.lfHeight  		= fSize;
	fFont.lfWidth			= 0;
	fFont.lfOutPrecision	= 3;
	fFont.lfClipPrecision	= 2;
	fFont.lfPitchAndFamily	= 34;
	fFont.lfQuality			= PROOF_QUALITY;
	strcpy(fFont.lfFaceName,"Arial");
//bgn	fStyle  = eNormal;							// Font Mgr: enum for plain style
	fMode   = SRCCOPY;							// Quickdraw: set the text drawing mode to "source copy"
	fJustification = TA_LEFT;					// Script Mgr: get the current system justification
#endif

	fLastAscent = 0;								// Ascent of the fFont font - used in positioning for drawing
	
	fFontMenu.menu = kODNULL;
//bgn	fSizeMenu = kODNULL;
//bgn	fStyleMenu = kODNULL;
	fMenuBar = kODNULL;
//	fSemanticInterface = kODNULL;
	fTestClockSU = kODNULL;
	fWorkPort = kODNULL;
	
	fSettingsWindow = 0;
	fSettingsWindowWasShown = kODFalse;
	fAlarmEnabled = kODFalse;
	fAnalog = kODFalse;
	
	fPartsBinWin = 0;
	fPartsBinOpen = kODFalse;
	fPartWrapper = kODNULL;
	fSOMSelf = kODNULL;
}

ClockPart::~ClockPart()
{
	ODDeleteObject(fDisplayFrames);// Release the display frames collection.
									// Deletion of memory used by the object will be
									// reclaimed when the shell deletes the
									// instantiation.
									
//	ODDeleteObject(fSemanticInterface);		// Release the SemanticInterface extension.

	Environment* ev = somGetGlobalEnvironment();

	ODReleaseObject(ev,fMenuBar);
	ODReleaseObject(ev,fTestClockSU);
#ifdef PLATFORM_MACINTOSH
	DisposeWindow(fWorkPort);
#endif
}

void ClockPart::InitClockPart(Environment* ev, 
								ODSession* session,
								ODPart* somSelf, 
								ODPartWrapper* partWrapper)
{
	fSOMSelf = somSelf;
	fPartWrapper = partWrapper;
    
	fSession = session; //$$$$$ fSOMSelf->GetStorageUnit(ev)->GetSession(ev);				
	gSession = fSession;
	
	fArbitrator = fSession->GetArbitrator(ev);
	fDispatcher = fSession->GetDispatcher(ev);
	fWindowState = fSession->GetWindowState(ev);
	
	Rect r;
	SetRect(&r, 0,0,0,0);

	fModalFocus = fSession->Tokenize(ev, kODModalFocus);
	fTimePresentation   = fSession->Tokenize(ev, kClockFrame);
	fSynchronizePresentation  = fSession->Tokenize(ev, kSynchronizeFrame);
	fAlarmSettingsPresentation   = fSession->Tokenize(ev, kAlarmSettingsFrame);
	
	fDisplayFrames = new OrderedCollection;		// Create an empty collection for storing the list 
												// of frames to display	the "clock" in.	

	fFontMenu.menu = CreatePopupMenu();
	strcpy (fFontMenu.strMenu, "Fo&nt");
	fSettingsMenu.menu = CreatePopupMenu();
	strcpy (fSettingsMenu.strMenu, "&Settings");

	if (!fFontMenu.menu || !fSettingsMenu.menu)
		return; //OutputDebugString((LPSTR)"Error creating menus");

	AppendMenu(fFontMenu.menu, MF_ENABLED | MF_STRING, kODClockPart_Size_Font, "Set Font...");
	AppendMenu(fSettingsMenu.menu, MF_ENABLED | MF_STRING, cAnalog, "Analog");
	AppendMenu(fSettingsMenu.menu, MF_ENABLED | MF_STRING, cDigital, "Digital");
	this->BuildMenuBar(ev);

}

void ClockPart::PrepareStorage(Environment* ev, ODStorageUnit* storageUnit)
{
	storageUnit->AddProperty(ev, kODPropContents)->AddValue(ev, kODKindTestClock);	

	fTestClockSU = storageUnit->GetDraft(ev)->CreateStorageUnit(ev);

	fTestClockSU->AddProperty(ev,kPropClockType)->AddValue(ev, kODBoolean);	
	fTestClockSU->AddProperty(ev,kPropClockFont)->AddValue(ev, kODUShort);	
	fTestClockSU->AddProperty(ev,kPropClockStyle)->AddValue(ev, kODUShort);			
	fTestClockSU->AddProperty(ev,kPropClockSize)->AddValue(ev, kODUShort);		
	fTestClockSU->AddProperty(ev,kODPropDisplayFrames)->AddValue(ev, kODWeakStorageUnitRefs);
}

void ClockPart::Internalize(Environment* ev, ODStorageUnit* storageUnit)
{
	ODULong valueSize, offset;
	ODStorageUnitRef aSURef;
	ODFrame* aFrame;
	ODStorageUnit* su;
	
	su = storageUnit; //$$$$$ somSelf->GetStorageUnit(ev);
	su->Focus(ev, kODPropContents,kODPosSame,kODKindTestClock,1,kODPosFirstSib);

	su->GetValue(ev, sizeof(ODStorageUnitRef),&aSURef);
	if (su->IsValidStorageUnitRef(ev, aSURef))
		fTestClockSU = su->GetDraft(ev)->GetStorageUnit(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
#ifdef PLATFORM_MACINTOSH
	else
		WARN("No Clock SU");
#endif
	su = fTestClockSU;
	
	su->Focus(ev, kPropClockType,kODPosSame,kODBoolean,1,kODPosFirstSib);
//bgn	StorageUnitGetValue(su, ev, sizeof(ODBoolean), (ODValue)&fAnalog);
	su->GetValue(ev, sizeof(ODBoolean), (ODValue)&fAnalog);

	su->Focus(ev, kPropClockFont,kODPosSame,kODUShort,1,kODPosFirstSib);
//bgn	StorageUnitGetValue(su, ev, sizeof(ODSShort), (ODValue)&fFont);
#ifdef WIN32
	memset(&fFont, 0, sizeof(LOGFONT));
	memset(&(fFont), 0, sizeof(LOGFONT));
	LOGFONT_WIN16 lf16;
	memset(&lf16, 0, sizeof(lf16));
	su->GetValue(ev, sizeof(lf16), (ODValue)&lf16);
	fFont.lfHeight = lf16.lfHeight;
	fFont.lfWidth = lf16.lfWidth;
	fFont.lfEscapement = lf16.lfEscapement;
	fFont.lfOrientation = lf16.lfOrientation;
	fFont.lfWeight = lf16.lfWeight;
	fFont.lfItalic = lf16.lfItalic;
	fFont.lfUnderline = lf16.lfUnderline;
	fFont.lfStrikeOut = lf16.lfStrikeOut;
	fFont.lfCharSet = lf16.lfCharSet;
	fFont.lfOutPrecision = lf16.lfOutPrecision;
	fFont.lfClipPrecision = lf16.lfClipPrecision;
	fFont.lfQuality = lf16.lfQuality;
	fFont.lfPitchAndFamily = lf16.lfPitchAndFamily;
	strcpy(fFont.lfFaceName, lf16.lfFaceName);
#else
	su->GetValue(ev, sizeof(ODSShort), (ODValue)&fFont);
#endif

#ifdef PLATFORM_MACINTOSH
	su->Focus(ev, kPropClockStyle,kODPosSame,kODUShort,1,kODPosFirstSib);
	StorageUnitGetValue(su, ev, sizeof(ODSShort), (ODValue)&fStyle);
	su->Focus(ev, kPropClockSize,kODPosSame,kODUShort,1,kODPosFirstSib);
	StorageUnitGetValue(su, ev, sizeof(ODSShort), (ODValue)&fSize);
#endif
	
	su->Focus(ev, kODPropDisplayFrames,kODPosUndefined,0,1,kODPosFirstSib);
	valueSize = su->GetSize(ev);
	for (offset = 0; offset < valueSize; offset += sizeof(ODStorageUnitRef))
	{
		su->SetOffset(ev, offset);
		su->GetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
//bgn		StorageUnitGetValue(su, ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
		
		if (su->IsValidStorageUnitRef(ev, aSURef)) {
			aFrame = su->GetDraft(ev)->GetFrame(ev, su->GetIDFromStorageUnitRef(ev, aSURef));
			this->AddDisplayFrame(ev, aFrame);
		}
		else 
			aFrame = kODNULL;
	}
	
	// We should minimize the frame shape here, but we can't because I think that
	// the _fClockPart->fPart and _fClockPart->fPartInfo for the frame hasn't been set up yet.
	// somSelf->MinimizeFrameShape(ev, dispFrame);	
}


ODPtr ClockPart::ReadPartInfo(Environment *ev,
								ODFrame* frame, 
								ODStorageUnitView*	storageUnitView)
{
	if (storageUnitView->GetSize(ev))
	{
		ClockTimeFrame* partInfo = new ClockTimeFrame();
		partInfo->InitClockTimeFrame(ev, fSession, frame, this);
		
		/*
		ODBoolean needsActivating;
		StorageUnitGetValue(storageUnitView, ev, sizeof(ODBoolean),
									(ODValue)&(needsActivating));
		partInfo->fNeedsActivating = needsActivating;
		*/								
		return (ODPtr)partInfo;
	}
	else
		return ((ODPtr)kODNULL);
}

void ClockPart::Externalize(Environment *ev)
{
	ODFrame* aFrame;
	ODStorageUnitRef aSURef;
	ODULong offset, offsetLimit;
	ODStorageUnit* su = fTestClockSU;

	su->Focus(ev, kPropClockType,kODPosSame,kODBoolean,1,kODPosFirstSib);
#ifdef PLATFORM_WINDOWS
	su->SetValue(ev, sizeof(ODBoolean), (ODValue)&fAnalog);
#endif
#ifdef PLATFORM_MACINTOSH
	StorageUnitSetValue(su, ev, sizeof(ODBoolean), (ODValue)&fAnalog);
#endif
	su->Focus(ev, kPropClockFont,kODPosSame,kODUShort,1,kODPosFirstSib);
#ifdef WIN32
		LOGFONT_WIN16 lf16;
		memset((char *)&lf16, 0, sizeof(lf16));
		lf16.lfHeight = fFont.lfHeight;
		lf16.lfWidth = fFont.lfWidth;
		lf16.lfEscapement = fFont.lfEscapement;
		lf16.lfOrientation = fFont.lfOrientation;
		lf16.lfWeight = fFont.lfWeight;
		lf16.lfItalic = fFont.lfItalic;
		lf16.lfUnderline = fFont.lfUnderline;
		lf16.lfStrikeOut = fFont.lfStrikeOut;
		lf16.lfCharSet = fFont.lfCharSet;
		lf16.lfOutPrecision = fFont.lfOutPrecision;
		lf16.lfClipPrecision = fFont.lfClipPrecision;
		lf16.lfQuality = fFont.lfQuality;
		lf16.lfPitchAndFamily = fFont.lfPitchAndFamily;
		strcpy(lf16.lfFaceName, fFont.lfFaceName);

		su->SetValue(ev, sizeof(lf16), (ODValue)&lf16);
#else
	su->SetValue(ev, sizeof(ODSShort), (ODValue)&_fClockPart->fFont);
#endif

#ifdef PLATFORM_MACINTOSH
	StorageUnitSetValue(su, ev, sizeof(ODSShort), (ODValue)&fFont);
	su->Focus(ev, kPropClockStyle,kODPosSame,kODUShort,1,kODPosFirstSib);
	StorageUnitSetValue(su, ev, sizeof(ODSShort), (ODValue)&fStyle);
	su->Focus(ev, kPropClockSize,kODPosSame,kODUShort,1,kODPosFirstSib);
	StorageUnitSetValue(su, ev, sizeof(ODSShort), (ODValue)&fSize);
#endif
	
	OrderedCollectionIterator aIter(fDisplayFrames);
	su->Focus(ev, kODPropDisplayFrames,kODPosUndefined,0,1,kODPosFirstSib);
	offsetLimit = su->GetSize(ev);
	offset = 0;
	for (aFrame = (ODFrame*)aIter.First(); aIter.IsNotComplete();
											aFrame = (ODFrame*)aIter.Next(),
											offset+=sizeof(ODStorageUnitRef))
	{
		aSURef = su->GetWeakStorageUnitRef(ev, aFrame->GetStorageUnit(ev)->GetID(ev));
		su->SetOffset(ev, offset);
		su->SetValue(ev, sizeof(ODStorageUnitRef), (ODValue)&aSURef);
	}
	if (offset < offsetLimit)
		su->DeleteValue(ev, offsetLimit - offset);
		
	su = fSOMSelf->GetStorageUnit(ev);
	su->Focus(ev, kODPropContents,kODPosSame,kODKindTestClock,1,kODPosFirstSib);
	aSURef = su->GetStrongStorageUnitRef(ev, fTestClockSU->GetID(ev));
	su->SetValue(ev, sizeof(ODStorageUnitRef),&aSURef);

}



void ClockPart::DisplayFrameAdded(Environment *ev,
								  ODFrame* frame)
{
	if ( frame -> GetPart(ev) == (ODPart*)fPartWrapper) 
	{
		ODTypeToken presentation = frame->GetPresentation(ev);
		if (presentation == 0)
		{
			presentation = fTimePresentation;
			frame->SetPresentation(ev, presentation);
		}
			
		if (presentation == fTimePresentation)
		{
			ClockTimeFrame* timeFrame = new ClockTimeFrame();
			timeFrame->InitClockTimeFrame(ev, fSession, frame, this);
			frame->SetPartInfo(ev, (ODInfoType) timeFrame);
		}
		else if (presentation == fSynchronizePresentation)
		{
			ClockSynchroDialogFrame* dialogFrame = new ClockSynchroDialogFrame();
			dialogFrame->InitClockSynchroDialogFrame(ev, fSession, frame, this);
			frame->SetPartInfo(ev, (ODInfoType) dialogFrame);
		}
		else if (presentation == fAlarmSettingsPresentation)
		{
			ClockSettingsDialogFrame* dialogFrame = new ClockSettingsDialogFrame();
			dialogFrame->InitClockSettingsDialogFrame(ev, fSession, frame, this);
			frame->SetPartInfo(ev, (ODInfoType) dialogFrame);
		}

		ClockFrame* clockFrame = (ClockFrame*) frame->GetPartInfo(ev);
		if (clockFrame)
			clockFrame->Add(ev);
	}
}

void ClockPart::DisplayFrameConnected(Environment *ev,
								  ODFrame* frame)
{
	// Assumes only time frames get externalized.
	ClockTimeFrame* clockFrame = (ClockTimeFrame*) frame->GetPartInfo(ev);
	if (clockFrame == kODNULL)
	{
		clockFrame = new ClockTimeFrame();
		clockFrame->InitClockTimeFrame(ev, fSession, frame, this);
		frame->SetPartInfo(ev, (ODInfoType) clockFrame);
	}
	clockFrame->Connect(ev);
	
}

ODBoolean ClockPart::ContainsDisplayFrame(Environment* ev, ODFrame* frame)
{ 
	if (fDisplayFrames)
		return fDisplayFrames->Contains(frame);
	else
		return kODFalse;
}
	
void ClockPart::AddDisplayFrame(Environment* ev, ODFrame* frame)
{
	if (fDisplayFrames)
		fDisplayFrames->AddLast(frame);
}

void ClockPart::RemoveDisplayFrame(Environment* ev, ODFrame* frame)
{
	if (fDisplayFrames)
		fDisplayFrames->Remove(frame);
}

void ClockPart::BuildMenuBar(Environment* ev)
{
	if ((fMenuBar == kODNULL) || !(fMenuBar->IsValid(ev)))
	{
		fMenuBar = fWindowState->CopyBaseMenuBar(ev);

#ifdef PLATFORM_MACINTOSH
		fMenuBar->AddMenuLast(ev, kClock_FontMenuID, fFontMenu, fPartWrapper);
		fMenuBar->AddMenuLast(ev, kClock_SizeMenuID, fSizeMenu, fPartWrapper);
		fMenuBar->AddMenuLast(ev, kClock_StyleMenuID,fStyleMenu, fPartWrapper);
		fMenuBar->AddMenuLast(ev, kClock_SettingsMenuID, fSettingsMenu, fPartWrapper);
#endif
#ifdef PLATFORM_WINDOWS
		fMenuBar->AddMenuLast(ev, 0, &fFontMenu, (ODPart*)fPartWrapper);
		fMenuBar->AddMenuLast(ev, 0, &fSettingsMenu, (ODPart*)fPartWrapper);
#endif

#ifdef PLATFORM_MACINTOSH
		fMenuBar->RegisterCommand(ev, cAnalog, kClock_SettingsMenuID, 1);
		fMenuBar->RegisterCommand(ev, cDigital, kClock_SettingsMenuID, 2);
		fMenuBar->RegisterCommand(ev, cSynchronize, kClock_SettingsMenuID, 4);
		fMenuBar->RegisterCommand(ev, cShowSettings, kClock_SettingsMenuID, 5);
#endif
	}
}

void ClockPart::InstallMenus(Environment* ev)
{
	this->BuildMenuBar(ev);	
	
	fMenuBar->Display(ev);
	//fMenuBar->EnableCommand(ev, kODCommandShowPartsBin , kODTrue);
	//fMenuBar->EnableCommand(ev, cAnalog , kODTrue, fAnalog);
	//fMenuBar->EnableCommand(ev, cDigital , kODTrue, !fAnalog);

#ifdef PLATFORM_MACINTOSH	
	this->OutlineSizeMenu(ev);
	
	Str255	tFontName;

	GetFontName(fFont, tFontName );
	CheckMarkMenu(fFontMenu, tFontName, kODTrue );

	Str255	tSizeStr;
	
	NumToString( (ODULong)fSize, tSizeStr );
	CheckMarkMenu(fSizeMenu, tSizeStr, kODTrue);
	
	Str255	tStyleStr;
	
	StyleToString(fStyle, (Str255 *)&tStyleStr);
	CheckMarkMenu(fStyleMenu, tStyleStr, kODTrue );
#endif
}


void ClockPart::OutlineSizeMenu(Environment *ev)
{
#ifdef PLATFORM_MACINTOSH
	MenuHandle menu = GetMenuHandle( kClock_SizeMenuID );
	
	// () Outline the sizes in the font menu that are available
	
	if (RealFont(fFont, 9))
		SetItemStyle( menu, kClock_Size_9Pt, outline );
	else
		SetItemStyle( menu, kClock_Size_9Pt, normal );

	if (RealFont(fFont, 10))
		SetItemStyle( menu, kClock_Size_10Pt, outline );
	else
		SetItemStyle( menu, kClock_Size_10Pt, normal );

	if (RealFont(fFont, 11))
		SetItemStyle( menu, kClock_Size_11Pt, outline );
	else
		SetItemStyle( menu, kClock_Size_11Pt, normal );

	if (RealFont(fFont, 12))
		SetItemStyle( menu, kClock_Size_12Pt, outline );
	else
		SetItemStyle( menu, kClock_Size_12Pt, normal );

	if (RealFont(fFont, 14))
		SetItemStyle( menu, kClock_Size_14Pt, outline );
	else
		SetItemStyle( menu, kClock_Size_14Pt, normal );

	if (RealFont(fFont, 18))
		SetItemStyle( menu, kClock_Size_18Pt, outline );
	else
		SetItemStyle( menu, kClock_Size_18Pt, normal );

	if (RealFont(fFont, 24))
		SetItemStyle( menu, kClock_Size_24Pt, outline );
	else
		SetItemStyle( menu, kClock_Size_24Pt, normal );

	if (RealFont(fFont, 36))
		SetItemStyle( menu, kClock_Size_36Pt, outline );
	else
		SetItemStyle( menu, kClock_Size_36Pt, normal );
#endif
}

void ClockPart::HandleFontMenu(Environment *ev, ODFrame *frame)
{
#ifdef PLATFORM_MACINTOSH
	Str255		fontName;
	ODSShort	fontNum = 0;

	//MenuHandle fontMenu = GetMHandle( kClock_FontMenuID );
	ODPlatformMenu fontMenu = fMenuBar->GetMenu(ev,kClock_FontMenuID);

	GetFontName(fFont, fontName );
	CheckMarkMenu(fontMenu, fontName, kODFalse );
	GetMenuItemText( fontMenu, item, fontName );
	CheckMarkMenu(fontMenu, fontName, kODTrue );
	this->OutlineSizeMenu(ev);
	GetFNum( fontName, &fontNum );
	this->SetFont(ev, fontNum );
#endif

#ifdef PLATFORM_WINDOWS
	Str255		fontName;
	ODSShort	fontNum = 0;

	LOGFONT LogFont = fFont;
	m_ChooseFont (ev, frame, &LogFont);
	this->SetFont(ev, LogFont);	
#endif
}

void ClockPart::ShowAboutBox(Environment* ev, ODFrame* frame)
{
#ifdef PLATFORM_MACINTOSH
	ODFrame* currentOwner = fArbitrator->GetFocusOwner(ev, fModalFocus);
	if (fArbitrator->RequestFocus(ev, fModalFocus,frame))
	{
		short itemHit;
		ParamText("\pClock Part.",0,0,0);
		SetCursor(&ODQDGlobals.arrow);
		ModalFilterUPP modalFilter = NewModalFilterProc(AboutDialogFilter);
		
		ODSLong		savedRefNum;
		BeginUsingLibraryResources(savedRefNum);
		DialogPtr aboutDialog = GetNewDialog(kClock_AboutBoxID ,0,(WindowPtr)-1L);
		EndUsingLibraryResources(savedRefNum);

		if (aboutDialog)
		{
			fWindowState->DeactivateFrontWindows(ev);
			ShowWindow(aboutDialog);
			ModalDialog(modalFilter, &itemHit);
			DisposeDialog(aboutDialog);
			fWindowState->ActivateFrontWindows(ev);
		}
		DisposeRoutineDescriptor(modalFilter);

		fArbitrator->TransferFocus(ev, fModalFocus,frame, currentOwner);		
	}
	else
		SysBeep(2);
#endif

#ifdef PLATFORM_WINDOWS
	ODFrame* currentOwner = fArbitrator->GetFocusOwner(ev, fModalFocus);
	if (fArbitrator->RequestFocus(ev, fModalFocus, frame))
	{
		SetCursor(IDC_ARROW);  // For now.
		MessageBox (kODNULL, "Clock Part.", "Alert", MB_OK);
		fArbitrator->TransferFocus(ev, fModalFocus, frame, currentOwner);
	}
	else
		MessageBeep(MB_OK);
#endif	
}

void ClockPart::ShowSynchDialog(Environment* ev)
{
BGNBP
#ifdef PLATFORM_MACINTOSH
	ODSLong savedRefNum;
	BeginUsingLibraryResources(savedRefNum);
	
	DialogPtr synchDialog = GetNewDialog(kClock_SynchronizeDialogID ,0,(WindowPtr)-1L);
		EndUsingLibraryResources(savedRefNum);
	ODWindow* synchWindow = fWindowState->
									RegisterWindow(ev, synchDialog,
										kODNULL,
										 kODFalse,	// Keeps draft open
										 kODFalse,	// Is resizable
										 kODFalse,	// Is floating
										 kODFalse, // don't save
										 fPartWrapper, 
										 kODNullTypeToken, 
										 fSynchronizePresentation, 
										 kODNULL);
	
	if (synchDialog 
		&& (fArbitrator->RequestFocus(ev, fModalFocus,
					synchWindow->GetRootFrame(ev))))

	{
	
		//!!! Disable entire Menus. 
		
	// $$$$$ Cleanup! 
		const ODMenuID kDocumentMenuID = 129;
		const ODMenuID kEditMenuID = 130;
		
		fMenuBar->EnableCommand(ev,  kODCommandAbout, kODFalse ) ;

		fMenuBar->DisableAll(ev);
/*		ODPlatformMenu docMenu = fMenuBar->GetMenu(ev,kDocumentMenuID);
		ODPlatformMenu editMenu = fMenuBar->GetMenu(ev,kEditMenuID);
		ODPlatformMenu fontMenu = fMenuBar->GetMenu(ev,kClock_FontMenuID);
		if (docMenu)
			DisableItem(docMenu, 0);
		if (editMenu)
			DisableItem(editMenu, 0);
		if (fontMenu)
			DisableItem(fontMenu, 0);

		BeginUsingLibraryResources(savedRefNum);
		DisableItem(GetMenuHandle(kClock_SizeMenuID), 0);
		DisableItem(GetMenuHandle(kClock_StyleMenuID), 0);
		DisableItem(GetMenuHandle(kClock_SettingsMenuID), 0);
		EndUsingLibraryResources(savedRefNum);
*/		InvalMenuBar();
		
		SetCursor(&ODQDGlobals.arrow);
		synchWindow->Open(ev);
		synchWindow->Show(ev);
		synchWindow->Select(ev);
		
	}
#endif
}

void ClockPart::ShowSettingsDialog(Environment* ev)
{
BGNBP
#ifdef PLATFORM_MACINTOSH
	ODWindow* settingsWindow = fWindowState->GetWindow(ev, fSettingsWindow);

	if (settingsWindow)
	{
		settingsWindow->Select(ev);
		settingsWindow->Show(ev);
	}
	else
	{
		ODSLong savedRefNum;
		
		BeginUsingLibraryResources(savedRefNum);
		DialogPtr settingsDialog = GetNewDialog(kClock_SettingsDialogID ,0,(WindowPtr)-1L);
		EndUsingLibraryResources(savedRefNum);
		
		settingsWindow = fSOMSelf->GetStorageUnit(ev)->GetSession(ev)->GetWindowState(ev)->
							RegisterWindow(ev, settingsDialog, 
								kODNULL,
								 kODFalse,	// Keeps draft open
								 kODFalse,	// Is resizable
								 kODFalse,	// Is floating
								 kODFalse,	// don't save
								 fPartWrapper, kODNullTypeToken, fAlarmSettingsPresentation, kODNULL);

		
		if (settingsDialog && settingsWindow)
		{
			settingsWindow->Open(ev);
			settingsWindow->Show(ev);
			settingsWindow->Select(ev);
			fSettingsWindow = settingsWindow->GetID(ev);
		}
	}
#endif
}

#ifdef PLATFORM_MACINTOSH
void ClockPart::HandleSizeMenu(Environment *ev, ODUShort item)
{
	ODSShort	fontSize = 0;
	
	MenuHandle clockMenuH = GetMenuHandle( kClock_SizeMenuID );
	Str255	tSizeStr;
	
	NumToString( (ODULong)fSize, tSizeStr );
	CheckMarkMenu(clockMenuH, tSizeStr, kODFalse );
	
	switch (item) {
		case kClock_Size_9Pt:	fontSize =  9; break;
		case kClock_Size_10Pt:	fontSize = 10; break;
		case kClock_Size_11Pt:	fontSize = 11; break;
		case kClock_Size_12Pt:	fontSize = 12; break;
		case kClock_Size_14Pt:	fontSize = 14; break;
		case kClock_Size_18Pt:	fontSize = 18; break;
		case kClock_Size_24Pt:	fontSize = 24; break;
		case kClock_Size_36Pt:	fontSize = 36; break;
		default:
			fontSize = 12;
	}
	
	this->SetFontSize(ev, fontSize );

	NumToString( (ODULong)fontSize, tSizeStr );
	CheckMarkMenu(clockMenuH, tSizeStr, kODTrue );
	this->OutlineSizeMenu(ev);
}

void ClockPart::HandleStyleMenu(Environment *ev, ODUShort item)
{
	ODUByte	fontStyle = normal;
	
	MenuHandle clockMenuH = GetMenuHandle( kClock_StyleMenuID );
	Str255	tStyleStr;
	
	StyleToString(fStyle, (Str255 *)&tStyleStr);
	CheckMarkMenu(clockMenuH, tStyleStr, kODFalse );
	
	switch (item) 
	{
		case kClock_Style_Plain:		fontStyle = normal; break;
		case kClock_Style_Bold:		fontStyle = bold; break;
		case kClock_Style_Italic:	fontStyle = italic; break;
		case kClock_Style_Underline:	fontStyle = underline; break;
		case kClock_Style_Outline:	fontStyle = outline; break;
		case kClock_Style_Shadow:	fontStyle = shadow; break;
		case kClock_Style_Condense:	fontStyle = condense; break;
		case kClock_Style_Extend:	fontStyle = extend; break;
		default:
			;
	}
	
	this->SetFontStyle(ev, fontStyle);

	StyleToString( fontStyle, (Str255 *)&tStyleStr);
	CheckMarkMenu(clockMenuH, tStyleStr, kODTrue );
}
#endif

void ClockPart::SetAnalog(Environment* ev, ODBoolean analog)
{
	if (fAnalog != analog) 
	{
		fAnalog = analog;
		fSOMSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
	}
}

void ClockPart::SetFont(Environment *ev, LOGFONT lf)
{
#ifdef PLATFORM_WINDOWS
//skn	if (_fClockPart->fFont != lf) {
		fFont = lf;
		fSOMSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
//skn	}
#endif
}							 

#ifdef PLATFORM_MACINTOSH
void ClockPart::SetFontSize(Environment *ev, ODSShort fontSize)
{
	if (fSize != fontSize) 
	{
		fSize = fontSize;
		fSOMSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
	}
}

void ClockPart::SetFontStyle(Environment *ev, ODUByte fontStyle )
{
	if (fStyle != fontStyle) 
	{
		fStyle = fontStyle;
		fSOMSelf->GetStorageUnit(ev)->GetDraft(ev)->SetChangedFromPrev(ev);
	}
}
#endif

ODWindow*  ClockPart::CLKCreateWindow(Environment *ev,ODFrame* sourceFrame)
{
	ODRect rect(0,0,0,0);
	Rect windRect;
	ODPlatformWindow platformWindow = kODNULL;
	ODWindow* window = kODNULL;
		
	this->CalcClockBounds(windRect);
	//rect.Offset(40,40);
	//rect.AsQDRect(windRect);
	OffsetRect(&windRect, 40, 40);

#ifdef PLATFORM_MACINTOSH
	platformWindow = NewCWindow(kODNULL, &windRect, "\pClock", false, zoomDocProc/*rDocProc*/, (WindowPtr)-1L, true, kODNULL);
#endif

#ifdef PLATFORM_WINDOWS
	platformWindow =  fSession->GetWindowState(ev)->CreatePlatformWindow(ev, kODFalse,
		WS_CHILD | WS_CLIPSIBLINGS);
#endif

	window =  fWindowState->
				RegisterWindow(ev, platformWindow, 
							kODNULL,
							(sourceFrame==kODNULL),	// is root
							kODTrue,			// Is resizable
							kODFalse,			// Is floating
							kODTrue,			// should save
							(ODPart*)fPartWrapper, 
							(fSession->Tokenize(ev, kODViewAsFrame)), 
							fTimePresentation, 
							sourceFrame);
	
	return window;
}

ODID ClockTimeFrame::ViewInWindow(Environment *ev)
{
	ODWindow* window = kODNULL;
	
	window = fWindowState->GetWindow(ev, fWindowID);
	if (window)
		window->Select(ev);
	else
	{
		window = fClockPart->CLKCreateWindow(ev, fFrame);
		fWindowID = window->GetID(ev);
		window->Open(ev);
		window->Show(ev);
		window->Select(ev);			
	}
	return fWindowID;
}

ODID ClockPart::OpenInitialWindow(Environment *ev)
{
	ODWindow* window = kODNULL;

	window = this->CLKCreateWindow(ev, kODNULL);
	ODID windowID = window->GetID(ev);
	window->Open(ev);
	window->Show(ev);
	window->Select(ev);	
	return windowID;			
}

//------------------------------------------------------------------------------
// ClockPart::ShowPartsBin
//------------------------------------------------------------------------------


void ClockPart::ShowPartsBin(Environment *ev, ODFrame* frame)
{
	ODPart*			partsbin;
	ODStorageUnit*		su = fSOMSelf->GetStorageUnit(ev);
	ODStorageUnit*		pbSU;
	ODStorageUnitRef	pbSURef;
	ODStorageUnitID	pbSUID;
	
	if (!su->Exists(ev, kODPropPartsBin,kODStrongStorageUnitRef,0))
	{
		su->AddProperty(ev, kODPropPartsBin)->AddValue(ev, kODStrongStorageUnitRef);

		partsbin = su->GetDraft(ev)->CreatePart(ev, kODKindPartsBin, kODNULL);
#ifdef PLATFORM_MACINTOSH
		ASSERTM(partsbin != kODNULL, kODErrCannotCreatePart, "Cannot Create Parts Bin");
#endif
		
		pbSU = partsbin->GetStorageUnit(ev);
BGNBP
#ifdef PLATFORM_MACINTOSH
		su->GetStrongStorageUnitRef(ev, pbSU->GetID(ev), pbSURef);
		StorageUnitSetValue(su, ev, sizeof(kODStrongStorageUnitRef), pbSURef);
#endif
	}
	else
	{
		su->Focus(ev, kODPropPartsBin,kODPosSame,kODStrongStorageUnitRef,1,kODPosFirstSib);
		su->SetOffset(ev, 0);
BGNBP
#ifdef PLATFORM_MACINTOSH
		StorageUnitGetValue(su, ev, sizeof(kODStrongStorageUnitRef), (ODValue)&pbSURef);
		
		if (su->IsValidStorageUnitRef(ev, pbSURef))
			pbSUID = su->GetIDFromStorageUnitRef(ev, pbSURef);
		else
			WARN("No PartsBin for Clock.");
		partsbin = su->GetDraft(ev)->GetPart(ev, pbSUID);
#endif
	}
	
	fPartsBinWin = partsbin->Open(ev,frame);
	partsbin->Release(ev);
	fPartsBinOpen = kODTrue;
}

void ClockPart::HidePartsBin(Environment *ev, ODFrame* frame)
{
	if (fPartsBinOpen && fPartsBinWin)
	{
		ODWindow* pbWin = fWindowState->GetWindow(ev, fPartsBinWin);
BGNBP
#ifdef PLATFORM_MACINTOSH
		ASSERTM(pbWin != kODNULL, kODErrCannotGetWindow, "Cannot Hide Parts Bin");
#endif

		pbWin->Hide(ev);
		fPartsBinOpen = kODFalse;
	}
}

void ClockPart::ShowHidePartsBin(Environment *ev, ODFrame* frame)
{
	if (fPartsBinOpen)
		this->HidePartsBin(ev, frame); 
	else
		this->ShowPartsBin(ev, frame); 
}

void  ClockPart::AdjustMenus(Environment *ev, ODFrame* frame)
{
	//fMenuBar->EnableCommand(ev, kODCommandViewAsWin, !frame->IsRoot(ev));
	fMenuBar->EnableCommand(ev, kODCommandViewAsWin, kODFalse);
	fMenuBar->EnableCommand(ev, kODCommandShowPartsBin, kODFalse); // DIsabled
	fMenuBar->EnableAndCheckCommand(ev, cAnalog , kODTrue, fAnalog);
	fMenuBar->EnableAndCheckCommand(ev, cDigital , kODTrue, !fAnalog);
	fMenuBar->EnableCommand(ev, kODClockPart_Size_Font, kODTrue);
	fMenuBar->EnableCommand(ev, kODCommandPageSetup, kODFalse);

	Str255		fontName;
	ODPlatformMenuBar fontMenu = fMenuBar->GetMenu(ev,kClock_FontMenuID);
#ifdef PLATFORM_MACINTOSH
	GetFontName(fFont, fontName );
	CheckMarkMenu(fontMenu, fontName, kODTrue );
#endif

	ODIText*	menuItem;
	menuItem = CreateIText(kODRomanScript, kODEnglishLang, "About Clock.");
	fMenuBar->SetItemString(ev, kODCommandAbout, menuItem);
	DisposeIText(menuItem);
	
	if (fPartsBinWin)
	{
		ODWindow* window = fWindowState->GetWindow(ev, fPartsBinWin);
		if (window) 
			fPartsBinOpen = window->IsActive(ev);			// <eeh> was IsShown(ev);
		else
			fPartsBinOpen = kODFalse;		// $$$$$ SHOULD NEVER HAPPEN - BAD!!!!
	}
	
	if (fPartsBinOpen)
	{
		menuItem = CreateIText(kODRomanScript, kODEnglishLang, "Hide Parts Bin");
	}
	else
	{
		menuItem = CreateIText(kODRomanScript, kODEnglishLang, "Show Parts Bin");
	}
	fMenuBar->SetItemString(ev, kODCommandShowPartsBin, menuItem);
	DisposeIText(menuItem);
}

void ClockPart::AcquiredSelectionFocus(Environment* ev, ClockFrame* frame)
{
	ODWindow* settingsWindow = fWindowState->GetWindow(ev, fSettingsWindow);
	if (settingsWindow && fSettingsWindowWasShown)
		settingsWindow->Show(ev);
}

void ClockPart::LostSelectionFocus(Environment* ev, ClockFrame* frame)
{
	ODWindow* settingsWindow = fWindowState->GetWindow(ev, fSettingsWindow);
	if (settingsWindow && settingsWindow->IsShown(ev))
	{
		fSettingsWindowWasShown = kODTrue;
		settingsWindow->Hide(ev);
	}
}

ODBoolean ClockPart::CloseWindow(Environment* ev, ODFrame* frame)
{
	ODWindow*	window = frame->GetWindow(ev);
	ODWindow* settingsWindow = fWindowState->GetWindow(ev, fSettingsWindow);
	if ((window == settingsWindow) && settingsWindow) 
	{
		settingsWindow->Hide(ev);
		return kODTrue;
	}
	else
		return kODFalse;
}

ODShape* ClockPart::CreateOvalShape(Environment* ev, ODFrame* frame, Rect& rect)
{
#ifdef PLATFORM_MACINTOSH
	GrafPtr savedPort;
	GetPort(&savedPort);
	SetPort(fWorkPort);
	RgnHandle region = NewRgn();
	OpenRgn();
	FrameOval(&rect);
	CloseRgn(region);
	
	ODShape* newShape = frame->CreateShape(ev);
	newShape->SetQDRegion(ev, region);
	SetPort(savedPort);
#endif

#ifdef PLATFORM_WINDOWS
	HRGN region = CreateEllipticRgnIndirect(&rect);

	ODShape* newShape = frame->CreateShape(ev);
	newShape->SetWinRegion(ev, region);
#endif

	return newShape;
}

#define ff(N)		( (ODCoordinate)(N) <<16 )	// Converts integer to fixed (ODCoordinate)

void ClockPart::CalcClockBounds(Rect& rect)
{
	if (fAnalog)
		SetRect(&rect, 0,0,150,150);
	else
	{
#ifdef PLATFORM_MACINTOSH
		GrafPtr savedPort;
		GetPort(&savedPort);
		SetPort(fWorkPort);
		
		TextFont(fFont);
		TextFace(fStyle );
		TextMode(srcCopy );
		TextSize(fSize );
	
		FontInfo fontIRec;
		GetFontInfo( &fontIRec );
		fLastAscent = fontIRec.ascent;
		
										//   move to resource for localization
		//rect.Set(0, 0, ff(StringWidth("\p12:59:59 MM")+4),
		//			  ff((fontIRec.ascent+fontIRec.descent+fontIRec.leading)+2) );
		SetRect(&rect, 0, 0, StringWidth("\p12:59:59 MM")+4,
					  (fontIRec.ascent+fontIRec.descent+fontIRec.leading)+2 );
		SetPort(savedPort);
#endif

#ifdef PLATFORM_WINDOWS

		HDC hdc = GetDC (GetDesktopWindow());
		HFONT		hDrawFont = CreateFontIndirect (this->GetFont());
		HFONT		hOldFont;
		hOldFont = SelectObject (hdc, hDrawFont);
		TEXTMETRIC tm;
		SIZE sz;
		GetTextMetrics (hdc, &tm);
		GetTextExtentPoint32 (hdc, "MMM MMM 99, 12:59:59 MM", 23, &sz);
		SelectObject (hdc, hOldFont);
		DeleteObject (hDrawFont);
		ReleaseDC (GetDesktopWindow(), hdc);

		fLastAscent = tm.tmAscent;

		SetRect(&rect, 0, 0, sz.cx+4,(tm.tmHeight+tm.tmExternalLeading)+2 );
#endif
	}
}


//------------------------------------------------------------------------------
// Clock:  m_ChooseFont
//------------------------------------------------------------------------------

LOGFONT * ClockPart::m_ChooseFont (Environment *ev, ODFrame*  frame, LOGFONT * pLogFont)
{
	int			rc;
	CHOOSEFONT 	cf;
	HWND		hwndFocus;
	ODFrameFacetIterator* fiter = frame->CreateFacetIterator(ev);
	HWND 		hwnd = fiter->First(ev)->GetWindow(ev)->GetPlatformWindow(ev);
	delete fiter;
										
	memset(&cf, 0, sizeof(CHOOSEFONT));	// Set all structure fields to zero.

	cf.lStructSize 	= sizeof(CHOOSEFONT);
	cf.hwndOwner 	= hwnd;
	cf.lpLogFont 	= pLogFont;
	cf.Flags 		= CF_SCREENFONTS | CF_EFFECTS | CF_SCALABLEONLY |
					  CF_INITTOLOGFONTSTRUCT;
	cf.rgbColors 	= RGB(0, 0, 0);		// black
	cf.nFontType 	= SCREEN_FONTTYPE;

	/* Focus-pocus to help us do the right thing in OLE2 containers
	 */
	hwndFocus		= GetFocus();
	rc				= ChooseFont(&cf);
	SetFocus(hwndFocus);

	return rc ? pLogFont : (LOGFONT *)NULL;
}



#ifndef _STORUTIL_
#include <StorUtil.h>
#endif

#pragma segment ClockFrame


//=========================================================================
// ClockFrame
//=========================================================================

ClockFrame::ClockFrame()
{
//bgn	fArrowCursor = (ODQDGlobals.arrow);				
	fFrame = kODNULL;
	fClockPart = kODNULL;
	fIsActive = kODFalse; 
	fNeedsActivating = kODFalse; 
	fFocusSet = kODNULL;
	fWindowID = 0;
}


ClockFrame::~ClockFrame()
{
#ifdef PLATFORM_WINDOWS
	if (fHourPen)
		DeleteObject(fHourPen);
	if (fMinutePen)
		DeleteObject(fHourPen);
	if (fSecondPen)
		DeleteObject(fHourPen);
#endif
}


void ClockFrame::InitClockFrame(Environment* ev, 
								ODSession* session,
								ODFrame* frame, 
								ClockPart* clockPart)
{
	fSession = session;
	fArbitrator = fSession->GetArbitrator(ev);
	fDispatcher = fSession->GetDispatcher(ev);
	fWindowState = fSession->GetWindowState(ev);

	fFrame = frame;
	fClockPart = clockPart;
#if 1
	// The way it should be:
	fFocusSet = fArbitrator->CreateFocusSet(ev);
#else
	fFocusSet = new ODFocusSet();
	fFocusSet->InitFocusSet(ev);
#endif
	fSelectionFocus = fSession->Tokenize(ev, kODSelectionFocus);
	fMenuFocus = fSession->Tokenize(ev, kODMenuFocus);
	fKeyFocus = fSession->Tokenize(ev, kODKeyFocus);
	fModalFocus = fSession->Tokenize(ev, kODModalFocus);
#ifdef PLATFORM_WINDOWS
	fHourPen = CreatePen(PS_SOLID, 3, RGB(255, 255, 255));
	fMinutePen = CreatePen(PS_SOLID, 2, RGB(255, 255, 255));
	fSecondPen = CreatePen(PS_SOLID, 1, RGB(255, 255, 255));
#endif
}

void ClockFrame::MouseEnter(Environment* ev, ODFacet* facet, ODPoint* where)
{
	ODUnused(facet);
	ODUnused(where);
//bgn	SetCursor(&fArrowCursor);
}

void ClockFrame::MouseWithin(Environment* ev, ODFacet* facet, ODPoint* where)
{
	ODUnused(facet);
	ODUnused(where);
}

void ClockFrame::MouseLeave(Environment* ev, ODFacet* facet)
{
	ODUnused(facet);
//bgn	SetCursor(&fArrowCursor);
}

//------------------------------------------------------------------------------
// ClockFrame::BeginRelinquishFocus
//------------------------------------------------------------------------------


ODBoolean ClockFrame::BeginRelinquishFocus(Environment *ev,
		 									ODTypeToken focus,
									 		ODFrame* proposedFrame)
{
	ODUnused(proposedFrame);

	if ((focus == fModalFocus) && (proposedFrame->GetPart(ev) != (ODPart*)fClockPart->GetPartWrapper()))
		return kODFalse;
	else
		return kODTrue;
}
	
	
//------------------------------------------------------------------------------
// ClockFrame::CommitRelinquishFocus
//------------------------------------------------------------------------------


void ClockFrame::CommitRelinquishFocus(Environment *ev,
		 								ODTypeToken focus,
									 	ODFrame* proposedFrame)
{
	if (proposedFrame->GetPart(ev) != (ODPart*)fClockPart->GetPartWrapper())
		this->FocusLost(ev, focus);
}
	
							
//------------------------------------------------------------------------------
// ClockFrame::AbortRelinquishFocus
//------------------------------------------------------------------------------


void ClockFrame::AbortRelinquishFocus(Environment *ev,
		 								ODTypeToken	focus,
								 		ODFrame* proposedFrame)
{
	ODUnused(focus);
	ODUnused(proposedFrame);
}
			
							  
//------------------------------------------------------------------------------
// ClockFrame::FocusAcquired
//------------------------------------------------------------------------------


void ClockFrame::FocusAcquired(Environment *ev,
		 						ODTypeToken	focus)
{
	if (focus == fSelectionFocus) 
	{
		fIsActive = kODTrue;
	}
	else if (focus == fMenuFocus) 
		fClockPart->InstallMenus(ev);
}	


//------------------------------------------------------------------------------
// ClockFrame::FocusLost
//------------------------------------------------------------------------------


void ClockFrame::FocusLost(Environment *ev,
		 					ODTypeToken	focus)
{
	if (focus == fSelectionFocus) 
	{	
		fIsActive = kODFalse;
		fClockPart->LostSelectionFocus(ev, this);

	}
	else if (focus == fMenuFocus) 
	{
		fClockPart->GetMenuBar()->EnableCommand(ev, kODCommandShowPartsBin , kODFalse);
	}

}	

void ClockFrame::Add(Environment* ev)
{
	fClockPart->AddDisplayFrame(ev, fFrame);
	fFrame -> IncrementRefCount(ev);
}

void ClockFrame::Connect(Environment* ev)
{
	fClockPart->AddDisplayFrame(ev, fFrame);
	fFrame -> IncrementRefCount(ev);
}

void ClockFrame::Remove(Environment* ev)
{
	fArbitrator->RelinquishFocusSet(ev, fFocusSet,fFrame);
	fClockPart->RemoveDisplayFrame(ev, fFrame);

	fFrame -> Release(ev);
}

void ClockFrame::Close(Environment* ev)
{
	fArbitrator->RelinquishFocusSet(ev, fFocusSet,fFrame);
	fClockPart->RemoveDisplayFrame(ev, fFrame);

	fFrame -> Release(ev);
}

//=========================================================================
// ClockTimeFrame
//=========================================================================

ClockTimeFrame::ClockTimeFrame()
{
//bgn	fCrossCursor = (ODQDGlobals.arrow);		
	fLastTime = 0;
};

ClockTimeFrame::~ClockTimeFrame()
{
}

void ClockTimeFrame::InitClockTimeFrame(Environment* ev, 
										ODSession* session,
										ODFrame* frame, 
										ClockPart* clockPart)
{
	this->InitClockFrame(ev, session, frame, clockPart);
//bgn	fCrossCursor = **GetCursor(crossCursor);	

	fFocusSet->Add(ev, fKeyFocus);
	fFocusSet->Add(ev, fMenuFocus);
	fFocusSet->Add(ev, fSelectionFocus);

	if (frame->IsRoot(ev))
		fNeedsActivating = kODTrue;
}

void ClockTimeFrame::MouseEnter(Environment* ev, ODFacet* facet, ODPoint* where)
{
	ODUnused(where);
	ODUnused(facet);
	//SetCursor(&fCrossCursor);
	SetCursor(&fArrowCursor);
}

void ClockTimeFrame::Idle(Environment* ev, ODEventData* event)
{
	ODBoolean	wasHandled = kODFalse;

#ifdef PLATFORM_MACINTOSH
	ODULong	tTickCount = 0;
	GetDateTime( &tTickCount );
#endif

#ifdef PLATFORM_WINDOWS
	ODSLong	tTickCount = 0;
	time( &tTickCount );
#endif


#ifdef PLATFORM_MACINTOSH
	DateTimeRec time;
	DateTimeRec lastTime;
	
	::SecondsToDate(tTickCount, &time);
	::SecondsToDate(fLastTime, &lastTime);
	
	if (lastTime.second != time.second)
	//if ( (tTickCount + 60) > fLastTime )
#endif

#ifdef PLATFORM_WINDOWS
	if ( tTickCount > fLastTime )
#endif
	{
		ODFrameFacetIterator* facets = fFrame->CreateFacetIterator(ev);
		for ( ODFacet* facet = facets->First(ev);
				facets->IsNotComplete(ev);
				facet = facets->Next(ev) )
		{
			this->UpdateTime(ev, facet, tTickCount);
		}
		delete facets;
	}

	if (fClockPart->AlarmEnabled() &&  (tTickCount % 10 == 0))
	{
		ODFrame* focusFrame = fArbitrator->GetFocusOwner(ev, fModalFocus);

		if (focusFrame == fFrame)
			MessageBeep(MB_OK);
		else if (fArbitrator->RequestFocus(ev, fModalFocus,fFrame))
		{
			ODSLong		savedRefNum;
#ifdef PLATFORM_MACINTOSH
			BeginUsingLibraryResources(savedRefNum);
			ParamText("\pWake Up!",0,0,0);
			ModalFilterUPP modalFilter = NewModalFilterProc(ClockDialogFilter);
			Alert(kClock_AlarmDialogID, modalFilter);
			DisposeRoutineDescriptor(modalFilter);
			fArbitrator->TransferFocus(ev, fModalFocus,fFrame, focusFrame);			
			EndUsingLibraryResources(savedRefNum);
#endif
		}
		else
			MessageBeep(2);
		
	}
}

void ClockTimeFrame::Draw(Environment* ev, ODFacet* facet, ODShape* invalShape)
{
	if (facet)
	{
		HDC hdc;
		CFocus	focus(facet, invalShape, &hdc);
			
		this->DrawClockFace(ev, facet, hdc);
		this->DrawTime(ev, facet, fLastTime, hdc);
	}
}

void ClockTimeFrame::DrawDigitalTime(Environment* ev, ODFacet* facet, ODULong tickCount, HDC hdc)
{
	// Assumes port is set
	Str255	tTimeString;		// pascal string holding date to draw
		
#ifdef PLATFORM_MACINTOSH
	TextFont(fClockPart->GetFont() );
	TextFace(fClockPart->GetStyle() );
	TextMode(srcCopy);
	TextSize(fClockPart->GetSize() );
	
	IUTimeString( tickCount, kODTrue, tTimeString );

	if (fClockPart->GetLastAscent() == 0)
	{
		FontInfo fontIRec;
		GetFontInfo( &fontIRec );
		fClockPart->SetLastAscent(fontIRec.ascent);
	}

	MoveToEx( hdc, 2, fClockPart->GetLastAscent() + 1, NULL );
	DrawString( tTimeString );
	
	TextFace( normal );
	TextFont( geneva );
	TextMode( srcOr );
	TextSize( 12 );
#endif

#ifdef PLATFORM_WINDOWS

	time_t tm;
	time (&tm);
	strftime(tTimeString, 255, "%a. %b. %d, %I:%M:%S %p", localtime(&tm));
	
	ODFrame*	displayFrame = facet->GetFrame(ev);
	ODRect		xRect;
	Rect		rect ;
	HFONT		hDrawFont = CreateFontIndirect (fClockPart->GetFont());
	HFONT		hOldFont;

	ODShape *frameShape = displayFrame->GetFrameShape(ev, kODNULL);
	frameShape->GetBoundingBox(ev, &xRect);
	frameShape->Release(ev);
	xRect.AsWinRect(rect);

	hOldFont = SelectObject (hdc, hDrawFont);

	/* Note DrawText() can't be used in a metafile ! Justify the 	
	 * text ourselves to make sure it looks OK...					
	 */																
	SetBkColor(hdc,RGB(255,255,255));								
	ExtTextOut(hdc, rect.left, rect.top,							
			   ETO_CLIPPED | ETO_OPAQUE,							
			   &rect,												
			   tTimeString, 										
			   lstrlen(tTimeString),								
			   NULL);												

	SelectObject (hdc, hOldFont);
	DeleteObject (hDrawFont);
#endif
}

void ClockTimeFrame::UpdateTime(Environment* ev, ODFacet* facet, ODULong tickCount)
{
	HDC hDC;
	CFocus	focus(facet, kODNULL, &hDC);

	if (fClockPart->IsAnalog())
		this->UpdateClockHands(ev, facet, tickCount, hDC);
	else
		this->DrawDigitalTime(ev, facet, tickCount, hDC);
	fLastTime = tickCount;
}

void ClockTimeFrame::DrawTime(Environment* ev, ODFacet* facet, ODULong tickCount, HDC hDC)
{
	if (fClockPart->IsAnalog())
		this->DrawClockHands(ev, facet, tickCount, hDC);
	else
		this->DrawDigitalTime(ev, facet, tickCount, hDC);
}

ODBoolean ClockTimeFrame::HandleMouseDown(Environment* ev, ODFacet* facet, ODEventData* event)
{
	ODBoolean wasHandled = kODFalse;

	if (!facet->GetWindow(ev)->IsActive(ev))
		facet->GetWindow(ev)->Select(ev);
	else
	{
		this->Activate(ev);
	}

	return wasHandled;
}

ODBoolean ClockTimeFrame::HandleMouseUp(Environment* ev, ODFacet* facet, ODEventData* event)
{
	if ( facet == kODNULL )
		return kODTrue;
	if (!facet->GetWindow(ev)->IsActive(ev))
		facet->GetWindow(ev)->Select(ev);
	else
	{
		this->Activate(ev);
	}
	return kODTrue;
}

void ClockTimeFrame::Activate(Environment* ev)
{
	if (!fIsActive)
	{
		ODBoolean succeeded = kODFalse;
							
		succeeded = fArbitrator->RequestFocusSet(ev, fFocusSet,fFrame);
				
		if (succeeded)
		{
			fIsActive = kODTrue;
			fClockPart->AcquiredSelectionFocus(ev, this);
			fClockPart->InstallMenus(ev);
		}
	}
}

void ClockTimeFrame::ActivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event) 
{
#if defined(ODDebug)
	somPrintf("Activating window of Clock\n");
#endif

	if (fNeedsActivating)
	{
#if defined(ODDebug)
	somPrintf("Frame of Clock Needs Activating\n");
#endif
		this->Activate(ev);
	}
}

void ClockTimeFrame::DeactivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event)
{
#if defined(ODDebug)
	somPrintf("Deactivating window of Clock\n");
#endif

	if (fFrame == fArbitrator->GetFocusOwner(ev, fSelectionFocus))
	{
		fNeedsActivating = kODTrue;
	}
	else
		fNeedsActivating = kODFalse;
}


//------------------------------------------------------------------------------
// ClockTimeFrame: HandleMenuEvent
//------------------------------------------------------------------------------


ODBoolean ClockTimeFrame::HandleMenuEvent(Environment *ev, ODEventData* event)
{
	ODBoolean wasHandled = kODTrue;

#ifdef PLATFORM_MACINTOSH
	long menuResult = event->message;
	short menu = HiWord(menuResult);
	short item = LoWord(menuResult);
	ODCommandID command = fClockPart->GetMenuBar()->GetCommand(ev, menu, item);

	if (fClockPart->GetMenuBar()->IsCommandSynthetic(ev, command))	// Font, Size, Style
	{
		switch ( menu ) 
		{
			case kClock_FontMenuID:	
				fClockPart->HandleFontMenu(ev, item ); 
				break;
			case kClock_SizeMenuID:	
				fClockPart->HandleSizeMenu(ev,  item ); 
				break;
			case kClock_StyleMenuID:	
				fClockPart->HandleStyleMenu(ev, item );
				break;
			default:
				wasHandled = kODFalse;
				break;
		}
		
		if (wasHandled)							// if change made, resize the frame
			this->MinimizeFrameShape(ev);	
	}
	else
#endif
	{
		switch (LOWORD(event->wParam))
		{
			case kODCommandAbout:
				fClockPart->ShowAboutBox(ev, fFrame);
				break;
			case kODCommandShowPartsBin:
				fClockPart->ShowHidePartsBin(ev, fFrame);
				break;
			case kODCommandViewAsWin:
				this->ViewInWindow(ev); 
				break;
			case kODCommandClose:
				wasHandled = fClockPart->CloseWindow(ev, fFrame);
				break;

			case kODClockPart_Size_Font:	
				fClockPart->HandleFontMenu(ev, fFrame ); 
				break;
			case cAnalog:
				fClockPart->SetAnalog(ev, kODTrue);
				this->MinimizeFrameShape(ev);	
				break;
			case cDigital:
				fClockPart->SetAnalog(ev, kODFalse);
				this->MinimizeFrameShape(ev);	
				break;
			case cSynchronize:
				fClockPart->ShowSynchDialog(ev);
				break;
			case cShowSettings:
				fClockPart->ShowSettingsDialog(ev);
				break;
			default:
				wasHandled = kODFalse;
				break;
		}
	}
	return wasHandled;
}



				
//------------------------------------------------------------------------------
// ClockTimeFrame:  MinimizeFrameShape
//------------------------------------------------------------------------------


void ClockTimeFrame::MinimizeFrameShape(Environment *ev)
{
	if (fFrame->IsRoot(ev))
	{
		fFrame-> Invalidate(ev, kODNULL, kODNULL);
		this->FitToFrameShape(ev);
		return;
	}
	
	Rect qdr;
	fClockPart->CalcClockBounds(qdr);
	ODShape *wantShape = fFrame->CreateShape(ev);
	
	ODRect r(qdr);
	wantShape->SetRectangle(ev, &r);
	
	fFrame-> Invalidate(ev, kODNULL, kODNULL);
	fFrame-> InvalidateActiveBorder(ev);
	
	ODShape* gotShape = fFrame -> RequestFrameShape(ev,  wantShape, kODNULL );
	
	//if (gotShape->IsSameAs(ev,wantShape))
	//	fFrame->ChangeUsedShape(ev, kODNULL, kODNULL);
	//else
	this->FitToFrameShape(ev); // Adjust used shape to frame shape
	fFrame-> Invalidate(ev, kODNULL, kODNULL);
	fFrame-> InvalidateActiveBorder(ev);
	
	wantShape->Release(ev); wantShape = kODNULL;
}

void ClockTimeFrame::FrameShapeChanged(Environment *ev)
{
	if (fClockPart->IsAnalog() && !fFrame->IsRoot(ev))
	{
		fFrame->RequestFrameShape(ev, this->GetNewFrameShape(ev), kODNULL);
	}

	fFrame-> Invalidate(ev, kODNULL, kODNULL);
	this->FitToFrameShape(ev);
}

//----------------------------------------------------------------------------------------
// CClockFrame::GetNewFrameShape
//----------------------------------------------------------------------------------------
ODShape* ClockTimeFrame::GetNewFrameShape(Environment *ev)
{
	ODRgnHandle frameRegion;
	Rect frameRect;

	ODShape *frameShape = fFrame->GetFrameShape(ev, kODNULL);
	ODRgnHandle shapeRegion = frameShape->GetWinRegion(ev);
	frameShape->Release(ev);
	Rect bbox;

	GetRgnBox(shapeRegion, &bbox);
	int size = bbox.bottom - bbox.top;
	if (size > bbox.right - bbox.left) {
		size = bbox.right - bbox.left;
	}
	if (size < kClockMinimumSize) {
		size = kClockMinimumSize;
	}

	SetRect(&frameRect, 0, 0, size, size);
	frameRegion = CreateRectRgnIndirect(&frameRect);

	ODShape* newFrameShape = fFrame->CreateShape(ev);
	newFrameShape->SetWinRegion(ev, frameRegion);

	return newFrameShape;
}

static inline short Width(const Rect& r)
{
	return r.right - r.left;
}

static inline short Height(const Rect& r)
{
	return r.bottom - r.top;
}

static inline void CenterRect(const Rect& outer, Rect& inner)
{
	short x = (Width(outer) - Width(inner)) / 2;
	short y = (Height(outer) - Height(inner)) / 2;
	
	inner.right += x - inner.left;
	inner.left = x;
	inner.bottom += y - inner.top;
	inner.top = y;
}



void ClockTimeFrame::FitToFrameShape(Environment *ev)
{
	// Update used shape of frame and active shape of all facets
	// invalidate frame shape
	// invalidate active border
	
	Rect frameShapeRect;
	Rect usedShapeRect;
	ODShape* newUsedShape = kODNULL;
	
	ODShape* frameShape = fFrame->GetFrameShape(ev, kODNULL);
	ODRgnHandle shapeRegion = frameShape->GetWinRegion(ev);
	GetRgnBox (shapeRegion, &frameShapeRect);
	frameShape->Release(ev);
		
	if (fClockPart->IsAnalog())
	{
		if (fFrame->IsRoot(ev))
		{
			frameShapeRect.right = frameShapeRect.right - 16;
			frameShapeRect.bottom = frameShapeRect.bottom - 16;
		}
		usedShapeRect = frameShapeRect;
		if (usedShapeRect.bottom > usedShapeRect.right)
			usedShapeRect.bottom = usedShapeRect.right;
		else
			usedShapeRect.right = usedShapeRect.bottom;
			
	}
	else
	{
		fClockPart->CalcClockBounds(usedShapeRect);
	}
	if (fClockPart->IsAnalog())
		CenterRect(frameShapeRect, usedShapeRect);

	if (fClockPart->IsAnalog())
	{
		/*
		ODRect u(usedShapeRect);
		newUsedShape = fFrame->CreateShape(ev);
		newUsedShape->SetRectangle(ev, &u);
		*/
		newUsedShape = fClockPart->CreateOvalShape(ev, fFrame, usedShapeRect);
	}
	else
	{
//bgn		ODRect u(usedShapeRect);
		ODRect u(frameShapeRect);
		newUsedShape = fFrame->CreateShape(ev);
		newUsedShape->SetRectangle(ev, &u);
	}
	
	/* This is an alternative to the SetOrigin calls. But then we need to
	  undo the transformation to draw the border. It would be nice if CFocus
	  provide an easy way to mix internal/external transforms.
	  
	ODTransform* internal = fFrame->CreateTransform(ev);
	Point offset; 
	offset.h = usedShapeRect.left;
	offset.v = usedShapeRect.top;
	internal->SetQDOffset(ev, &offset);
	fFrame->ChangeInternalTransform(ev, internal, kODNULL);
	internal->Release(ev);
	*/
	
	fFrame->ChangeUsedShape(ev, newUsedShape, kODNULL);
	
	ODShape* activeShape = newUsedShape->Copy(ev);
	/*if (fIsActive)
	{
		ODRect u2(usedShapeRect);
		activeShape->SetRectangle(ev, &u2);
	}*/
	ODFrameFacetIterator* fi = fFrame->CreateFacetIterator(ev);
	for(ODFacet* facet = fi->First(ev); fi->IsNotComplete(ev);
			facet = fi->Next(ev))
	{
		facet->ChangeActiveShape(ev,activeShape, kODNULL);
	}
	activeShape->Release(ev);
	
	newUsedShape->Release(ev);
}

void ClockTimeFrame::FacetAdded(Environment* ev, ODFacet* facet) 
{
	this->MinimizeFrameShape(ev);
}

void ClockTimeFrame::Add(Environment* ev)
{
	ClockFrame::Add(ev);
	fDispatcher->RegisterIdle(ev, (ODPart*)fClockPart->GetPartWrapper(), fFrame, kCPIdleFrequency );
}

void ClockTimeFrame::Connect(Environment* ev)
{
	ClockFrame::Connect(ev);
	fDispatcher->RegisterIdle(ev, (ODPart*)fClockPart->GetPartWrapper(), fFrame, kCPIdleFrequency );
}

void ClockTimeFrame::Remove(Environment* ev)
{
	fDispatcher->UnregisterIdle(ev, (ODPart*)fClockPart->GetPartWrapper(), fFrame );
	ClockFrame::Remove(ev);
}

void ClockTimeFrame::Close(Environment* ev)
{
	fDispatcher->UnregisterIdle(ev, (ODPart*)fClockPart->GetPartWrapper(), fFrame );
	ClockFrame::Close(ev);
}
									
//=========================================================================
// ClockDialogFrame
//=========================================================================

ClockDialogFrame::ClockDialogFrame()
{
}

ClockDialogFrame::~ClockDialogFrame()
{
}

void ClockDialogFrame::InitClockDialogFrame(Environment* ev, 
											ODSession* session,
											ODFrame* frame, 
											ClockPart* clockPart)
{
	this->InitClockFrame(ev, session, frame, clockPart);
}

void ClockDialogFrame::Draw(Environment* ev, ODFacet* facet, ODShape* invalShape)
{
BGNBP
#ifdef PLATFORM_MACINTOSH
	if (facet)
		DrawDialog(facet->GetWindow(ev)->GetPlatformWindow(ev));
#endif
}

void ClockDialogFrame::Idle(Environment* ev, ODEventData* event)
{
BGNBP
#ifdef PLATFORM_MACINTOSH
	if (IsDialogEvent((const EventRecord *)event))
	{
		short itemHit;
		DialogPtr dialog;
		ODBoolean wasHandled = DialogSelect((const EventRecord *)event, &dialog, &itemHit);
	}
#endif
}

void ClockDialogFrame::ActivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event) 
{
}

void ClockDialogFrame::DeactivatingWindow(Environment* ev, ODFacet* facet, ODEventData* event)
{
}

//=========================================================================
// ClockSynchroDialogFrame
//=========================================================================

ClockSynchroDialogFrame::ClockSynchroDialogFrame()
{
}

ClockSynchroDialogFrame::~ClockSynchroDialogFrame()
{
}

void ClockSynchroDialogFrame::InitClockSynchroDialogFrame(Environment* ev, 
															ODSession* session,
															ODFrame* frame, 
															ClockPart* clockPart)
{
	this->InitClockDialogFrame(ev, session, frame, clockPart);
}


ODBoolean ClockSynchroDialogFrame::HandleMouseDown(Environment* ev, ODFacet* facet, ODEventData* event)
{
	ODBoolean wasHandled = kODFalse;

BGNBP
#ifdef PLATFORM_MACINTOSH
	if (IsDialogEvent((const EventRecord *)event))
	{
		short itemHit;
		DialogPtr dialog;
		wasHandled = DialogSelect((const EventRecord *)event, &dialog, &itemHit);
		ODWindow* window = fWindowState->GetODWindow(ev, dialog);
		
		if (itemHit == cancel)
		{
			ClockPart* clockPart = fClockPart; // "this" is about to go away
			fArbitrator->RelinquishFocus(ev, fModalFocus, fFrame);
			window->CloseAndRemove(ev);
			//!!! Reenable entire Menus. MenuBar object needs more support for this
			
			// $$$$$ Cleanup! 
			clockPart->GetMenuBar()->EnableAll(ev);

			/*
			const ODMenuID kDocumentMenuID = 129;
			const ODMenuID kEditMenuID = 130;

			ODPlatformMenu docMenu = clockPart->GetMenuBar()->GetMenu(ev,kDocumentMenuID);
			ODPlatformMenu editMenu = clockPart->GetMenuBar()->GetMenu(ev,kEditMenuID);
			ODPlatformMenu fontMenu = clockPart->GetMenuBar()->GetMenu(ev,kClock_FontMenuID);
			if (docMenu)
				EnableItem(docMenu, 0);
			if (editMenu)
				EnableItem(editMenu, 0);
			*/
			clockPart->GetMenuBar()->EnableCommand(ev,  kODCommandAbout, kODTrue ) ;
			/*if (fontMenu)
				EnableItem(fontMenu, 0);
			
			ODSLong		savedRefNum;
			BeginUsingLibraryResources(savedRefNum);
			EnableItem(GetMenuHandle(kClock_SizeMenuID), 0);
			EnableItem(GetMenuHandle(kClock_StyleMenuID), 0);
			EnableItem(GetMenuHandle(kClock_SettingsMenuID), 0);
			EndUsingLibraryResources(savedRefNum);
			*/
			InvalMenuBar();
		}
	}
#endif

	return wasHandled;
}

//=========================================================================
// ClockSettingsDialogFrame
//=========================================================================

ClockSettingsDialogFrame::ClockSettingsDialogFrame()
{
}

ClockSettingsDialogFrame::~ClockSettingsDialogFrame()
{
}

void ClockSettingsDialogFrame::InitClockSettingsDialogFrame(Environment* ev, 
															ODSession* session,
															ODFrame* frame, 
															ClockPart* clockPart)
{
	this->InitClockDialogFrame(ev, session, frame, clockPart);
}

ODBoolean ClockSettingsDialogFrame::HandleMouseDown(Environment* ev, ODFacet* facet, ODEventData* event)
{
	ODBoolean wasHandled = kODFalse;

BGNBP
#ifdef PLATFORM_MACINTOSH
	if (IsDialogEvent((const EventRecord *)event))
	{
		short itemHit;
		ODSShort 	itemType;
		ODSShort	checkbox;
		Handle		itemHandle;
		Rect		scratchRect;

		DialogPtr dialog;
		wasHandled = DialogSelect((const EventRecord *)event, &dialog, &itemHit);
		
		if (itemHit == kClock_SettingsCheckBoxID)
		{
			GetDialogItem(dialog, itemHit, &itemType, &itemHandle, &scratchRect);
			checkbox = GetControlValue((ControlHandle)itemHandle);
			checkbox = 1 - checkbox;
			SetControlValue((ControlHandle)itemHandle,checkbox);
			fClockPart->ToggleAlarm();
		}
	}
#endif

	return wasHandled;
}

//-------------------------------------------------------------------------
// Utilities
//-------------------------------------------------------------------------


//------------------------------------------------------------------------------
// CheckMarkMenu
//------------------------------------------------------------------------------

// #define IUEQUALNOTWORKING

static void CheckMarkMenu(MenuHandle menu, Str255 checkItem, ODBoolean checkIt)
{
BGNBP
#ifdef PLATFORM_MACINTOSH
	ODSShort  	numMenuItems = CountMItems( menu );
	Str255  	menuItemString;
	
	for (ODSShort menuItemNum = 1; menuItemNum <= numMenuItems; menuItemNum++)
	{
		GetMenuItemText( menu, menuItemNum, menuItemString );
		
#ifndef IUEQUALNOTWORKING
		if ( IUEqualString(checkItem, menuItemString) == 0 )
		{
			if ( checkIt )
				CheckItem( menu, menuItemNum, kODTrue );
			else
				CheckItem( menu, menuItemNum, kODFalse );
		}
#else
		CheckItem( menu, menuItemNum, kODFalse );
#endif
	}
#endif
}


//------------------------------------------------------------------------------
// StyleToString
//------------------------------------------------------------------------------


static void StyleToString(ODUByte	style,
						  Str255*	styleName )
{
	char tStyleStr[12];
	
BGNBP
#ifdef PLATFORM_MACINTOSH
	switch (style) {
		case normal:	strcpy((char *)&tStyleStr ,"Plain\0"); break;				//   Move to resource
		case bold:		strcpy((char *)&tStyleStr ,"Bold\0"); break;				//   for localization
		case italic:	strcpy((char *)&tStyleStr ,"Italic\0"); break;				//   purposes
		case underline:	strcpy((char *)&tStyleStr ,"Underline\0"); break;
		case outline:	strcpy((char *)&tStyleStr ,"Outline\0"); break;
		case shadow:	strcpy((char *)&tStyleStr ,"Shadow\0"); break;
		case condense:	strcpy((char *)&tStyleStr ,"Condense\0"); break;
		case extend:	strcpy((char *)&tStyleStr ,"Extend\0"); break;
		default:
			strcpy((char *)&tStyleStr ,"Plain\0");
	}
	
	BlockMove((Ptr)c2pstr((char *)&tStyleStr),(Ptr)styleName,12);
#endif
}

//------------------------------------------------------------------------------
// AboutDialogFilter
//------------------------------------------------------------------------------

#ifdef PLATFORM_MACINTOSH
ODBoolean AboutDialogFilter(DialogPtr dialog,
							  EventRecord* event,
							  short* itemHit)
{
	ODBoolean handled = kODFalse;
	
	Environment* ev = somGetGlobalEnvironment();
	
	if (event->what == nullEvent)
	{
		gSession->GetDispatcher(ev)->Dispatch(ev, (ODEventData*)event);
	}
	else if (event->what == updateEvt &&
				(WindowPtr) event->message != dialog)		
	{
		gSession->GetDispatcher(ev)->Dispatch(ev, (ODEventData*)event);
	}
	else if (event->what == activateEvt &&
				(WindowPtr) event->message != dialog)		
	{
		gSession->GetDispatcher(ev)->Dispatch(ev, (ODEventData*)event);
	}
	else if (event->what == mouseDown) 
	{
		handled = kODFalse;
	}
	else if (event->what == mouseUp) 
	{
		handled = kODTrue;
		*itemHit = 1;
	}
	else if ((event->what == keyDown) || (event->what == autoKey))
	{
		handled = kODTrue;
		
		/*
		#define kMyButtonDelay 8
		long	waitTicks;
		short	itemKind;
		Handle	itemHandle;
		Rect	itemRect;
		char key = (char)(event->message & charCodeMask);
		const char kReturnKey = 13;
		const char kEnterKey = 3;
		const char kEscKey = 27;
		
		switch(key)
		{
			case kReturnKey:
			case kEnterKey:
				// change whatever is the current item is to the OK item 
				*itemHit = ok;
				GetDItem(dialog,ok,&itemKind,&itemHandle,&itemRect);
				HiliteControl((ControlHandle)itemHandle,inButton);
				Delay(kMyButtonDelay,&waitTicks);// wait about 8 ticks 
				HiliteControl((ControlHandle)itemHandle,kODFalse);
				handled = kODTrue;
				break;
			case kEscKey:
				*itemHit = cancel;
				GetDItem(dialog,cancel,&itemKind,&itemHandle,&itemRect);
				HiliteControl((ControlHandle)itemHandle,inButton);
				Delay(kMyButtonDelay,&waitTicks);
				HiliteControl((ControlHandle)itemHandle,kODFalse);
				handled = kODTrue;
				break;
		}
		*/
	}

	return handled;
}
#endif

//------------------------------------------------------------------------------
// ClockDialogFilter
//------------------------------------------------------------------------------

#ifdef PLATFORM_MACINTOSH
pascal Boolean ClockDialogFilter(DialogPtr dialog,
							  EventRecord* event,
							  short* itemHit)
{
	ODBoolean handled = kODFalse;
	
	Environment* ev = somGetGlobalEnvironment();
	
	if (event->what == nullEvent)
	{
		gSession->GetDispatcher(ev)->Dispatch(ev, (ODEventData*)event);
	}
	else if (event->what == updateEvt &&
				(WindowPtr) event->message != dialog)		
	{
		gSession->GetDispatcher(ev)->Dispatch(ev, (ODEventData*)event);
	}
	else if (event->what == activateEvt &&
				(WindowPtr) event->message != dialog)		
	{
		gSession->GetDispatcher(ev)->Dispatch(ev, (ODEventData*)event);
	}
	else if ((event->what == keyDown) || (event->what == autoKey))
	{
		#define kMyButtonDelay 8
		long	waitTicks;
		short	itemKind;
		Handle	itemHandle;
		Rect	itemRect;
		char key = (char)(event->message & charCodeMask);
		const char kReturnKey = 13;
		const char kEnterKey = 3;
		const char kEscKey = 27;
		
		switch(key)
		{
			case kReturnKey:
			case kEnterKey:
				/* change whatever is the current item is to the OK item */
				*itemHit = ok;
				GetDialogItem(dialog,ok,&itemKind,&itemHandle,&itemRect);
				HiliteControl((ControlHandle)itemHandle,kInButtonControlPart);
				Delay(kMyButtonDelay,&waitTicks);/* wait about 8 ticks */
				HiliteControl((ControlHandle)itemHandle,kODFalse);
				handled = kODTrue;
				break;
			case kEscKey:
				*itemHit = cancel;
				GetDialogItem(dialog,cancel,&itemKind,&itemHandle,&itemRect);
				HiliteControl((ControlHandle)itemHandle,kInButtonControlPart);
				Delay(kMyButtonDelay,&waitTicks);
				HiliteControl((ControlHandle)itemHandle,kODFalse);
				handled = kODTrue;
				break;
		}
	}

	return handled;
}
#endif

//----------------------------------------------------------------------------------------
// ClockTimeFrame::DrawClockFace
//----------------------------------------------------------------------------------------

void ClockTimeFrame::DrawClockFace(Environment* ev, ODFacet* facet, HDC hdc)
{
	ODShape* frameShape = fFrame->GetFrameShape(ev, kODNULL);
	ODShape* usedShape = fFrame->GetUsedShape(ev, kODNULL);
	ODRgnHandle frameRegion = frameShape->GetWinRegion(ev);
	Rect frameRect;
	GetRgnBox (frameRegion, &frameRect);
	ODRgnHandle usedRegion = usedShape->GetWinRegion(ev);
	Rect usedRect;
	GetRgnBox (usedRegion, &usedRect);
	frameShape->Release(ev);
	usedShape->Release(ev);

	if (fClockPart->IsAnalog())
	{
		if (fFrame->IsRoot(ev))
			FillRect(hdc, &frameRect, GetStockObject (WHITE_BRUSH));
		else
			FillRgn(hdc, usedRegion, GetStockObject (WHITE_BRUSH));
			//::EraseRect(&usedRect);
		this->DrawAnalogFace(ev, facet, hdc);
	}
	else
	{
		if (fFrame->IsRoot(ev))
			FillRect(hdc, &frameRect, GetStockObject (WHITE_BRUSH));
		else
			FillRect(hdc, &usedRect, GetStockObject (WHITE_BRUSH));
		
		FrameRect(hdc, &usedRect, GetStockObject (BLACK_BRUSH));
	}
}

//----------------------------------------------------------------------------------------
// ClockTimeFrame::DrawAnalogFace
//----------------------------------------------------------------------------------------

void ClockTimeFrame::DrawAnalogFace(Environment* ev, ODFacet* facet, HDC hDC)
{
#ifdef PLATFORM_MACINTOSH
	Point currentPenSize = ODQDGlobals.thePort->pnSize;
	// TextStyle currentTextStyle;
	Point centerPoint;
	Point newPoint;
	Point tickPoint;
	ODSShort radius;
	ODSShort angle = 0;
	ODSShort fiveMinute = 0;
	double_t radians;
	
	// ::GetPortTextStyle(&currentTextStyle);
	
	ODShape* usedShape = fFrame->GetUsedShape(ev, kODNULL);
	ODRgnHandle shapeRegion = usedShape->GetQDRegion(ev);
	Rect clockRect = (*shapeRegion)->rgnBBox;
	usedShape->Release(ev);
	
	centerPoint.h = (clockRect.right - clockRect.left) / 2;
	centerPoint.v = (clockRect.bottom - clockRect.top) / 2;
	radius = centerPoint.h;

	::EraseOval(&clockRect);

	::PenSize(2,2);
	::FrameOval(&clockRect);
	::PenSize(1,1);
	
	::TextFont(helvetica);
	//::TextFace(italic);
	::TextSize(radius / 10);

	/* $$$$$ Added */
	Point oldOrigin;
	Point newOrigin;
	oldOrigin.h = ODQDGlobals.thePort->portRect.left;
	oldOrigin.v = ODQDGlobals.thePort->portRect.top;
	newOrigin.h = oldOrigin.h - clockRect.left;
	newOrigin.v = oldOrigin.v - clockRect.top;
	SetOrigin(newOrigin.h,newOrigin.v);
	// */
	
	Str255 clockFaceString = "\pOpenDoct";
	//FW_CAcquireASLMResourceAccess aq;
	//::GetIndString(clockFaceString, kClockPartStrings, kClockFaceString);
	
	::MoveTo(((clockRect.right - clockRect.left) - ::StringWidth(clockFaceString)) / 2, (clockRect.bottom - clockRect.top) / 4);
	::DrawString(clockFaceString);


	//!!!!! Should save/restore
	TextFace( normal );
	TextFont( geneva );
	TextMode( srcOr );
	TextSize( 12 );
	
	
	
	// Use the symmetry of the clock face to speed up the calculations for drawing the face
	// We only need to calculate points for 45 degrees of the circle.  The remaining points can
	// be inferred from these points
	while (angle < 45)
	{
		// convert angle to radians
		radians = (90 - angle) / (360 / (2 * pi));
		newPoint.h = (short)::rint((radius * cos(radians)) + centerPoint.h);
		newPoint.v = (short)::rint((radius * sin(radians)) + centerPoint.v);
		
		if (fiveMinute == 0)
		{
			short hourTick = radius - (radius / 10);
			tickPoint.h = (short)::rint((hourTick * cos(radians)) + centerPoint.h);
			tickPoint.v = (short)::rint((hourTick * sin(radians)) + centerPoint.v);
			fiveMinute = 4;
		}
		else
		{
			short minuteTick = radius - (radius / 20);
			tickPoint.h = (short)::rint((minuteTick * cos(radians)) + centerPoint.h);
			tickPoint.v = (short)::rint((minuteTick * sin(radians)) + centerPoint.v);
			fiveMinute--;
		}

		::MoveTo(newPoint.h - 1, newPoint.v - 1);
		::LineTo(tickPoint.h - 1, tickPoint.v - 1);
		
		::MoveTo((clockRect.right-clockRect.left) - newPoint.h, newPoint.v - 1);
		::LineTo((clockRect.right-clockRect.left) - tickPoint.h, tickPoint.v - 1);
		
		::MoveTo(newPoint.h - 1, (clockRect.bottom-clockRect.top) - newPoint.v);
		::LineTo(tickPoint.h - 1, (clockRect.bottom-clockRect.top) - tickPoint.v);

		::MoveTo((clockRect.right-clockRect.left) - newPoint.h, (clockRect.bottom-clockRect.top) - newPoint.v);
		::LineTo((clockRect.right-clockRect.left) - tickPoint.h, (clockRect.bottom-clockRect.top) - tickPoint.v);

		::MoveTo(newPoint.v - 1, newPoint.h - 1);
		::LineTo(tickPoint.v - 1, tickPoint.h - 1);
		
		::MoveTo((clockRect.bottom-clockRect.top) - newPoint.v, newPoint.h - 1);
		::LineTo((clockRect.bottom-clockRect.top) - tickPoint.v, tickPoint.h - 1);
		
		::MoveTo(newPoint.v - 1, (clockRect.right-clockRect.left) - newPoint.h);
		::LineTo(tickPoint.v - 1, (clockRect.right-clockRect.left) - tickPoint.h);

		::MoveTo((clockRect.bottom-clockRect.top) - newPoint.v, (clockRect.right-clockRect.left) - newPoint.h);
		::LineTo((clockRect.bottom-clockRect.top) - tickPoint.v, (clockRect.right-clockRect.left) - tickPoint.h);

		angle += 6;
	}
	
	SetOrigin(oldOrigin.h,oldOrigin.v);
	
	
	::PenSize(currentPenSize.h, currentPenSize.v);
	// ::SetPortTextStyle(&currentTextStyle);
#endif

#ifdef PLATFORM_WINDOWS
	Point centerPoint;
	Point newPoint;
	Point tickPoint;
	ODSShort radius;
	ODSShort angle = 0;
	ODSShort fiveMinute = 0;
	long double radians;

//bgn	HDC hDC = GetDrawInitiator()->GetDC();
//bgn	HRGN    shapeRegion = GetODFacet()->GetFrame()->GetFrameShape()->GetWinRegion();
	ODShape* usedShape = fFrame->GetUsedShape(ev, kODNULL);
	ODRgnHandle shapeRegion = usedShape->GetWinRegion(ev);

	Rect clockRect;
	GetRgnBox(shapeRegion,&clockRect);
	SquareRect(hDC, clockRect);

	// The draw origin has been set (by the draw initiator) to the upper left of
	// the facet. All we need from the bounding box is the size.
	centerPoint.x = ((clockRect.right - clockRect.left) / 2) + clockRect.left;
	centerPoint.y = ((clockRect.bottom - clockRect.top) / 2) + clockRect.top;
	radius = (centerPoint.x - clockRect.left);

//bgn	CDrawContext dc(hDC);

//bgn	dc.SelectObject(GetStockObject(WHITE_BRUSH), kXMPTrue);
//bgn	dc.SelectObject(CreatePen(PS_INSIDEFRAME, 2, RGB(0, 0, 0)), kXMPFalse);
	HPEN hPen = CreatePen(PS_INSIDEFRAME, 2, RGB(0, 0, 0));
	HPEN hOldPen;
	HBRUSH hOldBrush;

	hOldBrush = SelectObject(hDC, GetStockObject(WHITE_BRUSH));
	hOldPen = SelectObject(hDC, hPen);

	FillRgn(hDC,shapeRegion,GetStockObject(WHITE_BRUSH));
	Ellipse(hDC,clockRect.left,clockRect.top,clockRect.right-1,clockRect.bottom-1);
	SelectObject(hDC, GetStockObject(BLACK_PEN));

	// Label the clock face - but not in the cached presentation space
	if (GetDeviceCaps(hDC, TECHNOLOGY) != DT_METAFILE)                                      //OLE2
	{
		LOGFONT labelFont;

		memset(&labelFont, 0, sizeof(labelFont));
		labelFont.lfPitchAndFamily = FF_SWISS;
		labelFont.lfItalic = 1;
		labelFont.lfHeight = (radius / 10);
		lstrcpy((LPSTR)labelFont.lfFaceName, (LPSTR)"Helv");

		HFONT hFont = CreateFontIndirect(&labelFont);
		HFONT hOldFont;
		hOldFont = SelectObject(hDC, hFont);

		const char labelText[] = "OpenDoc";
		int labelSize = lstrlen((LPSTR)labelText);
//bgn		int labelExtent = GetTextExtent(hDC, labelText, labelSize);

		SIZE Size;
		GetTextExtentPoint32 (hDC, labelText, labelSize, &Size);
		int labelExtent = Size.cx;

		TextOut(hDC, (((clockRect.right - clockRect.left) - labelExtent) / 2) + clockRect.left,
				  ((clockRect.bottom - clockRect.top) / 4) + clockRect.top, labelText, labelSize);

		SelectObject (hDC, hOldFont);
		DeleteObject (hFont);
	}
	// Use the symmetry of the clock face to speed up the calculations for drawing the face
	// We only need to calculate points for 45 degrees of the circle.  The remaining points can
	// be inferred from these points
	while (angle < 45)
	{
		// convert angle to radians
		radians = (90 - angle) / (360 / (2 * M_PI));
		newPoint.x = (short)(long)((radius * cosl(radians)) + centerPoint.x);
		newPoint.y = (short)(long)((radius * sinl(radians)) + centerPoint.y);

		if (fiveMinute == 0)
		{
			short hourTick = radius - (radius / 10);
			tickPoint.x = (short)(long)((hourTick * cosl(radians)) + centerPoint.x);
			tickPoint.y = (short)(long)((hourTick * sinl(radians)) + centerPoint.y);
			fiveMinute = 4;
		}
		else
		{
			short minuteTick = radius - (radius / 20);
			tickPoint.x = (short)(long)((minuteTick * cosl(radians)) + centerPoint.x);
			tickPoint.y = (short)(long)((minuteTick * sinl(radians)) + centerPoint.y);
			fiveMinute--;
		}

		// 4:30 - 6:00
		MoveToEx(hDC, newPoint.x - 1, newPoint.y - 1, NULL);
		LineTo(hDC, tickPoint.x - 1, tickPoint.y - 1);

		// 6:00 - 7:30
		MoveToEx(hDC, clockRect.right - newPoint.x, newPoint.y - 1, NULL);
		LineTo(hDC, clockRect.right - tickPoint.x, tickPoint.y - 1);

		// 12:00 - 1:30
		MoveToEx(hDC, newPoint.x - 1, clockRect.bottom - newPoint.y, NULL);
		LineTo(hDC, tickPoint.x - 1, clockRect.bottom - tickPoint.y);

		// 10:30 - 12:00
		MoveToEx(hDC, clockRect.right - newPoint.x, clockRect.bottom - newPoint.y, NULL);
		LineTo(hDC, clockRect.right - tickPoint.x, clockRect.bottom - tickPoint.y);

		// 3:00 - 4:30
		MoveToEx(hDC, newPoint.y - 1, newPoint.x - 1, NULL);
		LineTo(hDC, tickPoint.y - 1, tickPoint.x - 1);

		// 7:30 - 9:00
		MoveToEx(hDC, clockRect.bottom - newPoint.y, newPoint.x - 1, NULL);
		LineTo(hDC, clockRect.bottom - tickPoint.y, tickPoint.x - 1);

		MoveToEx(hDC, newPoint.y - 1, clockRect.right - newPoint.x, NULL);
		LineTo(hDC, tickPoint.y - 1, clockRect.right - tickPoint.x);

		MoveToEx(hDC, clockRect.bottom - newPoint.y, clockRect.right - newPoint.x, NULL);
		LineTo(hDC, clockRect.bottom - tickPoint.y, clockRect.right - tickPoint.x);

		angle += 6;

	}
	SelectObject (hDC, hOldBrush);
	SelectObject (hDC, hOldPen);
	DeleteObject (hPen);

	RestoreDC (hDC, -1);

#endif
}

//----------------------------------------------------------------------------------------
// ClockTimeFrame::DrawClockHands
//----------------------------------------------------------------------------------------
void ClockTimeFrame::DrawClockHands(Environment* ev, ODFacet* facet, ODULong tickCount, HDC hDC)
{
#ifdef PLATFORM_MACINTOSH
	ODSShort currentPenMode = ODQDGlobals.thePort->pnMode;
	Point centerPoint;
	DateTimeRec time;
	
	ODShape* usedShape = fFrame->GetUsedShape(ev, kODNULL);
	ODRgnHandle shapeRegion = usedShape->GetQDRegion(ev);
	Rect clockRect = (*shapeRegion)->rgnBBox;
	usedShape->Release(ev);

	/* $$$$$ Added */
	Point oldOrigin;
	Point newOrigin;
	oldOrigin.h = ODQDGlobals.thePort->portRect.left;
	oldOrigin.v = ODQDGlobals.thePort->portRect.top;
	newOrigin.h = oldOrigin.h - clockRect.left;
	newOrigin.v = oldOrigin.v - clockRect.top;
	SetOrigin(newOrigin.h,newOrigin.v);
	// */
	
	centerPoint.h = (clockRect.right - clockRect.left) / 2;
	centerPoint.v = (clockRect.bottom - clockRect.top) / 2;
	
	::SecondsToDate(tickCount, &time);
	
	PenMode(patXor);
	this->DrawSecondHand(&clockRect, &centerPoint, centerPoint.h, time.second);
	this->DrawMinuteHand(&clockRect, &centerPoint, centerPoint.h, time.minute);

	if (time.hour > 11)
	this->DrawHourHand(&clockRect, &centerPoint, centerPoint.h, time.hour - 12, time.minute);
	else
	this->DrawHourHand(&clockRect, &centerPoint, centerPoint.h, time.hour, time.minute);

	::PenMode(currentPenMode);
	
	//$$$$$Added
	SetOrigin(oldOrigin.h, oldOrigin.v);
#endif

#ifdef PLATFORM_WINDOWS
	ODSShort radius;
	Point centerPoint;

//bgn	HDC hDC = GetDrawInitiator()->GetDC();

//bgn	XMPRgnHandle shapeRegion = GetXMPFacet()->GetFrame()->GetFrameShape()->GetWinRegion();
	ODShape* usedShape = fFrame->GetUsedShape(ev, kODNULL);
	ODRgnHandle shapeRegion = usedShape->GetWinRegion(ev);

	Rect clockRect;
	GetRgnBox(shapeRegion,&clockRect);
	SquareRect(hDC, clockRect);

	// The draw origin has been set (by the draw initiator) to the upper left of
	// the facet. All we need from the bounding box is the size.
	centerPoint.x = ((clockRect.right - clockRect.left) / 2) + clockRect.left;
	centerPoint.y = ((clockRect.bottom - clockRect.top) / 2) + clockRect.top;
	radius = centerPoint.x;

	struct tm *time = localtime((time_t*)&tickCount);

	int oldROP = SetROP2(hDC, R2_XORPEN);

	this->DrawSecondHand(&clockRect, &centerPoint, radius, time->tm_sec, hDC);
	this->DrawMinuteHand(&clockRect, &centerPoint, radius, time->tm_min, hDC);

	if (time->tm_hour > 11)
		this->DrawHourHand(&clockRect, &centerPoint, radius, time->tm_hour - 12, time->tm_min, hDC);
	else
		this->DrawHourHand(&clockRect, &centerPoint, radius, time->tm_hour, time->tm_min, hDC);

	SetROP2(hDC, oldROP);

	RestoreDC (hDC, -1);

#endif
}

//----------------------------------------------------------------------------------------
// ClockTimeFrame::UpdateClockHands
//----------------------------------------------------------------------------------------
void ClockTimeFrame::UpdateClockHands(Environment* ev, ODFacet* facet, ODULong tickCount, HDC hDC)
{
#ifdef PLATFORM_MACINTOSH
	ODSShort currentPenMode = ODQDGlobals.thePort->pnMode;
	Point centerPoint;
	DateTimeRec time;
	DateTimeRec lastTime;
	
	


 	::GetDateTime(&tickCount);
	::SecondsToDate(tickCount, &time);
	::SecondsToDate(fLastTime, &lastTime);
	
	ODShape* usedShape = fFrame->GetUsedShape(ev, kODNULL);
	ODRgnHandle shapeRegion = usedShape->GetQDRegion(ev);
	Rect clockRect = (*shapeRegion)->rgnBBox;
	usedShape->Release(ev);
	
	/* $$$$$ Added */
	Point oldOrigin;
	Point newOrigin;
	oldOrigin.h = ODQDGlobals.thePort->portRect.left;
	oldOrigin.v = ODQDGlobals.thePort->portRect.top;
	newOrigin.h = oldOrigin.h - clockRect.left;
	newOrigin.v = oldOrigin.v - clockRect.top;
	SetOrigin(newOrigin.h,newOrigin.v);
	// */

	centerPoint.h = (clockRect.right - clockRect.left) / 2;
	centerPoint.v = (clockRect.bottom - clockRect.top) / 2;
	
	::PenMode(patXor);
	
	// Since we're called every second go ahead and update the second hand
	this->DrawSecondHand(&clockRect, &centerPoint, centerPoint.h, lastTime.second);
	this->DrawSecondHand(&clockRect, &centerPoint, centerPoint.h, time.second);

	if (lastTime.minute != time.minute)
	{
		this->DrawMinuteHand(&clockRect, &centerPoint, centerPoint.h, lastTime.minute);
		this->DrawMinuteHand(&clockRect, &centerPoint, centerPoint.h, time.minute);
		
		if (lastTime.hour > 11)
			this->DrawHourHand(&clockRect, &centerPoint, centerPoint.h, lastTime.hour - 12, lastTime.minute, hDC);
		else
			this->DrawHourHand(&clockRect, &centerPoint, centerPoint.h, lastTime.hour, lastTime.minute, hDC);

		if (time.hour > 11)
			this->DrawHourHand(&clockRect, &centerPoint, centerPoint.h, time.hour - 12, time.minute, hDC);
		else
			this->DrawHourHand(&clockRect, &centerPoint, centerPoint.h, time.hour, time.minute, hDC);
	}
	
	::PenMode(currentPenMode);
	//$$$$$Added
	SetOrigin(oldOrigin.h, oldOrigin.v);
#endif

#ifdef PLATFORM_WINDOWS
	ODSShort radius;
	Point centerPoint;
	struct tm time;
	struct tm lastTime;

//bgn	time_t lastCount = fClockFrame->GetClockPart()->GetLastTime();
	time = *localtime((time_t*)&tickCount);
	lastTime = *localtime(&fLastTime);

//bgn	HDC hDC = GetDrawInitiator()->GetDC();

//bgn	XMPRgnHandle    shapeRegion = GetXMPFacet()->GetFrame()->GetFrameShape()->GetWinRegion();
	ODShape* usedShape = fFrame->GetUsedShape(ev, kODNULL);
	ODRgnHandle shapeRegion = usedShape->GetWinRegion(ev);

	Rect clockRect;
	GetRgnBox(shapeRegion,&clockRect);
	SquareRect(hDC, clockRect);

	// The draw origin has been set (by the draw initiator) to the upper left of
	// the facet. All we need from the bounding box is the size.
	centerPoint.x = ((clockRect.right - clockRect.left) / 2) + clockRect.left;
	centerPoint.y = ((clockRect.bottom - clockRect.top) / 2) + clockRect.top;
	radius = centerPoint.x;

	int oldROP = SetROP2(hDC, R2_XORPEN);

	// Since we're called every second go ahead and update the second hand
	this->DrawSecondHand(&clockRect, &centerPoint, radius, lastTime.tm_sec, hDC);
	this->DrawSecondHand(&clockRect, &centerPoint, radius, time.tm_sec, hDC);

	if (lastTime.tm_min != time.tm_min)
	{
		this->DrawMinuteHand(&clockRect, &centerPoint, radius, lastTime.tm_min, hDC);
		this->DrawMinuteHand(&clockRect, &centerPoint, radius, time.tm_min, hDC);

		if (lastTime.tm_hour > 11)
			this->DrawHourHand(&clockRect, &centerPoint, radius, lastTime.tm_hour - 12, lastTime.tm_min, hDC);
		else
			this->DrawHourHand(&clockRect, &centerPoint, radius, lastTime.tm_hour, lastTime.tm_min, hDC);

		if (time.tm_hour > 11)
			this->DrawHourHand(&clockRect, &centerPoint, radius, time.tm_hour - 12, time.tm_min, hDC);
		else
			this->DrawHourHand(&clockRect, &centerPoint, radius, time.tm_hour, time.tm_min, hDC);
	}

	SetROP2(hDC, oldROP);

#endif
}

//----------------------------------------------------------------------------------------
// ClockTimeFrame::DrawHourHand
//----------------------------------------------------------------------------------------
void ClockTimeFrame::DrawHourHand(Rect* clockRect, Point* centerPoint, ODSShort radius, ODSShort hour, ODSShort minute, HDC hDC)
{
#ifdef PLATFORM_MACINTOSH
	Point currentPenSize = ODQDGlobals.thePort->pnSize;
	Point newPoint;
	double_t radians;
	ODSShort hourRadius = radius / 2;		// Make the hour hand short and stubby
	
	// Divide the clock face into degrees.  Hour hand falls on every five minutes or every 30 degrees
	radians = ((hour * 30) + (minute / 2)) / (360 / (2 * pi));
	newPoint.h = (short)::rint((hourRadius * ::sin(radians)) + centerPoint->h);
	newPoint.v = clockRect->bottom-clockRect->top - ((short)::rint((hourRadius * ::cos(radians)) + centerPoint->v));

	::PenSize(3,3);
	::MoveTo(centerPoint->h, centerPoint->v);
	::LineTo(newPoint.h - 1, newPoint.v);
	::PenSize(currentPenSize.h, currentPenSize.v);
#endif

#ifdef PLATFORM_WINDOWS
	Point newPoint;
	long double radians;
	ODSShort hourRadius = radius / 2;              // Make the hour hand short and stubby

//bgn	HDC hDC = GetDrawInitiator()->GetDC();

	// Divide the clock face into degrees.  Hour hand falls on every five minutes or every 30 degrees
	radians = ((hour * 30) + (minute / 2)) / (360 / (2 * M_PI));
	newPoint.x = (short)(long)ceill((hourRadius * sinl(radians)) + centerPoint->x);
	newPoint.y = clockRect->bottom - ((short)(long)ceill((hourRadius * cosl(radians)) + centerPoint->y));

//bgn	CDrawContext dc(hDC);
	HPEN hOldPen = SelectObject(hDC, fHourPen);

	MoveToEx(hDC, centerPoint->x, centerPoint->y,NULL);
	LineTo(hDC, newPoint.x - 1, newPoint.y);

	SelectObject (hDC, hOldPen);

#endif
}

//----------------------------------------------------------------------------------------
// ClockTimeFrame::DrawMinuteHand
//----------------------------------------------------------------------------------------
void ClockTimeFrame::DrawMinuteHand(Rect* clockRect, Point* centerPoint, ODSShort radius, ODSShort minute, HDC hDC)
{
#ifdef PLATFORM_MACINTOSH
	Point currentPenSize = ODQDGlobals.thePort->pnSize;
	Point newPoint;
	double_t radians;
	ODSShort minuteRadius = radius - (radius / 20);  // Make the minute hand longer than the hour hand

	// Divide the clock face into degrees.  (360 degrees divided by 60 minutes is 6 degrees per minute)
	radians = (minute * 6) / (360 / (2 * pi));
	newPoint.h = (short)::rint((minuteRadius * ::sin(radians)) + centerPoint->h);
	newPoint.v = clockRect->bottom-clockRect->top - ((short)::rint((minuteRadius * ::cos(radians)) + centerPoint->v));

	::PenSize(2,2);
	::MoveTo(centerPoint->h, centerPoint->v);
	::LineTo(newPoint.h - 1, newPoint.v);
	::PenSize(currentPenSize.h, currentPenSize.v);
#endif

#ifdef PLATFORM_WINDOWS
	Point newPoint;
	long double radians;
	ODSShort minuteRadius = radius - (radius / 20);  // Make the minute hand longer than the hour hand

//bgn	HDC hDC = GetDrawInitiator()->GetDC();

	// Divide the clock face into degrees.  (360 degrees divided by 60 minutes is 6 degrees per minute)
	radians = (minute * 6) / (360 / (2 * M_PI));
	newPoint.x = (short)(long)(minuteRadius * sinl(radians)) + centerPoint->x;
	newPoint.y = clockRect->bottom - ((short)(long)(minuteRadius * cosl(radians)) + centerPoint->y);

//bgn	CDrawContext dc(hDC);
	HPEN hOldPen = SelectObject(hDC, fMinutePen);

	MoveToEx(hDC, centerPoint->x, centerPoint->y, NULL);
	LineTo(hDC, newPoint.x - 1, newPoint.y);

	SelectObject (hDC, hOldPen);
#endif
}

//----------------------------------------------------------------------------------------
// ClockTimeFrame::DrawSecondHand
//----------------------------------------------------------------------------------------
void ClockTimeFrame::DrawSecondHand(Rect* clockRect, Point* centerPoint, ODSShort radius, ODSShort second, HDC hDC)
{
#ifdef PLATFORM_MACINTOSH
	Point currentPenSize = ODQDGlobals.thePort->pnSize;
	Point newPoint;

	double_t radians;
	ODSShort secondRadius = radius - (radius / 40);	// A nice sweeping second hand

	// Divide the clock face into degrees.  (360 degrees divided by 60 seconds is 6 degrees per second)
	radians = (second * 6) / (360 / (2 * pi));
	newPoint.h = (short)::rint((secondRadius * ::sin(radians)) + centerPoint->h);
	newPoint.v = clockRect->bottom-clockRect->top - ((short)::rint((secondRadius * ::cos(radians)) + centerPoint->v));

	::PenSize(1,1);
	::MoveTo(centerPoint->h, centerPoint->v);
	::LineTo(newPoint.h - 1, newPoint.v);
	::PenSize(currentPenSize.h, currentPenSize.v);
#endif

#ifdef PLATFORM_WINDOWS
	Point newPoint;
	long double radians;
	ODSShort secondRadius = radius - (radius / 40);        // A nice sweeping second hand

//bgn	HDC hDC = GetDrawInitiator()->GetDC();

	// Divide the clock face into degrees.  (360 degrees divided by 60 seconds is 6 degrees per second)
	radians = (second * 6) / (360 / (2 * M_PI));
	newPoint.x = (short)(long)(secondRadius * sinl(radians)) + centerPoint->x;
	newPoint.y = clockRect->bottom - ((short)(long)(secondRadius * cosl(radians)) + centerPoint->y);

//bgn	CDrawContext dc(hDC);
	HPEN hOldPen = SelectObject(hDC, fSecondPen);

	MoveToEx(hDC, centerPoint->x, centerPoint->y, NULL);
	LineTo(hDC, newPoint.x - 1, newPoint.y);

	SelectObject (hDC, hOldPen);

#endif
}

#if PLATFORM_WINDOWS
static void SquareRect(HDC hDC, RECT &rect)
{
//bgnreturn;
	int size_x = rect.right - rect.left;
	int size_y = rect.bottom - rect.top;
	if (size_x > size_y)
		rect.right = rect.left + size_y;
	else if (size_x < size_y)
		rect.bottom = rect.top + size_x;

	SaveDC (hDC);
	SetViewportOrgEx (hDC, rect.left, rect.top, NULL);
	OffsetRect (&rect, -rect.left, -rect.top);
}
#endif
