/*
	File:		Button.cpp

	Contains:	Implementation of the SOM class Button

	Written by:	Jeff Hanson	and PartMaker

	Copyright:	 1995 by Novell, Inc., all rights reserved.

*/

#ifndef _ALTPOINT_
#include <AltPoint.h>
#endif

#ifndef _PLFMDEF_
#include <PlfmDef.h>
#endif

#ifndef _ODTYPES_
#include "ODTypes.h"
#endif

#ifndef _ODUTILS_
#include "ODUtils.h"
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

#ifndef _FOCUSLIB_
#include "FocusLib.h"
#endif

#ifndef _STDDEFS_
#include <StdDefs.h>
#endif

#ifndef _FACETLIST_
#include <FacetLst.h>
#endif

#ifndef _ITEXT_
#include <IText.h>
#endif

#ifndef SOM_ODCmdDefs_xh
#include <CmdDefs.xh>
#endif

#ifndef SOM_ODStdProps_xh
#include <StdProps.xh>
#endif

#ifndef SOM_ODStdTypes_xh
#include <StdTypes.xh>
#endif

#ifndef SOM_ODFrame_xh
#include <Frame.xh>
#endif

#ifndef SOM_ODFacet_xh
#include <Facet.xh>
#endif

#ifndef SOM_ODFrameFacetIterator_xh
#include <FrFaItr.xh>
#endif

#ifndef SOM_ODArbitrator_xh
#include <Arbitrat.xh>
#endif

#ifndef SOM_ODCanvas_xh
#include <Canvas.xh>
#endif

#ifndef SOM_ODPstObj_
#include <PstObj.xh>
#endif

#ifndef SOM_ODShape_xh
#include <Shape.xh>
#endif

#ifndef SOM_ODDraft_xh
#include <Draft.xh>
#endif

#ifndef SOM_ODFoci_xh
#include <Foci.xh>
#endif

#ifndef SOM_ODStorageUnit_xh
#include <StorageU.xh>
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef SOM_ODWindow_xh
#include <Window.xh>
#endif

#ifndef SOM_ODWinStat_xh
#include <WinStat.xh>
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODMenuBar_xh
#include "MenuBar.xh"
#endif

#ifndef SOM_ODFocusSet_xh
#include <FocusSet.xh>
#endif

#ifndef SOM_ODInfo_xh
#include <Info.xh>		  
#endif

#ifndef SOM_ODPartWrapper_xh
#include "PartWrap.xh"
#endif

#ifndef SOM_ODPart_xh
#include <Part.xh>
#endif

// scripting includes
#ifndef SOM_ODMessageInterface_xh
#include <Mssgintf.xh>
#endif

/*#ifndef SOM_ODBaseMessageInterface_xh
#include <Mssgintb.xh>
#endif
*/
#ifndef SOM_ODAddressDesc_xh
#include <Odadrdes.xh>
#endif

#ifndef SOM_ODObjectSpec_xh
#include <Odobjspc.xh>
#endif
// end scripting includes

#ifndef _BUTTON_
#include "button.h"
#endif

#define SOM_Module_button_Source
#define VARIABLE_MACROS
#include <Button.xih>

#include <mmsystem.h>

LRESULT CALLBACK ShadowWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);



struct MyInfo {
  	ODPlatformWindow ShadowWindow;
	ODBoolean	IsParentShadowAware;
};


//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Novell_Button constructor
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonsomInit(Novell_Button *somSelf)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

    Novell_Button_parent_ODPart_somInit(somSelf);

	_fDirty    = kODFalse;
	_fWindowID = 0;
	_fSession  = kODNULL;
	_fMenuBar  = kODNULL;
	_fFacets = kODNULL;
	_fHasFocus = FALSE;
}

//==============================================================================
// Novell_Button destructor
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonsomUninit(Novell_Button *somSelf)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODDeleteObject(_fFacets);

    Novell_Button_parent_ODPart_somUninit(somSelf);
}

//==============================================================================
// Novell_ButtonInitPart
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonInitPart(Novell_Button *somSelf, Environment *ev,
		ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	if (somSelf->IsInitialized(ev))
		return;
	
	somSelf->InitPersistentObject(ev, storageUnit);
	
	_fPartWrapper = partWrapper;		

	somSelf->MyCommonInitPart(ev);		

	storageUnit->AddProperty(ev, kODPropContents)->AddValue(ev, kButtonKind);
		// For your edification, AddProperty & AddValue 
		// implicitly focus.  Check the API for more info.

	lstrcpy(_fTextData, "ButtonPart content");

	// Initialize your other fields here.

	_fDirty = kODTrue;
}

//==============================================================================
// Novell_ButtonInitPartFromStorage
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonInitPartFromStorage(Novell_Button *somSelf, Environment *ev,
		ODStorageUnit* storageUnit, ODPartWrapper* partWrapper)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);
	if (somSelf->IsInitialized(ev))
		return;

	somSelf->InitPersistentObjectFromStorage(ev, storageUnit);
	
	_fPartWrapper = partWrapper;		

	somSelf->MyCommonInitPart(ev);
	storageUnit->Focus(ev, kODPropContents, kODPosSame,
					   kButtonKind, 0, kODPosSame);
	short	theSize = (short)storageUnit->GetSize(ev);
	storageUnit->GetValue(ev, theSize, _fTextData);
	_fTextData[theSize] = 0;
}

//==============================================================================
// Novell_ButtonMyCommonInitPart
//==============================================================================

SOM_Scope void SOMLINK Novell_ButtonMyCommonInitPart(Novell_Button *somSelf, Environment* ev)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	_fSession = _fPartWrapper->GetStorageUnit(ev)->GetSession(ev);
		// As your part grows, add your initialization that is common
		// between InitPart and InitPartFromStorage here.
		// Note that GetStorageUnit can be used, since just prior to
		// calling this method, InitPart calledInitPersistentObject or
		// InitPartFromStorage called InitPersistentObjectFromStorage.

	_fFacets = new FacetList;

	_fSelectionFocus = _fSession->Tokenize(ev, kODSelectionFocus);
	_fMenuFocus      = _fSession->Tokenize(ev, kODMenuFocus);
	_fKeyFocus       = _fSession->Tokenize(ev, kODKeyFocus);
	_fModalFocus     = _fSession->Tokenize(ev, kODModalFocus);

	_fFocusSet = new ODFocusSet();
	_fFocusSet->InitFocusSet(ev);
	_fFocusSet->Add(ev, _fKeyFocus);
	_fFocusSet->Add(ev, _fMenuFocus);
	_fFocusSet->Add(ev, _fSelectionFocus);

	_fMenuBar = _fSession->GetWindowState(ev)->CopyBaseMenuBar(ev);

	_fMenu.menu = CreatePopupMenu();
	strcpy (_fMenu.strMenu, "ButtonPart");
	if (!_fMenu.menu)
		OutputDebugStr("Button::MyCommonMyInitPart -- couldn't create menu.");
			// Note that THROW won't work with SOM.  Therefore we are using debug messages
			// for these types of errors.  

	_fMenuBar->AddMenuLast(ev, (ODMenuID)"ButtonPart", &_fMenu, _fPartWrapper);


	_fDisplayFrames = new OrderedCollection;

}

//==============================================================================
// Novell_ButtonFulfillPromise
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonFulfillPromise(Novell_Button *somSelf, Environment *ev,
		ODStorageUnitView* promiseSUView)

// Fulfills a previously made promise by providing the actual
// data the promise represents.
//
// The promiseSUView is a view into the same storage unit value
// that is created by SetPromiseValue. The information about the
// promise is encoded in the promiseSUView in the Part Handler's
// own internal format. The promise data is written into the
// promiseSUView replacing the data stored in the part handler's
// format.
//
// When the promise was made, a record of it was kept by this part.
// The promiseSUView contains the part's information for that promise.
// The part uses the data in the promiseSUView to determine which
// data to move/copy. The part then writes the data into the
// promiseSUView.
//
// The format of a promise is determined by the part. The only
// restriction is that a promise must be able to be written to
// a Storage Unit Value.
//
// The destination part does not even know that the fulfilment
// of a promise is taking place.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(promiseSUView);
}

//==============================================================================
// Novell_ButtonDropCompleted
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonDropCompleted(Novell_Button *somSelf, Environment *ev,
		ODPart* destPart,
		ODDropResult dropResult)

// Notifies the part that the drop is completed.
//
// Called by the dragAndDrop object.
//
// DropCompleted is a peculiar method. If DragAndDrop::StartDrag is
// synchronous, the return code to DragAndDrop::StartDrag is the
// drop result. Part::DropCompleted does not need to be called.
// However, if it is required that DragAndDrop::StartDrag returns
// immediately, there needs to be a way to notify the result of the
// drop. Before calling this method, you must ensure that the part
// previously started an asynchronous drag.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(destPart);
ODUnused(dropResult);
}

//==============================================================================
// Novell_ButtonDragEnter
//==============================================================================

SOM_Scope ODDragResult  SOMLINK Novell_ButtonDragEnter(Novell_Button *somSelf, Environment *ev,
		ODDragItemIterator* dragInfo,
		ODFacet* facet,
		ODPoint* where)

// Activates the part used to track the drag.
//
// Called by the facet object.
//
// The part should display a drag target border within the facet.
// During drag tracking (DragEnter, DragWithin) the part should
// never attempt to read data from any of the storage units supplied
// by the iterator. The part should only inspect the type of the
// dragged data. Before calling this method, you must ensure that
// the part is ready to receive DrawWithin messages.
//
// DragEnter() is called when the mouse enters a facet.  The part
// should examine the available data types of the dragged items
// using the ODDragItemIterator passed in.  If the part can handle
// a drop of the dragged object, it should provide the appropriate
// feedback (e.g., adorning the droppable frame, changing the cursor).
// If the destination part cannot handle the data types, nothing
// should be done.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

	return kODFalse;
}

//==============================================================================
// Novell_ButtonDragWithin
//==============================================================================

SOM_Scope ODDragResult  SOMLINK Novell_ButtonDragWithin(Novell_Button *somSelf, Environment *ev,
		ODDragItemIterator* dragInfo,
		ODFacet* facet,
		ODPoint* where)

// Tracks the drag operation, and provides graphical feedback
// regarding possible drop targets.
//
// This method highlights the appropriate content to provide
// feedback about potential drop targets, based on type of dragged
// data. It gets the type information out of the dragInfo. During
// drag tracking (DragEnter, DragWithin) the part should never
// attempt to read data from any of the storage units supplied by
// the iterator. The part should only inspect the type of the
// dragged data. Before calling tis method, you must ensure that
// the part was previously activated via DragEnter().
//
// DragWithin() is called continuously when the mouse is still in
// the facet. This allows the part to do any processing desired.
// One good example is when the frame has several hot spots where
// objects can be dropped. If the mouse is not over these hot spots,
// the cursor may need to be changed to reflect that the no
// dropping can be done there even though it is still in a
// droppable frame. Again, a ODDragItemIterator is passed in so
// that the part can examine the availabe data types of the dragged
// objects.
//
// DragWithin() also provides a chance for the part to examine the
// state of the machine. For example, some part may want to find
// out whether the modifier keys are down or not.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(dragInfo);
ODUnused(facet);
ODUnused(where);

	return kODFalse;
}

//==============================================================================
// Novell_ButtonDragLeave
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonDragLeave(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)

// Signals that the drag operation is complete, and so
// deactivates the part from drag tracking.
//
// This method un-highlights any content previously highlighted
// during drag tracking. It also removes the drag target border.
// Before calling this method you must ensure that the part was
// previously activated via DragEnter().  After executing this
// method successfully, the part is no longer active, and cannot
// receive further DragWithin() or Drop() messages.
//
// DragLeave() is called when the mouse leaves a droppable frame.
// This allows the part to clean up after a drag within it
// (e.g., removing adornment on the frame, changing the cursor
// back to its original form).

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(facet);
ODUnused(where);
}

//==============================================================================
// Novell_ButtonDrop
//==============================================================================

SOM_Scope ODDropResult  SOMLINK Novell_ButtonDrop(Novell_Button *somSelf, Environment *ev,
		ODDragItemIterator* dropInfo,
		ODFacet* facet,
		ODPoint* where)

// Transfers the dragged data into this part.
//
// Called by the facet object.
//
// Respond to the Drop operation. This might involve moving or
// copying data in to the part, or some other response entirely.
// However, the response should use the data returned from the
// dropInfo iterator to perform the operation. Before calling
// this method, you must ensure that the part was previously
// activated via DragEnter().
//
// Don't forget whether the drop is a move or a copy.
//
// Drop() is called when the mouse is released within a part which
// owns the facet. The part can then figure out whether it can
// receive the dragged object using the ODDragItemIterator passed
// in. The following is a sample code fragment for incorporating
// text into a part.
//
// The destination part should return an appropriate ODDropResult
// from Drop(). This result tells the source part (via the system)
// whether the drop is accepted.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(dropInfo);
ODUnused(facet);
ODUnused(where);

	return kODDropFail;
}

//==============================================================================
// Novell_ButtonContainingPartPropertiesChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonContainingPartPropertiesChanged(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame,
		ODStorageUnit* propertyUnit)

// Used by ContainingPart to inform the contained part of
// changes to the content properties of that object within
// the containing parts content model that encapsulates the
// embedded frame.
//
// This method inspects *propertyUnit* for properties that this
// part can understand. Where applicable, it incorporate those
// properties into part's content data. It ignores inapplicable
// properties, without signalling an error.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);
ODUnused(propertyUnit);
}

//==============================================================================
// Novell_ButtonGetContainingPartProperties
//==============================================================================

SOM_Scope ODStorageUnit*  SOMLINK Novell_ButtonGetContainingPartProperties(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Used by an embedded part to create a storage unit and write
// properties that the containing part associates with the
// embedded frame into it, before returning it. 
//
// Called by an embedded part.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);

	OutputDebugStr("Button::GetContainingPartProperties -- shouldn't be here.");

	return kODNULL;
}

//==============================================================================
// Novell_ButtonRevealFrame
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_ButtonRevealFrame(Novell_Button *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* revealShape)

// Asks a part to make an embedded frame visible.
//
// Called by an embedded part.
//
// This method scrolls one of this part's display frame's to make
// the embedded frame visible therein. If this part has no visible
// frames, it asks a containing part to reveal one of them. If no
// display frames for the part currently exist, or if this part's
// containing frame can't reveal the display frame, it opens a frame
// in a new window.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(embeddedFrame);
ODUnused(revealShape);

	OutputDebugStr("Button::RevealFrame -- shouldn't be here.");

	return kODFalse;
}

//==============================================================================
// Novell_ButtonEmbeddedFrameSpec
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonEmbeddedFrameSpec(Novell_Button *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODObjectSpec* spec)

// Creates an object specifier for the embedded frame.
//
// If this part is itself embedded, this method asks its containing
// part for the specifier for the part's display frame, then
// concatenates the specifier for that embedded frame.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(embeddedFrame);
ODUnused(spec);

	OutputDebugStr("Button::EmbeddedFrameSpec -- shouldn't be here.");
}

//==============================================================================
// Novell_ButtonCreateEmbeddedFramesIterator
//==============================================================================

SOM_Scope ODEmbeddedFramesIterator*  SOMLINK Novell_ButtonCreateEmbeddedFramesIterator(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Creates an object that will iterate over the frames that
// are embedded within a display frame of this part.
//
// To indicate all the display frames, use kODNull for the frame
// parameter.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);

	OutputDebugStr("Button::CreateEmbeddedFramesIterator -- shouldn't be here.");

	return kODNULL;
}

//==============================================================================
// Novell_ButtonDisplayFrameAdded
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonDisplayFrameAdded(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Tells a part to add *frame* as one of its display frames.
//
// This method is only called by frame objects during their
// initialization.  Same for RemoveDisplayFrame() and
// CloseDisplayFrame().
//
// The part must record *frame* in whatever internal structures it
// uses to remember its display frames. The new frame will carry a
// suggested viewType and presentation information. The part should
// look at those settings, and decide if it can support them; if not,
// it should update those settings in the frame to reflect a default
// presentation that it can support. Note that the part must support
// the required set of standard viewTypes (frame, icon, small icon,
// thumbnail, etc.). The part will then create the appropriate
// partInfo data and store it in the frame. This data allows the part
// to distinguish the frame from its other display frames, and is
// also a handy place to store other view-related information.
//
// Add the new display frame to the parts list of its display frames.
// This list, like the parts other internal structures, is completely
// hidden from OpenDoc. The developer may represent this list any way
// he chooses. The simplest of parts may be able to do without such a
// list, but most parts will require it.
//
// Validate the viewType and presentation of the new frame. The part
// must support the required set of view types. Other kinds of view
// types or presentations are optional. The part should inspect these
// values and correct them if necessary. See the recipe for View Types
// and Presentations for more detail.
//
// Add partInfo to the frame. The partInfo field of a frame is a
// convenient place for a part to store information about that view of
// itself. It can be anything from a simple ID to a pointer to a
// complicated structure or a helper object. The partInfo for a frame
// is stored in the storage unit for the frame, not the part. If the
// part has many frames of which only a few are internalized, only the
// partInfo of those frames will be internalized and take up memory.
//
// The display frames need not be internalized until needed and will be
// done by the containing part. ???

{
	Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	_fDisplayFrames->AddLast(frame);

}

//==============================================================================
// Novell_ButtonDisplayFrameRemoved
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonDisplayFrameRemoved(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Removes the frame from the list of display frames.
//
// Called by Frame::Remove().
//
// This method makes whatever other adjustments are necessary
// to deal with removing one of the presentations. This includes
// removing any frames embedded within this display frame.
// Before calling this method, you must ensure that the frame
// has no facets.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet, frame);
}

//==============================================================================
// Novell_ButtonDisplayFrameConnected
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonDisplayFrameConnected(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

}

//==============================================================================
// Novell_ButtonDisplayFrameClosed
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonDisplayFrameClosed(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Informs a part that one of its display frames is closing.
//
// Called by the frame object.
// The part should remove *frame* from its list of display frames,
// call Frame::Close() on any frames that are embedded within that
// frame, and then release the frame.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	_fSession->GetArbitrator(ev)->RelinquishFocusSet(ev, _fFocusSet, frame);
}

//==============================================================================
// Novell_ButtonAttachSourceFrame
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonAttachSourceFrame(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame,
		ODFrame* sourceFrame)

// Called by the object that requested creation of a frame,
// immediately after the creation of the frame.
//
// Calling this method associates a *source frame* with a display
// frame of a part. This tells the part to keep two or more of its
// display frames synchronized.
//
// A part will receive this call just after a display frame has
// been added. Attaching a source frame should cause the display
// frame to look identical to it. If presentations differ, it
// causes the display frame to be equivalent to it. This causes
// duplication of the embedded frames, and ensures that the view
// in one frame is updated when content in the other is changed.
// Before calling this method, you must ensure that both frame
// and sourceFrame are display frames of the part.
//
// The part being displayed should take whatever action necessary
// to synchronize the frames. As a minimum, if the two frames are
// the same kind of presentation, it should duplicate embedded
// frames in one frame into the other. 

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);
ODUnused(sourceFrame);
}

//==============================================================================
// Novell_ButtonFrameShapeChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonFrameShapeChanged(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// ***Notifies the part that the frame shape of one of its
// display frames has been changed by its containing part.
//
// Called by Frame::ChangeFrameShape.
//
// The part should take whatever actions are necessary to respond
// to the new shape. It may need to re-layout its content, change
// its used shape, resize its embedded frames, or something else.
// It also has the option of turning around and asking the frame
// for a different frame shape via RequestFrameShape, though it
// must be able to handle the shape it is given. If the size of
// the frame is not sufficient, the part may ask the containing
// part for a continuation frame via CreateEmbeddedFrame.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

//	frame->RequestFrameShape(ev, somSelf->MyGetFrameShape(ev, frame), kODNULL);
//	somSelf->MyAdjustFacets(ev, frame);
	frame->Invalidate(ev, kODNULL, kODNULL);
	frame->InvalidateActiveBorder(ev);
}

//==============================================================================
// Novell_ButtonViewTypeChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonViewTypeChanged(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Notifies the part that the viewType of one of its
// frames has been changed.
//
// Parts must support all standard view types.
// And they are ... ???

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_ButtonPresentationChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonPresentationChanged(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Notifies the part that the presentation kind of one
// of its frames has been changed.
//
// Called by Frame::ChangeViewType().
//
// The part should examine the new view type via
// frame->GetViewType(). If the part does not support that kind
// of view type, it should correct the frame's viewType using
// frame->SetViewType(). Note that parts MUST support the
// standard set of view types (se HI spec). The part should then
// adjust its display in the display frame to be of the new view
// type.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_ButtonSequenceChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonSequenceChanged(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Informs the part that the sequencing of a group of its
// display frames has been changed.
//
// Called by containing part.
//
// The containing part of frame should call this when adding a new
// frame to the group or re-ordering the frames in the group. A
// single frame of the group is passed as an argument to indicate
// which group of which containing frame has been changed.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_ButtonWritePartInfo
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonWritePartInfo(Novell_Button *somSelf, Environment *ev,
		ODPtr partInfo,
		ODStorageUnitView* storageUnitView)

// Externalizes the frame's partInfo data onto the frame's
// storage unit.
//
// Called by the frame object.
//

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(partInfo);
ODUnused(storageUnitView);
}

//==============================================================================
// Novell_ButtonReadPartInfo
//==============================================================================

SOM_Scope ODPtr  SOMLINK Novell_ButtonReadPartInfo(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame,
		ODStorageUnitView* storageUnitView)

// Internalizes the partInfo for a display frame of this part.
//
//
// Called by the frame object.
//
// The data for the partInfo is stored in a value in the frame's
// storage unit, specified by the suView parameter. It gets the
// data from out of the value, and places it in a block of memory.
// It then returns the memory block to the frame for it to hold.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);
ODUnused(storageUnitView);

	return kODNULL;
}

//==============================================================================
// Novell_ButtonOpen
//==============================================================================

SOM_Scope ODID  SOMLINK Novell_ButtonOpen(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Creates and opens a presentation of the part in a frame
// in a new window.
//
// This method adds this part as the root part of the window.
// It bases the presentation in the new frame on the presentation
// in the old frame, or on a default presentation if there
// is no old frame.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODWindow*	window = kODNULL;

	if (frame)
		window = _fSession->GetWindowState(ev)->GetWindow(ev, _fWindowID);

	if (window == kODNULL)
	{
		window = somSelf->MyMakeWindow(ev, frame);
		_fWindowID = window->GetID(ev);
		window->Open(ev);
		window->Show(ev);
	}

	window->Select(ev);

	return window->GetID(ev);
}

//==============================================================================
// Novell_ButtonRequestEmbeddedFrame
//==============================================================================

SOM_Scope ODFrame*  SOMLINK Novell_ButtonRequestEmbeddedFrame(Novell_Button *somSelf, Environment *ev,
		ODFrame* containingFrame,
		ODFrame* baseFrame,
		ODShape* frameShape,
		ODPart* embedPart,
		ODTypeToken viewType,
		ODTypeToken presentation,
		ODBoolean isOverlaid)

// Asks the part to create a new frame and embed a part in it.
//
// This is only requested by embedded parts which want additional
// frames in which to display in the same containing part.
//
// If this part is a containing part, it should ask the draft to
// create a new frame, and embed the frame in its content.
// *baseFrame* is another display frame of the same part, already
// embedded in the same containing part. The frameShape parameter
// is relative to the frame coordinate system of the baseFrame.
// The containing part decides if it can fulfill the requests for
// frameShape. - if not, it can create the frame where it wants
// and with the shape it chooses. The containing part should assign
// the new frame to the same frameGroup as the baseFrame. If
// isOverlaid is true, the new frame should float above the part's
// content, and should not have to negotiate for space with the part.
// The viewType and presentation are just passed through to
// Draft::CreateFrame().
//
// Note that RequestEmbeddedFrame should only be called by an embedded
// part on its containing part in order to get a sibling frame.  That
// is why this call takes a baseFrame parameter.  The baseFrame must
// already be embedded inside the part receiving the
// RequestEmbeddedFrame message.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(containingFrame);
ODUnused(baseFrame);
ODUnused(frameShape);
ODUnused(embedPart);
ODUnused(viewType);
ODUnused(presentation);
ODUnused(isOverlaid);

	OutputDebugStr("Button::RequestEmbeddedFrame -- shouldn't be here.");

	return kODNULL;
}

//==============================================================================
// Novell_ButtonRemoveEmbeddedFrame
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonRemoveEmbeddedFrame(Novell_Button *somSelf, Environment *ev,
		ODFrame* embeddedFrame)

// Removes a frame used for viewing an embedded part.
//
// Called by an embedded part.
//
// It is called by an embedded part to indicate it no longer
// needs the frame to display itself.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(embeddedFrame);

	OutputDebugStr("Button::RemoveEmbeddedFrame -- shouldn't be here.");
}

//==============================================================================
// Novell_ButtonRequestFrameShape
//==============================================================================

SOM_Scope ODShape*  SOMLINK Novell_ButtonRequestFrameShape(Novell_Button *somSelf, Environment *ev,
		ODFrame* embeddedFrame,
		ODShape* frameShape)

// Used by an embedded part to ask for a change in the 
// shape of its frame.
//
// Called by Frame::RequestFrameShape().
//
// This method decides what new shape to give the embedded frame,
// using the requested *frameShape* as a guideline. It then
// answers with what shape is actually granted as the return value.
// The requestor must abide by the returned shape, though it may
// make further requests for different shapes or additional frames.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(embeddedFrame);
ODUnused(frameShape);

	OutputDebugStr("Button::RequestFrameShape -- shouldn't be here.");

	return kODNULL;
}

//==============================================================================
// Novell_ButtonUsedShapeChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonUsedShapeChanged(Novell_Button *somSelf, Environment *ev,
		ODFrame* embeddedFrame)

// Informs a containing part that the used shape of one of
// its embedded frames has changed.
//
// Called by Frame::ChangeUsedShape().
//
// Containing parts that have arranged their content to conform
// to the used shape of an embedded frame (as in text wrapping)
// will need to adjust the layout of that content for the new
// used shape.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(embeddedFrame);
}

//==============================================================================
// Novell_ButtonAdjustBorderShape
//==============================================================================

SOM_Scope ODShape*  SOMLINK Novell_ButtonAdjustBorderShape(Novell_Button *somSelf, Environment *ev,
		ODFacet* embeddedFacet,
		ODShape* shape)

// Adjusts the shape of the active frame border of an embedded
// frame.
//
// Called by the arbitrator object.
//
// The *shape* parameter specifies the requested shape. The
// return value specifies that shape as it is obscured by the
// other contents of this part.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(embeddedFacet);

	return shape;
}

//==============================================================================
// Novell_ButtonFacetAdded
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonFacetAdded(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	// Add new facet to list of current facets.

	_fFacets->Add(facet);

	ODFrame* frame = facet->GetFrame(ev);
//	frame->RequestFrameShape(ev, somSelf->MyGetFrameShape(ev, frame), kODNULL);
		// ** First, MyGetFrameShape is called to calculate the frame
		// shape we want.  However, we might not get it, due to the
		// needs/constraints of the containing part.  Therefore, after
		// calculating what we want, we see if we can get it by calling
		// RequestFrameShape.
		// RequestFrameShape either returns us what we passed it, or
		// returns something else because it thinks it knows best.
		// Either way, we then proceed with the returned result.
		// Note that this means that we have to be prepared to deal
		// with a frame shape other than we desire.

//	somSelf->MyAdjustFacets(ev, frame);
		// Given a new negotiated frame shape, adjust our facets based
		// on it.  That's all there is to it.

	if (frame->IsRoot(ev)) 
	{
		ODBoolean succeeded = kODFalse;
		succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame);
		if (succeeded)
		{
			somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
			somSelf->FocusAcquired(ev, _fMenuFocus, frame);
			somSelf->FocusAcquired(ev, _fKeyFocus, frame);
		}
	}

	MyInfo *info = new MyInfo;
	facet->SetPartInfo(ev,(ODInfoType) info);	
	somSelf->MyCreateShadowWindow (ev, facet);


}

//==============================================================================
// Novell_ButtonFacetRemoved
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonFacetRemoved(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	_fFacets->Remove(facet);
		// This just removes the reference from our facet list.

	ODFrame* frame = facet->GetFrame(ev);
//	frame->RequestFrameShape(ev, somSelf->MyGetFrameShape(ev, frame), kODNULL);
//	somSelf->MyAdjustFacets(ev, frame);
		// ***This is here in case losing a facet means that we need to recalculate
		// the frame.  This would occur if the part added some of its own facets,
		// beyond the single facet that is automatically given to a frame.  If
		// you don't have your own additional facets, then this code renegotiates
		// the frame shape for no reason, since the frame will be going away
		// immediately afterwards (after the last/only facet is removed).

	somSelf->MyDeleteShadowWindow (ev, facet);
	MyInfo *info = (MyInfo *)facet->GetPartInfo(ev);
	delete info;
	facet->SetPartInfo(ev,kODNULL);

}

//==============================================================================
// Novell_ButtonCanvasChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonCanvasChanged(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet)

// Notifies the part that one of its facets has been moved to
// image on a different canvas.
//
// Called by the facet object.
//
// The part must update any internal state necessary for
// compliance with this method.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(facet);
}

//==============================================================================
// Novell_ButtonGeometryChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonGeometryChanged(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet,
		ODBoolean clipShapeChanged,
		ODBoolean externalTransformChanged)

// Called by a facet of the part to inform it that the clipping
// shape and/or external transform of that facet has changed.
//
// Called by the facet object.
//
// The part should use the new clip shape for display from now
// on. Parts that display only in response to update events don't
// need to do anything special, provided they check the clip
// shape each time they draw. Parts that display asynchronously
// (like clocks, movies, etc.) must notice their new clipping and
// limit their display accordingly.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	somSelf->MySizeShadowWindow(ev,facet);

ODUnused(clipShapeChanged);
ODUnused(externalTransformChanged);
}

//--------------------------------------------------------------------
// Novell_ButtonMyWantResizable
//--------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK Novell_ButtonMyWantResizable(Novell_Button *somSelf, Environment *ev)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	return kODFalse;
		// used in MyMakeWindow() to toggle some parameters
}


//--------------------------------------------------------------------
// Novell_ButtonMyMakeWindow
//--------------------------------------------------------------------

SOM_Scope ODWindow*	SOMLINK Novell_ButtonMyMakeWindow(Novell_Button *somSelf, Environment *ev, ODFrame* sourceFrame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODPlatformWindow	platformWindow = kODNULL;
	ODWindow*			window = kODNULL;
	
	platformWindow =  _fSession->GetWindowState(ev)->CreatePlatformWindow(ev, kODFalse, WS_CHILD | WS_CLIPSIBLINGS);

	window = _fSession->GetWindowState(ev)->RegisterWindow
	(
		ev,
		platformWindow,								// newWindow
		kODNULL,									// frameType
		(sourceFrame == kODNULL),					// isRootWindow
		somSelf->MyWantResizable(ev),				// isResizable
		kODFalse,									// isFloating
		kODTrue,									// shouldSave
		_fPartWrapper,								// rootPart
		_fSession->Tokenize(ev, kODViewAsFrame),	// viewType
		kODNullTypeToken,							// presentation
		sourceFrame									// sourceFrame
	);

	return window;
}

//==============================================================================
// Novell_ButtonDraw
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonDraw(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet,
		ODShape* invalidShape)

// Draws the part in the facet, updating the portion of the
// facet in the invalidShape.
//
// Called by the facet object.
//
// The part should draw itself on the facet's canvas. The part
// must examine its canvas' isDynamic flag to determine if it
// will be drawing on the screen or to a printer, and then draw
// itself appropriately.
//
// Draw the part in the given facet. Only the portion in the
// invalidShape needs to be drawn.
//
// There are several steps a part needs to take to perform the
// imaging.
// 1) The part should look at the given facet and its frame.
//    Both the frame and the facet may have some partInfo that
//    the part has placed there, which the part can use to
//    decide how it will display itself.  The frame also has
//    viewType and presentation fields, which indicate what kind
//    of view of the part should display.
// 2) The part should examine its canvas to see how it should
//    be imaged. The canvas can be obtained from the facet via
//    ODFacet::GetCanvas(). If the canvas' isDynamic flag is
//    kODTrue, the part is imaging onto a dynamic device like
//    a CRT; otherwise, it is imaging to a static device like
//    a printer. The part will probably display its content
//    differently for static and dynamic views. For instance,
//    it should not display scroll bars on a static canvas.
// 3) The part must make sure the platform graphics system is
//    prepared to draw into the correct context for the facet.
//    On the Macintosh using QuickDraw, it is necessary to call
//    SetPort() for the appropriate canvas, and set up other
//    attributes of the drawing environment. A FocusLib library
//    is supplied to help focus drawing commands to a facet.
//    Make sure to clip to the facet's clipShape (FocusLib
//    does this for you).
// 4) Draw the part's contents.
// 5) Restore the old graphics environment.
//
// Part editors may sometimes need to display their parts
// asynchronously, that is, not in response to a ::Draw() call.
// This process is very similar to the basic drawing recipe,
// with minor modifications.
// 1) Determine which of the part's frames should be drawn. A part
//    may have multiple display frames, and more than one may need
//    updating. Parts store their display frames in whatever way
//    they want, so we can't tell you how to find them here.
// 2) For each frame being displayed, all facets must be drawn.
//    ODFrame::CreateFrameFacetIterator() returns an iterator
//    which will list all the facets of a frame. Draw the part's
//    contents in each of these facets, using the recipe above.
// 3) After drawing in a facet, call ODFacet::DrawnIn() on it to
//    tell it you've drawn in it asynchronously. If the facet is
//    on an offscreen canvas, this lets it get copied into the window. 

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	MyInfo *info = (MyInfo *)facet->GetPartInfo(ev);
	if (info) {
		if (info->ShadowWindow)	{
			HWND button = GetDlgItem(info->ShadowWindow, 100);
			if (IsWindow(button)) {
				InvalidateRect (button, NULL, TRUE);
			}
		}
	}


}

//==============================================================================
// Novell_ButtonCanvasUpdated
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonCanvasUpdated(Novell_Button *somSelf, Environment *ev,
		ODCanvas* canvas)

// Notifies the part that a canvas that it owns has been
// updated and that its contents need to be copied to its
// parent canvas.
//
// Called by the facet object.
//
// The data must be copied from an off-screen canvas,
// transformed, and then placed in the containing canvas.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(canvas);
}

//==============================================================================
// Novell_ButtonHighlightChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonHighlightChanged(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet)

// Notifies the part that the highlight state of one of its
// frames has been changed.
//
// Called by the frame object.
//
// It adjusts this part's presentation in the facet to its
// new highlight state. New state may be found by calling
// facet->GetHighlight(). It passes notification to embedded
// parts.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(facet);
}

//==============================================================================
// Novell_ButtonGetPrintResolution
//==============================================================================

SOM_Scope ODULong  SOMLINK Novell_ButtonGetPrintResolution(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Returns the minimum desired resolution in dots per inch
// that this part requires for printing the contents of the
// specified frame.
//
// Called by part or the application and is used in performing
// printing.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);

	return 0;
}

//==============================================================================
// Novell_ButtonCreateLink
//==============================================================================

SOM_Scope ODLink*  SOMLINK Novell_ButtonCreateLink(Novell_Button *somSelf, Environment *ev,
		ODPtr data,
		ODULong size)

// Creates a new link object.
//
// If a link already exists to the content identified by the data
// and size arguments, this method returns the link object;
// otherwise, it creates a new link object, puts in the initial
// data and returns it to the caller.
//
// This method identifies the content to be linked (by resolving
// the object specifier saved in the data parameter, or by some
// other means). It then creates a link object to represent the
// content data. The part must maintain information about what
// portion of its contents have been linked to it, so that it may
// notify link clients when that data has been changed. The link
// created is returned to the caller. Before calling this method,
// you must ensure that the data identifies some portion of this
// part's contents. After calling this method successfully, this
// part maintains a link to the identified content.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(data);
ODUnused(size);

	return kODNULL;
}

//==============================================================================
// Novell_ButtonLinkUpdated
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonLinkUpdated(Novell_Button *somSelf, Environment *ev,
		ODLink* updatedLink,
		ODChangeID id)

// Retrieves the data from the link and incorporates it into
// this part at the link's destination, thereby replacing any
// previous content of the link.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(updatedLink);
ODUnused(id);
}

//==============================================================================
// Novell_ButtonRevealLink
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonRevealLink(Novell_Button *somSelf, Environment *ev,
		ODLinkSource* linkSource)

// Reveals data that was previously linked in a window, making it
// available for viewing in a display frame.
//
// Called by ODLinkSource objects.  Should not be called by parts.
// In some display frame for this part, this method selects the
// content linked by the linkSource argument, and scrolls it into
// view. That display frame is made the active frame. If no display
// frames for the part currently exist, or if this part's containing
// frame can't reveal the display frame, it opens a frame in a new
// window.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(linkSource);
}

//==============================================================================
// Novell_ButtonEmbeddedFrameChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonEmbeddedFrameChanged(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame,
		ODChangeID change)

// Notifies the containing part that the content displayed
// in the argument *embedded frame* has changed.
//
// Called by an frame object belonging to an embedded part when
// the frame object's ContentChanged method is called.
//
// The part should call the ContentChanged method of any of its
// frames that would be interested in this information. This
// method should only be called by frame objects. The part is
// not responsible for passing this notification on to its
// containing part. The part may ignore this notification if it
// is uninterested in changes to embedded content. A part should
// wait a certain length of time (a second perhaps) before
// updating its display so that subsequent calls to
// EmbeddedFrameChanged with the same ODChangeID dont result
// in multiple updates for the same change.After executing this
// method successfully, the ContentChanged method of any of the
// part's frames may have been called and the part may have
// taken action to update its display.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(change);
ODUnused(frame);
}

//==============================================================================
// Novell_ButtonLinkStatusChanged
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonLinkStatusChanged(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)

// Allows the part to set the link status of any embedded frames.
//
// Called by a part's frame when that frame's ChangeLinkStatus
// method is called.
//
// Frames notify their owner parts that their link status has
// changed whenever ChangeLinkStatus is called. After this
// method executes successfully, the part will call
// ChangeLinkStatus on any embedded frames that are involved
// in the link in question.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(frame);
}

//==============================================================================
// Novell_ButtonBeginRelinquishFocus
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_ButtonBeginRelinquishFocus(Novell_Button *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(ownerFrame);

	if ((focus == _fModalFocus) && (proposedFrame->GetPart(ev) != _fPartWrapper)) {
		return kODFalse;
			// ** 6/23/94
			// What IS ModalFocus, anyway?  The whole purpose of this
			// ModalFocus thing is to restrict frame changes.  This is
			// the part's chance to do this.  But how much to restrict...
			//
			// This is an interesting case.  ModalFocus is kind of a weird
			// concept in OpenDoc, as it goes against the principal of
			// being able to click anywhere at any time.  This implementation
			// keeps the focus on the part.  Note that the implementation
			// of ModalFocus might be more restrictive than this.  You may
			// wish to restrict it to a single frame, instead of allowing
			// the focus to move from frame to frame within a single part.
			// If you wish to restrict it to a single frame, then the if
			// should only check if it is a modal focus.
	}
	else {
		return kODTrue;
			// This is the super-script way of handling ModalFocus.  You
			// can NOT switch off the frame to another, no matter what.
	}
}

//==============================================================================
// Novell_ButtonCommitRelinquishFocus
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonCommitRelinquishFocus(Novell_Button *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(proposedFrame);

	somSelf->FocusLost(ev, focus, ownerFrame);
		// ** 6/23/94
		// No choices to be made here.  It's too late to say no.  We are
		// losing the focus if we are here.  Getting called here means
		// that BeginRelinquishFocus has already agreed that losing focus
		// is okay.  If you don't want this to be happening, then you need
		// to do something in BeginRelinquishFocus.
		//
		// The way that some other samples are currently written I believe
		// to be in error.  The recipes say that when this is called, it
		// has already been decided that, focus-wise, you lose.  Therefore
		// there should be no conditions on calling FocusLost.
}

//==============================================================================
// Novell_ButtonAbortRelinquishFocus
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonAbortRelinquishFocus(Novell_Button *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame,
		ODFrame* proposedFrame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(focus);
ODUnused(ownerFrame);
ODUnused(proposedFrame);

	// ** 6/23/94
	// Being here means that BeginRelinquishFocus said no to one of the foci.
	// You are being informed of this because you may have already taken action
	// based on a previous focus.  Note that if foci are managed as a set, if
	// BeginRelinquishFocus says false to any of the foci, then no action is
	// taken.  If however the foci are tested one at a time, it is possible that
	// the part has already taken action based on the first foci, and therefore
	// needs to undo something once a foci says no thanks.
}

//==============================================================================
// Novell_ButtonFocusAcquired
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonFocusAcquired(Novell_Button *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	if (focus == _fMenuFocus) 
		if (ownerFrame && _fMenuBar)
		{	
			_fMenuBar->Display(ev);
		}

	_fHasFocus = TRUE;
}

//==============================================================================
// Novell_ButtonFocusLost
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonFocusLost(Novell_Button *somSelf, Environment *ev,
		ODTypeToken focus,
		ODFrame* ownerFrame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(ownerFrame);

	_fHasFocus = FALSE;
	if (focus == _fMenuFocus) 
	{
	}
}

//==============================================================================
// Novell_ButtonHasExtension
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_ButtonHasExtension(Novell_Button *somSelf, Environment *ev,
		ODType extensionName)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(extensionName);

	return kODFalse;
		// No extension until you implement one for your part.
}

//==============================================================================
// Novell_ButtonGetExtension
//==============================================================================

SOM_Scope ODExtension*  SOMLINK Novell_ButtonGetExtension(Novell_Button *somSelf, Environment *ev,
		ODType extensionName)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(extensionName);

	OutputDebugStr("Until the part implements extension support, this should not get called.");

	ev->_major = USER_EXCEPTION;
		// If we are called with an extension type we don't support,
		// we should be returning an error here.

	return kODNULL;
}

//==============================================================================
// Novell_ButtonReleaseExtension
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonReleaseExtension(Novell_Button *somSelf, Environment *ev,
		ODExtension* extension)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(extension);
}

//==============================================================================
// Novell_ButtonPurge
//==============================================================================

SOM_Scope ODSize  SOMLINK Novell_ButtonPurge(Novell_Button *somSelf, Environment *ev,
		ODSize size)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(size);
	
	// Button doesn't do anything here.

	return 0;
}

//==============================================================================
// Novell_ButtonIncrementRefCount
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonIncrementRefCount(Novell_Button *somSelf, Environment *ev)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

    Novell_Button_parent_ODPart_IncrementRefCount(somSelf,ev);
}

//==============================================================================
// Novell_ButtonRelease
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonRelease(Novell_Button *somSelf, Environment *ev)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

    Novell_Button_parent_ODPart_Release(somSelf,ev);

	// ***6/23/94
	//
	// If you are using RegisterIdle on the part, not on frames, then
	// the RefCount is bumped up by one by OpenDoc.  OpenDoc keeps a
	// reference to all parts that register idle time.  ALL OF THESE MUST
	// BE RESOLVED BEFORE THE DESTRUCTOR IS CALLED.  This is
	// the place to do that.

	// The logic below, assuming that Button has registered for idle
	// time, is that if the RefCount is 1, then we are here to unregister
	// the idle.  When the part is being removed, OpenDoc must decrement
	// the RefCount and call Release until the part gets messaged with
	// a RefCount of 0.  Once you return from here with a RefCount of 0,
	// OpenDoc will call the destructor.

	// This means that if you have registered for idle time, Release will
	// be called TWICE when closing down your part.  The first time the
	// RefCount is 1.  This is when you should unregister the idle time.
	// When you are called with a RefCount of 0, that when it gets really
	// serious.  This is when you detach from the draft.

	if (_fPartWrapper->GetRefCount(ev) == 1) {
		// Here is where you would unregister idle time for the part if
		// have registered time.  Note that if you unregister without
		// registering, OpenDoc will crash.  It's not just a simple
		// look-up-and-if-there-remove kind of operation.

		// Note that if you unregister idle here, OpenDoc will need to
		// call Release (here) due to it.  This means that when we call
		// to unregister the idle, we are nesting calls to Release.
		// Due to this, I return out of each case, just to make the
		// flow of control of the call(s) to Release more straightforward.

		// Note that if you are going to use idle registration, you will
		// need to include "Disptch.h"

		return;
	}
    	
	if (somSelf->GetRefCount(ev) == 0)
		somSelf->GetStorageUnit(ev)->GetDraft(ev)->ReleasePart(ev, somSelf);
}

//==============================================================================
// Novell_ButtonReleaseAll
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonReleaseAll(Novell_Button *somSelf, Environment *ev)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	if (_fMenuBar != kODNULL)
		_fMenuBar->Release(ev);
}

//==============================================================================
// Novell_ButtonExternalize
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonExternalize(Novell_Button *somSelf, Environment *ev)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	if (_fDirty != kODFalse)
	{
    	Novell_Button_parent_ODPart_Externalize(somSelf,ev);

		ODStorageUnit* storageUnit = _fPartWrapper->GetStorageUnit(ev);
			// Get the reference to where we are writing to.

		storageUnit->Focus(ev, kODPropContents, kODPosSame, kButtonKind, 0, kODPosSame);
			// First we focus on the property we want to write out.

		storageUnit->SetValue(ev, lstrlen(_fTextData), _fTextData);
			// Now we write out the property.

		_fDirty = kODFalse;
			// Flag our part as no longer being dirty.
   	}
}

//==============================================================================
// Novell_ButtonCloneInto
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonCloneInto(Novell_Button *somSelf, Environment *ev,
		ODDraftKey key,
		ODStorageUnit* storageUnit,
		ODFrame* initiatingFrame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODStorageUnit*	su = _fPartWrapper->GetStorageUnit(ev);
	ODDraft*		draft = su->GetDraft(ev);

	ODVolatile(draft);

	somSelf->Externalize(ev);

	if (initiatingFrame) {	
		su->CloneInto(ev, key, storageUnit, initiatingFrame->GetStorageUnit(ev)->GetID(ev));
	}
	else {
		su->CloneInto(ev, key, storageUnit, kODNULL);
	}

	if (ev->_major != NO_EXCEPTION)
		draft->AbortClone(ev, key);
}

//==============================================================================
// Novell_ButtonExternalizeKinds
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonExternalizeKinds(Novell_Button *somSelf, Environment *ev,
		ODTypeList* kindset)

// Externalizes a representation for each 'kind' that it supports.
//
// The part should iterate through all the kinds in 'kindList',
// and externalize a representation for each that it supports.
// This call does not specify anything about the ordering of those
// kinds in the contents property. Before calling this method,
// you must ensure that the part supports a subset of the kinds
// in 'kindList'. After executing this method successfully, the
// contents property of the part has a value and representation
// for each kind in kindListsupported.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(kindset);

	somSelf->Externalize(ev);
}

//==============================================================================
// Novell_ButtonChangeKind
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonChangeKind(Novell_Button *somSelf, Environment *ev,
		ODType kind)

// Asks a part to change into a new kind of content,
// i.e. ask an ASCII Text part to change into a Styled Text part.
//
// The part should begin using the given kind as its primary kind
// if it is supported. The first type of the first value in the
// content property of the part's storage unit should become the
// given kind. Before calling this method, you must ensure that the
// part supports the specified kind. After this method is executed
// successfully, the part's primary kind is the one that was
// specified in the parameter, and the first type of the first
// value in the content property of the part's storage unit is of
// the specified type. When it reads in data, the part uses this
// representation.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(kind);
}

//==============================================================================
// Novell_ButtonHandleEvent
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_ButtonHandleEvent(Novell_Button *somSelf, Environment *ev,
		ODEventData* event,
		ODFrame* frame,
		ODFacet* facet)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODBoolean	tWasHandled = kODFalse;
	
	switch ( event->message ) {
		case kODEvtNull:
			tWasHandled = kODTrue;
			break;
			
		case WM_LBUTTONDOWN:
			tWasHandled = somSelf->MyHandleMouseDown(ev, event, frame, facet);
			break;
			
		case kODEvtMouseDownEmbedded:
		case WM_LBUTTONUP:
		case WM_KEYDOWN:
		case kODEvtActivate:
			tWasHandled = kODTrue;
			break;

		case kODEvtMenu:

			tWasHandled = somSelf->MyHandleMenuEvent(ev, frame, event, facet );
			break;

		default:
			break;
	}

	return tWasHandled;

// Below is some documentation for this method.  If you don't care for
// being here, then just delete it.
//
// The frame and facet parameters of HandleEvent() may be
// kODNULL, depending on the kind of event.
//
// Parts must handle the following events, which correspond to
// standard Windows messages:
//
//	kODEvtNull
// 	kODEvtMouseDown
// 	kODEvtMouseUp
// 	kODEvtKeyDown
// 	kODEvtKeyUp
// 	kODEvtAutoKey
// 	kODEvtUpdate
// 	kODEvtActivate
// 	kODEvtOS
//
// Null Events --
// In order to receive null events (i.e. idle time), parts must call
// ODDispatcher::RegisterIdle(), specifying the part, a frame
// (optional) and idle frequency. The part will receive a null event
// for each frame registered. ODDispatcher::GetSleepTime() is called
// by the shell, and the value passed to WaitNextEvent. An appropriate
// sleep time is computed based on the idle frequencies of registered
// idle frames.
//
// Mouse Events --
// Unmodified mouse events are delivered to the facet under the mouse
// location using Part::HandleEvent().
//
// Shift-Click and Command-Click go to the frame with the selection
// focus.  Mouse events in window title bars are converted to window
// events. (See below)  Mouse down events in the menu bar are converted
// to menu events. (See below)
//
// Keyboard Events --
// Keyboard events go to the frame with the keyboard focus, with the
// exception of the Page Up, Page Down, Home and End keys, which will
// go to the frame with the scrolling focus, if there is one.
//
// Update Events --
// Update events are not passed to Part::HandleEvent(). Rather
// Part::Draw() will be called for each facet in the window.
//
// Activate Events --
// Activate events are also delivered to each facet, using
// Part::HandleEvent().
//
// Disk Events --
// Currently, disk events are not distributed to parts.
// But where do they go???
//
// OS Events --
// Suspend/Resume events are delivered to each facet in each
// window using Part::HandleEvent(). 
//
// Mouse Moved events are not passed to Part::HandleEvent().
// They are handled by the dispatcher, and translated into calls
// to Part::MouseEnter(), MouseWithin() and MouseLeave().
// See Cursor Tracking below.
//
// Menu Events --
// OpenDoc converts a mouse down in the menu bar, or its
// command-key equivalent, into a menu event of type kODEvtMenu.
//
// The message field of the event record contains the result 
// returned by MenuSelect() or MenuKey(). i.e. the menu is in 
// the high word, and the item in the low word. The part can 
// obtain a command number using ODMenuBar::GetCommand().
//
// Window Events --
// Events in the title bar of a window (eg. clicking in the
// close box) are usually handled by the shell, but are first
// offered to the root part of the window. Parts which wish to
// intercept these events (perhaps to hide rather than close a
// window) must handle the following event: kODEvtWindow 
// The message field of the event contains the part code, as
// returned by FindWindow().
//
// Events in Embedded Frames --
// Parts which support embedding may also receive the following events:
//	
//	kODEvtMouseDownEmbedded 
//	kODEvtMouseUpEmbedded
//	kODEvtMouseDownBorder
//	kODEvtMouseUpBorder
//
// If the user clicks in the active border, the containing
// facet/frame/part will receive a kODEvtMouseDownBorder event.
// The message field of the event record contains the embedded facet.
//
// Similarly, if the user clicks in an embedded frame with the
// *frozen* or *selected* property set, a kODEvtMouseDownEmbedded
// event is directed to the containing frame.
//
// If the user shift-clicks or command-clicks in a frame which is
// embedded in the frame with the selection focus, then the latter
// frame gets a kODEvtMouseDownEmbedded event.  
//
// Cursor Tracking --
// OpenDoc tracks cursor movement (with the mouse button up), and
// calls MouseEnter() when the cursor first moves into a facet, and
// MouseLeave() when the cursor leaves the facet. A part can change
// the cursor on MouseEnter, and set it to the arrow on MouseLeave.
//
// This process is triggered by the shell calling
// ODDispatcher::GetMouseRegion() and passing the result to
// WaitNextEvent(). The region is only recomputed when necessary. 
// If the cursor is motionless within a facet, the shell application
// goes to sleep because OpenDoc computes a mouse region containing
// just the cursor location. The part can make this region larger
// by calling ODDispatcher::SetMouseRegion(). In a future release,
// OpenDoc will also compute a suitably large sleep region if the
// cursor is not within any facet.
//
// Modal Focus --
// Some events are constrained by the modal focus. For example a
// mouse click outside the frame with the modal focus will be sent
// to the modal focus frame, but a click in an embedded frame
// within the modal focus frame will go to the embedded frame. 
//
// Propagating Events --
// If a containing part sets the *DoesPropagateEvents* property of
// an embedded frame, the containing part will receive events not
// handled by the embedded frame. A part which does this will have
// to inspect the frame passed to HandleEvent() to determine if it
// is one of its display frames.

}

//------------------------------------------------------------------------------
// Novell_ButtonMyHandleMenuEvent
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK Novell_ButtonMyHandleMenuEvent(Novell_Button *somSelf, Environment* ev, 
								ODFrame* frame, ODEventData* event, ODFacet * facet)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);
	static ButtonCount = 0;

ODUnused(frame);

	if ( LOWORD (event->wParam) == 100 && (HIWORD(event->wParam) == BN_CLICKED || HIWORD(event->wParam) == BN_DOUBLECLICKED))
	{
		// add scripting code here!
/* //ram
		ODAddressDesc*	theAddressDesc;
		ODObjectSpec*	theObjSpec;
		int				done = 0;
		ODMessageInterface* msgInterface = _fSession->GetMessageInterface(ev);

		OrderedCollectionIterator cIter(_fDisplayFrames);
		if(frame->IsRoot(ev))
		{
			return kODTrue;
		}
		ODFrame* containingFrame = frame->GetContainingFrame(ev);
		while(!done)
		{
			ODPart* containingPart = containingFrame->GetPart(ev);
			msgInterface->CreatePartAddrDesc(ev, &theAddressDesc, containingPart);
			msgInterface->CreatePartObjSpec(ev, &theObjSpec, containingPart);
*/
/*			err = msgInterface->CreateEvent(kAECoreSuite,
								kAESetData,
								&theAddress,
								kAnyTransactionID,
								&theAppleEvent );

			err = AEPutParamDesc((const AERecord*)&theAppleEvent, keyDirectObject, (const AEDesc*)&theObjSpec);

			srand(GetTickCount());
			rgbColor = rand();					//red
			rgbColor |= rand() << 8;			//green
			rgbColor |= (long)rand() << 16;		//blue

#define typeRGBColor LONGCONST('c','R','G','B')

			err = AECreateDesc(typeRGBColor,
								(Ptr)&rgbColor,
								sizeof(XMPRGBColor),
								&rgbDesc);
			err = AEPutKeyDesc((const AERecord*)&theAppleEvent,
									keyAEData,
									(const AEDesc*)&rgbDesc);

			msgInterface->Send((XMPPart*)this,
								&theAppleEvent,
								&theReply,
								kAENoReply + kAENeverInteract,
								kAENormalPriority,
								TIMEOUT_ASYNC,
								NULL,
								NULL );

			AEDisposeDesc((AEDesc FAR *)&theAddress);
			AEDisposeDesc((AEDesc FAR *)&theAppleEvent);
			AEDisposeDesc((AEDesc FAR *)&rgbDesc);

			if(containingFrame->IsRoot())
			{
				done = 1;
			} else
			{
				containingFrame = containingFrame->GetContainingFrame();
*/
//ram		}  // while

		sndPlaySound ("ODButton", SND_ASYNC);
		ButtonCount++;
		if (ButtonCount >=25) {
		 	MessageBox (NULL,"You must be bored!","Button Humor",MB_OK);
			ButtonCount = 0;
		}
		// this code tries to make sure the button draws correctly.
		if (facet) {
			MyInfo *info = (MyInfo *)facet->GetPartInfo(ev);
			if (info) {
				if (info->ShadowWindow)	{
					HWND button = GetDlgItem(info->ShadowWindow, 100);
					if (IsWindow(button)) {
						InvalidateRect (button, NULL, TRUE);
					}
				}
			}
		}
	}
	else {

		switch(event->wParam) {

			case kODCommandAbout:
			{
				if (_fSession->GetArbitrator(ev)->RequestFocus(ev, _fModalFocus, frame))
				{
					MessageBox(kODNULL, "ButtonPart\nCopyright 1995 Novell, Inc.\nAll rights reserved.", 
								"About", MB_APPLMODAL | MB_OK);
					_fSession->GetArbitrator(ev)->RelinquishFocus(ev, _fModalFocus,frame);
				}
			}
			break;

			case kODCommandClear:
				break;

			case kODCommandViewAsWin:
				somSelf->Open(ev, frame);
				break;

			case kODCommandGetPartInfo:
			{
				ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
				_fSession->GetInfo(ev)->ShowPartFrameInfo(ev, facets->First(ev));
			}
				break;

			default:
				return kODFalse;
		}

	}		
	return kODTrue;
}

//------------------------------------------------------------------------------
// Novell_ButtonMyHandleMouseDown
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK Novell_ButtonMyHandleMouseDown(Novell_Button *somSelf, Environment* ev, 
								ODEventData* event, ODFrame* frame, ODFacet* facet)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODBoolean handled = kODFalse;
	
	if (facet == kODNULL)		// Did we get a click outside a modal dialog? ...
	{
		return kODTrue;			// Return that click was handled.
	}

	// Activate the window if it is not active...
	if (!facet->GetWindow(ev)->IsActive(ev))
	{
		facet->GetWindow(ev)->Select(ev);

#ifdef FIRST_CLICK_WINDOW_BEHAVIOR
		handled = kODTrue;
#else
		return kODTrue;
#endif
			// We argued way too much about which this should be.  The answer is that
			// some types of content need first click, and some absolutely don't.  Even
			// for 'TEXT', sometimes you want one, and sometimes you want the other.
			// It depends on your content, usage model, etc.
			//
			// If you are unsure about which you want, the default for ButtonPart
			// should be FIRST_CLICK_WINDOW_BEHAVIOR.  This probably means fewer clicks
			// for the user.  If this doesn't work for your part, of course change it.
	}

	// get the mouse in local coordinates
#ifndef WIN32
	POINT	event_where = MAKEPOINT(event->lParam);
#else
	POINT	event_where;
	LONG2POINT(event->lParam, event_where);
#endif
	ODWindow* odwnd = frame->GetWindow(ev);
	ODPoint odPoint(IntToFixed(event_where.x), IntToFixed(event_where.y));

	// Try to grab all of our foci...
	if ( _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame) )
	{
		somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
		somSelf->FocusAcquired(ev, _fMenuFocus, frame);
		somSelf->FocusAcquired(ev, _fKeyFocus, frame);
		
	} else {
		return kODFalse;	// We couldn't get focus.

		// Of course, you shouldn't fail if you really don't need the *all*
		// of the foci.  For example, a vector drawing part that also has
		// a text tool should probably go ahead and allow drawing while 
		// disabling the text tool.
	}

	// Handle clicks in used shape...
	odPoint = facet->GetWindowContentTransform(ev, kODNULL)->InvertPoint(ev, &odPoint);
	
	ODShape*  usedShape = somSelf->MyGetUsedShape(ev, frame);
	ODBoolean hit       = usedShape->ContainsPoint(ev, &odPoint);
	usedShape->Release(ev);
	
	if (hit)
		return somSelf->MyUsedShapeHandleMouseDown(ev, event, frame, facet);

	return handled;
}



//------------------------------------------------------------------------------
// Novell_ButtonMyUsedShapeHandleMouseDown
//------------------------------------------------------------------------------

SOM_Scope ODBoolean SOMLINK Novell_ButtonMyUsedShapeHandleMouseDown(Novell_Button *somSelf, Environment* ev, 
						ODEventData* event, ODFrame* frame, ODFacet* facet)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	// Get the window and platform window (i.e. WindowPtr)...
	ODWindow*			odwnd = frame->GetWindow(ev);
	ODPlatformWindow	facetWnd = odwnd->GetPlatformWindow(ev);

	// Get the mouse in window-local and facet-local coordinates...
#ifndef WIN32
	POINT	event_where = MAKEPOINT(event->lParam);
#else
	POINT	event_where;
	LONG2POINT(event->lParam, event_where);
#endif
	ODPoint windowPoint(IntToFixed(event_where.x), IntToFixed(event_where.y));
	ODPoint facetPoint = facet->GetWindowContentTransform(ev, kODNULL)->InvertPoint(ev, &windowPoint);

/*
	// Handle the click in whatever way is appropriate...
	{
		HDC	hDC;
		CFocus	foc(facet, kODNULL, &hDC);

		Rect		rct;
		Point		pltFrmPoint = facetPoint.AsWinPoint();
	
		int		prevDrawMode = SetROP2(hDC, R2_NOT);
		::SetRect(&rct, pltFrmPoint.x - 3, pltFrmPoint.y - 3, pltFrmPoint.x + 3, pltFrmPoint.y + 3);
		::Ellipse(hDC, rct.left, rct.top, rct.right, rct.bottom);
		SetROP2(hDC, prevDrawMode);
	}
*/	
	return kODTrue;		// We handled the click.
}

//==============================================================================
// Novell_ButtonHandleEventInEmbedded
//==============================================================================

SOM_Scope ODBoolean  SOMLINK Novell_ButtonHandleEventInEmbedded(Novell_Button *somSelf, Environment *ev,
		ODEventData* event,
		ODFrame* frame,
		ODFacet* facet,
		ODFrame* embeddedFrame,
		ODFacet* embeddedFacet)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(event);
ODUnused(frame);
ODUnused(facet);
ODUnused(embeddedFrame);
ODUnused(embeddedFacet);

	return kODFalse;
}

//==============================================================================
// Novell_ButtonMouseEnter
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonMouseEnter(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)

// Called when the mouse is moved over a display frame of this
// part (mouse button up).
//
// Called by the Dispatcher object.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(facet);
ODUnused(where);
}

//==============================================================================
// Novell_ButtonMouseWithin
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonMouseWithin(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet,
		ODPoint* where)

// Called when the mouse is moved within a display frame of this
// part (mouse button up).
//
// Called by the Dispatcher object.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(facet);
ODUnused(where);
}

//==============================================================================
// Novell_ButtonMouseLeave
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonMouseLeave(Novell_Button *somSelf, Environment *ev,
		ODFacet* facet)

// Called when the mouse is moved out of a display frame of this
// part (mouse button up).
//
// Called by the Dispatcher object.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(facet);
}

//==============================================================================
// Novell_ButtonAdjustMenus
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonAdjustMenus(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	Str63		aboutText;
	ODIText*	odiText;

ODUnused(frame);

	_fMenuBar->EnableCommand(ev, kODCommandViewAsWin, !frame->IsRoot(ev) );
	_fMenuBar->EnableCommand(ev, kODCommandGetPartInfo, kODTrue);

	lstrcpy(aboutText, "About Button...");

	odiText = CreateIText(kODRomanScript, kODEnglishLang, aboutText);
	_fMenuBar->SetItemString(ev, kODCommandAbout, odiText);
	DisposeIText(odiText);
}

//==============================================================================
// Novell_ButtonUndoAction
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonUndoAction(Novell_Button *somSelf, Environment *ev,
		ODActionData actionState)

// Tells the part to undo the action that is described by actionState.
//
// Called by the undo object.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(actionState);
}

//==============================================================================
// Novell_ButtonRedoAction
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonRedoAction(Novell_Button *somSelf, Environment *ev,
		ODActionData actionState)

// Tells the part to Redo the action described by actionState.
//
// Called by the undo object.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(actionState);
}

//==============================================================================
// Novell_ButtonDisposeActionState
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonDisposeActionState(Novell_Button *somSelf, Environment *ev,
		ODActionData actionState,
		ODDoneState doneState)

// Tells the part to dispose of the action data.
//
// Before calling this method, you must ensure that *actionState*
// is an action data block previously logged by this part. After
// calling this method successfully, memory for *actionState* has
// been reclaimed. It is no longer usable to perform undo operations.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(actionState);
ODUnused(doneState);
}

//==============================================================================
// Novell_ButtonWriteActionState
//==============================================================================

SOM_Scope void  SOMLINK Novell_ButtonWriteActionState(Novell_Button *somSelf, Environment *ev,
		ODPtr actionState,
		ODStorageUnitView* storageUnitView)

// Writes out the actionState data onto a StorageUnitView,
// and externalizes the undoAction data to the storage unit.
//
// Called by the undo object.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(actionState);
ODUnused(storageUnitView);
}

//==============================================================================
// Novell_ButtonReadActionState
//==============================================================================

SOM_Scope ODPtr  SOMLINK Novell_ButtonReadActionState(Novell_Button *somSelf, Environment *ev,
		ODStorageUnitView* storageUnitView)

// Internalizes the undoAction data from the storage unit.
//
// This method reads the actionState data from a view on a
// StorageUnit. It then allocates the memory and passes ownership
// of the storage to the caller.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

ODUnused(storageUnitView);

	return kODNULL;
}

//==============================================================================
// Novell_ButtonMyGetFrameShape
//==============================================================================

SOM_Scope ODShape* SOMLINK Novell_ButtonMyGetFrameShape(Novell_Button *somSelf, Environment* ev, ODFrame* frame)

// This is just to centralize the frame shape code.  Do it any way
// is best for your part.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODShape* newFrameShape;
	
	if (frame->IsRoot(ev))
		newFrameShape = frame->GetFrameShape(ev, kODNULL);
	else
		newFrameShape = somSelf->MyGetUsedShape(ev, frame);

	return newFrameShape;
}


//==============================================================================
// Novell_ButtonMyGetUsedShape
//==============================================================================

SOM_Scope ODShape* SOMLINK Novell_ButtonMyGetUsedShape(Novell_Button *somSelf, Environment* ev, ODFrame* frame)

// This is just to centralize the frame shape code.  Do it any way
// is best for your part.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODShape*	frameShape = frame->GetFrameShape(ev, kODNULL);
	RgnHandle	shapeRgn = frameShape->GetWinRegion(ev);
	frameShape->Release(ev);
	
	Rect		rr;
	GetRgnBox(shapeRgn, &rr);
	short		hh = (short)(rr.bottom - rr.top);
	short		ww = (short)(rr.right - rr.left);

	if (hh > ww)  hh = ww;
	if (hh < 200) hh = 200;

	shapeRgn = CreateRoundRectRgn(0, 0, hh, hh, 40, 40);	

	ODShape* usedShape = frame->CreateShape(ev);
	usedShape->SetWinRegion(ev, shapeRgn);

	return usedShape;
}


//==============================================================================
// Novell_ButtonMyAdjustFacets
//==============================================================================

SOM_Scope void SOMLINK Novell_ButtonMyAdjustFacets(Novell_Button *somSelf, Environment* ev, ODFrame* frame)

// Given a frame, iterate through all of the facets and adjust them
// according to the new frame.

{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	ODShape* usedShape  = somSelf->MyGetUsedShape(ev, frame);
	frame->ChangeUsedShape(ev, usedShape, kODNULL);
	usedShape->Release(ev);

	ODShape* frameShape = frame->GetFrameShape(ev, kODNULL);
	ODFrameFacetIterator* facets = frame->CreateFacetIterator(ev);
	for (ODFacet* facet = facets->First(ev);
			facets->IsNotComplete(ev);
			facet = facets->Next(ev) )
	{
		facet->ChangeActiveShape(ev, frameShape, kODNULL);
	}
	frameShape->Release(ev);
}


SOM_Scope void SOMLINK Novell_ButtonMyCreateShadowWindow (Novell_Button *somSelf, Environment *ev, ODFacet *facet)
{
	WNDCLASS  wc;
	MyInfo *info = (MyInfo *)facet->GetPartInfo(ev);
	info->ShadowWindow = kODNULL;
	info->IsParentShadowAware = FALSE;

    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);
	
	HWND hParent = facet->GetWindow(ev)->GetPlatformWindow(ev);

	if (!GetClassInfo((HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE), "BTNShadowWindow", &wc)) {
		wc.style	     = CS_DBLCLKS | CS_OWNDC | CS_PARENTDC;
		wc.lpfnWndProc   = ShadowWindowProc;			// exported static member of XMPShell
		wc.cbClsExtra    = 0;
		wc.cbWndExtra    = 4;
		wc.hInstance     = (HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE);
		wc.hIcon	        = NULL;
		wc.hCursor	     = LoadCursor(NULL,IDC_ARROW);
		wc.hbrBackground = NULL;
		wc.lpszMenuName  = NULL;
		wc.lpszClassName = "BTNShadowWindow";

		if (!RegisterClass (&wc) )
			return ;
	}

	info->ShadowWindow = CreateWindowEx (WS_EX_TRANSPARENT ,"BTNShadowWindow", "", WS_CHILD | WS_VISIBLE,
		0, 0, 0, 0, hParent, NULL, (HINSTANCE)GetWindowLong (hParent, GWL_HINSTANCE), NULL);

	if (info->ShadowWindow) {

		SetWindowLong (info->ShadowWindow, 0, (LONG)somSelf);

		ODFrame *containingFrame = facet->GetFrame(ev)->GetContainingFrame(ev);
		if (containingFrame) {
			ODPart *containingPart = containingFrame->GetPart(ev);
			if (containingPart->HasExtension (ev,"WindowsShadowWindow")) {

				ODPlatformWindow *shadowWindow =
					(ODPlatformWindow*)containingPart->GetExtension(ev,"WindowsShadowWindow");
				SetParent (	info->ShadowWindow, *shadowWindow);
				info->IsParentShadowAware = TRUE;
			}
		}

		HWND button = ::CreateWindowA ("button", "Push Me", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
			0, 0, 1, 1, info->ShadowWindow, (HMENU)100,
			(HANDLE)GetWindowLong (info->ShadowWindow, GWL_HINSTANCE), NULL);

// The following commented block was an atempt to get the button to clip but it didn't
// work.  But the good news is there are new api's in Win95 and WinNT 3.51 that do
// work ( I even tried them) but I didn't put them here yet because I don't think
// WinNT 3.51 is shipping and if it is not many people have it yet.  Look for controls
// that clip correctly soon!
/*
		if (IsWindow(button)) {

			DWORD sytlebits = 0;
			sytlebits = GetClassLong (button,GCL_STYLE);
			sytlebits |= CS_OWNDC;
			SetClassLong(button,GCL_STYLE,sytlebits);
			DestroyWindow(button);
			button = ::CreateWindowA ("button", "Push Me", WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
				0, 0, 1, 1, info->ShadowWindow, (HMENU)100,
				(HANDLE)GetWindowLong (info->ShadowWindow, GWL_HINSTANCE), NULL);
		}
*/
		somSelf->MySizeShadowWindow(ev,facet);

	}

}
SOM_Scope void SOMLINK Novell_ButtonMySizeShadowWindow (Novell_Button *somSelf, Environment *ev, ODFacet *facet)
{
	RECT rc;

    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);
	MyInfo *info = (MyInfo *)facet->GetPartInfo(ev);

	if (!info)
		return;

	if (!info->ShadowWindow)
		return;

	ODShape *ActiveShape = facet->GetActiveShape(ev, kODNULL);
	ODShape* tempShape = (ODShape*) ActiveShape->Copy(ev);
	ODReleaseObject (ev, ActiveShape);

	if (facet->GetWindow(ev)->GetPlatformWindow(ev) == GetParent(info->ShadowWindow)){
		ODTransform *wcTrans = facet->GetWindowContentTransform(ev, kODNULL);
		tempShape->Transform(ev, wcTrans);
		ODReleaseObject(ev, wcTrans);
	}
	else{
		ODTransform *xTrans = facet->GetExternalTransform(ev, kODNULL);
		ODTransform *newTrans = xTrans->Copy(ev);
		// Get the scale from the Root Facet
		ODTransform *scaleTrans = facet->GetWindow(ev)
									->GetRootFacet(ev)->GetExternalTransform(ev, kODNULL);
		newTrans = newTrans->PostCompose(ev, scaleTrans);
		tempShape->Transform(ev, newTrans);
		ODReleaseObject(ev, scaleTrans);
		ODReleaseObject(ev, xTrans);
		ODReleaseObject(ev, newTrans);
	}

	GetRgnBox (	tempShape->GetWinRegion(ev), &rc);
	MoveWindow (info->ShadowWindow, rc.left, rc.top,
		rc.right - rc.left, rc.bottom - rc.top, TRUE);


	HWND button = GetDlgItem(info->ShadowWindow, 100);
	if (IsWindow (button)) {
		GetClientRect (info->ShadowWindow, &rc);
		MoveWindow (button, 0, 0, rc.right, rc.bottom, TRUE);


		// there was a lot of code here that set the clipping rgn on
		// the shadowwindow to try and get the button to clip but the
		// code didn't work so I removed it.  NOTE: I have found a new
		// api that will allow clipping of controls but I haven't put
		// it in yet.  Look for it in the near future.
	}

	ODReleaseObject(ev, tempShape);



}

SOM_Scope void SOMLINK Novell_ButtonMyDeleteShadowWindow (Novell_Button *somSelf, Environment *ev, ODFacet *facet)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);
	MyInfo *info = (MyInfo *)facet->GetPartInfo(ev);

	if (!info)
		return;

	if (info->ShadowWindow) {

		if (IsWindow (GetDlgItem(info->ShadowWindow, 100))) {
			DestroyWindow(GetDlgItem(info->ShadowWindow, 100));
		}
		DestroyWindow(info->ShadowWindow);
		info->ShadowWindow = kODNULL;
	}

}



LRESULT CALLBACK ShadowWindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	ODEventData event;
	Novell_Button *part;
	OrderedCollection *frames;
	ODFrameFacetIterator* facets;
							
	switch (message) {

		case WM_NCHITTEST:
			return HTTRANSPARENT;
			break;

		case WM_COMMAND:
			{
			Environment *ev = somGetGlobalEnvironment();
			part = (Novell_Button*)GetWindowLong (hWnd, 0);
			frames = part->GetDisplayFrames(ev);
			facets = ((ODFrame*)frames->First())->CreateFacetIterator(ev);
			
			part->ActivateFrame(ev, (ODFrame *)frames->First()); 
			
			event.message = message;
			event.wParam = wParam;
			event.lParam = lParam;

			part->HandleEvent (ev, &event, (ODFrame *)frames->First(), facets->First(ev));
			delete facets;
			}
			break;
	}
	
	return (DefWindowProc(hWnd, message, wParam, lParam));
}


SOM_Scope OrderedCollection*  SOMLINK Novell_ButtonGetDisplayFrames(Novell_Button *somSelf, Environment *ev)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	return _fDisplayFrames;
}


SOM_Scope void  SOMLINK Novell_ButtonActivateFrame(Novell_Button *somSelf, Environment *ev,
		ODFrame* frame)
{
    Novell_ButtonData *somThis = Novell_ButtonGetData(somSelf);

	if (frame != kODNULL) {
		if (!_fHasFocus)
		{
			ODBoolean succeeded = kODFalse;
								
			succeeded = _fSession->GetArbitrator(ev)->RequestFocusSet(ev, _fFocusSet,frame);
					
			if (succeeded)
			{
				somSelf->FocusAcquired(ev, _fSelectionFocus, frame);
				somSelf->FocusAcquired(ev, _fMenuFocus, frame);
				somSelf->FocusAcquired(ev, _fKeyFocus, frame);
			}
		}
	}
}
