/*
	File:		PrintLib.cpp

	Contains:	Library routines for printing (setting up for drawing in print DC)

	Written by:	Brad Tolman

	Change History (most recent first):

		 <1>	1/15/95	BT		first checked in
*/


#ifndef _ALTPOINT_
#include "AltPoint.h"
#endif

//#ifndef _ALTPOLY_
//#include "AltPoly.h"
//#endif

#ifndef SOM_ODShape_xh
#include <Shape.xh>
#endif

#ifndef SOM_ODFrame_xh
#include <Frame.xh>
#endif

#ifndef SOM_ODFacet_xh
#include "Facet.xh"
#endif

#ifndef SOM_ODCanvas_xh
#include <Canvas.xh>
#endif

#ifndef SOM_ODSession_xh
#include <ODSessn.xh>
#endif

#ifndef SOM_ODTransform_xh
#include <Trnsform.xh>
#endif

#ifndef SOM_ODWindow_xh
#include "Window.xh"
#endif

#ifndef SOM_ODWindowState_xh
#include <WinStat.xh>
#endif

#ifndef _PRINTLIB_
#include "PrintLib.h"
#endif

CPrint::CPrint( ODFacet *facet)
{
	fFacet = facet ? facet: kODNULL;
	fPrintScale.x = fPrintScale.y = 0;
	fPageSize.top = fPageSize.left = 0;
	fPageSize.right = fPageSize.bottom = 0;
	fPrintingStarted = 0;						  		// null if printing has not started
	fDocInfo.cbSize = sizeof(DOCINFO);
	fDocInfo.lpszDocName = kODNULL;
	fDocInfo.lpszOutput  = kODNULL;
	memset(&fPrintRec, 0, sizeof(PRINTDLG));
	fPrintRec.lStructSize =  sizeof(PRINTDLG);
}

ODFacet* CPrint::CreatePrinterFacet(Environment *ev, ODFrame *rootFrame, ODSession *session)
{
	ODTransform* xtransform = rootFrame->CreateTransform(ev);
	
	ODShape* clipshape = rootFrame->CreateShape(ev);
	Rect	cRect = fPageSize;
//	InflateRect(&cRect, 1000, 1000);
	ODRect cliprect(cRect);
	clipshape->SetRectangle(ev, &cliprect);
	xtransform->ScaleBy(ev, &this->fPrintScale);

	ODCanvas* prCanvas = session->GetWindowState(ev)->CreateCanvas(ev, kODWindows,
										(ODPlatformCanvas)fPrintRec.hDC, kODFalse, kODFalse);
	ODFacet* prFacet = session->GetWindowState(ev)->
		CreateFacet(ev, rootFrame, clipshape, xtransform, prCanvas, prCanvas);


//bgn	prCanvas->SetPlatformPrintJob(ev, kODQuickDraw, (ODPlatformCanvas)fPrintRec);
//bt use a windows 'define' for printJob
//bt use SetPlatformCanvas

//bt not needed?	prFacet->SetCanvas(ev, prCanvas);	 
		
	clipshape->Release(ev); clipshape = kODNULL;
	xtransform->Release(ev); xtransform = kODNULL;

	rootFrame->FacetAdded(ev, prFacet);
	fFacet = prFacet;

	return prFacet;
}

void CPrint::DeletePrinterFacet(Environment *ev)
{
	ODCanvas* prCanvas = fFacet->GetCanvas(ev);
	
	fFacet->GetFrame(ev)->FacetRemoved(ev, fFacet);
	
	delete prCanvas;
	delete fFacet;
	fFacet = kODNULL;
}

HDC CPrint::GetPrinterDC()
{		
	static char szPrinter[80];
	char		*szDevice, *szDriver, *szOutput;
	
	::GetProfileString("windows", "device", ",,,", szPrinter, 80);

	if (NULL != (szDevice = strtok(szPrinter, ",")) &&
			NULL != (szDriver = strtok(NULL, ",")) &&
			NULL != (szOutput = strtok(NULL, ",")))
		return ::CreateDC(szDriver, szDevice, szOutput ,NULL);
	return 0;
}

void CPrint::SetDocName(char* docname)
{		
	fDocInfo.lpszDocName = docname;
}

void CPrint::SetDocName()
{
}


DWORD CPrint::GetPrintFlags()
{
	return fPrintRec.Flags;
}


void CPrint::SetPrintFlags(DWORD printFlags)
{
	 fPrintRec.Flags = printFlags;
}


LPPRINTDLG CPrint::GetPrintRecord()
{
	return &fPrintRec;
}


ODBoolean CPrint::HandlePageSetup()
{
  DWORD FlagSave = this->GetPrintFlags();
  LPPRINTDLG printRecPtr = this->GetPrintRecord();
  printRecPtr->Flags |= PD_PRINTSETUP;    /* Set option */
  if (::PrintDlg(printRecPtr)) {
			
  }
  this->SetPrintFlags(FlagSave);          /* Restore Flags */

  return kODTrue;
}

LPPRINTDLG CPrint::BeginPrinting(Environment *ev, ODFacet *facet)
{
	fPrintRec.hwndOwner = facet->GetWindow(ev)->GetPlatformWindow(ev);
	if (fFacet != facet)
		fFacet = facet;

	fPrintRec.nFromPage = fPrintRec.nMinPage = 1;
	fPrintRec.nToPage = 9999;
	fPrintRec.nMaxPage = 0xfffe;
	fPrintRec.Flags = PD_PAGENUMS;
	if (::PrintDlg((LPPRINTDLG)&fPrintRec))
		return &fPrintRec;
	else{
		//bt for testing error
		DWORD err = CommDlgExtendedError();
		return kODFalse;
	}
}


ODBoolean CPrint::StartPrintJob()
{
	int			nyLogPix, nxLogPix;
	fPrintingStarted = kODFalse;

	fPrintRec.hDC = this->GetPrinterDC();	

	::GetClipBox (fPrintRec.hDC, &fPageSize);
												
	nxLogPix = ::GetDeviceCaps(fPrintRec.hDC, LOGPIXELSX);
	nyLogPix = ::GetDeviceCaps(fPrintRec.hDC, LOGPIXELSY);

	POINT	fOldWinOrg;
	SIZE	fOldWinExtent;
	SIZE	fOldVPExtent;
	int		fOldMapMode = SetMapMode(fPrintRec.hDC, MM_ANISOTROPIC);

	SetWindowOrgEx(fPrintRec.hDC,0, 0, &fOldWinOrg);
	SetWindowExtEx(fPrintRec.hDC,72,72,&fOldWinExtent);
	SetViewportExtEx(fPrintRec.hDC,nxLogPix,nyLogPix,&fOldVPExtent); 


	fPageSize.right = (int)(((LONG)fPageSize.right * 72) / nxLogPix);
	fPageSize.bottom = (int)(((LONG)fPageSize.bottom * 72) / nyLogPix);

	fPrintScale.x = ((LONG)nxLogPix << 16) / 72;
	fPrintScale.y = ((LONG)nyLogPix << 16) / 72;

	if (::StartDoc (fPrintRec.hDC, &fDocInfo) != SP_ERROR)
		fPrintingStarted = (::StartPage (fPrintRec.hDC) > 0);
	
	return fPrintingStarted;
}


ODBoolean CPrint::NewPage()
{
	if (fPrintingStarted){
		::EndPage (fPrintRec.hDC);
		return (::StartPage (fPrintRec.hDC) > 0);
	}

	return kODFalse;
}


void CPrint::EndPrinting()
{

	if (fPrintingStarted){
		::EndPage (fPrintRec.hDC);
		::EndDoc (fPrintRec.hDC);
	}

	if (fPrintRec.hDC)
		::DeleteDC(fPrintRec.hDC);
}

