/*
	File:		FocusLib.cpp

	Contains:	Library routines for focusing (setting up for drawing into a facet)

	Written by:	Jens Alfke

	Ported to Windows: Lynn LeBaron

	Copyright:	 1993-94 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

		 <4>	 4/13/94	T		jpa: Stop including obsolete PolyIter.h.
									(1145831)
		 <3>	 4/13/94	SS		Fixes for Post
		 <2>	 2/17/94	JA		Include new AltPoly.h.
		 <4>	  2/2/94	JA		Made it work better with offscreen or
									PostScript canvases. Added PS clip stuff.
									Added CFocusWindow.
		 <3>	 12/7/93	NP		Changed references to qd.
		 <2>	11/30/93	JA		Rearranged #includes for new "frame"
									constant fix.
		 <1>	11/23/93	JA		first checked in
*/

#ifndef _ALTPOINT_
#include "AltPoint.h"
#endif

#ifndef _ALTPOLY_
#include "AltPoly.h"
#endif

#ifndef SOM_ODFacet_xh
#include "Facet.xh"
#endif

#ifndef SOM_ODShape_xh
#include "Shape.xh"
#endif

//BGN#ifndef SOM_Module_5codsom5cinterfac5ccplus5cmachinem5cPOLYGON_OpenDoc_Polygon_defined
//BGN#include "Polygon.xh"
//BGN#endif

#ifndef SOM_ODTransform_xh
#include "Trnsform.xh"
#endif

#ifndef SOM_ODCanvas_xh
#include "Canvas.xh"
#endif

#ifndef SOM_ODWindow_xh
#include "Window.xh"
#endif

#ifndef _ODUTILS_
#include "ODUtils.h"
#endif

#ifndef _ODUTILW_
#include "ODUtilW.h"
#endif

#ifndef _FOCUSLIB_
#include "FocusLib.h"
#endif

ODFixed fixedMul(ODFixed val1, ODFixed val2)
{
	ODFixed retVal;

	retVal = (((val1 >> 16) * (val2 >> 16)) << 16);
	retVal += ((val1 >> 16) * (val2 & 0xffff));
	retVal += ((val1 & 0xffff) * (val2 >> 16));
	retVal += (((val1 & 0xffff) * (val2 & 0xffff)) >> 16);
	return retVal;
}

CFocus::CFocus( ODFacet *facet, ODShape* invalShape, HDC *theHDC )
{
	Focus(facet, invalShape, kODFalse);
	*theHDC = fHDC;
}

CFocusWindow::CFocusWindow( ODFacet *facet, ODShape* invalShape, HDC *theHDC, HWND *theHWnd )
{
	Focus(facet, invalShape, kODTrue);
	*theHDC = fHDC;
	*theHWnd = fHWnd;
}

void
CFocus::Focus( ODFacet *facet, ODShape* invalShape, ODBoolean toWindow )
{
	// Remember toWindow
	fToWindow = toWindow;

	// Remember the facet
	fFacet 		= facet;
#ifndef WIN32
	fOldClip	= 0;
#endif
	fclipShape	= NULL;
	Environment *ev = somGetGlobalEnvironment();

	// Get the HDC
	if (toWindow) {
		fHWnd = facet->GetWindow(ev)->GetPlatformWindow(ev);
		fHDC = GetDC(fHWnd);
	} else {
		fHDC = facet->GetCanvas(ev)->GetPlatformCanvas(ev, kODWindows);
	}

//	fSaveDC = SaveDC(fHDC);

	// Find out if we're a Metafile DC
	ODBoolean isMetafileDC = (GetDeviceCaps(fHDC, TECHNOLOGY) == DT_METAFILE);

	// Our we Printing
	ODBoolean isPrinting = !(facet->GetCanvas(ev)->IsDynamic(ev));

	// Clip to it (don't clip if to a Window)
	//   Don't clip to Metafiles because it's basically useless
	// ??? Should we clip in the toWindow case or not (maybe another flag?)
	if (!toWindow && !isMetafileDC && !isPrinting) {
		fclipShape = new ODShape;
		if (fclipShape) {
			ODShape *aggshape = facet->GetAggregateClipShape(ev, kODNULL);
			fclipShape->CopyFrom(ev, aggshape);
			ODReleaseObject (ev, aggshape);
			fclipShape->Transform(ev, facet->GetFrameTransform(ev, kODNULL));
			if (invalShape) {
				fclipShape->Intersect(ev, invalShape);
			}
			HRGN clip = fclipShape->GetWinRegion(ev);
			if (clip) {
#ifndef WIN32
				/* !!! this only works with 16-bit windows */
				fOldClip = GetClipRegion(fHDC);
#endif
				SelectClipRgn(fHDC, clip);
			}
		}
	}

	// Transform
	ODPoint		scale, offset;
	ODTransform*	localToGlobal;

	if (toWindow) {
		localToGlobal = facet->GetWindowContentTransform(ev, kODNULL);
	} else {
		localToGlobal = facet->GetContentTransform(ev, kODNULL);
	}

	localToGlobal->GetPreScaleOffset(ev, &offset);
	localToGlobal->GetScale(ev, &scale);
	fOldMapMode = SetMapMode(fHDC, MM_ANISOTROPIC);
	SetWindowOrgEx(fHDC,-(offset.IntX()), -(offset.IntY()), &fOldWinOrg);

// !!! Fix this later so that we get as much accuracy as possible
	scale.x		 = fixedMul(scale.x,IntToFixed(1000));
	scale.y		 = fixedMul(scale.y,IntToFixed(1000));
	SetViewportExtEx(fHDC, scale.IntX(), scale.IntY(), &fOldVPExtent);
	SetWindowExtEx(fHDC, 1000, 1000, &fOldWinExtent);
//	fOldVPExtent = SetViewportExt(fHDC, scale.IntX(), scale.IntY());
//	fOldWinExtent = SetWindowExt(fHDC, 1000, 1000);
}

void
CFocus::Defocus( )
{
	// Restore any old state

	Environment *ev = somGetGlobalEnvironment();

	SetMapMode(fHDC, fOldMapMode);
	SetWindowOrgEx(fHDC, fOldWinOrg.x, fOldWinOrg.y, kODNULL);
	SetWindowExtEx(fHDC, fOldWinExtent.cx, fOldWinExtent.cy, kODNULL);
	SetViewportExtEx(fHDC, fOldVPExtent.cx, fOldVPExtent.cy, kODNULL);
#ifndef WIN32
	if (fOldClip)
		SelectClipRgn(fHDC,fOldClip);
#endif
	if(fclipShape)
		fclipShape->Release(ev);

//	RestoreDC(fHDC, fSaveDC);

	// Release the DC
	if (fToWindow) {
		ReleaseDC(fHWnd, fHDC);
	} else {
		fFacet->GetCanvas(ev)->ReleasePlatformCanvas(ev);
	}
}

