#!/bin/csh
# RE_SID: @(%)/usr/re/builds/pcnfs/unix/serial/SCCS/s.addslip.csh 1.5 93/11/04 16:58:48 SMI
#  @(#)addslip.csh	1.5	11/4/93
echo ""
echo "           -------------- addslip.csh -------------------"
echo  ""
echo "This is the PC-NFS 5.1 SLIP Gateway Installation Script"
echo "for SunOS 4.x running on all Sun systems."
echo ""
echo "This script is quite verbose, and will ask you a number of questions about"
echo "your current configuration and what you want to do. You may find it useful"
echo "to use the script(1) command to create a record of the installation process."
echo ""
echo "All questions will be simple yes/no choices. You should enter y or n exactly"
echo "as shown - Y, yes, etc. will not be recognized. The default reply is shown"
echo "in square brackets."
echo ""
echo -n "Are you ready to proceed (y or n [y]): "
set yorn = $<
if ( $yorn == n ) goto exitscript
echo  ""
echo "Retrieving the current configuration..."
echo ""
set curconf=`strings /vmunix | grep "SunOS Release" | sed -e "s/^.*(//" | sed -e "s/).*//"`
set syspath=/usr/sys
set arch=`arch`
#
# Check for new paths on Sun3 and Sun4 systems.
#
if ( $arch == sun3) then
	if ( -e $syspath/sun3x) then
		set arch=sun3x
	else if (! -e $syspath/sun3) then
		echo "This script installs to $syspath/sun3 or $syspath/sun3x. "
		echo "Neither sub-directory can be located. "
		echo "Refer to the documentation for suggestions. "
		exit (3)
	endif
else if ( $arch == sun4) then
		if ( -e $syspath/sun4c) then
			set arch=sun4c
		else if ( -e $syspath/sun4m) then
			set arch=sun4m
		else if (! -e $syspath/sun4) then
			echo "This script installs to $syspath/sun4, sun4c, or sun4m. "
			echo "Neither sub-directory can be located. "
			echo "Refer to the documentation for suggestions. "
			exit (3)
		endif
endif
set archpath = $syspath/$arch
set confpath = $archpath/conf
set localpath = /files/local/sun386
if( $#argv > 1 ) then
	echo "Usage: addslip.csh [<current-config>]"
	exit (1)
endif

if (  -e $syspath/sunif/if_sl.c ) then
	diff sunif/if_sl.c $syspath/sunif/if_sl.c >/dev/null
	echo "You have already installed some or all of a SLIP distribution kit. Do you"
	echo "want to remove this software? If you do this, you should then remove any"
	echo "SLIP kernel configurations and install a non-SLIP kernel if necessary."
	echo "(Please note: You do not need to do this if you simply want to upgrade to"
	echo "new SLIP software.)"
	diff sunif/if_sl.c $syspath/sunif/if_sl.c >/dev/null
	if ($status == 0) echo "(N.b. The existing SLIP software matches that in this distribution.)"
	echo ""
	echo -n "Do you want to remove SLIP (y or n [n]): "
	set yorn = $<
	if ( $yorn == y) then
		echo -n "Are you sure you want to remove SLIP (y or n [n]):"
		set yorn = $<
		if ( $yorn == y) then
			if ( -f $syspath/sun/str_conf.c.PRE-SLIP ) mv $syspath/sun/str_conf.c.PRE-SLIP $syspath/sun/str_conf.c
			if ( -f $confpath/files.PRE-SLIP ) mv $confpath/files.PRE-SLIP $confpath/files
			echo ""
			echo "Pre-SLIP files replaced."
			echo ""
		endif
		echo -n "Do you want to continue with the installation (y or n [n]): "
		set yorn = $<
		if ( $yorn != y ) goto exitscript
	else
		echo ""
		echo "Any existing SLIP sources have been left intact."
		echo ""
	endif
endif
if ( $#argv > 0 ) then
	if( $1 != $curconf ) then
		echo "You have specified that the SLIP configuration should be derived from"
		echo "the configuration file $1"
		echo "However, your system is currently running a Unix kernel which was built"
		echo "from the configuration file $curconf"
		echo ""
		echo -n "Do you want to use $curconf instead of $1 (y or n [n]): "
		set yorn = $<
		if ( "$yorn" != y ) set curconf = $1
		echo ""
		echo "The file $curconf will be used as the basis for this configuration."
		echo ""
	endif
endif
if ( $#argv == 0 ) then
	echo "You did not specify the name of a configuration file from which the SLIP"
	echo "configuration should be derived. Your system is currently running a Unix"
	echo "kernel which was built from the configuration file $curconf"
	echo "This configuration file will be used for this installation."
	echo ""
endif
set newconf=${curconf}-SL
if ( ! -f $confpath/$curconf ) then
	echo "addslip.csh cannot find a configuration file called"
	echo "		$confpath/$curconf"
	echo "Please recheck your input."
	goto abortscript
endif

fgrep -s sl8 $confpath/$curconf

if ( $status ) then
	set newconf=${curconf}-SL
	if ( -f $confpath/$newconf ) then
		echo "The script normally creates a new kernel configuration file by appending"
		echo "the string  -SL to the original name. However a file called $newconf"
		echo -n "already exists. Should I replace this file (y) or use it (n)? [n]: "
		set yorn = $<
		if ( "$yorn" == y ) rm 	$confpath/$newconf
	 	echo ""
	endif
else
	echo "The configuration file $curconf already includes SLIP configuration"
	echo "information. A new configuration file will not be built."
	echo ""
	set newconf=$curconf
endif

echo "Current configuration checks complete."
echo ""
echo "Before you can build a SLIP kernel, you must copy the SLIP sources into the"
echo "correct directories. Specifically, new copies of the following files must be"
echo "installed:"
echo "	$syspath/sunif/if_sl.c"
echo ""
echo "Backup copies of all files will be made. If you have already installed SLIP"
echo "you can skip this step. If you are upgrading to a new release of the SLIP"
echo "software, this step will replace the necessary files but will still allow"
echo "you to back out SLIP completely at a later time."
echo ""
echo -n "Do you want to copy the SLIP source files (y or n [y]): "
set yorn = $<
echo ""
if ( "$yorn" != n ) then
	echo "Backing up old source files..."
	if ( ! -e $syspath/sun/str_conf.c.PRE-SLIP ) cp $syspath/sun/str_conf.c $syspath/sun/str_conf.c.PRE-SLIP
	echo "Copying source files..."
	cp sunif/if_sl.c $syspath/sunif/if_sl.c
	echo ""
endif

echo "There are four utility programs used by SLIP. They are:"
echo "	sunslip	(handles dial-up SLIP connections)"
echo "	slattach	(handles hard-wired slip connections)"
echo "	mkslipuser	(sets up the dialup user database)"
echo "	dslipuser	(displays dial-up SLIP status)"

#### on sun386i ####
if ("$arch" == sun386) then
 echo "These are normally installed in /files/local/sun386/etc, with symbolic"
 echo "links to them in /etc."
 echo ""
 echo -n "Do you want to compile and install the SLIP utilities (y or n [y]): "
 set yorn = $<
 echo ""
 if ( "$yorn" == n ) goto skip

 if(! -w $localpath) goto promptuser
 if(! -e $localpath/etc) mkdir $localpath/etc
 if(! -w $localpath/etc) goto promptuser
 set lpath=$localpath/etc
 goto continue

promptuser:
	echo "Cannot load files into $localpath/etc"
	echo "Please enter a local directory where you would like"
	echo "the SLIP utilities installed: "
	echo ""
	set lpath = $<

#### on other machines ####
else
 echo "These are normally installed in /etc; if you choose to move them to a"
 echo "different location, you should make sure that there are symbolic links"
 echo "to them in /etc."
 echo ""
 echo -n "Do you want to compile and install the SLIP utilities (y or n [y]): "
 set yorn = $<
 echo ""
 if ( "$yorn" != y ) goto skip

 if(! -w /etc) then
	echo "Cannot load files into /etc"
       	echo "Please enter a local directory where you would like"
       	echo "the SLIP utilities installed: " 
       	echo ""  
       	set lpath = $<
 else
       	set lpath=/etc
 endif
endif
continue:
        pushd usr
        echo "Changing current directory to $cwd"
        echo "Removing any old copies of the utilities..."
	if ("$lpath" != /etc) then
	        make -i uninstall386 DESTDIR=$lpath
       		echo "Installing utilities..."
        	make install386 DESTDIR=$lpath
	else
		make -i uninstall DESTDIR=$lpath
		echo "Installing utilities..."
		make install DESTDIR=$lpath
	endif
		
        popd
        echo "Changing current directory back to $cwd"
        echo ""

skip:

fgrep -s if_sl $confpath/files >/dev/null

if ($status ) then
	echo "The file"
	echo "	$confpath/files"
	echo "contains a list of the source files to be used in configuring a new kernel."
	echo "This file must be edited to include an entry for the SLIP driver if_sl.c."
	echo "A backup copy will be made before it is edited. Note that if you do not"
	echo "edit this file, further SLIP installation is impossible."
	echo ""
	echo -n "Edit $confpath/files (y or n [y]): "
	set yorn = $<
	if ( "$yorn" == n ) goto abortscript
	echo ""
	echo "Backing up current file..."
	if ( ! -e $confpath/files.PRE-SLIP ) cp $confpath/files $confpath/files.PRE-SLIP
	echo "Editing..."
	chmod +w $confpath/files
	ed  - $confpath/files  <<EOFSTRING
/if_subr.c/i
sunif/if_sl.c		optional sl INET device-driver
.
w
q
EOFSTRING
	chmod -w $confpath/files
	echo "Edit complete."
	echo ""
endif

fgrep -s sl_info $syspath/sun/str_conf.c >/dev/null

if ($status ) then
	echo "The file"
	echo "	$syspath/sun/str_conf.c"
	echo "contains definitions of the STREAMS modules to be included in the kernel."
	echo "This file must be edited to include an entry for the SLIP driver if_sl.c."
	echo "A backup copy will be made before it is edited. Note that if you do not"
	echo "edit this file, further SLIP installation is impossible."
	echo ""
	echo -n "Edit $syspath/sun/str_conf.c (y or n [y]): "
	set yorn = $<
	if ( "$yorn" == n ) goto abortscript
	echo ""
	echo "Backing up current file..."
	if ( ! -e $syspath/sun/str_conf.c.PRE-SLIP ) cp $syspath/sun/str_conf.c $syspath/sun/str_conf.c.PRE-SLIP
	echo "Editing..."
	chmod +w $syspath/sun/str_conf.c
	ed  - $syspath/sun/str_conf.c  <<EOFSTRING
/kb\.h/i
#include "sl.h"
.
/pf_info/+1a
#if	NSL > 0
extern struct streamtab	sl_info;
#endif
.
/pf_info/+1a
#if	NSL > 0
	{ "sl",	&sl_info },
#endif
.
w
q
EOFSTRING
	chmod -w $syspath/sun/str_conf.c
	echo "Edit complete."
	echo ""
endif

if ( ! -e $confpath/$newconf ) then
	echo "The configuration file"
	echo "	$confpath/$newconf"
	echo -n "does not exist. Create it (y or n [y]): "
	set yorn = $<
	if ( $yorn == n ) goto abortscript
	cp $confpath/$curconf $confpath/$newconf 
	echo ""
endif

# There are now three possibilities: no SLIP config info;
# obsolete info, or good info

egrep -s '^pseudo-device.*sl.*init.*slattach' $confpath/$newconf

if ( $status ) then
	echo "The configuration file"
	echo "	$confpath/$newconf"

	echo "does not contain an entry for the SLIP pseudo-device (or, possibly, contains"
	echo "an entry which is not in the correct format). The file must be edited to"
	echo "add this information."
	echo -n "Edit $confpath/$newconf (y or n [y]): "
	set yorn = $<
	if ( $yorn == n ) goto abortscript
	echo ""
	echo "Editing..."
	chmod +w $confpath/$newconf
	ed - $confpath/$newconf << EOFSTRING >/dev/null
/pseudo-device.*sl/d
w
q
EOFSTRING
	ed - $confpath/$newconf << EOFSTRING >/dev/null
/pseudo-device.*loop/a
pseudo-device   sl8	init	slattach
.
w
q
EOFSTRING
	echo "Edit complete."
endif
echo ""

echo "The next step is to run the config utility. This will take the file"
echo "	$confpath/$newconf"
echo "and create a directory"
echo "	$archpath/$newconf"
echo "The new kernel will then be built by executing a 'make' in this directory."
echo ""
echo -n "Ready to configure and build the new Unix kernel (y or n [y]): "
set yorn = $<
if ( "$yorn" == n ) goto abortscript
echo ""
echo "Changing current directory to $confpath"
pushd $confpath
echo "Configuring kernel..."
config $newconf
cd ../$newconf
echo "Changing current directory to $cwd"
echo "Making new kernel..."
make
echo "Kernel build complete."
echo "Save your exisitng kernel and"
echo "Reboot your machine using the newly built kernel."
popd
echo "Changing current directory back to $cwd"

exitscript:
echo ""
echo "        ---------------- addslip.csh DONE -----------------"
exit(0)

abortscript:
echo ""
echo "       ---------------- addslip.csh FAILED -----------------"
exit(1)
