#! /bin/sh
# RE_SID: @(%)/usr/re/builds/pcnfs/unix/pcnfsd/SCCS/s.addpcnfs.sh 1.5 93/10/27 14:30:42 SMI
# Copyright (c) 1992 by Sun Microsystems, Inc.
# All Rights Reserved.
#
#  Sun considers its source code as an unpublished, proprietary
#  trade secret, and it is available only under strict license
#  provisions.  This copyright notice is placed here only to protect
#  Sun in the event the source is deemed a published work.  Dissassembly,
#  decompilation, or other means of reducing the object code to human
#  readable form is prohibited by the license agreement under which
#  this code is provided to the user or company in possession of this
#  copy.
#
#  RESTRICTED RIGHTS LEGEND: Use, duplication, or disclosure by the
#  Government is subject to restrictions as set forth in subparagraph
#  (c)(1)(ii) of the Rights in Technical Data and Computer Software
#  clause at DFARS 52.227-7013 and in similar clauses in the FAR and
#  NASA FAR Supplement.
#

# Shell script to install the PC-NFS Daemon for SunOS systems.

DOSERVER=pcnfsd.rpc
DOSCLIENT=pcnfsd.clt
SERVER=rpc.pcnfsd
CLIENT=clnt.pcnfsd
DEFAULT_DEST=/usr/etc

fatalerror ( )
{
	echo " " ; echo "*** FATAL ERROR: $@" 1>&2 ; exit 1
}

#########
# Put up startup information
#########
echo 
echo "       --------------------------------------"
echo 
echo "This script will install the PC-NFS Daemon which provides printing"
echo "and login support"
echo 
echo "You must be root to run this script."
echo 
echo -n "Are you ready to proceed (y or n [y]): "
read YORN
if [ "$YORN" = "n" ]
then
	echo "Exiting from install script."
	exit 0
fi

echo 
if [ `whoami` != root ]
then
	echo "You must be root to run this script."
	echo "Exiting from install script."
	exit 1
fi


#########
# Check for files
#########
if [ ! -f $DOSERVER ]
then
	fatalerror "The PC-NFS daemon $DOSERVER is missing."
fi

if [ ! -f $DOSCLIENT ]
then
	fatalerror "The PC-NFS daemon client test program $DOSCLIENT is missing."
fi

#########
# Ask for destination directory and create it.
#########
echo -n "Install pcnfsd software in: [$DEFAULT_DEST]: "
read DEST
if [ ! -f ${DEST:=$DEFAULT_DEST} ]
then
	echo "Creating $DEST"
	mkdir $DEST
fi

#########
# Copy files to $DEST
#########

echo "Installing PC-NFS daemon software in $DEST"
/bin/install -g staff -m 755 -o root $DOSERVER $DEST/$SERVER
/bin/install -g staff -m 755 -o root $DOSCLIENT $DEST/$CLIENT

CURDIR=`pwd`

#########
# Add to RC file?
#
# If the installer says yes, add the appropriate line to /etc/rc.local.
#########
echo 
echo "Do you wish to have the PC-NFS daemon $SERVER started automatically"
echo -n "when this system boots (y or n [y]): "
read YORN
if [ "$YORN" != "n" ]
then
	echo "Adding $SERVER to /etc/rc.local"
# Edit rc.local and add rpc.pcnfsd
	ed - /etc/rc.local << EOFSTRING  > /dev/null
a
#
# Start the PC-NFS Daemon 
#
if [ -f $DEST/$SERVER ]; then
	$DEST/$SERVER &		echo "PC-NFS Daemon"
fi
.
w
q
EOFSTRING
fi
echo

#########
# Installation done
#########
echo 
echo "Installation complete."
echo 
