#!/bin/sh
# RE_SID: @(%)/usr/re/builds/pcnfs/unix/SCCS/s.dorfcmsg.sh 1.7 94/02/07 12:03:20 SMI
#
#  @(#)dorfcmsg.sh	1.7	2/7/94
# dorfcmsg.sh
#
# This script will unpack the console messaging server/client sources.
# It does NOT make the server and client components.  This must be
# done manually.
# The console messaging client/server programs are based on the
# Message Send Protocol 2, described in RFC1312.
#
# To use this script you must first have copied the following files 
# from the PC-NFS distribution diskette:
#		dorfcmsg.sh   ( this file )
#		rfcmsg.taz    ( compressed tar file )
# to some place on the system you are going to perform the install.  
# Usually /usr/tmp is a good place.  This script does not take any 
# arguments.
#

RFCMSG=rfcmsg

fatalerror ( )   # handle fatal errors
{
    echo " " ; echo "*** FATAL ERROR: $@" 1>&2 ; exit 1
}

if [ $# != 0 ]
then
	fatalerror "   Usage: dorfcmsg"
fi

echo " "
echo "Unpack MSGSERV shell script"
echo " "

if [ ! -f $RFCMSG.taz ]
then
    fatalerror "The compressed tar file $RFCMSG.taz is missing." 
fi

echo " "
echo "Uncompressing the $RFCMSG.taz file..."
mv -f $RFCMSG.taz $RFCMSG.tar.Z
uncompress -v $RFCMSG.tar.Z
if [ $? != 0 ] ; then
	fatalerror "Uncompressing $RFCMSG.taz failed."
fi

echo " "
echo "Unpacking the $RFCMSG.tar file..."
tar -xvf $RFCMSG.tar
if [ $? != 0 ] ; then
	fatalerror "Extracting files from $RFCMSG.tar failed."
fi

echo " "
echo "Unpack RFCMSG script completed."
echo " "
echo "You can build the server and client components by running"
echo "the makefiles provided."
echo "Pre-compiled versions of the server and client programs"
echo "are included in this distribution in the OS specific directories."
echo " "
echo "The Console Messaging server and client programs are based"
echo "on the Message Send Protocol 2 which is described in RFC1312."
echo " "
echo "Refer to the PC-NFS Installation and Configuration Guide for details."
echo " "
echo " "


