#!/bin/sh
# RE_SID: @(%)/usr/re/builds/pcnfs/unix/SCCS/s.dopcnfsd.sh 1.6 94/02/07 12:03:13 SMI
#
#  @(#)dopcnfsd.sh	1.6	2/7/94
# dopcnfsd.sh
#
# This script will unpack the pcnfsd version 2 sources, including a client
# test program. It does NOT make or install any of the individual components. 
# This must be done manually. Refer to the section on Installing PCNFSD in 
# the PC-NFS Installation and Configuration Guide for more information.
#
# To use this script you must first have copied the following files from the
# PC-NFS distribution diskette:
#		dopcnfsd.sh   ( this file )
#		pcnfsd.taz    ( compressed tar file )
# to some place on the system you are going to perform the install.  Usually
# Usually /usr/tmp is a good place.  This script does not take any 
# arguments.
#

PCNFSD=pcnfsd

fatalerror ( )   # handle fatal errors
{
    echo " " ; echo "*** FATAL ERROR: $@" 1>&2 ; exit 1
}

if [ $# != 0 ]
then
	fatalerror "   Usage: dopcnfsd"
fi

echo " "
echo "Unpack PCNFSD shell script"
echo " "

if [ ! -f $PCNFSD.taz ]
then
    fatalerror "The compressed tar file $PCNFSD.taz is missing." 
fi

echo " "
echo "Uncompressing the $PCNFSD.taz file..."
mv -f $PCNFSD.taz $PCNFSD.tar.Z
uncompress -v $PCNFSD.tar.Z
if [ $? != 0 ] ; then
	fatalerror "Uncompressing $PCNFSD.taz failed."
fi

echo " "
echo "Unpacking the $PCNFSD.tar file..."
tar -xvf $PCNFSD.tar
if [ $? != 0 ] ; then
	fatalerror "Extracting files from $PCNFSD.tar failed."
fi

echo " "
echo "Unpack PCNFSD script completed."
echo " "
echo "You can build the daemon and test programs by running"
echo "the makefile provided."
echo "Pre-compiled versions of the daemon and test program"
echo "are included in this distribution in the OS specific directories."
echo " "
echo "Refer to the PC-NFS Installation and Configuration Guide for details."
echo " "
echo " "


