/* Copyright (C) 1995 Charles Sandmann (sandmann@clio.rice.edu)
   This software may be freely distributed with above copyright, no warranty.

   Interface between DJGPP V2 emulator and Bill's most excellent but
   unfortunately GPL code (should be more freely distributable).  */

#include <setjmp.h>
#include <fpu_syst.h>

extern void math_emulate (void);

extern jmp_buf __djgpp_exception_state;

union i387_union I387;

struct info FPU__info = {0, 0};

struct task_struct _current = {0, 0};

static unsigned long signal;

int send_sig (unsigned long sig, struct task_struct *p, int priv)
{
  signal = sig;
  return 0;
}

int printk (const char *f,...)
{
#ifdef PRINTOK
  char buf[1000];
  vsprintf (buf, f, (&f) + 1);
  return write (2, buf, strlen (buf));
#endif
}

volatile void panic (const char *str)
{
  printk (str);
  signal = 1;
}

int _emu_entry(jmp_buf _exception_state)
{
  FPU__info.___eax = _exception_state->__eax;
  FPU__info.___ebx = _exception_state->__ebx;
  FPU__info.___ecx = _exception_state->__ecx;
  FPU__info.___edx = _exception_state->__edx;
  FPU__info.___esi = _exception_state->__esi;
  FPU__info.___edi = _exception_state->__edi;
  FPU__info.___ebp = _exception_state->__ebp;
  FPU__info.___esp = _exception_state->__esp;
  FPU__info.___eip = _exception_state->__eip;
  signal = 0;
  math_emulate();
  if(signal)
    return 1;
  _exception_state->__eip = FPU__info.___eip;
  _exception_state->__eax = FPU__info.___eax;
  return 0;
}
