//***************************** Module Header ******************************
// Module Name: sqlsniff.h
//
// SQLSNIFF's header file
//
// Author PeterWil 1994, Microsoft Ltd.
//***************************************************************************

//
// Resource defines
//
#define WINDOWMENU  1
#define MAXSVR      30
#define MAXUSR      30
#define MAXPWD      30
#define MAXRKEY     30
#define MAXAPPNAME  32
#define MAXFILENAME 256

#ifdef RC_INVOKED
#define ID(id) id
#else
#define ID(id) MAKEINTRESOURCE(id)
#endif

#define IDI_SLEEP       101
#define IDI_OPEN        102
#define IDI_IN          103
#define IDI_OUT         104
#define IDI_WAITING     105
#define IDI_RPC         106

//
// Menu ID's
//
#define IDM_INIT_ODS    21
#define IDM_ABOUT       22
#define IDM_EXIT        23

#define IDM_AUTOSCROLL  30
#define IDM_AUTOTILE    31
#define IDM_STARTMIN    32

#define IDM_CASCADE     60
#define IDM_TILE        61
#define IDM_ARRANGE     62

#define IDM_ACTIVE_ICON     40
#define IDM_INACTIVE_ICON   41
#define IDM_IN_ICON         42
#define IDM_OUT_ICON        43
#define IDM_RPC_ICON        44
#define IDM_INIT_MDI        45

#define IDM_PAUSE_SERVER    80
#define IDM_RESTART_SERVER  81
#define IDM_LOG_QUERIES     82
#define IDM_LOG_ALL         83

typedef struct _LogInfo
{
    BOOL MDI_Queries;
    BOOL MDI_All;
    BOOL File_Queries;
    BOOL File_All;
} LOG;

// Log buffer size
// Not to worried about size as it is very transient
#define LOG_BUF_SIZE    4096

// Define some message codes.
//
#define SRV_MAXERROR    20000
#define RPC_UNKNOWN     SRV_MAXERROR + 1
#define COMPUTE_ROW     SRV_MAXERROR + 2
#define REMOTE_MSG      SRV_MAXERROR + 3
#define SEND_FAILED     SRV_MAXERROR + 4
#define BULK_CMD        "insert bulk"
// Could make this user configurable
#define MAX_ROWS    512

// Declare the structure to use for our private data area.
// It will be passed to the event handlers in the SRV_PROC structure.
// Used for RPC only
#define MAXPARAMS   255

// The following error value must be sent back to the client in the event
// of a failure to login to the target database.  It is used in the
// init_remote() function below.
#define REMOTE_FAIL 4002

// Structure to hold the information an MDI window needs
typedef struct _ClientInfo
{
    HWND       hwnd;
    int        iCurrentRow;
    // This buffer holds the pointers to the data rows for the connection.
    // Although a ring buffer would be better in terms of always keeping the 
    // the maximum history. This way has a couple of advantages :
    // - We get to clear out the data in large chunks making us only scroll the window 
    //   once. In a ring buffer if the user was looking at the first row then we would
    //   need to scroll the window every time we added a new row (and hence deleted an 
    //   old one). This means that when we switch off Autoscrolling to save processor
    //   time we will still end up scrolling.
    //   (If we didn't scroll then we coudn't repaint the screen in responce to a
    //   WM_PAINT message)
    // - With the routine that adds rows in a different thread to the routine that
    //   draws the rows we'd have to implement critical sections around the linked 
    //   list. 
    //   With only one thread drawing all the windows then this could slow things down.
    // - It's much easier and quicker to draw the rows.
    char      *pszRow[MAX_ROWS];
    HICON      hAppIcon;  
    COLORREF   color[MAX_ROWS];
    int
               cxClient,
               cyClient,
               iMaxVScrollPos,
               iMaxHScrollPos,
               iMaxHorRow, 
               iVScrollPos,
               iHScrollPos,
               iDisplayedRows,
               iDisplayedHRows,
               cyChar,
               cxChar,
               cxCaps,
               iIconType;
    RECT       ExtraRect;
} CLIENTINFO, *PCLIENTINFO;

typedef struct remote_dbms
{
    LOGINREC   *login;
    DBPROCESS  *dbproc;
    BOOL        bulk_mode;
    int         retparams[MAXPARAMS];
    HANDLE      hQueryInfo; // MDI client info
    HANDLE      hAllInfo;   // MDI client info
} REMOTE_DBMS;

// the colours used to display info on the screen
#define  colorRed   (COLORREF)0x000000FF
#define  colorBlue  (COLORREF)0x00FF0000
#define  colorGreen (COLORREF)0x0000FF00
#define  colorBlack (COLORREF)0x00000000

// a few simple message boxes
#define MSGBOX(a) MessageBox(NULL,a,"SQLSNIFF Message",MB_OK | MB_ICONINFORMATION)
#define ERRBOX(a) MessageBox(NULL,a,"SQLSNIFF Error",MB_OK | MB_ICONSTOP)
