//****************************** Function Header ******************************
//
// Function : RPCExecute
//
// Description: Send RPC to SQL Server
//
// Author PeterWil 1994, Microsoft Ltd.
//*****************************************************************************
#define DBNTWIN32

// standard compiler/sql server supplied header files
#include    <windows.h>
#include    <sqlfront.h>
#include    <sqldb.h>
#include    <srv.h>
#include    <stdio.h>

// Application specific header files
#include    "sqlsniff.h"
#include    "rpcexec.h"
#include    "hresults.h"
#include    "rowstuff.h"
#include    "sniffcbs.h"

extern LOG Log;

#pragma check_stack( off )  // turn off stack checking

int RPCExecute(SRV_PROC  *srvproc)
{
    DBPROCESS  *rmtproc;
    REMOTE_DBMS  *rmt_dbms;
    int iParamCount;
    int len = 0;
    int params;
    int retparam;
    int  (*paramarray)[MAXPARAMS];
    int iOldIconType;
    char szScreen[LOG_BUF_SIZE];
    char szValue[LOG_BUF_SIZE];
    RETCODE ret;
    DBINT param1 = 1;
    DBCHAR * paramname;
    char log_buffer[LOG_BUF_SIZE];
    SRV_SERVER  *server;

    // Get the remote dbms pointer we saved in the srvproc via
    // srv_setuserdata.
    rmt_dbms = (REMOTE_DBMS *)srv_getuserdata(srvproc);
    // Set up the icon for RPC
    if (Log.MDI_All)     iOldIconType = ChangeIcon(rmt_dbms->hAllInfo  , IDM_RPC_ICON);
    if (Log.MDI_Queries) iOldIconType = ChangeIcon(rmt_dbms->hQueryInfo, IDM_RPC_ICON);

    // get the dbproc and the number of parameters
    rmtproc = ((REMOTE_DBMS *)srv_getuserdata(srvproc))->dbproc;
    paramarray = (int (*)[MAXPARAMS])&(((REMOTE_DBMS *)srv_getuserdata(srvproc))->retparams);

    // Get the RPC name and initialize the RPC to the remote DBMS.
    dbrpcinit(rmtproc, srv_rpcname(srvproc, (int *)NULL),
        (DBUSMALLINT)srv_rpcoptions(srvproc));

    // display it on the screen
    if (Log.MDI_All || Log.MDI_Queries || Log.File_Queries || Log.File_All)
        sprintf(szScreen,"dbrpcinit(RPCName=%s, Options=%d)",
            srv_rpcname(srvproc, (int *)NULL),
            (int)srv_rpcoptions(srvproc) );

    if (Log.MDI_All)
        {
        AddRow(rmt_dbms->hAllInfo," ",colorBlue);
        AddRow(rmt_dbms->hAllInfo," RPC",colorBlue);
        AddRow(rmt_dbms->hAllInfo,szScreen,colorBlack);
        }

    if (Log.MDI_Queries)
        {
        AddRow(rmt_dbms->hQueryInfo," ",colorBlue);
        AddRow(rmt_dbms->hQueryInfo," RPC",colorBlue);
        AddRow(rmt_dbms->hQueryInfo,szScreen,colorBlack);
        }

    // Update the log if necessary
    if (Log.File_Queries || Log.File_All)
    {
        server = SRV_GETSERVER(srvproc);
        sprintf(
            log_buffer,
            "==>   RPC: Client Id: %s - %s",
            srv_pfield(srvproc, SRV_SPID, (int *)NULL),
            szScreen );
        srv_log(server, TRUE, log_buffer, SRV_NULLTERM);
    }

    // Set up any RPC parameters.
    params = srv_rpcparams(srvproc);
    retparam = 1;


    for (iParamCount = 1; iParamCount <= params; iParamCount++)
    {
        paramname = srv_paramname(srvproc, iParamCount, &len);

        // screen and log display
        if (Log.MDI_All || Log.MDI_Queries || Log.File_Queries || Log.File_All)
        {              
            // Find the value
            if (srv_paramlen(srvproc, iParamCount) == 0)
                strcpy(szValue,"");
            else
                srv_convert(
                    srvproc,
                    srv_paramtype(srvproc, iParamCount),
                    srv_paramdata(srvproc, iParamCount),
                    srv_paramlen(srvproc, iParamCount),
                    SQLCHAR,
                    szValue,
                    -1);

            // Build the string
            sprintf(szScreen,
                "dbrpcparam Paramname=%s,status=%d, type=%s, maxlen=%d, datalen=%d, value=%s",
                srv_paramname(srvproc, iParamCount, (int *)NULL) ,
                srv_paramstatus(srvproc, iParamCount),
                srv_symbol(SRV_DATATYPE,srv_paramtype(srvproc, iParamCount),(int)NULL),
                srv_parammaxlen(srvproc, iParamCount),
                srv_paramlen(srvproc, iParamCount), 
                szValue );
        }

        // screen
    if (Log.MDI_All)
        {
        AddRow(rmt_dbms->hAllInfo,szScreen,colorBlack);
        }

    if (Log.MDI_Queries)
        {
        AddRow(rmt_dbms->hQueryInfo,szScreen,colorBlack);
        }

        // log file
        if (Log.File_Queries || Log.File_All)
        {
            server = SRV_GETSERVER(srvproc);
            sprintf(
                log_buffer,
                "RPC Param: Client Id: %s - %s",
                srv_pfield(srvproc, SRV_SPID, (int *)NULL),
                szScreen );
            srv_log(server, TRUE, log_buffer, SRV_NULLTERM);
        }

        // Send the parameter to SQL Server
        // Earlier on we used srv_paramname to get the name of the parameter.
        // If no name is specified then it returns a pointer to a NULL string.
        // If there is no parameter name then dbrpcparam requires a NULL pointer
        // NOT a pointer to a NULL string. Therefore if name of  length 0 then 
        // we make it a NULL pointer.
        if (len == 0) paramname = NULL;
        ret = dbrpcparam(
            rmtproc,
            paramname,
            (BYTE)srv_paramstatus(srvproc, iParamCount),
            srv_paramtype(srvproc, iParamCount),
            srv_parammaxlen(srvproc, iParamCount),
            srv_paramlen(srvproc, iParamCount),
            srv_paramdata(srvproc, iParamCount));
        
        // The current rpc may have three parameters, but only the
        // first and third are return parameters.  This means that
        // dbnumrets() returns two parameters, not three.  The first
        // call to dbretdata() referes to the rpc's first parameter,
        // and the second call to dbretdata() refers to the rpc's
        // third parameter.  To handle this, we map each return
        // parameter to its original parameter so we can later
        // reset the return value of the correct return parameters
        // in "HandleResults()".
        if ((BYTE)srv_paramstatus(srvproc, iParamCount) & SRV_PARAMRETURN)
        {
            (*paramarray)[retparam] = iParamCount;
            retparam++;
        }
    }

    // Send the RPC to the remote DBMS.
    dbrpcsend(rmtproc);

    // use the waiting icon
    if (Log.MDI_All)     ChangeIcon(rmt_dbms->hAllInfo  , IDM_ACTIVE_ICON);
    if (Log.MDI_Queries) ChangeIcon(rmt_dbms->hQueryInfo, IDM_ACTIVE_ICON);

    // wait for the server to finish
    dbsqlok(rmtproc);

    // Now get the remote DBMS results and pass them back to
    // Open Server client.
    HandleResults(rmtproc, srvproc);

    // use the original icon
    if (Log.MDI_All)     ChangeIcon(rmt_dbms->hAllInfo  , iOldIconType);
    if (Log.MDI_Queries) ChangeIcon(rmt_dbms->hQueryInfo, iOldIconType);

    return(SRV_CONTINUE);
}                              

#pragma check_stack()   // set stack checking to its default setting

