//****************************** Function Header ******************************
//
// Function : LangExecute
//
// Description: Calculates time between query batches
//
// Author PeterWil 1994, Microsoft Ltd.
//*****************************************************************************
#define DBNTWIN32

// standard compiler/sql server supplied header files
#include    <windows.h>
#include    <sqlfront.h>
#include    <sqldb.h>
#include    <srv.h>
#include    <stdio.h>

// Application specific header files
#include    "sqlsniff.h"
#include    "langexec.h"
#include    "hresults.h"
#include    "rowstuff.h"
#include    "mngeserv.h"
#include    "sniffcbs.h"

extern LOG Log;
extern HMENU hMenu;

#pragma check_stack( off )  // turn off stack checking

int LangExecute(SRV_PROC  *srvproc)
{
    REMOTE_DBMS *rmt_dbms;
    DBPROCESS   *rmtproc;
    DBCHAR      *query;
    long        query_len;
    int         status, iOldIconType;
    char        log_buffer[LOG_BUF_SIZE];
    SRV_SERVER  *server;

    // Get the remote dbms pointer we saved in the srvproc via
    // srv_setuserdata.
    rmt_dbms = (REMOTE_DBMS *)srv_getuserdata(srvproc);

    // store the old icon message, then use the in icon
    if (Log.MDI_All)     iOldIconType = ChangeIcon(rmt_dbms->hAllInfo,   IDM_IN_ICON);
    if (Log.MDI_Queries) iOldIconType = ChangeIcon(rmt_dbms->hQueryInfo, IDM_IN_ICON);

    // Get the pointer to the remote DBPROCESS
    rmtproc = rmt_dbms->dbproc;

    // Get the pointer to the client language request command buffer.
    query = srv_langptr(srvproc);

    // Check for SQLSNIFF shutdown by request
    if ( strcmp( srv_pfield(srvproc,SRV_USER,NULL),"sa") == 0 )
    {
        // SHUTDOWN
        if ( strcmp( query,"shutdown sqlsniff") == 0 ) 
        {
            // Switch off the menu options
            ModifyMenu(hMenu,IDM_INIT_ODS          ,MF_GRAYED,IDM_INIT_ODS,
                (LPSTR)"THE GATEWAY IS CURRENTLY IN THE PROCESS OF SHUTING DOWN");
            ModifyMenu(hMenu,IDM_PAUSE_SERVER  ,MF_GRAYED,IDM_PAUSE_SERVER,
             (LPSTR)"&Pause the gateway (No new connections)");
            ModifyMenu(hMenu,IDM_RESTART_SERVER,MF_GRAYED,IDM_RESTART_SERVER,
                (LPSTR)"&Restart the gateway (Allow new connections)");
            // use the original icon
            if (Log.MDI_All)     ChangeIcon(rmt_dbms->hAllInfo,   iOldIconType);
            if (Log.MDI_Queries) ChangeIcon(rmt_dbms->hQueryInfo, iOldIconType);
            srv_sendmsg(srvproc,
                SRV_MSG_ERROR,
                (DBINT)REMOTE_MSG,
                (DBTINYINT)0,
                (DBTINYINT)0,
                NULL,
                0,
                0,
                "SQLSNIFF is Shutting down by your request and your connection has been disconnected",
                SRV_NULLTERM);
            // Tell the client we have finished processing
            srv_senddone(srvproc, SRV_DONE_FINAL, (DBUSMALLINT)0, 0);
            srv_event(srvproc,SRV_STOP,NULL);
            return (SRV_DISCONNECT);
        }

        // PAUSE
        if ( strcmp( query,"pause sqlsniff") == 0 ) 
        {
            // Switch off the menu options
            ModifyMenu(hMenu,IDM_INIT_ODS      ,MF_GRAYED ,IDM_INIT_ODS,
                (LPSTR)"&Start the gateway");
            ModifyMenu(hMenu,IDM_PAUSE_SERVER  ,MF_GRAYED ,IDM_PAUSE_SERVER,
                (LPSTR)"&Pause the gateway (No new connections)");
            ModifyMenu(hMenu,IDM_RESTART_SERVER,MF_ENABLED,IDM_RESTART_SERVER,
                (LPSTR)"&Restart the gateway (Allow new connections)");
            // use the original icon
            if (Log.MDI_All)     ChangeIcon(rmt_dbms->hAllInfo,   iOldIconType);
            if (Log.MDI_Queries) ChangeIcon(rmt_dbms->hQueryInfo, iOldIconType);
            srv_sendmsg(srvproc,
                SRV_MSG_ERROR,
                (DBINT)REMOTE_MSG,
                (DBTINYINT)0,
                (DBTINYINT)0,
                NULL,
                0,
                0,
                "SQLSNIFF has been paused",
                SRV_NULLTERM);
            // Tell the client we have finished processing
            srv_senddone(srvproc, SRV_DONE_FINAL, (DBUSMALLINT)0, 0);
            ServerSleep(NULL);
            return (SRV_CONTINUE);
        }

        // RESTART
        if ( strcmp( query,"restart sqlsniff") == 0 ) 
        {
            // Switch off the menu options
            ModifyMenu(hMenu,IDM_INIT_ODS      ,MF_GRAYED ,IDM_INIT_ODS,
                (LPSTR)"&Start the gateway");
            ModifyMenu(hMenu,IDM_PAUSE_SERVER  ,MF_ENABLED,IDM_PAUSE_SERVER,
                (LPSTR)"&Pause the gateway (No new connections)");
            ModifyMenu(hMenu,IDM_RESTART_SERVER,MF_GRAYED ,IDM_RESTART_SERVER,
                (LPSTR)"&Restart the gateway (Allow new connections)");
            // use the original icon
            if (Log.MDI_All)     ChangeIcon(rmt_dbms->hAllInfo,   iOldIconType);
            if (Log.MDI_Queries) ChangeIcon(rmt_dbms->hQueryInfo, iOldIconType);
            srv_sendmsg(srvproc,
                SRV_MSG_ERROR,
                (DBINT)REMOTE_MSG,
                (DBTINYINT)0,
                (DBTINYINT)0,
                NULL,
                0,
                0,
                "SQLSNIFF has been restarted",
                SRV_NULLTERM);
            // Tell the client we have finished processing
            srv_senddone(srvproc, SRV_DONE_FINAL, (DBUSMALLINT)0, 0);
            ServerRestart(NULL);
            return (SRV_CONTINUE);
        }
    }

    // Log info
    if (Log.MDI_Queries)
    {
        AddRow(rmt_dbms->hQueryInfo, " ", colorBlue);
        AddRow(rmt_dbms->hQueryInfo, " Query: ", colorBlue);
        AddRow(rmt_dbms->hQueryInfo, query, colorBlack);
    }

    if (Log.MDI_All)
    {
        AddRow(rmt_dbms->hAllInfo, " ", colorBlue);
        AddRow(rmt_dbms->hAllInfo, " Query: ", colorBlue);
        AddRow(rmt_dbms->hAllInfo, query, colorBlack);
    }

    if (Log.File_Queries || Log.File_All)
    {
        sprintf(log_buffer, "==> Query: Client Id: %s",
            srv_pfield(srvproc, SRV_SPID, (int *)NULL));
        server = SRV_GETSERVER(srvproc);
        srv_log(server, TRUE, log_buffer, SRV_NULLTERM);
        srv_log(server, TRUE, query, SRV_NULLTERM);
    }

    // See if the previous command was a "bulk insert" command
    if (rmt_dbms->bulk_mode)
    {
        // Get length of the SQL command.
        query_len = srv_langlen(srvproc);

        // If length of data is zero, then send a zero length buffer
        // to the destination SQL Server.  This is required in order to
        // signal the SQL Server that no more data follows.
        if (query_len == -1L)
            query_len = 0L;

        // Place buffer into target SQL server's buffer.  Since
        // the buffer is binary data from the client, we need some
        // method of sending it to the target SQL Server.   We will use
        // dbbcmd(), an undocumented DBLIB API that is used for sending
        // binary data.
        status = dbfcmd(rmtproc, query, query_len);

        rmt_dbms->bulk_mode = FALSE;
    } else {
        // Let's check for "insert bulk" request
        if (srv_langlen(srvproc) > (sizeof(BULK_CMD) - 1))
            if (strnicmp(query, BULK_CMD, (sizeof(BULK_CMD) - 1)) == 0)
            rmt_dbms->bulk_mode = TRUE;

        // Place buffer into target SQL server's buffer.
        status = dbcmd(rmtproc, query);
    }

    // If previous DBLIB call successful, send command buffer to SQL Server.
    if (status == SUCCEED)
    {
        status = dbsqlsend(rmtproc);
        if (status)
        {
            // let's open the eyes
            if (Log.MDI_All)     ChangeIcon(rmt_dbms->hAllInfo,   IDM_ACTIVE_ICON);
            if (Log.MDI_Queries) ChangeIcon(rmt_dbms->hQueryInfo, IDM_ACTIVE_ICON);
            status = dbsqlok(rmtproc);
        }
    }

    // if the user hasn't issued a dbcancel and the call succeded
    if (!SRV_GOT_ATTENTION(srvproc) && (status == SUCCEED))
    {
        // Get the remote dbms results and pass them back to the client
        HandleResults(rmtproc, srvproc);
    } else {
        // If an attention event was issued or the dbsqlexec failed,
        // acknowledge with senddone.
        if (DBDEAD(rmtproc))
        {
            srv_sendmsg(srvproc,
                SRV_MSG_ERROR,
                (DBINT)REMOTE_FAIL,
                (DBTINYINT)23,
                (DBTINYINT)17,
                NULL,
                0,
                0,
                "Remote Server connection no longer active: \
                     thread shutting down",
                SRV_NULLTERM);
            srv_senddone(srvproc, SRV_DONE_FINAL | SRV_DONE_ERROR,
                (DBUSMALLINT)0, (DBINT)0);
            srv_event(srvproc, SRV_DISCONNECT, NULL);
        } else {
            dbcancel(rmtproc);
            srv_senddone(srvproc, SRV_DONE_FINAL, (DBUSMALLINT)0, (DBINT)0);
        }
    }
    // use the original icon
    if (Log.MDI_All)     ChangeIcon(rmt_dbms->hAllInfo,   iOldIconType);
    if (Log.MDI_Queries) ChangeIcon(rmt_dbms->hQueryInfo, iOldIconType);

    return(SRV_CONTINUE);
}

#pragma check_stack()   // set stack checking to its default setting

