
//****************************** Function Header ******************************
//
// Function : ExitRemote
//
// Description: Closes client connection
//
// Author PeterWil 1994, Microsoft Ltd.
//*****************************************************************************
#define     DBNTWIN32

// Standard compiler and SQL header files
#include    <windows.h>
#include    <sqlfront.h>
#include    <sqldb.h>
#include    <srv.h>
#include    <stdio.h>

// Application specific header files
#include    "sqlsniff.h"
#include    "exitremo.h"
#include    "rowstuff.h"

extern LOG Log;
extern HWND ghwndMain;
extern BOOL bAutoTile;

#pragma check_stack( off )  // turn off stack checking

int ExitRemote(SRV_PROC  *srvproc)
{
    REMOTE_DBMS  *remote;
    SRV_SERVER   *server;
    char log_buffer[LOG_BUF_SIZE];
    PCLIENTINFO pAll,pQuery;


    remote = (REMOTE_DBMS *)srv_getuserdata(srvproc);

    // Is there a REMOTE_DBMS structure to clean-up?
    if (remote != (REMOTE_DBMS *)NULL)
    {
        // Is there a live dbproc?
        if (remote->dbproc != (DBPROCESS *)NULL)
            dbclose(remote->dbproc);
        if (remote->login)
            dbfreelogin(remote->login);

        // Close MDI window(s)
        if (Log.MDI_Queries)
        {
            pQuery = LocalLock(remote->hQueryInfo);
            if (pQuery) 
                SendMessage(pQuery->hwnd, WM_CLOSE, 0, 0);
            else
                ERRBOX("Error closing MDI Query window");
            ClearBuffers(pQuery);
            LocalUnlock(remote->hQueryInfo);
            LocalFree(remote->hQueryInfo);
        }

        if (Log.MDI_All)
        {
            pAll = LocalLock(remote->hAllInfo);
            if (pAll)
                SendMessage(pAll->hwnd, WM_CLOSE, 0, 0);
            else
                ERRBOX("Error closing MDI AllInfo window");
            ClearBuffers(pAll);
            LocalUnlock(remote->hAllInfo);
            LocalFree(remote->hAllInfo);
        }

        if (Log.File_Queries || Log.File_All)
        {
            server = SRV_GETSERVER(srvproc);
            sprintf(log_buffer,
               "Connection closed, Client ID: %s",
               srv_pfield(srvproc, SRV_SPID, (int *)NULL));
            srv_log(server, TRUE, log_buffer, SRV_NULLTERM);
        }

        // Free the memory
        srv_free(remote);
    } 
        
    // Tile if necessary
    if (bAutoTile) PostMessage(ghwndMain,WM_COMMAND,IDM_TILE,0L);

    return(SRV_CONTINUE);
}

#pragma check_stack()   // set stack checking to its default setting

