/*********************************************************************
Multi-threaded Named Pipe test program.
Use it similar to the SQL Server MAKEPIPE/READPIPE programs.
There are actually three different programs in this group, currently
called MKPIPE2, RDPIPE2, and RDPIPE

MKPIPE2 is a multi-threaded MAKEPIPE-like,
OS/2-only server program.  Without arguments, it will generate 10
threads, each servicing a Named Pipe.  Pipe Name is always the same,
ABC.  Each pipe is actually an additional instance with the same
name.  A single numeric argument can be used to specify an alternate
number of threads.  The core of the program is a loop that reads data
with DOSREAD and writes it back out with DOSWRITE.

RDPIPE2 is a multi-threaded READPIPE-like,
OS/2-only client program.  Without arguments, it will generate 10
threads, each firing off DosTransactNmPipe to the server.  The format
of the server name is \\servername\pipe\abc, where servername is
the network name of the workstation, pipe is literally 'pipe', and
abc is literally 'abc'.  RDPIPE2 automatically prompts for the name of
the workstation.  If no argument is entered, local OS/2 pipes are
used.  Command line passing of the servername was not implemented
because this program is intended only for interactive use.

RDPIPE is a dual-mode (bound) program for both OS/2 and DOS.	It is
essentially a single-threaded version of RP5.

Each thread number is used as a y-axis offset to position the cursor
at the appropriate screen location for writing status information.
Each pair of _settextposition and printf is defined as a critical
section to prevent the OS/2 scheduler kicking in after the
_settextposition call, but before the printf call.
-- jdm, 9/91

Enhanced with array of test patterns, and larger, 1542-byte buffer size,
which is what SQL Server uses for its output buffer.
-- jdm 11/91.

Joe Marler
Microsoft Product Support Services.

***********************************************************************/

// Includes ----------------------------------------------------------------
#define INCL_DOS
#define INCL_DOSPROCESS
#define INCL_VIO
#define INCL_DOSFILEMGR

#include  <process.h>
#include  <stddef.h>
#include  <stdio.h>
#include  <string.h>
#include  <stdlib.h>
#include  <os2.h>
#include <netcons.h>
#include <graph.h>



// Prototypes --------------------------------------------------------------
void _far ReadPipe(unsigned long ulLimit);
void      main     (int argc, char *argv[]);


char pipename[80];	    /* pipename global to all threads */

/*************************************************************************
*   Here begins the function that is spun off as seperate threads	 *
*************************************************************************/

void _far ReadPipe(unsigned long ulLimit)
{
  #define BUFSZ 1542	    // size of S.S. output buffer
  int	threadid;

  static unsigned char outbuf[4][BUFSZ]; /* size of array holding tests patts.*/

  unsigned char instring[BUFSZ];

  /* array of test patterns */
  unsigned char testarray[]={0x55, 0xAA, 0xFF, 0x00};
  char curtest;
  int pipe;
  int action;
  int result;
  int bytes;
  int erflag;		//data corruption flag says die after processing buffer
  int erna=0;
  int bytesread;
  int bufoffset;
  int bufcntcol=0;
  int bufcntrow=0;
  int outcount;
  int corcount;
  long counter;


  //-----------------------------------------------------
  counter=0;


  threadid = (int) ulLimit;



  /* initialize array of test patterns with data */
  for(bufcntrow=0; bufcntrow<4; bufcntrow++)
     {
     curtest = testarray[bufcntrow];
     for(bufcntcol=0; bufcntcol<BUFSZ; bufcntcol++)
	outbuf[bufcntrow][bufcntcol]=curtest;
     outbuf[bufcntrow][bufcntcol-1]=0x00; /* so strcmp will work */
     }


  /********************************** OPEN PIPE */

    DosEnterCritSec();
	_settextposition(threadid, 0);
	printf("Thread %d  Trying to open Named Pipe..... ", threadid);
    DosExitCritSec();

result = DosOpen(
		   pipename,   // filename
		   &pipe,      // file handle
		   &action,    // returns Action taken(created,exits,trucated)
		   0L,	       // file size
		   FILE_NORMAL,// file attribute (normal=0,readonly=1, HSA)
		   FILE_OPEN,  // open flags (OPEN=1,truncate=2,create=0x10)
			       // open mode
		   OPEN_ACCESS_READWRITE |  //0x02
		   OPEN_SHARE_DENYREADWRITE,//0x10
		   0L);        // reserved  must be 0

  if (result)  // >0 is FAIL
    {

     _settextposition(threadid, 0);
     printf("Thread %d died, Failed to Open Pipe, Status=%d",threadid, result);
     _endthread();
    }



   /********************************** SET PIPE STATE */
  DosEnterCritSec();
	_settextposition(threadid, 0);
	printf("Thread %d  Trying to set Named Pipe state...", threadid);
  DosExitCritSec();

  result=DosSetNmPHandState(pipe,NP_WAIT	       |
				 NP_READMODE_MESSAGE	);

  if (result)
    {
     _settextposition(threadid, 0);
     printf("Thread %d died, Failed to Set Pipe State, Status=%d",threadid, result);
     _endthread();


    }

   /********************************* TRANSACT NAMED PIPE CALL
				      This call does a send, followed
				      by a receive	  ************/

  while (counter < 100000000)  /* Do forever */
     {

	/* Cycle through different test patterns */
	for (bufoffset = 0; bufoffset < 4; bufoffset++)
	   {

	   DosEnterCritSec();
	   _settextposition(threadid, 0);
	   printf("Thread %d  transmitting/receiving.........%ld",threadid, counter);
	   DosExitCritSec();


	   result=DosTransactNmPipe(
			  pipe, 		    //pipe name
			  (char far *) outbuf[bufoffset],	    // pointer to outbuf
			  sizeof(outbuf[bufoffset]),	    // size of output
			  (char far *) instring,    // pointer to input
			  sizeof(instring),	    // size of input
			  &bytes);		    // address of bytes read
	   counter++;

	   /* Beginning with LM 2.0, Named Pipe writes may return error */
	   /* 71 (ERROR_REQ_NOT_ACCEP).  This is a probably a design error */
	   /* in the Named Pipe code.  Have never seen this error in	*/
	   /* non-LM networks.	Retry 1 time, if it's encountered  */

	   if (result == 71)
	     {
	     erna++;		// # of er. 71s since thread start
	     DosEnterCritSec();
	     _settextposition(threadid, 0);
	     printf("ERROR: Network couldn't accept request................ retries since start: %d", erna);
	     DosExitCritSec();
	     DosSleep(2000);   //So user may see the error

	     result=DosTransactNmPipe(
			  pipe, 		    //pipe name
			  (char far *) outbuf[bufoffset],	    // pointer to outbuf
			  sizeof(outbuf[bufoffset]),	    // size of output
			  (char far *) instring,    // pointer to input
			  sizeof(instring),	    // size of input
			  &bytes);		    // address of bytes read
	     }
	   if (result)
	     {
	     DosEnterCritSec();
	     _settextposition(threadid, 0);
	     printf("Thread %d died, 2 consecutive DosTransactNmPipe failures, Status=%d     ",threadid, result);
	     DosExitCritSec();
	     _endthread();
	     }

	   /* May happen if server terminates, causing an EOF situation */
	   if(bytes==0)
	     {
	     DosEnterCritSec();
	     _settextposition(threadid, 0);
	     printf("Thread %d died, 0 bytes read with no failure code", threadid);
	     DosExitCritSec();
	     _endthread();
	     }

	   /****** Check if we read what we wrote *******/
	   corcount=0;		// only print 10 corrupted bytes if detected
	   erflag=FALSE;
	   for(outcount=0; outcount<BUFSZ; outcount++)
	      {
	      if(outbuf[bufoffset][outcount] != instring[outcount])
		 {
		 erflag=TRUE;		//Die after buffer processed
		 DosEnterCritSec();	//Only run this thread, then die
		 if(corcount<10)	//Process only 1st 10 corrupt bytes
		    {
		    if(corcount==0)
		       printf("\n\nDATA CORRUPT!! SHUTTING DOWN!!"); //avoid OS/2 title bar
		    printf("\nWrote %x (hex), Read %x (hex), in byte %d (dec)", outbuf[bufoffset][outcount], instring[outcount], outcount);
		    corcount++;
		    }
		 else
		    DosExit(EXIT_PROCESS,1);

		 }

	      }
	    if(erflag)
	       DosExit(EXIT_PROCESS,1); //Hit some error so die
	   }
     }

}//End ReadPipe



/**************************************************************************
* Main function merely starts up multiple threads of Readpipe function	  *
**************************************************************************/

void main(int argc, char *argv[])

{

  char	SvrName[20];
  char	Pname[80];
  int i, result;
  int iThreadCnt;

  if (argc < 2) iThreadCnt = 10;
  else		iThreadCnt = atoi(argv[1]);

  SvrName[0]='\0';
  strcpy(Pname, "\\pipe\\abc");

  printf("\n Enter Server Name (incl. leading \\\\): ");
  gets(SvrName);
  strcpy(pipename, SvrName);
  strcat(pipename, Pname);

  _clearscreen(_GCLEARSCREEN);

  if (DosSetMaxFH(200) != 0)	/*** Necessary for > 20 threads ***/
    {
    printf("\nDosSetMaxFH failed, terminating process");
    DosExit(EXIT_PROCESS, 1);
    }

  for (i=1; i < (iThreadCnt+1); i++) {
    if (_beginthread((void (_far *)(void _far *))ReadPipe,
                     NULL,
		     4096,
		     (unsigned long) i) < 0) {
      printf("*** Error *** Could not start thread %u\n", i);
      exit(0);
    }
  }
  DosSleep(2000000000L);


  return;
}
