/*********************************************************************
Single-threaded Named Pipe test program.
Use it similar to the SQL Server MAKEPIPE/READPIPE programs.
There are actually three different programs in this group, currently
called MKPIPE2, RDPIPE2, and RDPIPE.

MKPIPE2 is a multi-threaded MAKEPIPE-like,
OS/2-only server program.  Without arguments, it will generate 10
threads, each servicing a Named Pipe.  Pipe Name is always the same,
ABC.  Each pipe is actually an additional instance with the same
name.  A single numeric argument can be used to specify an alternate
number of threads.  The core of the program is a loop that reads data
with DOSREAD and writes it back out with DOSWRITE.

RDPIPE2 is a multi-threaded READPIPE-like,
OS/2-only client program.  Without arguments, it will generate 10
threads, each firing off DosTransactNmPipe to the server.  The format
of the server name is \\servername\pipe\abc, where servername is
the network name of the workstation, pipe is literally 'pipe', and
abc is literally 'abc'.  RDPIPE2 automatically prompts for the name of
the workstation.  If no argument is entered, local OS/2 pipes are
used.  Command line passing of the servername was not implemented
because this program is intended only for interactive use.

RDPIPE is a dual-mode (bound) program for both OS/2 and DOS.	It is
essentially a single-threaded version of RP5.




This is the Make syntax for RDPIPE.C:

cl -c -Zi -Od rdpipe.c
link /STACK:16384 rdpipe/CO,,,os2;
bind rdpipe.exe apilmr.obj api.lib os2.lib doslan.lib -o rdpipe.exe


-- jdm 9/91
-- jdm 11/91 Updated to be like RDPIPE2, its multi-threaded big brother.

Joe Marler
Microsoft Product Support Services.

***********************************************************************/


/***********************  DEFINE */

#define INCL_DOS
#define BUFSZ 1542		// SQL Server's output buffer size

/**********************  include */

#include <os2.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <netcons.h>

/********************************* MAIN */

int main(int argc, char **argv)
{
  /****************************** VARIABLES */

  char	   SvrName[20];  // For the server name
  char	   Pname[80];	 // pipe name only
  char	   pipename[80]; // for server-pipe combination
  char	   closebuf[10]; // to send the 'close'
  char curtest;
  unsigned char testarray[]={0x55, 0xAA, 0xFF, 0x00}; // array of test pats.
  static unsigned char outbuf[4][BUFSZ]; /* size of array holding tests patts.*/
  unsigned char instring[BUFSZ];

  int pipe;    // pipe handle
  int action;  // Action code from dos open
  int result;  // result of function calls
  int bytes;   // bytes sent/received
  int bytesread;
  int bufoffset;
  int bufcntcol=0;
  int bufcntrow=0;
  int outcount;
  int corcount;
  int erflag;	    // indicates data corruption happend, bail out.
  int erna=0;
  long counter; // send loop counter
  int passcntr;// use to only print pass count every 10 passes

/******************************* INITIALIZE */

  counter=0;
  SvrName[0]='\0';
  strcpy(Pname,"\\pipe\\abc");

  printf("\n Enter Server Name (incl. leading \\\\): ");
  gets(SvrName);
  strcpy(pipename,SvrName);
  strcat(pipename,Pname);

  /* initialize array of test patterns with data */
  for(bufcntrow=0; bufcntrow<4; bufcntrow++)
     {
     curtest = testarray[bufcntrow];
     for(bufcntcol=0; bufcntcol<BUFSZ; bufcntcol++)
	outbuf[bufcntrow][bufcntcol]=curtest;
     outbuf[bufcntrow][bufcntcol-1]=0x00; /* so strcmp will work */
     }


  /**********************************************   OPEN PIPE */

result = DosOpen(
		   pipename,   // filename
		   &pipe,      // file handle
		   &action,    // returns Action taken(created,exits,trucated)
		   0L,	       // file size
		   FILE_NORMAL,// file attribute (normal=0,readonly=1, HSA)
		   FILE_OPEN,  // open flags (OPEN=1,truncate=2,create=0x10)
			       // open mode
		   OPEN_ACCESS_READWRITE |  //0x02
		   OPEN_SHARE_DENYREADWRITE,//0x10
		   0L);        // reserved  must be 0

  if (result)  // >0 is FAIL
    {
     printf("\n\nFailed to Open Pipe, Status=%d  ",result);
     return(1);
    }



  /************************************************ SET PIPE STATE */
  result=DosSetNmPHandState(pipe,NP_WAIT	       |
				 NP_READMODE_MESSAGE	);

  if (result)
    {
     printf("\nSET Pipe State: %d\n",result);
     return(1);
    }

       /*********************
       transact call
       ****************/
  passcntr = 0;
  while (counter < 100000000)
     {
     /* Cycle through different test patterns */
     for (bufoffset = 0; bufoffset < 4; bufoffset++)
	{
	result=DosTransactNmPipe(
			  pipe, 		    //pipe name
			  (char far *) outbuf[bufoffset],    // pointer to outbuf
			  sizeof(outbuf[bufoffset]),	    // size of output
			  (char far *) instring,    // pointer to input
			  sizeof(instring),	    // size of input
			  &bytes);		    // address of bytes read
	counter++;
	passcntr++;


	if (passcntr > 9)	/* Print pass cnt every 10 passes	*/
	    {
	    printf("\nPerforming Named Pipe test, counter: %ld", counter);
	    passcntr = 0;
	    }

	/* Beginning with LM 2.0, Named Pipe writes may return error */
	   /* 71 (ERROR_REQ_NOT_ACCEP).  This is a probably a design error */
	   /* in the Named Pipe code.  Have never seen this error in	*/
	   /* non-LM networks.	Retry 1 time, if it's encountered  */

	   if (result == 71)
	     {
	     erna++;		// # of er. 71s since thread start
	     printf("ERROR: Network couldn't accept request................ retries since start: %d", erna);
	     DosSleep(2000);   //So user may see the error

	     result=DosTransactNmPipe(
			  pipe, 		    //pipe name
			  (char far *) outbuf[bufoffset],	    // pointer to outbuf
			  sizeof(outbuf[bufoffset]),	    // size of output
			  (char far *) instring,    // pointer to input
			  sizeof(instring),	    // size of input
			  &bytes);		    // address of bytes read
	     }

	   if (result)
	     {
	     printf("\nProcess died, 2 consecutive DosTransactNmPipe failures, Status=%d     ", result);
	     DosExit(EXIT_PROCESS,1);
	     }

	   /* This may happen if server terminates, causing an EOF situation*/
	   if(bytes==0)
	     {
	     printf("\nProcess died, 0 bytes read with no failure code");
	     DosExit(EXIT_PROCESS,1);
	     }
	 /****** Check if we read what we wrote *******/
	   corcount=0;		// only print 10 corrupted bytes if detected
	   erflag=FALSE;
	   for(outcount=0; outcount<BUFSZ; outcount++)
	      {
	      if(outbuf[bufoffset][outcount] != instring[outcount])
		 {
		 erflag=TRUE;
		 if(corcount<10)
		    {
		    if(corcount==0)
		       printf("\n\nDATA CORRUPT!! SHUTTING DOWN!!"); //avoid OS/2 title bar
		    printf("\nWrote %x (hex), Read %x (hex), in byte %d (dec)", outbuf[bufoffset][outcount], instring[outcount], outcount);
		    corcount++;
		    }
		 else
		    DosExit(EXIT_PROCESS,1); //Hit error limit so die
		 }

	      }
	    if(erflag)
		DosExit(EXIT_PROCESS,1);  //Hit some error so die

	 }
      }// End WHILE

}
