#define DPAGE_VER "DPages Version 1.10"
#define DBMSOS2

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <errno.h>
#include <io.h>
#include <sqlfront.h>
#include <sqldb.h>

#define OBJECT_ID_LEN 11
#define DPAGE_VAL_LEN 10
#define STDEXIT 0
#define LOGINULL (LOGINREC *)NULL



/***  BEGIN STRUCTURE DEFINTIONS  ********************************************/
struct dpage_node {				/* Linked list structure     */
    char		object_id[OBJECT_ID_LEN];		/* used to hold the object   */
    char		dpage_value[DPAGE_VAL_LEN];	/* id and correct dpage      */
    struct dpage_node	*next;			/* value that should appear  */
};						/* in the sysindexes table.  */
typedef struct dpage_node   DPAGE_ELEMENT;
typedef DPAGE_ELEMENT	    *DPAGE_LINK;
/***   END STRUCTURE DEFINTIONS   *******************************************/



/***  BEGIN GLOBAL DECLARATIONS	***********************************************/
DPAGE_LINK  head = NULL;			/* ptr to start of link list  */
DPAGE_LINK  tail = NULL;			/* ptr to end of link list    */
char	    object_id[OBJECT_ID_LEN];			/* temp storage of object id  */
char	    dpage_value[DPAGE_VAL_LEN];			/* temp storage of dpage val. */
int	    count = 0;				/* cnt of corrupted dpage val */
RETCODE     result_code;			/* global SQL func ret code   */
int	    debug = 0;				/* 0=no debug 1=debug enabled */
int	    fdDebug;				/* debug file descriptor      */
/***   END GLOBAL DECLARATIONS	***********************************************/



/***  BEGIN FORWARD DECLARATIONS  ***/
void main(int, char *[]);
void process_parameters (int, char *[], char **, char **, char **, char **);
void usages (void);
void open_connection(DBPROCESS **,LOGINREC **,char *,char *,char *);
void search_db(DBPROCESS **, char *);
void correct_dpage(DBPROCESS **, char *);
int errhand(DBPROCESS *,int,int,int,char *,char *);
int msghand(DBPROCESS *,DBINT,int,int,char *);
/***   END FORWARE DELCARATIONS   ***/



/*****************************************************************************
**  Function Name: MAIN							    **
**									    **
**  Purpose: Controls the flow of DPAGES by:				    **
**		1) declare and initialize user varriables		    **
**		2) process all user defined parameters			    **
**		3) establish connection to SQL Server			    **
**		4) find and trap all DPAGE inconsistencies		    **
**		5) correct all DPAGE inconsistencies			    **
*****************************************************************************/
void main(argc, argv)
int	argc;
char	*argv[];
{
    /* Varriable Declaration */
    DBPROCESS *dbproc;
    LOGINREC  *login;
    char      *server;
    char      *db_name;
    char      *user;
    char      *password;

    /* initialize varriables */
    server   = (CHAR *) malloc (30);
    db_name  = (CHAR *) malloc (30);
    user     = (CHAR *) malloc (30);
    password = (CHAR *) malloc (30);
    strcpy (server, "");
    strcpy (db_name,"master");
    strcpy (user,"sa");

    /* Display Version Number */
    printf ("\n%s\n", DPAGE_VER);


    /* set the error and message handler routine */
    dberrhandle(errhand);
    dbmsghandle(msghand);

    /* process user entered parameters */
    process_parameters (argc, argv, &server, &db_name, &user, &password);

    /* open connection to SQL Server */
    open_connection(&dbproc, &login, server, user, password);

    /* search for all dpage errors */
    search_db (&dbproc, db_name);

    /* correct dpage errors */
    if (count > 0)
	correct_dpage (&dbproc, db_name);
    else
	printf ("\n\nNo DPAGE Inconsistencies Found in Database %s\n",db_name);

    if (debug)
	close (fdDebug);

    /* terminate program */
    dbexit ();
    exit (STDEXIT);
}



/*****************************************************************************
**  Function Name: ERRHAND						    **
**									    **
**  Purpose: Dispays error messages that might occur during the course of   **
**  this program.							    **
*****************************************************************************/
int errhand(acctproc,sev,dberr,oserr,dberrstr,oserrstr)
DBPROCESS *acctproc;
int sev;
int dberr;
int oserr;
char *dberrstr;
char *oserrstr;
{
    printf ("SQL ERROR: %d, %s\n",dberr,dberrstr);
    return(0);
}


/*****************************************************************************
**  Function Name: MSGHAND						    **
**									    **
**  Purpose: Displays and processes selected messages that occur during the **
**  course of the program.  It is here where DPAGES determines if an object **
**  has dpage inconsistencie problems.	Message number 2537 and 2579 return **
**  the object id and correct count for dpages.  And message 2583 determines**
**  that the dpage value is not correct in 'sysindexes'.		    **
*****************************************************************************/
int msghand(acctproc,msgno,msgstate,sev,msgtext)
DBPROCESS *acctproc;
DBINT msgno;
int msgstate;
int sev;
char *msgtext;
{
    char    *ptr;
    char    numbuf[6];


    if (debug) {
      itoa((int)msgno, numbuf, 10);
      strcat (numbuf, ":");
      write (fdDebug, numbuf, strlen(numbuf));
      write (fdDebug, msgtext, strlen(msgtext));
      write (fdDebug, "\n", sizeof("\n"));
    }

    switch (msgno) {

	case 2537: /* retries object id of object being checked */
	    strcpy (object_id, msgtext+9);
	    printf (".");
	    break;

	case 2579: /* returns number of pages counted */
	    strcpy (dpage_value, msgtext+48);
	    ptr = strrchr (dpage_value, '.');
	    *ptr = '\0';
	    break;

	case 2583: /* records DPAGE inconsitency */
	    ++count;
	    if (head == NULL) {
		 head = tail = (DPAGE_LINK) malloc (sizeof (DPAGE_ELEMENT));
	    }
	    else {
		 tail->next = (DPAGE_LINK) malloc (sizeof (DPAGE_ELEMENT));
		 tail = tail->next;
	    }
	    strcpy (tail->object_id, object_id);
	    strcpy (tail->dpage_value, dpage_value);
	    tail->next = NULL;
	    break;

	case 3505:
	    printf ("\nInsufficient privileges, only DBO may execute DPAGES\n");
	    exit (ERREXIT);
	    break;

	case 2812:
	case 911:
	case 4002:
	    printf ("\n%s\n",msgtext);
	    exit (ERREXIT);
	    break;
    }

    return(0);
}

/*****************************************************************************
**  Function Name: PROCCESS_PARAMETERS					    **
**									    **
**  Purpose: This routine processes the command line parameters that the    **
**  user enters.  Server, Database, User and Password are determined here.  **
**  If the user enters /h or an invalid command line parameter, USAGES will **
**  be displayed and the program terminated.				    **
*****************************************************************************/
void process_parameters (argc, argv, server, db_name, user, password)
int	argc;
char	*argv[];
char	**server;
char	**db_name;
char	**user;
char	**password;
{
    int cnt;
    int pswd_not_set = 1;

    for (cnt=1; (cnt<argc) && ((*argv[cnt]=='/') || (*argv[cnt]=='-')); cnt++) {
	switch (*(argv[cnt]+1)) {

	    case 's':
	    case 'S':
		strcpy (*server, (argv[cnt]+2));
		break;

	    case 'D':
	    case 'd':
		strcpy (*db_name, (argv[cnt]+2));
		break;

	    case 'U':
	    case 'u':
		strcpy (*user, (argv[cnt]+2));
		break;

	    case 'P':
	    case 'p':
		strcpy (*password, (argv[cnt]+2));
		pswd_not_set = 0;
		break;

	    case 'Z':
	    case 'z':
	    case 'o':
	    case 'O':
		debug = 1;
		if ((fdDebug = open (argv[cnt]+2, 1)) == -1)
		    fdDebug = creat (argv[cnt]+2, 0777);
		break;

	    case 'H':
	    case 'h':
	    default:
		usages ();

	    }
	}
    /* check password set */
    if (pswd_not_set) {
	char	ch[30] = "";
	int	i = -1;

	printf ("password: ");
	while ((ch[++i] = (char)getch()) != '\r') {
	    if (ch[i] == 8) {	 /* 8 is ASCII character for backspace */
		ch[i--] = '\0';
		if (i >= 0) ch[i--] = '\0';
		}
	    }
	ch[i] = '\0';
	strcpy (*password, ch);
	}
}


/*****************************************************************************
**  Function Name: USAGES						    **
**									    **
**  Purpose: Displays propper usage of DPAGES to the user.  This function   **
**  is called upon the user asking for help using the /h option or the user **
**  enters impropper command line options.				    **
*****************************************************************************/
void usages ()
{
    printf ("\n\nusage: dpages [/h][/s<server>][/d<datbase>][/u<user>][/p<password>]");
    printf ("\n\nexample: dpages /Smyserv /Usa /P /Dpubs ");
    printf ("\n");
    printf ("\n/s specifies server name, default [NULL]");
    printf ("\n/d database name to be checked, default [master]");
    printf ("\n/u user name, deafualt [sa]");
    printf ("\n/p user password, if flag not used - user will be prompted");
    printf ("\n/o message file, outputs all messages received to ouput file specifed");
    printf ("\n");
    printf ("\nDescription:  DPAGES will check the database specified for dpage");
    printf ("\ninconsistencies and correct all descrpencies in 'sysindexes'.");
    printf ("\n");
    exit (STDEXIT);
}

/*****************************************************************************
**  Function Name: OPEN_CONNECTION					    **
**									    **
**  Purpose: Establishes a valid connection to the server		    **
*****************************************************************************/
void open_connection(dbproc,login,server,user,password)
DBPROCESS **dbproc;
LOGINREC  **login;
char	  *server;
char	  *user;
char	  *password;
{
    /* initialize the login structure */
    if ( (*login = (LOGINREC *)dblogin()) == LOGINULL ) {
	printf("Can't Allocate For Login Record.\n");
	exit(0);
    }

    /* set the user, password, and application */
    if ( DBSETLUSER(*login,user) == FAIL ) {
	printf("Can't Set User Name %s - ABORTING!\n",user);
	exit(0);
    }
    if ( DBSETLPWD(*login,password) == FAIL ) {
	printf("Can't Set User Password  - ABORTING!\n");
	exit(0);
    }
    if ( DBSETLAPP(*login,"D_Page") == FAIL ) {
	printf("Can't Set User Application FCVOL - ABORTING!\n");
	exit(0);
    }

    *dbproc = dbopen(*login,server);
}

/*****************************************************************************
**  Function Name: SEARCH_DB						    **
**									    **
**  Purpose: Executes a DBCC CHECKDB on the specified database to search    **
**  for dpage inconsistencies.	An inconsistencies will be trapped by the   **
**  message handler and saved in a linked list for processing.		    **
*****************************************************************************/
void search_db (dbproc, db_name)
DBPROCESS   **dbproc;
char	    *db_name;
{
    printf ("\nScanning database '%s' for DPAGE inconsistencies:\n",db_name);

    /* Run checkpoint fo force all outstanding Dpage writes */
    dbuse (*dbproc, db_name);
    dbcmd (*dbproc, "checkpoint");
    dbsqlexec (*dbproc);
    dbresults (*dbproc);

    /* Run DBCC CHECKDB, message handler will trap all dpage errors */
    dbfcmd (*dbproc, "dbcc checkdb (%s)", db_name);
    dbsqlexec (*dbproc);
    dbresults (*dbproc);
}

/*****************************************************************************
**  Function Name: CORECT_DPAGE 					    **
**									    **
**  Purpose: Scans the link list and then corrects the dpage number for the **
**  offending record in 'sysindexes'.					    **
*****************************************************************************/
void correct_dpage (dbproc, db_name)
DBPROCESS   **dbproc;
char	    *db_name;
{
    printf ("\n\n%d DPAGE Inconsistencies Found in Database %s\n\n",count, db_name);
    printf ("Correcting:\n");

    /* Allow for dynamic updates to system tables */
    dbcmd (*dbproc, "sp_configure 'allow updates', 1 ");
    dbcmd (*dbproc, "reconfigure with override");
    dbsqlexec (*dbproc);
    dbresults (*dbproc);

    tail = head;
    while (tail != NULL) {
	printf ("setting dpages to %s for object id %s in sysindexes table...",tail->dpage_value,tail->object_id);

	/* check dpage value for both clustered and nonclusted indexes */
	dbfcmd (*dbproc, " update %s..sysindexes ",db_name);
	dbfcmd (*dbproc, " set dpages = %s ",tail->dpage_value);
	dbfcmd (*dbproc, "   where id = %s ",tail->object_id);
	dbcmd  (*dbproc, "   and indid = 0 ");
	dbfcmd (*dbproc, "   and dpages != %s ", tail->dpage_value);
	dbfcmd (*dbproc, " update %s..sysindexes ",db_name);
	dbfcmd (*dbproc, " set dpages = %s ",tail->dpage_value);
	dbfcmd (*dbproc, "   where id = %s ",tail->object_id);
	dbcmd  (*dbproc, "   and indid = 1 ");
	dbfcmd (*dbproc, "   and dpages != %s ", tail->dpage_value);

	dbsqlexec (*dbproc);
	while ((result_code = dbresults (*dbproc)) != NO_MORE_RESULTS)
	    if (result_code == SUCCEED)
		while (dbnextrow(*dbproc) != NO_MORE_ROWS);
	    else {
		printf ("update failed\n");
		exit (ERREXIT);
		}
	printf ("updated \n");
	tail = tail->next;
	}

    /* Dis-Allow for dynamic updates to system tables */
    dbcmd (*dbproc, "sp_configure 'allow updates', 0 ");
    dbcmd (*dbproc, "reconfigure with override");
    dbsqlexec (*dbproc);
    dbresults (*dbproc);
}
