 /*************************************************************************

  This program preserves SQL Server 1.x security by preventing
  "hanging usernames" when the corresponding login ID is
  deleted. This can happen if a login ID has several usernames
  associated with it in several databases. The stored procedure
  sp_droplogin() will only check in the current database for
  associated usernames and the System Adminstrator is supposed
  to make sure that the corresponding usernames have been deleted.
  Failing this there is a good chance that SQL Server security
  can be compromised. For a more details on how this can happen
  see the file README.TXT which accompanies this utility.


  Vaqar Pirzada
  Microsoft SQL Server Support

*************************************************************************/

#define DBMSDOS /* operating system envorinment */
#include <sqlfront.h>
#include <sqldb.h>
#include <malloc.h>


#define     NULL    0


typedef struct db_names {
   DBCHAR       dbname[32];
   struct       db_names *next;
};


main ()
{
    DBPROCESS     *dbproc;  /* allocate a DB-LIB process structure          */
    LOGINREC      *login;   /* allocate a DB-LIB login structure            */
    int            errno;   /* variable to store DB-LIB error number in     */
    int          i=0;
    int          j=0;
    int          rowinfo;
    int 	 nomatch=0;
    char         *msg;      /* used to receive DB-LIB error message pointer */
    DBINT        num_of_cols;
    DBINT        len;
    DBINT        numofdbs;
    DBSMALLINT   suid=0;
    BYTE         *BptrDBNAME;
    BYTE         *BptrUSERNAME;

    /* Variables used to store the returning data */
    char       loginame[25];
    char       Servername[25];
    RETCODE    result_code;
    DBCHAR     username[32];

    struct db_names db_names;
    struct db_names *dbnames;
    struct db_names *tmp=NULL;



    /* Forward declarations of the error handler and message handler. */
    int        err_handler();
    int        msg_handler();


    dbnames=malloc(sizeof(struct db_names));
    dbnames->next=NULL;


    /* Install the user-supplied error-handling and message-handling
     * routines. They are defined at the bottom of this source file.
     */
    dberrhandle(err_handler);
    dbmsghandle(msg_handler);

    strcpy(username, "nouser");

    /* Get server's computer name */
    Servername[0] = NULL;
    printf ("\nEnter Name of SQL SERVER: ");
    gets (Servername);

    /* Get the login name */
    loginame[0] = NULL;
    printf ("\nEnter the login ID to be deleted: ");
    gets (loginame);

    login = dblogin();              /* get login record from DB-LIB */
    DBSETLUSER (login, "sa");       /* set the username             */
    DBSETLAPP (login, "example1");  /* set the application name     */
    DBSETLPWD (login, "");          /* set the SQL Server password  */

    /* Now attempt to create and initialize a DBPROCESS structure */
    if( (dbproc = dbopen (login, Servername)) == NULL)
    {
	printf ("dbopen failed\n");
	return (1); /* exit program */
    }


     dbcmd(dbproc, " select count(*) from sysdatabases");
     dbsqlexec(dbproc);

     while ((result_code = dbresults(dbproc)) != NO_MORE_RESULTS)
     {
	 if (result_code == SUCCEED)
	 {
	     /* now process the rows    */
	     while (dbnextrow(dbproc) != NO_MORE_ROWS)
	     {
		 numofdbs= *((DBSMALLINT *)dbdata(dbproc,1));

	     }
	 }
	 else
	 {
	     printf ("Results Failed\n");
	     break;
	 }
     }       /* end WHILE dbresults */

    /* allocate an array of strings to hold the names of the databases */

    dbuse (dbproc, "master");   /* use the "pubs" database */


    /* construct command buffer to be sent to the SQL server */

    dbcmd (dbproc," select name from sysdatabases");

    dbsqlexec (dbproc); /* send command buffer to SQL server */

    /* now check the results from the SQL server */
    while ((result_code = dbresults(dbproc)) != NO_MORE_RESULTS)
    {
       if (result_code == SUCCEED)
       {
	   /* now process the rows      */
	   while (dbnextrow(dbproc) != NO_MORE_ROWS)
	   {
	       len=dbdatlen(dbproc, 1);
	       BptrDBNAME=dbdata(dbproc,1);

	       if (dbnames->next==NULL) /* the list is empty */
		  tmp=dbnames;
	       else
		  for(tmp=dbnames; tmp->next!=NULL; tmp=tmp->next)
		  {
		  }
	       tmp->next=malloc(sizeof(struct db_names));

	       tmp->next->next=NULL;
	       strncpy(tmp->next->dbname,(DBCHAR *)BptrDBNAME, len);
	       tmp->next->dbname[len]='\0';
	   }
	}
	else
	{
	    printf ("Results Failed\n");
	    break;
	}
     }  /* end WHILE dbresults */


     dbfcmd(dbproc, "select suid from syslogins where name='%s'", loginame);
     dbsqlexec(dbproc);

     while ((result_code = dbresults(dbproc)) != NO_MORE_RESULTS)
     {
	 if (result_code == SUCCEED)
	 {
	     /* now process the rows    */
	     while (dbnextrow(dbproc) != NO_MORE_ROWS)
	     {
		 suid= *((DBSMALLINT *)dbdata(dbproc,1));

	     }
	 }
	 else
	 {
	     printf ("Results Failed\n");
	     break;
	 }
     }       /* end WHILE dbresults */


     /* In case the user enters an Invalid LoginID print a msg and exit */
     if (suid==0)
     {
	printf("\nInvalid LoginID\n");
	exit(0);
     }

     for(tmp=dbnames->next; tmp !=NULL; tmp=tmp->next)
     {
	dbuse(dbproc, tmp->dbname);
	dbfcmd(dbproc, " select name from sysusers where suid = %d", suid);
	dbsqlexec(dbproc);
	while ((result_code = dbresults(dbproc)) != NO_MORE_RESULTS)
	{
	    if (result_code == SUCCEED)
	    {
		/* now process the rows */
		while (dbnextrow(dbproc) != NO_MORE_ROWS)
		{

		    len=dbdatlen(dbproc, 1);
		    BptrUSERNAME = dbdata(dbproc,1);
		    strncpy(username, (DBCHAR *)BptrUSERNAME, len);
		    username[len]='\0';

		}
	    }
	    else
	    {
		printf ("Results Failed\n");
		break;
	    }
	}       /* end WHILE dbresults */

	if (strcmp(username, "nouser")!=0)
	{
	nomatch++;
	dbfcmd(dbproc, " sp_dropuser %s", username);
	dbsqlexec(dbproc);
	dbresults(dbproc);
	printf("\nUser %s dropped from database %s \n", username, tmp->dbname);
	strcpy(username, "nouser");
	}

     }          /* end FOR */

     dbuse(dbproc, "master");
     dbfcmd(dbproc, " sp_droplogin %s", loginame);
     dbsqlexec(dbproc);
     dbresults(dbproc);
     if (nomatch ==0)
     {
	printf("\nNo UserName Associated with this LoginID in any database\n");
     }
     printf("\nLoginID %s Dropped\n\n", loginame);


    /* Close the connection and exit */
    dbexit();
}

int err_handler(dbproc, severity, dberr, oserr, dberrstr, oserrstr)
DBPROCESS       *dbproc;
int             severity;
int             dberr;
int             oserr;
char            *dberrstr;
char            *oserrstr;
{

	if (dberr==SQLENONET)
		{
		printf("\nNetwork Communication Layer Not Loaded\n");
		printf("Load TSR dbnmpipe and then run this utility\n\n");
		}
	if ((dbproc == NULL) || (DBDEAD(dbproc)))
		return(INT_EXIT);
	else
	{
		printf("DB-LIBRARY error:\n\t%s\n", dberrstr);

		if (oserr != DBNOERR)
			printf("Operating-system error:\n\t%s\n", oserrstr);

		return(INT_CANCEL);
	}
}

int msg_handler(dbproc, msgno, msgstate, severity, msgtext)
DBPROCESS        *dbproc;
DBINT            msgno;
int              msgstate;
int              severity;
char             *msgtext;
{

	if (msgno == 5701 || msgno==0 || msgno==5703)
	    return(0);

	printf
		("SQL Server message %ld, state %d, severity %d:\n\t%s\n",
		 msgno, msgstate, severity, msgtext);
	return(0);
}
