/* Try to determine whether any write caching is in effect. */
/* Write caching adversely impacts database integrity. */
/* Write caching can be software-based or hardware-based. */
/* Microsoft OS/2 HPFS has a software-based write caching */
/* capability (lazy writing).  HPFS write caching can be circumvented */
/* by using the OPEN_FLAGS_WRITE_THROUGH parameter of DosOpen. */
/* SQL Server uses this parameter to insure that written data is */
/* safely committed on the disk before DosWrite returns.  */
/* This program does highly localized writing both with and without */
/* OPEN_FLAGS_WRITE_THROUGH set.  It times these operations, and */
/* comparision thereof can indicate the caching state of the */
/* platform.  Two passes in each mode are taken.  Some variation */
/* (up to about 30%) is normal.	The first two passes have */
/* WRITE_THROUGH set, and the second two don't.  What to look for: */
/* If all 4 passes are relatively slow (40-200 milliseconds) this */
/* indicates no write caching of any type is in effect. */
/* If all 4 passes are fast (0-10 milliseconds) this indicates */
/* that probable hardware write caching is in effect. */
/* If the first two passes are slow, and the second two passes */
/* are fast, this indicates that some type of caching /*
/* (most likely HPFS) is in effect that honors the WRITE_THROUGH */
/* parameter of DosOpen.  If this parameter is honored, SQL Server */
/* should have no cache-related integrity problems. */
/* This program is simple and primitive, but it works. */
/* At least nobody thought of doing it before now. */
/* Joe Marler, */
/* Microsoft SQL Server Support. */
/* Written 10-28-91 */


/* Haven't scrutinized what #defines and #includes are necessary.  */
/* I only know that this combination works */

#define INCL_DOS
#define INCL_DOSPROCESS
#define INCLl_VIO
#define INCL_DOSFILEMGR

#include  <process.h>
#include  <stddef.h>
#include  <stdio.h>
#include  <string.h>
#include  <stdlib.h>
#include  <os2.h>
#include <netcons.h>
#include <graph.h>

#include "io.h"
#include "bios.h"
#include "stdio.h"
#include "stdlib.h"
#include "sys\types.h"
#include "sys\stat.h"
#include "errno.h"
#include "time.h"


main()
   {
   char buf[8192];	    /* buffer for data to be written */
   char fname[]="cachetst"; /* name of test file */
   ULONG ulFilePointer;

   int pipe, bytes, action, result;
   unsigned int fd1,count=0,count2=0,count3=0, pass=28;
   double tused, tperstep;
   time_t tstart, tstop;

   for(count=0; count<8192; count++)  /* init buffer to ASCII 'A' */
      buf[count] = 0x41;


/********* DO FIRST PASS WITH WRITE_THROUGH SET **********/
   printf("\nTESTING FOR PRESENCE OF WRITE-BACK DISK CACHE\n");
   printf("\nAll 4 passes slow (50-200 mS): no write caching ");
   printf("\nAll 4 passes fast (0-10 mS): hardware write caching");
   printf("\n1st two passes slow and 2nd two fast: software write caching");
   printf("\nUp to about 30 percent inter-pass variation may be expected\n");

   result = DosOpen(
		   fname,	 // filename
		   &pipe,      // file handle
		   &action,    // returns Action taken(created,exits,trucated)
		   0L,	       // file size
		   FILE_NORMAL,// file attribute (normal=0,readonly=1, HSA)
		   FILE_TRUNCATE|
		   FILE_CREATE,	// open flags (OPEN=1,truncate=2,create=0x10)
			       // open mode
		   OPEN_ACCESS_READWRITE |
		   OPEN_SHARE_DENYNONE |
		   OPEN_FLAGS_WRITE_THROUGH,
		   0L);        // reserved  must be 0

    if (result)
	{
	printf("\n Failed to open file, return code = %d", result);
	DosExit(EXIT_PROCESS, 1);
	}


   /* Outermost (count3) loop currently does 2 passes, just to give */
   /* better idea of typical execution times.  Next loop in */
   /* does "pass" no. of passes.  Each of these passes is currently */
   /* defined as 4 DosWrite passes and 1 DosChgFilePtr each.  */
   /* Next loop in (count2) is what makes the 4:1 ratio between */
   /* DosWrite and DosChgFilePtr.  Reason for this is to minimize */
   /* overhead of DosChgFilePtr relative to DosWrite */


   for(count3=0; count3<2; count3++)
      {
      time(&tstart);	    /* get start time */
      for(count=0; count<pass; count++)
	 {
	 for(count2=0; count2<4; count2++)
	    {
	    result=DosWrite(
			pipe,
			(char far *) buf,
			sizeof(buf),
			&bytes);
	    if (result)
	       {
	       printf("\n DosWrite failed, return code = %d", result);
	       DosExit(EXIT_PROCESS, 1);
	       }
	    }



	    result = DosChgFilePtr(pipe,
		0L,
		FILE_BEGIN,
		&ulFilePointer);

	    if(result)
	       {
	       printf("\n DosChgFilePtr failed, return code = %d", result);
	       DosExit(EXIT_PROCESS, 1);
	       }

	 }

       time(&tstop);
       tused = difftime(tstop, tstart);
       tperstep = tused / (double)count;
       printf("\nWRITE_THROUGH time per iteration: %f milliseconds\n", tperstep*1000.0);
       } /* End count 3 */

    DosClose(pipe);
    DosDelete(fname, 0L);


    /********* DO A SECOND TIME WITHOUT DISABLING WRITE CACHING *****/

    result = DosOpen(
		   fname,	 // filename
		   &pipe,      // file handle
		   &action,    // returns Action taken(created,exits,trucated)
		   0L,	       // file size
		   FILE_NORMAL,// file attribute (normal=0,readonly=1, HSA)
		   FILE_TRUNCATE|
		   FILE_CREATE,	// open flags (OPEN=1,truncate=2,create=0x10)
			       // open mode
		   OPEN_ACCESS_READWRITE |
		   OPEN_SHARE_DENYNONE,
		   0L);        // reserved  must be 0

    if (result)
	{
	printf("\n Failed to open file, return code = %d", result);
	DosExit(EXIT_PROCESS, 1);
	}

   for(count3=0; count3<2; count3++)
      {
      time(&tstart);
      for(count=0; count<pass; count++)
	 {
	 for(count2=0; count2<4; count2++)
	    {
	    result=DosWrite(
			pipe,
			(char far *) buf,
			sizeof(buf),
			&bytes);

	    if (result)
	       {
	       printf("\n DosWrite failed, return code = %d", result);
	       DosExit(EXIT_PROCESS, 1);
	       }
	    }



	 result =DosChgFilePtr(pipe,
	     0L,
	     FILE_BEGIN,
	     &ulFilePointer);

	 if(result)
	       {
	       printf("\n DosChgFilePtr failed, return code = %d", result);
	       DosExit(EXIT_PROCESS, 1);
	       }

	 }

      time(&tstop);
      tused = difftime(tstop, tstart);
      tperstep = tused / (double)count;
      printf("\nNo WRITE_THROUGH time per iteration: %f milliseconds\n", tperstep*1000.0);
      }
    DosClose(pipe);
    DosDelete(fname, 0L);

   }
