/******************************************************************
Description:    WordPerfect for Windows 5.1 Run Exec

Details:        This exec is used to run the WordPerfect for Windows program.

                It checks to see if the Local.Directory exists.
                If it doesn't the user is told to run the install.
                It also checks to make sure that OS/2 2.0 is
                running.  It sets all of WP's parameters to the
                Local.Directory for the creation of configuration
                and temp files

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    Must be run from the T: drive
   Directories: See PACKINST.CMD
   Window Type: FS/WIN
   App Title:   WordPerfect for Windows

Last Updated:  10/1/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXOS2VER',    'RXUTILS', 'RXOS2VER'

/* Give header */
say
say ' WordPerfect for Windows run exec'
say ' --------------------------------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/*****************************************/
/** Determine if OS/2 2.0 is being used **/
/*****************************************/

if (RxOS2Ver() < 2.0) then do
  say
  say d2c(7)|| 'Error!'
  say 'You must be using OS/2 2.0 or later in order to'
  say 'run WordPerfect for Windows.  Windows programs'
  say 'cannot be run on versions of OS/2 prior to 2.0'
  say
  call RxPause 'Press any key to exit'
  'exit 10'
end /* do */

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'WPWin')
if rxDirExist(Local.Directory)=0 then do
   say
   say d2c(7)|| ' Local WordPerfect for Windows directory not set.'
   say ' You must run the installation program.'
   say
   call RxPause 'Press any key to exit'
   'exit 10'
end  /* Do */

/************************************************************/
/** Set WP environment variables to create WordPerfect     **/
/** .INI and .SET and temp files in users' Local Directory **/
/** Run WordPerfect for Windows                            **/
/************************************************************/

say
say ' Please wait while WordPerfect for Windows is loaded.'
say '       ( This may take more than a minute )'
say
say ' Local directory = 'Local.Directory
say
say ' Once WordPerfect for Windows has started this window'
say ' will be hidden...'

'START HIDEWIN /D=20 WordPerfect for Windows'
Drive'\WPWIN\WPWIN /WPC-T:\WPC /D-'Local.Directory '/PI-'Local.Directory '/PS-'Local.Directory
'exit'
