/**********************************************************************
Description:    WordPerfect for Windows 5.1 Installation exec

Details:        This exec creates a local directory where work
                files can be saved.  It adds this information to
                OS2.INI.  It copies DDEML.DLL to the user's 
                \OS2\MDOS\WINOS2\SYSTEM subdirectory.  This file
                is required for WP to run.  When WP is installed
                on the server the \OS2... directory is created there.
                The file should then be copied to the \WPWIN51
                directory on the server.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: \WPWIN51-----+--\WPWIN\--+--WPWIN.EXE
                             |           +--WPWP_NET.INI
                             |           +--WP{WP}.SET
                             |           +--WP{WP}.ENV
                             |
                             +--\WPC\----+--SPWIN.EXE
                             |           +--THWIN.EXE
                             |           +--FMWIN.EXE
                             |           +--MCWIN.EXE
                             |           +--MXWIN.EXE
                             |           +--MFWIN.EXE
                             |           +--FM{FM}.ENV
                             |           +--SP{SP}.ENV
                             |           +--TH{TH}.ENV
                             |           +--WPC_NET.INI
                             |           +--WPFM_NET.INI
                             |           +--WPMF_NET.INI
                             |           +--WPMC_NET.INI
                             |           +--WPMX_NET.INI
                             |           +--WPSP_NET.INI
                             |           +--WPTH_NET.INI
                             |
                             +--\WPCINI\ (not used, old INI files)
                                   (moved to \WPC for network use)
                                        (see README.NET on Disk 1)

   Window Type: FS/Win
   App Title:   WordPerfect for Windows

Last Updated:   10/1/92
**********************************************************************/
 trace 'O'
 '@echo off'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXBOOTDRIVE', 'RXUTILS', 'RXBOOTDRIVE'
call RxFuncAdd 'RXDRIVEMAP',  'RXUTILS', 'RXDRIVEMAP'
call RxFuncAdd 'RXDRIVEINFO', 'RXUTILS', 'RXDRIVEINFO'
call RxFuncAdd 'RXOS2VER',    'RXUTILS', 'RXOS2VER'

/* Give header */
say
say ' WordPerfect for Windows 5.1 Installation exec'
say ' ---------------------------------------------'
say

parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)
bdr=RxBootDrive()

/*****************************************/
/** Determine if OS/2 2.0 is being used **/
/*****************************************/

if (RxOS2Ver() < 2.0) then do
  say
  say d2c(7)|| 'Error!'
  say 'You must be using OS/2 2.0 or later in order to'
  say 'run WordPerfect for Windows.  Windows programs'
  say 'cannot be run on versions of OS/2 less than 2.0'
  say
  call RxPause 'Press any key to exit'
  'exit 10'
end /* do */

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'WPWin')
if RxDirExist(Local.Directory)=1 then do
   say ' Current WordPerfect for Windows local directory = 'Local.Directory
   say
end  /* if RxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/****************************************************************/
/** Prompt user for Local Directory.  Do until a valid local   **/
/** drive is used.  Create the directory and add it to OS2.INI **/
/****************************************************************/

say
say ' Enter a local directory for your WordPerfect for Windows'
say ' work files; i.e. D:\WPWIN'
say ' Valid local Drives:' DrvMap
say

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call RxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'WPWin', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/**************************************************/
/** copy DLL file to user's Window's directory,  **/
/** required for WordPerfect for Windows to run. **/
/**************************************************/

'copy DDEML.DLL 'bdr'\OS2\MDOS\WINOS2\SYSTEM >NUL'

say
say ' WordPerfect for Windows is now ready to run.'
say ' A reboot is not required'
say
call RxPause
'exit 0'
