/******************************************************************

Description:    WordPerfect 5.0 Installation Exec.

Details:        This exec is used to install WordPerfect.

                Installation really only consists of asking the
                user for a local directory spec in which to
                store local files.  This info is stored in OS2.INI.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   None

Last Updated:   9/24/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXDRIVEMAP',  'RXUTILS', 'RXDRIVEMAP'
call RxFuncAdd 'RXDRIVEINFO', 'RXUTILS', 'RXDRIVEINFO'

say
say ' WordPerfect 5.0 Installation'
say ' ----------------------------'
say

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'WordPerfect')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'WORDPERFECT', 'WORKDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'WordPerfect', Local.Directory
      call RxOS2Ini , 'WORDPERFECT', 'WORKDIR', '$RXDEL'
   end
end

if rxDirExist(Local.Directory)=1 then do
   say ' Current WordPerfect 5.0 local directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Enter a local directory for your WordPerfect work files;'
say ' i.e. D:\WP50'
say ' Valid local Drives:' DrvMap
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'WordPerfect', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/* Give message */
say
say ' WordPerfect is now ready to run.'
say ' A reboot is not required.'
say
call RxPause
'exit'
