/******************************************************************

Description:    SPSS Run Exec.

Details:        This exec sets up the appropriate SPSS environment
                then executes SPSS.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    Always use same drive.
   Directories: DLLs and EXEs in current directory.
   Window Type: FS/Win
   App Title:   SPSS Statistics for OS/2

Last Updated:   9/24/92
******************************************************************/
'@echo off'
trace 'o'


/* Load externals */
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'


/* Get drive letter being used and set vars */
parse upper source . . drv
drv = left(drv,2)
env = 'OS2ENVIRONMENT'                /* Short Hand */
Session = 'SPSS Statistics for OS/2'  /* Session title (used by HIDEWIN) */


/* Give header */
say
say 'SPSS Statistics for OS/2'
say '------------------------'
say

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'SPSS')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'SPSS', 'WORKDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'SPSS', Local.Directory
      call RxOS2Ini , 'SPSS', 'WORKDIR', '$RXDEL'
   end
end

if rxDirExist(Local.Directory)=0 then do
   say
   say d2c(7)|| ' Local SPSS directory not set.'
   say ' You must run the installation program.'
   say
   call RxPause
   'exit 10'
end  /* Do */


say ' Local SPSS directory = 'Local.Directory
say

/** Give message that we are starting the program **/
say ' Starting the SPSS program.'
say ' This will take a few moments, please be patient.'
say
say ' Once SPSS has started, this window will be hidden.'
say ' This window must be present for SPSS to run.....'


/** Setup session and run SPSS **/
call value 'PATH',    drv'\;'value('PATH', ,env),  env
call value 'DPATH',   drv'\;'value('DPATH', ,env), env
call value 'SPSS',    drv'\',                      env
call value 'SPSSTMP', Local.Directory'\TEMP',      env
call directory Local.Directory
'start hidewin /D=10 'Session
'spsspm.exe'
'exit'
