/******************************************************************

Description:    SPM/2 Install Exec

Details:        This exec installs the SPM/2 package available on
                OS2PROD on a users machine.

                To do this, the following will be done:

                 - Ask the user for a local directory for storing
                   the SPM/2 files.

                 - Run the self-extracting PKZIP file to place the
                   files in the specified local directory.

                 - Run the SPM2INST program to setup CONFIG.SYS
                   with the appropriate device drivers and create
                   an SPM/2 PM group.

Dependencies:
   Externals:   RXUTILS.DLL  - See RXUTILS PACKAGE on OS2TOOLS.
   Drive(s):    None
   Directories: None
   Window Type: FS/Win
   App Title:   None

Author:         Thomas J. Rogers

Support Level:  Append questions to VENDOR FORUM.

******************************************************************/
trace 'O'
'@echo off'

/*************************************/
/** Load RxUtils external functions **/
/*************************************/
call RxFuncAdd 'RXSAY',           'RXUTILS', 'RXSAY'
call RxFuncAdd 'RXMKDIR',         'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXWRITE',         'RXUTILS', 'RXWRITE'
call RxFuncAdd 'RXGETKEY',        'RXUTILS', 'RXGETKEY'

if (rxOs2Ver() < 2.0) then do

/************************/
/** Give the user info **/
/************************/
   'cls'
   say
   say
   say 'VENDOR is about to install SPM/2 on your system.'
   say
   say 'Once installed, you may run SPM/2 WITHOUT running VENDOR'
   say 'by simply starting it from the SPM/2 Desktop Manager group'
   say 'that will be created by the installation process.'
   say
   'pause'

/**********************************/
/** Get dir to store SPM/2 files **/
/**********************************/
   do until RxDirExist(SpmDir)=1
     do until resp='Y'
       'cls'
       say
       call RxSay 'Enter drive and directory in which to install SPM/2 > '
       SpmDir = translate(linein('STDIN'))
       say
       call RxSay 'Install SPM/2 in the 'SpmDir' subdirectory?  (Y/N) > '
       do until resp='Y' | resp='N'
         resp = translate(RxGetKey('NOECHO'))
       end
       say resp
       if resp='Y' then do
          call MakeDir SpmDir
          if RxDirExist(SpmDir)=0 then do
            say d2c(7)
            say 'Directory specified could not be created.  Please try something else.'
            'pause'
          end
       end
     end
   end

/************************************************************/
/** Create the files by running self-extracting PKZIP file **/
/************************************************************/
   'SPM2 'SpmDir

/************************************/
/** Run SPM/2 installation program **/
/************************************/
   SpmDir'\SPMINST 'SpmDir

/***************/
/** Give info **/
/***************/
   say d2c(7)
   say
   say 'An SPM/2 group has been added to the Desktop Manager.'
   say 'You may run SPM/2 from there without having to use VENDOR.'
   say
   say 'Device drivers have been added to your CONFIG.SYS.'
   say 'You will have to reboot your system before SPM/2 will'
   say 'run properly.'
   say
   say 'Press any key to exit...'
   'pause>nul'
   'exit'
end
else do
   say
   say ' SPM/2 currently does not run on OS/2 2.0.  Nothing will'
   say ' be installed.  When a new version of SPM/2 which does run'
   say ' on OS/2 2.0 is available it will be announced in CORE NEWS.'
   say
   call RxPause
   'exit'
end  /* Do */

/**********************************************************
* MakeDir directory                                       *
*                                                         *
* Purpose:                                                *
*   This procedure will make a directory specification no *
*   matter how many directories deeep it might span,      *
**********************************************************/
MakeDir: procedure expose IC.
 parse upper arg dir
 do i=1 to length(dir)
  if right(left(dir,i),1)='\' then
    call RxMkDir(left(dir, i-1))
 end
 call RxMkDir dir
return




