/******************************************************************

Description:    IBM Prolog/2 Installation Exec.

Details:        Query user for name of local directory for
                 Prolog/2 files, create directory (if needed),
                 and record directory spec in OS2.INI.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/Win
   App Title:   None

Last Updated:   8/13/92
******************************************************************/
'@ECHO OFF'
trace 'o'

/* Load externals */
call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

/* Give header */
say
say ' IBM Prolog/2 Installation'
say ' -------------------------'
say

/* Setup a few vars */
parse source . . Drv
Drv = left(Drv,2)

/* Give current setting */
Local.Directory = RxOS2Ini(, 'Directories', 'PROLOG2')
if RxDirExist(Local.Directory)=1 then do
  say 'Current local directory = 'Local.Directory
end

/* Query user */
do forever
     say
     say ' Enter a local directory where your IBM Prolog/2 source files'
     say ' will be saved: '
     Local.Directory = linein('STDIN')
     if Local.Directory<>'' then do
       call rxMkDir Local.Directory
       if rxDirExist(Local.Directory) then do
          say
          say 'Storing local directory information for future reference...'
          say
          call RxOS2Ini , 'Directories', 'PROLOG2', Local.Directory
          leave
       end
     end
     say d2c(7)
     say ' Invalid Directory.  Please enter a valid directory.'
end  /* Do Forever */

say
say ' IBM Prolog/2 is ready to run on your PC.'
say
call RxPause
'exit'
