/******************************************************************
Description:    ObjectVision Run Exec

Details:        This exec is used to run the ObjectVision program.

                It checks to see if the Local.Directory exists.
                If it doesn't the user is told to run the install.
                It also checks to make sure that OS/2 2.0 is
                running.  The the Vendor path is added to the PATH
                statement, which is recommended in the README.TXT
                file.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    none
   Directories:
   Window Type: FS/WIN
   App Title:   ObjectVision

Last Updated    10/1/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2VER',    'RXUTILS', 'RXOS2VER'

/* Give header */
say
say ' ObjectVision Run exec'
say ' ---------------------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)
Env = 'OS2ENVIRONMENT'

/*****************************************/
/** Determine if OS/2 2.0 is being used **/
/*****************************************/

if (RxOS2Ver() < 2.0) then do
  say
  say d2c(7)|| ' Error!'
  say 'ObjectVision requires OS/2 2.0 or later in order to'
  say 'run.  It will not run on earlier versions of OS/2.'
  say
  call RxPause 'Press any key to exit.'
  'exit 10'
end /* do */

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'ObjectVision')
if rxDirExist(Local.Directory)=0 then do
   say
   say d2c(7)|| ' Local ObjectVision directory not set.'
   say ' You must run the installation program.'
   say
   call RxPause 'Press any key to exit'
   'exit 10'
end  /* Do */

/****************************************************/
/** Give message about using ObjectVision programs **/
/****************************************************/

say
say ' If you want to use the the sample and demo programs that'
say ' come with ObjectVision you will have to run them from the'
say ' SAMPLE subdirectory in your 'Local.Directory' directory.'
say ' If you try to run them from the Vendor drive ObjectVision'
say ' may hang and require that it be closed and restarted.  If'
say ' you did not initially choose to have these programs copied'
say ' locally, you can re-run the install program to copy them.'
say
call RxPause

/*********************************************/
/** Add ObjectVision path to PATH statement **/
/** recommended in README.TXT file          **/
/*********************************************/

call value 'PATH',  path';'||value('PATH',,Env), Env

/** Run ObjectVision **/
say
say ' Starting ObjectVision...'
say
say ' Please wait a moment while it is loaded.'
say '   ( This may take more than a minute )'
say
say ' Local directory = 'Local.Directory
say
say ' Once ObjectVision has started this window will be hidden.'
'START HIDEWIN /D=20 ObjectVision'
'vision'
'exit'
