/******************************************************************
Description:    ObjectVision Installation exec

Details:        This exec creates a local directory where work
                files can be saved.  It adds this information to
                OS2.INI.  It also asks the user if he or she wants
                to copy the sample and demo programs locally.  This
                is necessary for them to run.  They will not run
                if started from the Vendor drive.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/Win
   App Title:   ObjectVision

Last Updated    10/1/92
******************************************************************/
 trace 'O'
 '@echo off'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXDRIVEMAP',  'RXUTILS', 'RXDRIVEMAP'
call RxFuncAdd 'RXDRIVEINFO', 'RXUTILS', 'RXDRIVEINFO'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXOS2VER',    'RXUTILS', 'RXOS2VER'

parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/* Give header */
say
say ' ObjectVision Installation exec'
say ' ------------------------------'
say

/*****************************************/
/** Determine if OS/2 2.0 is being used **/
/*****************************************/

if (RxOS2Ver() < 2.0) then do
  say
  say d2c(7)||' Error!'
  say 'ObjectVision requires OS/2 2.0 or later in order to'
  say 'run.  It will not run on earlier versions of OS/2.'
  say
  call RxPause 'Press any key to exit.'
  'exit 10'
end /* do */

/***********************************************/
/** Check if a Local.Directory already exists **/
/***********************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'ObjectVision')
if RxDirExist(Local.Directory)=1 then do
   say ' Current ObjectVision local directory = 'Local.Directory
   say
end  /* if RxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Enter a local directory for your ObjectVision work files;'
say ' i.e. D:\OBVISION'
say ' Valid local Drives:' DrvMap
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call RxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'ObjectVision', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/*******************************************************************/
/** Ask user if sample and Demo programs should be copied locally **/
/*******************************************************************/

say
say ' ObjectVision comes with several sample and demo programs.'
say ' In order to use them they must be copied to your hard'
say ' disk.  If you try to use the sample files from the Vendor'
say ' drive, ObjectVision will hang and then close itself.  The'
say ' files take up about 287KB of disk space.  If you choose'
say ' to copy the files to your hard disk a SAMPLE subdirectory'
say ' will be created under 'Local.Directory'.'
say
say ' Do you want to copy the sample programs to your.'
say ' hard disk? (Y/N)'
say

do until conv='Y' | conv='N'
   conv = translate(left(linein(STDIN),1))
end  /* do until... */

if (conv='Y') then do
  call RxMkDir Local.Directory'\sample'
  'copy 'path'sample\*.*' Local.Directory'\sample\ >NUL'
end

say
say 'ObjectVision is now ready to run.'
say 'A reboot is not required.'
call RxPause
'exit 0'
