/******************************************************************

Description:    Molecular Presentation Graphics install exec

Details:        This exec is used to install MPG.

                Installation consists of asking the user for a
                local directory spec in which to store local
                files.  This info is stored in OS2.INI.  It also
                copies several font files to the local directory.
                these files total approxiamately 22kb.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    Must be run from same drive to preserve path
                information for layouts and macros.
   Directories: font files must be copied to the local directory.
                copied locally in order to be edited.
   Window Type: FS/WIN
   App Title:   None

Last Updated:   12/10/91
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

say
say ' Molecular Presentation Graphics '
say ' ------------------------------- '
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/***************************************************************/
/** Check if a Local.Directory already exists.  If not, check **/
/** old format and if it exists convert to new format.        **/
/***************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'MPG')
if rxDirExist(Local.Directory)=1 then do
   say ' Current Molecular Presentation Graphics directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Enter a local directory where your Molecular Presentation'
say ' Graphics files will be saved. i.e. C:\MPG'
say ' Valid local Drives:' DrvMap
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'MPG', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/** copy necessary files to local directory **/
'copy 'path'*.mft 'Local.Directory

/* Give message */
say
say ' Molecular Presentation Graphics is now ready to run.'
say ' You do not have to reboot.'
say
call RxPause

'exit'
