/******************************************************************

Description:    IBM C/2 Compiler Run Exec.

Details:        This exec sets up the appropriate IBM C/2 envir.
                It reads defaults from OS2.INI regarding what
                components should be included when setting up
                the environment.

                This exec also sets up the appropriate OS/2
                Programmer's Toolkit environment.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
                PMBROWSE.EXE - Part of VENDOR package.
   Drive(s):    See install exec for this package.
   Directories: See install exec for this package.
   Window Type: FS/Win
   App Title:   None

Last Updated:   6/17/92
******************************************************************/
 trace 'o'
 '@echo off'

/* Add external funcs */
 call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

/* Check the OS2.INI for toolkit information */
 File = 'USER'
 App = 'IBMC2'
 Toolkit = 'Toolkit'
 TCPIP = 'TCPIP'
 TCPIPR3 = 'TCPIPR3'
 TCPIPR0 = 'TCPIPR0'
 SQLLIB  = 'SQLLIB'
 OS2='OS2ENVIRONMENT'

/* Query OS2.INI */
  CurTKver  =RxOs2Ini(File,  App, Toolkit)
  LinkTCP   =RxOs2Ini(File,  App, TCPIP)
  LinkTCPR3 =RxOs2Ini(File,  App, TCPIPR3)
  LinkTCPR0 =RxOs2Ini(File,  App, TCPIPR0)
  LinkSQL   =RxOs2Ini(File,  App, SQLLIB )

/* Information not found so call the Ini program */
 if CurTKver = '$RXERROR' | LinkTCP = 'Y' then do
   call AskUser
   CurTKver=RxOs2Ini(File, App, Toolkit)
   LinkTCPR3 =RxOs2Ini(File,  App, TCPIPR3)
   LinkTCPR0 =RxOs2Ini(File,  App, TCPIPR0)
   LinkSQL=RxOs2Ini(File,  App, SQLLIB )
 end

/* Set up the PATH and LIB PATH strings */
 parse source . . exec
 Cdr=left(exec, lastpos('\', exec))
 Netdr=Cdr'NETSRC\'
 TKdr=Cdr''CurTKver'\'

/* Test if SQLLIB libraries should be included in LIB PATH */
 if left(LinkSQL,1) = 'Y' then
   SQLdr=Cdr'SQLLIB;'
 else
   SQLdr=''

/* Test if TCPIP r3 libraries should be included in LIB PATH */
 if left(LinkTCPR3,1) = 'Y' then do
   COREdr=value('CORE.DRIVE',,OS2)     /* Usually W:\ */
   TCPdr=COREdr'TCPIP\LIB;'
 end
 else
   TCPdr=''

/* Test if TCPIP r0 libraries should be included in LIB PATH */
 if left(LinkTCPR0,1) = 'Y' then do
   COREdr=value('CORE.DRIVE',,OS2)     /* Usually W:\ */
   TCPdr=COREdr'TCPIPR0\LIB;'
 end
 else
   TCPdr=''

/* Setup C drive for IBMC2\ path statements */
 Cdr=Cdr'IBMC2\'

/* Test what version of the Programming Reference is required */
 if CurTKver = 'TOOLKT12' then
   progref = 'PRINTRO.INF+PRCP.INF+PRGPI.INF+PRWIN.INF+PRDATA.INF'
 else if CurTKver = 'TOOLKT13' then
   progref = 'PRINTRO.INF+PRCP.INF+PRGPIFN.INF+PRWINFN.INF+PRDATA.INF'
 else       /* TOOLKT11 has no online progref */
   progref = ''

 say; say 'Setting up IBM C/2 environment for this session...'
 say '  Setting up OS/2 Programming Tools and Information Toolkit Ver ',
 right(CurTKver,2)/10'...'
 if LinkTCPR0='Y' then say '  Setting up TCP/IP Ring 0 Library...'
 if LinkTCPR3='Y' then say '  Setting up TCP/IP Ring 3 Library...'
 if LinkSQL='Y' then say '  Setting up SQL Library and Headers...'

 'call pmbrowse copyrite.ibm'    /* Display copyright notice */
                                 /* Required for legal reasons */

 oldpath = value('PATH',,OS2)
 newpath = Cdr'BINP;'Cdr'BIN;'TKdr'BIN;'oldpath
 oldhelp = value('HELP',,OS2)
 newhelp = TKdr'DM;'TKdr'DTL;'TKdr'BIN;'oldhelp
 oldbook = value('BOOKSHELF',,OS2)
 newbook = TKdr'PROGREF;'oldbook
 oldlib  = value('LIB',,OS2)
 lib     = Cdr'LIB;'TKdr'LIB;'Netdr'LIB;'TCPdr||SQLdr'C:\OS2;'oldlib
 OldINC = value('INCLUDE',,OS2)
 inc     = Cdr'INCLUDE;'TKdr'C\INCLUDE;'Netdr'H;'TCPdr||SQLdr||OldInc
 ipf     = TkDr'IPFC'

 call value 'BOOKSHELF', newbook, OS2
 call value 'HELP',      newhelp, OS2
 call value 'PATH',      newpath, OS2
 call value 'LIB',       lib,     OS2
 call value 'INCLUDE',   inc,     OS2
 call value 'PROGREF',   progref, OS2
 call value 'IPFC',      ipf,     OS2
 call value 'C.DRIVE',   left(Cdr,2), OS2
 if value('TMP',,OS2)='' then do
   'if not exist c:\temp\nul md c:\temp>nul'
   call value 'TMP',  'C:\TEMP', OS2
 end
 say 'Done'; say
 if curTKver \= 'TOOLKT11' then
   say 'To view the on-line OS/2 Programming Ref, execute:  VIEW PROGREF'

 exit 0


AskUser:
 call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

  File = 'USER'
  App = 'IBMC2'
  Toolkit = 'Toolkit'
  TCPIP   = 'TCPIP'
  TCPIPR3 = 'TCPIPR3'
  TCPIPR0 = 'TCPIPR0'
  SQLLIB  = 'SQLLIB'

  CurTKver  =RxOs2Ini(File,  App, Toolkit)
  LinkTCP   =RxOs2Ini(File,  App, TCPIP)
  LinkTCPR3 =RxOs2Ini(File,  App, TCPIPR3)
  LinkTCPR0 =RxOs2Ini(File,  App, TCPIPR0)
  LinkSQL   =RxOs2Ini(File,  App, SQLLIB )
  if LinkTCP='Y' then
     call RxOs2Ini File,  App, TCPIP, '$RXDEL'

  if CurTKver <> '$RXERROR' then do
    Ver=right(CurTKver,1)
    say 'Current OS/2 Programming Toolkit: 1.'Ver
    if left(LinkTCP,1) = 'Y' then
       say 'Link to TCPIP Libraries: Yes'
    else if left(LinkTCPR3,1) = 'Y' then
       say 'Link to TCPIP Ring 3 Libraries: Yes'
    else if left(LinkTCPR0,1) = 'Y' then
       say 'Link to TCPIP Ring 0 Libraries: Yes'
    else
       say 'Link to TCPIP Libraries: No'
    if left(LinkSQL,1) = 'Y' then
       say 'Link with SQL support: Yes'
    else
       say 'Link with SQL support: No'
    say;
    say 'You can choose to change the current settings or accept them.'
    say;
  end

  say 'IBM C/2 can link your applications with any of the following'
  say 'Programming Toolkits:'
  say '     1. IBM OS/2 Programming Tools and Information Ver 1.1'
  say '     2. IBM OS/2 Programming Tools and Information Ver 1.2'
  say '     3. IBM OS/2 Programming Tools and Information Ver 1.3'
  say;
  say 'Choose which toolkit you want to link your applications with:'
  do until WhichTK='1' | WhichTK='2' | WhichTK='3'
    WhichTK = left(linein(STDIN),1)
  end

  LinkTCPR0 = 'N'
  LinkTCPR3 = 'N'
  say
  say 'If you are writing TCP/IP applications you will want to link with'
  say 'TCP Libraries.'
  say 'Do you want to include the TCPIP libraries in the LIB path? (Y/N)'
  do until LinkTCP='Y' | LinkTCP='N'
    LinkTCP = translate(left(linein(STDIN),1))
  end
  if LinkTCP = 'Y' then do
    say
    say 'Would you like to link TCP/IP Ring 0 or Ring 3 libraries:'
    say '   1. TCPIP Ring 0 Libraries'
    say '   2. TCPIP Ring 3 Libraries'
    say 'Choose which library you want to link your applications with:'
    do until WhichLib='1' | WhichLib='2'
      WhichLib = left(linein(STDIN),1)
    end
    if WhichLib = '1' then
      LinkTCPR0 = 'Y'
    else
      LinkTCPR3 = 'Y'
  end

  say
  say'If you are writing Query Manager applications you will want to'
  say 'link with the SQL Libraries and header files.'
  say 'Do you want to include the SQL libraries and headers? (Y/N)'
  do until LinkSQL='Y' | LinkSQL='N'
    LinkSQL = translate(left(linein(STDIN),1))
  end

  CurTKver = 'TOOLKT1'WhichTK

  call RxOs2Ini File, App, TCPIPR0, LinkTCPR0
  call RxOs2Ini File, App, TCPIPR3, LinkTCPR3
  call RxOs2Ini File, App, SQLLIB,  LinkSQL
  call RxOs2Ini File, App, Toolkit, CurTKver

  say
  say 'IBMC2 Toolkit version, TCPIP and SQL link access saved.'
return
