/******************************************************************

Description:    IBM C/2 Compiler Install Exec.

Details:        This really just prompts the user for information
                 about how the IBMC/2 Compiler environment
                 should be setup.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    TCPIP lib and include files on W: drive.  Change this
                if needed.
   Directories:  \--+--\IBMC2--+--\BIN
                    |          |
                    |          +--\BINP
                    |          |
                    |          +--\BINR
                    |          |
                    |          +--\INCLUDE--+--\MT
                    |          |            |
                    |          +--\LIB      +--\SYS
                    |          |
                    |          +--\SRC
                    |
                    |
                    +--\NETSRC--+--\H
                    |           |
                    |           +--\LIB
                    |
                    +--\SQLLIB
                    |
                    +--\TOOLKT*--\  Normal Toolkit dir struct

   Window Type: FS/Win
   App Title:   None

Last Updated:   6/17/92
******************************************************************/
trace 'O'
'@echo off'

/* Give header */
say;
say 'Configuration for IBM C/2 Programming Environment'
say '-------------------------------------------------'
say;

/* Get user options */
call AskUser

/* Give completed message */
say
say 'IBMC2 is ready to execute.  A reboot is not required.'
say 'Press any key at the Vendor Continue... Panel and OK to run'
say 'the IBMC2 Programming environment now.'
say
'pause'
'exit'




/*** Procedure for asking user for options ***/
AskUser:
 call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

  File = 'USER'
  App = 'IBMC2'
  Toolkit = 'Toolkit'
  TCPIP   = 'TCPIP'
  TCPIPR3 = 'TCPIPR3'
  TCPIPR0 = 'TCPIPR0'
  SQLLIB  = 'SQLLIB'

  CurTKver  =RxOs2Ini(File,  App, Toolkit)
  LinkTCP   =RxOs2Ini(File,  App, TCPIP)
  LinkTCPR3 =RxOs2Ini(File,  App, TCPIPR3)
  LinkTCPR0 =RxOs2Ini(File,  App, TCPIPR0)
  LinkSQL   =RxOs2Ini(File,  App, SQLLIB )
  if LinkTCP='Y' then
     call RxOs2Ini File,  App, TCPIP, '$RXDEL'

  if CurTKver <> '$RXERROR' then do
    Ver=right(CurTKver,1)
    say 'Current OS/2 Programming Toolkit: 1.'Ver
    if left(LinkTCP,1) = 'Y' then
       say 'Link to TCPIP Libraries: Yes'
    else if left(LinkTCPR3,1) = 'Y' then
       say 'Link to TCPIP Ring 3 Libraries: Yes'
    else if left(LinkTCPR0,1) = 'Y' then
       say 'Link to TCPIP Ring 0 Libraries: Yes'
    else
       say 'Link to TCPIP Libraries: No'
    if left(LinkSQL,1) = 'Y' then
       say 'Link with SQL support: Yes'
    else
       say 'Link with SQL support: No'
    say;
    say 'You can choose to change the current settings or accept them.'
    say;
  end

  say 'IBM C/2 can link your applications with any of the following'
  say 'Programming Toolkits:'
  say '     1. IBM OS/2 Programming Tools and Information Ver 1.1'
  say '     2. IBM OS/2 Programming Tools and Information Ver 1.2'
  say '     3. IBM OS/2 Programming Tools and Information Ver 1.3'
  say;
  say 'Choose which toolkit you want to link your applications with:'
  do until WhichTK='1' | WhichTK='2' | WhichTK='3'
    WhichTK = left(linein(STDIN),1)
  end

  LinkTCPR0 = 'N'
  LinkTCPR3 = 'N'
  say
  say 'If you are writing TCP/IP applications you will want to link with'
  say 'TCP Libraries.'
  say 'Do you want to include the TCPIP libraries in the LIB path? (Y/N)'
  do until LinkTCP='Y' | LinkTCP='N'
    LinkTCP = translate(left(linein(STDIN),1))
  end
  if LinkTCP = 'Y' then do
    say
    say 'Would you like to link TCP/IP Ring 0 or Ring 3 libraries:'
    say '   1. TCPIP Ring 0 Libraries'
    say '   2. TCPIP Ring 3 Libraries'
    say 'Choose which library you want to link your applications with:'
    do until WhichLib='1' | WhichLib='2'
      WhichLib = left(linein(STDIN),1)
    end
    if WhichLib = '1' then
      LinkTCPR0 = 'Y'
    else
      LinkTCPR3 = 'Y'
  end

  say
  say'If you are writing Database Manager applications you will want to'
  say 'link with the SQL Libraries and header files.'
  say 'Do you want to include the SQL libraries and headers? (Y/N)'
  do until LinkSQL='Y' | LinkSQL='N'
    LinkSQL = translate(left(linein(STDIN),1))
  end

  CurTKver = 'TOOLKT1'WhichTK

  call RxOs2Ini File, App, TCPIPR0, LinkTCPR0
  call RxOs2Ini File, App, TCPIPR3, LinkTCPR3
  call RxOs2Ini File, App, SQLLIB,  LinkSQL
  call RxOs2Ini File, App, Toolkit, CurTKver

  say
  say 'IBMC2 Toolkit version, TCPIP and SQL link access saved.'
return
