/******************************************************************
Description:    Freelance 4.0 Run Exec

Details:        This exec determines which version of OS/2 is
                running.  If OS/2 2.0 is running, the program
                FL.COM is started directly.  If an earlier version
                is running, it calls the DOSEXE.EXE program to
                execute the Freelance 4.0 program, FL.COM, from 
                within the DOS box.

                Parameters to the DOSEXE.EXE program are actually
                commands to be run in the DOS box.

                The exec also asks the user what local directory
                was created by FLINSTAL, and stores said info in
                OS2.INI where the Freelance Run exec may get it.

                This exec also uses GIME to assign the LOTUSLOT
                license alias.  It also uses GIME to determine the
                UNC name of the resource in use.  This UNC name is
                required in the PATHFILE file contained in the
                FLGDOS.V40 subdirectory of the license alias.
                Since this UNC name can be random (due to Vendor's
                dynamic licensing) the PATHFILE file is created
                or updated every time a user executes this exec.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
                HIDEWIN.EXE  - Part of VENDOR package.
                SWITCHTO.EXE - Part of VENDOR package.
                DOSEXE.EXE   - Part of VENDOR package.
                GIME.EXE     - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/Win
   App Title:   Freelance 4.0 (Dos)

Last Updated:   10/13/92
******************************************************************/
trace 'O'
'@echo off'

/*******************************************/
/** Give greetings messages               **/
/*******************************************/
say;
say 'Freelance 4.0 (DOS)'
say '-------------------'; say

/***************************************/
/** Initialize vars that might change **/
/***************************************/
PreApp  = ''                     /* Set COM1 for Plotter in DOS Box */
PostApp = ''                     /* Reset COM1 for Plotter in OS/2 */
App     = 'FL.COM'               /* Dos application to run          */
Params  = '/S'                   /* Parameters to DOS app (if any)  */
Opt     = 'L'                    /* Large memory option for OS/2 2.0 */
Session = 'Freelance 4.0 (DOS)'  /* Session title (used by HIDEWIN) */

/*******************************************/
/** Initialze vars that will never change **/
/*******************************************/
call RxFuncAdd 'RXCLS',       'RXUTILS', 'RXCLS'
call RxFuncAdd 'RXSAY',       'RXUTILS', 'RXSAY'
call RxFuncAdd 'RXGETKEY',    'RXUTILS', 'RXGETKEY'
call RxFuncAdd 'RXDELETE',    'RXUTILS', 'RXDELETE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'

parse upper source . . fspec              /* Get full exec fspec   */
Dir = left(fspec, lastpos('\', fspec)-1)  /* Get full dir name     */
Drive = left(fspec,2)                     /* Get the drive letter  */
SemFile = RxBootDrive()'\$DOSSEM.$$$'     /* DOS semaphore file    */
LocDir = RxOS2Ini(, 'Directories', 'FLV4')
if LocDir='$RXERROR' then do
 say d2c(7)
 say 'You must run the Freelance installation program before'
 say 'running Freelance.'; say
 call RxPause
 'EXIT'
end
LocDrive=Left(LocDir, 2)
Unc = GetUncName(Drive)        /* Get Unc File name */
Lic = AssignLicenseDrive()     /* Assign license alias */
if Unc='' || Lic='' then do
 say;
 say 'An error was encountered setting up the Freelance environment.'
 say 'Please append this problem to the CORE FORUM.'; say
 call RxPause
 'EXIT'
end


/******************************************************/
/** Check to see if Freelance can run on this        **/
/** system.                                          **/
/******************************************************/

if (rxOs2Ver() < 2.0) then do
  'QINETR /Q'
  if (rc = 3) then do
     say 'Error!  Ring 0 TCP/IP detected.  Freelance will not'
     say 'work.'
     call RxPause
     exit 10
  end
end


stem.0=1; stem.1=Unc
call RxWrite Lic'\FLGDOS.V40\PATHFILE.', 'STEM.'
say; say 'Local directory is 'LocDir
say 'Starting Freelance in the DOS Box...'; say
say '    [ Symbol libraries located in:  'Drive'\SYMBOLS]'
say '    [ IBM Hardware Symbol library located in:  'Drive'\FL_IBM]'
say

COMport = RxOS2Ini(, 'FLCOMPORT', 'ACTIVE')
if COMport<>'$RXERROR' then do
   PreApp='SETCOM40 'COMport'=ON'
   PostApp='SETCOM40 'COMport'=OFF'
   say 'The DOS Box will be configured for 'COMport'...'
end

/******************************************************/
/** Stay in this loop until the user aborts or until **/
/** the DOS program is run successfully.             **/
/******************************************************/

if (rxOs2Ver() < 2.0) then do
do forever
  call RxDelete SemFile
  'START HIDEWIN 'Session
  'DOSEXE 'LocDrive' "CD 'LocDir'" "'PreApp'" "'App Params'" "'PostApp,
          '"'RxBootDrive()' "ECHO Do Not Delete>'SemFile'"'
   /***************************************************/
   /** If the RC is 0 then wait for the DOS exec to  **/
   /** finish.  The DOS exec will be finished when   **/
   /** the semaphore file exists.                    **/
   /***************************************************/
   if RC=0 then do
     say 'Waiting for DOS app to end...'
     do forever
       if RxFileExist(SemFile)=1 then do
         do while RxDelete(SemFile)<>0   /* Loop until file can be deleted */
            Nop
         end
         leave
       end
     end
     leave
   end
   /***************************************************/
   /** If the RC is not 0 then an error occurred.    **/
   /** Tell the user and give them a chance to abort **/
   /** the program.                                  **/
   /***************************************************/
   else do
    'START HIDEWIN /S 'Session
     call RxCls
     say D2C(7)
     say 'ERROR - Could not start a program in the DOS box.'; say
     say 'Possible causes of failure:'
     say '  1)  There is no DOS box.'
     say '  2)  A program is already active in the DOS box.'
     say '  3)  DOS.SYS device driver not loaded via CONFIG.SYS.'; say
     resp = YesNoPrompt('Would you like to try again')
     if resp='N' then do
       say 'Aborted at your request.'
       leave
     end
   end
end
end
else do
  LocDrive
  'CD' LocDir
  'START HIDEWIN 'Session'>NUL 2>&1'
  App Opt
end
'GIME LOTUSLOT /D>NUL 2>&1'
'EXIT'



/**************************************************/
/** GetUncName(Drive)                            **/
/**                                              **/
/** Uses GIME to determine the UNC Name for a    **/
/** particular LAN attached drive.               **/
/**                                              **/
/** The drive letter is returned.                **/
/**************************************************/
GetUncName: procedure
parse arg Drive .
do queued(); pull .; end
'GIME 'Drive' | RXQUEUE'
parse pull line with 'The netname 'Unc .
return Unc



/**************************************************/
/** AssignLicenseDrive()                         **/
/**                                              **/
/** Uses GIME to attach the LOTUSLOT alias as a  **/
/** drive.                                       **/
/**                                              **/
/** Requires a NETALIAS.LST in users DPATH       **/
/** which contains a LOTUSLOT alias definition   **/
/** which points to the LOTUSLOT alias on some   **/
/** server.  See GIME documentation if needed.   **/
/**                                              **/
/** The drive letter is returned.                **/
/**************************************************/
AssignLicenseDrive: procedure
do queued(); pull .; end
call RxSay 'Assigning license drive...'
'GIME LOTUSLOT | RXQUEUE'
parse pull line 'The netname' . 'assigned to drive 'Drive .
if Right(Drive,1)=':' then
  say 'Done.'
else
  say d2c(7)'Error!'
return Drive



/**************************************************/
/** YesNoPrompt(prompt)                          **/
/**                                              **/
/** Procedure which excepts a prompt and prompts **/
/** the user for a Y/N response.                 **/
/**************************************************/
YesNoPrompt: procedure
parse arg prompt
call RxSay prompt||' [Y/N] > '
do until resp='Y' | resp='N'
   resp = translate(RxGetKey('NOECHO'))
   if resp<>'Y' & resp<>'N' then call RxSay D2C(7)
end
say resp
return resp
