/******************************************************************

Description:    Microsoft Excel v3.0 Run Exec.

Details:        This exec is used to run Excel v3.0.

                This exec will check to see that Excel has already
                been installed by looking for the EXCEL.INI file
                the user's C:\OS2 subdirectory.  They are DE.INI
                Whenever Excel is run this exec will query the Vendor
                drive letter and overlay it in the Init Commands,
                solver application key in EXCEL.INI.  The user will
                also be asked if he or she wants to start any of
                Excel's companion programs.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
                
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   Excel

Last Updated:   9/23/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXPAUSE',     'RXUTILS', 'RXPAUSE'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'
call RxFuncAdd 'RXBOOTDRIVE' ,'RXUTILS', 'RXBOOTDRIVE'

/* Give header */
say
say ' Starting Excel Run Exec'
say ' -----------------------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)
BootDrive = RxBootDrive()
IniFile = 'BootDrive\OS2\EXCEL.INI'

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'Excel')

if rxFileExist(BootDrive'\os2\excel.ini')=0 then do
   say
   say d2c(7)|| ' Excel is not properly installed.'
   say ' You must run the installation program.'
   say
   call RxPause
   'exit 10'
end  /* Do */

/*****************************************************************/
/** Overlay drive letter in Excel.ini with current Vendor drive **/
/*****************************************************************/

if RxFileExist(IniFile)=1 then do
  Data = rxOS2Ini(IniFile,'Init Commands','solver')
  P.1 = pos('\EXCEL30\', Data) - 2
  if P.1 > 0 then do
    Data = overlay(Drive, Data, P.1, 2)
    call rxOs2Ini IniFile, 'Init Commands','solver',Data
  end  /* if P.1 */
end  /* if then  */

/** Run Excel **/
say
say ' Starting Excel...'
say
say ' Please wait a moment while Excel is loaded.'
say '       ( This may take a more than a minute )'
say
say ' Once Excel has started this window will be hidden.'
'START HIDEWIN /D=20 Excel'
'EXCEL'
'exit'
