/******************************************************************

Description:    Microsoft Excel v3.0 Install Exec.

Details:        This exec is used to setup Excel v3.0.

                This exec will prompt the user for a local directory
                in which to store work files.  This directory spec
                is stored in OS2.INI.  Two configuration files will
                be copied to the user's BootDrive\OS2 subdirectory.
                They are DE.INI and EXCEL.INI, which are created on.
                the machine installing Excel.  These should be
                copied to the Excel directory on the Vendor server.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   Excel

Last Updated:   4/30/92
******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RXDIREXIST',  'RXUTILS', 'RXDIREXIST'
call RxFuncAdd 'RXMKDIR',     'RXUTILS', 'RXMKDIR'
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'
call RxFuncAdd 'RXFILEEXIST', 'RXUTILS', 'RXFILEEXIST'
call RxFuncAdd 'RXDRIVEINFO' ,'RXUTILS', 'RXDRIVEINFO'
call RxFuncAdd 'RXBOOTDRIVE' ,'RXUTILS', 'RXBOOTDRIVE'
call RxFuncAdd 'RXDRIVEMAP' , 'RXUTILS', 'RXDRIVEMAP'


/* Give header */
say
say ' Starting Excel Installation Exec'
say ' --------------------------------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)
BootDrive = RxBootDrive()
IniFile = 'BootDrive\OS2\EXCEL.INI'

/***************************************************************/
/** Check if a Local.Directory already exists.  If not, check **/
/** old format and if it exists convert to new format.        **/
/***************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'Excel')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'Excel', 'LOCALDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'Excel', Local.Directory
      call RxOS2Ini , 'Excel', 'LOCALDIR', '$RXDEL'
   end
end

if rxDirExist(Local.Directory)=1 then do
   say ' Current Excel local directory = 'Local.Directory
   say
end  /* if rxDirExist... */

/***************************************************************/
/** Get the valid local drives, remove the VDISK, prompt user **/
/***************************************************************/

DrvMap = RxDriveMap('C:', 'LOCAL' )
parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

/********************************************************/
/** Prompt user for Local Directory.  Do until a valid **/
/** local drive is used.                               **/
/********************************************************/

say
say ' Enter a local directory where your Excel files will be saved:'
say ' Valid local Drives:' DrvMap
say

/*****************************************************/
/** Create Local Directory.  Add entry to OS2.INI.  **/
/*****************************************************/

OK=0
do until OK=1
   Local.Directory = translate( LINEIN('STDIN') )
   if POS( left(Local.Directory,2), DrvMap) <> 0 then
      OK=1
   else do
      say
      say d2c(7)||' Cannot create directory.  Try again...'
      say
      OK=0
   end /* do */
   if OK=1 then do
      if Local.Directory<>'' then do
         call rxMkDir Local.Directory
         if RxDirExist(Local.Directory) then
            call RxOS2Ini , 'Directories', 'Excel', Local.Directory
         if RxDirExist(Local.Directory)=0 then do
            OK=0
            say
            say d2c(7)||' Cannot create directory.  Try again...'
            say
         end  /* do */
      end /* do */
   end /* do */
end /* do until */

/*****************************************************/
/** Copy Excel ini files to bootdrive\os2 directory **/
/*****************************************************/

if RxFileExist(IniFile)=0 then do
  say 'Two configuration files will be copied to'
  say 'your 'BootDrive'\OS2 subdirectory.'
  'copy 'path'excel.ini 'BootDrive'\os2'
  'copy 'path'qe.ini 'BootDrive'\os2'
end

say
say ' Excel is now ready to run.  A reboot is not required'
say

call RxPause
'exit'
