/******************************************************************

Description:    IBM EASEL Run Exec.

Details:        This exec sets up the proper Easel environment.

                It gets local directory info from OS2.INI where
                the install program placed it.

Dependencies:
   Externals:   RXUTILS.DLL - RXUTILS package on OS2TOOLS.
   Drive(s):    User must always use same drive.
   Directories: Assumes DLLs and EXEs in root directory of
                 assigned drive.
   Window Type: FS/Win
   App Title:   None

Last Updated:   4/2/91
******************************************************************/
trace 'O'
'@echo off'

/* Add external functs */
call RxFuncAdd 'RXCLS',      'RXUTILS', 'RXCLS'
call RxFuncAdd 'RXOS2INI',   'RXUTILS', 'RXOS2INI'


/* Give header */
say
say ' IBM EASEL ver 1.10'
say ' ------------------'
say


/* Get/set variables */
parse source . . exec
Env      = 'OS2ENVIRONMENT'
Edr      = left(exec, lastpos('\', exec))
oldpath  = value('PATH',,Env)
olddpath = value('DPATH',,Env)
newpath  = Edr';'oldpath
newdpath = Edr';'olddpath
LocalDir = RxOS2Ini(, 'EASEL', 'WORKDIR')


/* Quit if local dir not found */
if RxDirExist(LocalDir)=0 then do
  say d2c(7)
  say ' Easel is not properly configured.'
  say
  say ' Possible problems:'
  say
  say '   - You have not yet run the Easel Installation program.'
  say '   - Local Easel directory information is not in OS2.INI.'
  say '   - Your local Easel directory no longer exists.'
  say
  say ' Please run the Easel Installation program...'
  say
  'pause'
  'exit'
end


/* Perform setup */
say ' Setting up IBM EASEL V1.1 environment for this session...'
say
say ' Local directory = 'LocalDir
say
call value 'PATH',  newpath,  Env
call value 'DPATH', newdpath, Env
say ' Done.  You may run Easel now!'
say

exit
