/******************************************************************

Description:    DisplayWrite 5-2 Run Exec.

                This file asks the user whether or not they want
                to start Composer and then starts DisplayWrite.
Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/WIN
   App Title:   DisplayWrite 5/2

Last Updated:   9/23/91
******************************************************************/
trace 'O'
'@echo off'

/* Load external funcs */
call RxFuncAdd 'RXOS2INI',    'RXUTILS', 'RXOS2INI'

/* Init vars */
parse source . . exec
Cdr=left(exec, lastpos('\', exec))
Cdr=left(Cdr,1)

Local.Directory = RxOS2Ini(, 'Directories', 'DW5/2')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'DisplayWrite', 'Local Directory')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'DW5/2', Local.Directory
      call RxOS2Ini , 'DisplayWrite', 'Local Directory', '$RXDEL'
   end
end

/***************************************************************************/
/** Check if Local Directory exists, if not tell user to run installation **/
/***************************************************************************/

Local.Directory = RxOS2Ini(, 'Directories', 'DW5/2')

if rxDirExist(Local.Directory)=0 then do
   say
   say d2c(7)|| ' Local DisplayWrite directory not set.'
   say ' You must run the installation program.'
   say
   RxPause
   exit 10
end  /* Do */

/* Give header */
say
say
say  'DisplayWrite'
say  '------------'; say


say 'DisplayWrite 5-2 has the option to run with Composer.'
say
say 'Do you want to run Composer (Y/N)?'
do until composer='Y' | composer='N'
    composer = translate(left(linein(STDIN),1))
end

if (composer = 'N') then do
     say; say 'Program loading; please wait.'
     'CD \DW5-2'
     'DW52A113.EXE 'Local.Directory'\PROFILE.PRF,'Local.Directory',A'
end
else do
     say; say 'Program loading; please wait.'
     'SET FONT='Cdr':\DW5F'
     'SET INSTALL='Local.Directory
     'SET PP='Cdr':\DW5-2C'
     'CD \DW5-2'
     'MH.EXE'
end

'exit'
